//=============================================================================
// VisuStella MZ - Battle Core
// VisuMZ_1_BattleCore.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_1_BattleCore = true;

var VisuMZ = VisuMZ || {};
VisuMZ.BattleCore = VisuMZ.BattleCore || {};
VisuMZ.BattleCore.version = 1.46;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 1] [Version 1.46] [BattleCore]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Battle_Core_VisuStella_MZ
 * @orderAfter VisuMZ_0_CoreEngine
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * The Battle Core plugin revamps the battle engine provided by RPG Maker MZ to
 * become more flexible, streamlined, and support a variety of features. The
 * updated battle engine allows for custom Action Sequences, battle layout
 * styles, and a lot of control over the battle mechanics, too.
 *
 * Features include all (but not limited to) the following:
 * 
 * * Action Sequence Plugin Commands to give you full control over what happens
 *   during the course of a skill or item.
 * * Animated Sideview Battler support for enemies!
 * * Auto Battle options for party-wide and actor-only instances.
 * * Base Troop Events to quickly streamline events for all Troop events.
 * * Battle Command control to let you change which commands appear for actors.
 * * Battle Layout styles to change the way the battle scene looks.
 * * Casting animation support for skills.
 * * Critical Hit control over the success rate formula and damage multipliers.
 * * Custom target scopes added for skills and items.
 * * Damage formula control, including Damage Styles.
 * * Damage caps, both hard caps and soft caps.
 * * Damage traits such Armor Penetration/Reduction to bypass defenses.
 * * Elements & Status Menu Core support for traits.
 * * Multitude of JavaScript notetags and global Plugin Parameters to let you
 *   make a variety of effects across various instances during battle.
 * * Party Command window can be skipped/disabled entirely.
 * * Weather effects now show in battle.
 * * Streamlined Battle Log to remove redundant information and improve the
 *   flow of battle.
 * * Visual HP Gauges can be displayed above the heads of actors and/or enemies
 *   with a possible requirement for enemies to be defeated at least once first
 *   in order for them to show.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Tier 1 ------
 *
 * This plugin is a Tier 1 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 *
 * ============================================================================
 * Major Changes
 * ============================================================================
 *
 * This plugin will overwrite some core parts of the RPG Maker MZ base code in
 * order to ensure the Battle Core plugin will work at full capacity. The
 * following are explanations of what has been changed.
 *
 * ---
 *
 * Action Sequences
 *
 * - Action sequences are now done either entirely by the Battle Log Window or
 * through common events if the <Custom Action Sequence> notetag is used.
 * In RPG Maker MZ by default, Action Sequences would be a mixture of using the
 * Battle Log Window, the Battle Manager, and the Battle Scene, making it hard
 * to fully grab control of the situation.
 *
 * ---
 *
 * Action Speed
 *
 * - Action speeds determine the turn order in the default battle system. The
 * AGI of a battle unit is also taken into consideration. However, the random
 * variance applied to the action speed system makes the turn order extremely
 * chaotic and hard for the player to determine. Thus, the random variance
 * aspect of it has been turned off. This can be reenabled by default through
 * Plugin Parameters => Mechanics Settings => Allow Random Speed?
 *
 * ---
 *
 * Animated Sideview Battler Support For Enemies
 *
 * - Enemies can now use Sideview Actor sprites for themselves! They will
 * behave like actors and can even carry their own set of weapons for physical
 * attacks. These must be set up using notetags. More information can be found
 * in the notetag section.
 *
 * - As the sprites are normally used for actors, some changes have been made
 * to Sprite_Actor to be able to support both actors and enemies. These changes
 * should have minimal impact on other plugins.
 *
 * ---
 *
 * Battle Sprite Updates
 *
 * - A lot of functions in Sprite_Battler, Sprite_Actor, and Sprite_Enemy have
 * been overwritten to make the new Action Sequence system added by this plugin
 * possible. These changes make it possible for the sprites to move anywhere on
 * the screen, jump, float, change visibility, and more.
 *
 * ---
 *
 * Change Battle Back in Battle
 * 
 * - By default, the Change Battle Back event command does not work in battle.
 * Any settings made to it will only reflect in the following battle. Now, if
 * the battle back event command is used during battle, it will reflect upon
 * any new changes immediately.
 *
 * ---
 *
 * Critical Hit - LUK Influence
 *
 * - The LUK Buffs now affect the critical hit rate based off how the formula
 * is now calculated. Each stack of a LUK Buff will double the critical hit
 * rate and compound upon that. That means a x1 LUK Buff stack will raise it by
 * x2, a x2 LUK Buff stack will raise the critical hit rate by x4, a x3 LUK
 * Buff Stack will raise the critical hit rate stack by x8, and so on.
 *
 * - LUK also plays a role in how much damage is dealt with critical hits. The
 * default critical hit multiplier has been reduced from x3 to x2. However, a
 * percentage of LUK will added on (based off the user's CRI rate) onto the
 * finalized critical damage. If the user's CRI rate is 4%, then 4% of the user
 * LUK value will also be added onto the damage.
 *
 * - This change can be altered through Plugin Parameters => Damage Settings =>
 * Critical Hits => JS: Rate Formula and JS: Damage Formula.
 *
 * ---
 * 
 * Damage Popups
 * 
 * - Damage popups are now formatted with + and - to determine healing and
 * damage. MP Damage will also include "MP" at the back. This is to make it
 * clearer what each colored variant of the damage popup means as well as help
 * color blind players read the on-screen data properly.
 * 
 * - Damage popups have also been rewritten to show all changed aspects instead
 * of just one. Previously with RPG Maker MZ, if an action would deal both HP
 * and MP damage, only one of them would show. Now, everything is separated and
 * both HP and MP changes will at a time.
 * 
 * ---
 * 
 * Dual Wielding
 * 
 * - Previously, RPG Maker MZ had "Dual Wielding" attack using both weapon
 * animations at once, with the combined ATK of each weapon. It's confusing to
 * look at and does not portray the nature of "Dual Wielding".
 * 
 * - Dual Wielding, or in the case of users adding in third and fourth weapons,
 * Multi Wielding is now changed. Each weapon is displayed individually, each
 * producing its own attack animation, showing each weapon type, and applying
 * only that weapon's ATK, Traits, and related effects. It is no longer a
 * combined effect to display everything at once like RPG Maker MZ default.
 * 
 * - If an actor has multiple weapon slots but some of them are unequipped,
 * then the action will treat the attack as a single attack. There will be no
 * barehanded attack to add on top of it. This is to match RPG Maker MZ's
 * decision to omit a second animation if the same scenario is applied.
 * 
 * ---
 *
 * Force Action
 *
 * - Previously, Forced Actions would interrupt the middle of an event to
 * perform an action. However, with the addition of more flexible Action
 * Sequences, the pre-existing Force Action system would not be able to exist
 * and would require being remade.
 *
 * - Forced Actions now are instead, added to a separate queue from the action
 * battler list. Whenever an action and/or common event is completed, then if
 * there's a Forced Action battler queued, then the Forced Action battler will
 * have its turn. This is the cleanest method available and avoids the most
 * conflicts possible.
 *
 * - This means if you planned to make cinematic sequences with Forced Actions,
 * you will need to account for the queued Force Actions. However, in the case
 * of battle cinematics, we would highly recommend that you use the newly added
 * Action Sequence Plugin Commands instead as those give you more control than
 * any Force Action ever could.
 *
 * ---
 *
 * Random Scope
 *
 * - The skill and item targeting scopes for Random Enemy, 2 Random Enemies,
 * 3 Random Enemies, 4 Random Enemies will now ignore TGR and utilize true
 * randomness.
 *
 * ---
 *
 * Spriteset_Battle Update
 *
 * - The spriteset now has extra containers to separate battlers (actors and
 * enemies), animations, and damage. This is to make actors and enemy battler
 * sprites more efficient to sort (if enabled), so that animations won't
 * interfere with and cover damage sprites, and to make sure damage sprites are
 * unaffected by screen tints in order to ensure the player will always have a
 * clear read on the information relaying sprites.
 *
 * ---
 * 
 * TPB/ATB Active Battle Actor Shifting
 * 
 * - Pressing cancel on the Actor Command Window no longer switches between
 * actors with a full TPB/ATB gauge before reaching the Party Command Window.
 * This is to accomplish a couple of things: 1) reduce the number of button
 * presses to reach the Party Command Window and 2) to prevent motion resets
 * and disrupting action sequences. If this feature is vital to your battle
 * system, we recommend that you do not use this plugin or any of the Battle
 * Core-required plugins.
 * 
 * ---
 *
 * Weather Displayed in Battle
 *
 * - Previously, weather has not been displayed in battle. This means that any
 * weather effects placed on the map do not transfer over to battle and causes
 * a huge disconnect for players. The Battle Core plugin will add weather
 * effects to match the map's weather conditions. Any changes made to weather
 * through event commands midway through battle will also be reflected.
 *
 * ---
 *
 * ============================================================================
 * Base Troops
 * ============================================================================
 *
 * Base Troops can be found, declared, and modified in the Plugin Parameters =>
 * Mechanics Settings => Base Troop ID's. All of the listed Troop ID's here
 * will have their page events replicated and placed under all other troops
 * found in the database.
 *
 * ---
 *
 * This means that if you have an event that runs on Turn 1 of a Base Troop,
 * then for every troop out there, that same event will also run on Turn 1,
 * as well. This is useful for those who wish to customize their battle system
 * further and to reduce the amount of work needed to copy/paste said event
 * pages into every database troop object manually.
 *
 * ---
 *
 * ============================================================================
 * Damage Styles
 * ============================================================================
 *
 * Damage Styles are a new feature added through the Battle Core plugin. When
 * using certain Battle Styles, you can completely ignore typing in the whole
 * damage formula inside the damage formula input box, and instead, insert
 * either a power amount or a multiplier depending on the Damage Style. The
 * plugin will then automatically calculate damage using that value factoring
 * in ATK, DEF, MAT, MDF values.
 *
 * ---
 *
 * Here is a list of the Damage Styles that come with this plugin by default.
 * You can add in your own and even edit them to your liking.
 * Or just remove them if you want.
 *
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Style          Use Formula As   PH/MA Disparity   Stat Scale   Damage Scale
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Standard       Formula          No                Varies       Varies
 * ArmorScaling   Formula          No                Varies       Varies
 * CT             Multiplier       Yes               Low          Normal
 * D4             Multiplier       No                High         Normal
 * DQ             Multiplier       No                Low          Low
 * FF7            Power            Yes               Low          High
 * FF8            Power            Yes               Medium       Normal
 * FF9            Power            Yes               Low          Normal
 * FF10           Power            Yes               Medium       High
 * MK             Multiplier       No                Medium       Low
 * MOBA           Multiplier       No                Medium       Normal
 * PKMN           Power            No                Low          Normal
 *
 * Use the above chart to figure out which Damage Style best fits your game,
 * if you plan on using them.
 *
 * The 'Standard' style is the same as the 'Manual' formula input, except that
 * it allows for the support of <Armor Penetration> and <Armor Reduction>
 * notetags.
 *
 * The 'Armor Scaling' style allows you to type in the base damage calculation
 * without the need to type in any defending modifiers.
 *
 * NOTE: While these are based off the damage formulas found in other games,
 * not all of them are exact replicas. Many of them are adapted for use in
 * RPG Maker MZ since not all RPG's use the same set of parameters and not all
 * external multipliers function the same way as RPG Maker MZ.
 * 
 * ---
 *
 * Style:
 * - This is what the Damage Style is.
 *
 * Use Formula As:
 * - This is what you insert into the formula box.
 * - Formula: Type in the formula for the action just as you would normally.
 * - Multiplier: Type in the multiplier for the action.
 *     Use float values. This means 250% is typed out as 2.50
 * - Power: Type in the power constant for the action.
 *     Use whole numbers. Type in something like 16 for a power constant.
 * 
 * PH/MA Disparity:
 * - Is there a disparity between how Physical Attacks and Magical Attacks
 *   are calculated?
 * - If yes, then physical attacks and magical attacks will have different
 *   formulas used.
 * - If no, then physical attacks and magical attacks will share similar
 *   formulas for how they're calculated.
 *
 * Stat Scale:
 * - How much should stats scale throughout the game?
 * - Low: Keep them under 100 for the best results.
 * - Medium: Numbers work from low to mid 400's for best results.
 * - High: The numbers really shine once they're higher.
 *
 * Damage Scale:
 * - How much does damage vary depending on small parameter changes?
 * - Low: Very little increase from parameter changes.
 * - Normal: Damage scales close to proportionally with parameter changes.
 * - High: Damage can boost itself drastically with parameter changes.
 *
 * ---
 *
 * To determine what kind of parameters are used for the Damage Styles, they
 * will depend on two things: the action's 'Hit Type' (ie Physical Attack,
 * Magical Attack, and Certain Hit) and the action's 'Damage Type' (ie. Damage,
 * Recovery, or Drain).
 *
 * Certain Hit tends to use whichever value is higher: ATK or MAT, and then
 * ignores the target's defense values. Use Certain Hits for 'True Damage'.
 *
 * Use the chart below to figure out everything else:
 * 
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Hit Type      Damage Type   Attacker Parameter   Defender Parameter
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Physical      Damage        ATK                  DEF
 * Magical       Damage        MAT                  MDF
 * Certain Hit   Damage        Larger (ATK, MAT)    -Ignores-
 * Physical      Recover       DEF                  -Ignores-
 * Magical       Recover       MDF                  -Ignores-
 * Certain Hit   Recover       Larger (ATK, MAT)    -Ignores-
 * Physical      Drain         ATK                  DEF
 * Magical       Drain         MAT                  MDF
 * Certain Hit   Drain         Larger (ATK, MAT)    -Ignores-
 *
 * These can be modified within the Plugin Parameters in the individual
 * Damage Styles themselves.
 *
 * ---
 *
 * Skills and Items can use different Damage Styles from the setting you've
 * selected in the Plugin Parameters. They can be altered to have different
 * Damage Styles through the usage of a notetag:
 *
 * <Damage Style: name>
 *
 * This will use whichever style is found in the Plugin Parameters.
 *
 * If "Manual" is used, then no style will be used and all calculations will be
 * made strictly based off the formula found inside the formula box.
 *
 * ---
 *
 * ============================================================================
 * VisuStella MZ Compatibility
 * ============================================================================
 *
 * While this plugin is compatible with the majority of the VisuStella MZ
 * plugin library, it is not compatible with specific plugins or specific
 * features. This section will highlight the main plugins/features that will
 * not be compatible with this plugin or put focus on how the make certain
 * features compatible.
 *
 * ---
 * 
 * VisuMZ_1_BattleCore
 * 
 * When using Action Sequences, Boost effects for damage, turn extensions,
 * analyze, etc. will not occur for anything other than the Action Sequence:
 * "MECH: Action Effect" in order to maintain controlled effects. However, if
 * you do want to apply bonuses for Boosts, utilize "MECH: Boost Store Data" to
 * store inside a variable how many times Boosts were used. This can be used
 * however which way you want it to as long as it is manageable through events
 * and Common Events.
 * 
 * ---
 *
 * ============================================================================
 * Notetags
 * ============================================================================
 *
 * The following are notetags that have been added through this plugin. These
 * notetags will not work with your game if this plugin is OFF or not present.
 * 
 * === HP Gauge-Related Notetags ===
 * 
 * The following notetags allow you to set whether or not HP Gauges can be
 * displayed by enemies regardless of Plugin Parameter settings.
 * 
 * ---
 *
 * <Show HP Gauge>
 *
 * - Used for: Enemy Notetags
 * - Will always show the HP Gauge for the enemy regardless of the defeat
 *   requirement setting.
 * - This does not bypass the player's Options preferences.
 * - This does not bypass disabling enemy HP Gauges as a whole.
 * 
 * ---
 *
 * <Hide HP Gauge>
 *
 * - Used for: Enemy Notetags
 * - Will always hide the HP Gauge for the enemy regardless of the defeat
 *   requirement setting.
 * - This does not bypass the player's Options preferences.
 * 
 * ---
 * 
 * <Battle UI Offset: +x, +y>
 * <Battle UI Offset: -x, -y>
 * 
 * <Battle UI Offset X: +x>
 * <Battle UI Offset X: -x>
 * 
 * <Battle UI Offset Y: +y>
 * <Battle UI Offset Y: -y>
 * 
 * - Used for: Actor and Enemy Notetags
 * - Adjusts the offset of HP Gauges and State Icons above the heads of actors
 *   and enemies.
 * - Replace 'x' with a number value that offsets the x coordinate.
 * - Negative x values offset left. Positive x values offset right.
 * - Replace 'y' with a number value that offsets the y coordinate.
 * - Negative y values offset up. Positive x values offset down.
 * 
 * ---
 *
 * === Animation-Related Notetags ===
 *
 * The following notetags allow you to set animations to play at certain
 * instances and/or conditions.
 *
 * ---
 *
 * <Slip Animation: x>
 *
 * - Requires VisuMZ_0_CoreEngine!
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - During the phase at which the user regenerates HP, MP, or TP, this
 *   animation will play as long as the user is alive and visible.
 * - Replace 'x' with a number value representing the Animation ID to play.
 *
 * ---
 *
 * <Cast Animation: x>
 *
 * - Used for: Skill Notetags
 * - Plays a battle animation at the start of the skill.
 * - Replace 'x' with a number value representing the Animation ID to play.
 *
 * ---
 *
 * <Attack Animation: x>
 *
 * - Used for: Enemy Notetags
 * - Gives an enemy an attack animation to play for its basic attack.
 * - Replace 'x' with a number value representing the Animation ID to play.
 *
 * ---
 *
 * === Battleback-Related Notetags ===
 *
 * You can apply these notetags to have some control over the battlebacks that
 * appear in different regions of the map for random or touch encounters.
 *
 * ---
 *
 * <Region x Battleback1: filename>
 * <Region x Battleback2: filename>
 * 
 * - Used for: Map Notetags
 * - If the player starts a battle while standing on 'x' region, then the
 *   'filename' battleback will be used.
 * - Replace 'x' with a number representing the region ID you wish to use.
 * - Replace 'filename' with the filename of the graphic to use. Do not insert
 *   any extensions. This means the file 'Castle1.png' will be only inserted
 *   as 'Castle1' without the '.png' at the end.
 * - *NOTE: This will override any specified battleback settings.
 *
 * ---
 *
 * === Battle Command-Related Notetags ===
 *
 * You can use notetags to change how the battle commands of playable
 * characters appear in battle as well as whether or not they can be used.
 *
 * ---
 *
 * <Seal Attack>
 * <Seal Guard>
 * <Seal Item>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Prevents specific battle commands from being able to be used.
 *
 * ---
 *
 * <Battle Commands>
 *  Attack
 *  Skills
 *  SType: x
 *  SType: name
 *  All Skills
 *  Skill: x
 *  Skill: name
 *  Guard
 *  Item
 *  Party
 *  Escape
 *  Auto Battle
 *  Combat Log
 *  Talk
 *  Weapon Swap
 * </Battle Commands>
 *
 * - Used for: Class Notetags
 * - Changes which commands appear in the Actor Command Window in battle.
 *   If this notetag is not used, then the default commands determined in
 *   Plugin Parameters => Actor Command Window => Command List will be used.
 * - Add/remove/modify entries as needed.
 *
 * - Attack 
 *   - Adds the basic attack command.
 * 
 * - Skills
 *   - Displays all the skill types available to the actor.
 * 
 * - SType: x
 * - Stype: name
 *   - Adds in a specific skill type.
 *   - Replace 'x' with the ID of the skill type.
 *   - Replace 'name' with the name of the skill type (without text codes).
 *
 * - All Skills
 *   - Adds all usable battle skills as individual actions.
 * 
 * - Skill: x
 * - Skill: name
 *   - Adds in a specific skill as a usable action.
 *   - Replace 'x' with the ID of the skill.
 *   - Replace 'name' with the name of the skill.
 * 
 * - Guard
 *   - Adds the basic guard command.
 * 
 * - Item
 *   - Adds the basic item command.
 *
 * - Party
 *   - Requires VisuMZ_2_PartySystem.
 *   - Allows this actor to switch out with a different party member.
 * 
 * - Escape
 *   - Adds the escape command.
 * 
 * - Auto Battle
 *   - Adds the auto battle command.
 * 
 * - Combat Log
 *   - Requires VisuMZ_4_CombatLog.
 *   - Opens up the combat log.
 * 
 * - Talk
 *   - Requires VisuMZ_3_BattleCmdTalk!
 *   - Shows talk command if applicable.
 * 
 * - Weapon Swap
 *   - Requires VisuMZ_2_WeaponSwapSystem.
 *   - Swaps the current weapon.
 *
 * Example:
 *
 * <Battle Commands>
 *  Attack
 *  Skill: Heal
 *  Skills
 *  Guard
 *  Item
 *  Escape
 * </Battle Commands>
 *
 * ---
 *
 * <Command Text: x>
 *
 * - Used for: Skill Notetags
 * - When a skill is used in a <Battle Commands> notetag set, you can change
 *   the skill name text that appears to something else.
 * - Replace 'x' with the skill's name you want to shown in the Actor Battle
 *   Command window.
 * - Recommended Usage: Shorten skill names that are otherwise too big to fit
 *   inside of the Actor Battle Command window.
 *
 * ---
 *
 * <Command Icon: x>
 *
 * - Used for: Skill Notetags
 * - When a skill is used in a <Battle Commands> notetag set, you can change
 *   the skill icon that appears to something else.
 * - Replace 'x' with the ID of icon you want shown in the Actor Battle Command
 *   window to represent the skill.
 * 
 * ---
 * 
 * <Command Require Learn>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not by whether the actor has
 *   learned the skill.
 * - Learning the skill is a requirement. Acquiring the skill through traits
 *   does not count as learning the skill.
 * 
 * ---
 * 
 * <Command Require Access>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not by whether the actor has
 *   access to the skill.
 * - Having access to the skill can come through either learning the skill or
 *   temporarily acquiring it through trait objects.
 * 
 * ---
 * 
 * <Command Show Switch: x>
 * 
 * <Command Show All Switches: x,x,x>
 * <Command Show Any Switches: x,x,x>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not through switches.
 * - Replace 'x' with the switch ID to determine the skill's visibility.
 * - If 'All' notetag variant is used, item will be hidden until all
 *   switches are ON. Then, it would be shown.
 * - If 'Any' notetag variant is used, item will be shown if any of the
 *   switches are ON. Otherwise, it would be hidden.
 * - This can be applied to Attack and Guard commands, too.
 * 
 * ---
 * 
 * <Command Hide Switch: x>
 * 
 * <Command Hide All Switches: x,x,x>
 * <Command Hide Any Switches: x,x,x>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not through switches.
 * - Replace 'x' with the switch ID to determine the skill's visibility.
 * - If 'All' notetag variant is used, item will be shown until all
 *   switches are ON. Then, it would be hidden.
 * - If 'Any' notetag variant is used, item will be hidden if any of the
 *   switches are ON. Otherwise, it would be shown.
 * - This can be applied to Attack and Guard commands, too.
 * 
 * ---
 * 
 * <Battle Portrait: filename>
 *
 * - Used for: Actor
 * - This is used with the "Portrait" Battle Layout.
 * - Sets the battle portrait image for the actor to 'filename'.
 * - Replace 'filename' with a picture found within your game project's
 *   img/pictures/ folder. Filenames are case sensitive. Leave out the filename
 *   extension from the notetag.
 * - This will override any menu images used for battle only.
 * 
 * ---
 * 
 * <Battle Portrait Offset: +x, +y>
 * <Battle Portrait Offset: -x, -y>
 * 
 * <Battle Portrait Offset X: +x>
 * <Battle Portrait Offset X: -x>
 * 
 * <Battle Portrait Offset Y: +y>
 * <Battle Portrait Offset Y: -y>
 *
 * - Used for: Actor
 * - This is used with the "Portrait" and "Border" Battle Layouts.
 * - Offsets the X and Y coordinates for the battle portrait.
 * - Replace 'x' with a number value that offsets the x coordinate.
 * - Negative x values offset left. Positive x values offset right.
 * - Replace 'y' with a number value that offsets the y coordinate.
 * - Negative y values offset up. Positive x values offset down.
 * 
 * ---
 * 
 * === JavaScript Notetag: Battle Command-Related ===
 *
 * The following are notetags made for users with JavaScript knowledge to
 * determine if skill-based battle commands are visible or hidden.
 * 
 * ---
 * 
 * <JS Command Visible>
 *  code
 *  code
 *  visible = code;
 * </JS Command Visible>
 * 
 * - Used for: Skill Notetags
 * - The 'visible' variable is the final returned variable to determine the
 *   skill's visibility in the Battle Command Window.
 * - Replace 'code' with JavaScript code to determine the skill's visibility in
 *   the Battle Command Window.
 * - The 'user' variable represents the user who will perform the skill.
 * - The 'skill' variable represents the skill to be used.
 * 
 * ---
 *
 * === Targeting-Related Notetags ===
 *
 * The following notetags are related to the targeting aspect of skills and
 * items and may adjust the scope of how certain skills/items work.
 *
 * ---
 *
 * <Always Hit>
 *
 * <Always Hit Rate: x%>
 *
 * - Used for: Skill, Item Notetags
 * - Causes the action to always hit or to always have a hit rate of exactly
 *   the marked x%.
 * - Replace 'x' with a number value representing the hit success percentage.
 *
 * ---
 *
 * <Repeat Hits: x>
 *
 * - Used for: Skill, Item Notetags
 * - Changes the number of hits the action will produce.
 * - Replace 'x' with a number value representing the number of hits to incur.
 *
 * ---
 *
 * <Target: x Random Any>
 *
 * - Used for: Skill, Item Notetags
 * - Makes the skill pick 'x' random targets when used.
 * - Targets can be both actors and enemies.
 * - Replace 'x' with a number value representing the number of random targets.
 *
 * ---
 *
 * <Target: x Random Enemies>
 *
 * - Used for: Skill, Item Notetags
 * - Makes the skill pick 'x' random targets when used.
 * - Targets are only enemies.
 * - Replace 'x' with a number value representing the number of random targets.
 *
 * ---
 *
 * <Target: x Random Allies>
 *
 * - Used for: Skill, Item Notetags
 * - Makes the skill pick 'x' random targets when used.
 * - Targets are only actors.
 * - Replace 'x' with a number value representing the number of random targets.
 *
 * ---
 *
 * <Target: All Allies But User>
 *
 * - Used for: Skill, Item Notetags
 * - Targets all allies with the exception of the user.
 *
 * ---
 *
 * === JavaScript Notetag: Targeting-Related ===
 *
 * ---
 * 
 * <JS Targets>
 *  code
 *  code
 *  targets = [code];
 * </JS Targets>
 *
 * - Used for: Skill, Item Notetags
 * - The 'targets' variable is an array that is returned to be used as a
 *   container for all the valid action targets.
 * - The 'targets' variable will include the original set of targets determined
 *   by the skill/item's original scale.
 * - If you wish to clear it out, simply do 'targets = []' first.
 * - Replace 'code' with JavaScript code to determine valid targets.
 *
 * ---
 *
 * === Damage-Related Notetags ===
 *
 * ---
 *
 * <Damage Style: name>
 *
 * - Used for: Skill, Item Notetags
 * - Replace 'name' with a Damage Style name to change the way calculations are
 *   made using the damage formula input box.
 * - Names can be found in Plugin Parameters => Damage Settings => Style List
 *
 * ---
 *
 * <Armor Reduction: x>
 * <Armor Reduction: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   reduction properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor reduction properties
 *   when calculating one's own armor.
 * - This applies to physical attacks.
 * - Use the 'x' notetag variant to determine a flat reduction value.
 * - Use the 'x%' notetag variant to determine a percentile reduction value.
 *
 * ---
 *
 * <Armor Penetration: x>
 * <Armor Penetration: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   penetration properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor penetration
 *   properties when calculating a target's armor.
 * - This applies to physical attacks.
 * - Use the 'x' notetag variant to determine a flat penetration value.
 * - Use the 'x%' notetag variant to determine a percentile penetration value.
 *
 * ---
 *
 * <Magic Reduction: x>
 * <Magic Reduction: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   reduction properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor reduction properties
 *   when calculating one's own armor.
 * - This applies to magical attacks.
 * - Use the 'x' notetag variant to determine a flat reduction value.
 * - Use the 'x%' notetag variant to determine a percentile reduction value.
 *
 * ---
 *
 * <Magic Penetration: x>
 * <Magic Penetration: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   penetration properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor penetration
 *   properties when calculating a target's armor.
 * - This applies to magical attacks.
 * - Use the 'x' notetag variant to determine a flat penetration value.
 * - Use the 'x%' notetag variant to determine a percentile penetration value.
 *
 * ---
 *
 * <Bypass Damage Cap>
 * 
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will cause the action to never have
 *   its damage capped.
 * - If used on trait objects, this will cause the affected unit to never have
 *   its damage capped.
 *
 * ---
 *
 * <Damage Cap: x>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will declare the hard damage cap to
 *   be the 'x' value.
 * - If used on trait objects, this will raise the affect unit's hard damage
 *   cap to 'x' value. If another trait object has a higher value, use that
 *   value instead.
 *
 * ---
 *
 * <Bypass Soft Damage Cap>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will cause the action to never have
 *   its damage scaled downward to the soft cap.
 * - If used on trait objects, this will cause the affected unit to never have
 *   its damage scaled downward to the soft cap.
 *
 * ---
 *
 * <Soft Damage Cap: +x%>
 * <Soft Damage Cap: -x%>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will increase/decrease the action's
 *   soft cap by x% where 'x' is a percentage value representing the increment
 *   changed by the hard cap value.
 * - If used on trait objects, this will raise the affect unit's soft damage
 *   limit by x% where 'x' is a percentage value representing the increment
 *   changed by the hard cap value.
 *
 * ---
 *
 * <Unblockable>
 *
 * - Used for: Skill, Item Notetags
 * - Using "Guard" against this skill will not reduce any damage.
 *
 * ---
 *
 * === Critical-Related Notetags ===
 *
 * The following notetags affect skill and item critical hit rates and the
 * critical damage multiplier.
 *
 * ---
 *
 * <Always Critical>
 *
 * - Used for: Skill, Item Notetags
 * - This skill/item will always land a critical hit regardless of the
 *   user's CRI parameter value.
 *
 * ---
 *
 * <Set Critical Rate: x%>
 *
 * - Used for: Skill, Item Notetags
 * - This skill/item will always have a x% change to land a critical hit
 *   regardless of user's CRI parameter value.
 * - Replace 'x' with a percerntage value representing the success rate.
 *
 * ---
 *
 * <Modify Critical Rate: x%>
 * <Modify Critical Rate: +x%>
 * <Modify Critical Rate: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - Modifies the user's CRI parameter calculation for this skill/item.
 * - The 'x%' notetag variant will multiply the user's CRI parameter value
 *   for this skill/item.
 * - The '+x%' and '-x%' notetag variants will incremenetally increase/decrease
 *   the user's CRI parameter value for this skill/item.
 *
 * ---
 *
 * <Modify Critical Multiplier: x%>
 * <Modify Critical Multiplier: +x%>
 * <Modify Critical Multiplier: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - These notetags determine the damage multiplier when a critical hit lands.
 * - The 'x%' notetag variant multiply the multiplier to that exact percentage.
 * - The '+x%' and '-x%' notetag variants will change the multiplier with an
 *   incremenetal rate for this skill/item.
 *
 * ---
 *
 * <Modify Critical Bonus Damage: x%>
 * <Modify Critical Bonus Damage: +x%>
 * <Modify Critical Bonus Damage: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - These notetags determine the bonus damage added when a critical hit lands.
 * - The 'x%' notetag variant multiply the damage to that exact percentage.
 * - The '+x%' and '-x%' notetag variants will change the bonus damage with an
 *   incremenetal rate for this skill/item.
 *
 * ---
 *
 * === JavaScript Notetags: Critical-Related ===
 *
 * The following are notetags made for users with JavaScript knowledge to
 * determine how critical hit-related aspects are calculated.
 *
 * ---
 *
 * <JS Critical Rate>
 *  code
 *  code
 *  rate = code;
 * </JS Critical Rate>
 *
 * - Used for: Skill, Item Notetags
 * - The 'rate' variable is the final returned amount to determine the
 *   critical hit success rate.
 * - Replace 'code' with JavaScript code to determine the final 'rate' to be
 *   returned as the critical hit success rate.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Critical Damage>
 *  code
 *  code
 *  multiplier = code;
 *  bonusDamage = code;
 * </JS Critical Damage>
 *
 * - Used for: Skill, Item Notetags
 * - The 'multiplier' variable is returned later and used as the damage
 *   multiplier used to amplify the critical damage amount.
 * - The 'bonusDamage' variable is returned later and used as extra added
 *   damage for the critical damage amount.
 * - Replace 'code' with JavaScript code to determine how the 'multiplier' and
 *   'bonusDamage' variables are calculated.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * === Action Sequence-Related Notetags ===
 *
 * Action Sequences allow you full control over how a skill and/or item plays
 * through its course. These notetags give you control over various aspects of
 * those Action Sequences. More information is found in the Action Sequences
 * help section.
 *
 * ---
 *
 * <Custom Action Sequence>
 *
 * - Used for: Skill, Item Notetags
 * - Removes all automated Action Sequence parts from the skill.
 * - Everything Action Sequence-related will be done by Common Events.
 * - Insert Common Event(s) into the skill/item's effects list to make use of
 *   the Custom Action Sequences.
 * - This will prevent common events from loading in the Item Scene and Skill
 *   Scene when used outside of battle.
 *
 * ---
 * 
 * <Auto Action Sequence>
 * 
 * - Used for: Skill, Item Notetags
 * - If the Action Sequence Plugin Parameter "Auto Notetag" is enabled, this
 *   plugin will prevent custom action sequences from happening for the skill
 *   or item, and instead, use an Automatic Action Sequence instead.
 * - Ignore this if you have "Auto Notetag" disabled or set to false.
 * 
 * ---
 * 
 * <Common Event: name>
 *
 * - Used for: Skill, Item Notetags
 * - Battle only: calls forth a Common Event of a matching name.
 * - Replace 'name' with the name of a Common Event to call from when this
 *   skill/item is used in battle.
 *   - Remove any \I[x] in the name.
 * - Insert multiple notetags to call multiple Common Events in succession.
 * - This will occur after any Common Event Trait Effects for the skill/item's
 *   database entry.
 * - This is primarily used for users who are reorganizing around their Common
 *   Events and would still like to have their skills/items perform the correct
 *   Action Sequences in case the ID's are different.
 * 
 * ---
 *
 * <Display Icon: x>
 * <Display Text: string>
 *
 * - Used for: Skill, Item Notetags
 * - When displaying the skill/item name in the Action Sequence, determine the
 *   icon and/or text displayed.
 * - Replace 'x' with a number value representing the icon ID to be displayed.
 * - Replace 'string' with a text value representing the displayed name.
 *
 * ---
 * 
 * <Common Event Key: name>
 * <Common Event Keys: name, name, name>
 * 
 * <Common Event Keys>
 *  key
 *  key
 *  key
 * </Common Event Keys>
 * 
 * - Used for: Skill, Item Notetags
 * - Will generate Common Events for the skill/item with a corresponding key.
 * - Replace 'name' with the name of the Common Event's key that you want to
 *   reference. That key will be converted into a Common Event effect for the
 *   skill/item and be treated as an action sequence.
 *   - The notetag variants that use multiple keys will have the keys added in
 *     the order they are listed.
 *   - If keys do not reference any Common Events, no Common Events will be
 *     added for that key.
 * - To mark a Common Event with a key, insert inside a Common Event's name the
 *   [ and ] brackets around the text that will be used as the Common Event's
 *   key text.
 *   - For example, if Common Event's name is "Penta Slash [PENTA]", then the
 *     key used is "PENTA" without the quotes.
 *   - This key could then be referenced by <Common Event Key: PENTA> notetag.
 *   - Do not use commas (,) inside the key text as it will be automatically
 *     removed for the sake of consistency.
 * - This feature is made for make the process of sharing Action Sequences to
 *   become easier without needing to line up Common Event ID's.
 * 
 * ---
 *
 * === Animated Sideview Battler-Related Notetags ===
 *
 * Enemies can use Animated Sideview Actor graphics thanks to this plugin.
 * These notetags give you control over that aspect. Some of these also affect
 * actors in addition to enemies.
 *
 * ---
 *
 * <Sideview Battler: filename>
 *
 * <Sideview Battlers>
 *  filename: weight
 *  filename: weight
 *  filename: weight
 * </Sideview Battlers>
 *
 * - Used for: Enemy Notetags
 * - Replaces the enemy's battler graphic with an animated Sideview Actor
 *   graphic found in the img/sv_actors/ folder.
 * - Replace 'filename' with the filename of the graphic to use. Do not insert
 *   any extensions. This means the file 'Actor1_1.png' will be only inserted
 *   as 'Actor1_1' without the '.png' at the end.
 * - If the multiple notetag vaiant is used, then a random filename is selected
 *   from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'filename'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'filename' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Sideview Battlers>
 *  Actor1_1: 25
 *  Actor1_3: 10
 *  Actor1_5
 *  Actor1_7
 * </Sideview Battlers>
 *
 * ---
 *
 * <Sideview Anchor: x, y>
 *
 * - Used for: Actor, Enemy Notetags
 * - Sets the sprite anchor positions for the sideview sprite.
 * - Replace 'x' and 'y' with numbers depicting where the anchors should be for
 *   the sideview sprite.
 * - By default, the x and y anchors are 0.5 and 1.0.
 *
 * ---
 * 
 * <Sideview Home Offset: +x, +y>
 * <Sideview Home Offset: -x, -y>
 * 
 * - Used for: Actor, Class, Weapon, Armor, State Notetags
 * - Offsets the sideview actor sprite's home position by +/-x, +/-y.
 * - Replace 'x' and 'y' with numbers depicting how much to offset each of the
 *   coordinates by. For '0' values, use +0 or -0.
 * - This notetag will not work if you remove it from the JavaScript code in
 *   Plugin Parameters > Actor > JS:  Home Position
 * 
 * ---
 * 
 * <Sideview Weapon Offset: +x, +y>
 * <Sideview Weapon Offset: -x, -y>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy State Notetags
 * - Offsets the sideview weapon sprite's position by +/-x, +/-y.
 * - Replace 'x' and 'y' with numbers depicting how much to offset each of the
 *   coordinates by. For '0' values, use +0 or -0.
 * 
 * ---
 *
 * <Sideview Show Shadow>
 * <Sideview Hide Shadow>
 *
 * - Used for: Actor, Enemy Notetags
 * - Sets it so the sideview battler's shadow will be visible or hidden.
 *
 * ---
 * 
 * <Sideview Shadow Scale: x%>
 * <Sideview Shadow Scale: x.y>
 * 
 * - Used for: Actor, Enemy Notetags
 * - Adjusts the scaling size of the sideview battler's shadow.
 * - This affects both the X and Y scale.
 * 
 * ---
 * 
 * <Sideview Shadow Scale X: x%>
 * <Sideview Shadow Scale X: x.y>
 * 
 * <Sideview Shadow Scale Y: x%>
 * <Sideview Shadow Scale Y: x.y>
 * 
 * - Used for: Actor, Enemy Notetags
 * - Adjusts the scaling size of the sideview battler's shadow.
 * - These affect their respective X and Y scales separately.
 * 
 * ---
 *
 * <Sideview Collapse>
 * <Sideview No Collapse>
 *
 * - Used for: Enemy Notetags
 * - Either shows the collapse graphic or does not show the collapse graphic.
 * - Collapse graphic means the enemy will 'fade away' once it's defeated.
 * - No collapse graphic means the enemy's corpse will remain on the screen.
 *
 * ---
 *
 * <Sideview Idle Motion: name>
 *
 * <Sideview Idle Motions>
 *  name: weight
 *  name: weight
 *  name: weight
 * </Sideview Idle Motions>
 *
 * - Used for: Enemy Notetags
 * - Changes the default idle motion for the enemy.
 * - Replace 'name' with any of the following motion names:
 *   - 'walk', 'wait', 'chant', 'guard', 'damage', 'evade', 'thrust', 'swing',
 *     'missile', 'skill', 'spell', 'item', 'escape', 'victory', 'dying',
 *     'abnormal', 'sleep', 'dead'
 * - If the multiple notetag vaiant is used, then a random motion name is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'name'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'name' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Sideview Idle Motions>
 *  walk: 25
 *  wait: 50
 *  guard
 *  victory
 *  abnormal
 * </Sideview Idle Motions>
 *
 * ---
 *
 * <Sideview Size: width, height>
 *
 * - Used for: Enemy Notetags
 * - When using a sideview battler, its width and height will default to the
 *   setting made in Plugin Parameters => Enemy Settings => Size: Width/Height.
 * - This notetag lets you change that value to something else.
 * - Replace 'width' and 'height' with numbers representing how many pixels
 *   wide/tall the sprite will be treated as.
 *
 * ---
 *
 * <Sideview Weapon: weapontype>
 *
 * <Sideview Weapons>
 *  weapontype: weight
 *  weapontype: weight
 *  weapontype: weight
 * </Sideview Weapons>
 *
 * - Used for: Enemy Notetags
 * - Give your sideview enemies weapons to use.
 * - Replace 'weapontype' with the name of the weapon type found under the
 *   Database => Types => Weapon Types list (without text codes).
 * - If the multiple notetag vaiant is used, then a random weapon type is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the weapontype
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'weapontype' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Sideview Weapons>
 *  Dagger: 25
 *  Sword: 25
 *  Axe
 * </Sideview Weapons>
 *
 * ---
 *
 * <traitname Sideview Battler: filename>
 *
 * <traitname Sideview Battlers>
 *  filename: weight
 *  filename: weight
 *  filename: weight
 * </traitname Sideview Battlers>
 *
 * - Used for: Enemy Notetags
 * - Requires VisuMZ_1_ElementStatusCore
 * - Allows certain Trait Sets to cause battlers to have a unique appearance.
 * - Replace 'filename' with the filename of the graphic to use. Do not insert
 *   any extensions. This means the file 'Actor1_1.png' will be only inserted
 *   as 'Actor1_1' without the '.png' at the end.
 * - If the multiple notetag vaiant is used, then a random filename is selected
 *   from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'filename'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'filename' instead.
 * - Add/remove lines as you see fit.
 *
 * Examples:
 *
 * <Male Sideview Battlers>
 *  Actor1_1: 25
 *  Actor1_3: 10
 *  Actor1_5
 *  Actor1_7
 * </Male Sideview Battlers>
 *
 * <Female Sideview Battlers>
 *  Actor1_2: 25
 *  Actor1_4: 10
 *  Actor1_6
 *  Actor1_8
 * </Female Sideview Battlers>
 *
 * ---
 *
 * <traitname Sideview Idle Motion: name>
 *
 * <traitname Sideview Idle Motions>
 *  name: weight
 *  name: weight
 *  name: weight
 * </traitname Sideview Idle Motions>
 *
 * - Used for: Enemy Notetags
 * - Requires VisuMZ_1_ElementStatusCore
 * - Allows certain Trait Sets to cause battlers to have unique idle motions.
 * - Replace 'name' with any of the following motion names:
 *   - 'walk', 'wait', 'chant', 'guard', 'damage', 'evade', 'thrust', 'swing',
 *     'missile', 'skill', 'spell', 'item', 'escape', 'victory', 'dying',
 *     'abnormal', 'sleep', 'dead'
 * - If the multiple notetag vaiant is used, then a random motion name is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'name'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'name' instead.
 * - Add/remove lines as you see fit.
 *
 * Examples:
 *
 * <Jolly Sideview Idle Motions>
 *  wait: 25
 *  victory: 10
 *  walk
 * </Jolly Sideview Idle Motions>
 *
 * <Serious Sideview Idle Motions>
 *  walk: 25
 *  guard: 10
 *  wait
 * </Jolly Sideview Idle Motions>
 *
 * ---
 *
 * <traitname Sideview Weapon: weapontype>
 *
 * <traitname Sideview Weapons>
 *  weapontype: weight
 *  weapontype: weight
 *  weapontype: weight
 * </traitname Sideview Weapons>
 *
 * - Used for: Enemy Notetags
 * - Requires VisuMZ_1_ElementStatusCore
 * - Allows certain Trait Sets to cause battlers to have unique weapons.
 * - Replace 'weapontype' with the name of the weapon type found under the
 *   Database => Types => Weapon Types list (without text codes).
 * - If the multiple notetag vaiant is used, then a random weapon type is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the weapontype
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'weapontype' instead.
 * - Add/remove lines as you see fit.
 *
 * Examples:
 *
 * <Male Sideview Weapons>
 *  Dagger: 25
 *  Sword: 25
 *  Axe
 * </Male Sideview Weapons>
 *
 * <Female Sideview Weapons>
 *  Dagger: 25
 *  Spear: 25
 *  Cane
 * </Female Sideview Weapons>
 *
 * ---
 *
 * === Enemy-Related Notetags ===
 *
 * ---
 *
 * <Battler Sprite Cannot Move>
 *
 * - Used for: Enemy Notetags
 * - Prevents the enemy from being able to move, jump, and/or float due to
 *   Action Sequences. Useful for rooted enemies.
 *
 * ---
 * 
 * <Battler Sprite Grounded>
 *
 * - Used for: Enemy Notetags
 * - Prevents the enemy from being able to jumping and/or floating due to
 *   Action Sequences but still able to move. Useful for rooted enemies.
 * 
 * ---
 *
 * <Swap Enemies>
 *  name: weight
 *  name: weight
 *  name: weight
 * </Swap Enemies>
 *
 * - Used for: Enemy Notetags
 * - Causes this enemy database object to function as a randomizer for any of
 *   the listed enemies inside the notetag. When the enemy is loaded into the
 *   battle scene, the enemy is immediately replaced with one of the enemies
 *   listed. The randomization is based off the 'weight' given to each of the
 *   enemy 'names'.
 * - Replace 'name' with the database enemy of the enemy you wish to replace
 *   the enemy with.
 * - Replace 'weight' with a number value representing how often the 'name'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'name' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Swap Enemies>
 *  Bat: 50
 *  Slime: 25
 *  Orc
 *  Minotaur
 * </Swap Enemies>
 *
 * ---
 *
 * === JavaScript Notetags: Mechanics-Related ===
 *
 * These JavaScript notetags allow you to run code at specific instances during
 * battle provided that the unit has that code associated with them in a trait
 * object (actor, class, weapon, armor, enemy, or state). How you use these is
 * entirely up to you and will depend on your ability to understand the code
 * used and driven for each case.
 *
 * ---
 *
 * <JS Pre-Start Battle>
 *  code
 *  code
 *  code
 * </JS Pre-Start Battle>
 *
 * <JS Post-Start Battle>
 *  code
 *  code
 *  code
 * </JS Post-Start Battle>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of battle aimed at the function:
 *   BattleManager.startBattle()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Start Turn>
 *  code
 *  code
 *  code
 * </JS Pre-Start Turn>
 *
 * <JS Post-Start Turn>
 *  code
 *  code
 *  code
 * </JS Post-Start Turn>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of a turn aimed at the function:
 *   BattleManager.startTurn()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Start Action>
 *  code
 *  code
 *  code
 * </JS Pre-Start Action>
 *
 * <JS Post-Start Action>
 *  code
 *  code
 *  code
 * </JS Post-Start Action>
 * 
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of an action aimed at the function:
 *   BattleManager.startAction()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Apply>
 *  code
 *  code
 *  code
 * </JS Pre-Apply>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code at the start of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Pre' runs before the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Pre-Apply as User>
 *  code
 *  code
 *  code
 * </JS Pre-Apply as User>
 *
 * <JS Pre-Apply as Target>
 *  code
 *  code
 *  code
 * </JS Pre-Apply as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Pre' runs before the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Pre-Damage>
 *  code
 *  code
 *  code
 * </JS Pre-Damage>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code before damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Pre' runs before the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Pre-Damage as User>
 *  code
 *  code
 *  code
 * </JS Pre-Damage as User>
 *
 * <JS Pre-Damage as Target>
 *  code
 *  code
 *  code
 * </JS Pre-Damage as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code before damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Pre' runs before the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Post-Damage>
 *  code
 *  code
 *  code
 * </JS Post-Damage>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code after damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Post' runs after the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Post-Damage as User>
 *  code
 *  code
 *  code
 * </JS Post-Damage as User>
 *
 * <JS Post-Damage as Target>
 *  code
 *  code
 *  code
 * </JS Post-Damage as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code after damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Post' runs after the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Post-Apply>
 *  code
 *  code
 *  code
 * </JS Post-Apply>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code at the end of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Post' runs after the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Post-Apply as User>
 *  code
 *  code
 *  code
 * </JS Post-Apply as User>
 *
 * <JS Post-Apply as Target>
 *  code
 *  code
 *  code
 * </JS Post-Apply as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the end of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Post' runs after the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 *
 * ---
 *
 * <JS Pre-End Action>
 *  code
 *  code
 *  code
 * </JS Pre-End Action>
 *
 * <JS Post-End Action>
 *  code
 *  code
 *  code
 * </JS Post-End Action>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the end of an action aimed at the function:
 *   BattleManager.endAction()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-End Turn>
 *  code
 *  code
 *  code
 * </JS Pre-End Turn>
 *
 * <JS Post-End Turn>
 *  code
 *  code
 *  code
 * </JS Post-End Turn>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the end of a turn aimed at the function:
 *   Game_Battler.prototype.onTurnEnd()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Regenerate>
 *  code
 *  code
 *  code
 * </JS Pre-Regenerate>
 *
 * <JS Post-Regenerate>
 *  code
 *  code
 *  code
 * </JS Post-Regenerate>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when a unit regenerates HP/MP aimed at the function:
 *   Game_Battler.prototype.regenerateAll()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Battle Victory>
 *  code
 *  code
 *  code
 * </JS Battle Victory>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when a battle is won aimed at the function:
 *   BattleManager.processVictory()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Escape Success>
 *  code
 *  code
 *  code
 * </JS Escape Success>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when escaping succeeds aimed at the function:
 *   BattleManager.onEscapeSuccess()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Escape Failure>
 *  code
 *  code
 *  code
 * </JS Escape Failure>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when escaping fails aimed at the function:
 *   BattleManager.onEscapeFailure()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Battle Defeat>
 *  code
 *  code
 *  code
 * </JS Battle Defeat>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when a battle is lost aimed at the function:
 *   BattleManager.processDefeat()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-End Battle>
 *  code
 *  code
 *  code
 * </JS Pre-End Battle>
 *
 * <JS Post-End Battle>
 *  code
 *  code
 *  code
 * </JS Post-End Battle>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when the battle is over aimed at the function:
 *   BattleManager.endBattle()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 * 
 * === Battle Layout-Related Notetags ===
 * 
 * These tags will change the battle layout for a troop regardless of how the
 * plugin parameters are set up normally. Insert these tags in either the
 * noteboxes of maps or the names of troops for them to take effect. If both
 * are present for a specific battle, then priority goes to the setting found
 * in the troop name.
 * 
 * ---
 * 
 * <Layout: type>
 * <Battle Layout: type>
 * 
 * - Used for: Map Notetags, Troop Name Tags, and Troop Comment Tags
 * - Changes the battle layout style used for this specific map or battle.
 * - Replace 'type' with 'default', 'list', 'xp', 'portrait', or 'border'.
 * - If using Troop Comment Tags, then as long as the tag appears in a comment
 *   found on any of the Troop's pages (even if they don't run), the tag will
 *   be considered in effect.
 * 
 * ---
 *
 * ============================================================================
 * Action Sequence - Plugin Commands
 * ============================================================================
 *
 * Skills and items, when used in battle, have a pre-determined series of
 * actions to display to the player as a means of representing what's going on
 * with the action. For some game devs, this may not be enough and they would
 * like to get more involved with the actions themselves.
 *
 * Action Sequences, added through this plugin, enable this. To give a skill or
 * item a Custom Action Sequence, a couple of steps must be followed:
 *
 * ---
 *
 * 1. Insert the <Custom Action Sequence> notetag into the skill or item's
 *    notebox (or else this would not work as intended).
 * 2. Give that skill/item a Common Event through the Effects box. The selected
 *    Common Event will contain all the Action Sequence data.
 * 3. Create the Common Event with Action Sequence Plugin Commands and/or event
 *    commands to make the skill/item do what you want it to do.
 *
 * ---
 *
 * The Plugin Commands added through the Battle Core plugin focus entirely on
 * Action Sequences. However, despite the fact that they're made for skills and
 * items, some of these Action Sequence Plugin Commands can still be used for
 * regular Troop events and Common Events.
 *
 * ---
 *
 * === Action Sequence - Action Sets ===
 *
 * Action Sequence Action Sets are groups of commonly used
 * Action Sequence Commands put together for more efficient usage.
 *
 * ---
 *
 * ACSET: Setup Action Set
 * - The generic start to most actions.
 *
 *   Display Action:
 *   Immortal: On:
 *   Battle Step:
 *   Wait For Movement:
 *   Cast Animation:
 *   Wait For Animation:
 *   - Use this part of the action sequence?
 *
 * ---
 *
 * ACSET: All Targets Action Set
 * - Affects all targets simultaneously performing the following.
 *
 *   Dual/Multi Wield?
 *   - Add times struck based on weapon quantity equipped?
 * 
 *   Perform Action:
 *   Wait Count:
 *   Action Animation:
 *   Wait For Animation:
 *   Action Effect:
 *   Immortal: Off:
 *   - Use this part of the action sequence?
 *   - Insert values for the Wait Count(s).
 *
 * ---
 *
 * ACSET: Each Target Action Set
 * - Goes through each target one by one to perform the following.
 *
 *   Dual/Multi Wield?
 *   - Add times struck based on weapon quantity equipped?
 *
 *   Perform Action:
 *   Wait Count:
 *   Action Animation:
 *   Wait Count:
 *   Action Effect:
 *   Immortal: Off:
 *   - Use this part of the action sequence?
 *   - Insert values for the Wait Count(s).
 *
 * ---
 *
 * ACSET: Finish Action
 * - The generic ending to most actions.
 *
 *   Wait For New Line:
 *   Wait For Effects:
 *   Clear Battle Log:
 *   Home Reset:
 *   Wait For Movement:
 *   - Use this part of the action sequence?
 *
 * ---
 * 
 * === Action Sequences - Angle ===
 * 
 * These action sequences allow you to have control over the camera angle.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * ---
 *
 * ANGLE: Change Angle
 * - Changes the camera angle.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Angle:
 *   - Change the camera angle to this many degrees.
 *
 *   Duration:
 *   - Duration in frames to change camera angle.
 *
 *   Angle Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Angle?:
 *   - Wait for angle changes to complete before performing next command?
 *
 * ---
 *
 * ANGLE: Reset Angle
 * - Reset any angle settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Duration:
 *   - Duration in frames to reset camera angle.
 *
 *   Angle Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Angle?:
 *   - Wait for angle changes to complete before performing next command?
 *
 * ---
 *
 * ANGLE: Wait For Angle
 * - Waits for angle changes to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * === Action Sequences - Animations ===
 *
 * These Action Sequences are related to the 'Animations' that can be found in
 * the Animations tab of the Database.
 *
 * ---
 *
 * ANIM: Action Animation
 * - Plays the animation associated with the action.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Attack Animation
 * - Plays the animation associated with the user's weapon.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Attack Animation 2+
 * - Plays the animation associated with the user's other weapons.
 * - Plays nothing if there is no other weapon equipped.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 * 
 *   Slot:
 *   - Which weapon slot to get this data from?
 *   - Main-hand weapon is weapon slot 1.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Cast Animation
 * - Plays the cast animation associated with the action.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Change Battle Portrait
 * - Changes the battle portrait of the actor (if it's an actor).
 * - Can be used outside of battle/action sequences.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *   - Valid units can only be actors.
 *
 *   Filename:
 *   - Select the file to change the actor's portrait to.
 * 
 * ---
 *
 * ANIM: Play at Coordinate
 * - Plays an animation on the screen at a specific x, y coordinate.
 * - Requires VisuMZ_0_CoreEngine!
 * 
 *   Animation ID:
 *   - Plays this animation.
 * 
 *   Coordinates:
 * 
 *     X:
 *     Y:
 *     - X/Y coordinate used for the animation.
 *       You may use JavaScript code.
 * 
 *   Mirror Animation?:
 *   - Mirror the animation?
 * 
 *   Mute Animation?:
 *   - Mute the animation?
 * 
 *   Wait for Completion?:
 *   - Wait the animation to finish before continuing?
 *
 * ---
 *
 * ANIM: Show Animation
 * - Plays the a specific animation on unit(s).
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Animation ID:
 *   - Select which animation to play on unit(s).
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Wait For Animation
 * - Causes the interpreter to wait for any animation(s) to finish.
 *
 * ---
 *
 * === Action Sequences - Battle Log ===
 *
 * These Action Sequences are related to the Battle Log Window, the window
 * found at the top of the battle screen.
 *
 * ---
 *
 * BTLOG: Add Text
 * - Adds a new line of text into the Battle Log.
 *
 *   Text:
 *   - Add this text into the Battle Log.
 *   - Text codes allowed.
 * 
 *   Copy to Combat Log?:
 *   - Copies text to the Combat Log.
 *   - Requires VisuMZ_4_CombatLog
 * 
 *     Combat Log Icon:
 *     - What icon would you like to bind to this entry?
 *     - Requires VisuMZ_4_CombatLog
 *
 * ---
 *
 * BTLOG: Clear Battle Log
 * - Clears all the text in the Battle Log.
 *
 * ---
 *
 * BTLOG: Display Action
 * - plays the current action in the Battle Log.
 *
 * ---
 *
 * BTLOG: Pop Base Line
 * - Removes the Battle Log's last added base line and  all text up to its
 *   former location.
 *
 * ---
 *
 * BTLOG: Push Base Line
 * - Adds a new base line to where the Battle Log currently is at.
 *
 * ---
 *
 * BTLOG: Refresh Battle Log
 * - Refreshes the Battle Log.
 *
 * ---
 *
 * BTLOG: UI Show/Hide
 * - Shows or hides the Battle UI (including the Battle Log).
 *
 *   Show/Hide?:
 *   - Shows/hides the Battle UI.
 *
 * ---
 *
 * BTLOG: Wait For Battle Log
 * - Causes the interpreter to wait for the Battle Log to finish.
 *
 * ---
 *
 * BTLOG: Wait For New Line
 * - Causes the interpreter to wait for a new line in the Battle Log.
 *
 * ---
 *
 * === Action Sequences - Camera ===
 *
 * These Action Sequences are battle camera-related.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * CAMERA: Clamp ON/OFF
 * - Turns battle camera clamping on/off.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Setting:
 *   - Turns camera clamping on/off.
 *
 * ---
 *
 * CAMERA: Focus Point
 * - Focus the battle camera on a certain point in the screen.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   X Coordinate:
 *   - Insert the point to focus the camera on.
 *   - You may use JavaScript code.
 *
 *   Y Coordinate:
 *   - Insert the point to focus the camera on.
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for camera focus change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Focus Target(s)
 * - Focus the battle camera on certain battler target(s).
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Targets:
 *   - Select unit(s) to focus the battle camera on.
 *
 *   Duration:
 *   - Duration in frames for camera focus change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Offset
 * - Offset the battle camera from the focus target.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Offset X:
 *   - How much to offset the camera X by.
 *   - Negative: left. Positive: right.
 *
 *   Offset Y:
 *   - How much to offset the camera Y by.
 *   - Negative: up. Positive: down.
 *
 *   Duration:
 *   - Duration in frames for offset change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Reset
 * - Reset the battle camera settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Reset Focus?:
 *   - Reset the focus point?
 *
 *   Reset Offset?:
 *   - Reset the camera offset?
 *
 *   Duration:
 *   - Duration in frames for reset change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Wait For Camera
 * - Waits for camera changes to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * === Action Sequences - Dragonbones ===
 *
 * These Action Sequences are Dragonbones-related.
 * Requires VisuMZ_2_DragonbonesUnion!
 *
 * ---
 *
 * DB: Dragonbones Animation
 * - Causes the unit(s) to play a Dragonbones motion animation.
 * - Requires VisuMZ_2_DragonbonesUnion!
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion animation.
 *
 *   Motion Animation:
 *   - What is the name of the Dragonbones motion animation you wish to play?
 *
 * ---
 *
 * DB: Dragonbones Time Scale
 * - Causes the unit(s) to change their Dragonbones time scale.
 * - Requires VisuMZ_2_DragonbonesUnion!
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion animation.
 *
 *   Time Scale:
 *   - Change the value of the Dragonbones time scale to this.
 *
 * ---
 *
 * === Action Sequences - Elements ===
 *
 * These Action Sequences can change up the element(s) used for the action's
 * damage calculation midway through an action.
 *
 * They also require the VisuMZ_1_ElementStatusCore plugin to be present in
 * order for them to work.
 *
 * ---
 *
 * ELE: Add Elements
 * - Adds element(s) to be used when calculating damage.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 *   Elements:
 *   - Select which element ID to add onto the action.
 *   - Insert multiple element ID's to add multiple at once.
 *
 * ---
 *
 * ELE: Clear Element Changes
 * - Clears all element changes made through Action Sequences.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 * ---
 *
 * ELE: Force Elements
 * - Forces only specific element(s) when calculating damage.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 *   Elements:
 *   - Select which element ID to force in the action.
 *   - Insert multiple element ID's to force multiple at once.
 *
 * ---
 *
 * ELE: Null Element
 * - Forces no element to be used when calculating damage.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 * ---
 * 
 * === Action Sequences - Horror Effects ===
 * 
 * These Action Sequences are Horror Effects-related.
 * Requires VisuMZ_2_HorrorEffects!
 * 
 * ---
 *
 * HORROR: Clear All Filters
 * - Clear all Horror Effects filters on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove Horror Effects for.
 *
 * ---
 *
 * HORROR: Glitch Create
 * - Creates the glitch effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to create the Horror Effect for.
 *
 *   Glitch Slices:
 *   - Glitch slices to be used with the target.
 *
 *   Glitch Offset:
 *   - Default offset value.
 *
 *   Glitch Animated?:
 *   - Animate the glitch effect?
 *
 *   Glitch Frequency:
 *   - If animated, how frequent to make the glitch effect?
 *   - Lower = often     Higher = rarer
 *
 *   Glitch Strength:
 *   - If animated, how strong is the glitch effect?
 *   - Lower = weaker     Higher = stronger
 *
 * ---
 *
 * HORROR: Glitch Remove
 * - Removes the glitch effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove the Horror Effect for.
 *
 * ---
 *
 * HORROR: Noise Create
 * - Creates the noise effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to create the Horror Effect for.
 *
 *   Noise Rate:
 *   - Noise rate to be used with the target.
 *
 *   Noise Animated:
 *   - Animate the noise for the target?
 *
 * ---
 *
 * HORROR: Noise Remove
 * - Removes the noise effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove the Horror Effect for.
 *
 * ---
 *
 * HORROR: TV Create
 * - Creates the TV effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to create the Horror Effect for.
 *
 *   TV Line Thickness:
 *   - Default TV line thickness
 *   - Lower = thinner     Higher = thicker
 *
 *   TV Corner Size:
 *   - Default TV line corner size
 *   - Lower = smaller     Higher = bigger
 *
 *   TV Animated:
 *   - Animate the TV?
 *
 *   TV Speed:
 *   - Speed used to animate the TV if animated
 *   - Lower = slower     Higher = faster
 *
 * ---
 *
 * HORROR: TV Remove
 * - Removes the TV effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove the Horror Effect for.
 *
 * ---
 * 
 * === Action Sequences - Impact ===
 * 
 * These Action Sequences are related to creating impact.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * ---
 *
 * IMPACT: Color Break
 * - Breaks the colors on the screen before reassembling.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Intensity:
 *   - What is the intensity of the color break effect?
 *
 *   Duration:
 *   - What is the duration of the color break effect?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Motion Blur Screen
 * - Creates a motion blur on the whole screen.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Angle:
 *   - Determine what angle to make the motion blur at.
 *
 *   Intensity Rate:
 *   - This determines intensity rate of the motion blur.
 *   - Use a number between 0 and 1.
 *
 *   Duration:
 *   - How many frames should the motion blur last?
 *   - What do you want to be its duration?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Motion Blur Target(s)
 * - Creates a motion blur on selected target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to create motion blur effects for.
 *
 *   Angle:
 *   - Determine what angle to make the motion blur at.
 *
 *   Intensity Rate:
 *   - This determines intensity rate of the motion blur.
 *   - Use a number between 0 and 1.
 *
 *   Duration:
 *   - How many frames should the motion blur last?
 *   - What do you want to be its duration?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Motion Trail Create
 * - Creates a motion trail effect for the target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to create motion trail effects for.
 *
 *   Delay:
 *   - How many frames to delay by when creating a motion trail?
 *   - The higher the delay, the less motion trails there are.
 *
 *   Duration:
 *   - How many frames should the motion trail last?
 *   - What do you want to be its duration?
 *
 *   Hue:
 *   - What do you want to be the hue for the motion trail?
 *
 *   Starting Opacity:
 *   - What starting opacity value do you want for the motion trail?
 *   - Opacity values decrease over time.
 *
 *   Tone:
 *   - What tone do you want for the motion trail?
 *   - Format: [Red, Green, Blue, Gray]
 *
 * ---
 *
 * IMPACT: Motion Trail Remove
 * - Removes the motion trail effect from the target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to clear motion trail effects for.
 *
 * ---
 *
 * IMPACT: Shockwave at Point
 * - Creates a shockwave at the designated coordinates.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Point: X:
 *   Point: Y:
 *   - What x/y coordinate do you want to create a shockwave at?
 *   - You can use JavaScript code.
 *
 *   Amplitude:
 *   - What is the aplitude of the shockwave effect?
 *
 *   Wavelength:
 *   - What is the wavelength of the shockwave effect?
 *
 *   Duration:
 *   - What is the duration of the shockwave?
 *
 * ---
 *
 * IMPACT: Shockwave from Each Target(s)
 * - Creates a shockwave at each of the target(s) location(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to start a shockwave from.
 *
 *   Target Location:
 *   - Select which part target group to start a shockwave from.
 * 
 *     Offset X:
 *     Offset Y:
 *     - How much to offset the shockwave X/Y point by.
 *
 *   Amplitude:
 *   - What is the aplitude of the shockwave effect?
 *
 *   Wavelength:
 *   - What is the wavelength of the shockwave effect?
 *
 *   Duration:
 *   - What is the duration of the shockwave?
 *
 * ---
 *
 * IMPACT: Shockwave from Target(s) Center
 * - Creates a shockwave from the center of the target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to start a shockwave from.
 *
 *   Target Location:
 *   - Select which part target group to start a shockwave from.
 * 
 *     Offset X:
 *     Offset Y:
 *     - How much to offset the shockwave X/Y point by.
 *
 *   Amplitude:
 *   - What is the aplitude of the shockwave effect?
 *
 *   Wavelength:
 *   - What is the wavelength of the shockwave effect?
 *
 *   Duration:
 *   - What is the duration of the shockwave?
 *
 * ---
 *
 * IMPACT: Zoom Blur at Point
 * - Creates a zoom blur at the designated coordinates.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Point: X:
 *   Point: Y:
 *   - What x/y coordinate do you want to focus the zoom at?
 *   - You can use JavaScript code.
 *
 *   Zoom Strength:
 *   - What is the strength of the zoom effect?
 *   - Use a number between 0 and 1.
 *
 *   Visible Radius:
 *   - How much of a radius should be visible from the center?
 *
 *   Duration:
 *   - What is the duration of the zoom blur?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Zoom Blur at Target(s) Center
 * - Creates a zoom blur at the center of targets.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to start a zoom blur from.
 *
 *   Target Location:
 *   - Select which part target group to start a zoom blur from.
 * 
 *     Offset X:
 *     Offset Y:
 *     - How much to offset the zoom blur X/Y point by.
 *
 *   Zoom Strength:
 *   - What is the strength of the zoom effect?
 *   - Use a number between 0 and 1.
 *
 *   Visible Radius:
 *   - How much of a radius should be visible from the center?
 *
 *   Duration:
 *   - What is the duration of the zoom blur?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * === Action Sequences - Mechanics ===
 *
 * These Action Sequences are related to various mechanics related to the
 * battle system.
 *
 * ---
 *
 * MECH: Action Effect
 * - Causes the unit(s) to take damage/healing from action and incurs any
 *   changes made such as buffs and states.
 *
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 *
 * ---
 *
 * MECH: Add Buff/Debuff
 * - Adds buff(s)/debuff(s) to unit(s). 
 * - Determine which parameters are affected and their durations.
 *
 *   Targets:
 *   - Select unit(s) to receive the buff(s) and/or debuff(s).
 *
 *   Buff Parameters:
 *   - Select which parameter(s) to buff.
 *   - Insert a parameter multiple times to raise its stacks.
 *
 *   Debuff Parameters:
 *   - Select which parameter(s) to debuff.
 *   - Insert a parameter multiple times to raise its stacks.
 *
 *   Turns:
 *   - Number of turns to set the parameter(s) buffs to.
 *   - You may use JavaScript code.
 *
 * ---
 *
 * MECH: Add State
 * - Adds state(s) to unit(s).
 *
 *   Targets:
 *   - Select unit(s) to receive the buff(s).
 *
 *   States:
 *   - Select which state ID(s) to add to unit(s).
 *   - Insert multiple state ID's to add multiple at once.
 *
 * ---
 * 
 * MECH: Analyze Weakness
 * - Reveal elemental weakness(es) from target(s).
 * - Requires VisuMZ_3_WeaknessDisplay!
 * 
 *   Targets:
 *   - Select unit(s) to reveal elemental weaknesses for.
 * 
 *   Reveal:
 *   - How many elemental weaknesses do you wish to reveal?
 *   - You may use JavaScript code.
 * 
 * ---
 *
 * MECH: Armor Penetration
 * - Adds an extra layer of defensive penetration/reduction.
 * - You may use JavaScript code for any of these.
 *
 *   Armor/Magic Penetration:
 *
 *     Rate:
 *     - Penetrates an extra multiplier of armor by this value.
 *
 *     Flat:
 *     - Penetrates a flat amount of armor by this value.
 *
 *   Armor/Magic Reduction:
 *
 *     Rate:
 *     - Reduces an extra multiplier of armor by this value.
 *
 *     Flat:
 *     - Reduces a flat amount of armor by this value.
 *
 * ---
 * 
 * MECH: ATB Gauge
 * - Alters the ATB/TPB Gauges.
 * - Requires VisuMZ_2_BattleSystemATB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the ATB/TPB Gauges for.
 * 
 *   Charging:
 *   
 *     Charge Rate:
 *     - Changes made to the ATB Gauge if it is currently charging.
 * 
 *   Casting:
 *   
 *     Cast Rate:
 *     - Changes made to the ATB Gauge if it is currently casting.
 *   
 *     Interrupt?:
 *     - Interrupt the ATB Gauge if it is currently casting?
 * 
 * ---
 * 
 * MECH: Boost Points Change
 * - Changes Boost Points for target(s).
 * - Requires VisuMZ_3_BoostAction!
 * 
 *   Targets:
 *   - Select unit(s) to alter the Boost Points for.
 * 
 *   Alter Boost Points By:
 *   - Alters the unit(s) Boost Points.
 *   - Positive for gaining points. Negative for losing points.
 * 
 * ---
 * 
 * MECH: Boost Store Data
 * - Stores the number of Boosts used this action inside a variable.
 * - Requires VisuMZ_3_BoostAction!
 * 
 *   Variable ID:
 *   - Which variable do you want to store the data inside?
 * 
 * ---
 * 
 * MECH: Break Shield Change
 * - Changes Break Shields for target(s) if not Break Stunned.
 * - Requires VisuMZ_4_BreakShields!
 * 
 *   Targets:
 *   - Select unit(s) to alter the Break Shields for.
 * 
 *   Alter Break Shields By:
 *   - Alters the unit(s) Break Shields.
 *   - Positive for gaining shields. Negative for losing shields.
 * 
 * ---
 * 
 * MECH: Break Shield Reset
 * - Resets Break Shields for target(s) if not Break Stunned.
 * - Requires VisuMZ_4_BreakShields!
 * 
 *   Targets:
 *   - Select unit(s) to reset the Break Shields for.
 * 
 * ---
 * 
 * MECH: BTB Brave Points
 * - Alters the target(s) Brave Points to an exact value.
 * - Requires VisuMZ_2_BattleSystemBTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the ATB/TPB Gauges for.
 * 
 *   Alter Brave Points By:
 *   - Alters the target(s) Brave Points.
 *   - Positive for gaining BP.
 *   - Negative for losing BP.
 * 
 * ---
 *
 * MECH: Collapse
 * - Causes the unit(s) to perform its collapse animation if the unit(s)
 *   has died.
 *
 *   Targets:
 *   - Select unit(s) to process a death collapse.
 *
 *   Force Death:
 *   - Force death even if the unit has not reached 0 HP?
 *   - This will remove immortality.
 *
 *   Wait For Effect?:
 *   - Wait for the collapse effect to complete before performing next command?
 *
 * ---
 * 
 * MECH: CTB Order
 * - Alters the CTB Turn Order.
 * - Requires VisuMZ_2_BattleSystemCTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the CTB Turn Order for.
 * 
 *   Change Order By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 * ---
 * 
 * MECH: CTB Speed
 * - Alters the CTB Speed.
 * - Requires VisuMZ_2_BattleSystemCTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the CTB Speed for.
 * 
 *   Charge Rate:
 *   - Changes made to the CTB Speed if it is currently charging.
 * 
 *   Cast Rate:
 *   - Changes made to the CTB Speed if it is currently casting.
 * 
 * ---
 * 
 * MECH: Custom Damage Formula
 * - Changes the current action's damage formula to custom.
 * - This will assume the MANUAL damage style.
 * 
 *   Formula:
 *   - Changes the current action's damage formula to custom.
 *   - Use 'default' to revert the damage formula.
 * 
 * ---
 *
 * MECH: Damage Popup
 * - Causes the unit(s) to display the current state of damage received
 *   or healed.
 *
 *   Targets:
 *   - Select unit(s) to prompt a damage popup.
 *
 * ---
 *
 * MECH: Dead Label Jump
 * - If the active battler is dead, jump to a specific label in the
 *   common event.
 *
 *   Jump To Label:
 *   - If the active battler is dead, jump to this specific label in the
 *     common event.
 *
 * ---
 *
 * MECH: Enemy Escape
 * - Causes the enemy unit(s) to escape.
 *
 *   Targets:
 *   - Select unit(s) to escape.
 *
 * ---
 *
 * MECH: ETB Energy Count
 * - Alters the subject team's available Energy Count.
 * - Requires VisuMZ_2_BattleSystemETB!
 *
 *   Energy Count:
 *   - Alters the subject team's available Energy Count.
 *   - Positive for gaining energy. Negative for losing energy.
 *
 * ---
 *
 * MECH: FTB Action Count
 * - Alters the subject team's available Action Count.
 * - Requires VisuMZ_2_BattleSystemFTB!
 *
 *   Action Count:
 *   - Alters the subject team's available Action Count.
 *   - Positive for gaining actions. Negative for losing actions.
 *
 * ---
 *
 * MECH: HP, MP, TP
 * - Alters the HP, MP, and TP values for unit(s).
 * - Positive values for healing. Negative values for damage.
 *
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 *
 *   HP, MP, TP:
 *
 *     Rate:
 *     - Changes made to the parameter based on rate.
 *     - Positive values for healing. Negative values for damage.
 *
 *     Flat:
 *     - Flat changes made to the parameter.
 *     - Positive values for healing. Negative values for damage.
 *
 *   Damage Popup?:
 *   - Display a damage popup after?
 *
 * ---
 *
 * MECH: Immortal
 * - Changes the immortal flag of targets. If immortal flag is removed and a
 *   unit would die, collapse that unit.
 *
 *   Targets:
 *   - Alter the immortal flag of these groups. If immortal flag is removed and
 *     a unit would die, collapse that unit.
 *
 *   Immortal:
 *   - Turn immortal flag for unit(s) on/off?
 *
 * ---
 *
 * MECH: Multipliers
 * - Changes the multipliers for the current action.
 * - You may use JavaScript code for any of these.
 *
 *   Critical Hit%:
 *
 *     Rate:
 *     - Affects chance to land a critical hit by this multiplier.
 *
 *     Flat:
 *     - Affects chance to land a critical hit by this flat bonus.
 *
 *   Critical Damage
 *
 *     Rate:
 *     - Affects critical damage by this multiplier.
 *
 *     Flat:
 *     - Affects critical damage by this flat bonus.
 *
 *   Damage/Healing
 *
 *     Rate:
 *     - Sets the damage/healing multiplier for current action.
 *
 *     Flat:
 *     - Sets the damage/healing bonus for current action.
 *
 *   Hit Rate
 *
 *     Rate:
 *     - Affects chance to connect attack by this multiplier.
 *
 *     Flat:
 *     - Affects chance to connect attack by this flat bonus.
 *
 * ---
 * 
 * MECH: OTB Order
 * - Alters the OTB Turn Order. Best used with single targets.
 * - Requires VisuMZ_2_BattleSystemOTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the OTB Turn Order for.
 * 
 *   Current Turn By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 *   Next Turn By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 *   Follow Turn By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 * ---
 * 
 * MECH: PTB Alter Cost
 * - Alters the action's cost settings.
 * - Requires VisuMZ_2_BattleSystemPTB!
 * 
 *   Override?:
 *   - Overrides any 'permanent' settings for Changeability?
 * 
 *   Alter Changeability:
 *   - Allow the cost type and value to be changeable?
 * 
 *   Alter Cost Type:
 *   - Change the cost type to this scenario.
 *   - Use 'Unchanged' for no changes.
 * 
 *   Alter Cost Value:
 *   - What is the default action cost for this scenario?
 * 
 *   Priority:
 *   - What is this scenario's priority? Scenario outcomes with equal or lower
 *     priorities cannot override types and costs.
 * 
 * ---
 * 
 * MECH: PTB Conversion
 * - Converts full actions into half actions.
 * - Requires VisuMZ_2_BattleSystemPTB!
 * 
 *   Conversion Count:
 *   - Converts full actions into half actions.
 *   - If not enough, consume half actions.
 * 
 * ---
 * 
 * MECH: PTB Full/Half Action(s)
 * - Alters the subject team's available Full/Half Actions.
 * - Requires VisuMZ_2_BattleSystemPTB!
 * 
 *   Full Actions:
 *   - Alters the subject team's available Full Actions.
 *   - Positive for gaining. Negative for losing.
 * 
 *   Half Actions:
 *   - Alters the subject team's available Half Actions.
 *   - Positive for gaining. Negative for losing.
 * 
 * ---
 *
 * MECH: Remove Buff/Debuff
 * - Removes buff(s)/debuff(s) from unit(s). 
 * - Determine which parameters are removed.
 *
 *   Targets:
 *   - Select unit(s) to have the buff(s) and/or debuff(s) removed.
 *
 *   Buff Parameters:
 *   - Select which buffed parameter(s) to remove.
 *
 *   Debuff Parameters:
 *   - Select which debuffed parameter(s) to remove.
 *
 * ---
 *
 * MECH: Remove State
 * - Remove state(s) from unit(s).
 *
 *   Targets:
 *   - Select unit(s) to have states removed from.
 *
 *   States:
 *   - Select which state ID(s) to remove from unit(s).
 *   - Insert multiple state ID's to remove multiple at once.
 *
 * ---
 * 
 * MECH: STB Exploit Effect
 * - Utilize the STB Exploitation mechanics!
 * - Requires VisuMZ_2_BattleSystemSTB!
 * 
 *   Target(s) Exploited?:
 *   - Exploit the below targets?
 * 
 *     Targets:
 *     - Select unit(s) to become exploited.
 * 
 *     Force Exploitation:
 *     - Force the exploited status?
 * 
 *   User Exploiter?:
 *   - Allow the user to become the exploiter?
 * 
 *     Force Exploitation:
 *     - Force the exploiter status?
 * 
 * ---
 * 
 * MECH: STB Extra Action
 * - Adds an extra action for the currently active battler.
 * - Requires VisuMZ_2_BattleSystemSTB!
 * 
 *   Extra Actions:
 *   - How many extra actions should the active battler gain?
 *   - You may use JavaScript code.
 * 
 * ---
 * 
 * MECH: STB Remove Excess Actions
 * - Removes excess actions from the active battler.
 * - Requires VisuMZ_2_BattleSystemSTB!
 * 
 *   Remove Actions:
 *   - How many actions to remove from the active battler?
 *   - You may use JavaScript code.
 * 
 * ---
 * 
 * MECH: Swap Weapon
 * - Causes the unit(s) to swap their weapon for another.
 * - Requires VisuMZ_2_WeaponSwapSystem!
 * 
 *   Targets:
 *   - Select unit(s) to swap weapons for.
 * 
 *   Weapon Type ID:
 *   - Which weapon type to swap to?
 *   - This is NOT the weapon's ID.
 *   - It's the weapon TYPE.
 * 
 * ---
 * 
 * MECH: Text Popup
 * - Causes the unit(s) to display a text popup.
 * 
 *   Targets:
 *   - Select unit(s) to prompt a text popup.
 * 
 *   Text:
 *   - What text do you wish to display?
 * 
 *   Text Color:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 * 
 *   Flash Color:
 *   - Adjust the popup's flash color.
 *   - Format: [red, green, blue, alpha]
 * 
 *   Flash Duration:
 *   - What is the frame duration of the flash effect?
 * 
 * ---
 * 
 * MECH: Variable Popup
 * - Causes the unit(s) to display a popup using the data stored inside
 *   a variable.
 * 
 *   Targets:
 *   - Select unit(s) to prompt a text popup.
 * 
 *   Variable:
 *   - Get data from which variable to display as a popup?
 * 
 *   Digit Grouping:
 *   - Use digit grouping to separate numbers?
 *   - Requires VisuMZ_0_CoreEngine!
 * 
 *   Text Color:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 * 
 *   Flash Color:
 *   - Adjust the popup's flash color.
 *   - Format: [red, green, blue, alpha]
 * 
 *   Flash Duration:
 *   - What is the frame duration of the flash effect?
 * 
 * ---
 *
 * MECH: Wait For Effect
 * - Waits for the effects to complete before performing next command.
 *
 * ---
 *
 * === Action Sequences - Motion ===
 *
 * These Action Sequences allow you the ability to control the motions of
 * sideview sprites.
 *
 * ---
 * 
 * MOTION: Clear Freeze Frame
 * - Clears any freeze frames from the unit(s).
 * 
 *   Targets:
 *   - Select which unit(s) to clear freeze frames for.
 * 
 * ---
 * 
 * MOTION: Freeze Motion Frame
 * - Forces a freeze frame instantly at the selected motion.
 * - Automatically clears with a new motion.
 * 
 *   Targets:
 *   - Select which unit(s) to freeze motions for.
 * 
 *   Motion Type:
 *   - Freeze this motion for the unit(s).
 * 
 *   Frame Index:
 *   - Which frame do you want to freeze the motion on?
 *   - Frame index values start at 0.
 * 
 *   Show Weapon?:
 *   - If using 'attack', 'thrust', 'swing', or 'missile', display the
 *     weapon sprite?
 * 
 * ---
 *
 * MOTION: Motion Type
 * - Causes the unit(s) to play the selected motion.
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion.
 *
 *   Motion Type:
 *   - Play this motion for the unit(s).
 *
 *   Show Weapon?:
 *   - If using 'attack', 'thrust', 'swing', or 'missile', display the
 *     weapon sprite?
 *
 * ---
 *
 * MOTION: Perform Action
 * - Causes the unit(s) to play the proper motion based on the current action.
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion.
 *
 * ---
 *
 * MOTION: Refresh Motion
 * - Cancels any set motions unit(s) has to do and use their most natural
 *   motion at the moment.
 *
 *   Targets:
 *   - Select which unit(s) to refresh their motion state.
 *
 * ---
 *
 * MOTION: Wait By Motion Frame
 * - Creates a wait equal to the number of motion frames passing.
 * - Time is based on Plugin Parameters => Actors => Motion Speed.
 *
 *   Motion Frames to Wait?:
 *   - Each "frame" is equal to the value found in 
 *     Plugin Parameters => Actors => Motion Speed
 *
 * ---
 *
 * === Action Sequences - Movement ===
 *
 * These Action Sequences allow you the ability to control the sprites of
 * actors and enemies in battle.
 *
 * ---
 *
 * MOVE: Battle Step
 * - Causes the unit(s) to move forward past their home position to prepare
 *   for action.
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Face Direction
 * - Causes the unit(s) to face forward or backward.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change direction.
 *
 *   Direction:
 *   - Select which direction to face.
 *
 * ---
 *
 * MOVE: Face Point
 * - Causes the unit(s) to face a point on the screen.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change direction.
 *
 *   Point:
 *   - Select which point to face.
 *     - Home
 *     - Center
 *     - Point X, Y
 *       - Replace 'x' and 'y' with coordinates
 *
 *   Face Away From?:
 *   - Face away from the point instead?
 *
 * ---
 *
 * MOVE: Face Target(s)
 * - Causes the unit(s) to face other targets on the screen.
 * - Sideview-only!
 *
 *   Targets (facing):
 *   - Select which unit(s) to change direction.
 *
 *   Targets (destination):
 *   - Select which unit(s) for the turning unit(s) to face.
 *
 *   Face Away From?:
 *   - Face away from the unit(s) instead?
 *
 * ---
 *
 * MOVE: Float
 * - Causes the unit(s) to float above the ground.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to make float.
 *
 *   Desired Height:
 *   - Vertical distance to float upward.
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total float amount.
 *
 *   Float Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Float?:
 *   - Wait for floating to complete before performing next command?
 *
 * ---
 *
 * MOVE: Home Reset
 * - Causes the unit(s) to move back to their home position(s) and face back to
 *   their original direction(s).
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Jump
 * - Causes the unit(s) to jump into the air.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to make jump.
 *
 *   Desired Height:
 *   - Max jump height to go above the ground
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total jump amount.
 *
 *   Wait For Jump?:
 *   - Wait for jumping to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move Distance
 * - Moves unit(s) by a distance from their current position(s).
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Distance Adjustment:
 *   - Makes adjustments to distance values to determine which direction to
 *     move unit(s).
 *     - Normal - No adjustments made
 *     - Horizontal - Actors adjust left, Enemies adjust right
 *     - Vertical - Actors adjust Up, Enemies adjust down
 *     - Both - Applies both Horizontal and Vertical
 *
 *     Distance: X:
 *     - Horizontal distance to move.
 *     - You may use JavaScript code.
 *
 *     Distance: Y:
 *     - Vertical distance to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move To Point
 * - Moves unit(s) to a designated point on the screen.
 * - Sideview-only! Points based off Graphics.boxWidth/Height.
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Destination Point:
 *   - Select which point to face.
 *     - Home
 *     - Center
 *     - Point X, Y
 *       - Replace 'x' and 'y' with coordinates
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move To Target(s)
 * - Moves unit(s) to another unit(s) on the battle field.
 * - Sideview-only!
 *
 *   Targets (Moving):
 *   - Select which unit(s) to move.
 *
 *   Targets (Destination):
 *   - Select which unit(s) to move to.
 *
 *     Target Location:
 *     - Select which part target group to move to.
 *       - front head
 *       - front center
 *       - front base
 *       - middle head
 *       - middle center
 *       - middle base
 *       - back head
 *       - back center
 *       - back base
 *
 *     Melee Distance:
 *     - The melee distance away from the target location in addition to the
 *       battler's width.
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Opacity
 * - Causes the unit(s) to change opacity.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change opacity.
 *
 *   Desired Opacity:
 *   - Change to this opacity value.
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for opacity change.
 *
 *   Opacity Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Opacity?:
 *   - Wait for opacity changes to complete before performing next command?
 *
 * ---
 *
 * MOVE: Scale/Grow/Shrink
 * - Causes the unit(s) to scale, grow, or shrink?.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change the scale of.
 *
 *   Scale X:
 *   Scale Y:
 *   - What target scale value do you want?
 *   - 1.0 is normal size.
 *
 *   Duration:
 *   - Duration in frames to scale for.
 *
 *   Scale Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Scale?:
 *   - Wait for scaling to complete before performing next command?
 *
 * ---
 *
 * MOVE: Skew/Distort
 * - Causes the unit(s) to skew.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to skew.
 *
 *   Skew X:
 *   Skew Y:
 *   - What variance to skew?
 *   - Use small values for the best results.
 *
 *   Duration:
 *   - Duration in frames to skew for.
 *
 *   Skew Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Skew?:
 *   - Wait for skew to complete before performing next command?
 *
 * ---
 *
 * MOVE: Spin/Rotate
 * - Causes the unit(s) to spin.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to spin.
 *
 *   Angle:
 *   - How many degrees to spin?
 *
 *   Duration:
 *   - Duration in frames to spin for.
 *
 *   Spin Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 * 
 *   Revert Angle on Finish:
 *   - Upon finishing the spin, revert the angle back to 0.
 *
 *   Wait For Spin?:
 *   - Wait for spin to complete before performing next command?
 *
 * ---
 *
 * MOVE: Wait For Float
 * - Waits for floating to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Jump
 * - Waits for jumping to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Movement
 * - Waits for movement to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Opacity
 * - Waits for opacity changes to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Scale
 * - Waits for scaling to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Skew
 * - Waits for skewing to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Spin
 * - Waits for spinning to complete before performing next command.
 *
 * ---
 * 
 * === Action Sequences - Projectiles ===
 * 
 * Create projectiles on the screen and fire them off at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * ---
 *
 * PROJECTILE: Animation
 * - Create an animation projectile and fire it at a target.
 * - Requires VisuMZ_3_ActSeqProjectiles!
 *
 *   Coordinates:
 *
 *     Start Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should start from.
 *         - Target - Start from battler target(s)
 *         - Point - Start from a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) to start the projectile from.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile from.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to start the projectile at.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *     Goal Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should go to.
 *         - Target - Goal is battler target(s)
 *         - Point - Goal is a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) for projectile to go to.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile to.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to send the projectile to.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *   Settings:
 *
 *     Animation ID:
 *     - Determine which animation to use as a projectile.
 *
 *     Duration:
 *     - Duration for the projectile(s) to travel.
 *
 *     Wait For Projectile?:
 *     - Wait for projectile(s) to reach their destination before going onto
 *       the next command?
 *
 *     Extra Settings:
 *     - Add extra settings to the projectile?
 *
 *       Auto Angle?:
 *       - Automatically angle the projectile to tilt the direction
 *         it's moving?
 *
 *       Angle Offset:
 *       - Alter the projectile's tilt by this many degrees.
 *
 *       Arc Peak:
 *       - This is the height of the project's trajectory arc in pixels.
 *
 *       Easing:
 *       - Select which easing type to apply to the projectile's trajectory.
 *
 *       Spin Speed:
 *       - Determine how much angle the projectile spins per frame.
 *       - Does not work well with "Auto Angle".
 *
 * ---
 *
 * PROJECTILE: Icon
 * - Create an icon projectile and fire it at a target.
 * - Requires VisuMZ_3_ActSeqProjectiles!
 *
 *   Coordinates:
 *
 *     Start Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should start from.
 *         - Target - Start from battler target(s)
 *         - Point - Start from a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) to start the projectile from.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile from.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to start the projectile at.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *     Goal Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should go to.
 *         - Target - Goal is battler target(s)
 *         - Point - Goal is a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) for projectile to go to.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile to.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to send the projectile to.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *   Settings:
 *
 *     Icon:
 *     - Determine which icon to use as a projectile.
 *       - You may use JavaScript code.
 *
 *     Duration:
 *     - Duration for the projectile(s) to travel.
 *
 *     Wait For Projectile?:
 *     - Wait for projectile(s) to reach their destination before going onto
 *       the next command?
 *
 *     Extra Settings:
 *     - Add extra settings to the projectile?
 *
 *       Auto Angle?:
 *       - Automatically angle the projectile to tilt the direction
 *         it's moving?
 *
 *       Angle Offset:
 *       - Alter the projectile's tilt by this many degrees.
 *
 *       Arc Peak:
 *       - This is the height of the project's trajectory arc in pixels.
 *
 *       Blend Mode:
 *       - What kind of blend mode do you wish to apply to the projectile?
 *         - Normal
 *         - Additive
 *         - Multiply
 *         - Screen
 *
 *       Easing:
 *       - Select which easing type to apply to the projectile's trajectory.
 *
 *       Hue:
 *       - Adjust the hue of the projectile.
 *       - Insert a number between 0 and 360.
 *
 *       Scale:
 *       - Adjust the size scaling of the projectile.
 *       - Use decimals for exact control.
 *
 *       Spin Speed:
 *       - Determine how much angle the projectile spins per frame.
 *       - Does not work well with "Auto Angle".
 *
 * ---
 *
 * PROJECTILE: Picture
 * - Create a picture projectile and fire it at a target.
 * - Requires VisuMZ_3_ActSeqProjectiles!
 *
 *   Coordinates:
 *
 *     Start Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should start from.
 *         - Target - Start from battler target(s)
 *         - Point - Start from a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) to start the projectile from.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile from.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to start the projectile at.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *     Goal Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should go to.
 *         - Target - Goal is battler target(s)
 *         - Point - Goal is a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) for projectile to go to.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile to.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to send the projectile to.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *   Settings:
 *
 *     Picture Filename:
 *     - Determine which picture to use as a projectile.
 *
 *     Duration:
 *     - Duration for the projectile(s) to travel.
 *
 *     Wait For Projectile?:
 *     - Wait for projectile(s) to reach their destination before going onto
 *       the next command?
 *
 *     Extra Settings:
 *     - Add extra settings to the projectile?
 *
 *       Auto Angle?:
 *       - Automatically angle the projectile to tilt the direction
 *         it's moving?
 *
 *       Angle Offset:
 *       - Alter the projectile's tilt by this many degrees.
 *
 *       Arc Peak:
 *       - This is the height of the project's trajectory arc in pixels.
 *
 *       Blend Mode:
 *       - What kind of blend mode do you wish to apply to the projectile?
 *         - Normal
 *         - Additive
 *         - Multiply
 *         - Screen
 *
 *       Easing:
 *       - Select which easing type to apply to the projectile's trajectory.
 *
 *       Hue:
 *       - Adjust the hue of the projectile.
 *       - Insert a number between 0 and 360.
 *
 *       Scale:
 *       - Adjust the size scaling of the projectile.
 *       - Use decimals for exact control.
 *
 *       Spin Speed:
 *       - Determine how much angle the projectile spins per frame.
 *       - Does not work well with "Auto Angle".
 *
 * ---
 * 
 * === Action Sequences - Skew ===
 * 
 * These action sequences allow you to have control over the camera skew.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * ---
 *
 * SKEW: Change Skew
 * - Changes the camera skew.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Skew X:
 *   - Change the camera skew X to this value.
 *
 *   Skew Y:
 *   - Change the camera skew Y to this value.
 *
 *   Duration:
 *   - Duration in frames to change camera skew.
 *
 *   Skew Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Skew?:
 *   - Wait for skew changes to complete before performing next command?
 *
 * ---
 *
 * SKEW: Reset Skew
 * - Reset any skew settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Duration:
 *   - Duration in frames to reset camera skew.
 *
 *   Skew Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Skew?:
 *   - Wait for skew changes to complete before performing next command?
 *
 * ---
 *
 * SKEW: Wait For Skew
 * - Waits for skew changes to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * === Action Sequences - Target ===
 *
 * If using a manual target by target Action Sequence, these commands will give
 * you full control over its usage.
 *
 * ---
 *
 * TARGET: Current Index
 * - Sets the current index to this value.
 * - Then decide to jump to a label (optional).
 *
 *   Set Index To:
 *   - Sets current targeting index to this value.
 *   - 0 is the starting index of a target group.
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * TARGET: Next Target
 * - Moves index forward by 1 to select a new current target.
 * - Then decide to jump to a label (optional).
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * TARGET: Previous Target
 * - Moves index backward by 1 to select a new current target.
 * - Then decide to jump to a label (optional).
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * TARGET: Random Target
 * - Sets index randomly to determine new currernt target.
 * - Then decide to jump to a label (optional).
 *
 *   Force Random?:
 *   - Index cannot be its previous index amount after random.
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * === Action Sequences - Weapon ===
 *
 * Allows for finer control over Dual/Multi Wielding actors.
 * Only works for Actors.
 *
 * ---
 *
 * WEAPON: Clear Weapon Slot
 * - Clears the active weapon slot (making others valid again).
 * - Only works for Actors.
 *
 *   Targets:
 *   - Select unit(s) to clear the active weapon slot for.
 *
 * ---
 *
 * WEAPON: Next Weapon Slot
 * - Goes to next active weapon slot (making others invalid).
 * - If next slot is weaponless, don't label jump.
 *
 *   Targets:
 *   - Select unit(s) to change the next active weapon slot for.
 *
 * ---
 *
 * WEAPON: Set Weapon Slot
 * - Sets the active weapon slot (making others invalid).
 * - Only works for Actors.
 *
 *   Targets:
 *   - Select unit(s) to change the active weapon slot for.
 *
 *   Weapon Slot ID:
 *   - Select weapon slot to make active (making others invalid).
 *   - Use 0 to clear and normalize. You may use JavaScript code.
 *
 * ---
 *
 * === Action Sequences - Zoom ===
 *
 * These Action Sequences are zoom-related.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * ZOOM: Change Scale
 * - Changes the zoom scale.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Scale:
 *   - The zoom scale to change to.
 *
 *   Duration:
 *   - Duration in frames to reset battle zoom.
 *
 *   Zoom Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Zoom?
 *   - Wait for zoom changes to complete before performing next command?
 *
 * ---
 *
 * ZOOM: Reset Zoom
 * - Reset any zoom settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Duration:
 *   - Duration in frames to reset battle zoom.
 *
 *   Zoom Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Zoom?
 *   - Wait for zoom changes to complete before performing next command?
 *
 * ---
 *
 * ZOOM: Wait For Zoom
 * - Waits for zoom changes to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Auto Battle Settings
 * ============================================================================
 *
 * These Plugin Parameter settings allow you to change the aspects added by
 * this plugin that support Auto Battle and the Auto Battle commands.
 *
 * Auto Battle commands can be added to the Party Command Window and/or Actor
 * Command Window. The one used by the Party Command Window will cause the
 * whole party to enter an Auto Battle state until stopped by a button input.
 * The command used by the Actor Command Window, however, will cause the actor
 * to select an action based off the Auto Battle A.I. once for the current turn
 * instead.
 *
 * ---
 *
 * Battle Display
 * 
 *   Message:
 *   - Message that's displayed when Auto Battle is on.
 *     Text codes allowed. %1 - OK button, %2 - Cancel button
 * 
 *   OK Button:
 *   - Text used to represent the OK button.
 *   - If VisuMZ_0_CoreEngine is present, ignore this.
 * 
 *   Cancel Button:
 *   - Text used to represent the Cancel button.
 *   - If VisuMZ_0_CoreEngine is present, ignore this.
 * 
 *   Background Type:
 *   - Select background type for Auto Battle window.
 *     - 0 - Window
 *     - 1 - Dim
 *     - 2 - Transparent
 * 
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for this window.
 *
 * ---
 *
 * Options
 * 
 *   Add Option?:
 *   - Add the Auto Battle options to the Options menu?
 * 
 *   Adjust Window Height:
 *   - Automatically adjust the options window height?
 * 
 *   Startup Name:
 *   - Command name of the option.
 * 
 *   Style Name:
 *   - Command name of the option.
 * 
 *   OFF:
 *   - Text displayed when Auto Battle Style is OFF.
 * 
 *   ON:
 *   - Text displayed when Auto Battle Style is ON.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Damage Settings
 * ============================================================================
 *
 * These Plugin Parameters add a variety of things to how damage is handled in
 * battle. These range from hard damage caps to soft damage caps to how damage
 * popups appear, how the formulas for various aspects are handled and more.
 *
 * Damage Styles are also a feature added through this plugin. More information
 * can be found in the help section above labeled 'Damage Styles'.
 *
 * ---
 *
 * Damage Styles
 * 
 *   Default Style:
 *   - Which Damage Style do you want to set as default?
 *   - Use 'Manual' to not use any styles at all.
 *     - The 'Manual' style will not support <Armor Penetration> notetags.
 *     - The 'Manual' style will not support <Armor Reduction> notetags.
 * 
 *   Style List:
 *   - A list of the damage styles available.
 *   - These are used to calculate base damage.
 * 
 *     Name:
 *     - Name of this Damage Style.
 *     -Used for notetags and such.
 * 
 *     JS: Formula:
 *     - The base formula for this Damage Style.
 * 
 *     Items & Equips Core:
 * 
 *       HP Damage:
 *       MP Damage:
 *       HP Recovery:
 *       MP Recovery:
 *       HP Drain:
 *       MP Drain:
 *       - Vocabulary used for this data entry.
 * 
 *       JS: Damage Display:
 *       - Code used the data displayed for this category.
 *
 * ---
 *
 * Damage Cap
 * 
 *   Enable Damage Cap?:
 *   - Put a maximum hard damage cap on how far damage can go?
 *   - This can be broken through the usage of notetags.
 * 
 *   Default Hard Cap:
 *   - The default hard damage cap used before applying damage.
 * 
 *   Enable Soft Cap?:
 *   - Soft caps ease in the damage values leading up to the  hard damage cap.
 *   - Requires hard Damage Cap enabled.
 * 
 *     Base Soft Cap Rate:
 *     - The default soft damage cap used before applying damage.
 * 
 *     Soft Scale Constant:
 *     - The default soft damage cap used before applying damage.
 *
 * ---
 *
 * Popups
 * 
 *   Popup Duration:
 *   - Adjusts how many frames a popup stays visible.
 * 
 *   Newest Popups Bottom:
 *   - Puts the newest popups at the bottom.
 * 
 *   Offset X:
 *   Offset Y:
 *   - Sets how much to offset the sprites by horizontally/vertically.
 * 
 *   Shift X:
 *   Shift Y:
 *   - Sets how much to shift the sprites by horizontally/vertically.
 * 
 *   Shift Y:
 * 
 *   Critical Flash Color:
 *   - Adjust the popup's flash color.
 *   - Format: [red, green, blue, alpha]
 * 
 *   Critical Duration:
 *   - Adjusts how many frames a the flash lasts.
 *
 * ---
 *
 * Formulas
 * 
 *   JS: Overall Formula:
 *   - The overall formula used when calculating damage.
 * 
 *   JS: Variance Formula:
 *   - The formula used when damage variance.
 * 
 *   JS: Guard Formula:
 *   - The formula used when damage is guarded.
 *
 * ---
 *
 * Critical Hits
 * 
 *   JS: Rate Formula:
 *   - The formula used to calculate Critical Hit Rates.
 * 
 *   JS: Damage Formula:
 *   - The formula used to calculate Critical Hit Damage modification.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Mechanics Settings
 * ============================================================================
 *
 * Some of the base settings for the various mechanics found in the battle
 * system can be altered here in these Plugin Parameters. Most of these will
 * involve JavaScript code and require you to have to good understanding of
 * how the RPG Maker MZ code works before tampering with it.
 *
 * ---
 *
 * Action Speed
 * 
 *   Allow Random Speed?:
 *   - Allow speed to be randomized base off the user's AGI?
 * 
 *   JS: Calculate:
 *   - Code used to calculate action speed.
 *
 * ---
 *
 * Base Troop
 * 
 *   Base Troop ID's:
 *   - Select the Troop ID(s) to duplicate page events from for all
 *     other troops.
 *   - More information can be found in the dedicated Help section above.
 *
 * ---
 * 
 * Common Events (on Map)
 * 
 *   Pre-Battle Event:
 *   Post-Battle Event:
 *   Victory Event:
 *   Defeat Event:
 *   Escape Success Event:
 *   Escape Fail Event:
 *   - Queued Common Event to run upon meeting the condition.
 *   - Use to 0 to not run any Common Event at all.
 *   - "Post-Battle Event" will always run regardless.
 *   - If any events are running before the battle, they will continue running
 *     to the end first before the queued Common Events will run.
 *   - These common events only run on the map scene. They're not meant to run
 *     in the battle scene.
 *   - If the "Defeat Event" has a common event attached to it, then random
 *     encounters will be changed to allow defeat without being sent to the
 *     Game Over scene. Instead, the game will send the player to the map scene
 *     where the Defeat Event will run.
 *
 * ---
 *
 * Escape
 * 
 *   JS: Calc Escape Ratio:
 *   - Code used to calculate the escape success ratio.
 * 
 *   JS: Calc Escape Raise:
 *   - Code used to calculate how much the escape success ratio raises upon
 *     each failure.
 * 
 * ---
 * 
 * Switches
 * 
 *   Switch: Critical:
 *   - Turns switch ON if the action performs a critical hit.
 *   - Switch reverts to OFF whenever an action starts.
 *   - If multiple targets/hits are struck, as long as one hit lands a critical
 *     hit, then the switch will remain ON for the rest of the action.
 * 
 *   Switch: Miss/Evade:
 *   - Turns switch ON if the action misses/is evaded.
 *   - Switch reverts to OFF whenever an action starts.
 *   - If multiple targets/hits are struck, as long as one hit fails to land,
 *     then the switch will remain ON for the rest of the action.
 * 
 * ---
 * 
 * Variables
 * 
 *   Variable: Damage:
 *   - Variable records target damage during action.
 *   - Variable reverts to 0 whenever an action starts.
 *   - If multiple targets/hits are struck, the variable will record the total
 *     amount of damage done for the remainder of the action (unless manually
 *     reseting to 0 during an Action Sequence).
 * 
 *   Variable: Healing:
 *   - Variable records target healing during action.
 *   - Variable reverts to 0 whenever an action starts.
 *   - If multiple targets/hits are struck, the variable will record the total
 *     amount of healing done for the remainder of the action (unless manually
 *     reseting to 0 during an Action Sequence).
 * 
 * ---
 *
 * JS: Battle-Related
 * 
 *   JS: Pre-Start Battle:
 *   - Target function: BattleManager.startBattle()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Start Battle:
 *   - Target function: BattleManager.startBattle()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Battle Victory:
 *   - Target function: BattleManager.processVictory()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Escape Success:
 *   - Target function: BattleManager.onEscapeSuccess()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Escape Failure:
 *   - Target function: BattleManager.onEscapeFailure()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Battle Defeat:
 *   - Target function: BattleManager.processDefeat()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Pre-End Battle:
 *   - Target function: BattleManager.endBattle()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-End Battle:
 *   - Target function: BattleManager.endBattle()
 *   - JavaScript code occurs after function is run.
 *
 * ---
 *
 * JS: Turn-Related
 * 
 *   JS: Pre-Start Turn:
 *   - Target function: BattleManager.startTurn()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Start Turn:
 *   - Target function: BattleManager.startTurn()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-End Turn:
 *   - Target function: Game_Battler.prototype.onTurnEnd()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-End Turn:
 *   - Target function: Game_Battler.prototype.onTurnEnd()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-Regenerate:
 *   - Target function: Game_Battler.prototype.regenerateAll()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Regenerate:
 *   - Target function: Game_Battler.prototype.regenerateAll()
 *   - JavaScript code occurs after function is run.
 *
 * ---
 *
 * JS: Action-Related
 * 
 *   JS: Pre-Start Action:
 *   - Target function: BattleManager.startAction()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Start Action:
 *   - Target function: BattleManager.startAction()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-Apply:
 *   - Target function: Game_Action.prototype.apply()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Pre-Damage:
 *   - Target function: Game_Action.prototype.executeDamage()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Damage:
 *   - Target function: Game_Action.prototype.executeDamage()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Post-Apply:
 *   - Target function: Game_Action.prototype.apply()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-End Action:
 *   - Target function: BattleManager.endAction()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-End Action:
 *   - DescriTarget function: BattleManager.endAction()
 *   - JavaScript code occurs after function is run.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Battle Layout Settings
 * ============================================================================
 *
 * The Battle Layout Settings Plugin Parameter gives you control over the look,
 * style, and appearance of certain UI elements. These range from the way the
 * Battle Status Window presents its information to the way certain windows
 * like the Party Command Window and Actor Command Window appear.
 *
 * ---
 *
 * Battle Layout Style
 * - The style used for the battle layout.
 * 
 *   Default:
 *   - Shows actor faces in Battle Status.
 * 
 *   List:
 *   - Lists actors in Battle Status.
 * 
 *   XP:
 *   - Shows actor battlers in a stretched Battle Status.
 * 
 *   Portrait:
 *   - Shows portraits in a stretched Battle Status.
 * 
 *   Border:
 *   - Displays windows around the screen border.
 *
 * ---
 *
 * List Style
 * 
 *   Show Faces:
 *   - Shows faces in List Style?
 * 
 *   Command Window Width:
 *   - Determine the window width for the Party and Actor Command Windows.
 *   - Affects Default and List Battle Layout styles.
 *
 * ---
 *
 * XP Style
 * 
 *   Command Lines:
 *   - Number of action lines in the Actor Command Window for the XP Style.
 * 
 *   Sprite Height:
 *   - Default sprite height used when if the sprite's height has not been
 *     determined yet.
 * 
 *   Sprite Base Location:
 *   - Determine where the sprite is located on the Battle Status Window.
 *     - Above Name - Sprite is located above the name.
 *     - Bottom - Sprite is located at the bottom of the window.
 *     - Centered - Sprite is centered in the window.
 *     - Top - Sprite is located at the top of the window.
 *
 * ---
 *
 * Portrait Style
 * 
 *   Show Portraits?:
 *   - Requires VisuMZ_1_MainMenuCore.
 *   - Shows the actor's portrait instead of a face.
 * 
 *   Portrait Scaling:
 *   - If portraits are used, scale them by this much.
 *
 * ---
 *
 * Border Style
 * 
 *   Columns:
 *   - The total number of columns for Skill & Item Windows in the battle scene
 * 
 *   Show Portraits?:
 *   - Requires VisuMZ_1_MainMenuCore.
 *   - Shows the actor's portrait at the edge of the screen.
 * 
 *   Portrait Scaling:
 *   - If portraits are used, scale them by this much.
 *
 * ---
 *
 * Skill & Item Windows
 * 
 *   Middle Layout:
 *   - Shows the Skill & Item Windows in mid-screen?
 * 
 *   Columns:
 *   - The total number of columns for Skill & Item Windows in the battle scene
 *
 * ---
 * 
 * Status Window Elements
 * 
 *   Battler Name:
 *   Gauge 1 (HP):
 *   Gauge 2 (MP):
 *   Gauge 3 (TP):
 *   State Icon:
 *   TPB/ATB Gauge:
 * 
 *     Offset: X/Y:
 *     - Offset this Battle Status Window element's X/Y.
 *     - For X: Negative goes left. Positive goes right.
 *     - For Y: Negative goes up. Positive goes down.
 * 
 *   Window Skin:
 * 
 *     Filename:
 *     - Filename used for the Battle Status Window skin.
 *     - Leave this empty to use the default window skin.
 * 
 *     Hide Window Skin?:
 *     - Hide the window skin for the Battle Status Window?
 * 
 *   Selectable Background:
 * 
 *     Hide Selectable BG?:
 *     - Show/Hide the selectable background box for the Battle Status Window?
 * 
 *   Attachments:
 * 
 *     Back Attachment:
 * 
 *       Filename:
 *       - Filename used for an image to attach to the back of the Battle
 *         Status Window. Leave empty for none.
 * 
 *       Offset: X/Y:
 *       - Offset this Battle Status Window element's X/Y.
 *       - For X: Negative goes left. Positive goes right.
 *       - For Y: Negative goes up. Positive goes down.
 * 
 *     Front Attachment:
 * 
 *       Filename:
 *       - Filename used for an image to attach to the front of the Battle
 *         Status Window. Leave empty for none.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Battle Log Settings
 * ============================================================================
 *
 * These Plugin Parameters give you control over how the Battle Log Window, the
 * window shown at the top of the screen in the battle layout, appears, its
 * various properties, and which text will be displayed.
 *
 * The majority of the text has been disabled by default with this plugin to
 * make the flow of battle progress faster.
 *
 * ---
 *
 * General
 * 
 *   Back Color:
 *   - Use #rrggbb for a hex color.
 * 
 *   Max Lines:
 *   - Maximum number of lines to be displayed.
 * 
 *   Message Wait:
 *   - Number of frames for a usual message wait.
 * 
 *   Text Align:
 *   - Text alignment for the Window_BattleLog.
 * 
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for the battle log.
 *
 * ---
 *
 * Start Turn
 * 
 *   Show Start Turn?:
 *   - Display turn changes at the start of the turn?
 * 
 *   Start Turn Message:
 *   - Message displayed at turn start.
 *   - %1 - Turn Count
 * 
 *   Start Turn Wait:
 *   - Number of frames to wait after a turn started.
 *
 * ---
 *
 * Display Action
 * 
 *   Show Centered Action?:
 *   - Display a centered text of the action name?
 * 
 *   Show Skill Message 1?:
 *   - Display the 1st skill message?
 * 
 *   Show Skill Message 2?:
 *   - Display the 2nd skill message?
 * 
 *   Show Item Message?:
 *   - Display the item use message?
 *
 * ---
 *
 * Action Changes
 * 
 *   Show Counter?:
 *   - Display counter text?
 * 
 *   Show Reflect?:
 *   - Display magic reflection text?
 * 
 *   Show Substitute?:
 *   - Display substitute text?
 *
 * ---
 *
 * Action Results
 * 
 *   Show No Effect?:
 *   - Display no effect text?
 * 
 *   Show Critical?:
 *   - Display critical text?
 * 
 *   Show Miss/Evasion?:
 *   - Display miss/evasion text?
 * 
 *   Show HP Damage?:
 *   - Display HP Damage text?
 * 
 *   Show MP Damage?:
 *   - Display MP Damage text?
 * 
 *   Show TP Damage?:
 *   - Display TP Damage text?
 *
 * ---
 *
 * Display States
 * 
 *   Show Added States?:
 *   - Display added states text?
 * 
 *   Show Removed States?:
 *   - Display removed states text?
 * 
 *   Show Current States?:
 *   - Display the currently affected state text?
 * 
 *   Show Added Buffs?:
 *   - Display added buffs text?
 * 
 *   Show Added Debuffs?:
 *   - Display added debuffs text?
 * 
 *   Show Removed Buffs?:
 *   - Display removed de/buffs text?
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Battleback Scaling Settings
 * ============================================================================
 *
 * By default, the battlebacks in RPG Maker MZ scale as if the screen size is
 * a static 816x624 resolution, which isn't always the case. These settings
 * here allow you to dictate how you want the battlebacks to scale for the
 * whole game. These settings CANNOT be changed midgame or per battle.
 *
 * ---
 *
 * Settings
 * 
 *   Default Style:
 *   - The default scaling style used for battlebacks.
 *   - MZ (MZ's default style)
 *   - 1:1 (No Scaling)
 *   - Scale To Fit (Scale to screen size)
 *   - Scale Down (Scale Downward if Larger than Screen)
 *   - Scale Up (Scale Upward if Smaller than Screen)
 * 
 *   JS: 1:1:
 *   JS: Scale To Fit:
 *   JS: Scale Down:
 *   JS: Scale Up:
 *   JS: 1:1:
 *   JS: 1:1:
 *   - This code gives you control over the scaling for this style.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Party Command Window
 * ============================================================================
 *
 * These Plugin Parameters allow you control over how the Party Command Window
 * operates in the battle scene. You can turn disable it from appearing or make
 * it so that it doesn't 
 *
 * ---
 *
 * Command Window
 * 
 *   Style:
 *   - How do you wish to draw commands in the Party Command Window?
 *   - Text Only: Display only the text.
 *   - Icon Only: Display only the icon.
 *   - Icon + Text: Display the icon first, then the text.
 *   - Auto: Determine which is better to use based on the size of the cell.
 * 
 *   Text Align:
 *   - Text alignment for the Party Command Window.
 * 
 *   Fight Icon:
 *   - The icon used for the Fight command.
 * 
 *   Add Auto Battle?:
 *   - Add the "Auto Battle" command to the Command Window?
 * 
 *     Auto Battle Icon:
 *     - The icon used for the Auto Battle command.
 * 
 *     Auto Battle Text:
 *     - The text used for the Auto Battle command.
 * 
 *   Add Options?:
 *   - Add the "Options" command to the Command Window?
 * 
 *     Options Icon:
 *     - The icon used for the Options command.
 * 
 *     Active TPB Message:
 *     - Message that will be displayed when selecting options during the
 *       middle of an action.
 * 
 *   Escape Icon:
 *   - The icon used for the Escape command.
 *
 * ---
 *
 * Access
 * 
 *   Skip Party Command:
 *   - DTB: Skip Party Command selection on turn start.
 *   - TPB: Skip Party Command selection at battle start.
 * 
 *   Disable Party Command:
 *   - Disable the Party Command Window entirely?
 *
 * ---
 *
 * Help Window
 * 
 *   Fight:
 *   - Text displayed when selecting a skill type.
 *   - %1 - Skill Type Name
 * 
 *   Auto Battle:
 *   - Text displayed when selecting the Auto Battle command.
 * 
 *   Options:
 *   - Text displayed when selecting the Options command.
 * 
 *   Escape:
 *   - Text displayed when selecting the escape command.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Actor Command Window
 * ============================================================================
 *
 * These Plugin Parameters allow you to change various aspects regarding the
 * Actor Command Window and how it operates in the battle scene. This ranges
 * from how it appears to the default battle commands given to all players
 * without a custom <Battle Commands> notetag.
 *
 * ---
 *
 * Command Window
 * 
 *   Style:
 *   - How do you wish to draw commands in the Actor Command Window?
 *   - Text Only: Display only the text.
 *   - Icon Only: Display only the icon.
 *   - Icon + Text: Display the icon first, then the text.
 *   - Auto: Determine which is better to use based on the size of the cell.
 * 
 *   Text Align:
 *   - Text alignment for the Actor Command Window.
 * 
 *   Item Icon:
 *   - The icon used for the Item command.
 * 
 *   Normal SType Icon:
 *   - Icon used for normal skill types that aren't assigned any icons.
 *   - Ignore if VisuMZ_1_SkillsStatesCore is installed.
 * 
 *   Magic SType Icon:
 *   - Icon used for magic skill types that aren't assigned any icons.
 *   - Ignore if VisuMZ_1_SkillsStatesCore is installed.
 *
 * ---
 *
 * Battle Commands
 * 
 *   Command List:
 *   - List of battle commands that appear by default if the <Battle Commands>
 *     notetag isn't present.
 *
 *     - Attack 
 *       - Adds the basic attack command.
 * 
 *     - Skills
 *       - Displays all the skill types available to the actor.
 * 
 *     - SType: x
 *     - Stype: name
 *       - Adds in a specific skill type.
 *       - Replace 'x' with the ID of the skill type.
 *       - Replace 'name' with the name of the skill type (without text codes).
 *
 *     - All Skills
 *       - Adds all usable battle skills as individual actions.
 * 
 *     - Skill: x
 *     - Skill: name
 *       - Adds in a specific skill as a usable action.
 *       - Replace 'x' with the ID of the skill.
 *       - Replace 'name' with the name of the skill.
 * 
 *     - Guard
 *       - Adds the basic guard command.
 * 
 *     - Item
 *       - Adds the basic item command.
 * 
 *     - Escape
 *       - Adds the escape command.
 * 
 *     - Auto Battle
 *       - Adds the auto battle command.
 * 
 *     - Party
 *       - Requires VisuMZ_2_PartySystem!
 *       - Switches out the current actor for another.
 * 
 *     - Combat Log
 *       - Requires VisuMZ_4_CombatLog!
 *       - Shows combat log.
 * 
 *     - Talk
 *       - Requires VisuMZ_3_BattleCmdTalk!
 *       - Shows talk command if applicable.
 * 
 *     - Weapon Swap
 *       - Requires VisuMZ_2_WeaponSwapSystem!
 *       - Swaps current weapon for next one.
 * 
 *   Show Command Costs:
 *   - If a battle command has a resource cost, show it?
 *
 * ---
 *
 * Help Window
 * 
 *   Skill Types:
 *   - Text displayed when selecting a skill type.
 *   - %1 - Skill Type Name
 * 
 *   Items:
 *   - Text displayed when selecting the item command.
 * 
 *   Escape:
 *   - Text displayed when selecting the escape command.
 * 
 *   Auto Battle:
 *   - Text displayed when selecting the Auto Battle command.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Actor Battler Settings
 * ============================================================================
 *
 * These Plugin Parameter settings adjust how the sideview battlers behave for
 * the actor sprites. Some of these settings are shared with enemies if they
 * use sideview battler graphics.
 *
 * ---
 *
 * Flinch
 * 
 *   Flinch Distance X:
 *   - The normal X distance when flinching.
 * 
 *   Flinch Distance Y:
 *   - The normal Y distance when flinching.
 * 
 *   Flinch Duration:
 *   - The number of frames for a flinch to complete.
 *
 * ---
 *
 * Sideview Battlers
 * 
 *   Anchor: X:
 *   - Default X anchor for Sideview Battlers.
 * 
 *   Anchor: Y:
 *   - Default Y anchor for Sideview Battlers.
 * 
 *   Chant Style:
 *   - What determines the chant motion?
 *   - Hit type or skill type?
 * 
 *   Offset X:
 *   - Offsets X position where actor is positioned.
 *   - Negative values go left. Positive values go right.
 * 
 *   Offset Y:
 *   - Offsets Y position where actor is positioned.
 *   - Negative values go up. Positive values go down.
 * 
 *   Motion Speed:
 *   - The number of frames in between each motion.
 * 
 *   Priority: Active:
 *   - Place the active actor on top of actor and enemy sprites.
 * 
 *   Priority: Actors:
 *   - Prioritize actors over enemies when placing sprites on top of each other
 * 
 *   Shadow Visible:
 *   - Show or hide the shadow for Sideview Battlers.
 * 
 *   Smooth Image:
 *   - Smooth out the battler images or pixelate them?
 * 
 *   JS: Home Position:
 *   - Code used to calculate the home position of actors.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Enemy Battler Settings
 * ============================================================================
 *
 * These Plugin Parameter settings adjust how enemies appear visually in the
 * battle scene. Some of these settings will override the settings used for
 * actors if used as sideview battlers. Other settings include changing up the
 * default attack animation for enemies, how the enemy select window functions,
 * and more.
 *
 * ---
 *
 * Visual
 * 
 *   Attack Animation:
 *   - Default attack animation used for enemies.
 *   - Use <Attack Animation: x> for custom animations.
 * 
 *   Emerge Text:
 *   - Show or hide the 'Enemy emerges!' text at the start of battle.
 * 
 *   Offset X:
 *   - Offsets X position where enemy is positioned.
 *   - Negative values go left. Positive values go right.
 * 
 *   Offset Y:
 *   - Offsets Y position where enemy is positioned.
 *   - Negative values go up. Positive values go down.
 * 
 *   Smooth Image:
 *   - Smooth out the battler images or pixelate them?
 *
 * ---
 *
 * Select Window
 * 
 *   Any: Last Selected:
 *   - Prioritize last selected enemy over front view or sideview settings?
 * 
 *   FV: Right Priority:
 *   - If using frontview, auto select the enemy furthest right.
 * 
 *   SV: Right Priority:
 *   - If using sideview, auto select the enemy furthest right.
 * 
 * ---
 * 
 * Name:
 * 
 *   Legacy Option:
 *   - Use the legacy version (window) or new version (sprite).
 *   - WARNING: Legacy version is no longer supported for bugs.
 *   - Not all settings available here in the Plugin Parameters will be
 *     available to the legacy version (ie Always Visible and Attach States).
 * 
 *   Font Size:
 *   - Font size used for enemy names.
 * 
 *   Name Position:
 * 
 *     Offset X:
 *     Offset Y:
 *     - Offset the enemy name's position by this much.
 *     - For X: Negative goes left. Positive goes right.
 *     - For Y: Negative goes up. Positive goes down.
 * 
 *   Name: Attach States:
 *   - Attach the enemy's state icon to the enemy name?
 * 
 *     Attach: Offset X:
 *     Attach: Offset Y:
 *     - How much to offset the attached icon's X/Y position by?
 *     - For X: Negative goes left. Positive goes right.
 *     - For Y: Negative goes up. Positive goes down.
 * 
 *   Name Visibility:
 * 
 *     Always Hidden:
 *     - Determines if the enemy name will always be visible.
 *     - Highest priority.
 * 
 *     Always Visible:
 *     - Determines if the enemy name will always be visible.
 *     - Medium priority.
 * 
 *     By Selection?:
 *     - Determines the conditions for enemy name visibility.
 *     - Lowest priority.
 *
 * ---
 *
 * Sideview Battlers
 * 
 *   Allow Collapse:
 *   - Causes defeated enemies with SV Battler graphics to "fade away"
 *     when defeated?
 * 
 *   Anchor: X:
 *   - Default X anchor for Sideview Battlers.
 *   - Use values between 0 and 1 to be safe.
 * 
 *   Anchor: Y:
 *   - Default Y anchor for Sideview Battlers.
 *   - Use values between 0 and 1 to be safe.
 * 
 *   Motion: Idle:
 *   - Sets default idle animation used by Sideview Battlers.
 * 
 *   Shadow Visible:
 *   - Show or hide the shadow for Sideview Battlers.
 * 
 *   Size: Width:
 *   - Default width for enemies that use Sideview Battlers.
 * 
 *   Size: Height:
 *   - Default height for enemies that use Sideview Battlers.
 * 
 *   Weapon Type:
 *   - Sets default weapon type used by Sideview Battlers.
 *   - Use 0 for Bare Hands.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: HP Gauge Settings
 * ============================================================================
 *
 * Settings that adjust the visual HP Gauge displayed in battle.
 *
 * ---
 *
 * Show Gauges For
 * 
 *   Actors:
 *   - Show HP Gauges over the actor sprites' heads?
 *   - Requires SV Actors to be visible.
 * 
 *   Enemies:
 *   - Show HP Gauges over the enemy sprites' heads?
 *   - Can be bypassed with <Hide HP Gauge> notetag.
 * 
 *     Requires Defeat?:
 *     - Requires defeating the enemy once to show HP Gauge?
 *     - Can be bypassed with <Show HP Gauge> notetag.
 * 
 *       Battle Test Bypass?:
 *       - Bypass the defeat requirement in battle test?
 *
 * ---
 *
 * Settings
 * 
 *   Anchor X:
 *   Anchor Y:
 *   - Where do you want the HP Gauge sprite's anchor X/Y to be?
 *     Use values between 0 and 1 to be safe.
 * 
 *   Scale:
 *   - How large/small do you want the HP Gauge to be scaled?
 * 
 *   Offset X:
 *   Offset Y:
 *   - How many pixels to offset the HP Gauge's X/Y by?
 *
 * ---
 *
 * Options
 * 
 *   Add Option?:
 *   - Add the 'Show HP Gauge' option to the Options menu?
 * 
 *   Adjust Window Height:
 *   - Automatically adjust the options window height?
 * 
 *   Option Name:
 *   - Command name of the option.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Action Sequence Settings
 * ============================================================================
 *
 * Action Sequence Plugin Parameters allow you to decide if you want automatic
 * Action Sequences to be used for physical attacks, the default casting
 * animations used, how counters and reflects appear visually, and what the
 * default stepping distances are.
 *
 * ---
 *
 * Automatic Sequences
 * 
 *   Melee Single Target:
 *   - Allow this auto sequence for physical, single target actions?
 * 
 *   Melee Multi Target:
 *   - Allow this auto sequence for physical, multi-target actions?
 *
 * ---
 * 
 * Quality of Life
 * 
 *   Auto Notetag:
 *   - Automatically apply the <Custom Action Sequence> notetag effect to any
 *     item or skill that has a Common Event?
 *   - Any item or skill without a Common Event attached to it will use the
 *     Automatic Action Sequences instead.
 *   - The <Auto Action Sequence> notetag will disable this effect for that
 *     particular skill or item.
 * 
 * ---
 *
 * Cast Animations
 * 
 *   Certain Hit:
 *   - Cast animation for Certain Hit skills.
 * 
 *   Physical:
 *   - Cast animation for Physical skills.
 * 
 *   Magical:
 *   - Cast animation for Magical skills.
 *
 * ---
 *
 * Counter/Reflect
 * 
 *   Counter Back:
 *   - Play back the attack animation used?
 * 
 *   Reflect Animation:
 *   - Animation played when an action is reflected.
 * 
 *   Reflect Back:
 *   - Play back the attack animation used?
 *
 * ---
 *
 * Stepping
 * 
 *   Melee Distance:
 *   - Minimum distance in pixels for Movement Action Sequences.
 * 
 *   Step Distance X:
 *   - The normal X distance when stepping forward.
 * 
 *   Step Distance Y:
 *   - The normal Y distance when stepping forward.
 * 
 *   Step Duration:
 *   - The number of frames for a stepping action to complete.
 *
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * * Yanfly
 * * Arisu
 * * Olivia
 * * Irina
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.46: September 23, 2021
 * * Bug Fixes!
 * ** Fixed problem with skills and items without action sequences preventing
 *    actions from occurring. Fix made by Yanfly.
 * 
 * Version 1.45: September 17, 2021
 * * Bug Fixes!
 * ** <JS Pre-End Action> and <JS Post-End Action> effects now have multiple
 *    checks to make sure that they don't launch multiple times when a battler
 *    without actions has a turn after one that does. Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence notetags added by Yanfly and Arisu:
 * *** <Common Event Key: name>
 * *** <Common Event Keys: name, name, name>
 * *** <Common Event Keys>
 *      key
 *      key
 *      key
 *     </Common Event Keys>
 * **** Will generate Common Events for the skill/item with a corresponding
 *      key.
 * **** More information will be explained inside of the help file.
 * **** This feature is made for make the process of sharing Action Sequences
 *      to become easier without needing to line up Common Event ID's.
 * 
 * Version 1.44: August 20, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence added by Irina and sponsored by Anon.
 * *** "ANIM: Play at Coordinate"
 * **** Plays an animation on the screen at a specific x, y coordinate even if
 *      there is no sprite attached.
 * **** Requires VisuMZ_0_CoreEngine!
 * 
 * Version 1.43: July 23, 2021
 * * Feature Update!
 * ** Immortality now works different with instant death mechanics. Skill
 *    effects that apply instant death or attack states that apply instant
 *    death will now trigger a flag instead of cancelling immortality. The
 *    flag will remain until immortality is manually cancelled via Action
 *    Sequence and then proc the death effect. This way, animations can remain
 *    to the end with instant death mechanics in mind. This does not affect
 *    script calls.
 * 
 * Version 1.42: July 16, 2021
 * * Bug Fixes!
 * ** Added another fail safe for empty common events used for pre-battle
 *    common events. Fix made by Olivia.
 * 
 * Version 1.41: July 2, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Added entries to <Battle Command> notetags and Plugin Parameters for
 *    "Party", "Combat Log", and "Weapon Swap" which weren't updated before.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * * New Features!
 * ** New Action Sequence added by Arisu:
 * *** MECH: Enemy Escape
 * **** Causes the enemy unit(s) to escape.
 * 
 * Version 1.40: June 25, 2021
 * * Bug Fixes!
 * ** Transformations from static enemies to and from animated SV enemies
 *    should no longer show both sprites. Fix made by Irina.
 * * Compatibility Update
 * ** Compatibility update with RPG Maker MZ 1.3.0+.
 * 
 * Version 1.39: June 18, 2021
 * * Bug Fixes!
 * ** MOVE: Home Reset should no longer trigger an end action function and
 *    cause plugins such as "Boost Action" to malfunction. Fix made by Olivia.
 * * Compatibility Update
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for updated features.
 * * Feature Update!
 * ** <Battle Layout: x> Troop Name tags can now work with comment tags. Update
 *    made by Irina.
 * ** Random encounter lists are now better shuffled for more variety with how
 *    the RNG seed works. Update made by Arisu.
 * 
 * Version 1.38: June 11, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Updates!
 * ** Location calculations will now be based off the a battler's base position
 *    in order for animations, popups, and other aspects to line up properly
 *    when scaled. Update made by Irina.
 * ** Plugin Parameters for Enemy Battler Settings > Name have been rearranged
 *    for better organization. Update by Olivia.
 * * New Features!
 * ** New Notetags added by Olivia and sponsored by NSG:
 * *** <Sideview Shadow Scale X: x%>
 * *** <Sideview Shadow Scale X: x.y>
 * *** <Sideview Shadow Scale Y: x%>
 * *** <Sideview Shadow Scale Y: x.y>
 * **** These new notetags allow you to adjust the X and Y scale of the SV
 *      shadow sprite separately.
 * ** New Plugin Parameters added by Olivia and sponsored by NSG:
 * *** Enemy Battler Settings > Name > Name Visibility > Always Hidden
 * *** Enemy Battler Settings > Name > Name Visibility > By Selection?
 * **** Choose to have the names always hidden or by selection.
 * **** These are adjusted on a priority list.
 * 
 * Version 1.37: May 21, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetags added by Olivia.
 * *** <Command Require Learn>
 * *** <Command Require Access>
 * **** These two commands determine the visibility of a battle command by
 *      whether or not the skill has been learned or accessible.
 * * Feature Update!
 * ** For those using TPB, each battler's regeneration phase will no longer
 *    tick multiple times in a single frame to prevent irregularities. Update
 *    made by Olivia.
 * 
 * Version 1.36: May 14, 2021
 * * Bug Fixes!
 * ** Reversed an HP/MP regeneration bug that was incorrectly reported for TPB.
 *    Fix made by Olivia.
 * * Documentation Update
 * ** Added "TPB/ATB Active Battle Actor Shifting" to Major Changes section:
 * *** This change has been active since the start of this plugin. It was not
 *     documented until now.
 * *** Pressing cancel on the Actor Command Window no longer switches between
 *     actors with a full TPB/ATB gauge before reaching the Party Command
 *     Window. This is to accomplish a couple of things: 1) reduce the number
 *     of button presses to reach the Party Command Window and 2) to prevent
 *     motion resets and disrupting action sequences. If this feature is vital
 *     to your battle system, we recommend that you do not use this plugin or
 *     any of the Battle Core-required plugins.
 * ** Feature Updates
 * *** Distortion sprite Y calculations will now be rounded upward for better
 *     visuals and prevent odd pixelation effects. Update made by Irina.
 * 
 * Version 1.35: May 7, 2021
 * * Bug Fixes!
 * ** Pre-Battle Common Events without a wait command at the end should no
 *    longer lock up by coincidentally pressing the menu key at the same time.
 *    Fix made by Olivia.
 * * Feature Update!
 * ** Added an extra check for TPB-based battle systems to not run turn end
 *    functions when it's not actually the actual turn end timing. Update made
 *    by Olivia.
 * ** "Damage Styles" plugin parameters are now moved to the top of the
 *    Damage Settings category. This should make it easier to acknowledge the
 *    existence of and not have it be an unknown entity. Update made by Irina.
 * 
 * Version 1.34: April 23, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Uses a better algorithm for determining shadow positioning. Update made
 *    by Olivia.
 * * New Features!
 * ** New additions made for Projectile action sequences.
 * ** "Start Location" and "Goal Location" now have "Target Location" parameter
 *    to determine which part of the target's body to send the projectile from
 *    or towards. Added by Olivia.
 * ** Requires VisuMZ_1_BattleCore version 1.34 to have affect.
 * 
 * Version 1.33: April 9, 2021
 * * Bug Fixes!
 * ** Skill costs should now be displayed on battle commands again. Bug fix
 *    made by Olivia.
 * ** Pre-Battle Common Events should no longer cause stalling when used with
 *    specific event commands. Bug fix made by Olivia.
 * * Compatibility Update!
 * ** Added "Weapon Swap" to the list of battle commands that can be added.
 * * Documentation Update!
 * ** Added "Weapon Swap" and "Combat Log" to the list of <Battle Commands> in
 *    the notetags section.
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetags added by Olivia:
 * *** <Sideview Shadow Scale: x%> and <Sideview Shadow Scale: x.y>
 * **** Used for: Actor, Enemy Notetags
 * **** Adjusts the scaling size of the sideview battler's shadow.
 * 
 * Version 1.32: April 2, 2021
 * * Feature Update!
 * ** Sideview battler sprites when using front view will now factor in the
 *    window padding and appear properly centered to their focus point. Update
 *    made by Olivia.
 * 
 * Version 1.31: March 26, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Added "VisuStella MZ Compatibility" section for detailed compatibility
 *    explanations with the VisuMZ_3_BoostAction plugin.
 * 
 * Version 1.30: March 19, 2021
 * * Documentation Update!
 * ** Help file updated for updated features.
 * * Feature Update!
 * ** <JS Targets> is now updated to include the default set of targets
 *    selected by the skill/item's original scope. Update made by Yanfly.
 * *** If you wish to clear it out, simply do 'targets = []' first.
 * 
 * Version 1.29: March 12, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameter added by Olivia:
 * *** Plugin Parameters > Enemy Battler Settings > Name > Legacy Option
 * **** Use the legacy version (window) or new version (sprite).
 * **** WARNING: Legacy version is no longer supported for bugs.
 * **** Not all settings available here in the Plugin Parameters will be
 *      available to the legacy version (ie Always Visible and Attach States).
 * 
 * Version 1.28: March 5, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Arisu:
 * *** Plugin Parameters > Actor Command > Show Command Costs
 * **** If you don't want to show skill costs for your commands in the Actor
 *      Command Window, you can now hide them.
 * ** New Plugin Parameters added by Irina:
 * *** Plugin Parameters > Battle Layout Settings > Status Window Elements
 * *** Battle Layout Settings > Status Window Elements > Battler Name
 * *** Battle Layout Settings > Status Window Elements > Gauge 1 (HP)
 * *** Battle Layout Settings > Status Window Elements > Gauge 2 (MP)
 * *** Battle Layout Settings > Status Window Elements > Gauge 3 (TP)
 * *** Battle Layout Settings > Status Window Elements > State Icon
 * *** Battle Layout Settings > Status Window Elements > TPB/ATB Gauge
 * **** These new Plugin Parameters allow you to offset the positions of the
 *      various Battle Status Window elements. Their base positions will be
 *      calculated by the Battle Layout used and then offset from there.
 * *** Battle Layout Settings > Status Window Elements > Window Skin
 * **** These settings allow you to set a specific window skin for the
 *      Battle Status Window or hide it from view completely.
 * *** Battle Layout Settings > Status Window Elements > Selectable Background
 * **** This option allows you to hide the black box that comes with the
 *      majority of selectable elements found in RPG Maker MZ in case it does
 *      not fit with how you want the Battle Status Window to look.
 * *** Battle Layout Settings > Status Window Elements > Back Attachment
 * *** Battle Layout Settings > Status Window Elements > Front Attachment
 * **** These settings allow you to attach images to the back/front of the
 *      Battle Status Window from the img/system/ folder.
 * **** You may offset X and Y positions for them as well.
 * ** New Plugin Parameters added by Olivia:
 * *** Plugin Parameters > Enemy Settings > Name: Always Visible
 * **** Determines if the enemy name will always be visible.
 * *** Plugin Parameters > Enemy Settings > Name: Attach States
 * **** Attach the enemy's state icon to the enemy name?
 * *** Plugin Parameters > Enemy Settings > Attach: Offset X/Y
 * **** Offset the attached state icon's position.
 * * Feature Update!
 * ** Switched drawing enemy names on the screen from window to sprite to
 *    reduce lag and for better screen positioning accuracy especially during
 *    screen zooming. Update by Olivia.
 * 
 * Version 1.27: February 26, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Irina and sponsored by AndyL:
 * *** Plugin Parameters > Mechanics Settings > Switches > Switch: Critical
 * *** Plugin Parameters > Mechanics Settings > Switches > Switch: Miss/Evade
 * **** Turns Switches ON if the action performs a critical hit, misses, or is
 *      evaded at any point.
 * **** Switch reverts to OFF whenever an action starts.
 * **** If multiple targets/hits are struck, as long as one hit respectively
 *      lands a critical hit, fails to land, then the switch will remain ON for
 *      the rest of the action.
 * *** Plugin Parameters > Mechanics Settings > Variables > Variable: Damage
 * *** Plugin Parameters > Mechanics Settings > Variables > Variable: Healing
 * **** Variable records target damage/healing during action.
 * **** Variable reverts to 0 whenever an action starts.
 * **** If multiple targets/hits are struck, the variable will record the total
 *      amount of damage/healing done for the remainder of the action (unless
 *      manually reseting to 0 during an Action Sequence).
 * 
 * Version 1.26: February 19, 2021
 * * Bug Fixes!
 * ** Battles with branching event paths found within a conditional branch or
 *    choice tree will no longer be skipped over. Fix made by Arisu.
 * * Compatibility Update
 * ** Returning to the battle scene from the options scene in a Tpb-base battle
 *    system now links the current actor. Update by Irina.
 * 
 * Version 1.25: February 5, 2021
 * * Compatibility Update
 * ** Added compatibility update with VisuStella MZ Skills and States Core's
 *    Plugin Parameter > State Settings > Action End Update
 * * Feature Update!
 * ** <Common Event: name> notetag no longer requires <Custom Action Sequence>
 *    notetag if the Plugin Parameter: Auto Notetag is enabled.
 * 
 * Version 1.24: January 29, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** MOVE: Move To Point and MOVE: Move To Target(s) Action Sequences'
 *    "Offset Adjustment" normal setting will now factor in Offset X and
 *    Offset Y positions unlike before where it cancels them. Update by Irina.
 * * New Features!
 * ** New notetag added by Arisu:
 * *** <Common Event: name>
 * **** Battle only: calls forth a Common Event of a matching name.
 * **** This is primarily used for users who are reorganizing around their
 *      Common Events and would still like to have their skills/items perform
 *      the correct Action Sequences in case the ID's are different.
 * 
 * Version 1.23: January 22, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** ACSET: All Targets Action Set and ACSET: Each Target Action Set updated
 * *** New parameter added: Dual/Multi Wield?
 * **** Add times struck based on weapon quantity equipped?
 * * New Features!
 * ** Dual Wielding now functions differently. Made by Olivia.
 * *** Previously, RPG Maker MZ had "Dual Wielding" attack using both weapon
 *     animations at once, with the combined ATK of each weapon. It's confusing
 *     to look at and does not portray the nature of "Dual Wielding".
 * *** Dual Wielding, or in the case of users adding in third and fourth
 *     weapons, Multi Wielding is now changed. Each weapon is displayed
 *     individually, each producing its own attack animation, showing each
 *     weapon type, and applying only that weapon's ATK, Traits, and related
 *     effects. It is no longer a combined effect to display everything at once
 *     like RPG Maker MZ default.
 * *** If an actor has multiple weapon slots but some of them are unequipped,
 *     then the action will treat the attack as a single attack. There will be
 *     no barehanded attack to add on top of it. This is to match RPG Maker
 *     MZ's decision to omit a second animation if the same scenario is
 *     applied.
 * ** New Action Sequence Plugin Commands added by Yanfly
 * *** ANIM: Attack Animation 2+
 * **** Plays the animation associated with the user's 2nd weapon.
 *      Plays nothing if there is no 2nd weapon equipped.
 * ** New Action Sequence Plugin Commands added by Olivia
 * *** WEAPON: Clear Weapon Slot
 * *** WEAPON: Next Weapon Slot
 * *** WEAPON: Set Weapon Slot
 * **** These are Action Sequence Plugin Commands for devs who want finer
 *      control over Dual/Multi Wielding weapons.
 * 
 * Version 1.22: January 15, 2021
 * * Compatibility Update
 * ** Compatibility with "All Skills" Actor Command should now work with the
 *    Skills & States Core hide skill notetags.
 * 
 * Version 1.21: January 8, 2021
 * * Bug Fixes!
 * ** "MOVE: Home Reset" Plugin Command Action Sequence should work properly.
 *    Fix made by Yanfly.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New Notetag snuck in by Arisu
 * *** <Auto Action Sequence>
 * **** Used for those who have the "Auto Notetag" Plugin Parameter enabled and
 *      just want to use an automatic Action Sequence instead.
 * ** New Plugin Parameter snuck in by Arisu!
 * *** Plugin Parameters > Action Sequences > Quality of Life > Auto Notetag
 * **** Automatically apply the <Custom Action Sequence> notetag effect to any
 *      item or skill that has a Common Event?
 * **** Any item or skill without a Common Event attached to it will use the
 *      Automatic Action Sequences instead.
 * **** The <Auto Action Sequence> notetag will disable this effect for that
 *      particular skill or item.
 * ** Arisu, you're going to be responsible for any bugs these may cause.
 * *** Bring it!!!!
 * **** And handling any bug report emails that are sent because this was
 *      turned on by accident.
 * ***** Please read the documentation, guys!
 * 
 * Version 1.20: January 1, 2021
 * * Bug Fixes!
 * ** For TPB Active or ATB Active, inputting actors that have received damage
 *    will return back to place after flinching. Fix made by Yanfly.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New notetags added by Yanfly:
 * *** <Battle Portrait Offset: +x, +y>
 * *** <Battle Portrait Offset X: +x>
 * *** <Battle Portrait Offset Y: +y>
 * **** This is used with the "Portrait" and "Border" Battle Layouts.
 * **** Offsets the X and Y coordinates for the battle portrait.
 * 
 * Version 1.19: December 25, 2020
 * * Bug Fixes!
 * ** Removing a state from a Sideview Enemy during the middle of their a non-
 *    looping motion will no longer reset their motion to neutral.
 *    Fix made by Yanfly.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added documentation for updated feature(s)!
 * * Feature Update!
 * ** Action Sequence "PROJECTILE: Icon" now supports code for the "Icon"
 *    parameter. Update made by Yanfly.
 * 
 * Version 1.18: December 18, 2020
 * * Bug Fixes!
 * ** For TPB Active or ATB Active, inputting actors will no longer step back
 *    after an enemy's action is finished. Fix made by Yanfly and Shiro.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** Action Sequence "BTLOG: Add Text" is updated for the convenience of a new
 *    option to quickly copy the displayed text to the VisuStella MZ Combat Log
 *    if that plugin is installed. Added by Yanfly.
 * 
 * Version 1.17: December 11, 2020
 * * Bug Fixes!
 * ** Common Events in TPB Active that cause forced actions will no longer
 *    cause currently inputting actors that match the forced action battler to
 *    crash the game. Fix made by Yanfly and Shiro.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * Feature Update!
 * ** Action Sequence Impact Action Sequences "Shockwave from Each Target(s)",
 *    "Shockwave from Target(s) Center", and "Zoom Blur at Target(s) Center"
 *    now have "Offset X" and "Offset Y" plugin parameters. Added by Yanfly.
 * ** Action Sequence "MOVE: Move To Target(s)" is now changed so that if the
 *    "Melee Distance" value is set to 0, battlers will no longer stand a half
 *    body distance away. Added by Yanfly.
 * 
 * Version 1.16: December 4, 2020
 * * Bug Fixes!
 * ** Bug fixes made for the RPG Maker MZ base code. If a battler has no
 *    actions, then their action speed will not be Infinity. Fix by Olivia.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.15: November 29, 2020
 * * Bug Fixes!
 * ** Completely replacing the whole party at once will no longer cause the
 *    battle system to crash. Fix made by Olivia.
 * ** Pre-Battle Common Events will no longer cancel out any win/lose branches.
 *    Fix made by Arisu.
 * * Feature Update!
 * ** Custom Action Sequences will no longer close the Actor Command Input
 *    window unless absolutely necessary (like for Show Message events) during
 *    Active TPB/ATB. Change made by Arisu.
 * 
 * Version 1.14: November 22, 2020
 * * Feature Update!
 * ** Natural Miss and Evasion motions now have flinch distance.
 *    Added by Yanfly.
 * 
 * Version 1.13: November 15, 2020
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.12: November 8, 2020
 * * Bug Fixes!
 * ** Failsafes added to prevent common events from running if they're empty.
 *    Fix made by Irina.
 * ** Skip Party Command will now work properly with TPB-based battle systems.
 *    Fix made by Yanfly.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** In preparation for upcoming VisuStella MZ plugins.
 * 
 * Version 1.11: November 1, 2020
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added clarity for the Plugin Parameters for the Common Events settings
 *    found in the mechanics section. The common events are only meant to run
 *    in the map scene and not for the battle scene. Update made by Irina.
 * * Feature Update!
 * ** The Plugin Parameter for Mechanics, Common Events (on Map), Defeat Event
 *    now has updated functionality. If this has a common event attached to it,
 *    then losing to random encounters will no longer send the player to the
 *    Game Over scene, but instead, send the player back to the map scene,
 *    where the Defeat Common Event will run. Update made by Irina.
 * 
 * Version 1.10: October 25, 2020
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New Action Sequence Plugin Command added by Olivia:
 * *** MECH: Custom Damage Formula
 * **** Changes the current action's damage formula to custom.
 *      This will assume the MANUAL damage style.
 * ** New Notetag added by Irina:
 * ** New Plugin Parameters added by Irina:
 * *** Plugin Parameters > Battleback Scaling Settings
 * **** These settings allow you to adjust how battlebacks scale to the screen
 *      in the game.
 * *** <Battler Sprite Grounded>
 * **** Prevents the enemy from being able to jumping and/or floating due to
 *      Action Sequences but still able to move. Useful for rooted enemies.
 * 
 * Version 1.09: October 18, 2020
 * * Bug Fixes!
 * ** Exiting out of the Options menu scene or Party menu scene will no longer
 *    cause party members to reset their starting position. Fix made by Arisu
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * ** There was a documentation error with <JS Pre-Regenerate> and
 *    <JS Post-Regenerate>. Fix made by Yanfly.
 * *** Before, these were written as <JS Pre-Regenerate Turn> and
 *     <JS Post-Regenerate Turn>. The "Turn" part of the notetag has been
 *     removed in the documentation.
 * * Feature Update!
 * ** Damage sprites on actors are now centered relative to the actor's anchor.
 *    Change made by Yanfly.
 * * New Features!
 * ** New Action Sequence Plugin Command added by Yanfly:
 * *** MECH: Variable Popup
 * **** Causes the unit(s) to display a popup using the data stored inside
 *      a variable.
 * 
 * Version 1.08: October 11, 2020
 * * Bug Fixes!
 * ** Dead party members at the start of battle no longer start offscreen.
 *    Fix made by Arisu.
 * ** Removed party members from battle no longer count as moving battlers.
 *    Fix made by Yanfly.
 * ** Using specific motions should now have the weapons showing and not
 *    showing properly. Fix made by Yanfly.
 * 
 * Version 1.07: October 4, 2020
 * * Bug Fixes!
 * ** Adding and removing actors will now refresh the battle status display.
 *    Fix made by Irina.
 * ** Adding new states that would change the affected battler's state motion
 *    will automatically refresh the battler's motion. Fix made by Irina.
 * ** Boss Collapse animation fixed and will sink into the ground.
 *    Fix made by Irina.
 * ** Failsafes added for certain animation types. Fix made by Yanfly.
 * ** Freeze Motion for thrust, swing, and missile animations will now show the
 *    weapons properly. Fix made by Yanfly.
 * ** The Guard command will no longer display the costs of the Attack command.
 *    Fix made by Irina.
 * * Documentation Update!
 * ** Updated help file for newly added plugin parameters.
 * * Feature Updates!
 * ** When using the Change Battleback event command in battle, the game client
 *    will wait until both battlebacks are loaded before changing the both of
 *    them so that the appearance is synched together. Change made by Yanfly.
 * * New Features!
 * ** New plugin parameters added by Irina!
 * *** Plugin Parameters > Actor Battler Settings > Chant Style
 * **** What determines the chant motion? Hit type or skill type?
 * 
 * Version 1.06: September 27, 2020
 * * Bug Fixes!
 * ** Enemy Battler Plugin Parameter "Shadow Visible" should now work again.
 *    Fix made by Irina.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins. Added by Yanfly.
 * * Documentation Update!
 * ** Updated the help file for all the new plugin parameters.
 * * Feature Update!
 * ** Action Sequence "MECH: HP, MP, TP" will now automatically collapse an
 *    enemy if it has been killed by the effect.
 * ** All battle systems for front view will now have damage popups appear
 *    in front of the status window instead of just the Portrait battle layout.
 *    Update made by Yanfly.
 * * New Features!
 * ** New Action Sequence Plugin Commands from Irina!
 * *** MOTION: Clear Freeze Frame
 * *** MOTION: Freeze Motion Frame
 * **** You can freeze a battler's sprite's motion with a specific frame.
 * ** New notetags for Maps and name tags for Troops added by Yanfly!
 * *** <Battle Layout: type> to change the battle layout style used for
 *     specific maps and/or troops.
 * ** New plugin parameters added by Yanfly!
 * *** Plugin Parameters > Battle Layout Settings > Command Window Width
 * **** This plugin parameter lets you adjust the window width for Party and
 *      Actor Command windows in the Default and List Battle Layout styles.
 * *** Plugin Parameters > Enemy Battler Settings > Name: Offset X
 * *** Plugin Parameters > Enemy Battler Settings > Name: Offset Y
 * **** These plugin parameters allow you to offset the position of the enemy
 *      name positions on the screen by a specific amount.
 * 
 * Version 1.05: September 20, 2020
 * * Bug Fixes!
 * ** Actors now use their casting or charging animations again during TPB/ATB.
 *    Fix made by Yanfly.
 * ** Defeat requirement for enemies will no longer crash the game if turned on
 *    after creating
 * ** Escaping animation no longer has actors stay in place. Fixed by Yanfly.
 * ** Failsafes added for newly added weapon types that have not been adjusted
 *    in the Database > System 2 tab. Fixed by Irina.
 * ** Shadows now appear under the actor sprites. Fix made by Yanfly.
 * ** Victory during TPB will no longer cancel the victory animations of
 *    actors that will have their turn after. Fixed by Yanfly.
 * * Documentation Update!
 * ** All Anchor Plugin Parameter descriptions now state to use values between
 *    0 and 1 to be safe. Update made by Yanfly.
 * * Feature Update!
 * ** During Active TPB / ATB, canceling out of the actor command window will
 *    go directly into the party window without having to sort through all of
 *    the available active actors.
 * ** Going from the Party Command Window's Fight command will immediately
 *    return back to the actor command window that was canceled from.
 * * New Features!
 * ** Action Sequence Plugin Command "MOVE: Spin/Rotate" has been updated.
 * *** A new parameter has been added: "Revert Angle on Finish"
 * *** Added by Yanfly.
 * ** New plugin parameters have been added to Damage Settings.
 * *** Appear Position: Selects where you want popups to appear relative to the
 *     battler. Head, Center, Base. Added by Yanfly.
 * *** Offset X: Sets how much to offset the sprites by vertically.
 *     Added by Yanfly.
 * *** Offset Y: Sets how much to offset the sprites by horizontally.
 *     Added by Yanfly.
 * ** New plugin parameters have been added to Actor Battler Settings.
 * *** Priority: Active - Place the active actor on top of actor and
 *     enemy sprites. Added by Yanfly.
 * *** Priority: Actors - Prioritize actors over enemies when placing 
 *     sprites on top of each other. Added by Yanfly.
 * 
 * Version 1.04: September 13, 2020
 * * Bug Fixes!
 * ** Active Battler Sprites now remain on top and won't be hidden behind
 *    other sprites for better visual clarity. Fix made by Arisu.
 * ** Collapsing battlers will now show the dead motion properly. Fix made by
 *    Olivia.
 * ** Dead battlers can no longer be given immortality. Fix made by Olivia.
 * ** Going into the Options menu with no battleback set will no longer set a
 *    battle snapshot.
 * ** HP Gauges for Sideview Enemies are no longer flipped! Fix made by Yanfly.
 * ** Moving a dead battler would no longer reset their animation. Fix made by
 *    Olivia.
 * ** Pre-Battle Common Events now work with events instead of just random
 *    encounters. Fix made by Yanfly.
 * ** Sideview Enemy shadows no longer twitch. Fix made by Irina.
 * * Documentation Updates!
 * ** Added further explanations for Anchor X and Anchor Y plugin parameters.
 *    This is because there's a lot of confusion for users who aren't familiar
 *    with how sprites work. Added by Irina.
 * ** <Magic Reduction: x> notetag updated to say magical damage instead of
 *    physical damage. Fix made by Yanfly.
 * * New Features!
 * ** Additional Action Sequence Plugin Commands have been added in preparation
 *    of upcoming plugins! Additions made by Irina.
 * *** Action Sequences - Angle (for VisuMZ_3_ActSeqCamera)
 * *** Action Sequences - Camera (for VisuMZ_3_ActSeqCamera)
 * *** Action Sequences - Skew (for VisuMZ_3_ActSeqCamera)
 * *** Action Sequences - Zoom (for VisuMZ_3_ActSeqCamera)
 * ** Additional Action Sequence Plugin Commands have been made available now
 *    and added to Battle Core! Additions made by Irina.
 * *** MOVE: Scale/Grow/Shrink
 * *** MOVE: Skew/Distort
 * *** MOVE: Spin/Rotate
 * *** MOVE: Wait For Scale
 * *** MOVE: Wait For Skew
 * *** MOVE: Wait For Spin
 * ** Plugin Parameters Additions. Additions made by Irina.
 * *** Plugin Params > Actor Battler Settings > Offset X
 * *** Plugin Params > Actor Battler Settings > Offset Y
 * *** Plugin Params > Actor Battler Settings > Smooth Image
 * *** Plugin Params > Enemy Battler Settings > Offset X
 * *** Plugin Params > Enemy Battler Settings > Offset Y
 * *** Plugin Params > Enemy Battler Settings > Smooth Image
 * 
 * Version 1.03: September 6, 2020
 * * Bug Fixes!
 * ** Animated Battlers will refresh their motions from the death motion once
 *    they're revived instead of waiting for their next input phase. Fix made
 *    by Yanfly.
 * ** Battle Log speed sometimes went by too fast for certain enabled messages.
 *    Wait timers are now added to them, like state results, buff results, and
 *    debuff results. Fix made by Yanfly.
 * ** Boss Collapse animation now works properly. Fix made by Yanfly.
 * ** Freeze fix for TPB (Wait) if multiple actors get a turn at the same time.
 *    Fix made by Olivia.
 * ** Pressing cancel on a target window after selecting a single skill no
 *    longer causes the status window to twitch.
 * ** Sideview Enemies had a split frame of being visible if they were to start
 *    off hidden in battle. Fix made by Shaz.
 * * Compatibility Update:
 * ** Battle Core's Sprite_Damage.setup() function is now separated fro the
 *    default to allow for better compatibility. Made by Yanfly.
 * * Documentation Update:
 * ** Inserted more information for "Damage Popups" under "Major Changes"
 * * New Features!
 * ** <Magic Penetration: x>, <Magic Penetration: x%> notetags added.
 * ** <Magic Reduction: x>, <Magic Reduction: x%> notetags added.
 * ** <Battle UI Offset: +x, +y>, <Battle UI Offset X: +x>, and
 *    <Battle UI Offset Y: +y> notetags added for adjusting the positions of
 *    HP Gauges and State Icons.
 * *** Notetags added by Yanfly.
 * 
 * Version 1.02: August 30, 2020
 * * Bug Fixes!
 * ** Failsafes added for parsing battle targets. Fix made by Yanfly.
 * ** Immortality is no longer ignored by skills/items with the Normal Attack
 *    state effect. Fix made by Yanfly.
 * ** Miss and Evasion sound effects work again! Fix made by Yanfly.
 * ** Selecting "Escape" from the Actor Command Window will now have the
 *    Inputting Battler show its escape motion. Fix made by Yanfly.
 * ** Wait for Movement now applies to SV Enemies. Fix made by Yanfly.
 * * New Features!
 * ** Plugin Command "ACSET: Finish Action" now has an option to turn off the
 *    Immortality of targets. Feature added by Yanfly.
 * * Optimization Update
 * ** Uses less resources when making checks for Pre-Battle Battle Start events
 * 
 * Version 1.01: August 23, 2020
 * * Bug Fixes!
 * ** Plugin Parameters > Damage Settings > Damage Formats are now fixed.
 *    Fix made by Olivia.
 * ** TPB Battle System with Disable Party Command fixed. Fix made by Olivia.
 * ** States now show in list format if faces are disabled. Fix made by Yanfly.
 * ** The default damage styles were missing the 'v' variable to allow for
 *    variable data input. These are back now. Fix made by Yanfly.
 * *** Users updating from version 1.00 will need to fix this problem by either
 *     removing the plugin from the Plugin Manager list and reinstalling it, or
 *     going to Plugin Parameters > Damage Settings > Style List > the style
 *     you want, and adding "const v = $gameVariables._data;" to JS: Formula
 * * New Notetags Added:
 * ** <Command Show Switch: x> added by Olivia
 * ** <Command Show All Switches: x,x,x> added by Olivia
 * ** <Command Show Any Switches: x,x,x> added by Olivia
 * ** <Command Hide Switch: x> added by Olivia
 * ** <Command Hide All Switches: x,x,x> added by Olivia
 * ** <Command Hide Any Switches: x,x,x> added by Olivia
 * ** <JS Command Visible> added by Olivia
 *
 * Version 1.00: August 20, 2020
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceStart
 * @text -
 * @desc The following are Action Sequences commands/sets.
 * These Plugin Commands only work in battle.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakSet
 * @text Action Sequence - Action Sets
 * @desc Action Sequence Action Sets are groups of commonly used
 * Action Sequence Commands put together for more efficient usage.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_SetupAction
 * @text ACSET: Setup Action Set
 * @desc The generic start to most actions.
 * 
 * @arg DisplayAction:eval
 * @text Display Action
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: On
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ActionStart:eval
 * @text Battle Step
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg CastAnimation:eval
 * @text Cast Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_WholeActionSet
 * @text ACSET: All Targets Action Set
 * @desc Affects all targets simultaneously performing the following.
 * 
 * @arg DualWield:eval
 * @text Dual/Multi Wield?
 * @type boolean
 * @on Apply
 * @off Don't
 * @desc Add times struck based on weapon quantity equipped?
 * @default false
 * 
 * @arg PerformAction:eval
 * @text Perform Action
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitCount:eval
 * @text Wait Count
 * @desc How many frames should the action sequence wait?
 * You may use JavaScript code.
 * @default Sprite_Battler._motionSpeed
 * 
 * @arg ActionAnimation:eval
 * @text Action Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ActionEffect:eval
 * @text Action Effect
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: Off
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_TargetActionSet
 * @text ACSET: Each Target Action Set
 * @desc Goes through each target one by one to perform the following.
 * 
 * @arg DualWield:eval
 * @text Dual/Multi Wield?
 * @type boolean
 * @on Apply
 * @off Don't
 * @desc Add times struck based on weapon quantity equipped?
 * @default false
 * 
 * @arg PerformAction:eval
 * @text Perform Action
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitCount1:eval
 * @text Wait Count
 * @desc How many frames should the action sequence wait?
 * You may use JavaScript code.
 * @default Sprite_Battler._motionSpeed
 * 
 * @arg ActionAnimation:eval
 * @text Action Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitCount2:eval
 * @text Wait Count
 * @desc How many frames should the action sequence wait?
 * You may use JavaScript code.
 * @default Sprite_Battler._motionSpeed * 2
 * 
 * @arg ActionEffect:eval
 * @text Action Effect
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: Off
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_FinishAction
 * @text ACSET: Finish Action
 * @desc The generic ending to most actions.
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: Off
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForNewLine:eval
 * @text Wait For New Line
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForEffect:eval
 * @text Wait For Effects
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ClearBattleLog:eval
 * @text Clear Battle Log
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ActionEnd:eval
 * @text Home Reset
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceAngle
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakAngle
 * @text Action Sequences - Angle
 * @desc Allows you to have control over the camera angle.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_ChangeAngle
 * @text ANGLE: Change Angle
 * @desc Changes the camera angle.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Angle:eval
 * @text Angle
 * @desc Change the camera angle to this many degrees.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to change camera angle.
 * @default 60
 *
 * @arg EasingType:str
 * @text Angle Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForAngle:eval
 * @text Wait For Angle?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for angle changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Angle_Reset
 * @text ANGLE: Reset Angle
 * @desc Reset any angle settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to reset camera angle.
 * @default 60
 *
 * @arg EasingType:str
 * @text Angle Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForAngle:eval
 * @text Wait For Angle?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for angle changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Angle_WaitForAngle
 * @text ANGLE: Wait For Angle
 * @desc Waits for angle changes to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceAnimation
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakAnimation
 * @text Action Sequences - Animations
 * @desc These Action Sequences are related to the 'Animations' that
 * can be found in the Animations tab of the Database.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ActionAnimation
 * @text ANIM: Action Animation
 * @desc Plays the animation associated with the action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_AttackAnimation
 * @text ANIM: Attack Animation
 * @desc Plays the animation associated with the user's 1st weapon.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_AttackAnimation2
 * @text ANIM: Attack Animation 2+
 * @desc Plays the animation associated with the user's other weapons.
 * Plays nothing if there is no other weapon equipped.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Slot:eval
 * @text Slot
 * @desc Which weapon slot to get this data from?
 * Main-hand weapon is weapon slot 1.
 * @default 2
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_CastAnimation
 * @text ANIM: Cast Animation
 * @desc Plays the cast animation associated with the action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ChangeBattlePortrait
 * @text ANIM: Change Battle Portrait
 * @desc Changes the battle portrait of the actor (if it's an actor).
 * Can be used outside of battle/action sequences.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to change the portraits for.
 * Valid units can only be actors.
 * @default ["user"]
 * 
 * @arg Filename:str
 * @text Filename
 * @type file
 * @dir img/pictures/
 * @desc Select the file to change the actor's portrait to.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_PlayAtCoordinate
 * @text ANIM: Play at Coordinate
 * @desc Plays an animation on the screen at a specific x, y coordinate.
 * Requires VisuMZ_0_CoreEngine!
 *
 * @arg AnimationID:num
 * @text Animation ID
 * @parent Animation
 * @type animation
 * @desc Plays this animation.
 * @default 1
 * 
 * @arg Coordinates
 *
 * @arg pointX:eval
 * @text X
 * @parent Coordinates
 * @desc X coordinate used for the animation.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 *
 * @arg pointY:eval
 * @text Y
 * @parent Coordinates
 * @desc Y coordinate used for the animation.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 *
 * @arg Mirror:eval
 * @text Mirror Animation?
 * @parent Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 *
 * @arg Mute:eval
 * @text Mute Animation?
 * @parent Animation
 * @type boolean
 * @on Mute
 * @off Normal
 * @desc Mute the animation?
 * @default false
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion?
 * @parent Animation
 * @type boolean
 * @on Wait
 * @off Normal
 * @desc Wait the animation to finish before continuing?
 * @default false
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ShowAnimation
 * @text ANIM: Show Animation
 * @desc Plays the a specific animation on unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg AnimationID:num
 * @text Animation ID
 * @type animation
 * @desc Select which animation to play on unit(s).
 * @default 1
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_WaitForAnimation
 * @text ANIM: Wait For Animation
 * @desc Causes the interpreter to wait for any animation(s) to finish.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceBattleLog
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakBattleLog
 * @text Action Sequences - Battle Log
 * @desc These Action Sequences are related to the Battle Log Window,
 * the window found at the top of the battle screen.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_AddText
 * @text BTLOG: Add Text
 * @desc Adds a new line of text into the Battle Log.
 * 
 * @arg Text:str
 * @text Text
 * @desc Add this text into the Battle Log.
 * Text codes allowed.
 * @default Insert text here.
 * 
 * @arg CopyCombatLog:eval
 * @text Copy to Combat Log?
 * @type boolean
 * @on Copy Text
 * @off Don't Copy
 * @desc Copies text to the Combat Log.
 * Requires VisuMZ_4_CombatLog
 * @default true
 *
 * @arg CombatLogIcon:num
 * @text Combat Log Icon
 * @parent CopyCombatLog:eval
 * @desc What icon would you like to bind to this entry?
 * Requires VisuMZ_4_CombatLog
 * @default 87
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_Clear
 * @text BTLOG: Clear Battle Log
 * @desc Clears all the text in the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_DisplayAction
 * @text BTLOG: Display Action
 * @desc Displays the current action in the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_PopBaseLine
 * @text BTLOG: Pop Base Line
 * @desc Removes the Battle Log's last added base line and 
 * all text up to its former location.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_PushBaseLine
 * @text BTLOG: Push Base Line
 * @desc Adds a new base line to where the Battle Log currently is at.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_Refresh
 * @text BTLOG: Refresh Battle Log
 * @desc Refreshes the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_UI
 * @text BTLOG: UI Show/Hide
 * @desc Shows or hides the Battle UI (including the Battle Log).
 * 
 * @arg ShowHide:eval
 * @text Show/Hide?
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows/hides the Battle UI.
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_WaitForBattleLog
 * @text BTLOG: Wait For Battle Log
 * @desc Causes the interpreter to wait for the Battle Log to finish.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_WaitForNewLine
 * @text BTLOG: Wait For New Line
 * @desc Causes the interpreter to wait for a new line in the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceCamera
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakCamera
 * @text Action Sequences - Camera
 * @desc Allows you to have control over the camera.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_Clamp
 * @text CAMERA: Clamp ON/OFF
 * @desc Turns battle camera clamping on/off.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Setting:eval
 * @text ON/OFF
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Turns camera clamping on/off.
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_FocusPoint
 * @text CAMERA: Focus Point
 * @desc Focus the battle camera on a certain point in the screen.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg FocusX:eval
 * @text X Coordinate
 * @desc Insert the point to focus the camera on.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @arg FocusY:eval
 * @text Y Coordinate
 * @desc Insert the point to focus the camera on.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for camera focus change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_FocusTarget
 * @text CAMERA: Focus Target(s)
 * @desc Focus the battle camera on certain battler target(s).
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to focus the battle camera on.
 * @default ["user"]
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for camera focus change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_Offset
 * @text CAMERA: Offset
 * @desc Offset the battle camera from the focus target.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @desc How much to offset the camera X by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @desc How much to offset the camera Y by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for offset change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_Reset
 * @text CAMERA: Reset
 * @desc Reset the battle camera settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg ResetFocus:eval
 * @text Reset Focus?
 * @type boolean
 * @on On
 * @off Off
 * @desc Reset the focus point?
 * @default true
 * 
 * @arg ResetOffset:eval
 * @text Reset Offset?
 * @type boolean
 * @on On
 * @off Off
 * @desc Reset the camera offset?
 * @default true
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for reset change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_WaitForCamera
 * @text CAMERA: Wait For Camera
 * @desc Waits for camera to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 *
 * @command ActionSequenceSpaceDragonbones
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreaDragonbones
 * @text Action Sequences - Dragonbones
 * @desc These Action Sequences are Dragonbones-related.
 * Requires VisuMZ_2_DragonbonesUnion!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_DB_DragonbonesMotionAni
 * @text DB: Dragonbones Animation
 * @desc Causes the unit(s) to play a Dragonbones motion animation.
 * Requires VisuMZ_2_DragonbonesUnion!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion animation.
 * @default ["user"]
 *
 * @arg MotionAni:str
 * @text Motion Animation
 * @desc What is the name of the Dragonbones motion animation you wish to play?
 * @default attack
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_DB_DragonbonesTimeScale
 * @text DB: Dragonbones Time Scale
 * @desc Causes the unit(s) to change their Dragonbones time scale.
 * Requires VisuMZ_2_DragonbonesUnion!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion animation.
 * @default ["user"]
 *
 * @arg TimeScale:num
 * @text Time Scale
 * @desc Change the value of the Dragonbones time scale to this.
 * @default 1.0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceElements
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakElements
 * @text Action Sequences - Elements
 * @desc These Action Sequences are related to elements.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_AddElements
 * @text ELE: Add Elements
 * @desc Adds element(s) to be used when calculating damage.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @arg Elements:arraynum
 * @text Elements
 * @type number[]
 * @min 1
 * @max 99
 * @desc Select which element ID to add onto the action.
 * Insert multiple element ID's to add multiple at once.
 * @default ["1"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_Clear
 * @text ELE: Clear Element Changes
 * @desc Clears all element changes made through Action Sequences.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_ForceElements
 * @text ELE: Force Elements
 * @desc Forces only specific element(s) when calculating damage.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @arg Elements:arraynum
 * @text Elements
 * @type number[]
 * @min 1
 * @max 99
 * @desc Select which element ID to force in the action.
 * Insert multiple element ID's to force multiple at once.
 * @default ["1"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_NullElements
 * @text ELE: Null Element
 * @desc Forces no element to be used when calculating damage.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceHorror
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakHorror
 * @text Action Sequences - Horror Effects
 * @desc These Action Sequences are Horror Effects-related.
 * Requires VisuMZ_2_HorrorEffects!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_Clear
 * @text HORROR: Clear All Filters
 * @desc Clear all Horror Effects filters on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove Horror Effects for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_GlitchCreate
 * @text HORROR: Glitch Create
 * @desc Creates the glitch effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create the Horror Effect for.
 * @default ["user"]
 *
 * @arg slices:num
 * @text Glitch Slices
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc Glitch slices to be used with the target.
 * @default 10
 *
 * @arg offset:num
 * @text Glitch Offset
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc Default offset value.
 * @default 100
 *
 * @arg animated:eval
 * @text Glitch Animated?
 * @parent FilterGlitch
 * @type boolean
 * @on Animate
 * @off Static
 * @desc Animate the glitch effect?
 * @default true
 *
 * @arg aniFrequency:num
 * @text Glitch Frequency
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc If animated, how frequent to make the glitch effect?
 * Lower = often     Higher = rarer
 * @default 300
 *
 * @arg aniStrength:num
 * @text Glitch Strength
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc If animated, how strong is the glitch effect?
 * Lower = weaker     Higher = stronger
 * @default 30
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_GlitchRemove
 * @text HORROR: Glitch Remove
 * @desc Removes the glitch effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove the Horror Effect for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_NoiseCreate
 * @text HORROR: Noise Create
 * @desc Creates the noise effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create the Horror Effect for.
 * @default ["user"]
 *
 * @arg noise:num
 * @text Noise Rate
 * @parent FilterNoise
 * @desc Noise rate to be used with the target.
 * @default 0.3
 *
 * @arg animated:eval
 * @text Noise Animated
 * @parent FilterNoise
 * @type boolean
 * @on Animate
 * @off Static
 * @desc Animate the noise for the target?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_NoiseRemove
 * @text HORROR: Noise Remove
 * @desc Removes the noise effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove the Horror Effect for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_TVCreate
 * @text HORROR: TV Create
 * @desc Creates the TV effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create the Horror Effect for.
 * @default ["user"]
 *
 * @arg lineWidth:num
 * @text TV Line Thickness
 * @parent FilterTV
 * @type number
 * @min 1
 * @desc Default TV line thickness
 * Lower = thinner     Higher = thicker
 * @default 5
 *
 * @arg vignetting:num
 * @text TV Corner Size
 * @parent FilterTV
 * @desc Default TV line corner size
 * Lower = smaller     Higher = bigger
 * @default 0.3
 *
 * @arg animated:eval
 * @text TV Animated
 * @parent FilterTV
 * @type boolean
 * @on Animate
 * @off Static
 * @desc Animate the TV?
 * @default true
 *
 * @arg aniSpeed:num
 * @text TV Speed
 * @parent FilterTV
 * @desc Speed used to animate the TV if animated
 * Lower = slower     Higher = faster
 * @default 0.25
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_TVRemove
 * @text HORROR: TV Remove
 * @desc Removes the TV effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove the Horror Effect for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceImpact
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakImpact
 * @text Action Sequences - Impact
 * @desc These Action Sequences are related to creating impact.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ColorBreak
 * @text IMPACT: Color Break
 * @desc Breaks the colors on the screen before reassembling.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Intensity:eval
 * @text Intensity
 * @desc What is the intensity of the color break effect?
 * @default 60
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the color break effect?
 * @default 60
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default OutBack
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionBlurScreen
 * @text IMPACT: Motion Blur Screen
 * @desc Creates a motion blur on the whole screen.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Angle:eval
 * @text Angle
 * @desc Determine what angle to make the motion blur at.
 * @default Math.randomInt(360)
 *
 * @arg Rate:eval
 * @text Intensity Rate
 * @desc This determines intensity rate of the motion blur.
 * Use a number between 0 and 1.
 * @default 0.1
 *
 * @arg Duration:num
 * @text Duration
 * @type Number
 * @min 1
 * @desc How many frames should the motion blur last?
 * What do you want to be its duration?
 * @default 30
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionBlurTarget
 * @text IMPACT: Motion Blur Target(s)
 * @desc Creates a motion blur on selected target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create motion blur effects for.
 * @default ["user"]
 *
 * @arg Angle:eval
 * @text Angle
 * @desc Determine what angle to make the motion blur at.
 * @default Math.randomInt(360)
 *
 * @arg Rate:eval
 * @text Intensity Rate
 * @desc This determines intensity rate of the motion blur.
 * Use a number between 0 and 1.
 * @default 0.5
 *
 * @arg Duration:num
 * @text Duration
 * @type Number
 * @min 1
 * @desc How many frames should the motion blur last?
 * What do you want to be its duration?
 * @default 30
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionTrailCreate
 * @text IMPACT: Motion Trail Create
 * @desc Creates a motion trail effect for the target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create motion trail effects for.
 * @default ["user"]
 *
 * @arg delay:num
 * @text Delay
 * @type Number
 * @min 1
 * @desc How many frames to delay by when creating a motion trail?
 * The higher the delay, the less after images there are.
 * @default 1
 *
 * @arg duration:num
 * @text Duration
 * @type Number
 * @min 1
 * @desc How many frames should the motion trail last?
 * What do you want to be its duration?
 * @default 30
 *
 * @arg hue:num
 * @text Hue
 * @type Number
 * @min 0
 * @max 255
 * @desc What do you want to be the hue for the motion trail?
 * @default 0
 *
 * @arg opacityStart:num
 * @text Starting Opacity
 * @type Number
 * @min 0
 * @max 255
 * @desc What starting opacity value do you want for the motion
 * trail? Opacity values decrease over time.
 * @default 200
 *
 * @arg tone:eval
 * @text Tone
 * @desc What tone do you want for the motion trail?
 * Format: [Red, Green, Blue, Gray]
 * @default [0, 0, 0, 0]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionTrailRemove
 * @text IMPACT: Motion Trail Remove
 * @desc Removes the motion trail effect from the target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to clear motion trail effects for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ShockwavePoint
 * @text IMPACT: Shockwave at Point
 * @desc Creates a shockwave at the designated coordinates.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Coordinates
 * 
 * @arg X:eval
 * @text Point: X
 * @parent Coordinates
 * @desc What x coordinate do you want to create a shockwave at?
 * You can use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @arg Y:eval
 * @text Point: Y
 * @parent Coordinates
 * @desc What y coordinate do you want to create a shockwave at?
 * You can use JavaScript code.
 * @default (Graphics.height - 200) / 2
 * 
 * @arg Amp:eval
 * @text Amplitude
 * @desc What is the aplitude of the shockwave effect?
 * @default 30
 * 
 * @arg Wave:eval
 * @text Wavelength
 * @desc What is the wavelength of the shockwave effect?
 * @default 160
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the shockwave?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ShockwaveEachTargets
 * @text IMPACT: Shockwave from Each Target(s)
 * @desc Creates a shockwave at each of the target(s) location(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to start a shockwave from.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to start a shockwave from.
 * @default middle center
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave X point by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave Y point by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Amp:eval
 * @text Amplitude
 * @desc What is the aplitude of the shockwave effect?
 * @default 30
 * 
 * @arg Wave:eval
 * @text Wavelength
 * @desc What is the wavelength of the shockwave effect?
 * @default 160
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the shockwave?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ShockwaveCenterTargets
 * @text IMPACT: Shockwave from Target(s) Center
 * @desc Creates a shockwave from the center of the target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to start a shockwave from.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to start a shockwave from.
 * @default middle center
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave X point by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave Y point by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Amp:eval
 * @text Amplitude
 * @desc What is the aplitude of the shockwave effect?
 * @default 30
 * 
 * @arg Wave:eval
 * @text Wavelength
 * @desc What is the wavelength of the shockwave effect?
 * @default 160
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the shockwave?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ZoomBlurPoint
 * @text IMPACT: Zoom Blur at Point
 * @desc Creates a zoom blur at the designated coordinates.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Coordinates
 * 
 * @arg X:eval
 * @text Point: X
 * @parent Coordinates
 * @desc What x coordinate do you want to focus the zoom at?
 * You can use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @arg Y:eval
 * @text Point: Y
 * @parent Coordinates
 * @desc What y coordinate do you want to focus the zoom at?
 * You can use JavaScript code.
 * @default (Graphics.height - 200) / 2
 * 
 * @arg Strength:eval
 * @text Zoom Strength
 * @desc What is the strength of the zoom effect?
 * Use a number between 0 and 1.
 * @default 0.5
 * 
 * @arg Radius:eval
 * @text Visible Radius
 * @desc How much of a radius should be visible from the center?
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the zoom blur?
 * @default 60
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default OutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ZoomBlurTargetCenter
 * @text IMPACT: Zoom Blur at Target(s) Center
 * @desc Creates a zoom blur at the center of targets.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to start a zoom blur from.
 * @default ["user"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to start a zoom blur from.
 * @default middle center
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @parent TargetLocation:str
 * @desc How much to offset the zoom blur X point by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @parent TargetLocation:str
 * @desc How much to offset the zoom blur Y point by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Strength:eval
 * @text Zoom Strength
 * @desc What is the strength of the zoom effect?
 * Use a number between 0 and 1.
 * @default 0.5
 * 
 * @arg Radius:eval
 * @text Visible Radius
 * @desc How much of a radius should be visible from the center?
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the zoom blur?
 * @default 60
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default OutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceMechanics
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakMechanics
 * @text Action Sequences - Mechanics
 * @desc These Action Sequences are related to various mechanics
 * related to the battle system.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_ActionEffect
 * @text MECH: Action Effect
 * @desc Causes the unit(s) to take damage/healing from action and
 * incurs any changes made such as buffs and states.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AddBuffDebuff
 * @text MECH: Add Buff/Debuff
 * @desc Adds buff(s)/debuff(s) to unit(s). 
 * Determine which parameters are affected and their durations.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the buff(s) and/or debuff(s).
 * @default ["user"]
 * 
 * @arg Buffs:arraystr
 * @text Buff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which parameter(s) to buff.
 * Insert a parameter multiple times to raise its stacks.
 * @default ["ATK"]
 *
 * @arg Debuffs:arraystr
 * @text Debuff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which parameter(s) to debuff.
 * Insert a parameter multiple times to raise its stacks.
 * @default ["DEF"]
 * 
 * @arg Turns:eval
 * @text Turns
 * @desc Number of turns to set the parameter(s) buffs to.
 * You may use JavaScript code.
 * @default 5
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AddState
 * @text MECH: Add State
 * @desc Adds state(s) to unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the buff(s).
 * @default ["user"]
 * 
 * @arg States:arraynum
 * @text States
 * @type state[]
 * @desc Select which state ID(s) to add to unit(s).
 * Insert multiple state ID's to add multiple at once.
 * @default ["4"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AnalyzeWeakness
 * @text MECH: Analyze Weakness
 * @desc Reveal elemental weakness(es) from target(s).
 * Requires VisuMZ_3_WeaknessDisplay!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to reveal elemental weaknesses for.
 * @default ["all targets"]
 * 
 * @arg Reveal:eval
 * @text Reveal
 * @desc How many elemental weaknesses do you wish to reveal?
 * You may use JavaScript code.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_ArmorPenetration
 * @text MECH: Armor Penetration
 * @desc Adds an extra layer of defensive penetration/reduction.
 * You may use JavaScript code for any of these.
 *
 * @arg ArmorPenetration
 * @text Armor/Magic Penetration
 * 
 * @arg ArPenRate:eval
 * @text Rate
 * @parent ArmorPenetration
 * @desc Penetrates an extra multiplier of armor by this value.
 * @default 0.00
 * 
 * @arg ArPenFlat:eval
 * @text Flat
 * @parent ArmorPenetration
 * @desc Penetrates a flat amount of armor by this value.
 * @default 0
 *
 * @arg ArmorReduction
 * @text Armor/Magic Reduction
 * 
 * @arg ArRedRate:eval
 * @text Rate
 * @parent ArmorReduction
 * @desc Reduces an extra multiplier of armor by this value.
 * @default 0.00
 * 
 * @arg ArRedFlat:eval
 * @text Flat
 * @parent ArmorReduction
 * @desc Reduces a flat amount of armor by this value.
 * @default 0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AtbGauge
 * @text MECH: ATB Gauge
 * @desc Alters the ATB/TPB Gauges.
 * Requires VisuMZ_2_BattleSystemATB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the ATB/TPB Gauges for.
 * @default ["all targets"]
 *
 * @arg Charging
 * 
 * @arg ChargeRate:eval
 * @text Charge Rate
 * @parent Charging
 * @desc Changes made to the ATB Gauge if it is currently charging.
 * @default -0.00
 * 
 * @arg Casting
 * 
 * @arg CastRate:eval
 * @text Cast Rate
 * @parent Casting
 * @desc Changes made to the ATB Gauge if it is currently casting.
 * @default -0.00
 * 
 * @arg Interrupt:eval
 * @text Interrupt?
 * @parent Casting
 * @type boolean
 * @on Interrupt
 * @off Don't Interrupt
 * @desc Interrupt the ATB Gauge if it is currently casting?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BoostPointsChange
 * @text MECH: Boost Points Change
 * @desc Changes Boost Points for target(s).
 * Requires VisuMZ_3_BoostAction!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the Boost Points for.
 * @default ["user"]
 * 
 * @arg BoostPoints:eval
 * @text Alter Boost Points By
 * @desc Alters the unit(s) Boost Points.
 * Positive for gaining points. Negative for losing points.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BoostPointsStoreData
 * @text MECH: Boost Store Data
 * @desc Stores the number of Boosts used this action inside a variable.
 * Requires VisuMZ_3_BoostAction!
 * 
 * @arg VariableID:num
 * @text Variable ID
 * @type variable
 * @desc Which variable do you want to store the data inside?
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BreakShieldChange
 * @text MECH: Break Shield Change
 * @desc Changes Break Shields for target(s) if not Break Stunned.
 * Requires VisuMZ_4_BreakShields!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the Break Shields for.
 * @default ["all targets"]
 * 
 * @arg BreakShields:eval
 * @text Alter Break Shields By
 * @desc Alters the unit(s) Break Shields.
 * Positive for gaining shields. Negative for losing shields.
 * @default -1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BreakShieldReset
 * @text MECH: Break Shield Reset
 * @desc Resets Break Shields for target(s) if not Break Stunned.
 * Requires VisuMZ_4_BreakShields!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to reset the Break Shields for.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BtbGain
 * @text MECH: BTB Brave Points
 * @desc Alters the target(s) Brave Points to an exact value.
 * Requires VisuMZ_2_BattleSystemBTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the ATB/TPB Gauges for.
 * @default ["all targets"]
 * 
 * @arg BravePoints:eval
 * @text Alter Brave Points By
 * @desc Alters the target(s) Brave Points.
 * Positive for gaining BP. Negative for losing BP.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_Collapse
 * @text MECH: Collapse
 * @desc Causes the unit(s) to perform its collapse animation
 * if the unit(s) has died.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to process a death collapse.
 * @default ["all targets"]
 * 
 * @arg ForceDeath:eval
 * @text Force Death
 * @type boolean
 * @on On
 * @off Off
 * @desc Force death even if the unit has not reached 0 HP?
 * This will remove immortality.
 * @default false
 * 
 * @arg WaitForEffect:eval
 * @text Wait For Effect?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for the collapse effect to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_CtbOrder
 * @text MECH: CTB Order
 * @desc Alters the CTB Turn Order.
 * Requires VisuMZ_2_BattleSystemCTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the CTB Turn Order for.
 * @default ["all targets"]
 *
 * @arg ChangeOrderBy:eval
 * @text Change Order By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_CtbSpeed
 * @text MECH: CTB Speed
 * @desc Alters the CTB Speed.
 * Requires VisuMZ_2_BattleSystemCTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the CTB Speed for.
 * @default ["all targets"]
 *
 * @arg ChargeRate:eval
 * @text Charge Rate
 * @parent Charging
 * @desc Changes made to the CTB Speed if it is currently charging.
 * @default -0.00
 * 
 * @arg CastRate:eval
 * @text Cast Rate
 * @parent Casting
 * @desc Changes made to the CTB Speed if it is currently casting.
 * @default -0.00
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_CustomDmgFormula
 * @text MECH: Custom Damage Formula
 * @desc Changes the current action's damage formula to custom.
 * This will assume the MANUAL damage style.
 * 
 * @arg Formula:str
 * @text Formula
 * @desc Changes the current action's damage formula to custom.
 * Use 'default' to revert the damage formula.
 * @default default
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_DamagePopup
 * @text MECH: Damage Popup
 * @desc Causes the unit(s) to display the current state of
 * damage received or healed.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to prompt a damage popup.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_DeathBreak
 * @text MECH: Dead Label Jump
 * @desc If the active battler is dead, jump to a specific label in the common event.
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If the active battler is dead, jump to this specific label in the common event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EnemyEscape
 * @text MECH: Enemy Escape
 * @desc Causes the enemy unit(s) to escape.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to escape.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EtbAction
 * @text MECH: ETB Energy Count
 * @desc Alters the subject team's available Energy Count.
 * Requires VisuMZ_2_BattleSystemETB!
 * 
 * @arg ActionCount:eval
 * @text Energy Count
 * @desc Alters the subject team's available Energy Count.
 * Positive for gaining energy. Negative for losing energy.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_FtbAction
 * @text MECH: FTB Action Count
 * @desc Alters the subject team's available Action Count.
 * Requires VisuMZ_2_BattleSystemFTB!
 * 
 * @arg ActionCount:eval
 * @text Action Count
 * @desc Alters the subject team's available Action Count.
 * Positive for gaining actions. Negative for losing actions.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_HpMpTp
 * @text MECH: HP, MP, TP
 * @desc Alters the HP, MP, and TP values for unit(s).
 * Positive values for healing. Negative values for damage.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["user"]
 *
 * @arg HP
 * 
 * @arg HP_Rate:eval
 * @text HP Rate
 * @parent HP
 * @desc Changes made to HP based on rate.
 * Positive values for healing. Negative values for damage.
 * @default +0.00
 * 
 * @arg HP_Flat:eval
 * @text HP Flat
 * @parent HP
 * @desc Flat changes made to HP.
 * Positive values for healing. Negative values for damage.
 * @default +0
 * 
 * @arg MP
 * 
 * @arg MP_Rate:eval
 * @text MP Rate
 * @parent MP
 * @desc Changes made to MP based on rate.
 * Positive values for healing. Negative values for damage.
 * @default +0.00
 * 
 * @arg MP_Flat:eval
 * @text MP Flat
 * @parent MP
 * @desc Flat changes made to MP.
 * Positive values for healing. Negative values for damage.
 * @default +0
 *
 * @arg TP
 * 
 * @arg TP_Rate:eval
 * @text TP Rate
 * @parent TP
 * @desc Changes made to TP based on rate.
 * Positive values for healing. Negative values for damage.
 * @default +0.00
 * 
 * @arg TP_Flat:eval
 * @text TP Flat
 * @parent TP
 * @desc Flat changes made to TP.
 * Positive values for healing. Negative values for damage.
 * @default +0
 * 
 * @arg ShowPopup:eval
 * @text Damage Popup?
 * @type boolean
 * @on On
 * @off Off
 * @desc Display a damage popup after?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_Immortal
 * @text MECH: Immortal
 * @desc Changes the immortal flag of targets. If immortal flag is
 * removed and a unit would die, collapse that unit.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Alter the immortal flag of these groups. If immortal flag
 * is removed and a unit would die, collapse that unit.
 * @default ["user","all targets"]
 * 
 * @arg Immortal:eval
 * @text Immortal
 * @type boolean
 * @on On
 * @off Off
 * @desc Turn immortal flag for unit(s) on/off?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_Multipliers
 * @text MECH: Multipliers
 * @desc Changes the multipliers for the current action.
 * You may use JavaScript code for any of these.
 *
 * @arg CriticalHit
 * @text Critical Hit%
 * 
 * @arg CriticalHitRate:eval
 * @text Rate
 * @parent CriticalHit
 * @desc Affects chance to land a critical hit by this multiplier.
 * @default 1.00
 * 
 * @arg CriticalHitFlat:eval
 * @text Flat
 * @parent CriticalHit
 * @desc Affects chance to land a critical hit by this flat bonus.
 * @default +0.00
 *
 * @arg CriticalDmg
 * @text Critical Damage
 * 
 * @arg CriticalDmgRate:eval
 * @text Rate
 * @parent CriticalDmg
 * @desc Affects critical damage by this multiplier.
 * @default 1.00
 * 
 * @arg CriticalDmgFlat:eval
 * @text Flat
 * @parent CriticalDmg
 * @desc Affects critical damage by this flat bonus.
 * @default +0.00
 *
 * @arg Damage
 * @text Damage/Healing
 * 
 * @arg DamageRate:eval
 * @text Rate
 * @parent Damage
 * @desc Sets the damage/healing multiplier for current action.
 * @default 1.00
 * 
 * @arg DamageFlat:eval
 * @text Flat
 * @parent Damage
 * @desc Sets the damage/healing bonus for current action.
 * @default +0.00
 *
 * @arg HitRate
 * @text Hit Rate
 * 
 * @arg HitRate:eval
 * @text Rate
 * @parent HitRate
 * @desc Affects chance to connect attack by this multiplier.
 * @default 1.00
 * 
 * @arg HitFlat:eval
 * @text Flat
 * @parent HitRate
 * @desc Affects chance to connect attack by this flat bonus.
 * @default +0.00
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_OtbOrder
 * @text MECH: OTB Order
 * @desc Alters the OTB Turn Order. Best used with single targets.
 * Requires VisuMZ_2_BattleSystemOTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the OTB Turn Order for.
 * @default ["all targets"]
 *
 * @arg CurrentTurn:eval
 * @text Current Turn By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +0
 *
 * @arg NextTurn:eval
 * @text Next Turn By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +1
 *
 * @arg FollowTurn:eval
 * @text Follow Turn By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_PtbAlterCost
 * @text MECH: PTB Alter Cost
 * @desc Alters the action's cost settings.
 * Requires VisuMZ_2_BattleSystemPTB!
 *
 * @arg Override:eval
 * @text Override?
 * @type boolean
 * @on Override Permanent
 * @off Require Temporary
 * @desc Overrides any 'permanent' settings for Changeability?
 * @default false
 *
 * @arg alterChange:str
 * @text Alter Changeability
 * @type select
 * @option Unchanged - Cost type is unchanged after this effect
 * @value unchanged
 * @option Permanent - Cost type can no longer be changed after
 * @value permanent
 * @option Temporary - Cost type can still be changed after
 * @value temporary
 * @desc Allow the cost type and value to be changeable?
 * @default unchanged
 *
 * @arg alterType:str
 * @text Alter Cost Type
 * @type select
 * @option Unchanged - No changes are made
 * @value unchanged
 * @option Consume - Removes half, otherwise consumes full
 * @value consume
 * @option Convert - Converts full => half, otherwise consumes half
 * @value convert
 * @option Compress - Consumes half, otherwise converts full => half
 * @value compress
 * @desc Change the cost type to this scenario.
 * Use 'Unchanged' for no changes.
 * @default convert
 *
 * @arg alterCost:eval
 * @text Alter Cost Value
 * @desc What is the default action cost for this scenario?
 * @default +0
 *
 * @param alterPriority:eval
 * @text Priority
 * @desc What is this scenario's priority? Scenario outcomes with
 * equal or lower priorities cannot override types and costs.
 * @default 50
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_PtbConvert
 * @text MECH: PTB Conversion
 * @desc Converts full actions into half actions.
 * Requires VisuMZ_2_BattleSystemPTB!
 * 
 * @arg ConvertCount:eval
 * @text Conversion Count
 * @desc Converts full actions into half actions.
 * If not enough, consume half actions.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_PtbFullHalfAction
 * @text MECH: PTB Full/Half Action(s)
 * @desc Alters the subject team's available Full/Half Actions.
 * Requires VisuMZ_2_BattleSystemPTB!
 * 
 * @arg FullActions:eval
 * @text Full Actions
 * @desc Alters the subject team's available Full Actions.
 * Positive for gaining. Negative for losing.
 * @default +0
 * 
 * @arg HalfActions:eval
 * @text Half Actions
 * @desc Alters the subject team's available Half Actions.
 * Positive for gaining. Negative for losing.
 * @default +0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_RemoveBuffDebuff
 * @text MECH: Remove Buff/Debuff
 * @desc Removes buff(s)/debuff(s) from unit(s). 
 * Determine which parameters are removed.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to have the buff(s) and/or debuff(s) removed.
 * @default ["user"]
 * 
 * @arg Buffs:arraystr
 * @text Buff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which buffed parameter(s) to remove.
 * @default ["MaxHP","MaxMP","ATK","DEF","MAT","MDF","AGI","LUK"]
 *
 * @arg Debuffs:arraystr
 * @text Debuff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which debuffed parameter(s) to remove.
 * @default ["MaxHP","MaxMP","ATK","DEF","MAT","MDF","AGI","LUK"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_RemoveState
 * @text MECH: Remove State
 * @desc Remove state(s) from unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to have states removed from.
 * @default ["user"]
 * 
 * @arg States:arraynum
 * @text States
 * @type state[]
 * @desc Select which state ID(s) to remove from unit(s).
 * Insert multiple state ID's to remove multiple at once.
 * @default ["4"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StbExploit
 * @text MECH: STB Exploit Effect
 * @desc Utilize the STB Exploitation mechanics!
 * Requires VisuMZ_2_BattleSystemSTB!
 * 
 * @arg Exploited:eval
 * @text Target(s) Exploited?
 * @type boolean
 * @on Exploit
 * @off Don't
 * @desc Exploit the below targets?
 * @default true
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to become exploited.
 * @default ["all targets"]
 * 
 * @arg ForceExploited:eval
 * @text Force Exploitation
 * @type boolean
 * @on Force
 * @off Don't
 * @desc Force the exploited status?
 * @default false
 * 
 * @arg Exploiter:eval
 * @text User Exploiter?
 * @type boolean
 * @on Exploit
 * @off Don't
 * @desc Allow the user to become the exploiter?
 * @default true
 * 
 * @arg ForceExploited:eval
 * @text Force Exploitation
 * @type boolean
 * @on Force
 * @off Don't
 * @desc Force the exploiter status?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StbExtraAction
 * @text MECH: STB Extra Action
 * @desc Adds an extra action for the currently active battler.
 * Requires VisuMZ_2_BattleSystemSTB!
 * 
 * @arg Actions:eval
 * @text Extra Actions
 * @parent Charging
 * @desc How many extra actions should the active battler gain?
 * You may use JavaScript code.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StbRemoveExcessActions
 * @text MECH: STB Remove Excess Actions
 * @desc Removes excess actions from the active battler.
 * Requires VisuMZ_2_BattleSystemSTB!
 * 
 * @arg Actions:eval
 * @text Remove Actions
 * @parent Charging
 * @desc How many actions to remove from the active battler?
 * You may use JavaScript code.
 * @default 99
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_SwapWeapon
 * @text MECH: Swap Weapon
 * @desc Causes the unit(s) to swap their weapon for another.
 * Requires VisuMZ_2_WeaponSwapSystem!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to swap weapons for.
 * @default ["user"]
 * 
 * @arg WeaponTypeID:eval
 * @text Weapon Type ID
 * @desc Which weapon type to swap to?
 * This is NOT the weapon's ID. It's the weapon TYPE.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_TextPopup
 * @text MECH: Text Popup
 * @desc Causes the unit(s) to display a text popup.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to prompt a text popup.
 * @default ["target"]
 * 
 * @arg Text:str
 * @text Text
 * @desc What text do you wish to display?
 * @default Text
 * 
 * @arg TextColor:str
 * @text Text Color
 * @parent Text:str
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default #ffffff
 *
 * @arg FlashColor:eval
 * @text Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [255, 0, 0, 160]
 * 
 * @arg FlashDuration:num
 * @text Flash Duration
 * @parent FlashColor:eval
 * @type Number
 * @desc What is the frame duration of the flash effect?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_VariablePopup
 * @text MECH: Variable Popup
 * @desc Causes the unit(s) to display a popup using the data
 * stored inside a variable.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to prompt a text popup.
 * @default ["target"]
 * 
 * @arg Variable:num
 * @text Variable ID
 * @type variable
 * @desc Get data from which variable to display as a popup?
 * @default 1
 * 
 * @arg DigitGrouping:eval
 * @text Digit Grouping
 * @parent Variable:num
 * @type boolean
 * @on Group Digits
 * @off Don't Group
 * @desc Use digit grouping to separate numbers?
 * Requires VisuMZ_0_CoreEngine!
 * @default true
 * 
 * @arg TextColor:str
 * @text Text Color
 * @parent Variable:num
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default #ffffff
 *
 * @arg FlashColor:eval
 * @text Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [0, 0, 0, 0]
 * 
 * @arg FlashDuration:num
 * @text Flash Duration
 * @parent FlashColor:eval
 * @type Number
 * @desc What is the frame duration of the flash effect?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_WaitForEffect
 * @text MECH: Wait For Effect
 * @desc Waits for the effects to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceMotion
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakMotion
 * @text Action Sequences - Motion
 * @desc These Action Sequences allow you the ability to control
 * the motions of sideview sprites.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_ClearFreezeFrame
 * @text MOTION: Clear Freeze Frame
 * @desc Clears any freeze frames from the unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to clear freeze frames for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_FreezeMotionFrame
 * @text MOTION: Freeze Motion Frame
 * @desc Forces a freeze frame instantly at the selected motion.
 * Automatically clears with a new motion.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to freeze motions for.
 * @default ["user"]
 *
 * @arg MotionType:str
 * @text Motion Type
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option attack
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Freeze this motion for the unit(s).
 * @default attack
 * 
 * @arg Frame:num
 * @text Frame Index
 * @desc Which frame do you want to freeze the motion on?
 * Frame index values start at 0.
 * @default 2
 *
 * @arg ShowWeapon:eval
 * @text Show Weapon?
 * @type combo
 * @type boolean
 * @on Show
 * @off Hide
 * @desc If using 'attack', 'thrust', 'swing', or 'missile',
 * display the weapon sprite?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_MotionType
 * @text MOTION: Motion Type
 * @desc Causes the unit(s) to play the selected motion.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion.
 * @default ["user"]
 *
 * @arg MotionType:str
 * @text Motion Type
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option attack
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default attack
 *
 * @arg ShowWeapon:eval
 * @text Show Weapon?
 * @type combo
 * @type boolean
 * @on Show
 * @off Hide
 * @desc If using 'attack', 'thrust', 'swing', or 'missile',
 * display the weapon sprite?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_PerformAction
 * @text MOTION: Perform Action
 * @desc Causes the unit(s) to play the proper motion based
 * on the current action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_RefreshMotion
 * @text MOTION: Refresh Motion
 * @desc Cancels any set motions unit(s) has to do and use
 * their most natural motion at the moment.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to refresh their motion state.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_WaitMotionFrame
 * @text MOTION: Wait By Motion Frame
 * @desc Creates a wait equal to the number of motion frames passing.
 * Time is based on Plugin Parameters => Actors => Motion Speed.
 *
 * @arg MotionFrameWait:num
 * @text Motion Frames to Wait?
 * @type number
 * @min 1
 * @desc Each "frame" is equal to the value found in
 * Plugin Parameters => Actors => Motion Speed
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceMovement
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakMovement
 * @text Action Sequences - Movement
 * @desc These Action Sequences allow you the ability to control
 * the sprites of actors and enemies in battle.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_BattleStep
 * @text MOVE: Battle Step
 * @desc Causes the unit(s) to move forward past their home position
 * to prepare for action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FaceDirection
 * @text MOVE: Face Direction
 * @desc Causes the unit(s) to face forward or backward.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 * 
 * @arg Direction:str
 * @text Direction
 * @type combo
 * @option forward
 * @option backward
 * @option random
 * @desc Select which direction to face.
 * @default forward
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FacePoint
 * @text MOVE: Face Point
 * @desc Causes the unit(s) to face a point on the screen.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 * 
 * @arg Point:str
 * @text Point
 * @type combo
 * @option home
 * @option center
 * @option point x, y
 * @desc Select which point to face.
 * Replace 'x' and 'y' with coordinates
 * @default home
 * 
 * @arg FaceAway:eval
 * @text Face Away From?
 * @type boolean
 * @on Turn Away
 * @off Face Directly
 * @desc Face away from the point instead?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FaceTarget
 * @text MOVE: Face Target(s)
 * @desc Causes the unit(s) to face other targets on the screen.
 * Sideview-only!
 * 
 * @arg Targets1:arraystr
 * @text Targets (facing)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 * 
 * @arg Targets2:arraystr
 * @text Targets (destination)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) for the turning unit(s) to face.
 * @default ["current target"]
 * 
 * @arg FaceAway:eval
 * @text Face Away From?
 * @type boolean
 * @on Turn Away
 * @off Face Directly
 * @desc Face away from the unit(s) instead?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Float
 * @text MOVE: Float
 * @desc Causes the unit(s) to float above the ground.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to make float.
 * @default ["user"]
 * 
 * @arg Height:eval
 * @text Desired Height
 * @desc Vertical distance to float upward.
 * You may use JavaScript code.
 * @default 100
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total float amount.
 * @default 12
 *
 * @arg EasingType:str
 * @text Float Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForFloat:eval
 * @text Wait For Float?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for floating to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeReset
 * @text MOVE: Home Reset
 * @desc Causes the unit(s) to move back to their home position(s)
 * and face back to their original direction(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["alive battlers"]
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Jump
 * @text MOVE: Jump
 * @desc Causes the unit(s) to jump into the air.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to make jump.
 * @default ["user"]
 * 
 * @arg Height:eval
 * @text Desired Height
 * @desc Max jump height to go above the ground
 * You may use JavaScript code.
 * @default 100
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total jump amount.
 * @default 12
 * 
 * @arg WaitForJump:eval
 * @text Wait For Jump?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for jumping to complete before performing next command?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveBy
 * @text MOVE: Move Distance
 * @desc Moves unit(s) by a distance from their current position(s).
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 *
 * @arg DistanceAdjust:str
 * @text Distance Adjustment
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to distance values to determine
 * which direction to move unit(s).
 * @default horz
 * 
 * @arg DistanceX:eval
 * @text Distance: X
 * @parent DistanceAdjust:str
 * @desc Horizontal distance to move.
 * You may use JavaScript code.
 * @default 48
 * 
 * @arg DistanceY:eval
 * @text Distance: Y
 * @parent DistanceAdjust:str
 * @desc Vertical distance to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveToPoint
 * @text MOVE: Move To Point
 * @desc Moves unit(s) to a designated point on the screen.
 * Sideview-only! Points based off Graphics.boxWidth/Height.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 * 
 * @arg Destination:str
 * @text Destination Point
 * @type combo
 * @option home
 * @option center
 * @option point x, y
 * @desc Select which point to face.
 * Replace 'x' and 'y' with coordinates
 * @default home
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Destination:str
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveToTarget
 * @text MOVE: Move To Target(s)
 * @desc Moves unit(s) to another unit(s) on the battle field.
 * Sideview-only!
 * 
 * @arg Targets1:arraystr
 * @text Targets (Moving)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 * 
 * @arg Targets2:arraystr
 * @text Targets (Destination)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move to.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to move to.
 * @default front base
 * 
 * @arg MeleeDistance:eval
 * @text Melee Distance
 * @parent TargetLocation:str
 * @desc The melee distance away from the target location
 * in addition to the battler's width.
 * @default 24
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Targets2:arraystr
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Opacity
 * @text MOVE: Opacity
 * @desc Causes the unit(s) to change opacity.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change opacity.
 * @default ["user"]
 * 
 * @arg Opacity:eval
 * @text Desired Opacity
 * @desc Change to this opacity value.
 * You may use JavaScript code.
 * @default 255
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for opacity change.
 * @default 12
 *
 * @arg EasingType:str
 * @text Opacity Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForOpacity:eval
 * @text Wait For Opacity?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for opacity changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Scale
 * @text MOVE: Scale/Grow/Shrink
 * @desc Causes the unit(s) to scale, grow, or shrink?.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change the scale of.
 * @default ["user"]
 * 
 * @arg ScaleX:eval
 * @text Scale X
 * @desc What target scale value do you want?
 * 1.0 is normal size.
 * @default 1.00
 * 
 * @arg ScaleY:eval
 * @text Scale Y
 * @desc What target scale value do you want?
 * 1.0 is normal size.
 * @default 1.00
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to scale for.
 * @default 12
 *
 * @arg EasingType:str
 * @text Scale Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForScale:eval
 * @text Wait For Scale?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for scaling to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Skew
 * @text MOVE: Skew/Distort
 * @desc Causes the unit(s) to skew.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to skew.
 * @default ["user"]
 * 
 * @arg SkewX:eval
 * @text Skew X
 * @desc X variance to skew?
 * Use small values for the best results.
 * @default 0.00
 * 
 * @arg SkewY:eval
 * @text Skew Y
 * @desc Y variance to skew?
 * Use small values for the best results.
 * @default 0.00
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to skew for.
 * @default 12
 *
 * @arg EasingType:str
 * @text Skew Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForSkew:eval
 * @text Wait For Skew?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for skew to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Spin
 * @text MOVE: Spin/Rotate
 * @desc Causes the unit(s) to spin.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to spin.
 * @default ["user"]
 * 
 * @arg Angle:eval
 * @text Angle
 * @desc How many degrees to spin?
 * @default 360
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to spin for.
 * @default 12
 *
 * @arg EasingType:str
 * @text Spin Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg RevertAngle:eval
 * @text Revert Angle on Finish
 * @type boolean
 * @on Revert
 * @off Don't
 * @desc Revert angle after spinning?
 * @default true
 * 
 * @arg WaitForSpin:eval
 * @text Wait For Spin?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for spin to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForFloat
 * @text MOVE: Wait For Float
 * @desc Waits for floating to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForJump
 * @text MOVE: Wait For Jump
 * @desc Waits for jumping to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForMovement
 * @text MOVE: Wait For Movement
 * @desc Waits for movement to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForOpacity
 * @text MOVE: Wait For Opacity
 * @desc Waits for opacity changes to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForScale
 * @text MOVE: Wait For Scale
 * @desc Waits for scaling to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForSkew
 * @text MOVE: Wait For Skew
 * @desc Waits for skewing to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForSpin
 * @text MOVE: Wait For Spin
 * @desc Waits for spinning to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceProjectile
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakProjectile
 * @text Action Sequences - Projectiles
 * @desc Create projectiles on the screen and fire them off at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Projectile_Animation
 * @text PROJECTILE: Animation
 * @desc Create an animation projectile and fire it at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * @arg Coordinates
 *
 * @arg Start:struct
 * @text Start Location
 * @parent Coordinates
 * @type struct<ProjectileStart>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"user\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Goal:struct
 * @text Goal Location
 * @parent Coordinates
 * @type struct<ProjectileGoal>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"all targets\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 * 
 * @arg Settings
 *
 * @arg AnimationID:num
 * @text Animation ID
 * @parent Settings
 * @type animation
 * @desc Determine which animation to use as a projectile.
 * @default 77
 * 
 * @arg Duration:eval
 * @text Duration
 * @parent Settings
 * @desc Duration for the projectile(s) to travel.
 * @default 20
 * 
 * @arg WaitForProjectile:eval
 * @text Wait For Projectile?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for projectile(s) to reach their destination before
 * going onto the next command?
 * @default true
 * 
 * @arg Extra:struct
 * @text Extra Settings
 * @type struct<ProjectileExAni>
 * @desc Add extra settings to the projectile?
 * @default {"AutoAngle:eval":"true","AngleOffset:eval":"+0","Arc:eval":"0","EasingType:str":"Linear","Spin:eval":"+0.0"}
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Projectile_Icon
 * @text PROJECTILE: Icon
 * @desc Create an icon projectile and fire it at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * @arg Coordinates
 *
 * @arg Start:struct
 * @text Start Location
 * @parent Coordinates
 * @type struct<ProjectileStart>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"user\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Goal:struct
 * @text Goal Location
 * @parent Coordinates
 * @type struct<ProjectileGoal>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"all targets\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 * 
 * @arg Settings
 *
 * @arg Icon:eval
 * @text Icon Index
 * @parent Settings
 * @desc Determine which icon to use as a projectile.
 * You may use JavaScript code.
 * @default 118
 * 
 * @arg Duration:eval
 * @text Duration
 * @parent Settings
 * @desc Duration for the projectile(s) to travel.
 * @default 20
 * 
 * @arg WaitForProjectile:eval
 * @text Wait For Projectile?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for projectile(s) to reach their destination before
 * going onto the next command?
 * @default true
 * 
 * @arg Extra:struct
 * @text Extra Settings
 * @type struct<ProjectileExtra>
 * @desc Add extra settings to the projectile?
 * @default {"AutoAngle:eval":"true","AngleOffset:eval":"+0","Arc:eval":"0","BlendMode:num":"0","EasingType:str":"Linear","Hue:eval":"0","Scale:eval":"1.0","Spin:eval":"+0.0"}
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Projectile_Picture
 * @text PROJECTILE: Picture
 * @desc Create a picture projectile and fire it at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * @arg Coordinates
 *
 * @arg Start:struct
 * @text Start Location
 * @parent Coordinates
 * @type struct<ProjectileStart>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"user\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Goal:struct
 * @text Goal Location
 * @parent Coordinates
 * @type struct<ProjectileGoal>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"all targets\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 * 
 * @arg Settings
 *
 * @arg Picture:str
 * @text Picture Filename
 * @parent Settings
 * @type file
 * @dir img/pictures/
 * @desc Determine which picture to use as a projectile.
 * @default Untitled
 * 
 * @arg Duration:eval
 * @text Duration
 * @parent Settings
 * @desc Duration for the projectile(s) to travel.
 * @default 20
 * 
 * @arg WaitForProjectile:eval
 * @text Wait For Projectile?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for projectile(s) to reach their destination before
 * going onto the next command?
 * @default true
 * 
 * @arg Extra:struct
 * @text Extra Settings
 * @type struct<ProjectileExtra>
 * @desc Add extra settings to the projectile?
 * @default {"AutoAngle:eval":"true","AngleOffset:eval":"+0","Arc:eval":"0","BlendMode:num":"0","EasingType:str":"Linear","Hue:eval":"0","Scale:eval":"1.0","Spin:eval":"+0.0"}
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceSkew
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakSkew
 * @text Action Sequences - Skew
 * @desc Allows you to have control over the camera skew.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_ChangeSkew
 * @text SKEW: Change Skew
 * @desc Changes the camera skew.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg SkewX:eval
 * @text Skew X
 * @desc Change the camera skew X to this value.
 * @default 0
 * 
 * @arg SkewY:eval
 * @text Skew Y
 * @desc Change the camera skew Y to this value.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to change camera skew.
 * @default 60
 *
 * @arg EasingType:str
 * @text Skew Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForSkew:eval
 * @text Wait For Skew?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for skew changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Skew_Reset
 * @text SKEW: Reset Skew
 * @desc Reset any skew settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to reset camera skew.
 * @default 60
 *
 * @arg EasingType:str
 * @text Skew Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForSkew:eval
 * @text Wait For Skew?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for skew changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Skew_WaitForSkew
 * @text SKEW: Wait For Skew
 * @desc Waits for skew changes to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceTarget
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakTarget
 * @text Action Sequences - Target
 * @desc If using a manual target by target Action Sequence,
 * these commands will give you full control over its usage.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_CurrentIndex
 * @text TARGET: Current Index
 * @desc Sets the current index to this value.
 * Then decide to jump to a label (optional).
 * 
 * @arg Index:eval
 * @text Set Index To
 * @desc Sets current targeting index to this value.
 * 0 is the starting index of a target group.
 * @default 0
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_NextTarget
 * @text TARGET: Next Target
 * @desc Moves index forward by 1 to select a new current target.
 * Then decide to jump to a label (optional).
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_PrevTarget
 * @text TARGET: Previous Target
 * @desc Moves index backward by 1 to select a new current target.
 * Then decide to jump to a label (optional).
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_RandTarget
 * @text TARGET: Random Target
 * @desc Sets index randomly to determine new currernt target.
 * Then decide to jump to a label (optional).
 * 
 * @arg ForceRandom:eval
 * @text Force Random?
 * @type boolean
 * @on On
 * @off Off
 * @desc Index cannot be its previous index amount after random.
 * @default false
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceWeapon
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakWeapon
 * @text Action Sequences - Weapon
 * @desc Allows for finer control over Dual/Multi Wielding actors.
 * Only works for Actors.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Weapon_ClearActiveWeapon
 * @text WEAPON: Clear Weapon Slot
 * @desc Clears the active weapon slot (making others valid again).
 * Only works for Actors.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @desc Select unit(s) to clear the active weapon slot for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Weapon_NextActiveWeapon
 * @text WEAPON: Next Weapon Slot
 * @desc Goes to next active weapon slot (making others invalid).
 * If next slot is weaponless, don't label jump.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @desc Select unit(s) to change the next active weapon slot for.
 * @default ["user"]
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a weapon is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Weapon_SetActiveWeapon
 * @text WEAPON: Set Weapon Slot
 * @desc Sets the active weapon slot (making others invalid).
 * Only works for Actors.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @desc Select unit(s) to change the active weapon slot for.
 * @default ["user"]
 * 
 * @arg SlotID:eval
 * @text Weapon Slot ID
 * @desc Select weapon slot to make active (making others invalid).
 * Use 0 to clear and normalize. You may use JavaScript code.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceZoom
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakZoom
 * @text Action Sequences - Zoom
 * @desc Allows you to have control over the screen zoom.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Zoom_Scale
 * @text ZOOM: Change Scale
 * @desc Changes the zoom scale.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Scale:eval
 * @text Scale
 * @desc The zoom scale to change to.
 * @default 1.0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to change battle zoom.
 * @default 60
 *
 * @arg EasingType:str
 * @text Zoom Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForZoom:eval
 * @text Wait For Zoom?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for zoom changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Zoom_Reset
 * @text ZOOM: Reset Zoom
 * @desc Reset any zoom settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to reset battle zoom.
 * @default 60
 *
 * @arg EasingType:str
 * @text Zoom Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForZoom:eval
 * @text Wait For Zoom?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for zoom changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Zoom_WaitForZoom
 * @text ZOOM: Wait For Zoom
 * @desc Waits for zoom to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceEnd
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param BattleCore
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param AutoBattle:struct
 * @text Auto Battle Settings
 * @type struct<AutoBattle>
 * @desc Settings pertaining to Auto Battle.
 * @default {"BattleDisplay":"","AutoBattleMsg:str":"Press %1 or %2 to stop Auto Battle","AutoBattleOK:str":"OK","AutoBattleCancel:str":"Cancel","AutoBattleBgType:num":"1","AutoBattleRect:func":"\"const width = Graphics.width;\\nconst height = this.calcWindowHeight(1, false);\\nconst x = 0;\\nconst y = (Graphics.height - height) / 2;\\nreturn new Rectangle(x, y, width, height);\"","Options":"","AddOption:eval":"true","AdjustRect:eval":"true","StartName:str":"Auto Battle Start","StyleName:str":"Auto Battle Style","StyleOFF:str":"Attack","StyleON:str":"Skills"}
 *
 * @param Damage:struct
 * @text Damage Settings
 * @type struct<Damage>
 * @desc Settings pertaining to damage calculations.
 * @default {"Cap":"","EnableDamageCap:eval":"false","DefaultHardCap:num":"9999","EnableSoftCap:eval":"false","DefaultSoftCap:num":"0.80","DefaultSoftScaler:num":"0.1275","Popups":"","PopupDuration:num":"128","NewPopupBottom:eval":"true","PopupPosition:str":"base","PopupOffsetX:num":"0","PopupOffsetY:num":"0","PopupShiftX:num":"8","PopupShiftY:num":"-28","hpDamageFmt:str":"-%1","hpHealingFmt:str":"+%1","mpDamageFmt:str":"-%1 %2","mpHealingFmt:str":"+%1 %2","CriticalColor:eval":"[255, 0, 0, 160]","CriticalDuration:num":"128","Formulas":"","OverallFormulaJS:func":"\"// Declare Constants\\nconst target = arguments[0];\\nconst critical = arguments[1];\\nconst item = this.item();\\n\\n// Get Base Damage\\nconst baseValue = this.evalDamageFormula(target);\\n\\n// Calculate Element Modifiers\\nlet value = baseValue * this.calcElementRate(target);\\n\\n// Calculate Physical and Magical Modifiers\\nif (this.isPhysical()) {\\n    value *= target.pdr;\\n}\\nif (this.isMagical()) {\\n    value *= target.mdr;\\n}\\n\\n// Apply Healing Modifiers\\nif (baseValue < 0) {\\n    value *= target.rec;\\n}\\n\\n// Apply Critical Modifiers\\nif (critical) {\\n    value = this.applyCritical(value);\\n}\\n\\n// Apply Variance and Guard Modifiers\\nvalue = this.applyVariance(value, item.damage.variance);\\nvalue = this.applyGuard(value, target);\\n\\n// Finalize Damage\\nvalue = Math.round(value);\\nreturn value;\"","VarianceFormulaJS:func":"\"// Declare Constants\\nconst damage = arguments[0];\\nconst variance = arguments[1];\\n\\n// Calculate Variance\\nconst amp = Math.floor(Math.max((Math.abs(damage) * variance) / 100, 0));\\nconst v = Math.randomInt(amp + 1) + Math.randomInt(amp + 1) - amp;\\n\\n// Return Damage\\nreturn damage >= 0 ? damage + v : damage - v;\"","GuardFormulaJS:func":"\"// Declare Constants\\nconst damage = arguments[0];\\nconst target = arguments[1];\\n\\n// Return Damage Early\\nconst note = this.item().note;\\nif (note.match(/<UNBLOCKABLE>/i)) return damage;\\nif (!target.isGuard()) return damage;\\nif (damage < 0) return damage;\\n\\n// Declare Guard Rate\\nlet guardRate = 0.5;\\nguardRate /= target.grd;\\n\\n// Return Damage\\nreturn damage * guardRate;\"","Critical":"","CriticalHitRateJS:func":"\"// Declare Constants\\nconst user = this.subject();\\nconst target = arguments[0];\\n\\n// Create Base Critical Rate\\nlet rate = this.subject().cri * (1 - target.cev);\\n\\n// Apply Notetags\\nconst note = this.item().note;\\nif (note.match(/<ALWAYS CRITICAL>/i)) {\\n    return 1;\\n}\\nif (note.match(/<SET CRITICAL RATE:[ ](\\\\d+)([%％])>/i)) {\\n    return Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL RATE:[ ](\\\\d+)([%％])>/i)) {\\n    rate *= Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL RATE:[ ]([\\\\+\\\\-]\\\\d+)([%％])>/i)) {\\n    rate += Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<JS CRITICAL RATE>\\\\s*([\\\\s\\\\S]*)\\\\s*<\\\\/JS CRITICAL RATE>/i)) {\\n    const code = String(RegExp.$1);\\n    try {\\n        eval(code);\\n    } catch (e) {\\n        if ($gameTemp.isPlaytest()) console.log(e);\\n    }\\n}\\n\\n// Apply LUK Buffs/Debuffs\\nconst lukStack = this.subject().buff(7);\\nrate *= 2 ** lukStack;\\n\\n// Return Rate\\nreturn rate;\"","CriticalHitMultiplier:func":"\"// Declare Constants\\nconst user = this.subject();\\nlet damage = arguments[0];\\nlet multiplier = 2.0;\\nlet bonusDamage = this.subject().luk * this.subject().cri;\\n\\n// Apply Notetags\\nconst note = this.item().note;\\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ](\\\\d+)([%％])>/i)) {\\n    multiplier = Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ]([\\\\+\\\\-]\\\\d+)([%％])>/i)) {\\n    multiplier += Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ](\\\\d+)([%％])>/i)) {\\n    bonusDamage *= Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ]([\\\\+\\\\-]\\\\d+)([%％])>/i)) {\\n    bonusDamage += bonusDamage * (RegExp.$1) / 100;\\n}\\nif (note.match(/<JS CRITICAL DAMAGE>\\\\s*([\\\\s\\\\S]*)\\\\s*<\\\\/JS CRITICAL DAMAGE>/i)) {\\n    const code = String(RegExp.$1);\\n    try {\\n        eval(code);\\n    } catch (e) {\\n        if ($gameTemp.isPlaytest()) console.log(e);\\n    }\\n}\\n\\n// Return Damage\\nreturn damage * multiplier + bonusDamage;\"","DamageStyles":"","DefaultDamageStyle:str":"Standard","DamageStyleList:arraystruct":"[\"{\\\"Name:str\\\":\\\"Standard\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Declare Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Replace Formula\\\\\\\\nlet formula = item.damage.formula;\\\\\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 0)';\\\\\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nlet value = Math.max(eval(formula), 0);\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"return this.getItemDamageAmountTextOriginal();\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"Armor Scaling\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Declare Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Replace Formula\\\\\\\\nlet formula = item.damage.formula;\\\\\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 1)';\\\\\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nlet value = Math.max(eval(formula), 0);\\\\\\\\n\\\\\\\\n// Apply Defender's Defense Parameter\\\\\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\\\\\n\\\\\\\\n    // Calculate Base Armor\\\\\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\\\\\n\\\\\\\\n    // Apply Armor to Damage\\\\\\\\n    if (armor >= 0) {\\\\\\\\n        value *= 100 / (100 + armor);\\\\\\\\n    } else {\\\\\\\\n        value *= 2 - (100 / (100 - armor));\\\\\\\\n    }\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"return this.getItemDamageAmountTextOriginal();\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"CT\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet value = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\\\\\nlet attackStat = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat =  a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nattackStat = (attackStat * 1.75) + (level ** 2 / 45.5);\\\\\\\\nvalue = attackStat * 4;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= Math.max(256 - armor, 0) / 256;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= Math.max(102.4 - armor, 0) / 128;\\\\\\\\n}\\\\\\\\nvalue *= multiplier;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"D4\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nlet stat = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    stat = a.def;\\\\\\\\n    armor = 0;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    stat = a.mdf;\\\\\\\\n    armor = 0;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage \\\\\\\\nlet value = 1.5 * Math.max(2 * stat * multiplier - armor, 1) * multiplier / 5;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"DQ\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nlet multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\nif (this.isCertainHit()) {\\\\\\\\n    let value = multiplier * Math.max(a.atk, a.mat);\\\\\\\\n    return (isNaN(value) ? 0 : value) * sign;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Get Primary Stats\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(b, armor);\\\\\\\\nlet stat = 1;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    stat = a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    stat = a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Check for Recovery\\\\\\\\nif (this.isRecover()) {\\\\\\\\n    let value = stat * multiplier * sign;\\\\\\\\n    return isNaN(value) ? 0 : value;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nlet value = 0;\\\\\\\\nif (stat < ((2 + armor) / 2)) {\\\\\\\\n    // Plink Damage\\\\\\\\n    let baseline = Math.max(stat - ((12 * (armor - stat + 1)) / stat), 5);\\\\\\\\n    value = baseline / 3;\\\\\\\\n} else {\\\\\\\\n    // Normal Damage\\\\\\\\n    let baseline = Math.max(stat - (armor / 2), 1);\\\\\\\\n    value = baseline / 2;\\\\\\\\n}\\\\\\\\nvalue *= multiplier;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF7\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Power\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare base Damage\\\\\\\\nlet baseDamage = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    baseDamage = a.atk + ((a.atk + level) / 32) * ((a.atk * level) / 32);\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    baseDamage = 6 * (a.mat + level);\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    baseDamage = 6 * (a.def + level);\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    baseDamage = 6 * (a.mdf + level);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Final Damage\\\\\\\\nlet value = baseDamage;\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nif (this.isRecover()) {\\\\\\\\n    value += 22 * power;\\\\\\\\n} else {\\\\\\\\n    value = (power * Math.max(512 - armor, 1) * baseDamage) / (16 * 512);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF8\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Power\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Damage\\\\\\\\nlet Value = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = a.atk ** 2 / 16 + a.atk;\\\\\\\\n    value *= Math.max(265 - armor, 1) / 256;\\\\\\\\n    value *= power / 16;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = a.mat + power;\\\\\\\\n    value *= Math.max(265 - armor, 1) / 4;\\\\\\\\n    value *= power / 256;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value = (power + a.def) * power / 2;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value = (power + a.mdf) * power / 2;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF9\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Damage Constant\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\nif (this.isCertainHit()) {\\\\\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Declare Main Stats\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(b, armor);\\\\\\\\nlet stat = 1;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    stat = a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    stat = a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Declare Base Damage\\\\\\\\nlet baseDamage = power;\\\\\\\\nif (this.isPhysical()) {\\\\\\\\n    baseDamage += stat;\\\\\\\\n}\\\\\\\\nif (this.isDamage() || this.isDrain()) {\\\\\\\\n    baseDamage -= armor;\\\\\\\\n    baseDamage = Math.max(1, baseDamage);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Declare Bonus Damage\\\\\\\\nlet bonusDamage = stat + (((a.level || a.luk) + stat) / 8);\\\\\\\\n\\\\\\\\n// Declare Final Damage\\\\\\\\nlet value = baseDamage * bonusDamage * sign;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF10\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Damage Constant\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\nif (this.isCertainHit()) {\\\\\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Create Damage Offense Value\\\\\\\\nlet value = power;\\\\\\\\n\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = (((a.atk ** 3) / 32) + 32) * power / 16;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = power * ((a.mat ** 2 / 6) + power) / 4;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value = power * ((a.def + power) / 2);\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value = power * ((a.mdf + power) / 2);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Apply Damage Defense Value\\\\\\\\nif (this.isDamage() || this.isDrain()) {\\\\\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\n    armor = this.applyArmorModifiers(b, armor);\\\\\\\\n    armor = Math.max(armor, 1);\\\\\\\\n    value *= ((((armor - 280.4) ** 2) / 110) / 16) / 730;\\\\\\\\n    value *= (730 - (armor * 51 - (armor ** 2) / 11) / 10) / 730;\\\\\\\\n} else if (this.isRecover()) {\\\\\\\\n    value *= -1;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"MK\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nconst denominator = Math.max(200 + armor, 1);\\\\\\\\n\\\\\\\\n// Calculate Damage \\\\\\\\nlet value = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = 200 * a.atk / denominator;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = 200 * a.mat / denominator;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value = 200 * a.def / 200;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value = 200 * a.mdf / 200;\\\\\\\\n}\\\\\\\\nvalue *= multiplier;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"MOBA\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Damage Value\\\\\\\\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\\\\\\\\n\\\\\\\\n// Apply Attacker's Offense Parameter\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value *= a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value *= a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Apply Defender's Defense Parameter\\\\\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\\\\\n\\\\\\\\n    // Calculate Base Armor\\\\\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\\\\\n\\\\\\\\n    // Apply Armor to Damage\\\\\\\\n    if (armor >= 0) {\\\\\\\\n        value *= 100 / (100 + armor);\\\\\\\\n    } else {\\\\\\\\n        value *= 2 - (100 / (100 - armor));\\\\\\\\n    }\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"PKMN\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Power\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet value = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\\\\\nlet attackStat = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat =  a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nvalue = (((((2 * level) / 5) + 2) * power * (attackStat / armor)) / 50) + 2;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\"]"}
 *
 * @param Mechanics:struct
 * @text Mechanics Settings
 * @type struct<Mechanics>
 * @desc Settings pertaining to various game mechanics.
 * @default {"ActionSpeed":"","AllowRandomSpeed:eval":"false","CalcActionSpeedJS:func":"\"// Declare Constants\\nconst agi = this.subject().agi;\\n\\n// Create Speed\\nlet speed = agi;\\nif (this.allowRandomSpeed()) {\\n    speed += Math.randomInt(Math.floor(5 + agi / 4));\\n}\\nif (this.item()) {\\n    speed += this.item().speed;\\n}\\nif (this.isAttack()) {\\n    speed += this.subject().attackSpeed();\\n}\\n\\n// Return Speed\\nreturn speed;\"","BaseTroop":"","BaseTroopIDs:arraynum":"[\"1\"]","CommonEvents":"","BattleStartEvent:num":"0","BattleEndEvent:num":"0","VictoryEvent:num":"0","DefeatEvent:num":"0","EscapeSuccessEvent:num":"0","EscapeFailEvent:num":"0","Escape":"","CalcEscapeRatioJS:func":"\"// Calculate Escape Ratio\\nlet ratio = 0.5;\\nratio *= $gameParty.agility();\\nratio /= $gameTroop.agility();\\n\\n// Return Ratio\\nreturn ratio;\"","CalcEscapeRaiseJS:func":"\"// Calculate Escape Ratio\\nlet value = 0.1;\\nvalue += $gameParty.aliveMembers().length;\\n\\n// Return Value\\nreturn value;\"","BattleJS":"","PreStartBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostStartBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","BattleVictoryJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","EscapeSuccessJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","EscapeFailureJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","BattleDefeatJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PreEndBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostEndBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","TurnJS":"","PreStartTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostStartTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PreEndTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostEndTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PreRegenerateJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostRegenerateJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","ActionJS":"","PreStartActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\"","PostStartActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\"","PreApplyJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PreDamageJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PostDamageJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PostApplyJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PreEndActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\"","PostEndActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\""}
 *
 * @param CmdWindows
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param BattleLayout:struct
 * @text Battle Layout Settings
 * @type struct<BattleLayout>
 * @desc Settings that adjust how the battle layout appears.
 * @default {"Style:str":"default","ListStyle":"","ShowFacesListStyle:eval":"true","CommandWidth:num":"192","XPStyle":"","XPActorCommandLines:num":"4","XPActorDefaultHeight:num":"64","XPSpriteYLocation:str":"name","PotraitStyle":"","ShowPortraits:eval":"true","PortraitScale:num":"0.5","BorderStyle":"","SkillItemBorderCols:num":"1","ShowPortraitsBorderStyle:eval":"true","PortraitScaleBorderStyle:num":"1.25","SkillItemWindows":"","SkillItemMiddleLayout:eval":"false","SkillItemStandardCols:num":"2"}
 *
 * @param BattleLog:struct
 * @text Battle Log Settings
 * @type struct<BattleLog>
 * @desc Settings that adjust how Window_BattleLog behaves.
 * @default {"General":"","BackColor:str":"#000000","MaxLines:num":"10","MessageWait:num":"16","TextAlign:str":"center","BattleLogRectJS:func":"\"const wx = 0;\\nconst wy = 0;\\nconst ww = Graphics.boxWidth;\\nconst wh = this.calcWindowHeight(10, false);\\nreturn new Rectangle(wx, wy, ww, wh);\"","StartTurn":"","StartTurnShow:eval":"true","StartTurnMsg:str":"Turn %1","StartTurnWait:num":"40","DisplayAction":"","ActionCenteredName:eval":"true","ActionSkillMsg1:eval":"false","ActionSkillMsg2:eval":"true","ActionItemMsg:eval":"false","ActionChanges":"","ShowCounter:eval":"true","ShowReflect:eval":"true","ShowSubstitute:eval":"true","ActionResults":"","ShowFailure:eval":"false","ShowCritical:eval":"false","ShowMissEvasion:eval":"false","ShowHpDmg:eval":"false","ShowMpDmg:eval":"false","ShowTpDmg:eval":"false","DisplayStates":"","ShowAddedState:eval":"false","ShowRemovedState:eval":"false","ShowCurrentState:eval":"false","ShowAddedBuff:eval":"false","ShowAddedDebuff:eval":"false","ShowRemovedBuff:eval":"false"}
 *
 * @param Battleback:struct
 * @text Battleback Scaling
 * @type struct<Battleback>
 * @desc Settings that adjust how battlebacks scale.
 * @default {"DefaultStyle:str":"MZ","jsOneForOne:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst scale = 1.0;\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = 0;\\nthis.y = 0;\"","jsScaleToFit:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst ratioX = this.width / this.bitmap.width;\\nconst ratioY = this.height / this.bitmap.height;\\nconst scale = Math.max(ratioX, ratioY);\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = (Graphics.width - this.width) / 2;\\nthis.y = Graphics.height - this.height;\"","jsScaleDown:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst ratioX = Math.min(1, this.width / this.bitmap.width);\\nconst ratioY = Math.min(1, this.height / this.bitmap.height);\\nconst scale = Math.max(ratioX, ratioY);\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = (Graphics.width - this.width) / 2;\\nthis.y = Graphics.height - this.height;\"","jsScale Up:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst ratioX = Math.max(1, this.width / this.bitmap.width);\\nconst ratioY = Math.max(1, this.height / this.bitmap.height);\\nconst scale = Math.max(ratioX, ratioY);\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = (Graphics.width - this.width) / 2;\\nthis.y = Graphics.height - this.height;\""}
 *
 * @param PartyCmd:struct
 * @text Party Command Window
 * @type struct<PartyCmd>
 * @desc Settings that alter the Party Command Window in battle.
 * @default {"Cmd":"","CmdStyle:str":"auto","CmdTextAlign:str":"left","CmdIconFight:num":"76","CommandAddAutoBattle:eval":"true","CmdIconAutoBattle:num":"78","CmdTextAutoBattle:str":"Auto","CommandAddOptions:eval":"true","CmdIconOptions:num":"83","ActiveTpbOptionsMessage:str":"Options Menu queued after action is complete.","CmdIconEscape:num":"82","Access":"","SkipPartyCmd:eval":"true","DisablePartyCmd:eval":"false","HelpWindow":"","HelpFight:str":"Select actions to fight.","HelpAutoBattle:str":"Sets party to Auto Battle mode.","HelpOptions:str":"Opens up the Options Menu.","HelpEscape:str":"Attempt to escape the battle."}
 *
 * @param ActorCmd:struct
 * @text Actor Command Window
 * @type struct<ActorCmd>
 * @desc Settings that alter the Actor Command Window in battle.
 * @default {"Cmd":"","CmdStyle:str":"auto","CmdTextAlign:str":"left","CmdIconItem:num":"176","IconStypeNorm:num":"78","IconStypeMagic:num":"79","BattleCmd":"","BattleCmdList:arraystr":"[\"attack\",\"skills\",\"guard\",\"item\",\"escape\"]","HelpWindow":"","HelpSkillType:str":"Opens up a list of skills under the \\C[16]%1\\C[0] category.","HelpItem:str":"Opens up a list of items that you can use.","HelpEscape:str":"Attempt to escape the battle.","HelpAutoBattle:str":"Automatically choose an action suitable for combat."}
 *
 * @param VisualBreak
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param Actor:struct
 * @text Actor Battler Settings
 * @type struct<Actor>
 * @desc Settings that alter various properties for actors.
 * @default {"Flinch":"","FlinchDistanceX:num":"12","FlinchDistanceY:num":"0","FlinchDuration:num":"6","SvBattlers":"","AnchorX:num":"0.5","AnchorY:num":"1.0","ChantStyle:eval":"true","OffsetX:num":"0","OffsetY:num":"0","MotionSpeed:num":"12","PrioritySortActive:eval":"true","PrioritySortActors:eval":"false","Shadow:eval":"true","SmoothImage:eval":"true","HomePosJS:func":"\"// Declare Constants\\nconst sprite = this;\\nconst actor = this._actor;\\nconst index = arguments[0];\\n\\n// Make Calculations\\nlet x = Math.round((Graphics.width / 2) + 192)\\nx -= Math.floor((Graphics.width - Graphics.boxWidth) / 2);\\nx += index * 32;\\nlet y = (Graphics.height - 200) - ($gameParty.maxBattleMembers() * 48);\\ny -= Math.floor((Graphics.height - Graphics.boxHeight) / 2);\\ny += index * 48;\\n\\n// Home Position Offsets\\nconst offsetNote = /<SIDEVIEW HOME OFFSET:[ ]([\\\\+\\\\-]\\\\d+),[ ]([\\\\+\\\\-]\\\\d+)>/i;\\nconst xOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$1) : 0));\\nconst yOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$2) : 0));\\nx = xOffsets.reduce((r, offset) => r + offset, x);\\ny = yOffsets.reduce((r, offset) => r + offset, y);\\n\\n// Set Home Position\\nthis.setHome(x, y);\""}
 *
 * @param Enemy:struct
 * @text Enemy Battler Settings
 * @type struct<Enemy>
 * @desc Settings that alter various properties for enemies.
 * @default {"Visual":"","AttackAnimation:num":"1","EmergeText:eval":"false","OffsetX:num":"0","OffsetY:num":"0","SmoothImage:eval":"true","SelectWindow":"","FrontViewSelect:eval":"false","SideviewSelect:eval":"true","NameFontSize:num":"22","SvBattlers":"","AllowCollapse:eval":"false","AnchorX:num":"0.5","AnchorY:num":"1.0","MotionIdle:str":"walk","Shadow:eval":"true","Width:num":"64","Height:num":"64","WtypeId:num":"0"}
 *
 * @param HpGauge:struct
 * @text HP Gauge Settings
 * @type struct<HpGauge>
 * @desc Settings that adjust the visual HP Gauge displayed in battle.
 * @default {"Display":"","ShowActorGauge:eval":"false","ShowEnemyGauge:eval":"true","RequiresDefeat:eval":"false","BTestBypass:eval":"true","Settings":"","AnchorX:num":"0.5","AnchorY:num":"1.0","Scale:num":"0.5","OffsetX:num":"0","OffsetY:num":"-3","Options":"","AddHpGaugeOption:eval":"true","AdjustRect:eval":"true","Name:str":"Show HP Gauge"}
 *
 * @param ActionSequence:struct
 * @text Action Sequence Settings
 * @type struct<ActionSequence>
 * @desc Settings that adjust how certain Action Sequences work.
 * @default {"AutoSequences":"","AutoMeleeSolo:eval":"true","AutoMeleeAoE:eval":"true","CastAnimations":"","CastCertain:num":"120","CastPhysical:num":"52","CastMagical:num":"51","CounterReflection":"","CounterPlayback:eval":"true","ReflectAnimation:num":"53","ReflectPlayback:eval":"true","Stepping":"","MeleeDistance:num":"24","StepDistanceX:num":"48","StepDistanceY:num":"0","StepDuration:num":"12"}
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * Auto Battle Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~AutoBattle:
 *
 * @param BattleDisplay
 * @text Battle Display
 *
 * @param AutoBattleMsg:str
 * @text Message
 * @parent BattleDisplay
 * @desc Message that's displayed when Auto Battle is on.
 * Text codes allowed. %1 - OK button, %2 - Cancel button
 * @default Press %1 or %2 to stop Auto Battle
 *
 * @param AutoBattleOK:str
 * @text OK Button
 * @parent BattleDisplay
 * @desc Text used to represent the OK button.
 * If VisuMZ_0_CoreEngine is present, ignore this.
 * @default OK
 *
 * @param AutoBattleCancel:str
 * @text Cancel Button
 * @parent BattleDisplay
 * @desc Text used to represent the Cancel button.
 * If VisuMZ_0_CoreEngine is present, ignore this.
 * @default Cancel
 *
 * @param AutoBattleBgType:num
 * @text Background Type
 * @parent BattleDisplay
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for Auto Battle window.
 * @default 1
 *
 * @param AutoBattleRect:func
 * @text JS: X, Y, W, H
 * @parent BattleDisplay
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const width = Graphics.width;\nconst height = this.calcWindowHeight(1, false);\nconst x = 0;\nconst y = (Graphics.height - height) / 2;\nreturn new Rectangle(x, y, width, height);"
 *
 * @param Options
 *
 * @param AddOption:eval
 * @text Add Option?
 * @parent Options
 * @type boolean
 * @on Add
 * @off Don't Add
 * @desc Add the Auto Battle options to the Options menu?
 * @default true
 *
 * @param AdjustRect:eval
 * @text Adjust Window Height
 * @parent Options
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Automatically adjust the options window height?
 * @default true
 *
 * @param StartName:str
 * @text Startup Name
 * @parent Options
 * @desc Command name of the option.
 * @default Auto Battle Start
 *
 * @param StyleName:str
 * @text Style Name
 * @parent Options
 * @desc Command name of the option.
 * @default Auto Battle Style
 *
 * @param StyleOFF:str
 * @text OFF
 * @parent StyleName:str
 * @desc Text displayed when Auto Battle Style is OFF.
 * @default Attack
 *
 * @param StyleON:str
 * @text ON
 * @parent StyleName:str
 * @desc Text displayed when Auto Battle Style is ON.
 * @default Skills
 *
 */
/* ----------------------------------------------------------------------------
 * Damage Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Damage:
 *
 * @param DamageStyles
 * @text Damage Styles
 *
 * @param DefaultDamageStyle:str
 * @text Default Style
 * @parent DamageStyles
 * @desc Which Damage Style do you want to set as default?
 * Use 'Manual' to not use any styles at all.
 * @default Standard
 *
 * @param DamageStyleList:arraystruct
 * @text Style List
 * @parent DamageStyles
 * @type struct<DamageStyle>[]
 * @desc A list of the damage styles available.
 * These are used to calculate base damage.
 * @default ["{\"Name:str\":\"Standard\",\"Formula:func\":\"\\\"// Declare Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Replace Formula\\\\nlet formula = item.damage.formula;\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 0)';\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = Math.max(eval(formula), 0);\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"return this.getItemDamageAmountTextOriginal();\\\"\"}","{\"Name:str\":\"Armor Scaling\",\"Formula:func\":\"\\\"// Declare Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Replace Formula\\\\nlet formula = item.damage.formula;\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 1)';\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = Math.max(eval(formula), 0);\\\\n\\\\n// Apply Defender's Defense Parameter\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\n\\\\n    // Calculate Base Armor\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\n\\\\n    // Apply Armor to Damage\\\\n    if (armor >= 0) {\\\\n        value *= 100 / (100 + armor);\\\\n    } else {\\\\n        value *= 2 - (100 / (100 - armor));\\\\n    }\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"return this.getItemDamageAmountTextOriginal();\\\"\"}","{\"Name:str\":\"CT\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\nlet attackStat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat =  a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    attackStat =  a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    attackStat =  a.mdf;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nattackStat = (attackStat * 1.75) + (level ** 2 / 45.5);\\\\nvalue = attackStat * 4;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= Math.max(256 - armor, 0) / 256;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= Math.max(102.4 - armor, 0) / 128;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"D4\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nlet stat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n    armor = 0;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n    armor = 0;\\\\n}\\\\n\\\\n// Calculate Damage \\\\nlet value = 1.5 * Math.max(2 * stat * multiplier - armor, 1) * multiplier / 5;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"DQ\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nlet multiplier = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    let value = multiplier * Math.max(a.atk, a.mat);\\\\n    return (isNaN(value) ? 0 : value) * sign;\\\\n}\\\\n\\\\n// Get Primary Stats\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(b, armor);\\\\nlet stat = 1;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n}\\\\n\\\\n// Check for Recovery\\\\nif (this.isRecover()) {\\\\n    let value = stat * multiplier * sign;\\\\n    return isNaN(value) ? 0 : value;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = 0;\\\\nif (stat < ((2 + armor) / 2)) {\\\\n    // Plink Damage\\\\n    let baseline = Math.max(stat - ((12 * (armor - stat + 1)) / stat), 5);\\\\n    value = baseline / 3;\\\\n} else {\\\\n    // Normal Damage\\\\n    let baseline = Math.max(stat - (armor / 2), 1);\\\\n    value = baseline / 2;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF7\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare base Damage\\\\nlet baseDamage = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    baseDamage = a.atk + ((a.atk + level) / 32) * ((a.atk * level) / 32);\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    baseDamage = 6 * (a.mat + level);\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    baseDamage = 6 * (a.def + level);\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    baseDamage = 6 * (a.mdf + level);\\\\n}\\\\n\\\\n// Calculate Final Damage\\\\nlet value = baseDamage;\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nif (this.isRecover()) {\\\\n    value += 22 * power;\\\\n} else {\\\\n    value = (power * Math.max(512 - armor, 1) * baseDamage) / (16 * 512);\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF8\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Damage\\\\nlet Value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = a.atk ** 2 / 16 + a.atk;\\\\n    value *= Math.max(265 - armor, 1) / 256;\\\\n    value *= power / 16;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = a.mat + power;\\\\n    value *= Math.max(265 - armor, 1) / 4;\\\\n    value *= power / 256;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = (power + a.def) * power / 2;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = (power + a.mdf) * power / 2;\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF9\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Constant\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\n}\\\\n\\\\n// Declare Main Stats\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(b, armor);\\\\nlet stat = 1;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n}\\\\n\\\\n// Declare Base Damage\\\\nlet baseDamage = power;\\\\nif (this.isPhysical()) {\\\\n    baseDamage += stat;\\\\n}\\\\nif (this.isDamage() || this.isDrain()) {\\\\n    baseDamage -= armor;\\\\n    baseDamage = Math.max(1, baseDamage);\\\\n}\\\\n\\\\n// Declare Bonus Damage\\\\nlet bonusDamage = stat + (((a.level || a.luk) + stat) / 8);\\\\n\\\\n// Declare Final Damage\\\\nlet value = baseDamage * bonusDamage * sign;\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF10\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Constant\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\n}\\\\n\\\\n// Create Damage Offense Value\\\\nlet value = power;\\\\n\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = (((a.atk ** 3) / 32) + 32) * power / 16;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = power * ((a.mat ** 2 / 6) + power) / 4;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = power * ((a.def + power) / 2);\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = power * ((a.mdf + power) / 2);\\\\n}\\\\n\\\\n// Apply Damage Defense Value\\\\nif (this.isDamage() || this.isDrain()) {\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(b, armor);\\\\n    armor = Math.max(armor, 1);\\\\n    value *= ((((armor - 280.4) ** 2) / 110) / 16) / 730;\\\\n    value *= (730 - (armor * 51 - (armor ** 2) / 11) / 10) / 730;\\\\n} else if (this.isRecover()) {\\\\n    value *= -1;\\\\n}\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"MK\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nconst denominator = Math.max(200 + armor, 1);\\\\n\\\\n// Calculate Damage \\\\nlet value = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = 200 * a.atk / denominator;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = 200 * a.mat / denominator;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = 200 * a.def / 200;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = 200 * a.mdf / 200;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"MOBA\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Value\\\\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\\\\n\\\\n// Apply Attacker's Offense Parameter\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value *= a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value *= a.mdf;\\\\n}\\\\n\\\\n// Apply Defender's Defense Parameter\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\n\\\\n    // Calculate Base Armor\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\n\\\\n    // Apply Armor to Damage\\\\n    if (armor >= 0) {\\\\n        value *= 100 / (100 + armor);\\\\n    } else {\\\\n        value *= 2 - (100 / (100 - armor));\\\\n    }\\\\n}\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"PKMN\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\nlet attackStat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat =  a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    attackStat =  a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    attackStat =  a.mdf;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nvalue = (((((2 * level) / 5) + 2) * power * (attackStat / armor)) / 50) + 2;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}"]
 *
 * @param Cap
 * @text Damage Cap
 *
 * @param EnableDamageCap:eval
 * @text Enable Damage Cap?
 * @parent Cap
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Put a maximum hard damage cap on how far damage can go?
 * This can be broken through the usage of notetags.
 * @default false
 *
 * @param DefaultHardCap:num
 * @text Default Hard Cap
 * @parent EnableDamageCap:eval
 * @type number
 * @min 1
 * @desc The default hard damage cap used before applying damage.
 * @default 9999
 *
 * @param EnableSoftCap:eval
 * @text Enable Soft Cap?
 * @parent Cap
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Soft caps ease in the damage values leading up to the 
 * hard damage cap. Requires hard Damage Cap enabled.
 * @default false
 *
 * @param DefaultSoftCap:num
 * @text Base Soft Cap Rate
 * @parent EnableSoftCap:eval
 * @desc The default soft damage cap used before applying damage.
 * @default 0.80
 *
 * @param DefaultSoftScaler:num
 * @text Soft Scale Constant
 * @parent EnableSoftCap:eval
 * @desc The default soft damage cap used before applying damage.
 * @default 0.1275
 *
 * @param Popups
 *
 * @param PopupDuration:num
 * @text Popup Duration
 * @parent Popups
 * @type number
 * @min 1
 * @desc Adjusts how many frames a popup stays visible.
 * @default 128
 *
 * @param NewPopupBottom:eval
 * @text Newest Popups Bottom
 * @parent Popups
 * @type boolean
 * @on Bottom
 * @off Top
 * @desc Puts the newest popups at the bottom.
 * @default true
 *
 * @param PopupPosition:str
 * @text Appear Position
 * @parent Popups
 * @type select
 * @option Head - At the top of the battler.
 * @value head
 * @option Center - At the center of the battler.
 * @value center
 * @option Base - At the foot of the battler.
 * @value base
 * @desc Selects where you want popups to appear relative to the battler.
 * @default base
 *
 * @param PopupOffsetX:num
 * @text Offset X
 * @parent Popups
 * @desc Sets how much to offset the sprites by horizontally.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param PopupOffsetY:num
 * @text Offset Y
 * @parent Popups
 * @desc Sets how much to offset the sprites by vertically.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param PopupShiftX:num
 * @text Shift X
 * @parent Popups
 * @desc Sets how much to shift the sprites by horizontally.
 * Negative values go left. Positive values go right.
 * @default 8
 *
 * @param PopupShiftY:num
 * @text Shift Y
 * @parent Popups
 * @desc Sets how much to shift the sprites by vertically.
 * Negative values go up. Positive values go down.
 * @default -28
 *
 * @param hpDamageFmt:str
 * @text HP Damage Format
 * @parent Popups
 * @desc Determines HP damage format for popup.
 * %1 - Value, %2 - HP Text
 * @default -%1
 *
 * @param hpHealingFmt:str
 * @text HP Healing Format
 * @parent Popups
 * @desc Determines HP healing format for popup.
 * %1 - Value, %2 - HP Text
 * @default +%1
 *
 * @param mpDamageFmt:str
 * @text MP Damage Format
 * @parent Popups
 * @desc Determines MP damage format for popup.
 * %1 - Value, %2 - MP Text
 * @default -%1 %2
 *
 * @param mpHealingFmt:str
 * @text MP Healing Format
 * @parent Popups
 * @desc Determines MP healing format for popup.
 * %1 - Value, %2 - MP Text
 * @default +%1 %2
 *
 * @param CriticalColor:eval
 * @text Critical Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [255, 0, 0, 160]
 *
 * @param CriticalDuration:num
 * @text Critical Duration
 * @parent Popups
 * @type number
 * @min 1
 * @desc Adjusts how many frames a the flash lasts.
 * @default 128
 *
 * @param Formulas
 *
 * @param OverallFormulaJS:func
 * @text JS: Overall Formula
 * @parent Formulas
 * @type note
 * @desc The overall formula used when calculating damage.
 * @default "// Declare Constants\nconst target = arguments[0];\nconst critical = arguments[1];\nconst item = this.item();\n\n// Get Base Damage\nconst baseValue = this.evalDamageFormula(target);\n\n// Calculate Element Modifiers\nlet value = baseValue * this.calcElementRate(target);\n\n// Calculate Physical and Magical Modifiers\nif (this.isPhysical()) {\n    value *= target.pdr;\n}\nif (this.isMagical()) {\n    value *= target.mdr;\n}\n\n// Apply Healing Modifiers\nif (baseValue < 0) {\n    value *= target.rec;\n}\n\n// Apply Critical Modifiers\nif (critical) {\n    value = this.applyCritical(value);\n}\n\n// Apply Variance and Guard Modifiers\nvalue = this.applyVariance(value, item.damage.variance);\nvalue = this.applyGuard(value, target);\n\n// Finalize Damage\nvalue = Math.round(value);\nreturn value;"
 *
 * @param VarianceFormulaJS:func
 * @text JS: Variance Formula
 * @parent Formulas
 * @type note
 * @desc The formula used when damage variance.
 * @default "// Declare Constants\nconst damage = arguments[0];\nconst variance = arguments[1];\n\n// Calculate Variance\nconst amp = Math.floor(Math.max((Math.abs(damage) * variance) / 100, 0));\nconst v = Math.randomInt(amp + 1) + Math.randomInt(amp + 1) - amp;\n\n// Return Damage\nreturn damage >= 0 ? damage + v : damage - v;"
 *
 * @param GuardFormulaJS:func
 * @text JS: Guard Formula
 * @parent Formulas
 * @type note
 * @desc The formula used when damage is guarded.
 * @default "// Declare Constants\nconst damage = arguments[0];\nconst target = arguments[1];\n\n// Return Damage Early\nconst note = this.item().note;\nif (note.match(/<UNBLOCKABLE>/i)) return damage;\nif (!target.isGuard()) return damage;\nif (damage < 0) return damage;\n\n// Declare Guard Rate\nlet guardRate = 0.5;\nguardRate /= target.grd;\n\n// Return Damage\nreturn damage * guardRate;"
 *
 * @param Critical
 * @text Critical Hits
 *
 * @param CriticalHitRateJS:func
 * @text JS: Rate Formula
 * @parent Critical
 * @type note
 * @desc The formula used to calculate Critical Hit Rates.
 * @default "// Declare Constants\nconst user = this.subject();\nconst target = arguments[0];\n\n// Create Base Critical Rate\nlet rate = this.subject().cri * (1 - target.cev);\n\n// Apply Notetags\nconst note = this.item().note;\nif (note.match(/<ALWAYS CRITICAL>/i)) {\n    return 1;\n}\nif (note.match(/<SET CRITICAL RATE:[ ](\\d+)([%％])>/i)) {\n    return Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL RATE:[ ](\\d+)([%％])>/i)) {\n    rate *= Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL RATE:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    rate += Number(RegExp.$1) / 100;\n}\nif (note.match(/<JS CRITICAL RATE>\\s*([\\s\\S]*)\\s*<\\/JS CRITICAL RATE>/i)) {\n    const code = String(RegExp.$1);\n    try {\n        eval(code);\n    } catch (e) {\n        if ($gameTemp.isPlaytest()) console.log(e);\n    }\n}\n\n// Apply LUK Buffs/Debuffs\nconst lukStack = this.subject().buff(7);\nrate *= 2 ** lukStack;\n\n// Return Rate\nreturn rate;"
 *
 * @param CriticalHitMultiplier:func
 * @text JS: Damage Formula
 * @parent Critical
 * @type note
 * @desc The formula used to calculate Critical Hit Damage modification.
 * @default "// Declare Constants\nconst user = this.subject();\nlet damage = arguments[0];\nlet multiplier = 2.0;\nlet bonusDamage = this.subject().luk * this.subject().cri;\n\n// Apply Notetags\nconst note = this.item().note;\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ](\\d+)([%％])>/i)) {\n    multiplier = Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    multiplier += Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ](\\d+)([%％])>/i)) {\n    bonusDamage *= Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    bonusDamage += bonusDamage * (RegExp.$1) / 100;\n}\nif (note.match(/<JS CRITICAL DAMAGE>\\s*([\\s\\S]*)\\s*<\\/JS CRITICAL DAMAGE>/i)) {\n    const code = String(RegExp.$1);\n    try {\n        eval(code);\n    } catch (e) {\n        if ($gameTemp.isPlaytest()) console.log(e);\n    }\n}\n\n// Return Damage\nreturn damage * multiplier + bonusDamage;"
 *
 */
/* ----------------------------------------------------------------------------
 * Damage Formula Style
 * ----------------------------------------------------------------------------
 */
/*~struct~DamageStyle:
 *
 * @param Name:str
 * @text Name
 * @desc Name of this Damage Style.
 * Used for notetags and such.
 * @default Untitled
 *
 * @param Formula:func
 * @text JS: Formula
 * @parent Name:str
 * @type note
 * @desc The base formula for this Damage Style.
 * @default "// Define Constants\nconst item = this.item();\nconst a = this.subject();\nconst b = target;\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\n\n// Create Damage Value\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\n\n// Return Value\nreturn isNaN(value) ? 0 : value;"
 *
 * @param ItemsEquipsCore
 * @text Items & Equips Core
 *
 * @param DamageType
 * @text Damage Label
 * @parent ItemsEquipsCore
 *
 * @param DamageType1:str
 * @text HP Damage
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Damage Multiplier
 *
 * @param DamageType2:str
 * @text MP Damage
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Damage Multiplier
 *
 * @param DamageType3:str
 * @text HP Recovery
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Recovery Multiplier
 *
 * @param DamageType4:str
 * @text MP Recovery
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Recovery Multiplier
 *
 * @param DamageType5:str
 * @text HP Drain
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Drain Multiplier
 *
 * @param DamageType6:str
 * @text MP Drain
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Drain Multiplier
 *
 * @param DamageDisplay:func
 * @text JS: Damage Display
 * @parent ItemsEquipsCore
 * @type note
 * @desc Code used the data displayed for this category.
 * @default "// Define Constants\nconst item = this._item;\nconst formula = item.damage.formula;\nconst a = this._tempActorA;\nconst b = this._tempActorB;\nconst user = a;\nconst target = b;\n\n// Return Value\ntry {\n    const value = Math.max(eval(formula), 0);\n    return '%1%'.format(Math.round(value * 100));\n} catch (e) {\n    if ($gameTemp.isPlaytest()) {\n        console.log('Damage Formula Error for %1'.format(this._item.name));\n    }\n    return '?????';\n}"
 *
 */
/* ----------------------------------------------------------------------------
 * Mechanics Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Mechanics:
 *
 * @param ActionSpeed
 * @text Action Speed
 *
 * @param AllowRandomSpeed:eval
 * @text Allow Random Speed?
 * @parent ActionSpeed
 * @type boolean
 * @on Allow
 * @off Disable
 * @desc Allow speed to be randomized base off the user's AGI?
 * @default false
 *
 * @param CalcActionSpeedJS:func
 * @text JS: Calculate
 * @parent ActionSpeed
 * @type note
 * @desc Code used to calculate action speed.
 * @default "// Declare Constants\nconst agi = this.subject().agi;\n\n// Create Speed\nlet speed = agi;\nif (this.allowRandomSpeed()) {\n    speed += Math.randomInt(Math.floor(5 + agi / 4));\n}\nif (this.item()) {\n    speed += this.item().speed;\n}\nif (this.isAttack()) {\n    speed += this.subject().attackSpeed();\n}\n\n// Return Speed\nreturn speed;"
 *
 * @param BaseTroop
 * @text Base Troop
 *
 * @param BaseTroopIDs:arraynum
 * @text Base Troop ID's
 * @parent BaseTroop
 * @type troop[]
 * @desc Select the Troop ID(s) to duplicate page events from for all other troops.
 * @default ["1"]
 *
 * @param CommonEvents
 * @text Common Events (on Map)
 *
 * @param BattleStartEvent:num
 * @text Pre-Battle Event
 * @parent CommonEvents
 * @type common_event
 * @desc Common Event to run before each battle on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param BattleEndEvent:num
 * @text Post-Battle Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run after each battle on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param VictoryEvent:num
 * @text Victory Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon victory on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param DefeatEvent:num
 * @text Defeat Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon defeat on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param EscapeSuccessEvent:num
 * @text Escape Success Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon escape success on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param EscapeFailEvent:num
 * @text Escape Fail Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon escape failure on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param Escape
 *
 * @param CalcEscapeRatioJS:func
 * @text JS: Calc Escape Ratio
 * @parent Escape
 * @type note
 * @desc Code used to calculate the escape success ratio.
 * @default "// Calculate Escape Ratio\nlet ratio = 0.5;\nratio *= $gameParty.agility();\nratio /= $gameTroop.agility();\n\n// Return Ratio\nreturn ratio;"
 *
 * @param CalcEscapeRaiseJS:func
 * @text JS: Calc Escape Raise
 * @parent Escape
 * @type note
 * @desc Code used to calculate how much the escape success ratio raises upon each failure.
 * @default "// Calculate Escape Ratio\nlet value = 0.1;\nvalue += $gameParty.aliveMembers().length;\n\n// Return Value\nreturn value;"
 *
 * @param Switches
 *
 * @param SwitchCritical:num
 * @text Switch: Critical
 * @parent Switches
 * @type switch
 * @desc Turns switch ON if the action performs a critical hit.
 * Switch reverts to OFF whenever an action starts.
 * @default 0
 *
 * @param SwitchMissEvade:num
 * @text Switch: Miss/Evade
 * @parent Switches
 * @type switch
 * @desc Turns switch ON if the action misses/is evaded.
 * Switch reverts to OFF whenever an action starts.
 * @default 0
 *
 * @param Variables
 *
 * @param VariableDmg:num
 * @text Variable: Damage
 * @parent Variables
 * @type variable
 * @desc Variable records target damage during action.
 * Variable reverts to 0 whenever an action starts.
 * @default 0
 *
 * @param VariableHeal:num
 * @text Variable: Healing
 * @parent Variables
 * @type variable
 * @desc Variable records target healing during action.
 * Variable reverts to 0 whenever an action starts.
 * @default 0
 *
 * @param BattleJS
 * @text JS: Battle-Related
 * 
 * @param PreStartBattleJS:func
 * @text JS: Pre-Start Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.startBattle()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostStartBattleJS:func
 * @text JS: Post-Start Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.startBattle()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 * 
 * @param BattleVictoryJS:func
 * @text JS: Battle Victory
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.processVictory()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param EscapeSuccessJS:func
 * @text JS: Escape Success
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.onEscapeSuccess()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param EscapeFailureJS:func
 * @text JS: Escape Failure
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.onEscapeFailure()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 * 
 * @param BattleDefeatJS:func
 * @text JS: Battle Defeat
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.processDefeat()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 * 
 * @param PreEndBattleJS:func
 * @text JS: Pre-End Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.endBattle()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostEndBattleJS:func
 * @text JS: Post-End Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.endBattle()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param TurnJS
 * @text JS: Turn-Related
 *
 * @param PreStartTurnJS:func
 * @text JS: Pre-Start Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: BattleManager.startTurn()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostStartTurnJS:func
 * @text JS: Post-Start Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: BattleManager.startTurn()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PreEndTurnJS:func
 * @text JS: Pre-End Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.onTurnEnd()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostEndTurnJS:func
 * @text JS: Post-End Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.onTurnEnd()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PreRegenerateJS:func
 * @text JS: Pre-Regenerate
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.regenerateAll()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostRegenerateJS:func
 * @text JS: Post-Regenerate
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.regenerateAll()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param ActionJS
 * @text JS: Action-Related
 *
 * @param PreStartActionJS:func
 * @text JS: Pre-Start Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.startAction()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PostStartActionJS:func
 * @text JS: Post-Start Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.startAction()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PreApplyJS:func
 * @text JS: Pre-Apply
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.apply()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PreDamageJS:func
 * @text JS: Pre-Damage
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.executeDamage()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PostDamageJS:func
 * @text JS: Post-Damage
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.executeDamage()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PostApplyJS:func
 * @text JS: Post-Apply
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.apply()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PreEndActionJS:func
 * @text JS: Pre-End Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.endAction()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PostEndActionJS:func
 * @text JS: Post-End Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.endAction()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 */
/* ----------------------------------------------------------------------------
 * Battle Layout Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~BattleLayout:
 *
 * @param Style:str
 * @text Battle Layout Style
 * @type select
 * @option Default - Shows actor faces in Battle Status.
 * @value default
 * @option List - Lists actors in Battle Status.
 * @value list
 * @option XP - Shows actor battlers in a stretched Battle Status.
 * @value xp
 * @option Portrait - Shows portraits in a stretched Battle Status.
 * @value portrait
 * @option Border - Displays windows around the screen border.
 * @value border
 * @option Sideview Battle UI - Requires VisuMZ_3_SideviewBattleUI
 * @value sideview_ui
 * @desc The style used for the battle layout.
 * @default default
 *
 * @param ListStyle
 * @text List Style
 * @parent Style:str
 *
 * @param ShowFacesListStyle:eval
 * @text Show Faces
 * @parent ListStyle
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows faces in List Style?
 * @default true
 *
 * @param CommandWidth:num
 * @text Command Window Width
 * @parent ListStyle
 * @type number
 * @min 1
 * @desc Determine the window width for the Party and Actor Command
 * Windows. Affects Default and List Battle Layout styles.
 * @default 192
 *
 * @param XPStyle
 * @text XP Style
 * @parent Style:str
 *
 * @param XPActorCommandLines:num
 * @text Command Lines
 * @parent XPStyle
 * @type number
 * @min 1
 * @desc Number of action lines in the Actor Command Window for the XP Style.
 * @default 4
 *
 * @param XPActorDefaultHeight:num
 * @text Sprite Height
 * @parent XPStyle
 * @type number
 * @min 1
 * @desc Default sprite height used when if the sprite's height has not been determined yet.
 * @default 64
 *
 * @param XPSpriteYLocation:str
 * @text Sprite Base Location
 * @parent XPStyle
 * @type select
 * @option Above Name - Sprite is located above the name.
 * @value name
 * @option Bottom - Sprite is located at the bottom of the window.
 * @value bottom
 * @option Centered - Sprite is centered in the window.
 * @value center
 * @option Top - Sprite is located at the top of the window.
 * @value top
 * @desc Determine where the sprite is located on the Battle Status Window.
 * @default name
 *
 * @param PotraitStyle
 * @text Portrait Style
 * @parent Style:str
 *
 * @param ShowPortraits:eval
 * @text Show Portraits?
 * @parent PotraitStyle
 * @type boolean
 * @on Portraits
 * @off Faces
 * @desc Requires VisuMZ_1_MainMenuCore.
 * Shows the actor's portrait instead of a face.
 * @default true
 *
 * @param PortraitScale:num
 * @text Portrait Scaling
 * @parent PotraitStyle
 * @desc If portraits are used, scale them by this much.
 * @default 0.5
 *
 * @param BorderStyle
 * @text Border Style
 * @parent Style:str
 *
 * @param SkillItemBorderCols:num
 * @text Columns
 * @parent BorderStyle
 * @type number
 * @min 1
 * @desc The total number of columns for Skill & Item Windows
 * in the battle scene.
 * @default 1
 *
 * @param ShowPortraitsBorderStyle:eval
 * @text Show Portraits?
 * @parent BorderStyle
 * @type boolean
 * @on Portraits
 * @off Faces
 * @desc Requires VisuMZ_1_MainMenuCore.
 * Shows the actor's portrait at the edge of the screen.
 * @default true
 *
 * @param PortraitScaleBorderStyle:num
 * @text Portrait Scaling
 * @parent BorderStyle
 * @desc If portraits are used, scale them by this much.
 * @default 1.0
 *
 * @param SkillItemWindows
 * @text Skill & Item Windows
 *
 * @param SkillItemMiddleLayout:eval
 * @text Middle Layout
 * @parent SkillItemWindows
 * @type boolean
 * @on Middle
 * @off Bottom
 * @desc Shows the Skill & Item Windows in mid-screen?
 * @default false
 *
 * @param SkillItemStandardCols:num
 * @text Columns
 * @parent SkillItemWindows
 * @type number
 * @min 1
 * @desc The total number of columns for Skill & Item Windows
 * in the battle scene.
 * @default 2
 *
 * @param StatusWindow
 * @text Status Window Elements
 *
 * @param StatusWindowName
 * @text Battler Name
 * @parent StatusWindow
 *
 * @param NameOffsetX:num
 * @text Offset: X
 * @parent StatusWindowName
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param NameOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowName
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowHpGauge
 * @text Gauge 1 (HP)
 * @parent StatusWindow
 *
 * @param HpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowHpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param HpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowHpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowMpGauge
 * @text Gauge 2 (MP)
 * @parent StatusWindow
 *
 * @param MpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowMpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param MpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowMpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowTpGauge
 * @text Gauge 3 (TP)
 * @parent StatusWindow
 *
 * @param TpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowTpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param TpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowTpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowStateIcon
 * @text State Icon
 * @parent StatusWindow
 *
 * @param StateIconOffsetX:num
 * @text Offset: X
 * @parent StatusWindowStateIcon
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StateIconOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowStateIcon
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowTpbGauge
 * @text TPB/ATB Gauge
 * @parent StatusWindow
 *
 * @param TpbGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowTpbGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param TpbGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowTpbGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowSkin
 * @text Window Skin
 * @parent StatusWindow
 *
 * @param StatusWindowSkinFilename:str
 * @text Filename
 * @parent StatusWindowSkin
 * @type file
 * @dir img/system/
 * @desc Filename used for the Battle Status Window skin.
 * Leave this empty to use the default window skin.
 * @default 
 *
 * @param StatusWindowSkinHide:eval
 * @text Hide Window Skin?
 * @parent StatusWindowSkin
 * @type boolean
 * @on No Window Skin
 * @off Default Skin
 * @desc Show/Hide the window skin for the Battle Status Window?
 * @default false
 *
 * @param StatusWindowSelectBack
 * @text Selectable Background
 * @parent StatusWindow
 *
 * @param StatusWindowSelectableBackHide:eval
 * @text Hide Selectable BG?
 * @parent StatusWindowSelectBack
 * @type boolean
 * @on No Selectable BG
 * @off Default Selectable BG
 * @desc Show/Hide the selectable background box for the Battle Status Window?
 * @default false
 *
 * @param StatusWindowAttachments
 * @text Attachments
 * @parent StatusWindow
 *
 * @param StatusWindowBackAttachment
 * @text Back Attachment
 * @parent StatusWindowAttachments
 *
 * @param StatusWindowAttachmentBack:str
 * @text Filename
 * @parent StatusWindowBackAttachment
 * @type file
 * @dir img/system/
 * @desc Filename used for an image to attach to the back of the
 * Battle Status Window. Leave empty for none.
 * @default 
 *
 * @param StatusWindowAttachmentBackOffsetX:num
 * @text Offset: X
 * @parent StatusWindowBackAttachment
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StatusWindowAttachmentBackOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowBackAttachment
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowFrontAttachment
 * @text Front Attachment
 * @parent StatusWindowAttachments
 *
 * @param StatusWindowAttachmentFront:str
 * @text Filename
 * @parent StatusWindowFrontAttachment
 * @type file
 * @dir img/system/
 * @desc Filename used for an image to attach to the front of the
 * Battle Status Window. Leave empty for none.
 * @default 
 *
 * @param StatusWindowAttachmentFrontOffsetX:num
 * @text Offset: X
 * @parent StatusWindowFrontAttachment
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StatusWindowAttachmentFrontOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowFrontAttachment
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Battle Log Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~BattleLog:
 *
 * @param General
 *
 * @param BackColor:str
 * @text Back Color
 * @parent General
 * @desc Use #rrggbb for a hex color.
 * @default #000000
 *
 * @param MaxLines:num
 * @text Max Lines
 * @parent General
 * @type number
 * @min 1
 * @desc Maximum number of lines to be displayed.
 * @default 10
 *
 * @param MessageWait:num
 * @text Message Wait
 * @parent General
 * @type number
 * @min 1
 * @desc Number of frames for a usual message wait.
 * @default 16
 *
 * @param TextAlign:str
 * @text Text Align
 * @parent General
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Window_BattleLog.
 * @default center
 *
 * @param BattleLogRectJS:func
 * @text JS: X, Y, W, H
 * @parent General
 * @type note
 * @desc Code used to determine the dimensions for the battle log.
 * @default "const wx = 0;\nconst wy = 0;\nconst ww = Graphics.boxWidth;\nconst wh = this.calcWindowHeight(10, false);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param StartTurn
 * @text Start Turn
 *
 * @param StartTurnShow:eval
 * @text Show Start Turn?
 * @parent StartTurn
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display turn changes at the start of the turn?
 * @default false
 *
 * @param StartTurnMsg:str
 * @text Start Turn Message
 * @parent StartTurn
 * @desc Message displayed at turn start.
 * %1 - Turn Count
 * @default Turn %1
 *
 * @param StartTurnWait:num
 * @text Start Turn Wait
 * @parent StartTurn
 * @type number
 * @min 1
 * @desc Number of frames to wait after a turn started.
 * @default 40
 *
 * @param DisplayAction
 * @text Display Action
 *
 * @param ActionCenteredName:eval
 * @text Show Centered Action?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display a centered text of the action name?
 * @default true
 *
 * @param ActionSkillMsg1:eval
 * @text Show Skill Message 1?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the 1st skill message?
 * @default false
 *
 * @param ActionSkillMsg2:eval
 * @text Show Skill Message 2?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the 2nd skill message?
 * @default true
 *
 * @param ActionItemMsg:eval
 * @text Show Item Message?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the item use message?
 * @default false
 *
 * @param ActionChanges
 * @text Action Changes
 *
 * @param ShowCounter:eval
 * @text Show Counter?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display counter text?
 * @default true
 *
 * @param ShowReflect:eval
 * @text Show Reflect?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display magic reflection text?
 * @default true
 *
 * @param ShowSubstitute:eval
 * @text Show Substitute?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display substitute text?
 * @default true
 *
 * @param ActionResults
 * @text Action Results
 *
 * @param ShowFailure:eval
 * @text Show No Effect?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display no effect text?
 * @default false
 *
 * @param ShowCritical:eval
 * @text Show Critical?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display critical text?
 * @default false
 *
 * @param ShowMissEvasion:eval
 * @text Show Miss/Evasion?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display miss/evasion text?
 * @default false
 *
 * @param ShowHpDmg:eval
 * @text Show HP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display HP Damage text?
 * @default false
 *
 * @param ShowMpDmg:eval
 * @text Show MP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display MP Damage text?
 * @default false
 *
 * @param ShowTpDmg:eval
 * @text Show TP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display TP Damage text?
 * @default false
 *
 * @param DisplayStates
 * @text Display States
 *
 * @param ShowAddedState:eval
 * @text Show Added States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added states text?
 * @default false
 *
 * @param ShowRemovedState:eval
 * @text Show Removed States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display removed states text?
 * @default false
 *
 * @param ShowCurrentState:eval
 * @text Show Current States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the currently affected state text?
 * @default false
 *
 * @param ShowAddedBuff:eval
 * @text Show Added Buffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added buffs text?
 * @default false
 *
 * @param ShowAddedDebuff:eval
 * @text Show Added Debuffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added debuffs text?
 * @default false
 *
 * @param ShowRemovedBuff:eval
 * @text Show Removed Buffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display removed de/buffs text?
 * @default false
 *
 */
/* ----------------------------------------------------------------------------
 * Battleback Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Battleback:
 *
 * @param DefaultStyle:str
 * @text Default Style
 * @type select
 * @option MZ (MZ's default style)
 * @value MZ
 * @option 1:1 (No Scaling)
 * @value 1:1
 * @option Scale To Fit (Scale to screen size)
 * @value ScaleToFit
 * @option Scale Down (Scale Downward if Larger than Screen)
 * @value ScaleDown
 * @option Scale Up (Scale Upward if Smaller than Screen)
 * @value ScaleUp
 * @desc The default scaling style used for battlebacks.
 * @default MZ
 *
 * @param jsOneForOne:func
 * @text JS: 1:1
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst scale = 1.0;\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = 0;\nthis.y = 0;"
 *
 * @param jsScaleToFit:func
 * @text JS: Scale To Fit
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = this.width / this.bitmap.width;\nconst ratioY = this.height / this.bitmap.height;\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 * @param jsScaleDown:func
 * @text JS: Scale Down
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = Math.min(1, this.width / this.bitmap.width);\nconst ratioY = Math.min(1, this.height / this.bitmap.height);\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 * @param jsScale Up:func
 * @text JS: Scale Up
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = Math.max(1, this.width / this.bitmap.width);\nconst ratioY = Math.max(1, this.height / this.bitmap.height);\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 */
/* ----------------------------------------------------------------------------
 * Party Command Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~PartyCmd:
 *
 * @param Cmd
 * @text Command Window
 *
 * @param CmdStyle:str
 * @text Style
 * @parent Cmd
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Party Command Window?
 * @default auto
 *
 * @param CmdTextAlign:str
 * @text Text Align
 * @parent Cmd
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Party Command Window.
 * @default left
 *
 * @param CmdIconFight:num
 * @text Fight Icon
 * @parent Cmd
 * @desc The icon used for the Fight command.
 * @default 76
 *
 * @param CommandAddAutoBattle:eval
 * @text Add Auto Battle?
 * @parent Cmd
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add the "Auto Battle" command to the Command Window?
 * @default true
 *
 * @param CmdIconAutoBattle:num
 * @text Auto Battle Icon
 * @parent CommandAddAutoBattle:eval
 * @desc The icon used for the Auto Battle command.
 * @default 78
 *
 * @param CmdTextAutoBattle:str
 * @text Auto Battle Text
 * @parent CommandAddAutoBattle:eval
 * @desc The text used for the Auto Battle command.
 * @default Auto
 *
 * @param CommandAddOptions:eval
 * @text Add Options?
 * @parent Cmd
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add the "Options" command to the Command Window?
 * @default true
 *
 * @param CmdIconOptions:num
 * @text Options Icon
 * @parent CommandAddOptions:eval
 * @desc The icon used for the Options command.
 * @default 83
 *
 * @param ActiveTpbOptionsMessage:str
 * @text Active TPB Message
 * @parent CommandAddOptions:eval
 * @desc Message that will be displayed when selecting options during the middle of an action.
 * @default Options Menu queued after action is complete.
 *
 * @param CmdIconEscape:num
 * @text Escape Icon
 * @parent Cmd
 * @desc The icon used for the Escape command.
 * @default 82
 *
 * @param Access
 *
 * @param SkipPartyCmd:eval
 * @text Skip Party Command
 * @parent Access
 * @type boolean
 * @on Skip
 * @off Don't
 * @desc DTB: Skip Party Command selection on turn start.
 * TPB: Skip Party Command selection at battle start.
 * @default true
 *
 * @param DisablePartyCmd:eval
 * @text Disable Party Command
 * @parent Access
 * @type boolean
 * @on Disable
 * @off Don't
 * @desc Disable the Party Command Window entirely?
 * @default false
 *
 * @param HelpWindow
 * @text Help Window
 *
 * @param HelpFight:str
 * @text Fight
 * @parent HelpWindow
 * @desc Text displayed when selecting a skill type.
 * %1 - Skill Type Name
 * @default Select actions to fight.
 *
 * @param HelpAutoBattle:str
 * @text Auto Battle
 * @parent HelpWindow
 * @desc Text displayed when selecting the Auto Battle command.
 * @default Sets party to Auto Battle mode.
 *
 * @param HelpOptions:str
 * @text Options
 * @parent HelpWindow
 * @desc Text displayed when selecting the Options command.
 * @default Opens up the Options Menu.
 *
 * @param HelpEscape:str
 * @text Escape
 * @parent HelpWindow
 * @desc Text displayed when selecting the escape command.
 * @default Attempt to escape the battle.
 *
 */
/* ----------------------------------------------------------------------------
 * Actor Command Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ActorCmd:
 *
 * @param Cmd
 * @text Command Window
 *
 * @param CmdStyle:str
 * @text Style
 * @parent Cmd
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Actor Command Window?
 * @default auto
 *
 * @param CmdTextAlign:str
 * @text Text Align
 * @parent Cmd
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Actor Command Window.
 * @default left
 *
 * @param CmdIconItem:num
 * @text Item Icon
 * @parent Cmd
 * @desc The icon used for the Item command.
 * @default 176
 *
 * @param IconStypeNorm:num
 * @text Normal SType Icon
 * @parent Cmd
 * @desc Icon used for normal skill types that aren't assigned any
 * icons. Ignore if VisuMZ_1_SkillsStatesCore is installed.
 * @default 78
 *
 * @param IconStypeMagic:num
 * @text Magic SType Icon
 * @parent Cmd
 * @desc Icon used for magic skill types that aren't assigned any
 * icons. Ignore if VisuMZ_1_SkillsStatesCore is installed.
 * @default 79
 *
 * @param BattleCmd
 * @text Battle Commands
 *
 * @param BattleCmdList:arraystr
 * @text Command List
 * @parent BattleCmd
 * @type combo[]
 * @option attack
 * @option skills
 * @option guard
 * @option item
 * @option party
 * @option escape
 * @option auto battle
 * @option stypes
 * @option stype: x
 * @option stype: name
 * @option all skills
 * @option skill: x
 * @option skill: name
 * @option combat log
 * @option talk
 * @option weapon swap
 * @desc List of battle commands that appear by default
 * if the <Battle Commands> notetag isn't present.
 * @default ["attack","skills","guard","party","item"]
 *
 * @param ShowCosts:eval
 * @text Show Command Costs
 * @parent BattleCmd
 * @type boolean
 * @on Show Costs
 * @off Hide Costs
 * @desc If a battle command has a resource cost, show it?
 * @default true
 *
 * @param HelpWindow
 * @text Help Window
 *
 * @param HelpSkillType:str
 * @text Skill Types
 * @parent HelpWindow
 * @desc Text displayed when selecting a skill type.
 * %1 - Skill Type Name
 * @default Opens up a list of skills under the \C[16]%1\C[0] category.
 *
 * @param HelpItem:str
 * @text Items
 * @parent HelpWindow
 * @desc Text displayed when selecting the item command.
 * @default Opens up a list of items that you can use.
 *
 * @param HelpEscape:str
 * @text Escape
 * @parent HelpWindow
 * @desc Text displayed when selecting the escape command.
 * @default Attempt to escape the battle.
 *
 * @param HelpAutoBattle:str
 * @text Auto Battle
 * @parent HelpWindow
 * @desc Text displayed when selecting the Auto Battle command.
 * @default Automatically choose an action suitable for combat.
 *
 * @param HelpParty:str
 * @text Party
 * @parent HelpWindow
 * @desc Text displayed when selecting the Party command.
 * Requires 
 * @default Automatically choose an action suitable for combat.
 *
 */
/* ----------------------------------------------------------------------------
 * Actor Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Actor:
 *
 * @param Flinch
 *
 * @param FlinchDistanceX:num
 * @text Flinch Distance X
 * @parent Flinch
 * @desc The normal X distance when flinching.
 * @default 12
 *
 * @param FlinchDistanceY:num
 * @text Flinch Distance Y
 * @parent Flinch
 * @desc The normal Y distance when flinching.
 * @default 0
 *
 * @param FlinchDuration:num
 * @text Flinch Duration
 * @parent Flinch
 * @desc The number of frames for a flinch to complete.
 * @default 6
 *
 * @param SvBattlers
 * @text Sideview Battlers
 *
 * @param AnchorX:num
 * @text Anchor: X
 * @parent SvBattlers
 * @desc Default X anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor: Y
 * @parent SvBattlers
 * @desc Default Y anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param ChantStyle:eval
 * @text Chant Style
 * @parent SvBattlers
 * @type boolean
 * @on Magical Hit Type
 * @off Magical Skill Type
 * @desc What determines the chant motion?
 * Hit type or skill type?
 * @default true
 *
 * @param OffsetX:num
 * @text Offset: X
 * @parent SvBattlers
 * @desc Offsets X position where actor is positioned.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset: Y
 * @parent SvBattlers
 * @desc Offsets Y position where actor is positioned.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param MotionSpeed:num
 * @text Motion Speed
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc The number of frames in between each motion.
 * @default 12
 *
 * @param PrioritySortActive:eval
 * @text Priority: Active
 * @parent SvBattlers
 * @type boolean
 * @on Active Actor over All Else
 * @off Active Actor is Sorted Normally
 * @desc Place the active actor on top of actor and enemy sprites.
 * @default false
 *
 * @param PrioritySortActors:eval
 * @text Priority: Actors
 * @parent SvBattlers
 * @type boolean
 * @on Actors over Enemies
 * @off Sort by Y Position
 * @desc Prioritize actors over enemies when placing sprites on top
 * of each other.
 * @default true
 *
 * @param Shadow:eval
 * @text Shadow Visible
 * @parent SvBattlers
 * @type boolean
 * @on Visible
 * @off Hidden
 * @desc Show or hide the shadow for Sideview Battlers.
 * @default true
 *
 * @param SmoothImage:eval
 * @text Smooth Image
 * @parent SvBattlers
 * @type boolean
 * @on Smooth
 * @off Pixelated
 * @desc Smooth out the battler images or pixelate them?
 * @default false
 *
 * @param HomePosJS:func
 * @text JS: Home Position
 * @parent SvBattlers
 * @type note
 * @desc Code used to calculate the home position of actors.
 * @default "// Declare Constants\nconst sprite = this;\nconst actor = this._actor;\nconst index = arguments[0];\n\n// Make Calculations\nlet x = Math.round((Graphics.width / 2) + 192)\nx -= Math.floor((Graphics.width - Graphics.boxWidth) / 2);\nx += index * 32;\nlet y = (Graphics.height - 200) - ($gameParty.maxBattleMembers() * 48);\ny -= Math.floor((Graphics.height - Graphics.boxHeight) / 2);\ny += index * 48;\n\n// Home Position Offsets\nconst offsetNote = /<SIDEVIEW HOME OFFSET:[ ]([\\+\\-]\\d+),[ ]([\\+\\-]\\d+)>/i;\nconst xOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$1) : 0));\nconst yOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$2) : 0));\nx = xOffsets.reduce((r, offset) => r + offset, x);\ny = yOffsets.reduce((r, offset) => r + offset, y);\n\n// Set Home Position\nthis.setHome(x, y);"
 *
 */
/* ----------------------------------------------------------------------------
 * Enemy Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Enemy:
 *
 * @param Visual
 *
 * @param AttackAnimation:num
 * @text Attack Animation
 * @parent Visual
 * @type animation
 * @desc Default attack animation used for enemies.
 * Use <Attack Animation: x> for custom animations.
 * @default 1
 *
 * @param EmergeText:eval
 * @text Emerge Text
 * @parent Visual
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show or hide the 'Enemy emerges!' text at the start of battle.
 * @default false
 *
 * @param OffsetX:num
 * @text Offset: X
 * @parent Visual
 * @desc Offsets X position where enemy is positioned.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset: Y
 * @parent Visual
 * @desc Offsets Y position where enemy is positioned.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param SmoothImage:eval
 * @text Smooth Image
 * @parent Visual
 * @type boolean
 * @on Smooth
 * @off Pixelated
 * @desc Smooth out the battler images or pixelate them?
 * @default true
 *
 * @param SelectWindow
 * @text Select Window
 *
 * @param LastSelected:eval
 * @text Any: Last Selected
 * @parent SelectWindow
 * @type boolean
 * @on Last Selected
 * @off FV/SV Priority
 * @desc Prioritize last selected enemy over front view or sideview settings?
 * @default true
 *
 * @param FrontViewSelect:eval
 * @text FV: Right Priority
 * @parent SelectWindow
 * @type boolean
 * @on Right
 * @off Normal
 * @desc If using frontview, auto select the enemy furthest right.
 * @default false
 *
 * @param SideviewSelect:eval
 * @text SV: Right Priority
 * @parent SelectWindow
 * @type boolean
 * @on Right
 * @off Normal
 * @desc If using sideview, auto select the enemy furthest right.
 * @default true
 * 
 * @param Name
 *
 * @param NameLegacy:eval
 * @text Legacy Option
 * @parent Name
 * @type boolean
 * @on Legacy Version
 * @off New Version (Sprite)
 * @desc Use the legacy version (window) or new version (sprite).
 * WARNING: Legacy version is no longer supported for bugs.
 * @default false
 *
 * @param NameFontSize:num
 * @text Font Size
 * @parent Name
 * @desc Font size used for enemy names.
 * @default 22
 * 
 * @param NamePosition
 * @text Name Position
 * @parent Name
 *
 * @param NameOffsetX:num
 * @text Offset X
 * @parent NamePosition
 * @desc Offset the enemy name's X position by this much.
 * Negative goes left. Positive goes right.
 * @default 0
 *
 * @param NameOffsetY:num
 * @text Offset Y
 * @parent NamePosition
 * @desc Offset the enemy name's Y position by this much.
 * Negative goes up. Positive goes down.
 * @default 0
 *
 * @param NameAttachStateIcon:eval
 * @text Attach States
 * @parent Name
 * @type boolean
 * @on Attach
 * @off Normal Position
 * @desc Attach the enemy's state icon to the enemy name?
 * @default false
 *
 * @param AttachStateOffsetX:num
 * @text Attach: Offset X
 * @parent NameAttachStateIcon:eval
 * @desc How much to offset the attached icon's X position by?
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param AttachStateOffsetY:num
 * @text Attach: Offset Y
 * @parent NameAttachStateIcon:eval
 * @desc How much to offset the attached icon's Y position by?
 * Negative goes up. Positive goes down.
 * @default +0
 * 
 * @param NameVisibility
 * @text Name Visibility
 * @parent Name
 *
 * @param NameAlwaysHidden:eval
 * @text Always Hidden
 * @parent NameVisibility
 * @type boolean
 * @on Always Hidden
 * @off No Priority
 * @desc Determines if the enemy name will always be visible.
 * Highest priority.
 * @default false
 *
 * @param NameAlwaysVisible:eval
 * @text Always Visible
 * @parent NameVisibility
 * @type boolean
 * @on Always Visible
 * @off Hide when Unselected
 * @desc Determines if the enemy name will always be visible.
 * Medium priority.
 * @default false
 *
 * @param NameAlwaysSelectOnly:eval
 * @text By Selection?
 * @parent NameVisibility
 * @type boolean
 * @on Visible when Selected
 * @off Visible when Targeting
 * @desc Determines the conditions for enemy name visibility.
 * Lowest priority.
 * @default false
 *
 * @param SvBattlers
 * @text Sideview Battlers
 *
 * @param AllowCollapse:eval
 * @text Allow Collapse
 * @parent SvBattlers
 * @type boolean
 * @on Allow
 * @off Don't
 * @desc Causes defeated enemies with SV Battler graphics
 * to "fade away" when defeated?
 * @default false
 *
 * @param AnchorX:num
 * @text Anchor: X
 * @parent SvBattlers
 * @desc Default X anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor: Y
 * @parent SvBattlers
 * @desc Default Y anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param MotionIdle:str
 * @text Motion: Idle
 * @parent SvBattlers
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Sets default idle animation used by Sideview Battlers.
 * @default walk
 *
 * @param Shadow:eval
 * @text Shadow Visible
 * @parent SvBattlers
 * @type boolean
 * @on Visible
 * @off Hidden
 * @desc Show or hide the shadow for Sideview Battlers.
 * @default true
 *
 * @param Width:num
 * @text Size: Width
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc Default width for enemies that use Sideview Battlers.
 * @default 64
 *
 * @param Height:num
 * @text Size: Height
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc Default height for enemies that use Sideview Battlers.
 * @default 64
 *
 * @param WtypeId:num
 * @text Weapon Type
 * @parent SvBattlers
 * @type number
 * @min 0
 * @desc Sets default weapon type used by Sideview Battlers.
 * Use 0 for Bare Hands.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * HP Gauge Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~HpGauge:
 *
 * @param Display
 * @text Show Gauges For
 *
 * @param ShowActorGauge:eval
 * @text Actors
 * @parent Display
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show HP Gauges over the actor sprites' heads?
 * Requires SV Actors to be visible.
 * @default true
 *
 * @param ShowEnemyGauge:eval
 * @text Enemies
 * @parent Display
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show HP Gauges over the enemy sprites' heads?
 * Can be bypassed with <Hide HP Gauge> notetag.
 * @default true
 *
 * @param RequiresDefeat:eval
 * @text Requires Defeat?
 * @parent ShowEnemyGauge:eval
 * @type boolean
 * @on Require Defeat First
 * @off No Requirement
 * @desc Requires defeating the enemy once to show HP Gauge?
 * Can be bypassed with <Show HP Gauge> notetag.
 * @default true
 *
 * @param BTestBypass:eval
 * @text Battle Test Bypass?
 * @parent RequiresDefeat:eval
 * @type boolean
 * @on Bypass
 * @off Don't Bypass
 * @desc Bypass the defeat requirement in battle test?
 * @default true
 *
 * @param Settings
 *
 * @param AnchorX:num
 * @text Anchor X
 * @parent Settings
 * @desc Where do you want the HP Gauge sprite's anchor X to be?
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor Y
 * @parent Settings
 * @desc Where do you want the HP Gauge sprite's anchor Y to be?
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param Scale:num
 * @text Scale
 * @parent Settings
 * @desc How large/small do you want the HP Gauge to be scaled?
 * @default 0.5
 *
 * @param OffsetX:num
 * @text Offset X
 * @parent Settings
 * @desc How many pixels to offset the HP Gauge's X by?
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset Y
 * @parent Settings
 * @desc How many pixels to offset the HP Gauge's Y by?
 * @default -3
 *
 * @param Options
 * @text Options
 *
 * @param AddHpGaugeOption:eval
 * @text Add Option?
 * @parent Options
 * @type boolean
 * @on Add
 * @off Don't Add
 * @desc Add the 'Show HP Gauge' option to the Options menu?
 * @default true
 *
 * @param AdjustRect:eval
 * @text Adjust Window Height
 * @parent Options
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Automatically adjust the options window height?
 * @default true
 *
 * @param Name:str
 * @text Option Name
 * @parent Options
 * @desc Command name of the option.
 * @default Show HP Gauge
 *
 */
/* ----------------------------------------------------------------------------
 * Action Sequence Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ActionSequence:
 *
 * @param AutoSequences
 * @text Automatic Sequences
 *
 * @param AutoMeleeSolo:eval
 * @text Melee Single Target
 * @parent AutoSequences
 * @type boolean
 * @on Allow
 * @off Ignore
 * @desc Allow this auto sequence for physical, single target actions?
 * @default true
 *
 * @param AutoMeleeAoE:eval
 * @text Melee Multi Target
 * @parent AutoSequences
 * @type boolean
 * @on Allow
 * @off Ignore
 * @desc Allow this auto sequence for physical, multi-target actions?
 * @default true
 *
 * @param QoL
 * @text Quality of Life
 *
 * @param AutoNotetag:eval
 * @text Auto Notetag
 * @parent QoL
 * @type boolean
 * @on Automatic
 * @off Manual
 * @desc Automatically apply the <Custom Action Sequence> notetag
 * effect to any item or skill that has a Common Event?
 * @default false
 *
 * @param CastAnimations
 * @text Cast Animations
 *
 * @param CastCertain:num
 * @text Certain Hit
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Certain Hit skills.
 * @default 120
 *
 * @param CastPhysical:num
 * @text Physical
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Physical skills.
 * @default 52
 *
 * @param CastMagical:num
 * @text Magical
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Magical skills.
 * @default 51
 *
 * @param CounterReflection
 * @text Counter/Reflect
 *
 * @param CounterPlayback:eval
 * @text Counter Back
 * @parent CounterReflection
 * @type boolean
 * @on Play Back
 * @off Ignore
 * @desc Play back the attack animation used?
 * @default true
 *
 * @param ReflectAnimation:num
 * @text Reflect Animation
 * @parent CounterReflection
 * @type animation
 * @desc Animation played when an action is reflected.
 * @default 53
 *
 * @param ReflectPlayback:eval
 * @text Reflect Back
 * @parent CounterReflection
 * @type boolean
 * @on Play Back
 * @off Ignore
 * @desc Play back the attack animation used?
 * @default true
 *
 * @param Stepping
 *
 * @param MeleeDistance:num
 * @text Melee Distance
 * @parent Stepping
 * @desc Minimum distance in pixels for Movement Action Sequences.
 * @default 24
 *
 * @param StepDistanceX:num
 * @text Step Distance X
 * @parent Stepping
 * @desc The normal X distance when stepping forward.
 * @default 48
 *
 * @param StepDistanceY:num
 * @text Step Distance Y
 * @parent Stepping
 * @desc The normal Y distance when stepping forward.
 * @default 0
 *
 * @param StepDuration:num
 * @text Step Duration
 * @parent Stepping
 * @desc The number of frames for a stepping action to complete.
 * @default 12
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Start Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileStart:
 * 
 * @param Type:str
 * @text Type
 * @type select
 * @option Target - Start from battler target(s)
 * @value target
 * @option Point - Start from a point on the screen
 * @value point
 * @desc Select where the projectile should start from.
 * @default target
 * 
 * @param Targets:arraystr
 * @text Target(s)
 * @parent Type:str
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to start the projectile from.
 * @default ["user"]
 * 
 * @param TargetCenter:eval
 * @text Centralize
 * @parent Targets:arraystr
 * @type boolean
 * @on Center Projectile
 * @off Create Each
 * @desc Create one projectile at the center of the targets?
 * Or create a projectile for each target?
 * @default false
 * 
 * @param TargetLocation:str
 * @text Target Location
 * @parent Targets:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part of the target to send the projectile from.
 * @default middle center
 * 
 * @param PointX:eval
 * @text Point X
 * @parent Type:str
 * @desc Insert the X coordinate to start the projectile at.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @param PointY:eval
 * @text Point Y
 * @parent Type:str
 * @desc Insert the Y coordinate to start the projectile at.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 * 
 * @param OffsetX:eval
 * @text Offset X
 * @desc Insert how many pixels to offset the X coordinate by.
 * You may use JavaScript code.
 * @default +0
 * 
 * @param OffsetY:eval
 * @text Offset Y
 * @desc Insert how many pixels to offset the Y coordinate by.
 * You may use JavaScript code.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Goal Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileGoal:
 * 
 * @param Type:str
 * @text Type
 * @type select
 * @option Target - Goal is battler target(s)
 * @value target
 * @option Point - Goal is a point on the screen
 * @value point
 * @desc Select where the projectile should go to.
 * @default target
 * 
 * @param Targets:arraystr
 * @text Target(s)
 * @parent Type:str
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) for projectile to go to.
 * @default ["all targets"]
 * 
 * @param TargetCenter:eval
 * @text Centralize
 * @parent Targets:arraystr
 * @type boolean
 * @on Center Projectile
 * @off Create Each
 * @desc Set goal in the center of targets?
 * Or create a projectile to go to each target?
 * @default false
 * 
 * @param TargetLocation:str
 * @text Target Location
 * @parent Targets:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part of the target to send the projectile at.
 * @default middle center
 * 
 * @param PointX:eval
 * @text Point X
 * @parent Type:str
 * @desc Insert the X coordinate to send the projectile to.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @param PointY:eval
 * @text Point Y
 * @parent Type:str
 * @desc Insert the Y coordinate to send the projectile to.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 * 
 * @param OffsetX:eval
 * @text Offset X
 * @desc Insert how many pixels to offset the X coordinate by.
 * You may use JavaScript code.
 * @default +0
 * 
 * @param OffsetY:eval
 * @text Offset Y
 * @desc Insert how many pixels to offset the Y coordinate by.
 * You may use JavaScript code.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Extra Animation Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileExAni:
 * 
 * @param AutoAngle:eval
 * @text Auto Angle?
 * @parent Settings
 * @type boolean
 * @on Automatically Angle
 * @off Normal
 * @desc Automatically angle the projectile to tilt the direction it's moving?
 * @default true
 * 
 * @param AngleOffset:eval
 * @text Angle Offset
 * @desc Alter the projectile's tilt by this many degrees.
 * @default +0
 * 
 * @param Arc:eval
 * @text Arc Peak
 * @parent Settings
 * @desc This is the height of the project's trajectory arc
 * in pixels.
 * @default 0
 *
 * @param EasingType:str
 * @text Easing
 * @parent Settings
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type to apply to the projectile's trajectory.
 * @default Linear
 * 
 * @param Spin:eval
 * @text Spin Speed
 * @parent Settings
 * @desc Determine how much angle the projectile spins per frame.
 * Does not work well with "Auto Angle".
 * @default +0.0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Extra Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileExtra:
 * 
 * @param AutoAngle:eval
 * @text Auto Angle?
 * @parent Settings
 * @type boolean
 * @on Automatically Angle
 * @off Normal
 * @desc Automatically angle the projectile to tilt the direction it's moving?
 * @default true
 * 
 * @param AngleOffset:eval
 * @text Angle Offset
 * @desc Alter the projectile's tilt by this many degrees.
 * @default +0
 * 
 * @param Arc:eval
 * @text Arc Peak
 * @parent Settings
 * @desc This is the height of the project's trajectory arc
 * in pixels.
 * @default 0
 *
 * @param BlendMode:num
 * @text Blend Mode
 * @type select
 * @option 0 - Normal
 * @value 0
 * @option 1 - Additive
 * @value 1
 * @option 2 - Multiply
 * @value 2
 * @option 3 - Screen
 * @value 3
 * @desc What kind of blend mode do you wish to apply to the projectile?
 * @default 0
 *
 * @param EasingType:str
 * @text Easing
 * @parent Settings
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type to apply to the projectile's trajectory.
 * @default Linear
 * 
 * @param Hue:eval
 * @text Hue
 * @parent Settings
 * @desc Adjust the hue of the projectile.
 * Insert a number between 0 and 360.
 * @default 0
 * 
 * @param Scale:eval
 * @text Scale
 * @parent Settings
 * @desc Adjust the size scaling of the projectile.
 * Use decimals for exact control.
 * @default 1.0
 * 
 * @param Spin:eval
 * @text Spin Speed
 * @parent Settings
 * @desc Determine how much angle the projectile spins per frame.
 * Does not work well with "Auto Angle".
 * @default +0.0
 *
 */
//=============================================================================

const _0x251720=_0x2c58;(function(_0x4d22a1,_0x15a931){const _0x3c22d8=_0x2c58,_0x582349=_0x4d22a1();while(!![]){try{const _0x1a3cf2=parseInt(_0x3c22d8(0xa5a))/0x1+-parseInt(_0x3c22d8(0xf1))/0x2+parseInt(_0x3c22d8(0x812))/0x3*(parseInt(_0x3c22d8(0xa22))/0x4)+parseInt(_0x3c22d8(0xac6))/0x5+parseInt(_0x3c22d8(0x487))/0x6+-parseInt(_0x3c22d8(0x6b9))/0x7*(parseInt(_0x3c22d8(0x666))/0x8)+parseInt(_0x3c22d8(0x955))/0x9*(parseInt(_0x3c22d8(0x414))/0xa);if(_0x1a3cf2===_0x15a931)break;else _0x582349['push'](_0x582349['shift']());}catch(_0x1a8804){_0x582349['push'](_0x582349['shift']());}}}(_0x477f,0x83bc3));var label=_0x251720(0x731),tier=tier||0x0,dependencies=[],pluginData=$plugins[_0x251720(0x778)](function(_0xdc99ba){const _0x32bb2c=_0x251720;return _0xdc99ba[_0x32bb2c(0x4ea)]&&_0xdc99ba['description'][_0x32bb2c(0x9b0)]('['+label+']');})[0x0];VisuMZ[label][_0x251720(0x825)]=VisuMZ[label][_0x251720(0x825)]||{},VisuMZ[_0x251720(0xa0c)]=function(_0x41e9bf,_0x4751e0){const _0x4c92dd=_0x251720;for(const _0x42faaf in _0x4751e0){if(_0x4c92dd(0xa24)===_0x4c92dd(0xa24)){if(_0x42faaf[_0x4c92dd(0x591)](/(.*):(.*)/i)){if(_0x4c92dd(0x565)!==_0x4c92dd(0x3a3)){const _0x59ce07=String(RegExp['$1']),_0x166a23=String(RegExp['$2'])[_0x4c92dd(0x62a)]()[_0x4c92dd(0x30b)]();let _0x8907e5,_0x3f36f5,_0x3b52ea;switch(_0x166a23){case _0x4c92dd(0xfa):_0x8907e5=_0x4751e0[_0x42faaf]!==''?Number(_0x4751e0[_0x42faaf]):0x0;break;case'ARRAYNUM':_0x3f36f5=_0x4751e0[_0x42faaf]!==''?JSON[_0x4c92dd(0xa31)](_0x4751e0[_0x42faaf]):[],_0x8907e5=_0x3f36f5[_0x4c92dd(0x259)](_0x2c43f5=>Number(_0x2c43f5));break;case'EVAL':_0x8907e5=_0x4751e0[_0x42faaf]!==''?eval(_0x4751e0[_0x42faaf]):null;break;case'ARRAYEVAL':_0x3f36f5=_0x4751e0[_0x42faaf]!==''?JSON[_0x4c92dd(0xa31)](_0x4751e0[_0x42faaf]):[],_0x8907e5=_0x3f36f5[_0x4c92dd(0x259)](_0xfe70c9=>eval(_0xfe70c9));break;case _0x4c92dd(0x71b):_0x8907e5=_0x4751e0[_0x42faaf]!==''?JSON[_0x4c92dd(0xa31)](_0x4751e0[_0x42faaf]):'';break;case _0x4c92dd(0xa39):_0x3f36f5=_0x4751e0[_0x42faaf]!==''?JSON[_0x4c92dd(0xa31)](_0x4751e0[_0x42faaf]):[],_0x8907e5=_0x3f36f5[_0x4c92dd(0x259)](_0x2319ac=>JSON['parse'](_0x2319ac));break;case _0x4c92dd(0x578):_0x8907e5=_0x4751e0[_0x42faaf]!==''?new Function(JSON['parse'](_0x4751e0[_0x42faaf])):new Function(_0x4c92dd(0x282));break;case _0x4c92dd(0x5dc):_0x3f36f5=_0x4751e0[_0x42faaf]!==''?JSON[_0x4c92dd(0xa31)](_0x4751e0[_0x42faaf]):[],_0x8907e5=_0x3f36f5[_0x4c92dd(0x259)](_0x1de26c=>new Function(JSON[_0x4c92dd(0xa31)](_0x1de26c)));break;case _0x4c92dd(0xa20):_0x8907e5=_0x4751e0[_0x42faaf]!==''?String(_0x4751e0[_0x42faaf]):'';break;case _0x4c92dd(0xa8c):_0x3f36f5=_0x4751e0[_0x42faaf]!==''?JSON[_0x4c92dd(0xa31)](_0x4751e0[_0x42faaf]):[],_0x8907e5=_0x3f36f5[_0x4c92dd(0x259)](_0x4d4cc1=>String(_0x4d4cc1));break;case _0x4c92dd(0x3d1):_0x3b52ea=_0x4751e0[_0x42faaf]!==''?JSON[_0x4c92dd(0xa31)](_0x4751e0[_0x42faaf]):{},_0x41e9bf[_0x59ce07]={},VisuMZ[_0x4c92dd(0xa0c)](_0x41e9bf[_0x59ce07],_0x3b52ea);continue;case _0x4c92dd(0x9ff):_0x3f36f5=_0x4751e0[_0x42faaf]!==''?JSON[_0x4c92dd(0xa31)](_0x4751e0[_0x42faaf]):[],_0x8907e5=_0x3f36f5[_0x4c92dd(0x259)](_0x5aa896=>VisuMZ[_0x4c92dd(0xa0c)]({},JSON[_0x4c92dd(0xa31)](_0x5aa896)));break;default:continue;}_0x41e9bf[_0x59ce07]=_0x8907e5;}else{if(!this[_0x4c92dd(0x397)])return![];if(this[_0x4c92dd(0x397)][_0x4c92dd(0x4f2)]())return!![];const _0x32d627=this[_0x4c92dd(0x397)][_0x4c92dd(0xa80)]()[_0x4c92dd(0x67f)];if(_0x32d627[_0x4c92dd(0x591)](/<SHOW HP GAUGE>/i))return!![];if(_0x32d627[_0x4c92dd(0x591)](/<HIDE HP GAUGE>/i))return![];const _0x1b8b36=_0x22b5a6['BattleCore']['Settings'][_0x4c92dd(0x2df)];if(_0x1b8b36[_0x4c92dd(0x7d3)]){if(_0x1b8b36[_0x4c92dd(0xd7)]&&_0x13426c[_0x4c92dd(0x220)]())return!![];if(this['_battler'][_0x4c92dd(0x8ce)])return![];return this['_battler'][_0x4c92dd(0x278)]();}return!![];}}}else this[_0x4c92dd(0x141)](_0x4c92dd(0x1b5),_0x1de604,_0x468cee);}return _0x41e9bf;},(_0x2b95eb=>{const _0x119241=_0x251720,_0x21fed6=_0x2b95eb[_0x119241(0x1f8)];for(const _0x4dbfe3 of dependencies){if(!Imported[_0x4dbfe3]){alert(_0x119241(0x178)[_0x119241(0x8d6)](_0x21fed6,_0x4dbfe3)),SceneManager[_0x119241(0x9fa)]();break;}}const _0x9f576a=_0x2b95eb[_0x119241(0x253)];if(_0x9f576a[_0x119241(0x591)](/\[Version[ ](.*?)\]/i)){const _0x33202b=Number(RegExp['$1']);_0x33202b!==VisuMZ[label][_0x119241(0x11a)]&&(alert(_0x119241(0x649)[_0x119241(0x8d6)](_0x21fed6,_0x33202b)),SceneManager[_0x119241(0x9fa)]());}if(_0x9f576a[_0x119241(0x591)](/\[Tier[ ](\d+)\]/i)){if('cNAnP'==='gKQli')_0x25b09d[_0x119241(0x667)](_0x2789ea[_0x119241(0xab2)],0x0);else{const _0x5d6f34=Number(RegExp['$1']);_0x5d6f34<tier?_0x119241(0xa46)!==_0x119241(0xa46)?this[_0x119241(0xbe)]():(alert('%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.'[_0x119241(0x8d6)](_0x21fed6,_0x5d6f34,tier)),SceneManager[_0x119241(0x9fa)]()):tier=Math[_0x119241(0x79a)](_0x5d6f34,tier);}}VisuMZ[_0x119241(0xa0c)](VisuMZ[label][_0x119241(0x825)],_0x2b95eb[_0x119241(0x14e)]);})(pluginData),VisuMZ['CreateActionSequenceTargets']=function(_0x4caf57){const _0x2eedec=_0x251720;let _0x565291=[];for(const _0x231df2 of _0x4caf57){_0x565291=_0x565291[_0x2eedec(0x86)](VisuMZ[_0x2eedec(0x7c3)](_0x231df2));}return _0x565291[_0x2eedec(0x778)](_0x34aa59=>_0x34aa59);},VisuMZ[_0x251720(0x7c3)]=function(_0x2b0a6e){const _0x2786cf=_0x251720,_0xf90b97=BattleManager['allBattleMembers']()[_0x2786cf(0x778)](_0x1a90a8=>_0x1a90a8&&_0x1a90a8['isAppeared']()),_0x48df5e=BattleManager[_0x2786cf(0x29b)],_0x2d8042=BattleManager[_0x2786cf(0x312)],_0x28cb16=BattleManager['_allTargets']?BattleManager['_allTargets'][_0x2786cf(0xa79)](0x0):_0xf90b97;_0x2b0a6e=_0x2b0a6e[_0x2786cf(0x612)]()['trim']();if(_0x2b0a6e===_0x2786cf(0x77d))return[_0x48df5e];else{if(_0x2b0a6e===_0x2786cf(0x195)){if(_0x2786cf(0x4ba)===_0x2786cf(0x43d))_0x19ccd4[_0x2786cf(0x731)][_0x2786cf(0x425)][_0x2786cf(0xa57)](this,_0x4d932e),this[_0x2786cf(0x364)](_0x40a520);else return[_0x2d8042];}else{if(_0x2b0a6e===_0x2786cf(0x8cd)){if(_0x2d8042){const _0x46129a=_0x28cb16[_0x2786cf(0x2dd)](_0x2d8042);return _0x46129a>=0x0?[_0x28cb16[_0x46129a-0x1]||_0x2d8042]:[_0x2d8042];}}else{if(_0x2b0a6e===_0x2786cf(0x203)){if('LZwoL'==='LZwoL'){if(_0x2d8042){if('zRtLM'===_0x2786cf(0x4f3))_0x462f4a[_0x2786cf(0x731)]['Game_BattlerBase_initMembers'][_0x2786cf(0xa57)](this),this[_0x2786cf(0x158)]();else{const _0x17e801=_0x28cb16[_0x2786cf(0x2dd)](_0x2d8042);return _0x17e801>=0x0?[_0x28cb16[_0x17e801+0x1]||_0x2d8042]:[_0x2d8042];}}}else{if(!_0x2e4e64[_0x2786cf(0x847)]())return;if(!_0x5c4cef[_0x2786cf(0xb5)])return;const _0x3a63c4=_0x2e99d3['_action'];if(!_0x3a63c4)return;_0x3a63c4[_0x2786cf(0xa4d)]=!![];}}else{if(_0x2b0a6e===_0x2786cf(0x858))return _0x28cb16;else{if(_0x2b0a6e===_0x2786cf(0x8d1))return[_0x48df5e]['concat'](_0x28cb16);else{if(_0x2b0a6e===_0x2786cf(0x30f))return _0xf90b97[_0x2786cf(0x778)](_0xb2149e=>_0xb2149e!==_0x48df5e&&!_0x28cb16['includes'](_0xb2149e)&&_0xb2149e['notFocusValid']());}}}}}}if(_0x48df5e){if(_0x2b0a6e===_0x2786cf(0x1ec)){if(_0x2786cf(0x472)===_0x2786cf(0x472))return _0x48df5e[_0x2786cf(0x366)]()[_0x2786cf(0x8ef)]();else{const _0xdae451=this['actor'](_0x1083df)[_0x2786cf(0x60a)]();if(!_0xdae451)return;const _0x527213=this[_0x2786cf(0x5bf)](),_0x4d5a6b=this[_0x2786cf(0x7b7)](_0x3257dc);let _0x50fd4b=_0x464b91[_0x2786cf(0x3e4)](_0x4d5a6b['x']+_0x4d5a6b[_0x2786cf(0x139)]/0x2)+this['padding'];[_0x2786cf(0x855)][_0x2786cf(0x9b0)](_0x527213)&&(_0x50fd4b=_0x4d5a6b[_0x2786cf(0x139)]/_0x527b3f[_0x2786cf(0x5e2)]()[_0x2786cf(0x988)],_0x50fd4b*=_0x2abc25,_0x50fd4b+=_0x4d5a6b[_0x2786cf(0x139)]/_0x26ae64['battleMembers']()[_0x2786cf(0x988)]/0x2);let _0x30d565=_0x305506[_0x2786cf(0x3e4)](this[_0x2786cf(0x9c5)](_0xa85571,_0xdae451,_0x4d5a6b));_0xdae451[_0x2786cf(0x56b)](_0x50fd4b,_0x30d565),this[_0x2786cf(0x7e3)](_0xdae451,0x1),_0xdae451['show']();}}else{if(_0x2b0a6e===_0x2786cf(0x349)){if(_0x2786cf(0x405)===_0x2786cf(0x405))return _0x48df5e[_0x2786cf(0x366)]()['aliveMembers']()[_0x2786cf(0x778)](_0x1a023b=>_0x1a023b!==_0x48df5e);else this['_windowLayer']['x']=_0x45d2cc[_0x2786cf(0x139)]*0xa,this[_0x2786cf(0x290)]['y']=_0x220ed0[_0x2786cf(0x442)]*0xa;}else{if(_0x2b0a6e===_0x2786cf(0x327))return _0x48df5e[_0x2786cf(0x366)]()[_0x2786cf(0x8ef)]()[_0x2786cf(0x778)](_0x1581fb=>_0x1581fb!==_0x2d8042);else{if(_0x2b0a6e===_0x2786cf(0x779))return _0x48df5e[_0x2786cf(0x366)]()[_0x2786cf(0x55b)]();else{if(_0x2b0a6e[_0x2786cf(0x591)](/FRIEND INDEX (\d+)/i)){const _0x4d7eec=Number(RegExp['$1']);return[_0x48df5e[_0x2786cf(0x366)]()[_0x2786cf(0x991)]()[_0x4d7eec]];}}}}}if(_0x2b0a6e===_0x2786cf(0x4e2))return _0x48df5e[_0x2786cf(0x7f5)]()[_0x2786cf(0x8ef)]();else{if(_0x2b0a6e===_0x2786cf(0x7b9))return _0x48df5e[_0x2786cf(0x7f5)]()[_0x2786cf(0x8ef)]()[_0x2786cf(0x778)](_0x5a9ab3=>_0x5a9ab3!==_0x2d8042);else{if(_0x2b0a6e==='dead\x20opponents')return _0x48df5e[_0x2786cf(0x7f5)]()[_0x2786cf(0x55b)]();else{if(_0x2b0a6e[_0x2786cf(0x591)](/OPPONENT INDEX (\d+)/i)){if(_0x2786cf(0x3a0)==='TWlrb'){_0x14f37b[_0x2786cf(0x97e)][_0x2786cf(0x702)][_0x2786cf(0xa57)](this,_0x1dfd8b);if(this[_0x2786cf(0x87d)]())this[_0x2786cf(0x458)](_0xdf19c3);}else{const _0x356533=Number(RegExp['$1']);return[_0x48df5e[_0x2786cf(0x7f5)]()[_0x2786cf(0x991)]()[_0x356533]];}}}}}}if(_0x2b0a6e===_0x2786cf(0x2ed))return $gameParty[_0x2786cf(0x8ef)]();else{if(_0x2b0a6e===_0x2786cf(0x932)){if('TqZBP'===_0x2786cf(0xa29))return $gameParty[_0x2786cf(0x8ef)]()['filter'](_0x39be3d=>_0x39be3d!==_0x48df5e);else for(const _0xb9e819 of _0x26994d[_0x2786cf(0x963)]()){this[_0x2786cf(0x1cb)]['push'](_0x2786cf(0x84b),_0x258c92[_0x2786cf(0x481)]['format'](_0xb9e819)),this[_0x2786cf(0x1cb)][_0x2786cf(0x141)]('wait'),_0x71390a=!![];}}else{if(_0x2b0a6e==='alive\x20actors\x20not\x20target'){if(_0x2786cf(0xa01)!==_0x2786cf(0x20f))return $gameParty[_0x2786cf(0x8ef)]()['filter'](_0x54869d=>_0x54869d!==_0x2d8042);else _0x204ca6['BattleCore'][_0x2786cf(0x799)][_0x2786cf(0xa57)](this),this['_forcedBattlers']=[];}else{if(_0x2b0a6e===_0x2786cf(0x911)){if(_0x2786cf(0x5cf)==='THqTv')return $gameParty[_0x2786cf(0x55b)]();else{if(!_0x527ad2)return;_0x325b64['VisuMZ_1_SkillsStatesCore']?_0x120571['prototype']['drawSkillCost']['call'](this,_0xcdc696,_0x3945f0,_0x30ceb1,_0x468de1,_0x26a9b9):_0x163288['prototype'][_0x2786cf(0x9fc)]['call'](this,_0xe5b172,_0xf4767b,_0xf2a971,_0x5c48df);}}else{if(_0x2b0a6e[_0x2786cf(0x591)](/ACTOR INDEX (\d+)/i)){const _0x371d5a=Number(RegExp['$1']);return[$gameParty[_0x2786cf(0x991)]()[_0x371d5a]];}else{if(_0x2b0a6e[_0x2786cf(0x591)](/ACTOR ID (\d+)/i)){const _0x3e692e=Number(RegExp['$1']);return[$gameActors[_0x2786cf(0x30d)](_0x3e692e)];}}}}}}if(_0x2b0a6e==='alive\x20enemies')return $gameTroop['aliveMembers']();else{if(_0x2b0a6e===_0x2786cf(0x91e))return $gameTroop[_0x2786cf(0x8ef)]()[_0x2786cf(0x778)](_0x51f4eb=>_0x51f4eb!==_0x48df5e);else{if(_0x2b0a6e===_0x2786cf(0x81a))return $gameTroop[_0x2786cf(0x8ef)]()['filter'](_0x5d65a9=>_0x5d65a9!==_0x2d8042);else{if(_0x2b0a6e===_0x2786cf(0x80f)){if(_0x2786cf(0x7c9)===_0x2786cf(0x7c9))return $gameTroop[_0x2786cf(0x55b)]();else{if(!_0x196040[_0x2786cf(0x731)][_0x2786cf(0x825)][_0x2786cf(0x8cf)][_0x2786cf(0x155)])return;_0x624b06[_0x2786cf(0x731)][_0x2786cf(0x189)]['call'](this,_0x4cf357);}}else{if(_0x2b0a6e['match'](/ENEMY INDEX (\d+)/i)){if(_0x2786cf(0x371)!==_0x2786cf(0xa9c)){const _0x23691c=Number(RegExp['$1']);return[$gameTroop['members']()[_0x23691c]];}else return _0x25234d[_0x2786cf(0x30e)]();}else{if(_0x2b0a6e['match'](/ENEMY ID (\d+)/i)){const _0x1d3ef1=Number(RegExp['$1']);return $gameTroop[_0x2786cf(0x8ef)]()[_0x2786cf(0x778)](_0x3a7eeb=>_0x3a7eeb[_0x2786cf(0xa0b)]()===_0x1d3ef1);}}}}}}if(_0x2b0a6e===_0x2786cf(0xc5)){if(_0x2786cf(0x7bc)==='Azvjc')return _0xf90b97['filter'](_0x32a444=>_0x32a444['isAlive']());else{if(!_0x18e5c7[_0x2786cf(0x847)]())return;_0x47d014['ConvertParams'](_0x2ef7f8,_0x29f382);const _0x4729b7=_0x5dd104[_0x2786cf(0x27e)](),_0x2d7b89=_0x1f90c7[_0x2786cf(0x3f8)],_0x559f9e=_0x8a51e1[_0x2786cf(0x2bc)];if(!_0x4729b7)return;_0x5b008e[_0x2786cf(0x1d1)]=_0x2d7b89,_0x50d328[_0x2786cf(0x312)]=_0x276ff1['_allTargets']?_0x18c593[_0x2786cf(0x8cb)][_0x1afb15['_targetIndex']]||null:null,_0x3d1157['_target']&&_0x559f9e[_0x2786cf(0x62a)]()[_0x2786cf(0x30b)]()!==_0x2786cf(0x720)&&_0x4729b7[_0x2786cf(0x65a)]([_0x559f9e]);}}else{if(_0x2b0a6e===_0x2786cf(0x882)){if(_0x2786cf(0xa8f)!==_0x2786cf(0xa8f))_0x382db2[_0x2786cf(0x1a1)](_0x2786cf(0x3d8));else return _0xf90b97[_0x2786cf(0x778)](_0x218dfd=>_0x218dfd['isAlive']()&&_0x218dfd!==_0x48df5e);}else{if(_0x2b0a6e===_0x2786cf(0x21a)){if(_0x2786cf(0x3ec)==='MEOsE'){_0x3b0c91[_0x2786cf(0x731)][_0x2786cf(0x257)][_0x2786cf(0xa57)](this,_0x441ff5),this[_0x2786cf(0x6dc)](),this['setupBattleCoreData']();const _0x384776=this[_0x2786cf(0x60a)]();if(_0x384776)_0x384776[_0x2786cf(0x200)](this);}else return _0xf90b97[_0x2786cf(0x778)](_0x913e0e=>_0x913e0e[_0x2786cf(0x2ce)]()&&_0x913e0e!==_0x2d8042);}else{if(_0x2b0a6e==='dead\x20battlers'){if(_0x2786cf(0x211)!==_0x2786cf(0x211))_0x397b6c[_0x2786cf(0x731)]['ParseActorNotetags']&&_0x43e1f5[_0x2786cf(0x731)][_0x2786cf(0x4f5)]['call'](this,_0x5c9e6f),_0x244fcd[_0x2786cf(0x731)][_0x2786cf(0x4d5)](_0xe15447);else return _0xf90b97[_0x2786cf(0x778)](_0x3fd831=>_0x3fd831[_0x2786cf(0x864)]());}}}}return[];},PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x5ea),_0x530fbe=>{const _0x13f32c=_0x251720;if(!SceneManager[_0x13f32c(0x847)]())return;VisuMZ[_0x13f32c(0xa0c)](_0x530fbe,_0x530fbe);const _0x236afd=$gameTemp[_0x13f32c(0x27e)](),_0x1afd21=BattleManager[_0x13f32c(0x866)],_0x4f3312=BattleManager['_subject'],_0x33be2a=BattleManager[_0x13f32c(0x8cb)]?BattleManager[_0x13f32c(0x8cb)][_0x13f32c(0xa79)](0x0):[],_0x64d547=BattleManager[_0x13f32c(0x1cb)];if(!_0x236afd||!_0x1afd21||!_0x4f3312)return;if(!_0x1afd21[_0x13f32c(0x342)]())return;if(_0x530fbe['DisplayAction'])_0x64d547['displayAction'](_0x4f3312,_0x1afd21[_0x13f32c(0x342)]());_0x530fbe['ApplyImmortal']&&('hfjoX'!=='FnKIF'?_0x64d547[_0x13f32c(0x141)]('applyImmortal',_0x4f3312,_0x33be2a,!![]):(this['_lastEnemy']=null,_0x236a7f['BattleCore'][_0x13f32c(0x4af)][_0x13f32c(0xa57)](this,_0x2671fe)));if(_0x530fbe['ActionStart'])_0x64d547['push'](_0x13f32c(0x7bb),_0x4f3312,_0x1afd21);if(_0x530fbe[_0x13f32c(0x6e7)])_0x64d547['push'](_0x13f32c(0x766));if(_0x530fbe[_0x13f32c(0x31d)])_0x64d547[_0x13f32c(0x141)](_0x13f32c(0xb1),_0x4f3312,_0x1afd21);if(_0x530fbe[_0x13f32c(0x5fb)])_0x64d547['push'](_0x13f32c(0x797));_0x236afd[_0x13f32c(0x1a1)]('battlelog');}),PluginManager[_0x251720(0x24b)](pluginData['name'],_0x251720(0xed),_0x5e0692=>{const _0x52c4b3=_0x251720;if(!SceneManager[_0x52c4b3(0x847)]())return;VisuMZ[_0x52c4b3(0xa0c)](_0x5e0692,_0x5e0692);const _0x242f2c=$gameTemp[_0x52c4b3(0x27e)](),_0x8a052d=BattleManager[_0x52c4b3(0x866)],_0x415993=BattleManager[_0x52c4b3(0x29b)],_0x104146=BattleManager['_allTargets']?BattleManager[_0x52c4b3(0x8cb)][_0x52c4b3(0xa79)](0x0):[],_0x4a11d2=BattleManager[_0x52c4b3(0x1cb)],_0x435af6=_0x5e0692[_0x52c4b3(0xa14)]??![];if(!_0x242f2c||!_0x8a052d||!_0x415993)return;if(!_0x8a052d[_0x52c4b3(0x342)]())return;let _0x4b50f5=_0x435af6?_0x4a11d2[_0x52c4b3(0x6bb)](_0x415993):0x1;for(let _0x3b5ac9=0x0;_0x3b5ac9<_0x4b50f5;_0x3b5ac9++){if(_0x435af6&&_0x415993[_0x52c4b3(0x4f2)]()){if(_0x52c4b3(0x67c)!=='hdCyB'){const _0x32fc96=this[_0x52c4b3(0x571)];_0x32fc96[_0x52c4b3(0x1e8)]['clear']();const _0x2911a2=this[_0x52c4b3(0x272)](this[_0x52c4b3(0x77c)]());if(_0x2911a2==='icon'&&this['maxItems']()>0x0){const _0x51b610=this['itemLineRect'](this[_0x52c4b3(0x77c)]());let _0x115deb=this[_0x52c4b3(0x392)](this[_0x52c4b3(0x77c)]());_0x115deb=_0x115deb[_0x52c4b3(0x105)](/\\I\[(\d+)\]/gi,''),_0x32fc96[_0x52c4b3(0x906)](),this[_0x52c4b3(0x652)](_0x115deb,_0x51b610),this[_0x52c4b3(0x997)](_0x115deb,_0x51b610),this[_0x52c4b3(0x896)](_0x115deb,_0x51b610);}}else _0x4a11d2[_0x52c4b3(0x141)](_0x52c4b3(0x1b5),_0x415993,_0x3b5ac9);}if(_0x5e0692[_0x52c4b3(0x441)])_0x4a11d2[_0x52c4b3(0x141)](_0x52c4b3(0x702),_0x415993,_0x8a052d);if(_0x5e0692[_0x52c4b3(0x3f6)]>0x0)_0x4a11d2[_0x52c4b3(0x141)](_0x52c4b3(0x5b4),_0x5e0692[_0x52c4b3(0x3f6)]);if(_0x5e0692[_0x52c4b3(0x6b4)])_0x4a11d2['push']('showAnimation',_0x415993,_0x104146,_0x8a052d[_0x52c4b3(0x342)]()[_0x52c4b3(0x1fc)]);if(_0x5e0692[_0x52c4b3(0x5fb)])_0x4a11d2[_0x52c4b3(0x141)]('waitForAnimation');for(const _0x2f1b4f of _0x104146){if(!_0x2f1b4f)continue;if(_0x5e0692[_0x52c4b3(0x6bd)])_0x4a11d2['push']('actionEffect',_0x415993,_0x2f1b4f);}}_0x435af6&&_0x415993['isActor']()&&_0x4a11d2[_0x52c4b3(0x141)]('clearActiveWeaponSet',_0x415993);if(_0x5e0692[_0x52c4b3(0x564)])_0x4a11d2[_0x52c4b3(0x141)](_0x52c4b3(0x5c8),_0x415993,_0x104146,![]);_0x242f2c[_0x52c4b3(0x1a1)]('battlelog');}),PluginManager['registerCommand'](pluginData[_0x251720(0x1f8)],_0x251720(0xacc),_0x1ea831=>{const _0xa38614=_0x251720;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0xa38614(0xa0c)](_0x1ea831,_0x1ea831);const _0x34cfde=$gameTemp['getLastPluginCommandInterpreter'](),_0x150a2e=BattleManager[_0xa38614(0x866)],_0x507408=BattleManager[_0xa38614(0x29b)],_0x27aba8=BattleManager[_0xa38614(0x8cb)]?BattleManager[_0xa38614(0x8cb)][_0xa38614(0xa79)](0x0):[],_0x1cc58d=BattleManager['_logWindow'],_0xad55cf=_0x1ea831[_0xa38614(0xa14)]??![];if(!_0x34cfde||!_0x150a2e||!_0x507408)return;if(!_0x150a2e[_0xa38614(0x342)]())return;let _0x4f026d=_0xad55cf?_0x1cc58d['getDualWieldTimes'](_0x507408):0x1;for(let _0x27aa8a=0x0;_0x27aa8a<_0x4f026d;_0x27aa8a++){if('GvHRB'!==_0xa38614(0xf4))for(const _0x140efe of _0x27aba8){if(!_0x140efe)continue;_0xad55cf&&_0x507408[_0xa38614(0x4f2)]()&&_0x1cc58d[_0xa38614(0x141)](_0xa38614(0x1b5),_0x507408,_0x27aa8a);if(_0x1ea831[_0xa38614(0x441)])_0x1cc58d['push'](_0xa38614(0x702),_0x507408,_0x150a2e);if(_0x1ea831['WaitCount1']>0x0)_0x1cc58d[_0xa38614(0x141)](_0xa38614(0x5b4),_0x1ea831[_0xa38614(0x6f)]);if(_0x1ea831[_0xa38614(0x6b4)])_0x1cc58d[_0xa38614(0x141)](_0xa38614(0xaaf),_0x507408,[_0x140efe],_0x150a2e[_0xa38614(0x342)]()[_0xa38614(0x1fc)]);if(_0x1ea831[_0xa38614(0x854)]>0x0)_0x1cc58d[_0xa38614(0x141)](_0xa38614(0x5b4),_0x1ea831[_0xa38614(0x854)]);if(_0x1ea831[_0xa38614(0x6bd)])_0x1cc58d[_0xa38614(0x141)](_0xa38614(0x973),_0x507408,_0x140efe);}else{this[_0xa38614(0x392)](_0x48c9e9)[_0xa38614(0x591)](/\\I\[(\d+)\]/i);const _0x43a03a=_0x4c44ba(_0x101c9a['$1'])||0x0,_0x4ce8c5=this[_0xa38614(0x67d)](_0x5cc78c),_0x3f557a=_0x4ce8c5['x']+_0x5614de[_0xa38614(0x570)]((_0x4ce8c5['width']-_0x4560c9[_0xa38614(0x391)])/0x2),_0x397aa5=_0x4ce8c5['y']+(_0x4ce8c5[_0xa38614(0x442)]-_0xf97da5[_0xa38614(0x162)])/0x2;this[_0xa38614(0x97a)](_0x43a03a,_0x3f557a,_0x397aa5);}}_0xad55cf&&_0x507408[_0xa38614(0x4f2)]()&&(_0xa38614(0xa90)!==_0xa38614(0xa90)?this[_0xa38614(0x6f1)]['open']():_0x1cc58d[_0xa38614(0x141)]('clearActiveWeaponSet',_0x507408));if(_0x1ea831['ApplyImmortal'])_0x1cc58d[_0xa38614(0x141)](_0xa38614(0x5c8),_0x507408,_0x27aba8,![]);_0x34cfde[_0xa38614(0x1a1)](_0xa38614(0x77f));}),PluginManager[_0x251720(0x24b)](pluginData['name'],'ActSeq_Set_FinishAction',_0xec0904=>{const _0x41ef2c=_0x251720;if(!SceneManager[_0x41ef2c(0x847)]())return;VisuMZ[_0x41ef2c(0xa0c)](_0xec0904,_0xec0904);const _0x5102e0=$gameTemp[_0x41ef2c(0x27e)](),_0xa3ced4=BattleManager[_0x41ef2c(0x866)],_0xfea2ed=BattleManager[_0x41ef2c(0x29b)],_0x2621dd=BattleManager['_allTargets']?BattleManager['_allTargets'][_0x41ef2c(0xa79)](0x0):[],_0xcd8aec=BattleManager['_logWindow'];if(!_0x5102e0||!_0xa3ced4||!_0xfea2ed)return;if(!_0xa3ced4[_0x41ef2c(0x342)]())return;if(_0xec0904[_0x41ef2c(0x564)])_0xcd8aec[_0x41ef2c(0x141)](_0x41ef2c(0x5c8),_0xfea2ed,_0x2621dd,![]);if(_0xec0904['WaitForNewLine'])_0xcd8aec[_0x41ef2c(0x141)](_0x41ef2c(0x941));if(_0xec0904[_0x41ef2c(0x309)])_0xcd8aec[_0x41ef2c(0x141)]('waitForEffect');if(_0xec0904['ClearBattleLog'])_0xcd8aec[_0x41ef2c(0x141)]('clear');if(_0xec0904[_0x41ef2c(0xa53)])_0xcd8aec[_0x41ef2c(0x141)](_0x41ef2c(0x29c),_0xfea2ed);if(_0xec0904[_0x41ef2c(0x6e7)])_0xcd8aec[_0x41ef2c(0x141)]('waitForMovement');_0x5102e0[_0x41ef2c(0x1a1)]('battlelog');}),PluginManager[_0x251720(0x24b)](pluginData['name'],_0x251720(0x4c4),_0x376b09=>{const _0x3058d2=_0x251720;if(!SceneManager['isSceneBattle']())return;if(!Imported['VisuMZ_3_ActSeqCamera'])return;VisuMZ[_0x3058d2(0xa0c)](_0x376b09,_0x376b09);const _0x568979=$gameTemp[_0x3058d2(0x27e)](),_0x12e5c2=_0x376b09[_0x3058d2(0x816)];if(!_0x568979)return;$gameScreen['setBattleAngle'](_0x376b09[_0x3058d2(0x5ef)],_0x376b09[_0x3058d2(0x19f)],_0x376b09[_0x3058d2(0xc3)]);if(_0x12e5c2)_0x568979[_0x3058d2(0x1a1)](_0x3058d2(0x82e));}),PluginManager[_0x251720(0x24b)](pluginData['name'],_0x251720(0x7d4),_0x4e6712=>{const _0x1192eb=_0x251720;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x1192eb(0x243)])return;VisuMZ[_0x1192eb(0xa0c)](_0x4e6712,_0x4e6712);const _0x1a46f9=$gameTemp['getLastPluginCommandInterpreter'](),_0x1835fb=_0x4e6712[_0x1192eb(0x816)];if(!_0x1a46f9)return;$gameScreen[_0x1192eb(0x745)](0x0,_0x4e6712['Duration'],_0x4e6712[_0x1192eb(0xc3)]);if(_0x1835fb)_0x1a46f9[_0x1192eb(0x1a1)](_0x1192eb(0x82e));}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x9e0),_0x1e6e15=>{const _0x4f2f88=_0x251720;if(!SceneManager[_0x4f2f88(0x847)]())return;if(!Imported['VisuMZ_3_ActSeqCamera'])return;const _0x732564=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x732564)return;_0x732564[_0x4f2f88(0x1a1)](_0x4f2f88(0x82e));}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],'ActSeq_Animation_ActionAnimation',_0x7a5c39=>{const _0x5c432e=_0x251720;if(!SceneManager[_0x5c432e(0x847)]())return;VisuMZ['ConvertParams'](_0x7a5c39,_0x7a5c39);const _0x358481=$gameTemp[_0x5c432e(0x27e)](),_0x337e28=BattleManager[_0x5c432e(0x866)],_0x435e44=BattleManager[_0x5c432e(0x29b)],_0x216240=VisuMZ[_0x5c432e(0x41c)](_0x7a5c39[_0x5c432e(0x179)]),_0x18dbe1=_0x7a5c39[_0x5c432e(0x6ce)],_0x2f3407=BattleManager['_logWindow'];if(!_0x358481||!_0x337e28||!_0x435e44)return;if(!_0x337e28[_0x5c432e(0x342)]())return;let _0x9d95bc=_0x337e28[_0x5c432e(0x342)]()['animationId'];if(_0x9d95bc<0x0)_0x9d95bc=_0x435e44['attackAnimationId1']();$gameTemp['requestAnimation'](_0x216240,_0x9d95bc,_0x18dbe1),_0x7a5c39[_0x5c432e(0x5fb)]&&_0x358481['setWaitMode']('battleAnimation');}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x662),_0x3000bb=>{const _0x40d16d=_0x251720;if(!SceneManager['isSceneBattle']())return;VisuMZ['ConvertParams'](_0x3000bb,_0x3000bb);const _0x29d335=$gameTemp[_0x40d16d(0x27e)](),_0x19751e=BattleManager[_0x40d16d(0x29b)],_0x2f2a62=VisuMZ['CreateActionSequenceTargets'](_0x3000bb[_0x40d16d(0x179)]),_0x26dd66=_0x3000bb[_0x40d16d(0x6ce)],_0x21340e=BattleManager[_0x40d16d(0x1cb)];if(!_0x29d335||!_0x19751e)return;const _0x3ad3c5=_0x19751e[_0x40d16d(0x3fe)]();$gameTemp[_0x40d16d(0x95b)](_0x2f2a62,_0x3ad3c5,_0x26dd66),_0x3000bb[_0x40d16d(0x5fb)]&&_0x29d335[_0x40d16d(0x1a1)](_0x40d16d(0x3d8));}),PluginManager['registerCommand'](pluginData[_0x251720(0x1f8)],_0x251720(0x375),_0x266194=>{const _0x2ea152=_0x251720;if(!SceneManager[_0x2ea152(0x847)]())return;VisuMZ['ConvertParams'](_0x266194,_0x266194);const _0xff224b=_0x44de14[_0x2ea152(0x5de)](_0x266194['Slot']);if(_0xff224b<=0x0)return;const _0x8800a2=$gameTemp[_0x2ea152(0x27e)](),_0x44de14=BattleManager[_0x2ea152(0x29b)],_0x29cfc1=VisuMZ[_0x2ea152(0x41c)](_0x266194[_0x2ea152(0x179)]),_0x3f4a9c=_0x266194['Mirror'],_0x2686e3=BattleManager['_logWindow'];if(!_0x8800a2||!_0x44de14)return;$gameTemp[_0x2ea152(0x95b)](_0x29cfc1,_0xff224b,_0x3f4a9c),_0x266194['WaitForAnimation']&&_0x8800a2[_0x2ea152(0x1a1)](_0x2ea152(0x3d8));}),PluginManager[_0x251720(0x24b)](pluginData['name'],_0x251720(0x901),_0x573693=>{const _0x432621=_0x251720;if(!SceneManager[_0x432621(0x847)]())return;VisuMZ['ConvertParams'](_0x573693,_0x573693);const _0x1e6b76=$gameTemp[_0x432621(0x27e)](),_0x690f8=BattleManager[_0x432621(0x866)],_0x534cdb=_0x573693['Mirror'],_0x402029=VisuMZ[_0x432621(0x41c)](_0x573693['Targets']);if(!_0x1e6b76||!_0x690f8)return;if(!_0x690f8['item']())return;for(const _0x1ddc00 of _0x402029){if(!_0x1ddc00)continue;_0x1ddc00[_0x432621(0xb1)](_0x690f8,_0x534cdb);}if(_0x573693[_0x432621(0x5fb)])_0x1e6b76[_0x432621(0x1a1)](_0x432621(0x3d8));}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],'ActSeq_Animation_ChangeBattlePortrait',_0x4c4bdb=>{const _0x5cefbb=_0x251720;VisuMZ[_0x5cefbb(0xa0c)](_0x4c4bdb,_0x4c4bdb);const _0xacf64=$gameTemp['getLastPluginCommandInterpreter'](),_0x128f07=VisuMZ[_0x5cefbb(0x41c)](_0x4c4bdb[_0x5cefbb(0x179)]),_0x12dbfb=_0x4c4bdb[_0x5cefbb(0x1eb)];if(!_0x12dbfb)return;for(const _0x302f68 of _0x128f07){if(!_0x302f68)continue;if(!_0x302f68[_0x5cefbb(0x4f2)]())continue;_0x302f68[_0x5cefbb(0xa82)](_0x12dbfb);}}),PluginManager[_0x251720(0x24b)](pluginData['name'],_0x251720(0x431),_0x23fcb1=>{const _0xfce483=_0x251720;if(!SceneManager[_0xfce483(0x35b)])return;if(!SceneManager['_scene'][_0xfce483(0x742)])return;if(!Imported[_0xfce483(0x7a8)])return;VisuMZ[_0xfce483(0xa0c)](_0x23fcb1,_0x23fcb1);const _0x16cf26=$gameTemp[_0xfce483(0x27e)](),_0x107dee=Math[_0xfce483(0x3e4)](_0x23fcb1[_0xfce483(0x90c)]),_0x508530=Math[_0xfce483(0x3e4)](_0x23fcb1['pointY']);$gameTemp[_0xfce483(0x9ed)](_0x107dee,_0x508530,_0x23fcb1[_0xfce483(0x5a1)],_0x23fcb1['Mirror'],_0x23fcb1[_0xfce483(0x40e)]),_0x23fcb1['WaitComplete']&&_0x16cf26&&(SceneManager[_0xfce483(0x35b)]['_spriteset']['updatePointAnimations'](),_0x16cf26['setWaitMode'](_0xfce483(0x3d8)));}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x34e),_0x52e53e=>{const _0x6206f7=_0x251720;if(!SceneManager[_0x6206f7(0x847)]())return;VisuMZ['ConvertParams'](_0x52e53e,_0x52e53e);const _0x311c5f=$gameTemp[_0x6206f7(0x27e)](),_0x30e0a8=VisuMZ['CreateActionSequenceTargets'](_0x52e53e[_0x6206f7(0x179)]),_0x1b05bd=_0x52e53e[_0x6206f7(0x5a1)],_0x34c7b1=_0x52e53e['Mirror'];if(!_0x311c5f)return;$gameTemp[_0x6206f7(0x95b)](_0x30e0a8,_0x1b05bd,_0x34c7b1);if(_0x52e53e['WaitForAnimation'])_0x311c5f[_0x6206f7(0x1a1)](_0x6206f7(0x3d8));}),PluginManager[_0x251720(0x24b)](pluginData['name'],_0x251720(0x1c7),_0xc42463=>{const _0x742f12=_0x251720;if(!SceneManager[_0x742f12(0x847)]())return;const _0x57844c=$gameTemp[_0x742f12(0x27e)]();if(!_0x57844c)return;_0x57844c[_0x742f12(0x1a1)](_0x742f12(0x3d8));}),PluginManager['registerCommand'](pluginData[_0x251720(0x1f8)],_0x251720(0x6ed),_0x2fdac5=>{const _0xb7d8e4=_0x251720;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0xb7d8e4(0xa0c)](_0x2fdac5,_0x2fdac5);const _0x4c8c9a=BattleManager['_logWindow'],_0x2ec8ec=_0x2fdac5[_0xb7d8e4(0xaa9)]&&Imported[_0xb7d8e4(0x307)];_0x4c8c9a[_0xb7d8e4(0x84b)](_0x2fdac5[_0xb7d8e4(0xa5)]),_0x2ec8ec&&Imported[_0xb7d8e4(0x307)]&&(_0xb7d8e4(0x9ec)===_0xb7d8e4(0x9ec)?$gameSystem[_0xb7d8e4(0x6dd)](_0x2fdac5[_0xb7d8e4(0xa5)]||'',_0x2fdac5['CombatLogIcon']||0x0):(this[_0xb7d8e4(0x4ed)]=this[_0xb7d8e4(0xa86)],this[_0xb7d8e4(0x2c5)]=this[_0xb7d8e4(0xcd)]));}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x247),_0x277363=>{const _0x462082=_0x251720;if(!SceneManager[_0x462082(0x847)]())return;const _0x159db4=BattleManager['_logWindow'];_0x159db4[_0x462082(0x90f)]();}),PluginManager[_0x251720(0x24b)](pluginData['name'],_0x251720(0x3db),_0x41cf88=>{const _0x255cfe=_0x251720;if(!SceneManager['isSceneBattle']())return;const _0xd47e90=$gameTemp[_0x255cfe(0x27e)](),_0x504269=BattleManager[_0x255cfe(0x866)],_0x1e3aeb=BattleManager[_0x255cfe(0x29b)],_0x14cf65=BattleManager[_0x255cfe(0x1cb)];if(!_0xd47e90||!_0x504269||!_0x1e3aeb)return;if(!_0x504269[_0x255cfe(0x342)]())return;_0x14cf65[_0x255cfe(0xa27)](_0x1e3aeb,_0x504269['item']()),_0xd47e90['setWaitMode'](_0x255cfe(0x77f));}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x251),_0x998bcb=>{const _0x538214=_0x251720;if(!SceneManager[_0x538214(0x847)]())return;const _0x9175f8=BattleManager[_0x538214(0x1cb)];_0x9175f8[_0x538214(0x238)]();}),PluginManager[_0x251720(0x24b)](pluginData['name'],_0x251720(0x23d),_0x2ec62d=>{const _0x5bdc03=_0x251720;if(!SceneManager[_0x5bdc03(0x847)]())return;const _0x5d7875=BattleManager[_0x5bdc03(0x1cb)];_0x5d7875[_0x5bdc03(0x6e5)]();}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x24c),_0x11256b=>{const _0x2ed4bb=_0x251720;if(!SceneManager[_0x2ed4bb(0x847)]())return;const _0x140be7=BattleManager['_logWindow'];_0x140be7['refresh']();}),PluginManager[_0x251720(0x24b)](pluginData['name'],_0x251720(0x2f0),_0x306062=>{const _0x1f309b=_0x251720;if(!SceneManager[_0x1f309b(0x847)]())return;VisuMZ[_0x1f309b(0xa0c)](_0x306062,_0x306062),SceneManager[_0x1f309b(0x35b)][_0x1f309b(0xa7c)](_0x306062[_0x1f309b(0x2b4)]);}),PluginManager['registerCommand'](pluginData['name'],_0x251720(0x5d3),_0x2f9161=>{const _0x354163=_0x251720;if(!SceneManager['isSceneBattle']())return;const _0x2c7416=$gameTemp['getLastPluginCommandInterpreter']();_0x2c7416['setWaitMode'](_0x354163(0x77f));}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x1f0),_0x1d0066=>{const _0x240f39=_0x251720;if(!SceneManager['isSceneBattle']())return;const _0x4603ce=$gameTemp[_0x240f39(0x27e)](),_0x58e22e=BattleManager[_0x240f39(0x1cb)];_0x58e22e[_0x240f39(0x941)](),_0x4603ce[_0x240f39(0x1a1)](_0x240f39(0x77f));}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],'ActSeq_Camera_Clamp',_0x2bda74=>{const _0x4e2178=_0x251720;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x4e2178(0x243)])return;VisuMZ[_0x4e2178(0xa0c)](_0x2bda74,_0x2bda74);const _0x2c993f=$gameScreen[_0x4e2178(0x623)]();_0x2c993f[_0x4e2178(0x7f3)]=_0x2bda74['Setting'];}),PluginManager['registerCommand'](pluginData[_0x251720(0x1f8)],_0x251720(0x12d),_0xffb252=>{const _0x5ade2d=_0x251720;if(!SceneManager[_0x5ade2d(0x847)]())return;if(!Imported['VisuMZ_3_ActSeqCamera'])return;VisuMZ[_0x5ade2d(0xa0c)](_0xffb252,_0xffb252);const _0x13c8da=$gameTemp[_0x5ade2d(0x27e)](),_0x1ae9ef=_0xffb252['WaitForCamera'];$gameScreen['setBattleCameraPoint'](_0xffb252[_0x5ade2d(0x34a)],_0xffb252[_0x5ade2d(0x85e)],_0xffb252[_0x5ade2d(0x19f)],_0xffb252['EasingType']);if(_0x1ae9ef)_0x13c8da[_0x5ade2d(0x1a1)](_0x5ade2d(0x828));}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x181),_0x30b7d2=>{const _0x5f5266=_0x251720;if(!SceneManager[_0x5f5266(0x847)]())return;if(!Imported['VisuMZ_3_ActSeqCamera'])return;VisuMZ['ConvertParams'](_0x30b7d2,_0x30b7d2);const _0xfc3065=$gameTemp[_0x5f5266(0x27e)](),_0x15a8b9=VisuMZ[_0x5f5266(0x41c)](_0x30b7d2[_0x5f5266(0x179)]),_0x367c0c=_0x30b7d2['WaitForCamera'];$gameScreen['setBattleCameraTargets'](_0x15a8b9,_0x30b7d2[_0x5f5266(0x19f)],_0x30b7d2[_0x5f5266(0xc3)]);if(_0x367c0c)_0xfc3065['setWaitMode'](_0x5f5266(0x828));}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x7b5),_0x9cfe4f=>{const _0x9e0a22=_0x251720;if(!SceneManager[_0x9e0a22(0x847)]())return;if(!Imported[_0x9e0a22(0x243)])return;VisuMZ[_0x9e0a22(0xa0c)](_0x9cfe4f,_0x9cfe4f);const _0x560a09=$gameTemp[_0x9e0a22(0x27e)](),_0x505a08=_0x9cfe4f[_0x9e0a22(0x3dc)];$gameScreen['setBattleCameraOffset'](_0x9cfe4f[_0x9e0a22(0x38a)],_0x9cfe4f[_0x9e0a22(0x3bb)],_0x9cfe4f[_0x9e0a22(0x19f)],_0x9cfe4f[_0x9e0a22(0xc3)]);if(_0x505a08)_0x560a09[_0x9e0a22(0x1a1)]('battleCamera');}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x169),_0x5b48c6=>{const _0x36f489=_0x251720;if(!SceneManager[_0x36f489(0x847)]())return;if(!Imported[_0x36f489(0x243)])return;VisuMZ['ConvertParams'](_0x5b48c6,_0x5b48c6);const _0x414467=$gameTemp[_0x36f489(0x27e)](),_0x4630c5=_0x5b48c6[_0x36f489(0x88b)],_0x4a73d6=_0x5b48c6[_0x36f489(0x6ee)],_0x2f6ba9=_0x5b48c6[_0x36f489(0x3dc)];if(_0x4630c5){if(_0x36f489(0x4b0)!==_0x36f489(0x4b0)){if(!_0x3562fa[_0x36f489(0x847)]())return;if(!_0x2357d9[_0x36f489(0x47f)])return;if(!_0x426ce5['isSTB']())return;_0x20abce[_0x36f489(0xa0c)](_0x37f6dc,_0x2ad2e5);const _0xa470f3=_0x49b074[_0x36f489(0x20c)];_0x26c139['_subject']&&_0x8b1a48[_0x36f489(0x29b)][_0x36f489(0x240)](_0xa470f3);}else{const _0x315cf4=Math['round'](Graphics[_0x36f489(0x139)]/0x2),_0x3ce5f9=Math['round'](Graphics[_0x36f489(0x442)]/0x2);$gameScreen[_0x36f489(0x807)](_0x315cf4,_0x3ce5f9,_0x5b48c6[_0x36f489(0x19f)],_0x5b48c6[_0x36f489(0xc3)]);}}_0x4a73d6&&$gameScreen['setBattleCameraOffset'](0x0,0x0,_0x5b48c6['Duration'],_0x5b48c6[_0x36f489(0xc3)]);if(_0x2f6ba9)_0x414467['setWaitMode'](_0x36f489(0x828));}),PluginManager[_0x251720(0x24b)](pluginData['name'],_0x251720(0x5a0),_0x285857=>{const _0x1464f4=_0x251720;if(!SceneManager[_0x1464f4(0x847)]())return;if(!Imported[_0x1464f4(0x243)])return;const _0x411039=$gameTemp[_0x1464f4(0x27e)]();if(!_0x411039)return;_0x411039[_0x1464f4(0x1a1)](_0x1464f4(0x828));}),PluginManager['registerCommand'](pluginData[_0x251720(0x1f8)],_0x251720(0x551),_0x5998de=>{const _0x2abad8=_0x251720;if(!SceneManager[_0x2abad8(0x847)]())return;if(!Imported[_0x2abad8(0x703)])return;VisuMZ['ConvertParams'](_0x5998de,_0x5998de);const _0x16f0f6=VisuMZ[_0x2abad8(0x41c)](_0x5998de[_0x2abad8(0x179)]),_0x5cd7f1=_0x5998de['MotionAni'][_0x2abad8(0x612)]()[_0x2abad8(0x30b)]();for(const _0x23d42e of _0x16f0f6){if(!_0x23d42e)continue;_0x23d42e[_0x2abad8(0x782)](_0x5cd7f1);}}),PluginManager[_0x251720(0x24b)](pluginData['name'],_0x251720(0xa1b),_0x5197ca=>{const _0x56c870=_0x251720;if(!SceneManager[_0x56c870(0x847)]())return;if(!Imported[_0x56c870(0x703)])return;VisuMZ[_0x56c870(0xa0c)](_0x5197ca,_0x5197ca);const _0x2189ee=VisuMZ[_0x56c870(0x41c)](_0x5197ca[_0x56c870(0x179)]),_0xf776c2=_0x5197ca[_0x56c870(0x3eb)];for(const _0x4c98e0 of _0x2189ee){if(_0x56c870(0x5f3)!==_0x56c870(0x30c)){if(!_0x4c98e0)continue;_0x4c98e0[_0x56c870(0x2cc)]()['timeScale']=_0xf776c2;}else _0x5397b2[_0x56c870(0x342)]()[_0x56c870(0x363)][_0x56c870(0x74e)]>0x0?this[_0x56c870(0x62e)]():this['requestMotion'](_0x56c870(0x6f7));}}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x16c),_0x2172f1=>{const _0x3d75a3=_0x251720;if(!SceneManager[_0x3d75a3(0x847)]())return;if(!Imported[_0x3d75a3(0xb5)])return;VisuMZ['ConvertParams'](_0x2172f1,_0x2172f1);const _0x10f832=BattleManager[_0x3d75a3(0x866)],_0x24c70d=_0x2172f1[_0x3d75a3(0x3ac)];if(!_0x10f832)return;_0x10f832[_0x3d75a3(0x820)]=_0x24c70d;}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x61d),_0x306420=>{const _0x41c4b5=_0x251720;if(!SceneManager[_0x41c4b5(0x847)]())return;if(!Imported['VisuMZ_1_ElementStatusCore'])return;const _0x4103bf=BattleManager[_0x41c4b5(0x866)];if(!_0x4103bf)return;_0x4103bf[_0x41c4b5(0x4bb)]();}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x118),_0x84d52e=>{const _0x373230=_0x251720;if(!SceneManager[_0x373230(0x847)]())return;if(!Imported[_0x373230(0xb5)])return;VisuMZ[_0x373230(0xa0c)](_0x84d52e,_0x84d52e);const _0xbd0649=BattleManager[_0x373230(0x866)],_0x46b834=_0x84d52e['Elements'];if(!_0xbd0649)return;_0xbd0649[_0x373230(0x11e)]=_0x46b834;}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],'ActSeq_Element_NullElements',_0xcd41ee=>{const _0x154415=_0x251720;if(!SceneManager[_0x154415(0x847)]())return;if(!Imported['VisuMZ_1_ElementStatusCore'])return;const _0x5e7689=BattleManager[_0x154415(0x866)];if(!_0x5e7689)return;_0x5e7689[_0x154415(0xa4d)]=!![];}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x3f5),_0x38663b=>{const _0x4c8e5d=_0x251720;if(!Imported[_0x4c8e5d(0x201)])return;if(!SceneManager[_0x4c8e5d(0x847)]())return;VisuMZ[_0x4c8e5d(0xa0c)](_0x38663b,_0x38663b);const _0x2733ca=VisuMZ[_0x4c8e5d(0x41c)](_0x38663b[_0x4c8e5d(0x179)]);for(const _0x213f33 of _0x2733ca){if(_0x4c8e5d(0x704)===_0x4c8e5d(0x704)){if(!_0x213f33)continue;_0x213f33[_0x4c8e5d(0x3c2)]('noise'),_0x213f33[_0x4c8e5d(0x3c2)](_0x4c8e5d(0x7b)),_0x213f33['removeHorrorEffect']('tv'),_0x213f33[_0x4c8e5d(0x295)]();}else this[_0x4c8e5d(0x931)]('PreApply%1JS',_0x289e1e,0x0,!![]),_0x143460[_0x4c8e5d(0x731)]['Game_Action_apply']['call'](this,_0x3cede7),this[_0x4c8e5d(0x931)](_0x4c8e5d(0x305),_0x1424c5,this[_0x4c8e5d(0x781)]||0x0,!![]),this[_0x4c8e5d(0x6f0)](_0x464b2d);}$gamePlayer[_0x4c8e5d(0x841)]();}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x671),_0x2dd1a9=>{const _0x239b50=_0x251720;if(!Imported[_0x239b50(0x201)])return;if(!SceneManager[_0x239b50(0x847)]())return;VisuMZ[_0x239b50(0xa0c)](_0x2dd1a9,_0x2dd1a9);const _0x64ff10=VisuMZ[_0x239b50(0x41c)](_0x2dd1a9[_0x239b50(0x179)]),_0x34ab90='glitch';_0x2dd1a9[_0x239b50(0x89d)]=Math[_0x239b50(0x4a0)](_0x2dd1a9[_0x239b50(0x5a2)]/0x2),_0x2dd1a9[_0x239b50(0x2fc)]=_0x2dd1a9[_0x239b50(0x5a2)],_0x2dd1a9['refreshRequest']=!![];for(const _0xfed401 of _0x64ff10){if('MfcVL'!==_0x239b50(0x237)){if(!_0xfed401)continue;_0xfed401['setHorrorEffectSettings'](_0x34ab90,_0x2dd1a9);}else return _0x246c91[_0x239b50(0x366)]()[_0x239b50(0x55b)]();}$gamePlayer['refresh']();}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x50b),_0x1db21d=>{const _0x3b75eb=_0x251720;if(!Imported[_0x3b75eb(0x201)])return;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x3b75eb(0xa0c)](_0x1db21d,_0x1db21d);const _0x1c096b=VisuMZ['CreateActionSequenceTargets'](_0x1db21d[_0x3b75eb(0x179)]);for(const _0x39382c of _0x1c096b){if(!_0x39382c)continue;_0x39382c[_0x3b75eb(0x3c2)](_0x3b75eb(0x7b));}$gamePlayer['refresh']();}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x484),_0x10b390=>{const _0xe909c7=_0x251720;if(!Imported[_0xe909c7(0x201)])return;if(!SceneManager[_0xe909c7(0x847)]())return;VisuMZ[_0xe909c7(0xa0c)](_0x10b390,_0x10b390);const _0x1cdb6d=VisuMZ[_0xe909c7(0x41c)](_0x10b390[_0xe909c7(0x179)]),_0x78e142=_0xe909c7(0xa0);for(const _0x3055ba of _0x1cdb6d){if(_0xe909c7(0x809)!=='maxQi'){if(!_0x3055ba)continue;_0x3055ba[_0xe909c7(0x98f)](_0x78e142,_0x10b390);}else this[_0xe909c7(0x1ea)](this[_0xe909c7(0x32a)][_0xe909c7(0x397)]);}$gamePlayer['refresh']();}),PluginManager['registerCommand'](pluginData[_0x251720(0x1f8)],_0x251720(0x96b),_0x3be639=>{const _0x102074=_0x251720;if(!Imported['VisuMZ_2_HorrorEffects'])return;if(!SceneManager[_0x102074(0x847)]())return;VisuMZ[_0x102074(0xa0c)](_0x3be639,_0x3be639);const _0x183f5f=VisuMZ[_0x102074(0x41c)](_0x3be639[_0x102074(0x179)]);for(const _0x1f055c of _0x183f5f){if(_0x102074(0xa09)!==_0x102074(0x805)){if(!_0x1f055c)continue;_0x1f055c[_0x102074(0x3c2)](_0x102074(0xa0));}else this[_0x102074(0x817)][_0x102074(0x149)]=_0x283a02['BattleCore'][_0x102074(0x825)][_0x102074(0x98)][_0x102074(0x55c)];}$gamePlayer[_0x102074(0x841)]();}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x66e),_0x307d86=>{const _0x41f1f5=_0x251720;if(!Imported[_0x41f1f5(0x201)])return;if(!SceneManager[_0x41f1f5(0x847)]())return;VisuMZ[_0x41f1f5(0xa0c)](_0x307d86,_0x307d86);const _0x55401e=VisuMZ[_0x41f1f5(0x41c)](_0x307d86[_0x41f1f5(0x179)]),_0x22e1a1='tv';for(const _0x101409 of _0x55401e){if(_0x41f1f5(0x7ab)===_0x41f1f5(0x5e4)){if(!this[_0x41f1f5(0x186)])this[_0x41f1f5(0x6f6)]();return _0x55cbf1[_0x41f1f5(0x731)][_0x41f1f5(0x825)][_0x41f1f5(0x2e1)][_0x41f1f5(0x69a)]?this[_0x41f1f5(0x186)][_0x41f1f5(0x7e7)]():this[_0x41f1f5(0x186)][_0x41f1f5(0xa6)]();}else{if(!_0x101409)continue;_0x101409[_0x41f1f5(0x98f)](_0x22e1a1,_0x307d86);}}$gamePlayer['refresh']();}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x940),_0x42c9a6=>{const _0x285787=_0x251720;if(!Imported[_0x285787(0x201)])return;if(!SceneManager[_0x285787(0x847)]())return;VisuMZ[_0x285787(0xa0c)](_0x42c9a6,_0x42c9a6);const _0x5db710=VisuMZ[_0x285787(0x41c)](_0x42c9a6['Targets']);for(const _0x2119c6 of _0x5db710){if(_0x285787(0x2a6)==='IMTll'){if(!_0x2119c6)continue;_0x2119c6[_0x285787(0x3c2)]('tv');}else this[_0x285787(0x818)][_0x285787(0x499)]=![];}$gamePlayer['refresh']();}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],'ActSeq_Impact_ColorBreak',_0x5aa926=>{const _0x448dab=_0x251720;if(!SceneManager[_0x448dab(0x847)]())return;if(!Imported[_0x448dab(0x32d)])return;const _0x11ed05=SceneManager[_0x448dab(0x35b)][_0x448dab(0x742)];if(!_0x11ed05)return;VisuMZ['ConvertParams'](_0x5aa926,_0x5aa926);const _0x2aa12e=_0x5aa926[_0x448dab(0x86d)]||0x1,_0x21d051=_0x5aa926[_0x448dab(0x19f)]||0x1,_0x5fed79=_0x5aa926[_0x448dab(0xc3)]||'Linear';_0x11ed05['setupRgbSplitImpactFilter'](_0x2aa12e,_0x21d051,_0x5fed79);}),PluginManager[_0x251720(0x24b)](pluginData['name'],_0x251720(0x337),_0x3dbbe3=>{const _0x225ba3=_0x251720;if(!SceneManager[_0x225ba3(0x847)]())return;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0xfbe1af=SceneManager[_0x225ba3(0x35b)][_0x225ba3(0x742)];if(!_0xfbe1af)return;VisuMZ[_0x225ba3(0xa0c)](_0x3dbbe3,_0x3dbbe3);const _0xc986a3=Number(_0x3dbbe3['Angle'])||0x0,_0x2e6583=Number(_0x3dbbe3[_0x225ba3(0x95)]),_0x5b2b49=_0x3dbbe3['Duration']||0x1,_0x170726=_0x3dbbe3[_0x225ba3(0xc3)]||_0x225ba3(0x59a);_0xfbe1af[_0x225ba3(0xe0)](_0xc986a3,_0x2e6583,_0x5b2b49,_0x170726);}),PluginManager[_0x251720(0x24b)](pluginData['name'],_0x251720(0x1a3),_0x842635=>{const _0x373479=_0x251720;if(!SceneManager[_0x373479(0x847)]())return;if(!Imported[_0x373479(0x32d)])return;const _0x1b418e=SceneManager['_scene'][_0x373479(0x742)];if(!_0x1b418e)return;VisuMZ['ConvertParams'](_0x842635,_0x842635);const _0x383a75=Number(_0x842635[_0x373479(0x5ef)])||0x0,_0x57a059=Number(_0x842635[_0x373479(0x95)]),_0x5e1e7a=_0x842635['Duration']||0x1,_0x2b8b8f=_0x842635[_0x373479(0xc3)]||_0x373479(0x59a),_0xab3985=VisuMZ['CreateActionSequenceTargets'](_0x842635[_0x373479(0x179)]);for(const _0x4e0a19 of _0xab3985){if(!_0x4e0a19)continue;if(!_0x4e0a19[_0x373479(0x60a)]())continue;_0x4e0a19[_0x373479(0x60a)]()['setupMotionBlurImpactFilter'](_0x383a75,_0x57a059,_0x5e1e7a,_0x2b8b8f);}}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x57e),_0x11d5b9=>{const _0x3074c0=_0x251720;if(!SceneManager[_0x3074c0(0x847)]())return;if(!Imported[_0x3074c0(0x32d)])return;VisuMZ[_0x3074c0(0xa0c)](_0x11d5b9,_0x11d5b9);const _0x5ed81e={'delay':_0x11d5b9[_0x3074c0(0x3a9)],'duration':_0x11d5b9[_0x3074c0(0x74b)],'hue':_0x11d5b9[_0x3074c0(0x4f8)],'opacityStart':_0x11d5b9[_0x3074c0(0x5bc)],'tone':_0x11d5b9[_0x3074c0(0x245)],'visible':!![]},_0x216b66=VisuMZ['CreateActionSequenceTargets'](_0x11d5b9[_0x3074c0(0x179)]);for(const _0x50e0fc of _0x216b66){if(!_0x50e0fc)continue;_0x50e0fc[_0x3074c0(0x2f5)](_0x5ed81e);}}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x541),_0x55a054=>{const _0x273114=_0x251720;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x273114(0x32d)])return;VisuMZ[_0x273114(0xa0c)](_0x55a054,_0x55a054);const _0x4db51e=VisuMZ[_0x273114(0x41c)](_0x55a054[_0x273114(0x179)]);for(const _0x319daf of _0x4db51e){if(!_0x319daf)continue;_0x319daf[_0x273114(0x9ca)]();}}),PluginManager['registerCommand'](pluginData[_0x251720(0x1f8)],_0x251720(0x4e0),_0x172eac=>{const _0x46d781=_0x251720;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0x334585=SceneManager[_0x46d781(0x35b)][_0x46d781(0x742)];if(!_0x334585)return;VisuMZ['ConvertParams'](_0x172eac,_0x172eac);const _0x56a97e=_0x172eac['X']||0x0,_0x4f4d48=_0x172eac['Y']||0x0,_0x5a5dca=_0x172eac[_0x46d781(0x654)]||0x0,_0x53edb1=_0x172eac['Wave']||0x0,_0x4a05a5=_0x172eac['Duration']||0x1;_0x334585['setupShockwaveImpactFilter'](_0x56a97e,_0x4f4d48,_0x5a5dca,_0x53edb1,_0x4a05a5);}),PluginManager[_0x251720(0x24b)](pluginData['name'],_0x251720(0x347),_0x2efd95=>{const _0x1ae70c=_0x251720;if(!SceneManager[_0x1ae70c(0x847)]())return;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0x4cf45c=SceneManager[_0x1ae70c(0x35b)][_0x1ae70c(0x742)];if(!_0x4cf45c)return;VisuMZ[_0x1ae70c(0xa0c)](_0x2efd95,_0x2efd95);const _0x2e2ae0=VisuMZ['CreateActionSequenceTargets'](_0x2efd95[_0x1ae70c(0x179)]),_0x5a94cb=_0x2efd95[_0x1ae70c(0x124)],_0x29ba99=_0x2efd95[_0x1ae70c(0x38a)]||0x0,_0x3cbdd6=_0x2efd95['OffsetY']||0x0,_0x321256=_0x2efd95[_0x1ae70c(0x654)]||0x0,_0x4b4c1f=_0x2efd95[_0x1ae70c(0x14b)]||0x0,_0x294eef=_0x2efd95[_0x1ae70c(0x19f)]||0x1;for(const _0x4b3ee3 of _0x2e2ae0){if(!_0x4b3ee3)continue;if(!_0x4b3ee3['battler']())continue;const _0x1cc84f=_0x4b3ee3['battler']();let _0x310946=_0x1cc84f[_0x1ae70c(0x176)],_0x1ab078=_0x1cc84f[_0x1ae70c(0x6cc)];_0x310946+=(Graphics[_0x1ae70c(0x139)]-Graphics[_0x1ae70c(0x13f)])/0x2,_0x1ab078+=(Graphics[_0x1ae70c(0x442)]-Graphics[_0x1ae70c(0x635)])/0x2;if(_0x5a94cb[_0x1ae70c(0x591)](/front/i))_0x1ae70c(0x4ae)===_0x1ae70c(0x4ae)?_0x310946+=(_0x4b3ee3['isEnemy']()?0x1:-0x1)*_0x1cc84f[_0x1ae70c(0x6f9)]()/0x2:(_0x2fb3ac[_0x1ae70c(0x731)]['Window_PartyCommand_initialize']['call'](this,_0x222ea6),this[_0x1ae70c(0xa5c)](_0x215737));else{if(_0x5a94cb[_0x1ae70c(0x591)](/back/i)){if(_0x1ae70c(0x5cd)!=='VnVjO')_0x310946+=(_0x4b3ee3['isEnemy']()?-0x1:0x1)*_0x1cc84f[_0x1ae70c(0x6f9)]()/0x2;else return _0x1a429b[_0x1ae70c(0x731)][_0x1ae70c(0x825)][_0x1ae70c(0x98)]['SmoothImage'];}}if(_0x5a94cb[_0x1ae70c(0x591)](/head/i))_0x1ab078-=_0x1cc84f[_0x1ae70c(0x1d6)]();else _0x5a94cb[_0x1ae70c(0x591)](/center/i)&&(_0x1ab078-=_0x1cc84f[_0x1ae70c(0x1d6)]()/0x2);_0x310946+=_0x29ba99,_0x1ab078+=_0x3cbdd6,_0x4cf45c[_0x1ae70c(0x6d6)](_0x310946,_0x1ab078,_0x321256,_0x4b4c1f,_0x294eef);}}),PluginManager['registerCommand'](pluginData['name'],_0x251720(0x4b9),_0x57c2ba=>{const _0x2c533b=_0x251720;if(!SceneManager[_0x2c533b(0x847)]())return;if(!Imported[_0x2c533b(0x32d)])return;const _0x13874f=SceneManager['_scene'][_0x2c533b(0x742)];if(!_0x13874f)return;VisuMZ[_0x2c533b(0xa0c)](_0x57c2ba,_0x57c2ba);const _0x419913=VisuMZ[_0x2c533b(0x41c)](_0x57c2ba['Targets']),_0x71cfa4=_0x57c2ba[_0x2c533b(0x124)],_0x14e4e0=_0x57c2ba['OffsetX']||0x0,_0x53c123=_0x57c2ba[_0x2c533b(0x3bb)]||0x0,_0x506489=_0x57c2ba[_0x2c533b(0x654)]||0x0,_0x217af0=_0x57c2ba[_0x2c533b(0x14b)]||0x0,_0x4ea8a2=_0x57c2ba[_0x2c533b(0x19f)]||0x1,_0x211e94=Math[_0x2c533b(0x1c4)](..._0x419913['map'](_0x500371=>_0x500371[_0x2c533b(0x60a)]()[_0x2c533b(0x176)]-_0x500371[_0x2c533b(0x60a)]()['mainSpriteWidth']()/0x2)),_0x3daa79=Math[_0x2c533b(0x79a)](..._0x419913['map'](_0x19180a=>_0x19180a[_0x2c533b(0x60a)]()[_0x2c533b(0x176)]+_0x19180a[_0x2c533b(0x60a)]()[_0x2c533b(0x6f9)]()/0x2)),_0x46abfc=Math[_0x2c533b(0x1c4)](..._0x419913[_0x2c533b(0x259)](_0x53d07e=>_0x53d07e[_0x2c533b(0x60a)]()[_0x2c533b(0x6cc)]-_0x53d07e[_0x2c533b(0x60a)]()['mainSpriteHeight']())),_0x12ba8c=Math[_0x2c533b(0x79a)](..._0x419913[_0x2c533b(0x259)](_0xeb64a8=>_0xeb64a8['battler']()[_0x2c533b(0x6cc)])),_0x46329a=_0x419913['filter'](_0x558ffc=>_0x558ffc[_0x2c533b(0x4f2)]())['length'],_0x1b1816=_0x419913[_0x2c533b(0x778)](_0x1f15ab=>_0x1f15ab[_0x2c533b(0x722)]())[_0x2c533b(0x988)];let _0x280c01=0x0,_0x569f83=0x0;if(_0x71cfa4['match'](/front/i)){if(_0x2c533b(0x6c5)===_0x2c533b(0x131)){if(!this['_battler'])return;this[_0x2c533b(0x188)]=this[_0x2c533b(0x397)][_0x2c533b(0x58e)](),this['_shadowScaleY']=this[_0x2c533b(0x397)][_0x2c533b(0x2ad)]();}else _0x280c01=_0x46329a>=_0x1b1816?_0x211e94:_0x3daa79;}else{if(_0x71cfa4[_0x2c533b(0x591)](/middle/i))_0x280c01=(_0x211e94+_0x3daa79)/0x2,melee=-0x1;else _0x71cfa4[_0x2c533b(0x591)](/back/i)&&(_0x280c01=_0x46329a>=_0x1b1816?_0x3daa79:_0x211e94);}if(_0x71cfa4[_0x2c533b(0x591)](/head/i))_0x569f83=_0x46abfc;else{if(_0x71cfa4[_0x2c533b(0x591)](/center/i))_0x569f83=(_0x46abfc+_0x12ba8c)/0x2;else _0x71cfa4[_0x2c533b(0x591)](/base/i)&&(_0x569f83=_0x12ba8c);}_0x280c01+=(Graphics[_0x2c533b(0x139)]-Graphics[_0x2c533b(0x13f)])/0x2,_0x569f83+=(Graphics[_0x2c533b(0x442)]-Graphics[_0x2c533b(0x635)])/0x2,_0x280c01+=_0x14e4e0,_0x569f83+=_0x53c123,_0x13874f[_0x2c533b(0x6d6)](_0x280c01,_0x569f83,_0x506489,_0x217af0,_0x4ea8a2);}),PluginManager[_0x251720(0x24b)](pluginData['name'],'ActSeq_Impact_ZoomBlurPoint',_0x15009f=>{const _0x1cb474=_0x251720;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0x551ff7=SceneManager[_0x1cb474(0x35b)][_0x1cb474(0x742)];if(!_0x551ff7)return;VisuMZ['ConvertParams'](_0x15009f,_0x15009f);const _0x4e9f72=_0x15009f['X']||0x0,_0x574a75=_0x15009f['Y']||0x0,_0x2d8249=_0x15009f[_0x1cb474(0xac7)]||0x0,_0xb1bde=_0x15009f[_0x1cb474(0x2af)]||0x0,_0x527252=_0x15009f[_0x1cb474(0x19f)]||0x1,_0x121df0=_0x15009f['EasingType']||'Linear';_0x551ff7[_0x1cb474(0x87b)](_0x2d8249,_0x4e9f72,_0x574a75,_0xb1bde,_0x527252,_0x121df0);}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],'ActSeq_Impact_ZoomBlurTargetCenter',_0x1a8490=>{const _0x4fba18=_0x251720;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0x4ecc84=SceneManager[_0x4fba18(0x35b)][_0x4fba18(0x742)];if(!_0x4ecc84)return;VisuMZ['ConvertParams'](_0x1a8490,_0x1a8490);const _0x580cdb=VisuMZ[_0x4fba18(0x41c)](_0x1a8490[_0x4fba18(0x179)]),_0x200c70=_0x1a8490[_0x4fba18(0x124)],_0x316b70=_0x1a8490['OffsetX']||0x0,_0x531eae=_0x1a8490[_0x4fba18(0x3bb)]||0x0,_0x191773=_0x1a8490[_0x4fba18(0xac7)]||0x0,_0x5235dc=_0x1a8490[_0x4fba18(0x2af)]||0x0,_0x3d4bb6=_0x1a8490['Duration']||0x1,_0x2f10c1=_0x1a8490['EasingType']||'Linear',_0x2460be=Math['min'](..._0x580cdb['map'](_0x8f5ed1=>_0x8f5ed1['battler']()[_0x4fba18(0x176)]-_0x8f5ed1[_0x4fba18(0x60a)]()[_0x4fba18(0x6f9)]()/0x2)),_0x1d0710=Math[_0x4fba18(0x79a)](..._0x580cdb[_0x4fba18(0x259)](_0xefa035=>_0xefa035['battler']()[_0x4fba18(0x176)]+_0xefa035['battler']()[_0x4fba18(0x6f9)]()/0x2)),_0x4222de=Math[_0x4fba18(0x1c4)](..._0x580cdb[_0x4fba18(0x259)](_0x18d394=>_0x18d394[_0x4fba18(0x60a)]()[_0x4fba18(0x6cc)]-_0x18d394[_0x4fba18(0x60a)]()['mainSpriteHeight']())),_0x27db6a=Math[_0x4fba18(0x79a)](..._0x580cdb[_0x4fba18(0x259)](_0x446642=>_0x446642[_0x4fba18(0x60a)]()[_0x4fba18(0x6cc)])),_0x176828=_0x580cdb[_0x4fba18(0x778)](_0x31004d=>_0x31004d[_0x4fba18(0x4f2)]())[_0x4fba18(0x988)],_0x304fc8=_0x580cdb[_0x4fba18(0x778)](_0x51347f=>_0x51347f[_0x4fba18(0x722)]())[_0x4fba18(0x988)];let _0x48668f=0x0,_0x51d3f5=0x0;if(_0x200c70[_0x4fba18(0x591)](/front/i))_0x48668f=_0x176828>=_0x304fc8?_0x2460be:_0x1d0710;else{if(_0x200c70[_0x4fba18(0x591)](/middle/i))_0x48668f=(_0x2460be+_0x1d0710)/0x2,melee=-0x1;else _0x200c70[_0x4fba18(0x591)](/back/i)&&(_0x48668f=_0x176828>=_0x304fc8?_0x1d0710:_0x2460be);}if(_0x200c70[_0x4fba18(0x591)](/head/i)){if(_0x4fba18(0x5f4)!==_0x4fba18(0x3b4))_0x51d3f5=_0x4222de;else return _0xa46e3b['setLastPluginCommandInterpreter'](this),_0xad017b[_0x4fba18(0x731)][_0x4fba18(0x171)]['call'](this,_0x3628b8);}else{if(_0x200c70[_0x4fba18(0x591)](/center/i)){if('AQZKM'!==_0x4fba18(0x846)){if(this[_0x4fba18(0x950)]())this[_0x4fba18(0xa55)]('PreStartTurnJS');_0x23e4f4['BattleCore'][_0x4fba18(0xa04)][_0x4fba18(0xa57)](this);if(this['isTurnBased']())this[_0x4fba18(0xa55)](_0x4fba18(0x548));}else _0x51d3f5=(_0x4222de+_0x27db6a)/0x2;}else _0x200c70['match'](/base/i)&&(_0x51d3f5=_0x27db6a);}_0x48668f+=(Graphics[_0x4fba18(0x139)]-Graphics[_0x4fba18(0x13f)])/0x2,_0x51d3f5+=(Graphics['height']-Graphics[_0x4fba18(0x635)])/0x2,_0x48668f+=_0x316b70,_0x51d3f5+=_0x531eae,_0x4ecc84[_0x4fba18(0x87b)](_0x191773,_0x48668f,_0x51d3f5,_0x5235dc,_0x3d4bb6,_0x2f10c1);}),PluginManager[_0x251720(0x24b)](pluginData['name'],_0x251720(0x810),_0x24e6ae=>{const _0x41e356=_0x251720;if(!SceneManager[_0x41e356(0x847)]())return;VisuMZ['ConvertParams'](_0x24e6ae,_0x24e6ae);const _0x2d127a=$gameTemp['getLastPluginCommandInterpreter'](),_0x144c10=BattleManager[_0x41e356(0x866)],_0x5526b1=BattleManager[_0x41e356(0x29b)],_0x3a18fb=BattleManager[_0x41e356(0x1cb)];if(!_0x2d127a||!_0x144c10||!_0x5526b1)return;if(!_0x144c10[_0x41e356(0x342)]())return;const _0x39db58=VisuMZ[_0x41e356(0x41c)](_0x24e6ae[_0x41e356(0x179)]);for(const _0x4bd52f of _0x39db58){if(!_0x4bd52f)continue;_0x3a18fb['push'](_0x41e356(0x973),_0x5526b1,_0x4bd52f);}_0x2d127a['setWaitMode'](_0x41e356(0x77f));}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0xa1c),_0x3b2a66=>{const _0x2ac6e5=_0x251720;if(!SceneManager[_0x2ac6e5(0x847)]())return;VisuMZ['ConvertParams'](_0x3b2a66,_0x3b2a66);const _0xfb0d38=[_0x2ac6e5(0xd9),'MAXMP',_0x2ac6e5(0x22f),_0x2ac6e5(0x38e),_0x2ac6e5(0x974),_0x2ac6e5(0xcc),'AGI',_0x2ac6e5(0x9dd)],_0x5a27c8=_0x3b2a66[_0x2ac6e5(0x47c)],_0x2476c8=_0x3b2a66['Debuffs'],_0xb20789=_0x3b2a66[_0x2ac6e5(0xc6)],_0x193e5a=VisuMZ['CreateActionSequenceTargets'](_0x3b2a66['Targets']);for(const _0x3093a7 of _0x193e5a){if(!_0x3093a7)continue;for(const _0x558e33 of _0x5a27c8){const _0x59d29a=_0xfb0d38[_0x2ac6e5(0x2dd)](_0x558e33[_0x2ac6e5(0x62a)]()[_0x2ac6e5(0x30b)]());_0x59d29a>=0x0&&_0x59d29a<=0x7&&_0x3093a7['addBuff'](_0x59d29a,_0xb20789);}for(const _0x352310 of _0x2476c8){const _0x33d160=_0xfb0d38['indexOf'](_0x352310['toUpperCase']()[_0x2ac6e5(0x30b)]());_0x33d160>=0x0&&_0x33d160<=0x7&&(_0x2ac6e5(0x867)!==_0x2ac6e5(0x867)?(this[_0x2ac6e5(0xa55)](_0x2ac6e5(0x6f8)),_0x28998e[_0x2ac6e5(0x731)][_0x2ac6e5(0x72f)][_0x2ac6e5(0xa57)](this),this[_0x2ac6e5(0xa66)]('Victory')):_0x3093a7[_0x2ac6e5(0x42c)](_0x33d160,_0xb20789));}}}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x415),_0xc32aca=>{const _0x159457=_0x251720;if(!SceneManager[_0x159457(0x847)]())return;VisuMZ[_0x159457(0xa0c)](_0xc32aca,_0xc32aca);const _0x4ce8d0=_0xc32aca['States'],_0x2549fc=VisuMZ[_0x159457(0x41c)](_0xc32aca[_0x159457(0x179)]);for(const _0x5a7c11 of _0x2549fc){if(_0x159457(0x6e1)!=='nqUVR')return _0x22954e[_0x159457(0x6bf)]-_0xc4fee6[_0x159457(0x6bf)];else{if(!_0x5a7c11)continue;for(const _0x35fe32 of _0x4ce8d0){_0x5a7c11[_0x159457(0x909)](_0x35fe32);}}}}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],'ActSeq_Mechanics_ArmorPenetration',_0x4321a9=>{const _0x342840=_0x251720;if(!SceneManager[_0x342840(0x847)]())return;VisuMZ['ConvertParams'](_0x4321a9,_0x4321a9);const _0x80df20=BattleManager[_0x342840(0x866)],_0x2266a4={'arPenRate':_0x4321a9[_0x342840(0x822)],'arPenFlat':_0x4321a9[_0x342840(0x4fa)],'arRedRate':_0x4321a9[_0x342840(0x602)],'arRedFlat':_0x4321a9[_0x342840(0x20e)]};_0x80df20[_0x342840(0x687)]=_0x2266a4;}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x496),_0x57135b=>{const _0x4a4f3c=_0x251720;if(!SceneManager[_0x4a4f3c(0x847)]())return;if(!Imported[_0x4a4f3c(0x4e7)])return;VisuMZ[_0x4a4f3c(0xa0c)](_0x57135b,_0x57135b);const _0x18e5ec=VisuMZ[_0x4a4f3c(0x41c)](_0x57135b[_0x4a4f3c(0x179)]),_0x8f07f8=_0x57135b[_0x4a4f3c(0x3e8)]||0x1;for(const _0x903f90 of _0x18e5ec){if(_0x4a4f3c(0x765)==='gcFrk'){if(!_0x903f90)continue;if(!_0x903f90[_0x4a4f3c(0x722)]())continue;_0x903f90[_0x4a4f3c(0x90)](_0x8f07f8);}else this['addSkillCommands']();}}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],'ActSeq_Mechanics_AtbGauge',_0x2094cf=>{const _0x26f0c8=_0x251720;if(!SceneManager[_0x26f0c8(0x847)]())return;if(!Imported['VisuMZ_2_BattleSystemATB'])return;if(!BattleManager[_0x26f0c8(0x99)]())return;VisuMZ['ConvertParams'](_0x2094cf,_0x2094cf);const _0x1c6a36=VisuMZ[_0x26f0c8(0x41c)](_0x2094cf[_0x26f0c8(0x179)]),_0x5be91c=_0x2094cf['ChargeRate'],_0xb6e381=_0x2094cf[_0x26f0c8(0x9cc)],_0x1f58d6=_0x2094cf['Interrupt'];for(const _0x25755e of _0x1c6a36){if(!_0x25755e)continue;if(_0x25755e[_0x26f0c8(0x72b)]())_0x25755e[_0x26f0c8(0x80a)](_0x5be91c);else{if(_0x25755e[_0x26f0c8(0x1dd)]()){if(_0x26f0c8(0x2fd)!=='jKVEA')this[_0x26f0c8(0x8cb)]=this[_0x26f0c8(0x45b)]['slice'](0x0),this[_0x26f0c8(0x1d1)]=0x0,this[_0x26f0c8(0x312)]=this[_0x26f0c8(0x8cb)][0x0]||null,this['_phase']=_0x26f0c8(0x3be);else{_0x25755e['changeAtbCastTime'](_0xb6e381);if(_0x1f58d6)_0x25755e[_0x26f0c8(0x9a4)]();}}}}}),PluginManager['registerCommand'](pluginData[_0x251720(0x1f8)],'ActSeq_Mechanics_BoostPointsChange',_0xa60f00=>{const _0x13428b=_0x251720;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x13428b(0x395)])return;VisuMZ[_0x13428b(0xa0c)](_0xa60f00,_0xa60f00);const _0xf14e61=VisuMZ[_0x13428b(0x41c)](_0xa60f00[_0x13428b(0x179)]),_0x47691d=_0xa60f00[_0x13428b(0x15f)];for(const _0x3af41f of _0xf14e61){if(!_0x3af41f)continue;_0x3af41f[_0x13428b(0x8b6)](_0x47691d);}}),PluginManager['registerCommand'](pluginData[_0x251720(0x1f8)],_0x251720(0x80c),_0x3de63d=>{const _0x4d4621=_0x251720;if(!SceneManager[_0x4d4621(0x847)]())return;if(!Imported[_0x4d4621(0x395)])return;if(!BattleManager['_subject'])return;VisuMZ[_0x4d4621(0xa0c)](_0x3de63d,_0x3de63d);const _0x4e5624=_0x3de63d[_0x4d4621(0x3a6)];$gameVariables['setValue'](_0x4e5624,BattleManager[_0x4d4621(0x29b)][_0x4d4621(0x4d0)]());}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x462),_0x60e3cb=>{const _0x23b8fc=_0x251720;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x23b8fc(0x894)])return;VisuMZ['ConvertParams'](_0x60e3cb,_0x60e3cb);const _0x5415a1=VisuMZ[_0x23b8fc(0x41c)](_0x60e3cb[_0x23b8fc(0x179)]),_0x23551b=_0x60e3cb[_0x23b8fc(0x920)];for(const _0xb4f27b of _0x5415a1){if(!_0xb4f27b)continue;if(_0xb4f27b[_0x23b8fc(0x46e)]())continue;if(!_0xb4f27b[_0x23b8fc(0x4e1)]())continue;_0xb4f27b[_0x23b8fc(0x84e)](_0x23551b);}}),PluginManager[_0x251720(0x24b)](pluginData['name'],'ActSeq_Mechanics_BreakShieldReset',_0x20f8a3=>{const _0x268a18=_0x251720;if(!SceneManager[_0x268a18(0x847)]())return;if(!Imported[_0x268a18(0x894)])return;VisuMZ['ConvertParams'](_0x20f8a3,_0x20f8a3);const _0x5e4413=VisuMZ[_0x268a18(0x41c)](_0x20f8a3[_0x268a18(0x179)]);for(const _0x2c11c3 of _0x5e4413){if(_0x268a18(0x3a5)===_0x268a18(0x3a5)){if(!_0x2c11c3)continue;if(_0x2c11c3[_0x268a18(0x46e)]())continue;if(!_0x2c11c3[_0x268a18(0x4e1)]())continue;_0x2c11c3[_0x268a18(0x9ae)]();}else this[_0x268a18(0x9e)]();}}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],'ActSeq_Mechanics_BtbGain',_0x2495ae=>{const _0x1b51b8=_0x251720;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x1b51b8(0x976)])return;if(!BattleManager[_0x1b51b8(0x96f)]())return;VisuMZ[_0x1b51b8(0xa0c)](_0x2495ae,_0x2495ae);const _0x2fc758=VisuMZ['CreateActionSequenceTargets'](_0x2495ae[_0x1b51b8(0x179)]),_0x5b9efd=_0x2495ae[_0x1b51b8(0x64e)];for(const _0x23f664 of _0x2fc758){if(!_0x23f664)continue;_0x23f664[_0x1b51b8(0x29f)](_0x5b9efd);}}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x786),_0x498ab3=>{const _0x16c561=_0x251720;if(!SceneManager[_0x16c561(0x847)]())return;VisuMZ[_0x16c561(0xa0c)](_0x498ab3,_0x498ab3);const _0x5e1e6a=$gameTemp['getLastPluginCommandInterpreter'](),_0x1dd87c=BattleManager['_action'],_0x2930ce=BattleManager[_0x16c561(0x29b)];if(!_0x5e1e6a||!_0x1dd87c||!_0x2930ce)return;if(!_0x1dd87c[_0x16c561(0x342)]())return;const _0x6bed90=VisuMZ['CreateActionSequenceTargets'](_0x498ab3[_0x16c561(0x179)]);for(const _0x521c00 of _0x6bed90){if(_0x16c561(0xaa4)===_0x16c561(0xaa4)){if(!_0x521c00)continue;_0x498ab3[_0x16c561(0x4e9)]&&(_0x521c00['removeImmortal'](),_0x521c00[_0x16c561(0x909)](_0x521c00[_0x16c561(0x1b1)]())),_0x521c00[_0x16c561(0x490)]()&&(_0x16c561(0x6d2)!=='ASsKq'?_0x521c00[_0x16c561(0xd0)]():(_0x232dfd[_0x16c561(0x731)][_0x16c561(0x20b)][_0x16c561(0xa57)](this),this[_0x16c561(0x687)]={'arPenRate':0x0,'arPenFlat':0x0,'arRedRate':0x0,'arRedFlat':0x0},this[_0x16c561(0x2e7)]={'criticalHitRate':0x1,'criticalHitFlat':0x0,'criticalDmgRate':0x1,'criticalDmgFlat':0x0,'damageRate':0x1,'damageFlat':0x0,'hitRate':0x1,'hitFlat':0x0},this[_0x16c561(0x151)]=_0x16c561(0xa0f)));}else this[_0x16c561(0x694)]=(this['_currentAngle']*(_0xf68e03-0x1)+this[_0x16c561(0x1aa)])/_0x370dba;}_0x5e1e6a[_0x16c561(0x1a1)](_0x16c561(0x260));}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x3ae),_0x213fdf=>{const _0x2caaf4=_0x251720;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x2caaf4(0x4be)])return;if(!BattleManager['isCTB']())return;VisuMZ['ConvertParams'](_0x213fdf,_0x213fdf);const _0xa602de=VisuMZ[_0x2caaf4(0x41c)](_0x213fdf[_0x2caaf4(0x179)]),_0x1bb98e=_0x213fdf['ChangeOrderBy'];for(const _0x2c7d1b of _0xa602de){if(!_0x2c7d1b)continue;_0x2c7d1b['changeTurnOrderByCTB'](_0x1bb98e);}}),PluginManager[_0x251720(0x24b)](pluginData['name'],_0x251720(0xa02),_0x3481f=>{const _0x2e5ff4=_0x251720;if(!SceneManager[_0x2e5ff4(0x847)]())return;if(!Imported[_0x2e5ff4(0x4be)])return;if(!BattleManager[_0x2e5ff4(0x524)]())return;VisuMZ[_0x2e5ff4(0xa0c)](_0x3481f,_0x3481f);const _0x2b17b5=VisuMZ[_0x2e5ff4(0x41c)](_0x3481f[_0x2e5ff4(0x179)]),_0x4798e6=_0x3481f[_0x2e5ff4(0x9cc)],_0x1ec795=_0x3481f[_0x2e5ff4(0x9cc)];for(const _0x5c5e49 of _0x2b17b5){if(_0x2e5ff4(0x75b)===_0x2e5ff4(0xa8))_0x229859=(_0x580181+_0x34fea6)/0x2;else{if(!_0x5c5e49)continue;if(_0x5c5e49['_tpbState']==='charging')_0x2e5ff4(0xa7a)===_0x2e5ff4(0xa7a)?_0x5c5e49[_0x2e5ff4(0x7d2)](_0x4798e6):_0x101d8e['addDebuff'](_0xc0e5e7,_0x574536);else _0x5c5e49[_0x2e5ff4(0x7ef)]===_0x2e5ff4(0xa11)&&(_0x2e5ff4(0xa98)!==_0x2e5ff4(0x52b)?_0x5c5e49[_0x2e5ff4(0x3d0)](_0x1ec795):_0x2e496f[_0x2e5ff4(0x39c)](this[_0x2e5ff4(0x271)]()));}}}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],'ActSeq_Mechanics_CustomDmgFormula',_0x5762c6=>{const _0x181b67=_0x251720;if(!SceneManager['isSceneBattle']())return;VisuMZ['ConvertParams'](_0x5762c6,_0x5762c6);const _0x41035c=BattleManager[_0x181b67(0x866)];if(!_0x41035c)return;let _0x45147b=_0x5762c6[_0x181b67(0x413)];_0x41035c[_0x181b67(0x693)](_0x45147b);}),PluginManager['registerCommand'](pluginData[_0x251720(0x1f8)],_0x251720(0x525),_0x33b41a=>{const _0x8a0f80=_0x251720;if(!SceneManager[_0x8a0f80(0x847)]())return;VisuMZ['ConvertParams'](_0x33b41a,_0x33b41a);const _0x134a55=VisuMZ['CreateActionSequenceTargets'](_0x33b41a[_0x8a0f80(0x179)]);for(const _0x3d00af of _0x134a55){if(!_0x3d00af)continue;if(_0x3d00af[_0x8a0f80(0x2a0)]())_0x3d00af[_0x8a0f80(0x3f3)]();}}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x7c2),_0x55da32=>{const _0x1b72d8=_0x251720;if(!SceneManager[_0x1b72d8(0x847)]())return;VisuMZ[_0x1b72d8(0xa0c)](_0x55da32,_0x55da32);const _0x2d01db=$gameTemp[_0x1b72d8(0x27e)](),_0x3beb3b=BattleManager[_0x1b72d8(0x29b)],_0x5aa879=_0x55da32[_0x1b72d8(0x2bc)];if(!_0x2d01db)return;if(!_0x3beb3b)return;_0x3beb3b&&_0x3beb3b[_0x1b72d8(0x864)]()&&_0x5aa879[_0x1b72d8(0x62a)]()[_0x1b72d8(0x30b)]()!=='UNTITLED'&&_0x2d01db['command119']([_0x5aa879]);}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x99c),_0x4cced8=>{const _0x5b0e5b=_0x251720;if(!SceneManager[_0x5b0e5b(0x847)]())return;VisuMZ[_0x5b0e5b(0xa0c)](_0x4cced8,_0x4cced8);const _0x146465=VisuMZ['CreateActionSequenceTargets'](_0x4cced8['Targets']);for(const _0x20a24b of _0x146465){if('kfpSd'!=='kfpSd')return _0x426851=_0x368add['BattleCore'][_0x5b0e5b(0x825)]['Damage'][_0x5b0e5b(0x1ef)][_0x5b0e5b(0xa57)](this,_0x187f89),_0x3f5a04=this[_0x5b0e5b(0x2e7)][_0x5b0e5b(0x8b8)]*_0x4c6a42+this[_0x5b0e5b(0x2e7)]['criticalDmgFlat'],_0x47cf0;else{if(!_0x20a24b)continue;if(!_0x20a24b[_0x5b0e5b(0x722)]())continue;_0x20a24b[_0x5b0e5b(0x5f1)]();}}}),PluginManager['registerCommand'](pluginData['name'],'ActSeq_Mechanics_EtbAction',_0x461d31=>{const _0x21115d=_0x251720;if(!SceneManager[_0x21115d(0x847)]())return;if(!Imported[_0x21115d(0xaa7)])return;if(!BattleManager['isETB']())return;VisuMZ[_0x21115d(0xa0c)](_0x461d31,_0x461d31);const _0x78c75d=_0x461d31['ActionCount'];if(BattleManager[_0x21115d(0x29b)]){if(_0x21115d(0x4da)!==_0x21115d(0x5ff))BattleManager['_subject']['friendsUnit']()[_0x21115d(0x18d)](_0x78c75d);else{let _0x179e65=-0x10,_0x2dfac2=this[_0x21115d(0x442)]*0.5;const _0x1c85ac=/<SIDEVIEW WEAPON OFFSET:[ ]([\+\-]\d+),[ ]([\+\-]\d+)>/i,_0x2eeb6e=this[_0x21115d(0x397)][_0x21115d(0xabc)]()[_0x21115d(0x259)](_0x4cc7ff=>_0x4cc7ff&&_0x4cc7ff[_0x21115d(0x67f)]['match'](_0x1c85ac)?_0x82a7ef(_0x51e1ed['$1']):0x0),_0xf35544=this['_battler']['traitObjects']()[_0x21115d(0x259)](_0x15551c=>_0x15551c&&_0x15551c[_0x21115d(0x67f)][_0x21115d(0x591)](_0x1c85ac)?_0x23a622(_0x10eb57['$2']):0x0);_0x179e65=_0x2eeb6e[_0x21115d(0x843)]((_0xfb5c92,_0x551565)=>_0xfb5c92+_0x551565,_0x179e65),_0x2dfac2=_0xf35544[_0x21115d(0x843)]((_0x5c639e,_0x5cbbfd)=>_0x5c639e+_0x5cbbfd,_0x2dfac2),this[_0x21115d(0x488)]['x']=_0x179e65,this[_0x21115d(0x488)]['y']=_0x2dfac2,this[_0x21115d(0x488)][_0x21115d(0xc8)]();}}}),PluginManager[_0x251720(0x24b)](pluginData['name'],_0x251720(0x168),_0x2227b1=>{const _0xdf5215=_0x251720;if(!SceneManager[_0xdf5215(0x847)]())return;if(!Imported[_0xdf5215(0x5fe)])return;if(!BattleManager['isFTB']())return;VisuMZ['ConvertParams'](_0x2227b1,_0x2227b1);const _0xc130ca=_0x2227b1[_0xdf5215(0x9fe)];BattleManager[_0xdf5215(0x29b)]&&BattleManager[_0xdf5215(0x29b)][_0xdf5215(0x366)]()[_0xdf5215(0x423)](_0xc130ca);}),PluginManager[_0x251720(0x24b)](pluginData['name'],_0x251720(0x1bc),_0x2edd1f=>{const _0x423903=_0x251720;if(!SceneManager[_0x423903(0x847)]())return;VisuMZ['ConvertParams'](_0x2edd1f,_0x2edd1f);const _0x3ea0ca=VisuMZ[_0x423903(0x41c)](_0x2edd1f['Targets']),_0x52945e=_0x2edd1f[_0x423903(0x12c)],_0x4d065a=_0x2edd1f[_0x423903(0x6fd)],_0x46e177=_0x2edd1f[_0x423903(0x97d)],_0x281d1e=_0x2edd1f[_0x423903(0x79d)],_0x2041e3=_0x2edd1f[_0x423903(0xac4)],_0x17088b=_0x2edd1f[_0x423903(0x7b6)],_0x1d8019=_0x2edd1f[_0x423903(0x9ea)];for(const _0x277293 of _0x3ea0ca){if(_0x423903(0x165)!==_0x423903(0x165)){const _0x2a8d73=this[_0x423903(0x60a)]();if(_0x2a8d73&&_0x5e2059)_0x2a8d73[_0x423903(0x4c0)]();return;}else{if(!_0x277293)continue;const _0x10f5a1=_0x277293['isAlive'](),_0xbc2bb3=Math['round'](_0x52945e*_0x277293[_0x423903(0x21f)]+_0x4d065a),_0x5afbb7=Math[_0x423903(0x3e4)](_0x46e177*_0x277293['mmp']+_0x281d1e),_0x12d0da=Math['round'](_0x2041e3*_0x277293[_0x423903(0x975)]()+_0x17088b);if(_0xbc2bb3!==0x0)_0x277293[_0x423903(0x47b)](_0xbc2bb3);if(_0x5afbb7!==0x0)_0x277293[_0x423903(0x752)](_0x5afbb7);if(_0x12d0da!==0x0)_0x277293[_0x423903(0x25b)](_0x12d0da);if(_0x1d8019)_0x277293['startDamagePopup']();if(_0x10f5a1&&_0x277293['isDead']()){if('CIMWj'!=='CIMWj')return _0x299379['BattleCore'][_0x423903(0x4b5)][_0x423903(0xa57)](this);else _0x277293[_0x423903(0xd0)]();}}}}),PluginManager['registerCommand'](pluginData[_0x251720(0x1f8)],_0x251720(0x242),_0x1c7e97=>{const _0x13c25e=_0x251720;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x13c25e(0xa0c)](_0x1c7e97,_0x1c7e97);const _0x4dfc1e=VisuMZ[_0x13c25e(0x41c)](_0x1c7e97[_0x13c25e(0x179)]);for(const _0x5785fb of _0x4dfc1e){if(!_0x5785fb)continue;_0x5785fb['setImmortal'](_0x1c7e97[_0x13c25e(0x981)]);}}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x233),_0xbada55=>{const _0x2032ce=_0x251720;if(!SceneManager['isSceneBattle']())return;VisuMZ['ConvertParams'](_0xbada55,_0xbada55);const _0x577a5d=BattleManager[_0x2032ce(0x866)],_0x246a82={'criticalHitRate':_0xbada55[_0x2032ce(0xa1f)],'criticalHitFlat':_0xbada55[_0x2032ce(0x5b1)],'criticalDmgRate':_0xbada55['CriticalDmgRate'],'criticalDmgFlat':_0xbada55['CriticalDmgFlat'],'damageRate':_0xbada55['DamageRate'],'damageFlat':_0xbada55[_0x2032ce(0xabe)],'hitRate':_0xbada55[_0x2032ce(0x685)],'hitFlat':_0xbada55[_0x2032ce(0x6de)]};_0x577a5d['_multipliers']=_0x246a82;}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x2d3),_0x37b681=>{const _0x337466=_0x251720;if(!SceneManager[_0x337466(0x847)]())return;if(!Imported[_0x337466(0x447)])return;if(!BattleManager[_0x337466(0x6ca)]())return;VisuMZ['ConvertParams'](_0x37b681,_0x37b681);const _0x25a291=VisuMZ[_0x337466(0x41c)](_0x37b681['Targets']);for(const _0x22aa64 of _0x25a291){if(!_0x22aa64)continue;let _0x28d469=_0x37b681[_0x337466(0x509)],_0xc53e09=_0x37b681[_0x337466(0x900)],_0x5651ed=_0x37b681[_0x337466(0xa74)];BattleManager['_actionBattlers']['includes'](_0x22aa64)?_0x337466(0xa6b)!=='WMpoT'?this['_forcedBattleLayout']='sideview_ui':_0x28d469+=_0x5651ed:_0xc53e09+=_0x5651ed,BattleManager[_0x337466(0x7b4)](_0x22aa64,-_0x28d469,![]),BattleManager['turnOrderChangeOTB'](_0x22aa64,-_0xc53e09,!![]);}}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x398),_0x687418=>{const _0x2d6e67=_0x251720;if(!SceneManager[_0x2d6e67(0x847)]())return;if(!Imported[_0x2d6e67(0x41e)])return;if(!BattleManager[_0x2d6e67(0xa8e)]())return;VisuMZ[_0x2d6e67(0xa0c)](_0x687418,_0x687418);const _0x623e1c=BattleManager['_subject']['friendsUnit'](),_0x5ec14b=_0x687418['Override'],_0x35175b=_0x687418[_0x2d6e67(0xaa1)]||'unchanged',_0x7f4bce=_0x687418[_0x2d6e67(0x13e)]||_0x2d6e67(0x6e9),_0x244802=_0x687418[_0x2d6e67(0x8df)]||0x0,_0x19511f=_0x687418[_0x2d6e67(0x87e)]||0x0;if(_0x623e1c[_0x2d6e67(0x1f4)]()||_0x5ec14b){if(_0x2d6e67(0x603)!==_0x2d6e67(0x133))_0x5ec14b&&(_0x623e1c['_ptbActionCost']=_0x623e1c[_0x2d6e67(0x4fc)]||{},_0x623e1c[_0x2d6e67(0x4fc)]['priority']=0x0),_0x623e1c[_0x2d6e67(0x184)](_0x35175b,_0x7f4bce,_0x244802,_0x19511f);else{this[_0x2d6e67(0x5c4)]=new _0x4a6b3b();for(let _0x278854=0x0;_0x278854<0x9;_0x278854++){this[_0x2d6e67(0x5c4)][_0x2d6e67(0x26f)](new _0x1ea4f4());}this[_0x2d6e67(0x361)]['addChild'](this[_0x2d6e67(0x5c4)]);}}}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x4ff),_0x4af242=>{const _0x28fc28=_0x251720;if(!SceneManager[_0x28fc28(0x847)]())return;if(!Imported[_0x28fc28(0x41e)])return;if(!BattleManager[_0x28fc28(0xa8e)]())return;VisuMZ[_0x28fc28(0xa0c)](_0x4af242,_0x4af242);const _0x4c78cb=BattleManager['_subject'][_0x28fc28(0x366)]();let _0x455154=Math[_0x28fc28(0x79a)](_0x4af242[_0x28fc28(0x170)],0x0),_0x10dc0a=_0x4c78cb['getFullActionsPTB'](),_0x6700c7=_0x4c78cb[_0x28fc28(0x473)]();while(_0x455154--){if(_0x10dc0a<=0x0&&_0x6700c7<=0x0)break;else _0x10dc0a>0x0?_0x28fc28(0x75f)===_0x28fc28(0x207)?_0x4a93af=_0x28fc28(0x8cc):(_0x10dc0a--,_0x6700c7++):_0x6700c7--;}_0x4c78cb[_0x28fc28(0x503)](_0x10dc0a),_0x4c78cb[_0x28fc28(0x51c)](_0x6700c7);}),PluginManager[_0x251720(0x24b)](pluginData['name'],_0x251720(0x276),_0x4dfe29=>{const _0x1b0269=_0x251720;if(!SceneManager[_0x1b0269(0x847)]())return;if(!Imported[_0x1b0269(0x41e)])return;if(!BattleManager['isPTB']())return;VisuMZ[_0x1b0269(0xa0c)](_0x4dfe29,_0x4dfe29);const _0xe45058=BattleManager[_0x1b0269(0x29b)][_0x1b0269(0x366)]();let _0x3dc54d=_0x4dfe29[_0x1b0269(0x4e4)],_0x26a1b4=_0x4dfe29[_0x1b0269(0x477)];_0xe45058[_0x1b0269(0x65d)](_0x3dc54d),_0xe45058[_0x1b0269(0x74c)](_0x26a1b4);}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],'ActSeq_Mechanics_RemoveBuffDebuff',_0x5bd158=>{const _0x43f1c6=_0x251720;if(!SceneManager[_0x43f1c6(0x847)]())return;VisuMZ['ConvertParams'](_0x5bd158,_0x5bd158);const _0x2c0fc0=[_0x43f1c6(0xd9),'MAXMP',_0x43f1c6(0x22f),'DEF',_0x43f1c6(0x974),'MDF',_0x43f1c6(0x1a5),_0x43f1c6(0x9dd)],_0x3d4351=_0x5bd158['Buffs'],_0x2c2925=_0x5bd158[_0x43f1c6(0xa6f)],_0x36ae7e=VisuMZ['CreateActionSequenceTargets'](_0x5bd158[_0x43f1c6(0x179)]);for(const _0x1c6a07 of _0x36ae7e){if(!_0x1c6a07)continue;for(const _0x5e3d67 of _0x3d4351){const _0x56b681=_0x2c0fc0[_0x43f1c6(0x2dd)](_0x5e3d67['toUpperCase']()[_0x43f1c6(0x30b)]());if(_0x56b681>=0x0&&_0x56b681<=0x7&&_0x1c6a07['isBuffAffected'](_0x56b681)){if(_0x43f1c6(0x8f6)===_0x43f1c6(0x7e5)){if(!_0x27e9a1['isSceneBattle']())return;const _0xa04bef=_0x431742[_0x43f1c6(0x35b)][_0x43f1c6(0xa7b)];if(_0xa04bef)_0xa04bef['requestRefresh']();}else _0x1c6a07[_0x43f1c6(0xa8d)](_0x56b681);}}for(const _0x36190d of _0x2c2925){const _0x25a2b6=_0x2c0fc0[_0x43f1c6(0x2dd)](_0x36190d['toUpperCase']()[_0x43f1c6(0x30b)]());if(_0x25a2b6>=0x0&&_0x25a2b6<=0x7&&_0x1c6a07[_0x43f1c6(0x3f2)](_0x25a2b6)){if(_0x43f1c6(0x639)===_0x43f1c6(0x639))_0x1c6a07['removeBuff'](_0x25a2b6);else{const _0x2a143d=_0x2e64b1(_0x1e90a3['$1'])[_0x43f1c6(0xa45)](/[\r\n]+/)['remove'](''),_0x45708b=_0x40f22f['processRandomizedData'](_0x2a143d);_0x4f40b4[_0x43f1c6(0x87c)]=_0x2d7fc0[_0x43f1c6(0x385)](_0x45708b);}}}}}),PluginManager[_0x251720(0x24b)](pluginData['name'],_0x251720(0x60b),_0x52217c=>{const _0x1281e7=_0x251720;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x1281e7(0xa0c)](_0x52217c,_0x52217c);const _0x78b2a=_0x52217c[_0x1281e7(0x3df)],_0x2a75d1=VisuMZ[_0x1281e7(0x41c)](_0x52217c[_0x1281e7(0x179)]);for(const _0x2fe570 of _0x2a75d1){if(!_0x2fe570)continue;for(const _0x166e79 of _0x78b2a){_0x2fe570[_0x1281e7(0x4ad)](_0x166e79);}}}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x7c7),_0x252d2c=>{const _0x405dd2=_0x251720;if(!SceneManager[_0x405dd2(0x847)]())return;if(!Imported[_0x405dd2(0x47f)])return;if(!BattleManager[_0x405dd2(0x754)]())return;VisuMZ[_0x405dd2(0xa0c)](_0x252d2c,_0x252d2c);const _0x185dd1=_0x252d2c[_0x405dd2(0x64c)],_0x426f57=VisuMZ[_0x405dd2(0x41c)](_0x252d2c[_0x405dd2(0x179)]),_0x1033df=_0x252d2c[_0x405dd2(0x27d)],_0x157884=_0x252d2c[_0x405dd2(0x9f0)],_0xbdb981=_0x252d2c[_0x405dd2(0x585)],_0x269f09=BattleManager[_0x405dd2(0x866)];if(_0x185dd1)for(const _0x21ac73 of _0x426f57){if(!_0x21ac73)continue;if(_0x21ac73===user)continue;if(_0x1033df)_0x21ac73[_0x405dd2(0x212)](![]);_0x21ac73[_0x405dd2(0x26b)](BattleManager[_0x405dd2(0x29b)],_0x269f09);}if(_0x157884&&BattleManager[_0x405dd2(0x29b)]){if(_0x405dd2(0x350)!==_0x405dd2(0x350)){const _0x89a47d=_0x5f2103['VisuMZ_1_SkillsStatesCore']?_0x5dac51[_0x405dd2(0x42a)][_0x405dd2(0x825)]['Skills']:_0x1259e5[_0x405dd2(0x731)][_0x405dd2(0x825)]['ActorCmd'],_0x16d1c4=_0x1b1135[_0x405dd2(0x7b1)]['includes'](_0x3e54cd),_0x2aa486=_0x16d1c4?_0x89a47d[_0x405dd2(0x550)]:_0x89a47d[_0x405dd2(0x33b)];_0xb41799=_0x405dd2(0x969)[_0x405dd2(0x8d6)](_0x2aa486,_0x499bb8);}else{if(_0xbdb981)BattleManager[_0x405dd2(0x29b)][_0x405dd2(0x212)](![]);const _0x247b9a=_0x426f57[0x0];BattleManager[_0x405dd2(0x7a3)](_0x247b9a,_0x269f09);}}}),PluginManager['registerCommand'](pluginData[_0x251720(0x1f8)],_0x251720(0x404),_0x3844f4=>{const _0xd50452=_0x251720;if(!SceneManager[_0xd50452(0x847)]())return;if(!Imported['VisuMZ_2_BattleSystemSTB'])return;if(!BattleManager[_0xd50452(0x754)]())return;VisuMZ['ConvertParams'](_0x3844f4,_0x3844f4);const _0x51b446=_0x3844f4[_0xd50452(0x20c)];BattleManager[_0xd50452(0x29b)]&&('IyIrY'===_0xd50452(0x7d7)?BattleManager[_0xd50452(0x29b)]['stbGainInstant'](_0x51b446):(this['damageContainer']()[_0xd50452(0x9d7)](_0x4b41e4),this[_0xd50452(0x5a8)]['remove'](_0x422a1b),_0x4d9d41[_0xd50452(0x8f)]()));}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x6ac),_0x35b8a6=>{const _0x440b3b=_0x251720;if(!SceneManager[_0x440b3b(0x847)]())return;if(!Imported[_0x440b3b(0x47f)])return;if(!BattleManager['isSTB']())return;VisuMZ[_0x440b3b(0xa0c)](_0x35b8a6,_0x35b8a6);let _0x240f88=_0x35b8a6[_0x440b3b(0x20c)];if(BattleManager[_0x440b3b(0x29b)]){if(_0x440b3b(0x8bc)!==_0x440b3b(0xac3)){BattleManager[_0x440b3b(0x29b)][_0x440b3b(0x15d)]=BattleManager['_subject'][_0x440b3b(0x15d)]||[];while(_0x240f88--){if(_0x440b3b(0xa28)!==_0x440b3b(0xa28))_0x1780ab['BattleCore'][_0x440b3b(0x4f5)][_0x440b3b(0xa57)](this,_0x5d66a4);else{if(BattleManager[_0x440b3b(0x29b)][_0x440b3b(0x15d)][_0x440b3b(0x988)]<=0x0)break;BattleManager[_0x440b3b(0x29b)][_0x440b3b(0x15d)][_0x440b3b(0x7e7)]();}}}else return this['getMenuImage']();}}),PluginManager['registerCommand'](pluginData[_0x251720(0x1f8)],_0x251720(0x2cb),_0x2845c8=>{const _0x19a0f8=_0x251720;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x19a0f8(0x3fc)])return;VisuMZ[_0x19a0f8(0xa0c)](_0x2845c8,_0x2845c8);const _0x490d07=VisuMZ[_0x19a0f8(0x41c)](_0x2845c8[_0x19a0f8(0x179)]),_0x1bda51=_0x2845c8[_0x19a0f8(0xa15)];for(const _0x2eb306 of _0x490d07){if('IYhdI'===_0x19a0f8(0x6a4))return![];else{if(!_0x2eb306)continue;if(!_0x2eb306[_0x19a0f8(0x4f2)]())continue;_0x2eb306[_0x19a0f8(0x5f9)](_0x1bda51);}}}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x89),_0x17157c=>{const _0x379ec3=_0x251720;if(!SceneManager[_0x379ec3(0x847)]())return;VisuMZ['ConvertParams'](_0x17157c,_0x17157c);const _0x1c8518=VisuMZ[_0x379ec3(0x41c)](_0x17157c[_0x379ec3(0x179)]),_0x1d2a28=_0x17157c['Text'],_0x3c89e1={'textColor':ColorManager[_0x379ec3(0x58b)](_0x17157c['TextColor']),'flashColor':_0x17157c['FlashColor'],'flashDuration':_0x17157c['FlashDuration']};for(const _0x135a5a of _0x1c8518){if(!_0x135a5a)continue;_0x135a5a[_0x379ec3(0x33c)](_0x1d2a28,_0x3c89e1);}}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],'ActSeq_Mechanics_VariablePopup',_0x998a1c=>{const _0x2f134d=_0x251720;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x2f134d(0xa0c)](_0x998a1c,_0x998a1c);const _0x457aa2=VisuMZ[_0x2f134d(0x41c)](_0x998a1c[_0x2f134d(0x179)]);let _0x5b6012=$gameVariables[_0x2f134d(0x951)](_0x998a1c[_0x2f134d(0x6c3)]);Imported['VisuMZ_0_CoreEngine']&&_0x998a1c[_0x2f134d(0x23b)]&&(_0x5b6012=VisuMZ[_0x2f134d(0x4bd)](_0x5b6012));const _0x90f3b5=String(_0x5b6012),_0x35734d={'textColor':ColorManager[_0x2f134d(0x58b)](_0x998a1c[_0x2f134d(0x9b6)]),'flashColor':_0x998a1c[_0x2f134d(0x39a)],'flashDuration':_0x998a1c[_0x2f134d(0xa88)]};for(const _0x238b86 of _0x457aa2){if(!_0x238b86)continue;_0x238b86[_0x2f134d(0x33c)](_0x90f3b5,_0x35734d);}}),PluginManager[_0x251720(0x24b)](pluginData['name'],'ActSeq_Mechanics_WaitForEffect',_0x5d317d=>{const _0x4989ef=_0x251720;if(!SceneManager[_0x4989ef(0x847)]())return;const _0x2deee4=$gameTemp[_0x4989ef(0x27e)]();if(!_0x2deee4)return;_0x2deee4['setWaitMode'](_0x4989ef(0x260));}),PluginManager['registerCommand'](pluginData[_0x251720(0x1f8)],_0x251720(0x90a),_0x810c14=>{const _0x41ece1=_0x251720;if(!SceneManager[_0x41ece1(0x847)]())return;VisuMZ['ConvertParams'](_0x810c14,_0x810c14);const _0x43184b=VisuMZ['CreateActionSequenceTargets'](_0x810c14[_0x41ece1(0x179)]);for(const _0x32f9fa of _0x43184b){if(_0x41ece1(0xa62)!=='uAQSu')_0x1da7a0[_0x41ece1(0xac5)]()?_0x3b80ec[_0x41ece1(0x97e)][_0x41ece1(0x42f)][_0x41ece1(0xa57)](this):_0x34925e[_0x41ece1(0x731)][_0x41ece1(0x491)][_0x41ece1(0xa57)](this);else{if(!_0x32f9fa)continue;_0x32f9fa[_0x41ece1(0x985)]();}}}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],'ActSeq_Motion_FreezeMotionFrame',_0x13d529=>{const _0x2db5ea=_0x251720;if(!SceneManager[_0x2db5ea(0x847)]())return;VisuMZ[_0x2db5ea(0xa0c)](_0x13d529,_0x13d529);const _0x59bc06=VisuMZ[_0x2db5ea(0x41c)](_0x13d529[_0x2db5ea(0x179)]),_0x22ae05=_0x13d529[_0x2db5ea(0x386)][_0x2db5ea(0x612)]()['trim'](),_0x1cdf3f=_0x13d529[_0x2db5ea(0x216)],_0x1230b6=_0x13d529['Frame'];for(const _0x1dd1c1 of _0x59bc06){if(_0x2db5ea(0x19d)==='FtmgM'){let _0x2bf036=_0x171fa6(_0x17c721['$1']);while(_0x2bf036--){_0x2cb997['push'](this[_0x2db5ea(0x7f5)]()[_0x2db5ea(0x50d)]());}return this[_0x2db5ea(0x84d)](_0x1b7f90);}else{if(!_0x1dd1c1)continue;_0x1dd1c1['freezeMotion'](_0x22ae05,_0x1cdf3f,_0x1230b6);}}}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x9f3),_0x12842a=>{const _0x131ca2=_0x251720;if(!SceneManager[_0x131ca2(0x847)]())return;VisuMZ[_0x131ca2(0xa0c)](_0x12842a,_0x12842a);const _0x51d85f=VisuMZ[_0x131ca2(0x41c)](_0x12842a['Targets']),_0x15856d=_0x12842a['MotionType'][_0x131ca2(0x612)]()[_0x131ca2(0x30b)](),_0x5ec7e7=_0x12842a['ShowWeapon'];for(const _0x58f3e5 of _0x51d85f){if(_0x131ca2(0x3ba)==='XACLZ'){let _0xe8f59a=_0x367cc5[_0x131ca2(0x731)][_0x131ca2(0x49d)][_0x131ca2(0xa57)](this,_0x38c41d);return _0xe8f59a=this[_0x131ca2(0x2e7)][_0x131ca2(0x661)]*_0xe8f59a+this[_0x131ca2(0x2e7)][_0x131ca2(0x784)],_0xe8f59a;}else{if(!_0x58f3e5)continue;if(_0x15856d[_0x131ca2(0x591)](/ATTACK[ ](\d+)/i))_0x58f3e5[_0x131ca2(0x218)](Number(RegExp['$1']));else _0x15856d===_0x131ca2(0x6ff)?_0x58f3e5[_0x131ca2(0x62e)]():_0x58f3e5[_0x131ca2(0x995)](_0x15856d);if(!_0x5ec7e7){if(_0x131ca2(0x13b)!==_0x131ca2(0x13b)){if(!_0x49eb86[_0x131ca2(0x847)]())return;if(!_0x119733[_0x131ca2(0x46a)])return;_0x170101[_0x131ca2(0xa0c)](_0x1567b4,_0x4dff28);const _0x557289=_0x360db1[_0x131ca2(0x27e)](),_0x40967c=_0x37f744[_0x131ca2(0x646)];if(!_0x557289)return;const _0x403678=_0x2bdbd3[_0x131ca2(0x742)];if(!_0x403678)return;_0x403678['createActionSequenceProjectile'](_0x2e0013);if(_0x40967c)_0x557289['setWaitMode'](_0x131ca2(0x980));}else _0x58f3e5[_0x131ca2(0x7fa)](0x0);}else{if(_0x5ec7e7&&['thrust',_0x131ca2(0x389),'missle'][_0x131ca2(0x9b0)](_0x15856d)){}}}}}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x3a7),_0x5b74de=>{const _0x42b98d=_0x251720;if(!SceneManager[_0x42b98d(0x847)]())return;VisuMZ['ConvertParams'](_0x5b74de,_0x5b74de);const _0xad6f84=BattleManager[_0x42b98d(0x866)];if(!_0xad6f84)return;if(!_0xad6f84[_0x42b98d(0x342)]())return;const _0x5805de=VisuMZ[_0x42b98d(0x41c)](_0x5b74de[_0x42b98d(0x179)]);for(const _0x24912e of _0x5805de){if(_0x42b98d(0x7e4)===_0x42b98d(0x500))this['_canLose']=!![];else{if(!_0x24912e)continue;_0x24912e[_0x42b98d(0x702)](_0xad6f84);}}}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x47e),_0xe7f049=>{const _0x425310=_0x251720;if(!SceneManager[_0x425310(0x847)]())return;VisuMZ['ConvertParams'](_0xe7f049,_0xe7f049);const _0x1d64fc=VisuMZ['CreateActionSequenceTargets'](_0xe7f049[_0x425310(0x179)]);for(const _0x462adf of _0x1d64fc){if(!_0x462adf)continue;if(!_0x462adf[_0x425310(0x60a)]())continue;_0x462adf[_0x425310(0x60a)]()[_0x425310(0x853)]();}}),PluginManager[_0x251720(0x24b)](pluginData['name'],_0x251720(0x72d),_0x18b3f9=>{const _0x2dbc2f=_0x251720;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x2dbc2f(0xa0c)](_0x18b3f9,_0x18b3f9);const _0x3e2473=$gameTemp['getLastPluginCommandInterpreter'](),_0x1ebd98=_0x18b3f9[_0x2dbc2f(0x764)]*Sprite_Battler['_motionSpeed'];_0x3e2473[_0x2dbc2f(0x990)](_0x1ebd98);}),PluginManager[_0x251720(0x24b)](pluginData['name'],_0x251720(0x94e),_0x48cd79=>{const _0x9193ad=_0x251720;if(!SceneManager[_0x9193ad(0x847)]())return;VisuMZ[_0x9193ad(0xa0c)](_0x48cd79,_0x48cd79);const _0x298f69=$gameTemp['getLastPluginCommandInterpreter'](),_0x4f901f=BattleManager[_0x9193ad(0x866)];if(!_0x298f69||!_0x4f901f)return;if(!_0x4f901f[_0x9193ad(0x342)]())return;const _0x19ec5d=VisuMZ['CreateActionSequenceTargets'](_0x48cd79[_0x9193ad(0x179)]);for(const _0x5de012 of _0x19ec5d){if(!_0x5de012)continue;_0x5de012[_0x9193ad(0x7bb)](_0x4f901f);}if(_0x48cd79['WaitForMovement'])_0x298f69[_0x9193ad(0x1a1)](_0x9193ad(0x3cc));}),PluginManager[_0x251720(0x24b)](pluginData['name'],_0x251720(0x953),_0x282fc3=>{const _0x4e0490=_0x251720;if(!SceneManager[_0x4e0490(0x847)]())return;if(!$gameSystem[_0x4e0490(0x22c)]())return;VisuMZ[_0x4e0490(0xa0c)](_0x282fc3,_0x282fc3);const _0x2b9a4c=VisuMZ[_0x4e0490(0x41c)](_0x282fc3['Targets']);let _0x3b1988=_0x282fc3[_0x4e0490(0x289)][_0x4e0490(0x591)](/back/i);for(const _0x5be034 of _0x2b9a4c){if('tSKGq'!==_0x4e0490(0x91b)){if(!_0x5be034)continue;if(_0x282fc3[_0x4e0490(0x289)][_0x4e0490(0x591)](/rand/i))_0x3b1988=Math[_0x4e0490(0x9b7)](0x2);_0x5be034[_0x4e0490(0x79c)](!!_0x3b1988);}else this[_0x4e0490(0xa0d)]=_0x4e0490(0x234);}}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x506),_0x87fdfd=>{const _0x2a7c68=_0x251720;if(!SceneManager[_0x2a7c68(0x847)]())return;if(!$gameSystem['isSideView']())return;VisuMZ[_0x2a7c68(0xa0c)](_0x87fdfd,_0x87fdfd);const _0x435f3c=VisuMZ['CreateActionSequenceTargets'](_0x87fdfd[_0x2a7c68(0x179)]);let _0x4442de=_0x87fdfd['Point'];const _0x4829a8=_0x87fdfd[_0x2a7c68(0x4f7)];for(const _0x1808c2 of _0x435f3c){if(_0x2a7c68(0x1dc)===_0x2a7c68(0x1dc)){if(!_0x1808c2)continue;let _0x5a8929=_0x1808c2[_0x2a7c68(0x60a)]()['_baseX'],_0x22030e=_0x1808c2[_0x2a7c68(0x60a)]()['_baseY'];if(_0x4442de[_0x2a7c68(0x591)](/home/i))_0x5a8929=_0x1808c2['battler']()[_0x2a7c68(0x231)],_0x22030e=_0x1808c2[_0x2a7c68(0x60a)]()['_homeY'];else{if(_0x4442de[_0x2a7c68(0x591)](/center/i)){if('Bedge'===_0x2a7c68(0x852))_0x5a8929=Graphics[_0x2a7c68(0x13f)]/0x2,_0x22030e=Graphics[_0x2a7c68(0x635)]/0x2;else return _0x58c4ce[_0x2a7c68(0x731)]['Settings'][_0x2a7c68(0x8ca)][_0x2a7c68(0x6e8)];}else _0x4442de[_0x2a7c68(0x591)](/point (\d+), (\d+)/i)&&(_0x5a8929=Number(RegExp['$1']),_0x22030e=Number(RegExp['$2']));}_0x1808c2[_0x2a7c68(0x587)](Math[_0x2a7c68(0x3e4)](_0x5a8929),Math[_0x2a7c68(0x3e4)](_0x22030e),!!_0x4829a8);}else return _0xb6385d[_0x2a7c68(0x731)][_0x2a7c68(0x825)][_0x2a7c68(0x85f)][_0x2a7c68(0xe2)];}}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x725),_0x254b92=>{const _0x32279a=_0x251720;if(!SceneManager[_0x32279a(0x847)]())return;if(!$gameSystem[_0x32279a(0x22c)]())return;VisuMZ[_0x32279a(0xa0c)](_0x254b92,_0x254b92);const _0x435e69=VisuMZ[_0x32279a(0x41c)](_0x254b92[_0x32279a(0x618)]),_0x1b073f=VisuMZ['CreateActionSequenceTargets'](_0x254b92[_0x32279a(0xda)]),_0x464b17=_0x1b073f[_0x32279a(0x259)](_0x1c44d2=>_0x1c44d2&&_0x1c44d2[_0x32279a(0x60a)]()?_0x1c44d2[_0x32279a(0x60a)]()[_0x32279a(0x176)]:0x0)/(_0x1b073f[_0x32279a(0x988)]||0x1),_0x793c49=_0x1b073f[_0x32279a(0x259)](_0x5334e3=>_0x5334e3&&_0x5334e3[_0x32279a(0x60a)]()?_0x5334e3[_0x32279a(0x60a)]()['_baseY']:0x0)/(_0x1b073f[_0x32279a(0x988)]||0x1),_0x10449b=_0x254b92['FaceAway'];for(const _0x39d847 of _0x435e69){if(_0x32279a(0x526)===_0x32279a(0x526)){if(!_0x39d847)continue;_0x39d847[_0x32279a(0x587)](Math[_0x32279a(0x3e4)](_0x464b17),Math[_0x32279a(0x3e4)](_0x793c49),!!_0x10449b);}else this[_0x32279a(0x926)]=this[_0x32279a(0x5e8)],this[_0x32279a(0x926)]['_tpbState']=_0x32279a(0x174),this[_0x32279a(0xaa8)]=!![],this[_0x32279a(0x5e8)]=null;}}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],'ActSeq_Movement_Float',_0x53f24c=>{const _0x3f1595=_0x251720;if(!SceneManager[_0x3f1595(0x847)]())return;VisuMZ['ConvertParams'](_0x53f24c,_0x53f24c);const _0x1227ca=$gameTemp['getLastPluginCommandInterpreter'](),_0x378976=VisuMZ[_0x3f1595(0x41c)](_0x53f24c[_0x3f1595(0x179)]),_0x2dfb08=_0x53f24c[_0x3f1595(0xa34)],_0x395fba=_0x53f24c[_0x3f1595(0x19f)],_0x508697=_0x53f24c[_0x3f1595(0xc3)],_0x5e23a2=_0x53f24c['WaitForFloat'];if(!_0x1227ca)return;for(const _0x4441d8 of _0x378976){if(!_0x4441d8)continue;_0x4441d8[_0x3f1595(0x59e)](_0x2dfb08,_0x395fba,_0x508697);}if(_0x5e23a2)_0x1227ca[_0x3f1595(0x1a1)](_0x3f1595(0x202));}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],'ActSeq_Movement_HomeReset',_0x2d0b85=>{const _0x387b81=_0x251720;if(!SceneManager[_0x387b81(0x847)]())return;VisuMZ[_0x387b81(0xa0c)](_0x2d0b85,_0x2d0b85);const _0x3c39fd=$gameTemp[_0x387b81(0x27e)]();if(!_0x3c39fd)return;const _0x45fc23=VisuMZ[_0x387b81(0x41c)](_0x2d0b85[_0x387b81(0x179)]);for(const _0x11424f of _0x45fc23){if(!_0x11424f)continue;_0x11424f['performActionEndMembers']();}BattleManager[_0x387b81(0x29b)]&&BattleManager['_subject'][_0x387b81(0x29c)]();if(_0x2d0b85[_0x387b81(0x6e7)])_0x3c39fd[_0x387b81(0x1a1)]('battleMove');}),PluginManager[_0x251720(0x24b)](pluginData['name'],'ActSeq_Movement_Jump',_0xe5a63e=>{const _0x31c4c2=_0x251720;if(!SceneManager[_0x31c4c2(0x847)]())return;VisuMZ[_0x31c4c2(0xa0c)](_0xe5a63e,_0xe5a63e);const _0xad5c2d=$gameTemp['getLastPluginCommandInterpreter'](),_0x46e0c5=VisuMZ[_0x31c4c2(0x41c)](_0xe5a63e[_0x31c4c2(0x179)]),_0x3ddefa=_0xe5a63e[_0x31c4c2(0xa34)],_0x1e05fb=_0xe5a63e[_0x31c4c2(0x19f)],_0x554421=_0xe5a63e['WaitForJump'];if(!_0xad5c2d)return;for(const _0x4cf4f2 of _0x46e0c5){if(_0x31c4c2(0x90e)===_0x31c4c2(0x90e)){if(!_0x4cf4f2)continue;_0x4cf4f2['jumpBattler'](_0x3ddefa,_0x1e05fb);}else return this[_0x31c4c2(0xdd)](_0x5ea85e(_0x5e9af6));}if(_0x554421)_0xad5c2d[_0x31c4c2(0x1a1)](_0x31c4c2(0xbb));}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],'ActSeq_Movement_MoveBy',_0x50569a=>{const _0x103710=_0x251720;if(!SceneManager[_0x103710(0x847)]())return;if(!$gameSystem[_0x103710(0x22c)]())return;VisuMZ[_0x103710(0xa0c)](_0x50569a,_0x50569a);const _0x51450d=$gameTemp[_0x103710(0x27e)](),_0x95e022=VisuMZ[_0x103710(0x41c)](_0x50569a[_0x103710(0x179)]),_0x236acb=_0x50569a[_0x103710(0x960)],_0x55ea3d=_0x50569a[_0x103710(0x701)],_0x3e1528=_0x50569a[_0x103710(0x17f)],_0x16f0cd=_0x50569a[_0x103710(0x19f)],_0x38b05e=_0x50569a[_0x103710(0x78d)],_0xd4ed6a=_0x50569a['EasingType'],_0x28abd9=_0x50569a['MotionType'],_0x5e76fe=_0x50569a[_0x103710(0x6e7)];if(!_0x51450d)return;for(const _0x42058f of _0x95e022){if(_0x103710(0x93e)===_0x103710(0x93e)){if(!_0x42058f)continue;let _0x4d10ed=_0x55ea3d,_0x41fe78=_0x3e1528;if(_0x236acb[_0x103710(0x591)](/horz/i))_0x4d10ed*=_0x42058f[_0x103710(0x4f2)]()?-0x1:0x1;if(_0x236acb[_0x103710(0x591)](/vert/i))_0x41fe78*=_0x42058f[_0x103710(0x4f2)]()?-0x1:0x1;_0x42058f[_0x103710(0x92)](_0x4d10ed,_0x41fe78,_0x16f0cd,_0x38b05e,_0xd4ed6a),_0x42058f['requestMotion'](_0x28abd9);}else return-0x1;}if(_0x5e76fe)_0x51450d[_0x103710(0x1a1)]('battleMove');}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],'ActSeq_Movement_MoveToPoint',_0x17592c=>{const _0x1add4c=_0x251720;if(!SceneManager[_0x1add4c(0x847)]())return;if(!$gameSystem['isSideView']())return;VisuMZ[_0x1add4c(0xa0c)](_0x17592c,_0x17592c);const _0x155a3d=$gameTemp['getLastPluginCommandInterpreter'](),_0x2808e1=VisuMZ['CreateActionSequenceTargets'](_0x17592c[_0x1add4c(0x179)]),_0x2c6ff6=_0x17592c[_0x1add4c(0xaa5)],_0x4c0935=_0x17592c[_0x1add4c(0x5d6)],_0x1cf57d=_0x17592c['OffsetX'],_0x457433=_0x17592c['OffsetY'],_0x382ac8=_0x17592c['Duration'],_0x58421b=_0x17592c[_0x1add4c(0x78d)],_0x34c378=_0x17592c[_0x1add4c(0xc3)],_0x4abdde=_0x17592c[_0x1add4c(0x386)],_0x32b6ac=_0x17592c[_0x1add4c(0x6e7)];if(!_0x155a3d)return;for(const _0x5a9174 of _0x2808e1){if(_0x1add4c(0x32c)!=='BNZIg'){if(!_0x5a9174)continue;let _0x59e0d7=_0x5a9174[_0x1add4c(0x60a)]()[_0x1add4c(0x176)],_0xec5f56=_0x5a9174[_0x1add4c(0x60a)]()[_0x1add4c(0x6cc)];if(_0x2c6ff6[_0x1add4c(0x591)](/home/i))_0x59e0d7=_0x5a9174['battler']()['_homeX'],_0xec5f56=_0x5a9174[_0x1add4c(0x60a)]()['_homeY'];else{if(_0x2c6ff6[_0x1add4c(0x591)](/center/i)){if(_0x1add4c(0x291)==='RPAHW')_0x59e0d7=Graphics[_0x1add4c(0x13f)]/0x2,_0xec5f56=Graphics['boxHeight']/0x2;else{if(!_0x1d8e7f[_0x1add4c(0x847)]())return;_0x1ca979[_0x1add4c(0xa0c)](_0x463892,_0x3bb7f5);const _0x34dfcd=_0x548846[_0x1add4c(0x27e)](),_0x1a040d=_0x592d79[_0x1add4c(0x29b)],_0x359ebe=_0x4e4522[_0x1add4c(0x2bc)];if(!_0x34dfcd)return;if(!_0x1a040d)return;_0x1a040d&&_0x1a040d[_0x1add4c(0x864)]()&&_0x359ebe[_0x1add4c(0x62a)]()[_0x1add4c(0x30b)]()!==_0x1add4c(0x720)&&_0x34dfcd[_0x1add4c(0x65a)]([_0x359ebe]);}}else _0x2c6ff6[_0x1add4c(0x591)](/point (\d+), (\d+)/i)&&(_0x59e0d7=Number(RegExp['$1']),_0xec5f56=Number(RegExp['$2']));}if(_0x4c0935[_0x1add4c(0x591)](/none/i))_0x59e0d7+=_0x1cf57d,_0xec5f56+=_0x457433;else{if(_0x4c0935[_0x1add4c(0x591)](/horz/i)&&_0x4c0935[_0x1add4c(0x591)](/vert/i))_0x59e0d7+=_0x5a9174[_0x1add4c(0x4f2)]()?-_0x1cf57d:_0x1cf57d,_0xec5f56+=_0x5a9174[_0x1add4c(0x4f2)]()?-_0x457433:_0x457433;else{if(_0x4c0935['match'](/horz/i))_0x59e0d7+=_0x5a9174['isActor']()?-_0x1cf57d:_0x1cf57d,_0xec5f56+=_0x457433;else _0x4c0935['match'](/vert/i)&&(_0x59e0d7+=_0x1cf57d,_0xec5f56+=_0x5a9174[_0x1add4c(0x4f2)]()?-_0x457433:_0x457433);}}_0x5a9174[_0x1add4c(0x436)](_0x59e0d7,_0xec5f56,_0x382ac8,_0x58421b,_0x34c378,-0x1),_0x5a9174['requestMotion'](_0x4abdde);}else{let _0x340b40=_0xdd9b80(_0x5a80a3['$1'])[_0x1add4c(0x105)](/,/g,'')[_0x1add4c(0x62a)]()[_0x1add4c(0x30b)]();_0x162fed[_0x1add4c(0x731)]['_commonEventKey'][_0x340b40]=_0x2d5cb7['id'];}}if(_0x32b6ac)_0x155a3d[_0x1add4c(0x1a1)]('battleMove');}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x616),_0x1cabe9=>{const _0x47a4fe=_0x251720;if(!SceneManager[_0x47a4fe(0x847)]())return;if(!$gameSystem[_0x47a4fe(0x22c)]())return;VisuMZ['ConvertParams'](_0x1cabe9,_0x1cabe9);const _0x3fa106=$gameTemp['getLastPluginCommandInterpreter'](),_0x21cf3e=VisuMZ[_0x47a4fe(0x41c)](_0x1cabe9[_0x47a4fe(0x618)]),_0x1ce3e2=VisuMZ[_0x47a4fe(0x41c)](_0x1cabe9[_0x47a4fe(0xda)]),_0x1b78a3=_0x1cabe9[_0x47a4fe(0x124)];let _0x1d4299=_0x1cabe9['MeleeDistance'];const _0x3cf7fd=_0x1cabe9[_0x47a4fe(0x5d6)],_0x17f72b=_0x1cabe9[_0x47a4fe(0x38a)],_0x93bbc6=_0x1cabe9[_0x47a4fe(0x3bb)],_0x5382f9=_0x1cabe9[_0x47a4fe(0x19f)],_0x3e6c0f=_0x1cabe9[_0x47a4fe(0x78d)],_0x4475c5=_0x1cabe9[_0x47a4fe(0xc3)],_0x4eef34=_0x1cabe9[_0x47a4fe(0x386)],_0x4b2420=_0x1cabe9['WaitForMovement'],_0x375f9b=Math[_0x47a4fe(0x1c4)](..._0x1ce3e2[_0x47a4fe(0x259)](_0x3fbd88=>_0x3fbd88[_0x47a4fe(0x60a)]()[_0x47a4fe(0x176)]-_0x3fbd88[_0x47a4fe(0x60a)]()['mainSpriteWidth']()/0x2)),_0x119550=Math[_0x47a4fe(0x79a)](..._0x1ce3e2['map'](_0x28e7f8=>_0x28e7f8[_0x47a4fe(0x60a)]()[_0x47a4fe(0x176)]+_0x28e7f8[_0x47a4fe(0x60a)]()['mainSpriteWidth']()/0x2)),_0x37f22c=Math[_0x47a4fe(0x1c4)](..._0x1ce3e2[_0x47a4fe(0x259)](_0x25c63f=>_0x25c63f[_0x47a4fe(0x60a)]()[_0x47a4fe(0x6cc)]-_0x25c63f[_0x47a4fe(0x60a)]()[_0x47a4fe(0x1d6)]())),_0xd6f75b=Math[_0x47a4fe(0x79a)](..._0x1ce3e2[_0x47a4fe(0x259)](_0x50ac0d=>_0x50ac0d[_0x47a4fe(0x60a)]()['_baseY'])),_0x3c92f3=_0x1ce3e2[_0x47a4fe(0x778)](_0x388827=>_0x388827['isActor']())[_0x47a4fe(0x988)],_0x165bd2=_0x1ce3e2[_0x47a4fe(0x778)](_0x155841=>_0x155841[_0x47a4fe(0x722)]())[_0x47a4fe(0x988)];let _0x63e51=0x0,_0x52911e=0x0;if(_0x1b78a3[_0x47a4fe(0x591)](/front/i))_0x63e51=_0x3c92f3>=_0x165bd2?_0x375f9b:_0x119550;else{if(_0x1b78a3[_0x47a4fe(0x591)](/middle/i))_0x63e51=(_0x375f9b+_0x119550)/0x2,_0x1d4299=-0x1;else _0x1b78a3[_0x47a4fe(0x591)](/back/i)&&(_0x63e51=_0x3c92f3>=_0x165bd2?_0x119550:_0x375f9b);}if(_0x1b78a3[_0x47a4fe(0x591)](/head/i))'LQaEl'===_0x47a4fe(0x599)?this[_0x47a4fe(0x926)]=null:_0x52911e=_0x37f22c;else{if(_0x1b78a3['match'](/center/i))_0x47a4fe(0x294)===_0x47a4fe(0x72c)?(_0x5046c5+=_0x476f96,_0x4de494+=_0x1c7671):_0x52911e=(_0x37f22c+_0xd6f75b)/0x2;else _0x1b78a3['match'](/base/i)&&(_0x52911e=_0xd6f75b);}if(!_0x3fa106)return;for(const _0x1fccc9 of _0x21cf3e){if(!_0x1fccc9)continue;let _0x54f47c=_0x63e51,_0x1c5799=_0x52911e;if(_0x3cf7fd['match'](/none/i)){if('bVMnL'!=='bVMnL'){_0x243bc2=_0x45b265||'',_0x3e8f8e=_0x2d60d0||'';_0x27f01b===''&&_0x46a722===''&&(_0xe2f42d=this['_back1Sprite'][_0x47a4fe(0x126)](),_0x2ca963=this[_0x47a4fe(0x747)]['battleback2Name']());const _0xbaa68c=_0x5f33d6[_0x47a4fe(0x2f2)](_0x56e9ef),_0xa24030=_0x2a94ac[_0x47a4fe(0x2f7)](_0x1aad3f);_0xbaa68c[_0x47a4fe(0x26d)](this[_0x47a4fe(0x75)][_0x47a4fe(0x270)](this,this[_0x47a4fe(0x205)],this['_back2Sprite'],_0xbaa68c,_0xa24030));}else _0x54f47c+=_0x17f72b,_0x1c5799+=_0x93bbc6;}else{if(_0x3cf7fd[_0x47a4fe(0x591)](/horz/i)&&_0x3cf7fd[_0x47a4fe(0x591)](/vert/i))_0x47a4fe(0x160)==='TZkhY'?(_0x27b024+=_0x3cbea5[_0x47a4fe(0x98)][_0x47a4fe(0x38a)]||0x0,_0x407996+=_0x49d338[_0x47a4fe(0x98)][_0x47a4fe(0x3bb)]||0x0):(_0x54f47c+=_0x1fccc9['isActor']()?-_0x17f72b:_0x17f72b,_0x1c5799+=_0x1fccc9[_0x47a4fe(0x4f2)]()?-_0x93bbc6:_0x93bbc6);else{if(_0x3cf7fd[_0x47a4fe(0x591)](/horz/i))_0x54f47c+=_0x1fccc9[_0x47a4fe(0x4f2)]()?-_0x17f72b:_0x17f72b,_0x1c5799+=_0x93bbc6;else{if(_0x3cf7fd[_0x47a4fe(0x591)](/vert/i)){if(_0x47a4fe(0x729)!==_0x47a4fe(0x5e9))_0x54f47c+=_0x17f72b,_0x1c5799+=_0x1fccc9[_0x47a4fe(0x4f2)]()?-_0x93bbc6:_0x93bbc6;else{if(!_0x2a8de1['isSceneBattle']())return;if(!_0x1a407b[_0x47a4fe(0x41e)])return;if(!_0x503a6c['isPTB']())return;_0x420a69[_0x47a4fe(0xa0c)](_0x114f94,_0x4d1c80);const _0x5a0e81=_0x2202a0[_0x47a4fe(0x29b)][_0x47a4fe(0x366)](),_0x111fb8=_0x392294[_0x47a4fe(0x1a8)],_0x2af224=_0x254d11[_0x47a4fe(0xaa1)]||_0x47a4fe(0x6e9),_0x1aab3d=_0x21aeb8[_0x47a4fe(0x13e)]||_0x47a4fe(0x6e9),_0x724f64=_0x510808[_0x47a4fe(0x8df)]||0x0,_0x6c4041=_0x105429[_0x47a4fe(0x87e)]||0x0;(_0x5a0e81[_0x47a4fe(0x1f4)]()||_0x111fb8)&&(_0x111fb8&&(_0x5a0e81[_0x47a4fe(0x4fc)]=_0x5a0e81[_0x47a4fe(0x4fc)]||{},_0x5a0e81[_0x47a4fe(0x4fc)][_0x47a4fe(0x6d5)]=0x0),_0x5a0e81['alterActionCostPTB'](_0x2af224,_0x1aab3d,_0x724f64,_0x6c4041));}}}}}_0x1fccc9[_0x47a4fe(0x436)](_0x54f47c,_0x1c5799,_0x5382f9,_0x3e6c0f,_0x4475c5,_0x1d4299),_0x1fccc9[_0x47a4fe(0x995)](_0x4eef34);}if(_0x4b2420)_0x3fa106['setWaitMode'](_0x47a4fe(0x3cc));}),PluginManager['registerCommand'](pluginData[_0x251720(0x1f8)],_0x251720(0x17b),_0x571db8=>{const _0x4815ee=_0x251720;if(!SceneManager[_0x4815ee(0x847)]())return;VisuMZ[_0x4815ee(0xa0c)](_0x571db8,_0x571db8);const _0x452a45=$gameTemp['getLastPluginCommandInterpreter'](),_0x252253=VisuMZ[_0x4815ee(0x41c)](_0x571db8['Targets']),_0x67ce2e=_0x571db8[_0x4815ee(0x388)],_0x4c5567=_0x571db8[_0x4815ee(0x19f)],_0x357511=_0x571db8['EasingType'],_0x6b1b41=_0x571db8[_0x4815ee(0x18f)];if(!_0x452a45)return;for(const _0x88a4b3 of _0x252253){if(!_0x88a4b3)continue;_0x88a4b3[_0x4815ee(0x1b2)](_0x67ce2e,_0x4c5567,_0x357511);}if(_0x6b1b41)_0x452a45[_0x4815ee(0x1a1)](_0x4815ee(0x553));}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x9d6),_0x3f808e=>{const _0x7ab630=_0x251720;if(!SceneManager[_0x7ab630(0x847)]())return;VisuMZ[_0x7ab630(0xa0c)](_0x3f808e,_0x3f808e);const _0x1d987a=$gameTemp[_0x7ab630(0x27e)](),_0x1159f0=VisuMZ[_0x7ab630(0x41c)](_0x3f808e[_0x7ab630(0x179)]),_0x56351d=_0x3f808e[_0x7ab630(0x494)],_0x27c385=_0x3f808e[_0x7ab630(0x37d)],_0x2ec7d4=_0x3f808e['Duration'],_0x2a6053=_0x3f808e[_0x7ab630(0xc3)],_0x7fbab1=_0x3f808e['WaitForScale'];if(!_0x1d987a)return;for(const _0x178e84 of _0x1159f0){if(_0x7ab630(0x450)!==_0x7ab630(0x450))_0x380e3c['requestMotion'](_0x36c904);else{if(!_0x178e84)continue;_0x178e84[_0x7ab630(0x54f)](_0x56351d,_0x27c385,_0x2ec7d4,_0x2a6053);}}if(_0x7fbab1)_0x1d987a[_0x7ab630(0x1a1)](_0x7ab630(0x8bd));}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],'ActSeq_Movement_Skew',_0x3df9ea=>{const _0xa36b99=_0x251720;if(!SceneManager[_0xa36b99(0x847)]())return;VisuMZ['ConvertParams'](_0x3df9ea,_0x3df9ea);const _0x10d080=$gameTemp[_0xa36b99(0x27e)](),_0x34c548=VisuMZ[_0xa36b99(0x41c)](_0x3df9ea['Targets']),_0x23db26=_0x3df9ea[_0xa36b99(0x6b7)],_0x4c2aa6=_0x3df9ea[_0xa36b99(0x382)],_0x16e2fc=_0x3df9ea[_0xa36b99(0x19f)],_0x1b2281=_0x3df9ea[_0xa36b99(0xc3)],_0x46be77=_0x3df9ea[_0xa36b99(0x9b2)];if(!_0x10d080)return;for(const _0x5ce084 of _0x34c548){if(_0xa36b99(0x3ff)===_0xa36b99(0x3ff)){if(!_0x5ce084)continue;_0x5ce084[_0xa36b99(0x978)](_0x23db26,_0x4c2aa6,_0x16e2fc,_0x1b2281);}else _0x49b92b[_0xa36b99(0x377)]=_0x253d3a[_0xa36b99(0x79a)](0x1,_0x187a83(_0x1419ef['$1']));}if(_0x46be77)_0x10d080[_0xa36b99(0x1a1)](_0xa36b99(0x758));}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x605),_0x5c34b4=>{const _0x3d76d8=_0x251720;if(!SceneManager[_0x3d76d8(0x847)]())return;VisuMZ[_0x3d76d8(0xa0c)](_0x5c34b4,_0x5c34b4);const _0x41c18c=$gameTemp[_0x3d76d8(0x27e)](),_0x189841=VisuMZ[_0x3d76d8(0x41c)](_0x5c34b4['Targets']),_0x11ca14=_0x5c34b4['Angle'],_0x28fc71=_0x5c34b4['Duration'],_0x2dcaaf=_0x5c34b4[_0x3d76d8(0xc3)],_0x3e1798=_0x5c34b4['RevertAngle'],_0x339982=_0x5c34b4[_0x3d76d8(0x400)];if(!_0x41c18c)return;for(const _0x50ec7c of _0x189841){if(!_0x50ec7c)continue;_0x50ec7c[_0x3d76d8(0x546)](_0x11ca14,_0x28fc71,_0x2dcaaf,_0x3e1798);}if(_0x339982)_0x41c18c[_0x3d76d8(0x1a1)]('battleSpin');}),PluginManager['registerCommand'](pluginData['name'],_0x251720(0x9bb),_0x7455a6=>{const _0x2ead32=_0x251720;if(!SceneManager['isSceneBattle']())return;const _0x5e8427=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x5e8427)return;_0x5e8427[_0x2ead32(0x1a1)](_0x2ead32(0x202));}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x515),_0x2a9bc4=>{const _0x39c08b=_0x251720;if(!SceneManager[_0x39c08b(0x847)]())return;const _0x1c5434=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x1c5434)return;_0x1c5434[_0x39c08b(0x1a1)]('battleJump');}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],'ActSeq_Movement_WaitForMovement',_0x2200f0=>{const _0x221546=_0x251720;if(!SceneManager[_0x221546(0x847)]())return;const _0x7331a9=$gameTemp[_0x221546(0x27e)]();if(!_0x7331a9)return;_0x7331a9[_0x221546(0x1a1)](_0x221546(0x3cc));}),PluginManager[_0x251720(0x24b)](pluginData['name'],'ActSeq_Movement_WaitForOpacity',_0x4c7944=>{const _0x4f3a6c=_0x251720;if(!SceneManager['isSceneBattle']())return;const _0x525ac6=$gameTemp[_0x4f3a6c(0x27e)]();if(!_0x525ac6)return;_0x525ac6[_0x4f3a6c(0x1a1)](_0x4f3a6c(0x553));}),PluginManager['registerCommand'](pluginData['name'],_0x251720(0xaad),_0x175807=>{const _0x132d66=_0x251720;if(!SceneManager[_0x132d66(0x847)]())return;const _0x2b1f94=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x2b1f94)return;_0x2b1f94[_0x132d66(0x1a1)](_0x132d66(0x8bd));}),PluginManager['registerCommand'](pluginData[_0x251720(0x1f8)],_0x251720(0xa52),_0x590ddf=>{const _0x261dd2=_0x251720;if(!SceneManager['isSceneBattle']())return;const _0x204cd3=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x204cd3)return;_0x204cd3[_0x261dd2(0x1a1)](_0x261dd2(0x758));}),PluginManager[_0x251720(0x24b)](pluginData['name'],_0x251720(0x52c),_0x11ea71=>{const _0x4b5f90=_0x251720;if(!SceneManager[_0x4b5f90(0x847)]())return;const _0x3ac43a=$gameTemp[_0x4b5f90(0x27e)]();if(!_0x3ac43a)return;_0x3ac43a[_0x4b5f90(0x1a1)](_0x4b5f90(0x265));}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x57d),_0x11844e=>{const _0x2bca5a=_0x251720;if(!SceneManager[_0x2bca5a(0x847)]())return;if(!Imported[_0x2bca5a(0x46a)])return;VisuMZ[_0x2bca5a(0xa0c)](_0x11844e,_0x11844e);const _0x14b9d5=$gameTemp[_0x2bca5a(0x27e)](),_0x35b067=_0x11844e[_0x2bca5a(0x646)];if(!_0x14b9d5)return;const _0x38b7fc=BattleManager['_spriteset'];if(!_0x38b7fc)return;_0x38b7fc[_0x2bca5a(0x767)](_0x11844e);if(_0x35b067)_0x14b9d5[_0x2bca5a(0x1a1)](_0x2bca5a(0x980));}),PluginManager[_0x251720(0x24b)](pluginData['name'],_0x251720(0x577),_0x549c19=>{const _0x44fddc=_0x251720;if(!SceneManager[_0x44fddc(0x847)]())return;if(!Imported[_0x44fddc(0x46a)])return;VisuMZ[_0x44fddc(0xa0c)](_0x549c19,_0x549c19);const _0x31ab9f=$gameTemp[_0x44fddc(0x27e)](),_0x21ebdb=_0x549c19['WaitForProjectile'];if(!_0x31ab9f)return;const _0x2a715a=BattleManager[_0x44fddc(0x742)];if(!_0x2a715a)return;_0x2a715a[_0x44fddc(0x767)](_0x549c19);if(_0x21ebdb)_0x31ab9f[_0x44fddc(0x1a1)](_0x44fddc(0x980));}),PluginManager[_0x251720(0x24b)](pluginData['name'],'ActSeq_Projectile_Picture',_0x1820e0=>{const _0xa2cb1b=_0x251720;if(!SceneManager[_0xa2cb1b(0x847)]())return;if(!Imported[_0xa2cb1b(0x46a)])return;VisuMZ[_0xa2cb1b(0xa0c)](_0x1820e0,_0x1820e0);const _0x3f4be5=$gameTemp['getLastPluginCommandInterpreter'](),_0x12134d=_0x1820e0[_0xa2cb1b(0x646)];if(!_0x3f4be5)return;const _0x2640e4=BattleManager['_spriteset'];if(!_0x2640e4)return;_0x2640e4['createActionSequenceProjectile'](_0x1820e0);if(_0x12134d)_0x3f4be5[_0xa2cb1b(0x1a1)]('battleProjectiles');}),PluginManager['registerCommand'](pluginData[_0x251720(0x1f8)],'ActSeq_ChangeSkew',_0x1215c4=>{const _0x2602cd=_0x251720;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x2602cd(0x243)])return;VisuMZ[_0x2602cd(0xa0c)](_0x1215c4,_0x1215c4);const _0x20d62b=$gameTemp[_0x2602cd(0x27e)](),_0x1e335b=_0x1215c4[_0x2602cd(0x9b2)];if(!_0x20d62b)return;$gameScreen['setBattleSkew'](_0x1215c4['SkewX'],_0x1215c4[_0x2602cd(0x382)],_0x1215c4[_0x2602cd(0x19f)],_0x1215c4[_0x2602cd(0xc3)]);if(_0x1e335b)_0x20d62b[_0x2602cd(0x1a1)](_0x2602cd(0xeb));}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x1a6),_0x5ecf7f=>{const _0x372a92=_0x251720;if(!SceneManager[_0x372a92(0x847)]())return;if(!Imported['VisuMZ_3_ActSeqCamera'])return;VisuMZ[_0x372a92(0xa0c)](_0x5ecf7f,_0x5ecf7f);const _0x4d67db=$gameTemp[_0x372a92(0x27e)](),_0x4d4aa2=_0x5ecf7f[_0x372a92(0x9b2)];if(!_0x4d67db)return;$gameScreen[_0x372a92(0x4b2)](0x0,0x0,_0x5ecf7f[_0x372a92(0x19f)],_0x5ecf7f[_0x372a92(0xc3)]);if(_0x4d4aa2)_0x4d67db[_0x372a92(0x1a1)](_0x372a92(0xeb));}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x2e2),_0x210f61=>{const _0xf846fa=_0x251720;if(!SceneManager[_0xf846fa(0x847)]())return;if(!Imported[_0xf846fa(0x243)])return;const _0x1a03bb=$gameTemp[_0xf846fa(0x27e)]();if(!_0x1a03bb)return;_0x1a03bb[_0xf846fa(0x1a1)]('battleSkew');}),PluginManager[_0x251720(0x24b)](pluginData['name'],_0x251720(0x430),_0x1048a2=>{const _0x33cd6c=_0x251720;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x33cd6c(0xa0c)](_0x1048a2,_0x1048a2);const _0x4d7945=$gameTemp[_0x33cd6c(0x27e)](),_0x1a595e=_0x1048a2['Index'],_0x2f33f2=_0x1048a2[_0x33cd6c(0x2bc)];if(!_0x4d7945)return;BattleManager[_0x33cd6c(0x1d1)]=_0x1a595e,BattleManager['_target']=BattleManager['_allTargets']?BattleManager[_0x33cd6c(0x8cb)][BattleManager[_0x33cd6c(0x1d1)]]||null:null;if(BattleManager[_0x33cd6c(0x312)]&&_0x2f33f2[_0x33cd6c(0x62a)]()[_0x33cd6c(0x30b)]()!==_0x33cd6c(0x720)){if(_0x33cd6c(0x768)!==_0x33cd6c(0x14c))_0x4d7945[_0x33cd6c(0x65a)]([_0x2f33f2]);else{const _0x297ebd=_0x3fea02[_0x33cd6c(0x731)]['Settings'][_0x33cd6c(0x8ca)],_0x54b737=_0x297ebd[_0x33cd6c(0xac0)]||0xc0,_0x4986a9=this[_0x33cd6c(0x57b)](),_0xf6dbc7=this[_0x33cd6c(0x95a)]()?_0x2bfd1f[_0x33cd6c(0x13f)]-_0x54b737:0x0,_0x5716f5=_0x5a7411[_0x33cd6c(0x635)]-_0x4986a9;return new _0x4ad653(_0xf6dbc7,_0x5716f5,_0x54b737,_0x4986a9);}}}),PluginManager[_0x251720(0x24b)](pluginData['name'],'ActSeq_Target_NextTarget',_0x3d6b43=>{const _0x3d76a6=_0x251720;if(!SceneManager['isSceneBattle']())return;VisuMZ['ConvertParams'](_0x3d6b43,_0x3d6b43);const _0x2a4353=$gameTemp['getLastPluginCommandInterpreter'](),_0x3b920a=_0x3d6b43[_0x3d76a6(0x2bc)];if(!_0x2a4353)return;BattleManager[_0x3d76a6(0x1d1)]++,BattleManager[_0x3d76a6(0x312)]=BattleManager['_allTargets'][BattleManager[_0x3d76a6(0x1d1)]]||null,BattleManager[_0x3d76a6(0x312)]&&_0x3b920a[_0x3d76a6(0x62a)]()[_0x3d76a6(0x30b)]()!==_0x3d76a6(0x720)&&(_0x3d76a6(0x538)===_0x3d76a6(0x538)?_0x2a4353[_0x3d76a6(0x65a)]([_0x3b920a]):_0xaa4c28=_0x4f405a[_0x3d76a6(0x64d)]);}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],'ActSeq_Target_PrevTarget',_0x40adca=>{const _0x4988be=_0x251720;if(!SceneManager[_0x4988be(0x847)]())return;VisuMZ[_0x4988be(0xa0c)](_0x40adca,_0x40adca);const _0x3935e3=$gameTemp['getLastPluginCommandInterpreter'](),_0x36b4f0=_0x40adca[_0x4988be(0x2bc)];if(!_0x3935e3)return;BattleManager['_targetIndex']--,BattleManager['_target']=BattleManager[_0x4988be(0x8cb)][BattleManager[_0x4988be(0x1d1)]]||null,BattleManager[_0x4988be(0x312)]&&_0x36b4f0['toUpperCase']()[_0x4988be(0x30b)]()!==_0x4988be(0x720)&&_0x3935e3[_0x4988be(0x65a)]([_0x36b4f0]);}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x681),_0x3a7764=>{const _0x5db153=_0x251720;if(!SceneManager[_0x5db153(0x847)]())return;VisuMZ[_0x5db153(0xa0c)](_0x3a7764,_0x3a7764);const _0x2e5d73=$gameTemp[_0x5db153(0x27e)](),_0x503ece=_0x3a7764[_0x5db153(0x7d1)],_0x52ad36=_0x3a7764[_0x5db153(0x2bc)];if(!_0x2e5d73)return;const _0x4ad80b=BattleManager['_targetIndex'];for(;;){BattleManager[_0x5db153(0x1d1)]=Math[_0x5db153(0x9b7)](BattleManager[_0x5db153(0x8cb)]['length']);if(!_0x503ece)break;if(BattleManager[_0x5db153(0x1d1)]!==_0x4ad80b)break;if(BattleManager[_0x5db153(0x8cb)]['length']<=0x1){BattleManager['_targetIndex']=0x0;break;}}BattleManager[_0x5db153(0x312)]=BattleManager['_allTargets'][BattleManager[_0x5db153(0x1d1)]]||null;if(BattleManager[_0x5db153(0x312)]&&_0x52ad36['toUpperCase']()[_0x5db153(0x30b)]()!==_0x5db153(0x720)){if('jKvle'!=='jKvle'){const _0x3d9466=this[_0x5db153(0x397)]['_freezeMotionData'];this['_motion']=_0x23a1f1['MOTIONS'][_0x3d9466['motionType']],this[_0x5db153(0x258)]=_0x3d9466[_0x5db153(0x961)];const _0x2ee12a=this[_0x5db153(0x488)];_0x2ee12a[_0x5db153(0x230)](_0x3d9466[_0x5db153(0x9e8)],_0x3d9466[_0x5db153(0x961)]),this['adjustWeaponSpriteOffset']();}else _0x2e5d73[_0x5db153(0x65a)]([_0x52ad36]);}}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x871),_0x539199=>{const _0x11548d=_0x251720;if(!SceneManager[_0x11548d(0x847)]())return;VisuMZ[_0x11548d(0xa0c)](_0x539199,_0x539199);const _0x1ebb2c=VisuMZ[_0x11548d(0x41c)](_0x539199[_0x11548d(0x179)]);for(const _0x32de88 of _0x1ebb2c){if(_0x11548d(0x2d2)===_0x11548d(0x292))_0x10ea89[_0x11548d(0xa8d)](_0x6cbc90);else{if(!_0x32de88)continue;if(!_0x32de88[_0x11548d(0x4f2)]())continue;_0x32de88['clearActiveWeaponSlot']();}}}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x359),_0xbaa788=>{const _0x5d668a=_0x251720;if(!SceneManager[_0x5d668a(0x847)]())return;VisuMZ[_0x5d668a(0xa0c)](_0xbaa788,_0xbaa788);const _0x2ead19=$gameTemp[_0x5d668a(0x27e)]();let _0x33704d=![];const _0xd4f42d=_0xbaa788['JumpToLabel'],_0xc6e43e=VisuMZ[_0x5d668a(0x41c)](_0xbaa788[_0x5d668a(0x179)]);for(const _0x1a32ac of _0xc6e43e){if(!_0x1a32ac)continue;if(!_0x1a32ac['isActor']())continue;_0x1a32ac[_0x5d668a(0x904)]();if(_0x1a32ac['weapons']()[_0x5d668a(0x988)]>0x0){if(_0x5d668a(0x621)!=='IuzlG')_0x33704d=!![];else return this['isBattleCoreTargetScope']()&&!this[_0x5d668a(0xab3)]()?this[_0x5d668a(0x54b)]():_0xae9c87[_0x5d668a(0x731)][_0x5d668a(0xb9)][_0x5d668a(0xa57)](this);}else _0x1a32ac['clearActiveWeaponSlot']();}_0x33704d&&_0xd4f42d[_0x5d668a(0x62a)]()[_0x5d668a(0x30b)]()!=='UNTITLED'&&_0x2ead19[_0x5d668a(0x65a)]([_0xd4f42d]);}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],'ActSeq_Weapon_SetActiveWeapon',_0x48009f=>{const _0x5220d9=_0x251720;if(!SceneManager['isSceneBattle']())return;VisuMZ['ConvertParams'](_0x48009f,_0x48009f);let _0xe6401e=_0x48009f[_0x5220d9(0x2d0)];_0xe6401e--,_0xe6401e=Math[_0x5220d9(0x79a)](_0xe6401e,0x0);const _0x1b1f50=VisuMZ[_0x5220d9(0x41c)](_0x48009f[_0x5220d9(0x179)]);for(const _0x9c6394 of _0x1b1f50){if(_0x5220d9(0x6eb)!==_0x5220d9(0x6af)){if(!_0x9c6394)continue;if(!_0x9c6394['isActor']())continue;_0x9c6394[_0x5220d9(0x9d8)](_0xe6401e);}else{this[_0x5220d9(0x70)](),this[_0x5220d9(0x9ce)](),this[_0x5220d9(0x154)](),this[_0x5220d9(0x916)](),this['updateHpGaugePosition'](),_0x20ccb8[_0x5220d9(0x731)][_0x5220d9(0x33e)]['call'](this);if(this[_0x5220d9(0x8c)]===_0x1b70a2)this[_0x5220d9(0xa0a)]();}}}),PluginManager['registerCommand'](pluginData[_0x251720(0x1f8)],'ActSeq_Zoom_Scale',_0x4bb103=>{const _0x1edbda=_0x251720;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x1edbda(0x243)])return;VisuMZ['ConvertParams'](_0x4bb103,_0x4bb103);const _0x5e97e8=$gameTemp['getLastPluginCommandInterpreter'](),_0x3b3c7d=_0x4bb103['WaitForZoom'];if(!_0x5e97e8)return;$gameScreen[_0x1edbda(0x9f2)](_0x4bb103[_0x1edbda(0x120)],_0x4bb103[_0x1edbda(0x19f)],_0x4bb103[_0x1edbda(0xc3)]);if(_0x3b3c7d)_0x5e97e8[_0x1edbda(0x1a1)](_0x1edbda(0x684));}),PluginManager['registerCommand'](pluginData[_0x251720(0x1f8)],_0x251720(0xb0),_0x292e94=>{const _0x4058c8=_0x251720;if(!SceneManager[_0x4058c8(0x847)]())return;if(!Imported['VisuMZ_3_ActSeqCamera'])return;VisuMZ['ConvertParams'](_0x292e94,_0x292e94);const _0xa6a2d7=$gameTemp[_0x4058c8(0x27e)](),_0x2c5ec8=_0x292e94[_0x4058c8(0x92e)];if(!_0xa6a2d7)return;$gameScreen[_0x4058c8(0x9f2)](0x1,_0x292e94[_0x4058c8(0x19f)],_0x292e94['EasingType']);if(_0x2c5ec8)_0xa6a2d7['setWaitMode'](_0x4058c8(0x684));}),PluginManager[_0x251720(0x24b)](pluginData[_0x251720(0x1f8)],_0x251720(0x889),_0x5cdfda=>{const _0x58a9e4=_0x251720;if(!SceneManager[_0x58a9e4(0x847)]())return;if(!Imported[_0x58a9e4(0x243)])return;const _0x40a0f7=$gameTemp[_0x58a9e4(0x27e)]();if(!_0x40a0f7)return;_0x40a0f7[_0x58a9e4(0x1a1)](_0x58a9e4(0x684));}),VisuMZ[_0x251720(0x731)][_0x251720(0x2e8)]=Scene_Boot[_0x251720(0x97e)]['onDatabaseLoaded'],Scene_Boot[_0x251720(0x97e)][_0x251720(0x35e)]=function(){const _0x51fa7b=_0x251720;this[_0x51fa7b(0x40c)](),this['process_VisuMZ_BattleCore_PluginParams'](),this[_0x51fa7b(0x100)](),this['process_VisuMZ_BattleCore_CreateRegExp'](),VisuMZ[_0x51fa7b(0x731)][_0x51fa7b(0x2e8)]['call'](this),this[_0x51fa7b(0x759)](),this['process_VisuMZ_BattleCore_BaseTroops'](),this[_0x51fa7b(0x53d)](),this[_0x51fa7b(0xe8)]();},Scene_Boot[_0x251720(0x97e)]['process_VisuMZ_BattleCore_Notetags']=function(){const _0x346127=_0x251720;if(VisuMZ[_0x346127(0x76d)])return;this[_0x346127(0x514)](),this[_0x346127(0x36f)](),this[_0x346127(0x426)]();},Scene_Boot[_0x251720(0x97e)][_0x251720(0x40c)]=function(){const _0x5b37c2=_0x251720,_0x269fba=$dataSystem['weaponTypes'][_0x5b37c2(0x988)];for(let _0x26cfd7=0x0;_0x26cfd7<_0x269fba;_0x26cfd7++){if(_0x5b37c2(0x22d)==='wqqgQ')_0xf0e31a['bitmap']=new _0x2012cb(this[_0x5b37c2(0x139)],this[_0x5b37c2(0x442)]);else{const _0x1e67eb=$dataSystem[_0x5b37c2(0x65f)][_0x26cfd7];if(_0x1e67eb)continue;$dataSystem[_0x5b37c2(0x65f)][_0x26cfd7]=JsonEx[_0x5b37c2(0xa1d)]($dataSystem[_0x5b37c2(0x65f)][0x0]);}}},Scene_Boot[_0x251720(0x97e)][_0x251720(0x53e)]=function(){const _0x42bf47=_0x251720,_0x49a725=VisuMZ[_0x42bf47(0x731)][_0x42bf47(0x825)];_0x49a725[_0x42bf47(0x2e1)][_0x42bf47(0x62f)]===undefined&&(_0x49a725['Damage'][_0x42bf47(0x62f)]=_0x42bf47(0x936)),_0x49a725[_0x42bf47(0x98)][_0x42bf47(0x55c)]===undefined&&(_0x42bf47(0x83e)==='htqKg'?this[_0x42bf47(0xa12)][_0x42bf47(0x26f)](_0x4fa4c3):_0x49a725[_0x42bf47(0x98)][_0x42bf47(0x55c)]=![]),_0x49a725[_0x42bf47(0x3b1)][_0x42bf47(0x55c)]===undefined&&(_0x42bf47(0x9c6)!=='QyPHb'?_0x49a725[_0x42bf47(0x3b1)][_0x42bf47(0x55c)]=!![]:this[_0x42bf47(0x258)]=(this['_pattern']+0x1)%0x4),_0x49a725['Actor'][_0x42bf47(0x38f)]===undefined&&('KpnqV'!=='KpnqV'?_0x1a7609[_0x42bf47(0x977)]=![]:_0x49a725[_0x42bf47(0x98)]['PrioritySortActive']=![]),_0x49a725['Actor'][_0x42bf47(0x9da)]===undefined&&('MVdRz'!==_0x42bf47(0x7a1)?_0x589bd0+=_0x45ccb8[_0x42bf47(0x7a)](_0x18f5d2[_0x42bf47(0x427)]):_0x49a725[_0x42bf47(0x98)][_0x42bf47(0x9da)]=!![]);},VisuMZ[_0x251720(0x5e7)]={},Scene_Boot[_0x251720(0x97e)][_0x251720(0x100)]=function(){const _0x4c8c9f=_0x251720;for(const _0x3663e3 of VisuMZ[_0x4c8c9f(0x731)]['Settings'][_0x4c8c9f(0x2e1)][_0x4c8c9f(0xe3)]){if(!_0x3663e3)continue;const _0x5e943d=_0x3663e3[_0x4c8c9f(0x225)][_0x4c8c9f(0x62a)]()['trim']();VisuMZ[_0x4c8c9f(0x5e7)][_0x5e943d]=_0x3663e3;}},VisuMZ[_0x251720(0x731)][_0x251720(0x61f)]={},Scene_Boot[_0x251720(0x97e)][_0x251720(0x3e7)]=function(){const _0x4726c4=_0x251720,_0x1e9cf2=VisuMZ[_0x4726c4(0x731)][_0x4726c4(0x61f)],_0x160220='<%1>\x5cs*([\x5cs\x5cS]*)\x5cs*<\x5c/%1>',_0x2aa597=[[_0x4726c4(0x5cb),_0x4726c4(0xa92)],[_0x4726c4(0x755),_0x4726c4(0x849)]],_0x3240ad=[[_0x4726c4(0x6ab),'JS\x20%1APPLY\x20%2'],[_0x4726c4(0x10e),'JS\x20%1DAMAGE\x20%2']],_0x4d832b=[['',''],[_0x4726c4(0x529),_0x4726c4(0x749)],[_0x4726c4(0x21b),_0x4726c4(0x137)]];for(const _0x3a8ffd of _0x3240ad){if(_0x4726c4(0x7fb)==='pMQLY'){if(!this[_0x4726c4(0x56c)]&&this['subject']()[_0x4726c4(0x356)]())return![];if(this[_0x4726c4(0xab3)]())return!![];return typeof this['item']()['scope']===_0x4726c4(0x4ca);}else for(const _0x250a67 of _0x4d832b){for(const _0x3dc944 of _0x2aa597){const _0x3af18f=_0x3a8ffd[0x0][_0x4726c4(0x8d6)](_0x3dc944[0x0],_0x250a67[0x0]),_0x10dedc=_0x3a8ffd[0x1][_0x4726c4(0x8d6)](_0x3dc944[0x1],_0x250a67[0x1])[_0x4726c4(0x30b)](),_0x57b757=new RegExp(_0x160220[_0x4726c4(0x8d6)](_0x10dedc),'i');_0x1e9cf2[_0x3af18f]=_0x57b757;}}}const _0x256360=[[_0x4726c4(0x7b8),'JS\x20%1START\x20ACTION'],[_0x4726c4(0x79f),'JS\x20%1END\x20ACTION']];for(const _0x572574 of _0x256360){if(_0x4726c4(0x373)===_0x4726c4(0x373))for(const _0x642706 of _0x2aa597){const _0x889b0e=_0x572574[0x0][_0x4726c4(0x8d6)](_0x642706[0x0]),_0x59cddc=_0x572574[0x1][_0x4726c4(0x8d6)](_0x642706[0x1]),_0x43fc96=new RegExp(_0x160220['format'](_0x59cddc),'i');_0x1e9cf2[_0x889b0e]=_0x43fc96;}else this[_0x4726c4(0x1b0)]=![],this['_autoBattle']=_0x7cb32d['autoBattleAtStart'],this[_0x4726c4(0xa55)](_0x4726c4(0x279)),_0x240d82[_0x4726c4(0x731)][_0x4726c4(0x756)][_0x4726c4(0xa57)](this),this[_0x4726c4(0xa55)](_0x4726c4(0x7cc));}const _0x4b056a=[[_0x4726c4(0x492),_0x4726c4(0x358)],['%1EndBattleJS',_0x4726c4(0x8da)],[_0x4726c4(0x6f8),_0x4726c4(0xff)],[_0x4726c4(0x53b),_0x4726c4(0x339)],[_0x4726c4(0x8fc),_0x4726c4(0x14f)],['EscapeFailureJS',_0x4726c4(0x9a1)],[_0x4726c4(0x322),_0x4726c4(0x607)],['%1EndTurnJS',_0x4726c4(0xdc)],[_0x4726c4(0x860),_0x4726c4(0x922)]];for(const _0x1fc414 of _0x4b056a){for(const _0x4304df of _0x2aa597){const _0x2334c9=_0x1fc414[0x0][_0x4726c4(0x8d6)](_0x4304df[0x0]),_0x325765=_0x1fc414[0x1][_0x4726c4(0x8d6)](_0x4304df[0x1]),_0x4c9159=new RegExp(_0x160220['format'](_0x325765),'i');_0x1e9cf2[_0x2334c9]=_0x4c9159;}}},Scene_Boot[_0x251720(0x97e)][_0x251720(0x514)]=function(){const _0x3c9e0f=_0x251720,_0x185661=$dataSkills[_0x3c9e0f(0x86)]($dataItems);for(const _0xcf3c1e of _0x185661){if(!_0xcf3c1e)continue;VisuMZ[_0x3c9e0f(0x731)][_0x3c9e0f(0x7c6)](_0xcf3c1e);}},Scene_Boot['prototype']['process_VisuMZ_BattleCore_TraitObject_Notetags']=function(){const _0xe604f6=_0x251720,_0x1678ca=$dataActors[_0xe604f6(0x86)]($dataClasses,$dataWeapons,$dataArmors,$dataEnemies,$dataStates);for(const _0x17f582 of _0x1678ca){if(!_0x17f582)continue;VisuMZ['BattleCore'][_0xe604f6(0x4d5)](_0x17f582);}},Scene_Boot['prototype'][_0x251720(0xd1)]=function(){const _0xf28608=_0x251720,_0xed4e61=VisuMZ[_0xf28608(0x731)]['Settings'][_0xf28608(0xa38)][_0xf28608(0x37e)],_0x832de4=[];for(const _0x8c4f of _0xed4e61){const _0x2012c7=$dataTroops[_0x8c4f];if(_0x2012c7)_0x832de4[_0xf28608(0x141)](JsonEx['makeDeepCopy'](_0x2012c7));}for(const _0xe68f0c of $dataTroops){if(!_0xe68f0c)continue;for(const _0x1018b8 of _0x832de4){if(_0xf28608(0x1b6)!==_0xf28608(0x628)){if(_0x1018b8['id']===_0xe68f0c['id'])continue;_0xe68f0c[_0xf28608(0xa4f)]=_0xe68f0c[_0xf28608(0xa4f)][_0xf28608(0x86)](_0x1018b8[_0xf28608(0xa4f)]);}else _0x521c66[_0xf28608(0x3b1)][_0xf28608(0x55c)]=!![];}}},Scene_Boot['prototype'][_0x251720(0x53d)]=function(){const _0x1d1127=_0x251720,_0xdacc5a=VisuMZ['BattleCore'][_0x1d1127(0x825)]['Mechanics'];if(_0xdacc5a[_0x1d1127(0x94f)]>0x0&&$dataCommonEvents[_0xdacc5a[_0x1d1127(0x94f)]]){if('fRnDz'===_0x1d1127(0xab8)){const _0x39f290=$dataCommonEvents[_0xdacc5a['BattleStartEvent']],_0x1690f5=_0x39f290[_0x1d1127(0x855)][_0x1d1127(0x988)]-0x2,_0x3a2550=_0x39f290[_0x1d1127(0x855)][_0x1690f5];if(_0x3a2550&&_0x3a2550['code']!==0xe6){const _0xcf21bd={'code':0xe6,'indent':0x0,'parameters':[0x1]},_0x4af6eb=_0x39f290[_0x1d1127(0x855)]['pop']();_0x39f290[_0x1d1127(0x855)][_0x1d1127(0x943)](_0xcf21bd),_0x39f290[_0x1d1127(0x855)][_0x1d1127(0x943)](_0x4af6eb);}}else _0x47b75e['_tpbNeedsPartyCommand']=![],this[_0x1d1127(0x61e)]();}},Scene_Boot[_0x251720(0x97e)]['process_VisuMZ_BattleCore_CommonEventKeys']=function(){const _0x43b693=_0x251720;VisuMZ[_0x43b693(0x731)]['CreateCommonEventKeys'](),VisuMZ[_0x43b693(0x731)][_0x43b693(0x85b)]($dataSkills),VisuMZ[_0x43b693(0x731)]['BindCommonEventKeysForGroup']($dataItems);},VisuMZ['BattleCore'][_0x251720(0x576)]=function(){const _0x288c51=_0x251720;VisuMZ['BattleCore'][_0x288c51(0x1ba)]={};for(const _0x3b5bf5 of $dataCommonEvents){if(!_0x3b5bf5)continue;if(_0x3b5bf5[_0x288c51(0x1f8)][_0x288c51(0x591)](/\[(.*)\]/i)){if(_0x288c51(0xa99)==='lCcRk'){let _0x190bf1=String(RegExp['$1'])['replace'](/,/g,'')[_0x288c51(0x62a)]()[_0x288c51(0x30b)]();VisuMZ[_0x288c51(0x731)]['_commonEventKey'][_0x190bf1]=_0x3b5bf5['id'];}else this[_0x288c51(0x995)](_0x288c51(0x25c));}}},VisuMZ[_0x251720(0x731)]['BindCommonEventKeysForGroup']=function(_0x1e3aef){const _0x2f981e=_0x251720;for(const _0x505c0e of _0x1e3aef){if(!_0x505c0e)continue;VisuMZ[_0x2f981e(0x731)][_0x2f981e(0xa85)](_0x505c0e);}},VisuMZ[_0x251720(0x731)]['BindCommonEventKeysForObj']=function(_0x55f55f){const _0x3232e8=_0x251720;if(!_0x55f55f)return;if(!_0x55f55f[_0x3232e8(0x3c6)])return;VisuMZ[_0x3232e8(0x731)][_0x3232e8(0x1ba)]=VisuMZ[_0x3232e8(0x731)][_0x3232e8(0x1ba)]||{};const _0x3e0211=/<COMMON EVENT (?:KEY|KEYS):[ ](.*)>/gi,_0x3a1ea2=/<COMMON EVENT (?:KEY|KEYS)>\s*([\s\S]*)\s*<\/COMMON EVENT (?:KEY|KEYS)>/i;let _0x6f23a=[];const _0x1785f3=_0x55f55f[_0x3232e8(0x67f)]['match'](_0x3e0211);if(_0x1785f3){for(const _0x14cb6a of _0x1785f3){_0x14cb6a['match'](_0x3e0211);const _0x4c3962=String(RegExp['$1'])[_0x3232e8(0xa45)](',')[_0x3232e8(0x259)](_0x36d361=>String(_0x36d361)[_0x3232e8(0x62a)]()[_0x3232e8(0x30b)]());_0x6f23a=_0x6f23a[_0x3232e8(0x86)](_0x4c3962);}!_0x55f55f['note'][_0x3232e8(0x591)](/<CUSTOM ACTION SEQUENCE>/i)&&(_0x55f55f['note']+=_0x3232e8(0x57c));;}if(_0x55f55f[_0x3232e8(0x67f)][_0x3232e8(0x591)](_0x3a1ea2)){if(_0x3232e8(0x66b)!=='NJXMS')this[_0x3232e8(0xd0)](),this[_0x3232e8(0x711)]();else{const _0x464222=String(RegExp['$1'])[_0x3232e8(0xa45)](/[\r\n]+/)[_0x3232e8(0x259)](_0x53efeb=>String(_0x53efeb)[_0x3232e8(0x62a)]()[_0x3232e8(0x30b)]());_0x6f23a=_0x6f23a[_0x3232e8(0x86)](_0x464222);if(!_0x55f55f['note'][_0x3232e8(0x591)](/<CUSTOM ACTION SEQUENCE>/i)){if(_0x3232e8(0x6a2)===_0x3232e8(0x6a2))_0x55f55f[_0x3232e8(0x67f)]+=_0x3232e8(0x57c);else return this[_0x3232e8(0x690)]()[_0x3232e8(0x1f8)];};}}for(const _0x42f1be of _0x6f23a){if(_0x3232e8(0x58f)!==_0x3232e8(0x58f))this[_0x3232e8(0x663)]();else{if(VisuMZ[_0x3232e8(0x731)]['_commonEventKey'][_0x42f1be]){const _0x55ead7=VisuMZ[_0x3232e8(0x731)][_0x3232e8(0x1ba)][_0x42f1be],_0x509778={'code':0x2c,'dataId':_0x55ead7,'value1':0x1,'value2':0x0};_0x55f55f['effects'][_0x3232e8(0x141)](_0x509778);}}}},Scene_Boot['prototype'][_0x251720(0x426)]=function(){const _0x36b03b=_0x251720,_0x5520e2=$dataSkills[_0x36b03b(0x86)]($dataItems);for(const _0x1620c9 of _0x5520e2){if(!_0x1620c9)continue;VisuMZ[_0x36b03b(0x731)]['Parse_Notetags_Targets'](_0x1620c9);}},VisuMZ[_0x251720(0x731)]['ParseActorNotetags']=VisuMZ['ParseActorNotetags'],VisuMZ[_0x251720(0x4f5)]=function(_0x43eec9){const _0x3d348b=_0x251720;VisuMZ[_0x3d348b(0x731)][_0x3d348b(0x4f5)]&&VisuMZ[_0x3d348b(0x731)][_0x3d348b(0x4f5)][_0x3d348b(0xa57)](this,_0x43eec9),VisuMZ[_0x3d348b(0x731)][_0x3d348b(0x4d5)](_0x43eec9);},VisuMZ[_0x251720(0x731)]['ParseClassNotetags']=VisuMZ[_0x251720(0x59d)],VisuMZ[_0x251720(0x59d)]=function(_0xae7eeb){const _0x1eb325=_0x251720;VisuMZ[_0x1eb325(0x731)][_0x1eb325(0x59d)]&&VisuMZ[_0x1eb325(0x731)][_0x1eb325(0x59d)][_0x1eb325(0xa57)](this,_0xae7eeb),VisuMZ['BattleCore'][_0x1eb325(0x4d5)](_0xae7eeb);},VisuMZ['BattleCore'][_0x251720(0x966)]=VisuMZ[_0x251720(0x966)],VisuMZ[_0x251720(0x966)]=function(_0x49c504){const _0x35d1f4=_0x251720;VisuMZ['BattleCore']['ParseSkillNotetags']&&VisuMZ['BattleCore'][_0x35d1f4(0x966)][_0x35d1f4(0xa57)](this,_0x49c504),VisuMZ['BattleCore'][_0x35d1f4(0x7c6)](_0x49c504),VisuMZ[_0x35d1f4(0x731)][_0x35d1f4(0x15c)](_0x49c504);},VisuMZ[_0x251720(0x731)]['ParseItemNotetags']=VisuMZ[_0x251720(0x7c)],VisuMZ[_0x251720(0x7c)]=function(_0x24ee42){const _0x313031=_0x251720;VisuMZ[_0x313031(0x731)]['ParseItemNotetags']&&VisuMZ[_0x313031(0x731)][_0x313031(0x7c)][_0x313031(0xa57)](this,_0x24ee42),VisuMZ[_0x313031(0x731)][_0x313031(0x7c6)](_0x24ee42),VisuMZ[_0x313031(0x731)][_0x313031(0x15c)](_0x24ee42);},VisuMZ[_0x251720(0x731)][_0x251720(0x803)]=VisuMZ[_0x251720(0x803)],VisuMZ[_0x251720(0x803)]=function(_0x17934b){const _0x2963bc=_0x251720;if(VisuMZ[_0x2963bc(0x731)][_0x2963bc(0x803)]){if(_0x2963bc(0x264)!==_0x2963bc(0x264))return _0x35eb98[_0x2963bc(0x731)][_0x2963bc(0x825)][_0x2963bc(0x3b1)][_0x2963bc(0x632)]?this[_0x2963bc(0x397)]['isSelected']():_0x535c10[_0x2963bc(0x35b)][_0x2963bc(0x31c)]&&_0x5a573a[_0x2963bc(0x35b)][_0x2963bc(0x31c)][_0x2963bc(0xb4)]&&_0x392bdc[_0x2963bc(0x35b)][_0x2963bc(0x31c)][_0x2963bc(0x164)]['includes'](this['_battler']);else VisuMZ[_0x2963bc(0x731)][_0x2963bc(0x803)][_0x2963bc(0xa57)](this,_0x17934b);}VisuMZ[_0x2963bc(0x731)][_0x2963bc(0x4d5)](_0x17934b);},VisuMZ[_0x251720(0x731)][_0x251720(0x5e6)]=VisuMZ[_0x251720(0x5e6)],VisuMZ['ParseArmorNotetags']=function(_0x17adbc){const _0x10bae9=_0x251720;VisuMZ[_0x10bae9(0x731)][_0x10bae9(0x5e6)]&&VisuMZ[_0x10bae9(0x731)]['ParseArmorNotetags'][_0x10bae9(0xa57)](this,_0x17adbc),VisuMZ[_0x10bae9(0x731)]['Parse_Notetags_TraitObjects'](_0x17adbc);},VisuMZ[_0x251720(0x731)][_0x251720(0x845)]=VisuMZ[_0x251720(0x845)],VisuMZ['ParseEnemyNotetags']=function(_0x24553e){const _0x3ba871=_0x251720;VisuMZ['BattleCore']['ParseEnemyNotetags']&&VisuMZ[_0x3ba871(0x731)]['ParseEnemyNotetags'][_0x3ba871(0xa57)](this,_0x24553e),VisuMZ['BattleCore'][_0x3ba871(0x4d5)](_0x24553e);},VisuMZ[_0x251720(0x731)]['ParseStateNotetags']=VisuMZ[_0x251720(0x937)],VisuMZ['ParseStateNotetags']=function(_0x4f43bc){const _0x37d7c2=_0x251720;VisuMZ[_0x37d7c2(0x731)]['ParseStateNotetags']&&VisuMZ[_0x37d7c2(0x731)][_0x37d7c2(0x937)]['call'](this,_0x4f43bc),VisuMZ[_0x37d7c2(0x731)]['Parse_Notetags_TraitObjects'](_0x4f43bc);},VisuMZ['BattleCore']['Parse_Notetags_Action']=function(_0x34230e){const _0x3010bb=_0x251720,_0x4672c0=[_0x3010bb(0x8c6),_0x3010bb(0x7a4),_0x3010bb(0x273),_0x3010bb(0x8f2),_0x3010bb(0x283),'PostStartActionJS',_0x3010bb(0x446),_0x3010bb(0x5f7)];for(const _0x4cbcea of _0x4672c0){VisuMZ[_0x3010bb(0x731)]['createJS'](_0x34230e,_0x4cbcea);}const _0x52eab4=_0x34230e[_0x3010bb(0x67f)];_0x52eab4[_0x3010bb(0x591)](/<ALWAYS CRITICAL/i)&&(_0x34230e['damage'][_0x3010bb(0x8f5)]=!![]),_0x52eab4[_0x3010bb(0x591)](/<(?:REPEAT|REPEATS|REPEAT HITS):[ ](\d+)/i)&&(_0x3010bb(0x3b8)!==_0x3010bb(0x3d6)?_0x34230e[_0x3010bb(0x377)]=Math[_0x3010bb(0x79a)](0x1,Number(RegExp['$1'])):_0x4b3755[_0x2566f0]['call'](this,_0x3dac4b)),_0x52eab4[_0x3010bb(0x591)](/<TARGET:[ ](.*)>/i)&&(_0x34230e[_0x3010bb(0x6a1)]=String(RegExp['$1'])[_0x3010bb(0x62a)]()[_0x3010bb(0x30b)]());},VisuMZ[_0x251720(0x731)][_0x251720(0x4d5)]=function(_0x2df40c){const _0x512426=_0x251720,_0x341e30=[_0x512426(0x81f),_0x512426(0x19c),_0x512426(0x872),'PostDamageAsUserJS',_0x512426(0x485),_0x512426(0x4fe),_0x512426(0x4f6),'PostDamageAsTargetJS',_0x512426(0x283),_0x512426(0x4e5),'PreEndActionJS',_0x512426(0x5f7),_0x512426(0x279),'PostStartBattleJS',_0x512426(0x1fe),'PostEndBattleJS',_0x512426(0x6f8),_0x512426(0x53b),_0x512426(0x8fc),_0x512426(0x3cf),_0x512426(0xa05),_0x512426(0x548),_0x512426(0x173),_0x512426(0x8d4),'PreRegenerateJS','PostRegenerateJS'];for(const _0x57f3e1 of _0x341e30){if(_0x512426(0x2b9)===_0x512426(0x2b9))VisuMZ[_0x512426(0x731)][_0x512426(0x44d)](_0x2df40c,_0x57f3e1);else{const _0x2f27e1=this[_0x512426(0x342)]()[_0x512426(0x6a1)];return _0x2f27e1[_0x512426(0x591)](/(?:RAND|RANDOM)/i);}}},VisuMZ[_0x251720(0x731)][_0x251720(0x15c)]=function(_0x5ef899){const _0x587b19=_0x251720,_0x375621=_0x5ef899[_0x587b19(0x67f)];if(_0x375621['match'](/<JS TARGETS>\s*([\s\S]*)\s*<\/JS TARGETS>/i)){const _0xef09ea=String(RegExp['$1']),_0x30a9d1=VisuMZ[_0x587b19(0x731)][_0x587b19(0x338)](_0x5ef899,'Targets');VisuMZ[_0x587b19(0x731)][_0x587b19(0x52e)](_0xef09ea,_0x30a9d1);}if(_0x375621['match'](/<JS COMMAND (?:VISIBLE|SHOW|HIDE)>\s*([\s\S]*)\s*<\/JS COMMAND (?:VISIBLE|SHOW|HIDE)>/i)){const _0x10a297=String(RegExp['$1']),_0x266d40=VisuMZ['BattleCore'][_0x587b19(0x338)](_0x5ef899,_0x587b19(0x1ed));VisuMZ[_0x587b19(0x731)][_0x587b19(0x69f)](_0x10a297,_0x266d40);}},VisuMZ[_0x251720(0x731)]['JS']={},VisuMZ['BattleCore'][_0x251720(0x44d)]=function(_0x1cfa16,_0x2363d3){const _0x1d3b01=_0x251720,_0x220fc0=_0x1cfa16['note'];if(_0x220fc0['match'](VisuMZ[_0x1d3b01(0x731)]['RegExp'][_0x2363d3])){const _0x57fcf3=RegExp['$1'],_0x595f5e='\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Declare\x20Arguments\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20arguments[0];\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20target\x20=\x20arguments[1];\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20obj\x20=\x20arguments[2];\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20value\x20=\x20arguments[3]\x20||\x200;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20originalValue\x20=\x20value;\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Declare\x20Constants\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20action\x20=\x20(this.constructor\x20===\x20Game_Action)\x20?\x20this\x20:\x20user.currentAction();\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20a\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20b\x20=\x20target;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20attacker\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20defender\x20=\x20target;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20healer\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20receiver\x20=\x20target;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20actor\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20currentClass\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20skill\x20=\x20(this.constructor\x20===\x20Game_Action)\x20?\x20this.item()\x20:\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20item\x20=\x20(this.constructor\x20===\x20Game_Action)\x20?\x20this.item()\x20:\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20weapon\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20armor\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20enemy\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20state\x20=\x20obj;\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Create\x20Compatibility\x20Variables\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20origin\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20(Imported.VisuMZ_1_SkillsStatesCore\x20&&\x20$dataStates.includes(obj))\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20origin\x20=\x20target.getStateOrigin(obj.id);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Process\x20Code\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20NaN\x20Check\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20(isNaN(value)){\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20console.log(\x27NaN\x20value\x20created\x20by\x20%2\x27.format(\x27\x27,obj.name));\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20console.log(\x27Restoring\x20value\x20to\x20%2\x27.format(\x27\x27,originalValue));\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20value\x20=\x20originalValue;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Return\x20Value\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20return\x20value;\x0a\x20\x20\x20\x20\x20\x20\x20\x20'[_0x1d3b01(0x8d6)](_0x57fcf3),_0x16b3d3=VisuMZ['BattleCore'][_0x1d3b01(0x338)](_0x1cfa16,_0x2363d3);VisuMZ['BattleCore']['JS'][_0x16b3d3]=new Function(_0x595f5e);}},VisuMZ[_0x251720(0x731)]['createKeyJS']=function(_0x452b6f,_0x1611dc){const _0x5caf1b=_0x251720;let _0x3b10b1='';if($dataActors[_0x5caf1b(0x9b0)](_0x452b6f))_0x3b10b1=_0x5caf1b(0x899)[_0x5caf1b(0x8d6)](_0x452b6f['id'],_0x1611dc);if($dataClasses[_0x5caf1b(0x9b0)](_0x452b6f))_0x3b10b1=_0x5caf1b(0x7c5)['format'](_0x452b6f['id'],_0x1611dc);if($dataSkills[_0x5caf1b(0x9b0)](_0x452b6f))_0x3b10b1=_0x5caf1b(0x2dc)[_0x5caf1b(0x8d6)](_0x452b6f['id'],_0x1611dc);if($dataItems['includes'](_0x452b6f))_0x3b10b1=_0x5caf1b(0x17a)['format'](_0x452b6f['id'],_0x1611dc);if($dataWeapons[_0x5caf1b(0x9b0)](_0x452b6f))_0x3b10b1=_0x5caf1b(0x8c7)[_0x5caf1b(0x8d6)](_0x452b6f['id'],_0x1611dc);if($dataArmors[_0x5caf1b(0x9b0)](_0x452b6f))_0x3b10b1=_0x5caf1b(0x873)['format'](_0x452b6f['id'],_0x1611dc);if($dataEnemies[_0x5caf1b(0x9b0)](_0x452b6f))_0x3b10b1='Enemy-%1-%2'[_0x5caf1b(0x8d6)](_0x452b6f['id'],_0x1611dc);if($dataStates[_0x5caf1b(0x9b0)](_0x452b6f))_0x3b10b1=_0x5caf1b(0x5d5)[_0x5caf1b(0x8d6)](_0x452b6f['id'],_0x1611dc);return _0x3b10b1;},VisuMZ[_0x251720(0x731)][_0x251720(0x52e)]=function(_0x17eb0f,_0x23b659){const _0x1bd026=_0x251720,_0x27b6f1=_0x1bd026(0x3fb)['format'](_0x17eb0f);VisuMZ[_0x1bd026(0x731)]['JS'][_0x23b659]=new Function(_0x27b6f1);},VisuMZ[_0x251720(0x731)][_0x251720(0x69f)]=function(_0x18195f,_0x3ae848){const _0x300b40=_0x251720,_0x1df93a=_0x300b40(0x7ed)['format'](_0x18195f);VisuMZ['BattleCore']['JS'][_0x3ae848]=new Function(_0x1df93a);},TextManager[_0x251720(0x581)]=VisuMZ[_0x251720(0x731)]['Settings'][_0x251720(0x85f)][_0x251720(0x562)],TextManager[_0x251720(0x348)]=VisuMZ[_0x251720(0x731)]['Settings'][_0x251720(0x513)][_0x251720(0x9ee)],TextManager[_0x251720(0x6d7)]=VisuMZ[_0x251720(0x731)][_0x251720(0x825)]['AutoBattle'][_0x251720(0x333)],TextManager[_0x251720(0x6b5)]=VisuMZ['BattleCore'][_0x251720(0x825)][_0x251720(0x2df)][_0x251720(0x225)],ColorManager[_0x251720(0x58b)]=function(_0x56f969){const _0x13436d=_0x251720;return _0x56f969=String(_0x56f969),_0x56f969[_0x13436d(0x591)](/#(.*)/i)?'qhpQw'==='WFWBP'?0x0:_0x13436d(0x971)['format'](String(RegExp['$1'])):this[_0x13436d(0xdd)](Number(_0x56f969));},DataManager[_0x251720(0x22b)]=function(_0x533b0b){const _0x59ee9d=_0x251720;if(_0x533b0b[_0x59ee9d(0x67f)]['match'](/<DAMAGE STYLE:[ ](.*)>/i)){if('yBIFM'!=='yBIFM'){if(_0xdf9e62[_0x59ee9d(0x591)](/(.*):[ ](\d+)/i)){const _0xd6a2ce=_0x55a71e(_0x16b4cc['$1'])[_0x59ee9d(0x30b)](),_0x3463c6=_0x4a6e5b(_0xb3094d['$2']);_0x22b3c6[_0xd6a2ce]=_0x3463c6,_0x34c109+=_0x3463c6;}else{if(_0x1f2d83[_0x59ee9d(0x591)](/(.*):[ ](\d+\.?\d+)/i)){const _0xf9e6c0=_0x16e761(_0x101fee['$1'])['trim'](),_0x49e98e=_0x275d52(_0x80a9e9['$2']);_0x4f8964[_0xf9e6c0]=_0x49e98e,_0x4fdf9b+=_0x49e98e;}else _0x2851e8!==''&&(_0x5674c6[_0x1a971b]=0x1,_0x386ad6++);}}else{const _0x101f43=String(RegExp['$1'])['toUpperCase']()[_0x59ee9d(0x30b)]();if(_0x101f43==='MANUAL')return _0x59ee9d(0x5d8);if(VisuMZ[_0x59ee9d(0x5e7)][_0x101f43])return _0x101f43;}}const _0x53d773=VisuMZ[_0x59ee9d(0x731)][_0x59ee9d(0x825)][_0x59ee9d(0x2e1)][_0x59ee9d(0x2e9)]['toUpperCase']()['trim']();if(VisuMZ['DamageStyles'][_0x53d773])return _0x53d773;return'MANUAL';},DataManager[_0x251720(0x559)]=function(_0x143cb7){const _0x3387b8=_0x251720;_0x143cb7=_0x143cb7['toUpperCase']()[_0x3387b8(0x30b)](),this[_0x3387b8(0xa77)]=this[_0x3387b8(0xa77)]||{};if(this[_0x3387b8(0xa77)][_0x143cb7])return this['_stypeIDs'][_0x143cb7];for(let _0x504292=0x1;_0x504292<0x64;_0x504292++){if(_0x3387b8(0x16a)!==_0x3387b8(0x51f)){if(!$dataSystem[_0x3387b8(0x7fd)][_0x504292])continue;let _0x2920d2=$dataSystem[_0x3387b8(0x7fd)][_0x504292][_0x3387b8(0x62a)]()[_0x3387b8(0x30b)]();_0x2920d2=_0x2920d2['replace'](/\x1I\[(\d+)\]/gi,''),_0x2920d2=_0x2920d2[_0x3387b8(0x105)](/\\I\[(\d+)\]/gi,''),this[_0x3387b8(0xa77)][_0x2920d2]=_0x504292;}else return _0x3387b8(0x85);}return this[_0x3387b8(0xa77)][_0x143cb7]||0x0;},DataManager[_0x251720(0x7da)]=function(_0x46d078){const _0x479736=_0x251720;_0x46d078=_0x46d078[_0x479736(0x62a)]()[_0x479736(0x30b)](),this[_0x479736(0x9b5)]=this[_0x479736(0x9b5)]||{};if(this[_0x479736(0x9b5)][_0x46d078])return this[_0x479736(0x9b5)][_0x46d078];for(const _0x12462b of $dataSkills){if(_0x479736(0x6d3)!==_0x479736(0x6d3))return _0x582a09['BattleCore']['Scene_Battle_skillWindowRect'][_0x479736(0xa57)](this);else{if(!_0x12462b)continue;this['_skillIDs'][_0x12462b[_0x479736(0x1f8)][_0x479736(0x62a)]()[_0x479736(0x30b)]()]=_0x12462b['id'];}}return this[_0x479736(0x9b5)][_0x46d078]||0x0;},DataManager['getEnemyIdWithName']=function(_0x258b16){const _0x1dfdc5=_0x251720;_0x258b16=_0x258b16[_0x1dfdc5(0x62a)]()[_0x1dfdc5(0x30b)](),this[_0x1dfdc5(0x68a)]=this[_0x1dfdc5(0x68a)]||{};if(this['_enemyIDs'][_0x258b16])return this[_0x1dfdc5(0x68a)][_0x258b16];for(const _0x4fd318 of $dataEnemies){if(!_0x4fd318)continue;this[_0x1dfdc5(0x68a)][_0x4fd318['name'][_0x1dfdc5(0x62a)]()[_0x1dfdc5(0x30b)]()]=_0x4fd318['id'];}return this[_0x1dfdc5(0x68a)][_0x258b16]||0x0;},DataManager[_0x251720(0x385)]=function(_0x2c9ab1){const _0x2881a1=_0x251720;_0x2c9ab1=_0x2c9ab1['toUpperCase']()[_0x2881a1(0x30b)](),this['_wtypeIDs']=this['_wtypeIDs']||{};if(this[_0x2881a1(0x38b)][_0x2c9ab1])return this['_wtypeIDs'][_0x2c9ab1];for(let _0x3bc069=0x1;_0x3bc069<0x64;_0x3bc069++){if(!$dataSystem[_0x2881a1(0xa23)][_0x3bc069])continue;let _0x142408=$dataSystem[_0x2881a1(0xa23)][_0x3bc069][_0x2881a1(0x62a)]()['trim']();_0x142408=_0x142408['replace'](/\x1I\[(\d+)\]/gi,''),_0x142408=_0x142408[_0x2881a1(0x105)](/\\I\[(\d+)\]/gi,''),this[_0x2881a1(0x38b)][_0x142408]=_0x3bc069;}return this[_0x2881a1(0x38b)][_0x2881a1(0x454)]=0x0,this['_wtypeIDs'][_0x2c9ab1]||0x0;},DataManager['battleDisplayText']=function(_0x3c2571){const _0x152ee5=_0x251720,_0x57473b=_0x152ee5(0x969);let _0x31c1a3=_0x3c2571['iconIndex'],_0x5d7ed3=_0x3c2571[_0x152ee5(0x1f8)];const _0x2dabe6=_0x3c2571[_0x152ee5(0x67f)];if(_0x2dabe6[_0x152ee5(0x591)](/<DISPLAY ICON: (\d+)>/i)){if('oYxSX'!=='tuVTw')_0x31c1a3=Number(RegExp['$1']);else{this[_0x152ee5(0x3b9)]=_0xe610b;const _0x5349e9=this[_0x152ee5(0x1f8)](),_0x24828e=this[_0x152ee5(0x8ba)](),_0x5c6aa8=_0x240d3f[_0x152ee5(0x97e)][_0x152ee5(0x1d8)]();this['setupFont'](),this[_0x152ee5(0x817)][_0x152ee5(0x90f)](),this[_0x152ee5(0x817)][_0x152ee5(0xa68)](_0x5349e9,0x0,0x0,_0x24828e,_0x5c6aa8,'center');}}return _0x2dabe6['match'](/<DISPLAY TEXT: (.*)>/i)&&(_0x5d7ed3=String(RegExp['$1'])),_0x57473b[_0x152ee5(0x8d6)](_0x31c1a3,_0x5d7ed3);},DataManager[_0x251720(0x815)]=function(_0x5b08b2){const _0x3dfcec=_0x251720;return _0x5b08b2[_0x3dfcec(0x67f)]['match'](/<COMMAND TEXT: (.*)>/i)?String(RegExp['$1']):_0x5b08b2[_0x3dfcec(0x1f8)];},DataManager['battleCommandIcon']=function(_0x31d26b){const _0x340945=_0x251720;return _0x31d26b[_0x340945(0x67f)][_0x340945(0x591)](/<COMMAND ICON: (\d+)>/i)?Number(RegExp['$1']):_0x31d26b[_0x340945(0xdf)];},DataManager[_0x251720(0x83b)]=function(_0x352f40){const _0x3f7137=_0x251720,_0x4ee888=$dataEnemies[_0x352f40];if(_0x4ee888){if(_0x4ee888[_0x3f7137(0x67f)][_0x3f7137(0x591)](/<SWAP ENEMIES>\s*([\s\S]*)\s*<\/SWAP ENEMIES>/i)){const _0x9def09=String(RegExp['$1'])[_0x3f7137(0xa45)](/[\r\n]+/)['remove'](''),_0x2e361e=this[_0x3f7137(0xa9f)](_0x9def09);_0x352f40=this[_0x3f7137(0x886)](_0x2e361e)||_0x352f40,_0x352f40=DataManager[_0x3f7137(0x83b)](_0x352f40);}}return _0x352f40;},DataManager[_0x251720(0xa9f)]=function(_0x673371){const _0x18451c=_0x251720;let _0xd89834=0x0;const _0x4b3fe1={};for(const _0x1620e6 of _0x673371){if(_0x1620e6[_0x18451c(0x591)](/(.*):[ ](\d+)/i)){if(_0x18451c(0x519)==='BXnFW')return!this[_0x18451c(0x950)]()&&!this[_0x18451c(0xaca)]();else{const _0x201335=String(RegExp['$1'])[_0x18451c(0x30b)](),_0x23b57e=Number(RegExp['$2']);_0x4b3fe1[_0x201335]=_0x23b57e,_0xd89834+=_0x23b57e;}}else{if(_0x1620e6[_0x18451c(0x591)](/(.*):[ ](\d+\.?\d+)/i)){if(_0x18451c(0x463)!=='NKIcf'){if(_0x4d2035[_0x18451c(0x7aa)](_0x20a37a))return!![];return![];}else{const _0x54b1f7=String(RegExp['$1'])['trim'](),_0xc140b=Number(RegExp['$2']);_0x4b3fe1[_0x54b1f7]=_0xc140b,_0xd89834+=_0xc140b;}}else{if(_0x1620e6!==''){if(_0x18451c(0x92d)!=='JCJuA'){const _0x59c1ac=_0x34bde3['floor'](_0x3ff39a['width']/0x3),_0x387d0b=this['isRightInputMode']()?(_0x4e55a0[_0x18451c(0x139)]+_0x2a270a[_0x18451c(0x13f)])/0x2-_0x59c1ac:(_0xb5bb39[_0x18451c(0x139)]-_0x4ca266[_0x18451c(0x13f)])/-0x2,_0x3340b3=this['helpWindowRectBorderStyle'](),_0x35e988=_0x3340b3['y']+_0x3340b3['height'],_0x15de42=this[_0x18451c(0x1f1)](),_0x2dcafc=_0x15de42['y']-_0x35e988;return new _0x9f98e2(_0x387d0b,_0x35e988,_0x59c1ac,_0x2dcafc);}else _0x4b3fe1[_0x1620e6]=0x1,_0xd89834++;}}}}if(_0xd89834<=0x0)return'';let _0x896cce=Math['random']()*_0xd89834;for(const _0x450d9a in _0x4b3fe1){if(_0x18451c(0x43f)!==_0x18451c(0x469)){_0x896cce-=_0x4b3fe1[_0x450d9a];if(_0x896cce<=0x0)return _0x450d9a;}else this[_0x18451c(0x1d0)](_0x5e83fd[_0x18451c(0x67f)]);}return'';},DataManager[_0x251720(0xd2)]=function(_0x562ce9){const _0x1b8c66=_0x251720;if(!_0x562ce9)return![];if(!VisuMZ[_0x1b8c66(0x731)]['Settings'][_0x1b8c66(0x1cc)][_0x1b8c66(0x983)])return![];if(_0x562ce9['note'][_0x1b8c66(0x591)](/<AUTO ACTION SEQUENCE>/i))return![];if(_0x562ce9['note'][_0x1b8c66(0x591)](/<COMMON (?:EVENT|EVENTS):[ ](.*)>/gi))return!![];for(const _0x335ee2 of _0x562ce9[_0x1b8c66(0x3c6)]){if(!_0x335ee2)continue;if(_0x335ee2['code']===Game_Action[_0x1b8c66(0x710)])return!![];}return![];},DataManager[_0x251720(0x8fe)]=function(_0x103bbd){const _0x3cec66=_0x251720,_0x33c3f1=$dataTroops[_0x103bbd];if(!_0x33c3f1)return'';let _0x22e7e6='';_0x22e7e6+=_0x33c3f1['name'];for(const _0x373b5b of _0x33c3f1['pages']){for(const _0x2c5f8a of _0x373b5b['list']){[0x6c,0x198][_0x3cec66(0x9b0)](_0x2c5f8a['code'])&&(_0x3cec66(0x6b0)===_0x3cec66(0x6b0)?(_0x22e7e6+='\x0a',_0x22e7e6+=_0x2c5f8a[_0x3cec66(0x14e)][0x0]):_0x1ac33e[_0x3cec66(0x97e)][_0x3cec66(0x9fc)]['call'](this,_0x28d07f,_0x480400,_0x4988b1,_0x3792d8,_0x154039));}}return _0x22e7e6;},ConfigManager['autoBattleAtStart']=ConfigManager[_0x251720(0x465)]??![],ConfigManager['autoBattleUseSkills']=ConfigManager[_0x251720(0x842)]??![],ConfigManager['visualHpGauge']=ConfigManager[_0x251720(0x6b5)]??!![],VisuMZ[_0x251720(0x731)][_0x251720(0x90b)]=ConfigManager[_0x251720(0x145)],ConfigManager[_0x251720(0x145)]=function(){const _0x3217ff=_0x251720,_0x4054b0=VisuMZ[_0x3217ff(0x731)]['ConfigManager_makeData'][_0x3217ff(0xa57)](this);return _0x4054b0[_0x3217ff(0x465)]=this[_0x3217ff(0x465)],_0x4054b0[_0x3217ff(0x842)]=this[_0x3217ff(0x842)],_0x4054b0[_0x3217ff(0x6b5)]=this['visualHpGauge'],_0x4054b0;},VisuMZ[_0x251720(0x731)][_0x251720(0x609)]=ConfigManager[_0x251720(0x4ef)],ConfigManager[_0x251720(0x4ef)]=function(_0x161ac7){const _0x140e5a=_0x251720;VisuMZ[_0x140e5a(0x731)][_0x140e5a(0x609)][_0x140e5a(0xa57)](this,_0x161ac7);if(_0x140e5a(0x465)in _0x161ac7)_0x140e5a(0x54e)!=='UXtma'?this['refreshMotion']():this[_0x140e5a(0x465)]=_0x161ac7[_0x140e5a(0x465)];else{if(_0x140e5a(0x15b)===_0x140e5a(0x15b))this[_0x140e5a(0x465)]=![];else{if(!_0x1c2904['isSceneBattle']())return;if(!_0x918d75['VisuMZ_1_ElementStatusCore'])return;const _0x253f97=_0x1de81e['_action'];if(!_0x253f97)return;_0x253f97['clearElementChanges']();}}_0x140e5a(0x842)in _0x161ac7?this[_0x140e5a(0x842)]=_0x161ac7[_0x140e5a(0x842)]:this[_0x140e5a(0x842)]=![],_0x140e5a(0x6b5)in _0x161ac7?this['visualHpGauge']=_0x161ac7['visualHpGauge']:this[_0x140e5a(0x6b5)]=!![];},VisuMZ[_0x251720(0x731)][_0x251720(0x799)]=BattleManager[_0x251720(0x147)],BattleManager['initMembers']=function(){const _0x45ca81=_0x251720;VisuMZ[_0x45ca81(0x731)]['BattleManager_initMembers'][_0x45ca81(0xa57)](this),this[_0x45ca81(0x64f)]=[];},BattleManager[_0x251720(0x4cc)]=function(){const _0x1761b5=_0x251720;if(!SceneManager['isSceneBattle']())return;const _0x25dc39=SceneManager[_0x1761b5(0x35b)][_0x1761b5(0xa7b)];if(_0x25dc39)_0x25dc39['requestRefresh']();},BattleManager[_0x251720(0x907)]=function(){const _0x2adaa6=_0x251720;if(BattleManager['isTpb']())return _0x2adaa6(0x707);return _0x2adaa6(0x796);},BattleManager[_0x251720(0x72e)]=function(_0x172c63){const _0x5893d0=_0x251720;return _0x172c63=_0x172c63['toUpperCase']()[_0x5893d0(0x30b)](),this['battleSys']()===_0x172c63;},BattleManager[_0x251720(0x20d)]=function(){const _0x5aca5b=_0x251720;return this[_0x5aca5b(0x72e)](_0x5aca5b(0x796));},BattleManager[_0x251720(0x950)]=function(){return this['isDTB']();},BattleManager[_0x251720(0xaca)]=function(){return!this['isTurnBased']();},BattleManager[_0x251720(0x54c)]=function(){const _0x88f816=_0x251720;return!this[_0x88f816(0x950)]()&&!this[_0x88f816(0xaca)]();},BattleManager[_0x251720(0xa55)]=function(_0x2ba625){const _0x550eb6=_0x251720;$gameParty[_0x550eb6(0xa55)](_0x2ba625),$gameTroop[_0x550eb6(0xa55)](_0x2ba625);},VisuMZ['BattleCore']['BattleManager_startBattle']=BattleManager[_0x251720(0x4b6)],BattleManager['startBattle']=function(){const _0x16b46f=_0x251720;this[_0x16b46f(0x1b0)]=![],this[_0x16b46f(0x8b7)]=ConfigManager[_0x16b46f(0x465)],this[_0x16b46f(0xa55)](_0x16b46f(0x279)),VisuMZ['BattleCore'][_0x16b46f(0x756)][_0x16b46f(0xa57)](this),this[_0x16b46f(0xa55)]('PostStartBattleJS');},BattleManager[_0x251720(0xa66)]=function(_0x50112b){const _0x28211c=_0x251720,_0x42ca69=VisuMZ[_0x28211c(0x731)][_0x28211c(0x825)][_0x28211c(0xa38)];_0x42ca69[_0x28211c(0x3c5)]&&VisuMZ[_0x28211c(0x731)][_0x28211c(0x369)](_0x42ca69['BattleEndEvent'])&&$gameTemp[_0x28211c(0x7e)](_0x42ca69['BattleEndEvent']);const _0x3be98c=_0x28211c(0x360)['format'](_0x50112b);_0x42ca69[_0x3be98c]&&VisuMZ[_0x28211c(0x731)]['CheckMapBattleEventValid'](_0x42ca69[_0x3be98c])&&(_0x28211c(0x6c)!==_0x28211c(0xa97)?$gameTemp['reserveCommonEvent'](_0x42ca69[_0x3be98c]):(this[_0x28211c(0x24f)][_0x28211c(0x2b2)](),this[_0x28211c(0x24f)][_0x28211c(0xb4)]&&this[_0x28211c(0x24f)][_0x28211c(0xa67)](),this[_0x28211c(0x215)][_0x28211c(0x2b2)](),this[_0x28211c(0x215)][_0x28211c(0xb4)]&&this[_0x28211c(0x215)][_0x28211c(0xa67)]()));},VisuMZ[_0x251720(0x731)]['BattleManager_processVictory']=BattleManager[_0x251720(0x5c3)],BattleManager['processVictory']=function(){const _0xba969=_0x251720;this[_0xba969(0xa55)]('BattleVictoryJS'),VisuMZ[_0xba969(0x731)][_0xba969(0x72f)]['call'](this),this[_0xba969(0xa66)](_0xba969(0x24a));},VisuMZ[_0x251720(0x731)][_0x251720(0x9d1)]=BattleManager[_0x251720(0x80e)],BattleManager['processDefeat']=function(){const _0x945fc6=_0x251720;this['processBattleCoreJS'](_0x945fc6(0x53b)),VisuMZ[_0x945fc6(0x731)][_0x945fc6(0x9d1)][_0x945fc6(0xa57)](this),this[_0x945fc6(0xa66)](_0x945fc6(0x697));},VisuMZ[_0x251720(0x731)][_0x251720(0x22e)]=BattleManager[_0x251720(0x903)],BattleManager[_0x251720(0x903)]=function(_0x5327e5){const _0x24dd2c=_0x251720;this['_endBattle']=!![],this[_0x24dd2c(0x8b7)]=![],this['processBattleCoreJS']('PreEndBattleJS'),VisuMZ[_0x24dd2c(0x731)]['BattleManager_endBattle'][_0x24dd2c(0xa57)](this,_0x5327e5),this['processBattleCoreJS'](_0x24dd2c(0x763));},VisuMZ[_0x251720(0x731)][_0x251720(0xa04)]=BattleManager[_0x251720(0x449)],BattleManager[_0x251720(0x449)]=function(){const _0x5775eb=_0x251720;if(this[_0x5775eb(0x950)]())this[_0x5775eb(0xa55)](_0x5775eb(0xa05));VisuMZ[_0x5775eb(0x731)][_0x5775eb(0xa04)][_0x5775eb(0xa57)](this);if(this[_0x5775eb(0x950)]())this[_0x5775eb(0xa55)](_0x5775eb(0x548));},VisuMZ[_0x251720(0x731)][_0x251720(0x897)]=BattleManager[_0x251720(0x419)],BattleManager[_0x251720(0x419)]=function(){const _0xfeae5f=_0x251720,_0x267b01=this[_0xfeae5f(0x29b)][_0xfeae5f(0x4c1)](),_0x3406db=this[_0xfeae5f(0x29b)];_0x267b01&&_0x267b01[_0xfeae5f(0x271)]()===_0x3406db&&_0x267b01[_0xfeae5f(0x60e)]('PreStartActionJS');VisuMZ[_0xfeae5f(0x731)][_0xfeae5f(0x897)][_0xfeae5f(0xa57)](this);if(_0x267b01&&_0x267b01['subject']()===_0x3406db){if('LZGOC'===_0xfeae5f(0x4e3)){const _0x24e458=_0x1fa3c1[_0xfeae5f(0x731)][_0xfeae5f(0x825)]['Mechanics'],_0x5cdaa1=_0x24e458[_0xfeae5f(0x94f)],_0x984887=_0x2778ce[_0x5cdaa1];if(_0x984887&&_0x2caeec['BattleCore'][_0xfeae5f(0x369)](_0x5cdaa1)){const _0xfd5ce4=this[_0xfeae5f(0x1a4)]()?this['_eventId']:0x0,_0x51f4bb=_0x984887[_0xfeae5f(0x855)];this[_0xfeae5f(0x300)](_0x51f4bb,_0xfd5ce4),this['_list']=_0x35e1b6[_0xfeae5f(0xa1d)](this['_list']);const _0x558771={'code':0xbc3,'indent':this[_0xfeae5f(0x8ac)],'parameters':_0x526198[_0xfeae5f(0xa1d)](_0x474c73)};return this[_0xfeae5f(0x619)][_0xfeae5f(0xa81)](this[_0xfeae5f(0x868)]+0x1,0x0,_0x558771),!![];}else return _0xd6762[_0xfeae5f(0x731)][_0xfeae5f(0x19a)][_0xfeae5f(0xa57)](this,_0x4a7f25);}else _0x267b01[_0xfeae5f(0x60e)](_0xfeae5f(0x4e5));}},VisuMZ[_0x251720(0x731)][_0x251720(0x2d5)]=BattleManager[_0x251720(0x42d)],BattleManager['endAction']=function(){const _0x18f521=_0x251720,_0x5132c4=this[_0x18f521(0x866)],_0xc12610=this[_0x18f521(0x29b)];_0x5132c4&&_0x5132c4!==this[_0x18f521(0x213)]&&_0x5132c4['subject']()===_0xc12610&&_0x5132c4['actionBattleCoreJS'](_0x18f521(0x446)),VisuMZ[_0x18f521(0x731)][_0x18f521(0x2d5)][_0x18f521(0xa57)](this),_0x5132c4&&_0x5132c4!==this[_0x18f521(0x213)]&&_0x5132c4[_0x18f521(0x271)]()===_0xc12610&&_0x5132c4['actionBattleCoreJS'](_0x18f521(0x5f7)),this['refreshBattlerMotions'](this[_0x18f521(0x552)]()),this[_0x18f521(0x213)]=this[_0x18f521(0x866)];},BattleManager[_0x251720(0x7a5)]=function(_0x56a227){const _0xbbc068=_0x251720;for(const _0x3ec8e1 of _0x56a227){if(_0xbbc068(0x340)!==_0xbbc068(0x340))_0x1eea02[_0xbbc068(0x731)][_0xbbc068(0x7c)]&&_0x86f73[_0xbbc068(0x731)][_0xbbc068(0x7c)][_0xbbc068(0xa57)](this,_0x36bc77),_0x3b27ef[_0xbbc068(0x731)][_0xbbc068(0x7c6)](_0x13c736),_0x2d7121[_0xbbc068(0x731)][_0xbbc068(0x15c)](_0x2ea6f5);else{if(!_0x3ec8e1)continue;if(!_0x3ec8e1['battler']())continue;_0x3ec8e1[_0xbbc068(0x60a)]()[_0xbbc068(0x853)]();}}},BattleManager[_0x251720(0x53f)]=function(){const _0x43f2d2=_0x251720;!this[_0x43f2d2(0x1cb)][_0x43f2d2(0xaa2)]()&&('nDpsx'!==_0x43f2d2(0x85a)?this['endAction']():_0x3a9e05[_0x43f2d2(0x3bf)]('undecided'));},Game_Battler[_0x251720(0x97e)][_0x251720(0x28e)]=function(){const _0x426d9e=_0x251720;this[_0x426d9e(0x678)]();if(Imported[_0x426d9e(0xc2)]){const _0x342fe2=VisuMZ[_0x426d9e(0x42a)][_0x426d9e(0x825)][_0x426d9e(0x3df)];if(_0x342fe2&&_0x342fe2[_0x426d9e(0x4f1)]===![]){if('btCIR'!==_0x426d9e(0x57a))return!_0x3ad0e1[_0x426d9e(0x56a)]()?this[_0x426d9e(0x19b)](_0x478c40):_0x5e77f3[_0x426d9e(0x731)][_0x426d9e(0x19a)][_0x426d9e(0xa57)](this,_0x3add1f);else this[_0x426d9e(0x9d9)](0x1);}}else this['removeStatesAuto'](0x1);this[_0x426d9e(0xa2d)]();},BattleManager['makeEscapeRatio']=function(){const _0x443842=_0x251720;this[_0x443842(0x1cf)]=VisuMZ[_0x443842(0x731)][_0x443842(0x825)][_0x443842(0xa38)][_0x443842(0x40a)]['call'](this);},VisuMZ['BattleCore'][_0x251720(0x33a)]=BattleManager[_0x251720(0x8a1)],BattleManager[_0x251720(0x8a1)]=function(){const _0x3e5e68=_0x251720;this[_0x3e5e68(0xa55)](_0x3e5e68(0x8fc)),BattleManager[_0x3e5e68(0x742)]['processEscape'](),VisuMZ[_0x3e5e68(0x731)][_0x3e5e68(0x33a)]['call'](this),this[_0x3e5e68(0xa66)](_0x3e5e68(0x372));},VisuMZ['BattleCore'][_0x251720(0x850)]=BattleManager[_0x251720(0x3e5)],BattleManager[_0x251720(0x3e5)]=function(){const _0x312bdc=_0x251720;this[_0x312bdc(0xa55)](_0x312bdc(0x3cf));const _0x3e7728=this[_0x312bdc(0x1cf)];VisuMZ[_0x312bdc(0x731)][_0x312bdc(0x850)][_0x312bdc(0xa57)](this),this[_0x312bdc(0x1cf)]=_0x3e7728+VisuMZ[_0x312bdc(0x731)]['Settings'][_0x312bdc(0xa38)][_0x312bdc(0x182)][_0x312bdc(0xa57)](this),this[_0x312bdc(0xa66)]('EscapeFail');},BattleManager['displayStartMessages']=function(){const _0x3bd594=_0x251720;let _0x515df9=![];if(this[_0x3bd594(0x55d)]())for(const _0x5c1580 of $gameTroop[_0x3bd594(0x963)]()){this[_0x3bd594(0x1cb)][_0x3bd594(0x141)](_0x3bd594(0x84b),TextManager[_0x3bd594(0x481)][_0x3bd594(0x8d6)](_0x5c1580)),this[_0x3bd594(0x1cb)][_0x3bd594(0x141)](_0x3bd594(0x990)),_0x515df9=!![];}if(this['_preemptive']){if('SKLmQ'!==_0x3bd594(0x61b))this[_0x3bd594(0x1cb)][_0x3bd594(0x141)](_0x3bd594(0x84b),TextManager[_0x3bd594(0x902)][_0x3bd594(0x8d6)]($gameParty[_0x3bd594(0x1f8)]())),this['_logWindow'][_0x3bd594(0x141)](_0x3bd594(0x990));else return _0x464db9['_scene'][_0x3bd594(0x5bf)]()===_0x3bd594(0x9bc)?_0x2dec3c[_0x3bd594(0x731)][_0x3bd594(0x825)][_0x3bd594(0x8ca)][_0x3bd594(0x6e8)]:_0x33ebb3[_0x3bd594(0x731)]['Settings'][_0x3bd594(0x8ca)][_0x3bd594(0x82a)];}else{if(this[_0x3bd594(0x2a3)]){if(_0x3bd594(0x691)===_0x3bd594(0x47a)){const _0x1eaafc=this[_0x3bd594(0x164)][_0x3bd594(0x2dd)](this['_lastEnemy']);this[_0x3bd594(0x37c)](_0x1eaafc);}else this[_0x3bd594(0x1cb)][_0x3bd594(0x141)](_0x3bd594(0x84b),TextManager[_0x3bd594(0x556)][_0x3bd594(0x8d6)]($gameParty['name']())),this[_0x3bd594(0x1cb)][_0x3bd594(0x141)](_0x3bd594(0x990));}}if(_0x515df9){if(_0x3bd594(0x751)===_0x3bd594(0x751))this['_logWindow'][_0x3bd594(0x141)](_0x3bd594(0x990)),this['_logWindow'][_0x3bd594(0x141)](_0x3bd594(0x90f));else return _0x1acbcb[_0x3bd594(0x731)]['Settings'][_0x3bd594(0x3b1)][_0x3bd594(0x7eb)]||_0x102b16[_0x3bd594(0x36d)]();}if(this['isTpb']()&&this['isSkipPartyCommandWindow']()){if(_0x3bd594(0x73f)!==_0x3bd594(0x70b))this[_0x3bd594(0x6f5)]=![];else{if(this[_0x3bd594(0x397)]&&this['_battler'][_0x3bd594(0xa63)]){const _0x55b6e0=this[_0x3bd594(0x397)][_0x3bd594(0xa63)];this[_0x3bd594(0x723)]=_0x16fe71['MOTIONS'][_0x55b6e0[_0x3bd594(0x7c1)]],this[_0x3bd594(0x258)]=_0x55b6e0['pattern'];const _0x1299ff=this[_0x3bd594(0x488)];_0x1299ff['freezeFrame'](_0x55b6e0[_0x3bd594(0x9e8)],_0x55b6e0[_0x3bd594(0x961)]),this[_0x3bd594(0x51d)]();}}}},BattleManager['isDisplayEmergedEnemies']=function(){const _0x1bcfaa=_0x251720;if(BattleManager[_0x1bcfaa(0x8b7)])return![];return VisuMZ['BattleCore']['Settings'][_0x1bcfaa(0x3b1)][_0x1bcfaa(0x58a)];},VisuMZ[_0x251720(0x731)][_0x251720(0x31e)]=BattleManager[_0x251720(0x4f4)],BattleManager[_0x251720(0x4f4)]=function(){const _0x2a2393=_0x251720;VisuMZ[_0x2a2393(0x731)][_0x2a2393(0x31e)][_0x2a2393(0xa57)](this),this['isDTB']()&&this[_0x2a2393(0xa7e)]()&&!this[_0x2a2393(0x2a3)]&&$gameParty[_0x2a2393(0x51b)]()&&this[_0x2a2393(0x1da)]();},BattleManager[_0x251720(0xa7e)]=function(){const _0xbab316=_0x251720;return VisuMZ[_0xbab316(0x731)][_0xbab316(0x825)][_0xbab316(0x85f)][_0xbab316(0x54a)];},BattleManager[_0x251720(0x5fa)]=function(){const _0x2f8e04=_0x251720;this[_0x2f8e04(0x511)]()&&(_0x2f8e04(0x790)==='NDVka'?this[_0x2f8e04(0x1da)]():(this[_0x2f8e04(0x24f)][_0x2f8e04(0x824)](),this['_itemWindow'][_0x2f8e04(0x824)]()));},VisuMZ[_0x251720(0x731)]['Scene_Battle_startActorCommandSelection']=Scene_Battle['prototype']['startActorCommandSelection'],Scene_Battle[_0x251720(0x97e)][_0x251720(0xaab)]=function(){const _0x22088f=_0x251720;VisuMZ[_0x22088f(0x731)][_0x22088f(0x304)]['call'](this);if(BattleManager[_0x22088f(0xb2)]()&&BattleManager[_0x22088f(0x6f5)]){if(_0x22088f(0x9cd)!==_0x22088f(0x9cd)){if(_0x19f894[_0x22088f(0x4a8)]())_0x58e4c9['log'](_0xaaaedc);return _0x3f5779[_0x22088f(0x731)][_0x22088f(0x83a)][_0x22088f(0xa57)](this);}else BattleManager[_0x22088f(0x6f5)]=![],this[_0x22088f(0x61e)]();}},BattleManager[_0x251720(0xa2e)]=function(_0x2d1976,_0xe6c3e){const _0x2c42e7=_0x251720;this['_action']['_reflectionTarget']=_0xe6c3e,this['_logWindow'][_0x2c42e7(0x9a7)](_0xe6c3e),this[_0x2c42e7(0x1cb)]['displayReflectionPlayBack'](_0x2d1976,this['_action']),this['_action'][_0x2c42e7(0x1d9)](_0x2d1976),this[_0x2c42e7(0x1cb)]['displayActionResults'](_0x2d1976,_0x2d1976);},VisuMZ['BattleCore'][_0x251720(0x5af)]=BattleManager[_0x251720(0x547)],BattleManager[_0x251720(0x547)]=function(){const _0x3abf39=_0x251720;VisuMZ[_0x3abf39(0x731)][_0x3abf39(0x5af)][_0x3abf39(0xa57)](this),this[_0x3abf39(0xfd)]=this[_0x3abf39(0xfd)]['filter'](_0xcf02de=>_0xcf02de&&_0xcf02de[_0x3abf39(0x217)]());},VisuMZ[_0x251720(0x731)][_0x251720(0xa03)]=BattleManager[_0x251720(0xaa)],BattleManager[_0x251720(0xaa)]=function(_0x6a582){const _0x1ca325=_0x251720;if(this['_phase']===_0x1ca325(0x3be))this[_0x1ca325(0x3d7)]();else this[_0x1ca325(0x56e)]===_0x1ca325(0x834)?this[_0x1ca325(0x7d5)]():VisuMZ[_0x1ca325(0x731)][_0x1ca325(0xa03)][_0x1ca325(0xa57)](this,_0x6a582);},BattleManager[_0x251720(0x46c)]=function(){const _0x2e2f60=_0x251720;this[_0x2e2f60(0x8cb)]=this[_0x2e2f60(0x45b)][_0x2e2f60(0xa79)](0x0),this[_0x2e2f60(0x1d1)]=0x0,this[_0x2e2f60(0x312)]=this[_0x2e2f60(0x8cb)][0x0]||null,this[_0x2e2f60(0x56e)]=_0x2e2f60(0x3be);},BattleManager[_0x251720(0x3d7)]=function(){const _0x1c0e5e=_0x251720;!this[_0x1c0e5e(0xab1)]()&&!this[_0x1c0e5e(0x1cb)][_0x1c0e5e(0xaa2)]()&&(this[_0x1c0e5e(0x56e)]=_0x1c0e5e(0x3a4));},BattleManager[_0x251720(0x834)]=function(_0x4f2ba4){const _0x15cae5=_0x251720;this[_0x15cae5(0xfd)][_0x15cae5(0x39c)](_0x4f2ba4);if(_0x4f2ba4===this[_0x15cae5(0x29b)])return;const _0x27f3e5=JsonEx[_0x15cae5(0xa1d)](_0x4f2ba4[_0x15cae5(0x4c1)]());this[_0x15cae5(0x64f)]['push']([_0x4f2ba4,_0x27f3e5]);},BattleManager[_0x251720(0x569)]=function(){},BattleManager['updateStart']=function(){const _0x2f2481=_0x251720;if(this['isTpb']())_0x2f2481(0x79)===_0x2f2481(0x79)?this[_0x2f2481(0x56e)]=_0x2f2481(0x197):_0x40a0fc[_0x2f2481(0xb2)]()?(this[_0x2f2481(0x402)](),this[_0x2f2481(0xaab)]()):_0x53909d['BattleCore'][_0x2f2481(0xa95)][_0x2f2481(0xa57)](this);else{if(this[_0x2f2481(0x64f)][_0x2f2481(0x988)]>0x0){if('yYgoI'===_0x2f2481(0x198))return _0x85f4cf;else this[_0x2f2481(0x56e)]=_0x2f2481(0x197);}else this[_0x2f2481(0x4f4)]();}},BattleManager[_0x251720(0x7ce)]=function(){const _0x2c1583=_0x251720,_0x2a386d=this[_0x2c1583(0x29b)];if(_0x2a386d&&this[_0x2c1583(0xb2)]()){if(_0x2c1583(0x2ff)===_0x2c1583(0x28d)){if(this[_0x2c1583(0x522)]<=0x0)return;if(!this[_0x2c1583(0x316)])return;const _0x2cb28f=this[_0x2c1583(0x522)],_0x3423ab=this[_0x2c1583(0x579)],_0x350fa7=this['_growEasing'];_0x32069a[_0x2c1583(0x7a8)]?(this[_0x2c1583(0x4ed)]=this['applyEasing'](this[_0x2c1583(0x4ed)],this['_targetGrowX'],_0x2cb28f,_0x3423ab,_0x350fa7),this[_0x2c1583(0x2c5)]=this[_0x2c1583(0xa94)](this[_0x2c1583(0x2c5)],this[_0x2c1583(0xcd)],_0x2cb28f,_0x3423ab,_0x350fa7)):(this[_0x2c1583(0x4ed)]=(this['_growX']*(_0x2cb28f-0x1)+this['_targetGrowX'])/_0x2cb28f,this['_growY']=(this[_0x2c1583(0x2c5)]*(_0x2cb28f-0x1)+this['_targetGrowY'])/_0x2cb28f);this[_0x2c1583(0x522)]--;if(this[_0x2c1583(0x522)]<=0x0)this['onGrowEnd']();}else _0x2a386d[_0x2c1583(0x3bf)](_0x2c1583(0x7f4));}for(;;){const _0x824b0a=this[_0x2c1583(0x2de)]();if(!_0x824b0a)return null;if(_0x824b0a['isBattleMember']()&&_0x824b0a[_0x2c1583(0x2ce)]())return _0x824b0a;}},BattleManager[_0x251720(0x2de)]=function(){const _0x4f47c7=_0x251720;if(this[_0x4f47c7(0x64f)][_0x4f47c7(0x988)]>0x0){if(_0x4f47c7(0xa71)==='RxmZY'){const _0x1d032c=this[_0x4f47c7(0x64f)][_0x4f47c7(0x7e7)](),_0x124d2c=_0x1d032c[0x0];return _0x124d2c[_0x4f47c7(0x15d)]=_0x124d2c[_0x4f47c7(0x15d)]||[],_0x124d2c['_actions'][0x0]=_0x1d032c[0x1],_0x124d2c;}else{const _0x1c7da6=this[_0x4f47c7(0x272)](_0x3a8193);if(_0x1c7da6==='iconText')this['drawItemStyleIconText'](_0x923f1f);else _0x1c7da6===_0x4f47c7(0x85)?this[_0x4f47c7(0x81b)](_0x33e8f8):_0x139d63['prototype'][_0x4f47c7(0x6d9)][_0x4f47c7(0xa57)](this,_0x146cef);}}else return this[_0x4f47c7(0xfd)][_0x4f47c7(0x7e7)]();},VisuMZ[_0x251720(0x731)]['Game_Battler_forceAction']=Game_Battler['prototype'][_0x251720(0x834)],Game_Battler[_0x251720(0x97e)][_0x251720(0x834)]=function(_0x4d0448,_0x20cc4f){const _0x6a98ae=_0x251720;VisuMZ['BattleCore']['Game_Battler_forceAction']['call'](this,_0x4d0448,_0x20cc4f),this['_actions'][this[_0x6a98ae(0x15d)][_0x6a98ae(0x988)]-0x1]['_forceAction']=!![];},Game_Interpreter[_0x251720(0x97e)][_0x251720(0x9a2)]=function(_0x5cbf6b){const _0x1d6e84=_0x251720;return this[_0x1d6e84(0x523)](_0x5cbf6b[0x0],_0x5cbf6b[0x1],_0x284a62=>{const _0x291008=_0x1d6e84;!_0x284a62[_0x291008(0x490)]()&&(_0x284a62['forceAction'](_0x5cbf6b[0x2],_0x5cbf6b[0x3]),BattleManager['forceAction'](_0x284a62));}),!![];},VisuMZ[_0x251720(0x731)]['Game_Battler_makeSpeed']=Game_Battler[_0x251720(0x97e)][_0x251720(0x9f6)],Game_Battler[_0x251720(0x97e)][_0x251720(0x9f6)]=function(){const _0x36603a=_0x251720;VisuMZ['BattleCore'][_0x36603a(0x8e5)][_0x36603a(0xa57)](this),this[_0x36603a(0x15d)][_0x36603a(0x988)]<=0x0&&(this[_0x36603a(0x3a1)]=Number[_0x36603a(0x9de)]);},VisuMZ['BattleCore'][_0x251720(0x106)]=BattleManager[_0x251720(0x1da)],BattleManager[_0x251720(0x1da)]=function(){const _0x3c1d38=_0x251720;this[_0x3c1d38(0xb2)]()?this[_0x3c1d38(0x89f)]():VisuMZ[_0x3c1d38(0x731)]['BattleManager_selectNextCommand'][_0x3c1d38(0xa57)](this);},BattleManager['selectNextCommandTpb']=function(){const _0xf94946=_0x251720;if(this[_0xf94946(0x926)]){if(_0xf94946(0x835)!==_0xf94946(0x8e0)){if(this[_0xf94946(0x926)]['selectNextCommand']())return;this[_0xf94946(0x8ab)](),this['checkTpbInputClose']();if(!this[_0xf94946(0x29b)]&&!this['_currentActor']){if('DKTSP'===_0xf94946(0x308))return this[_0xf94946(0x336)]()[_0xf94946(0x84)](_0x56ea67=>_0x56ea67['isFloating']());else SceneManager[_0xf94946(0x35b)]['updateBattleProcess']();}}else this[_0xf94946(0x777)]();}else!this[_0xf94946(0x29b)]&&(_0xf94946(0x856)===_0xf94946(0x856)?this[_0xf94946(0x37a)]():this[_0xf94946(0xa7d)][_0xf94946(0x8c4)](0x0,0x0,this['_mainSprite'][_0xf94946(0x139)],this['_effectDuration']));},BattleManager[_0x251720(0xa37)]=function(){const _0x17f48b=_0x251720;if(!this[_0x17f48b(0x511)]()||this[_0x17f48b(0x70c)]()){if(this['_tpbSceneChangeCacheActor']){if(_0x17f48b(0x921)!==_0x17f48b(0xa76)){if(!$gameParty[_0x17f48b(0x5e2)]()['includes'](this[_0x17f48b(0x5e8)])){if('vCDhR'===_0x17f48b(0xa48))this['_tpbSceneChangeCacheActor']=null;else{const _0x3ff210=_0x21911a(_0x584e3b['$1']);this[_0x17f48b(0x3f0)](_0x3ff210);}}}else _0x35b242[_0x17f48b(0x731)][_0x17f48b(0x825)][_0x17f48b(0x3b1)]['NameAttachStateIcon']&&(this['_stateIconSprite']=new _0x4f476a(),this[_0x17f48b(0x26f)](this[_0x17f48b(0x83f)]));}!this[_0x17f48b(0x5e8)]?(this[_0x17f48b(0x354)](),this[_0x17f48b(0x926)]=null,this[_0x17f48b(0xaa8)]=![]):_0x17f48b(0x6c4)!==_0x17f48b(0x6c4)?(_0x45a2f5['BattleCore']['Sprite_Actor_update'][_0x17f48b(0xa57)](this),this[_0x17f48b(0x81d)]&&(this[_0x17f48b(0x6ae)](),this[_0x17f48b(0x6c7)]())):this['revertTpbCachedActor']();}},BattleManager['revertTpbCachedActor']=function(){const _0x27522f=_0x251720;!$gameParty[_0x27522f(0x5e2)]()[_0x27522f(0x9b0)](this[_0x27522f(0x5e8)])&&(_0x27522f(0x53c)===_0x27522f(0x53c)?this[_0x27522f(0x5e8)]=null:this[_0x27522f(0xa7d)][_0x27522f(0x817)]['smooth']=this[_0x27522f(0x397)][_0x27522f(0x26c)]()),this['_tpbSceneChangeCacheActor']?(this[_0x27522f(0x926)]=this[_0x27522f(0x5e8)],this['_currentActor']['_tpbState']=_0x27522f(0x174),this[_0x27522f(0xaa8)]=!![],this[_0x27522f(0x5e8)]=null):(this[_0x27522f(0x354)](),this[_0x27522f(0x926)]=null,this['_inputting']=![]);},VisuMZ['BattleCore'][_0x251720(0xa2)]=BattleManager['isTpbMainPhase'],BattleManager[_0x251720(0x724)]=function(){const _0x440dde=_0x251720;return this['_phase']==='custom'?this[_0x440dde(0x92c)]():VisuMZ['BattleCore'][_0x440dde(0xa2)][_0x440dde(0xa57)](this);},BattleManager[_0x251720(0x92c)]=function(){const _0x162956=_0x251720;return this[_0x162956(0x8a4)]();},VisuMZ[_0x251720(0x731)]['BattleManager_cancelActorInput']=BattleManager[_0x251720(0x354)],BattleManager[_0x251720(0x354)]=function(){const _0x2c9501=_0x251720;this[_0x2c9501(0xb2)]()&&this[_0x2c9501(0x56e)]===_0x2c9501(0x2d1)&&(this[_0x2c9501(0x926)]=null),VisuMZ[_0x2c9501(0x731)]['BattleManager_cancelActorInput'][_0x2c9501(0xa57)](this);},VisuMZ[_0x251720(0x731)]['BattleManager_inputtingAction']=BattleManager[_0x251720(0x407)],BattleManager[_0x251720(0x407)]=function(){const _0x1abb13=_0x251720,_0xb4a94a=this['_currentActor'];if(_0xb4a94a&&!_0xb4a94a[_0x1abb13(0x407)]()){if(_0x1abb13(0x9f1)===_0x1abb13(0x293))return 0x0;else{const _0x28b4c0=_0xb4a94a['_actionInputIndex'];_0xb4a94a[_0x1abb13(0x15d)][_0x28b4c0]=new Game_Action(_0xb4a94a);}}return VisuMZ['BattleCore']['BattleManager_inputtingAction'][_0x1abb13(0xa57)](this);},SceneManager[_0x251720(0x847)]=function(){const _0x1253a8=_0x251720;return this[_0x1253a8(0x35b)]&&this['_scene'][_0x1253a8(0x8c)]===Scene_Battle;},SceneManager[_0x251720(0x443)]=function(){const _0x4316cb=_0x251720;return Spriteset_Battle[_0x4316cb(0x97e)][_0x4316cb(0xa33)]();},SceneManager['isPreviousSceneBattleTransitionable']=function(){const _0x46a47a=_0x251720;if(SceneManager[_0x46a47a(0x7aa)](Scene_Options))return!![];return![];},SceneManager[_0x251720(0xac5)]=function(){const _0x1f72cb=_0x251720;if(SceneManager[_0x1f72cb(0x2c2)](Scene_Options))return!![];return![];},VisuMZ[_0x251720(0x731)][_0x251720(0x8e)]=Game_Temp[_0x251720(0x97e)][_0x251720(0x95b)],Game_Temp['prototype'][_0x251720(0x95b)]=function(_0x7090a,_0x36e26d,_0x11cdf4){const _0x305895=_0x251720;_0x7090a=_0x7090a[_0x305895(0x778)]((_0x581f39,_0x376df0,_0xd92eab)=>_0xd92eab[_0x305895(0x2dd)](_0x581f39)===_0x376df0);if(SceneManager[_0x305895(0x847)]()&&SceneManager[_0x305895(0x443)]()){if('mUyoj'!==_0x305895(0x9b)){if(_0x18e8bc[_0x305895(0x417)]())this[_0x305895(0xa2b)](),this[_0x305895(0x6f4)]=![],_0x5bbf13[_0x305895(0x4d8)]();else this['_requestRefresh']&&(this['_requestRefresh']=![],this[_0x305895(0x841)](),this[_0x305895(0x486)]());}else _0x11cdf4=!_0x11cdf4;}VisuMZ[_0x305895(0x731)][_0x305895(0x8e)][_0x305895(0xa57)](this,_0x7090a,_0x36e26d,_0x11cdf4),SceneManager[_0x305895(0x847)]()&&(_0x305895(0x4d3)===_0x305895(0x4d3)?BattleManager[_0x305895(0x742)]['processAnimationRequests']():(_0x5b2d9c[_0x305895(0x731)][_0x305895(0x557)][_0x305895(0xa57)](this,_0xbc306d),this[_0x305895(0x648)]()));},Game_Temp['prototype'][_0x251720(0x686)]=function(_0x203aeb){this['_lastPluginCommandInterpreter']=_0x203aeb;},Game_Temp['prototype']['getLastPluginCommandInterpreter']=function(){const _0x2cffc5=_0x251720;return this[_0x2cffc5(0x44e)];},Game_Temp[_0x251720(0x97e)]['clearForcedGameTroopSettingsBattleCore']=function(){const _0x5af41e=_0x251720;this[_0x5af41e(0xa0d)]=undefined;},Game_Temp[_0x251720(0x97e)][_0x251720(0xbf)]=function(_0x5832b){const _0x235f93=_0x251720;$gameMap&&$dataMap&&$dataMap[_0x235f93(0x67f)]&&this[_0x235f93(0x1d0)]($dataMap['note']);const _0x299b39=$dataTroops[_0x5832b];if(_0x299b39){if(_0x235f93(0x9aa)!==_0x235f93(0x227)){let _0x10dccc=DataManager['createTroopNote'](_0x299b39['id']);this[_0x235f93(0x1d0)](_0x10dccc);}else this['startMotion'](_0x235f93(0x750));}},Game_Temp['prototype']['parseForcedGameTroopSettingsBattleCore']=function(_0xbdad1f){const _0x5c1552=_0x251720;if(!_0xbdad1f)return;if(_0xbdad1f[_0x5c1552(0x591)](/<(?:BATTLELAYOUT|BATTLE LAYOUT|LAYOUT):[ ](.*)>/i)){if(_0x5c1552(0x86e)==='JSJNj')this[_0x5c1552(0x1aa)]=0x0,this['_currentAngle']=0x0;else{const _0x3814f0=String(RegExp['$1']);if(_0x3814f0[_0x5c1552(0x591)](/DEFAULT/i))this[_0x5c1552(0xa0d)]=_0x5c1552(0xa0f);else{if(_0x3814f0[_0x5c1552(0x591)](/LIST/i))this[_0x5c1552(0xa0d)]='list';else{if(_0x3814f0[_0x5c1552(0x591)](/XP/i)){if(_0x5c1552(0x2fa)!=='iGcQH')this['_forcedBattleLayout']='xp';else{const _0x216597=_0xc7fcda[_0x5c1552(0x22b)](this[_0x5c1552(0x68b)]),_0x1dbbfa=_0x386c85[_0x5c1552(0x5e7)][_0x216597];if(!_0x1dbbfa)return this['getItemDamageAmountLabelOriginal']();const _0x5c95b1='DamageType%1'[_0x5c1552(0x8d6)](this[_0x5c1552(0x68b)][_0x5c1552(0x363)]['type']),_0x455d47=[null,_0x2fd2bf['hp'],_0x15cffe['mp'],_0xf2a1c0['hp'],_0x23aea9['mp'],_0x1e3858['hp'],_0x1275df['mp']][this[_0x5c1552(0x68b)][_0x5c1552(0x363)][_0x5c1552(0x74e)]];return _0x1dbbfa[_0x5c95b1][_0x5c1552(0x8d6)](_0x455d47);}}else{if(_0x3814f0[_0x5c1552(0x591)](/PORTRAIT/i))this[_0x5c1552(0xa0d)]=_0x5c1552(0x234);else{if(_0x3814f0[_0x5c1552(0x591)](/BORDER/i))this[_0x5c1552(0xa0d)]='border';else{if(_0x3814f0[_0x5c1552(0x591)](/(?:SIDEVIEW UI|SIDEVIEW)/i)){if(Imported[_0x5c1552(0x9e4)])_0x5c1552(0x1de)===_0x5c1552(0x107)?(_0x39e262[_0x5c1552(0x731)][_0x5c1552(0xa07)][_0x5c1552(0xa57)](this),this[_0x5c1552(0x8f9)]=this['_iconIndex']>0x0?0xff:0x0):this['_forcedBattleLayout']=_0x5c1552(0x42b);else{if(_0x5c1552(0x1fa)==='QZDDY'){const _0x13c3c2=_0x3834a2[_0x5c1552(0x342)]();this['setupActionSet'](_0x358362,_0x5443ea,_0x12d9d3),this[_0x5c1552(0x1ce)](_0x563182,_0x2cc8a0,_0x287828),this[_0x5c1552(0x813)](_0x1596b4,_0x815af8,_0x1e31fa);}else this[_0x5c1552(0xa0d)]=_0x5c1552(0xa0f);}}}}}}}}}},VisuMZ['BattleCore'][_0x251720(0x883)]=Game_System[_0x251720(0x97e)]['initialize'],Game_System[_0x251720(0x97e)][_0x251720(0x43e)]=function(){const _0x1fb999=_0x251720;VisuMZ[_0x1fb999(0x731)][_0x1fb999(0x883)]['call'](this),this[_0x1fb999(0x17d)]();},Game_System[_0x251720(0x97e)][_0x251720(0x17d)]=function(){const _0x315f0a=_0x251720;this[_0x315f0a(0x8d8)]=this[_0x315f0a(0x8d8)]||[];},Game_System['prototype'][_0x251720(0x411)]=function(){const _0x5636fc=_0x251720;if(this['_defeatedEnemies']===undefined)this['initBattleCore']();return this[_0x5636fc(0x8d8)];},Game_System[_0x251720(0x97e)]['registerDefeatedEnemy']=function(_0x578dda){const _0x202d2a=_0x251720;if(this[_0x202d2a(0x8d8)]===undefined)this[_0x202d2a(0x17d)]();if(!_0x578dda)return;if(this[_0x202d2a(0x8d8)][_0x202d2a(0x9b0)](_0x578dda))return;this['_defeatedEnemies'][_0x202d2a(0x141)](_0x578dda),this[_0x202d2a(0x8d8)][_0x202d2a(0x713)]((_0x1de17f,_0x5a8311)=>_0x1de17f-_0x5a8311);},VisuMZ[_0x251720(0x731)][_0x251720(0x18b)]=Game_BattlerBase['prototype']['addNewState'],Game_BattlerBase['prototype']['addNewState']=function(_0x1d8a0b){const _0x3d42c5=_0x251720,_0x75cb22=this['isAlive'](),_0x4a7d4c=this['stateMotionIndex']();VisuMZ[_0x3d42c5(0x731)]['Game_BattlerBase_addNewState'][_0x3d42c5(0xa57)](this,_0x1d8a0b),this[_0x3d42c5(0x722)]()&&_0x75cb22&&this[_0x3d42c5(0x864)]()&&('GWczr'==='GWczr'?(this[_0x3d42c5(0x8ce)]=!this[_0x3d42c5(0x278)](),$gameSystem[_0x3d42c5(0x5e0)](this['enemyId']())):(this[_0x3d42c5(0x332)](),this[_0x3d42c5(0x531)](),this[_0x3d42c5(0x159)](),this[_0x3d42c5(0x8f7)](),this['addEscapeCommand']())),SceneManager[_0x3d42c5(0x847)]()&&_0x4a7d4c!==this[_0x3d42c5(0x8a9)]()&&(this[_0x3d42c5(0x60a)]()&&('iGnGZ'!==_0x3d42c5(0xea)?_0x15f975+=_0x478c54[_0x3d42c5(0x139)]-_0x20c16b:this[_0x3d42c5(0x60a)]()[_0x3d42c5(0x853)]()));},Game_Enemy[_0x251720(0x97e)]['hasBeenDefeatedBefore']=function(){const _0x475c64=_0x251720;return $gameSystem[_0x475c64(0x411)]()[_0x475c64(0x9b0)](this[_0x475c64(0x35a)]);},VisuMZ['BattleCore']['Game_BattlerBase_eraseState']=Game_BattlerBase['prototype']['eraseState'],Game_BattlerBase[_0x251720(0x97e)][_0x251720(0x8c9)]=function(_0x384211){const _0x23dc7d=_0x251720;VisuMZ[_0x23dc7d(0x731)][_0x23dc7d(0x89e)][_0x23dc7d(0xa57)](this,_0x384211),this['isEnemy']()&&_0x384211===this[_0x23dc7d(0x1b1)]()&&this['isAlive']()&&(this[_0x23dc7d(0x8ce)]=![]),!this[_0x23dc7d(0x600)]&&!this[_0x23dc7d(0x1bd)]&&SceneManager[_0x23dc7d(0x847)]()&&('usSrC'!=='usSrC'?(this[_0x23dc7d(0x694)]=this['_targetAngle'],this[_0x23dc7d(0x167)]&&(this[_0x23dc7d(0x1aa)]=0x0,this[_0x23dc7d(0x694)]=0x0)):this[_0x23dc7d(0x711)]());},VisuMZ['BattleCore'][_0x251720(0x20b)]=Game_Action[_0x251720(0x97e)][_0x251720(0x90f)],Game_Action['prototype']['clear']=function(){const _0x5cc3ce=_0x251720;VisuMZ[_0x5cc3ce(0x731)][_0x5cc3ce(0x20b)][_0x5cc3ce(0xa57)](this),this[_0x5cc3ce(0x687)]={'arPenRate':0x0,'arPenFlat':0x0,'arRedRate':0x0,'arRedFlat':0x0},this['_multipliers']={'criticalHitRate':0x1,'criticalHitFlat':0x0,'criticalDmgRate':0x1,'criticalDmgFlat':0x0,'damageRate':0x1,'damageFlat':0x0,'hitRate':0x1,'hitFlat':0x0},this[_0x5cc3ce(0x151)]=_0x5cc3ce(0xa0f);},Game_Action[_0x251720(0x97e)][_0x251720(0x4c3)]=function(_0x17f3c7,_0x2ba957){const _0x464345=_0x251720;return VisuMZ[_0x464345(0x731)][_0x464345(0x825)][_0x464345(0x2e1)][_0x464345(0x355)][_0x464345(0xa57)](this,_0x17f3c7,_0x2ba957);},Game_Action[_0x251720(0x97e)][_0x251720(0x532)]=function(_0x1db79b,_0x3217f4){const _0x53c29e=_0x251720;return VisuMZ[_0x53c29e(0x731)][_0x53c29e(0x825)][_0x53c29e(0x2e1)]['VarianceFormulaJS'][_0x53c29e(0xa57)](this,_0x1db79b,_0x3217f4);},Game_Action[_0x251720(0x97e)]['applyGuard']=function(_0xe9a200,_0x127276){const _0x2fcaca=_0x251720;return VisuMZ[_0x2fcaca(0x731)]['Settings'][_0x2fcaca(0x2e1)][_0x2fcaca(0x542)][_0x2fcaca(0xa57)](this,_0xe9a200,_0x127276);},VisuMZ[_0x251720(0x731)][_0x251720(0x49d)]=Game_Action[_0x251720(0x97e)][_0x251720(0x7be)],Game_Action['prototype']['itemHit']=function(_0xb79313){const _0x5014a7=_0x251720,_0x1568c9=this[_0x5014a7(0x342)]()[_0x5014a7(0x67f)];if(_0x1568c9[_0x5014a7(0x591)](/<ALWAYS HIT>/i)){if(_0x5014a7(0x3b7)!==_0x5014a7(0x3b7)){this['commandName'](_0x4a1525)[_0x5014a7(0x591)](/\\I\[(\d+)\]/i);const _0x23617c=_0x509e42(_0x59959f['$1'])||0x0,_0x1ee7e=this['itemLineRect'](_0x5e9de1),_0x496d0d=_0x1ee7e['x']+_0x23a0b5['floor']((_0x1ee7e[_0x5014a7(0x139)]-_0x4d016a[_0x5014a7(0x391)])/0x2),_0xfd924c=_0x1ee7e['y']+(_0x1ee7e[_0x5014a7(0x442)]-_0x24ec4a[_0x5014a7(0x162)])/0x2;this[_0x5014a7(0x97a)](_0x23617c,_0x496d0d,_0xfd924c);}else return 0x1;}else{if(_0x1568c9[_0x5014a7(0x591)](/<ALWAYS HIT RATE: (\d+)([%％])>/i)){if(_0x5014a7(0x98c)===_0x5014a7(0x98c))return Number(RegExp['$1'])/0x64;else{let _0x7894a8=0x0;return _0x7894a8;}}else{if(_0x5014a7(0x9e3)!==_0x5014a7(0x9e3)){const _0x109087=_0x58fef6(_0x385830['$1']);this[_0x5014a7(0x788)](_0x38cd3d[_0x109087]);}else{let _0x3c1e8e=VisuMZ[_0x5014a7(0x731)][_0x5014a7(0x49d)][_0x5014a7(0xa57)](this,_0xb79313);return _0x3c1e8e=this[_0x5014a7(0x2e7)]['hitRate']*_0x3c1e8e+this[_0x5014a7(0x2e7)]['hitFlat'],_0x3c1e8e;}}}},Game_Action[_0x251720(0x97e)][_0x251720(0xacd)]=function(_0x4e2f42){const _0x5cdbae=_0x251720;if(!this[_0x5cdbae(0x342)]()[_0x5cdbae(0x363)][_0x5cdbae(0x8f5)])return 0x0;let _0x379781=VisuMZ['BattleCore'][_0x5cdbae(0x825)]['Damage'][_0x5cdbae(0x13d)][_0x5cdbae(0xa57)](this,_0x4e2f42);return _0x379781=this[_0x5cdbae(0x2e7)]['criticalHitRate']*_0x379781+this['_multipliers']['criticalHitFlat'],_0x379781;},Game_Action[_0x251720(0x97e)][_0x251720(0x9d2)]=function(_0x45472d){const _0xaef1b4=_0x251720;return _0x45472d=VisuMZ[_0xaef1b4(0x731)][_0xaef1b4(0x825)][_0xaef1b4(0x2e1)]['CriticalHitMultiplier'][_0xaef1b4(0xa57)](this,_0x45472d),_0x45472d=this[_0xaef1b4(0x2e7)][_0xaef1b4(0x8b8)]*_0x45472d+this['_multipliers'][_0xaef1b4(0x31b)],_0x45472d;},VisuMZ[_0x251720(0x731)]['Game_Action_evalDamageFormula']=Game_Action['prototype'][_0x251720(0x94b)],Game_Action[_0x251720(0x97e)][_0x251720(0x94b)]=function(_0x1d4b58){const _0x5e3fd8=_0x251720;if(this[_0x5e3fd8(0x151)]!==_0x5e3fd8(0xa0f)){if(_0x5e3fd8(0x1ff)!==_0x5e3fd8(0xca))return this[_0x5e3fd8(0x60d)](_0x1d4b58);else this[_0x5e3fd8(0x71c)](_0x36158d);}else return DataManager[_0x5e3fd8(0x22b)](this[_0x5e3fd8(0x342)]())===_0x5e3fd8(0x5d8)?VisuMZ[_0x5e3fd8(0x731)]['Game_Action_evalDamageFormula'][_0x5e3fd8(0xa57)](this,_0x1d4b58):_0x5e3fd8(0xa3c)===_0x5e3fd8(0xa3c)?this[_0x5e3fd8(0x606)](_0x1d4b58):!![];},Game_Action[_0x251720(0x97e)][_0x251720(0x693)]=function(_0x1282d0){const _0x7ba0b8=_0x251720;this[_0x7ba0b8(0x151)]=_0x1282d0;},Game_Action[_0x251720(0x97e)][_0x251720(0x60d)]=function(_0x23f70c){const _0x35332a=_0x251720,_0x25b6f9=this[_0x35332a(0x342)](),_0x6d2762=_0x25b6f9[_0x35332a(0x363)][_0x35332a(0x5b2)];_0x25b6f9[_0x35332a(0x363)][_0x35332a(0x5b2)]=this[_0x35332a(0x151)];let _0x795a0c=VisuMZ[_0x35332a(0x731)][_0x35332a(0x83a)][_0x35332a(0xa57)](this,_0x23f70c);return _0x25b6f9[_0x35332a(0x363)][_0x35332a(0x5b2)]=_0x6d2762,_0x795a0c;},Game_Action[_0x251720(0x97e)]['damageStyle']=function(){const _0x193118=_0x251720;if(this[_0x193118(0x342)]()['note']['match'](/<DAMAGE STYLE:[ ](.*)>/i)){const _0x41b2e4=String(RegExp['$1'])['toUpperCase']()[_0x193118(0x30b)]();return _0x41b2e4;}return _0x193118(0x5d8);},Game_Action[_0x251720(0x97e)]['evalDamageFormulaBattleCore']=function(_0x5f0df1){const _0x1ac3fd=_0x251720,_0x180b3b=DataManager[_0x1ac3fd(0x22b)](this[_0x1ac3fd(0x342)]()),_0x58b11c=VisuMZ[_0x1ac3fd(0x5e7)][_0x180b3b];try{return _0x58b11c[_0x1ac3fd(0x413)][_0x1ac3fd(0xa57)](this,_0x5f0df1);}catch(_0xf02337){if($gameTemp[_0x1ac3fd(0x4a8)]())console[_0x1ac3fd(0x2d8)](_0xf02337);return VisuMZ['BattleCore'][_0x1ac3fd(0x83a)]['call'](this);}},Game_Action[_0x251720(0x97e)][_0x251720(0x73c)]=function(_0x1bd4d2,_0x4e34c4){const _0x11573b=_0x251720;if(this[_0x11573b(0x204)]())return _0x4e34c4;const _0x4f44b9=this[_0x11573b(0x271)](),_0x1e098f=_0x1bd4d2;let _0x2953b3=[],_0x57d1c5=[];_0x2953b3['push'](this[_0x11573b(0x687)]['arPenFlat'],this[_0x11573b(0x687)]['arRedFlat']),_0x57d1c5[_0x11573b(0x141)](this[_0x11573b(0x687)]['arPenRate'],this[_0x11573b(0x687)][_0x11573b(0x2a5)]);const _0x3784ba=this[_0x11573b(0x1f9)]()?/<ARMOR REDUCTION:[ ](\d+\.?\d*)>/i:/<MAGIC REDUCTION:[ ](\d+\.?\d*)>/i,_0x5e843d=this[_0x11573b(0x1f9)]()?/<ARMOR REDUCTION:[ ](\d+\.?\d*)([%％])>/i:/<MAGIC REDUCTION:[ ](\d+\.?\d*)([%％])>/i,_0x533616=this[_0x11573b(0x1f9)]()?/<ARMOR PENETRATION:[ ](\d+\.?\d*)>/i:/<MAGIC PENETRATION:[ ](\d+\.?\d*)>/i,_0x1402a1=this['isPhysical']()?/<ARMOR PENETRATION:[ ](\d+\.?\d*)([%％])>/i:/<MAGIC PENETRATION:[ ](\d+\.?\d*)([%％])>/i;return _0x2953b3=_0x2953b3[_0x11573b(0x86)](_0x1e098f[_0x11573b(0xabc)]()[_0x11573b(0x259)](_0x87ccca=>_0x87ccca&&_0x87ccca[_0x11573b(0x67f)][_0x11573b(0x591)](_0x3784ba)?Number(RegExp['$1']):0x0)),_0x57d1c5=_0x57d1c5['concat'](_0x1e098f['traitObjects']()[_0x11573b(0x259)](_0xfbc8d=>_0xfbc8d&&_0xfbc8d['note'][_0x11573b(0x591)](_0x5e843d)?Number(RegExp['$1'])/0x64:0x0)),_0x2953b3=_0x2953b3['concat'](_0x4f44b9[_0x11573b(0xabc)]()[_0x11573b(0x259)](_0x434386=>_0x434386&&_0x434386['note'][_0x11573b(0x591)](_0x533616)?Number(RegExp['$1']):0x0)),_0x57d1c5=_0x57d1c5[_0x11573b(0x86)](_0x4f44b9['traitObjects']()[_0x11573b(0x259)](_0xdd2e0f=>_0xdd2e0f&&_0xdd2e0f['note'][_0x11573b(0x591)](_0x1402a1)?Number(RegExp['$1'])/0x64:0x0)),this[_0x11573b(0x342)]()[_0x11573b(0x67f)][_0x11573b(0x591)](_0x533616)&&_0x2953b3[_0x11573b(0x141)](Number(RegExp['$1'])),this[_0x11573b(0x342)]()[_0x11573b(0x67f)]['match'](_0x1402a1)&&_0x57d1c5[_0x11573b(0x141)](Number(RegExp['$1'])),_0x4e34c4=_0x2953b3[_0x11573b(0x843)]((_0x1ba5ca,_0x2a644c)=>_0x1ba5ca-_0x2a644c,_0x4e34c4),_0x4e34c4>0x0&&(_0x4e34c4=_0x57d1c5[_0x11573b(0x843)]((_0x41e30f,_0xa4c80c)=>_0x41e30f*(0x1-_0xa4c80c),_0x4e34c4)),_0x4e34c4;},VisuMZ[_0x251720(0x731)][_0x251720(0x3f7)]=Game_Action[_0x251720(0x97e)][_0x251720(0x90d)],Game_Action[_0x251720(0x97e)][_0x251720(0x90d)]=function(_0x5b4f01,_0x33f2a5){const _0x3da70e=_0x251720;_0x33f2a5=_0x33f2a5*this['_multipliers'][_0x3da70e(0x3c1)],_0x33f2a5+=this['_multipliers'][_0x3da70e(0x1d5)]*(_0x33f2a5>=0x0?0x1:-0x1),_0x33f2a5=this['applyBattleCoreJS'](_0x3da70e(0x716),_0x5b4f01,_0x33f2a5,![]),_0x33f2a5=this['applyDamageCaps'](_0x33f2a5),_0x33f2a5=Math[_0x3da70e(0x3e4)](_0x33f2a5),this[_0x3da70e(0x781)]=_0x33f2a5,this['_totalValue']=this[_0x3da70e(0x6d1)]||0x0,this[_0x3da70e(0x6d1)]+=_0x33f2a5,VisuMZ[_0x3da70e(0x731)]['Game_Action_executeDamage'][_0x3da70e(0xa57)](this,_0x5b4f01,_0x33f2a5),this[_0x3da70e(0x931)](_0x3da70e(0x91),_0x5b4f01,_0x33f2a5,!![]);},Game_Action[_0x251720(0x97e)][_0x251720(0x4a5)]=function(_0x25692c){const _0x1fc599=_0x251720;if(this['isBypassDamageCap']())return _0x25692c;return _0x25692c=this['applySoftDamageCap'](_0x25692c),_0x25692c=this[_0x1fc599(0x2c4)](_0x25692c),_0x25692c;},Game_Action['prototype'][_0x251720(0x6a7)]=function(){const _0x1a7236=_0x251720,_0xccf63a=/<BYPASS DAMAGE CAP>/i;if(this[_0x1a7236(0x342)]()['note'][_0x1a7236(0x591)](_0xccf63a))return!![];if(this['subject']()['traitObjects']()[_0x1a7236(0x84)](_0x26cf39=>_0x26cf39&&_0x26cf39[_0x1a7236(0x67f)][_0x1a7236(0x591)](_0xccf63a)))return!![];return!VisuMZ[_0x1a7236(0x731)]['Settings'][_0x1a7236(0x2e1)][_0x1a7236(0x2d6)];},Game_Action[_0x251720(0x97e)][_0x251720(0x826)]=function(_0x5db8b4){const _0x4d25a9=_0x251720;if(!VisuMZ['BattleCore'][_0x4d25a9(0x825)]['Damage'][_0x4d25a9(0x1a0)])return _0x5db8b4;const _0x52af3f=/<BYPASS SOFT DAMAGE CAP>/i;if(this[_0x4d25a9(0x342)]()[_0x4d25a9(0x67f)][_0x4d25a9(0x591)](_0x52af3f))return!![];if(this[_0x4d25a9(0x271)]()[_0x4d25a9(0xabc)]()[_0x4d25a9(0x84)](_0x11b2e6=>_0x11b2e6&&_0x11b2e6[_0x4d25a9(0x67f)][_0x4d25a9(0x591)](_0x52af3f)))return!![];const _0x1b4452=_0x5db8b4<0x0?-0x1:0x1;_0x5db8b4=Math[_0x4d25a9(0x7a)](_0x5db8b4);let _0xe0bff2=this['subject']()[_0x4d25a9(0x8b0)]();this[_0x4d25a9(0x342)]()['note'][_0x4d25a9(0x591)](/<SOFT DAMAGE CAP:[ ]([\+\-]\d+)([%％])>/i)&&(_0xe0bff2+=Number(RegExp['$1'])/0x64);_0xe0bff2=_0xe0bff2['clamp'](0.01,0x1);const _0x296247=this[_0x4d25a9(0x5ca)](),_0x2c52a5=_0xe0bff2*_0x296247;if(_0x5db8b4>_0x2c52a5&&_0x296247>_0x2c52a5){_0x5db8b4-=_0x2c52a5;const _0x1c2ae8=VisuMZ[_0x4d25a9(0x731)][_0x4d25a9(0x825)][_0x4d25a9(0x2e1)][_0x4d25a9(0x2b8)],_0x5472d1=Math[_0x4d25a9(0x79a)](0x1-_0x5db8b4/((_0x296247-_0x2c52a5)*_0x1c2ae8+_0x5db8b4),0.01);_0x5db8b4*=_0x5472d1,_0x5db8b4+=_0x2c52a5;}return _0x5db8b4*_0x1b4452;},Game_Action[_0x251720(0x97e)][_0x251720(0x5ca)]=function(){const _0xe232c7=_0x251720;return this[_0xe232c7(0x342)]()[_0xe232c7(0x67f)][_0xe232c7(0x591)](/<DAMAGE CAP:[ ](\d+)>/i)?Number(RegExp['$1']):this[_0xe232c7(0x271)]()[_0xe232c7(0x706)]();},Game_Action[_0x251720(0x97e)][_0x251720(0x2c4)]=function(_0x3b1bf5){let _0x53614d=this['getHardDamageCap']();return _0x3b1bf5['clamp'](-_0x53614d,_0x53614d);},VisuMZ['BattleCore'][_0x251720(0x26e)]=Game_Action['prototype']['apply'],Game_Action[_0x251720(0x97e)]['apply']=function(_0x175305){const _0x3a3f75=_0x251720;this[_0x3a3f75(0x931)]('PreApply%1JS',_0x175305,0x0,!![]),VisuMZ[_0x3a3f75(0x731)]['Game_Action_apply'][_0x3a3f75(0xa57)](this,_0x175305),this[_0x3a3f75(0x931)](_0x3a3f75(0x305),_0x175305,this[_0x3a3f75(0x781)]||0x0,!![]),this['applyResultSwitches'](_0x175305);},Game_Action[_0x251720(0x97e)][_0x251720(0x931)]=function(_0x4a8942,_0x3dd172,_0x275556,_0x1212a0){const _0x2f6d6d=_0x251720;if(this['_tempBattler']||this[_0x2f6d6d(0x600)])return;_0x275556=_0x275556||0x0;const _0xb6e018=_0x275556,_0x3749b6=VisuMZ['BattleCore'][_0x2f6d6d(0x825)]['Mechanics'],_0x1d4858=_0x4a8942['format']('');if(_0x3749b6[_0x1d4858]){_0x275556=_0x3749b6[_0x1d4858]['call'](this,_0x275556,_0x3dd172);if(_0x1212a0)_0x275556=_0xb6e018;}let _0x1be79d=VisuMZ[_0x2f6d6d(0x731)][_0x2f6d6d(0x338)](this[_0x2f6d6d(0x342)](),_0x4a8942[_0x2f6d6d(0x8d6)](''));if(VisuMZ['BattleCore']['JS'][_0x1be79d]){_0x275556=VisuMZ['BattleCore']['JS'][_0x1be79d][_0x2f6d6d(0xa57)](this,this[_0x2f6d6d(0x271)](),_0x3dd172,this[_0x2f6d6d(0x342)](),_0x275556);if(_0x1212a0)_0x275556=_0xb6e018;}for(const _0x7c4b45 of this[_0x2f6d6d(0x271)]()[_0x2f6d6d(0xabc)]()){if(!_0x7c4b45)continue;_0x1be79d=VisuMZ['BattleCore'][_0x2f6d6d(0x338)](_0x7c4b45,_0x4a8942[_0x2f6d6d(0x8d6)](_0x2f6d6d(0x529)));if(VisuMZ['BattleCore']['JS'][_0x1be79d]){_0x275556=VisuMZ[_0x2f6d6d(0x731)]['JS'][_0x1be79d][_0x2f6d6d(0xa57)](this,this[_0x2f6d6d(0x271)](),_0x3dd172,_0x7c4b45,_0x275556);if(_0x1212a0)_0x275556=_0xb6e018;}}for(const _0x1bc2fd of _0x3dd172[_0x2f6d6d(0xabc)]()){if(_0x2f6d6d(0x631)!==_0x2f6d6d(0x631))return _0x1c3b89[_0x2f6d6d(0x731)][_0x2f6d6d(0x825)][_0x2f6d6d(0x8ca)][_0x2f6d6d(0x82a)];else{if(!_0x1bc2fd)continue;_0x1be79d=VisuMZ[_0x2f6d6d(0x731)][_0x2f6d6d(0x338)](_0x1bc2fd,_0x4a8942[_0x2f6d6d(0x8d6)]('AsTarget'));if(VisuMZ[_0x2f6d6d(0x731)]['JS'][_0x1be79d]){_0x275556=VisuMZ[_0x2f6d6d(0x731)]['JS'][_0x1be79d][_0x2f6d6d(0xa57)](this,this[_0x2f6d6d(0x271)](),_0x3dd172,_0x1bc2fd,_0x275556);if(_0x1212a0)_0x275556=_0xb6e018;}}}return _0x275556;},Game_Action[_0x251720(0x97e)]['actionBattleCoreJS']=function(_0xfba8bc){const _0x17003e=_0x251720,_0xb6ecaf=this['_totalValue']||0x0,_0x3acd00=VisuMZ['BattleCore']['Settings'][_0x17003e(0xa38)],_0x3c202d=_0xfba8bc[_0x17003e(0x8d6)]('');_0x3acd00[_0x3c202d]&&_0x3acd00[_0x3c202d][_0x17003e(0xa57)](this,_0xb6ecaf);let _0x522fcd=VisuMZ[_0x17003e(0x731)][_0x17003e(0x338)](this[_0x17003e(0x342)](),_0xfba8bc);VisuMZ[_0x17003e(0x731)]['JS'][_0x522fcd]&&VisuMZ[_0x17003e(0x731)]['JS'][_0x522fcd][_0x17003e(0xa57)](this,this[_0x17003e(0x271)](),this['subject'](),this[_0x17003e(0x342)](),_0xb6ecaf);for(const _0x492fca of this[_0x17003e(0x271)]()[_0x17003e(0xabc)]()){if(!_0x492fca)continue;_0x522fcd=VisuMZ[_0x17003e(0x731)]['createKeyJS'](_0x492fca,_0xfba8bc),VisuMZ[_0x17003e(0x731)]['JS'][_0x522fcd]&&VisuMZ[_0x17003e(0x731)]['JS'][_0x522fcd][_0x17003e(0xa57)](this,this[_0x17003e(0x271)](),this[_0x17003e(0x271)](),_0x492fca,_0xb6ecaf);}},Game_Action[_0x251720(0x97e)][_0x251720(0x2eb)]=function(){const _0x58dcc1=_0x251720;return VisuMZ[_0x58dcc1(0x731)]['Settings'][_0x58dcc1(0xa38)][_0x58dcc1(0x62b)][_0x58dcc1(0xa57)](this);},Game_Action[_0x251720(0x97e)][_0x251720(0x9e9)]=function(){const _0x4bdbef=_0x251720;return VisuMZ[_0x4bdbef(0x731)][_0x4bdbef(0x825)][_0x4bdbef(0xa38)]['AllowRandomSpeed'];},Game_Action[_0x251720(0x97e)][_0x251720(0xab3)]=function(){const _0x45abe6=_0x251720;return this[_0x45abe6(0x342)]()['note']['match'](/<JS TARGETS>/i);},Game_Action[_0x251720(0x97e)][_0x251720(0x2db)]=function(){const _0x3cf865=_0x251720;if(!this[_0x3cf865(0x56c)]&&this[_0x3cf865(0x271)]()[_0x3cf865(0x356)]())return![];if(this[_0x3cf865(0xab3)]())return!![];return typeof this[_0x3cf865(0x342)]()[_0x3cf865(0x6a1)]===_0x3cf865(0x4ca);},VisuMZ[_0x251720(0x731)][_0x251720(0x534)]=Game_Action[_0x251720(0x97e)][_0x251720(0x1b4)],Game_Action[_0x251720(0x97e)]['isForOpponent']=function(){const _0x54a794=_0x251720;if(this['isBattleCoreTargetScope']()&&!this['isCustomBattleScope']())return this[_0x54a794(0x346)]();else{if(_0x54a794(0x952)!=='WTAAs')return VisuMZ['BattleCore'][_0x54a794(0x534)][_0x54a794(0xa57)](this);else this['_forcedBattleLayout']=_0x54a794(0xa0f);}},Game_Action[_0x251720(0x97e)][_0x251720(0x346)]=function(){const _0x5b6ac8=_0x251720,_0x156e6b=this[_0x5b6ac8(0x342)]()[_0x5b6ac8(0x6a1)];return _0x156e6b[_0x5b6ac8(0x591)](/(?:ENEMY|ENEMIES|FOE|FOES)/i);},VisuMZ[_0x251720(0x731)]['Game_Action_isForFriend']=Game_Action[_0x251720(0x97e)][_0x251720(0xa50)],Game_Action['prototype'][_0x251720(0xa50)]=function(){const _0x2634f0=_0x251720;return this['isBattleCoreTargetScope']()&&!this[_0x2634f0(0xab3)]()?this[_0x2634f0(0x82)]():_0x2634f0(0xb3)==='HHTHs'?VisuMZ[_0x2634f0(0x731)]['Game_Action_isForFriend'][_0x2634f0(0xa57)](this):this[_0x2634f0(0x923)];},Game_Action[_0x251720(0x97e)][_0x251720(0x82)]=function(){const _0x4881e7=_0x251720,_0x8d8a9f=this[_0x4881e7(0x342)]()[_0x4881e7(0x6a1)];return _0x8d8a9f[_0x4881e7(0x591)](/(?:ALLY|ALLIES|FRIEND|FRIENDS)/i);},VisuMZ[_0x251720(0x731)][_0x251720(0x36c)]=Game_Action[_0x251720(0x97e)]['isForRandom'],Game_Action['prototype'][_0x251720(0x7de)]=function(){const _0x467e50=_0x251720;if(this['isBattleCoreTargetScope']()&&!this['isCustomBattleScope']()){if(_0x467e50(0xee)!==_0x467e50(0xa3b))return this[_0x467e50(0x97c)]();else _0x3f1b85+=_0x573296[_0x467e50(0x4f2)]()?-_0x2c6dc9:_0x1c2a0e,_0x3ebf1b+=_0x226b2c;}else return'ZbaFG'===_0x467e50(0xa43)?this['battlerSprites']()[_0x467e50(0x84)](_0x1f5342=>_0x1f5342[_0x467e50(0x4e6)]()):VisuMZ[_0x467e50(0x731)][_0x467e50(0x36c)][_0x467e50(0xa57)](this);},Game_Action[_0x251720(0x97e)][_0x251720(0x97c)]=function(){const _0x10252a=_0x251720,_0x2534c2=this[_0x10252a(0x342)]()[_0x10252a(0x6a1)];return _0x2534c2[_0x10252a(0x591)](/(?:RAND|RANDOM)/i);},VisuMZ[_0x251720(0x731)]['Game_Action_needsSelection']=Game_Action[_0x251720(0x97e)][_0x251720(0x434)],Game_Action[_0x251720(0x97e)][_0x251720(0x434)]=function(){const _0x2835df=_0x251720;if(this[_0x2835df(0x2db)]()&&!this['isCustomBattleScope']()){if(_0x2835df(0x24e)===_0x2835df(0xa16))this['opacity']-=0x10;else return this[_0x2835df(0x54b)]();}else return VisuMZ[_0x2835df(0x731)][_0x2835df(0xb9)][_0x2835df(0xa57)](this);},Game_Action[_0x251720(0x97e)]['needsSelectionBattleCore']=function(){const _0x5ae540=_0x251720,_0x384ca9=this['item']()['scope'];if(_0x384ca9[_0x5ae540(0x591)](/RANDOM/i))return![];if(_0x384ca9['match'](/ALL (?:ALLY|ALLIES|FRIEND|FRIENDS)/i))return![];if(_0x384ca9[_0x5ae540(0x591)](/ALL (?:ENEMY|ENEMIES|FOE|FOES)/i))return![];return VisuMZ['BattleCore']['Game_Action_needsSelection'][_0x5ae540(0xa57)](this);},VisuMZ[_0x251720(0x731)][_0x251720(0x310)]=Game_Action[_0x251720(0x97e)][_0x251720(0x422)],Game_Action['prototype']['makeTargets']=function(){const _0x3f818d=_0x251720;let _0x5d9641=[];return this[_0x3f818d(0x2db)]()?_0x3f818d(0x744)==='fFads'?_0x5d9641=this[_0x3f818d(0x9cb)]():this[_0x3f818d(0x3a1)]=_0x5a5876[_0x3f818d(0x9de)]:_0x5d9641=VisuMZ[_0x3f818d(0x731)][_0x3f818d(0x310)][_0x3f818d(0xa57)](this),_0x5d9641=this[_0x3f818d(0x5a3)](_0x5d9641),_0x5d9641;},Game_Action[_0x251720(0x97e)][_0x251720(0x9cb)]=function(){const _0x516ec1=_0x251720;let _0x34d664=[];const _0x3ec86e=String(this[_0x516ec1(0x342)]()[_0x516ec1(0x6a1)]),_0x47b7d6=VisuMZ[_0x516ec1(0x731)][_0x516ec1(0x338)](this[_0x516ec1(0x342)](),_0x516ec1(0x179));if(VisuMZ[_0x516ec1(0x731)]['JS'][_0x47b7d6]){_0x34d664=VisuMZ[_0x516ec1(0x731)][_0x516ec1(0x310)][_0x516ec1(0xa57)](this);const _0x4b4f06=VisuMZ[_0x516ec1(0x731)][_0x516ec1(0x338)](this[_0x516ec1(0x342)](),_0x516ec1(0x179));return _0x34d664=VisuMZ[_0x516ec1(0x731)]['JS'][_0x4b4f06][_0x516ec1(0xa57)](this,this[_0x516ec1(0x271)](),_0x34d664),this[_0x516ec1(0x84d)](_0x34d664);}if(_0x3ec86e[_0x516ec1(0x591)](/(\d+) RANDOM ANY/i)){let _0x41a697=Number(RegExp['$1']);while(_0x41a697--){if('BSSSd'==='bXmYp')_0x2f286e?this[_0x516ec1(0x695)]():this[_0x516ec1(0x2c7)]();else{const _0x110935=Math[_0x516ec1(0x9b7)](0x2)===0x0?this[_0x516ec1(0x7f5)]():this[_0x516ec1(0x366)]();_0x34d664['push'](_0x110935['trueRandomTarget']());}}return this[_0x516ec1(0x84d)](_0x34d664);}if(_0x3ec86e[_0x516ec1(0x591)](/(\d+) RANDOM (?:ENEMY|ENEMIES|FOE|FOES)/i)){let _0x247663=Number(RegExp['$1']);while(_0x247663--){_0x34d664[_0x516ec1(0x141)](this['opponentsUnit']()[_0x516ec1(0x50d)]());}return this[_0x516ec1(0x84d)](_0x34d664);}if(_0x3ec86e['match'](/(\d+) RANDOM (?:ALLY|ALLIES|FRIEND|FRIENDS)/i)){let _0x1539cf=Number(RegExp['$1']);while(_0x1539cf--){_0x34d664[_0x516ec1(0x141)](this[_0x516ec1(0x366)]()[_0x516ec1(0x50d)]());}return this[_0x516ec1(0x84d)](_0x34d664);}if(_0x3ec86e['match'](/ALL (?:ALLY|ALLIES|FRIEND|FRIENDS) (?:BUT|EXCEPT) (?:USER|SELF)/i)){if(_0x516ec1(0x613)!=='IeYqp'){if(!_0x4ea493['isSceneBattle']())return;if(!_0x276126[_0x516ec1(0x243)])return;_0x5b742f[_0x516ec1(0xa0c)](_0x54b961,_0x88a09f);const _0x4cedff=_0x548508['getLastPluginCommandInterpreter'](),_0x40d05d=_0x9f89a6[_0x516ec1(0x9b2)];if(!_0x4cedff)return;_0x5092d7[_0x516ec1(0x4b2)](0x0,0x0,_0x9b9a3c[_0x516ec1(0x19f)],_0x26ae46[_0x516ec1(0xc3)]);if(_0x40d05d)_0x4cedff[_0x516ec1(0x1a1)](_0x516ec1(0xeb));}else return _0x34d664[_0x516ec1(0x141)](...this[_0x516ec1(0x366)]()['aliveMembers']()[_0x516ec1(0x778)](_0x1e918a=>_0x1e918a!==this[_0x516ec1(0x271)]())),this['repeatTargets'](_0x34d664);}return VisuMZ[_0x516ec1(0x731)][_0x516ec1(0x310)][_0x516ec1(0xa57)](this);},Game_Action['prototype'][_0x251720(0x318)]=function(_0x1b7e88){const _0x4892b0=_0x251720,_0x34bdc5=[];for(let _0x5c1040=0x0;_0x5c1040<this[_0x4892b0(0x4d1)]();_0x5c1040++){if('GqGnd'!==_0x4892b0(0x267)){const _0x1450f4=_0x42f25d[_0x4892b0(0x3fe)]();_0x1450f4<=0x0?_0x377709[_0x4892b0(0x222)]():this['showNormalAnimation'](_0x5c0c83,_0x1450f4);}else _0x34bdc5[_0x4892b0(0x141)](_0x1b7e88[_0x4892b0(0x50d)]());}return _0x34bdc5;},Game_Action[_0x251720(0x97e)][_0x251720(0x5a3)]=function(_0x5913d1){const _0x45e128=_0x251720;if(!this['item']())return _0x5913d1;const _0x28a1e6=this[_0x45e128(0x342)]()[_0x45e128(0x67f)];return _0x28a1e6[_0x45e128(0x591)](/(?:BUT|EXCEPT) (?:USER|SELF)/i)&&_0x5913d1[_0x45e128(0x39c)](this[_0x45e128(0x271)]()),_0x5913d1;},VisuMZ['BattleCore']['Game_Action_itemEffectAddAttackState']=Game_Action[_0x251720(0x97e)]['itemEffectAddAttackState'],Game_Action[_0x251720(0x97e)][_0x251720(0x117)]=function(_0x2363c6,_0xaa4d99){const _0x540e0a=_0x251720;VisuMZ[_0x540e0a(0x731)][_0x540e0a(0x58c)][_0x540e0a(0xa57)](this,_0x2363c6,_0xaa4d99);if(!_0x2363c6[_0x540e0a(0x9e5)]())return;for(const _0x323de0 of this['subject']()[_0x540e0a(0x35c)]()){if(_0x323de0===_0x2363c6[_0x540e0a(0x1b1)]()){let _0x27d77e=_0xaa4d99[_0x540e0a(0x884)];_0x27d77e*=_0x2363c6[_0x540e0a(0x982)](_0x323de0),_0x27d77e*=this[_0x540e0a(0x271)]()[_0x540e0a(0x3cb)](_0x323de0),_0x27d77e*=this['lukEffectRate'](_0x2363c6),Math[_0x540e0a(0x298)]()<_0x27d77e&&(_0x2363c6[_0x540e0a(0x4d4)]=!![],this[_0x540e0a(0x60c)](_0x2363c6));}}},VisuMZ[_0x251720(0x731)][_0x251720(0x6e4)]=Game_Action[_0x251720(0x97e)][_0x251720(0xab0)],Game_Action['prototype']['itemEffectAddNormalState']=function(_0x3a09c0,_0xdadf4b){const _0x87eef5=_0x251720;VisuMZ[_0x87eef5(0x731)][_0x87eef5(0x6e4)][_0x87eef5(0xa57)](this,_0x3a09c0,_0xdadf4b);if(!_0x3a09c0['isImmortal']())return;if(_0xdadf4b[_0x87eef5(0x2b6)]!==_0x3a09c0[_0x87eef5(0x1b1)]())return;let _0x5db805=_0xdadf4b[_0x87eef5(0x884)];!this[_0x87eef5(0x204)]()&&(_0x5db805*=_0x3a09c0[_0x87eef5(0x982)](_0xdadf4b[_0x87eef5(0x2b6)]),_0x5db805*=this[_0x87eef5(0x190)](_0x3a09c0));if(Math['random']()<_0x5db805){if(_0x87eef5(0x85d)!==_0x87eef5(0x85d)){if(!this[_0x87eef5(0x397)]['isSpriteVisible']())return;const _0x2adbc2=_0x4d5797[_0x87eef5(0x731)][_0x87eef5(0x825)]['Damage'],_0x4c1432=new _0x5cfcc4();_0x4c1432[_0x87eef5(0x38d)]=_0x2adbc2[_0x87eef5(0xabb)],this[_0x87eef5(0xa65)](_0x4c1432),_0x4c1432[_0x87eef5(0x33c)](_0x4d7156,_0x300c6a),this[_0x87eef5(0x1bf)](_0x4c1432);}else _0x3a09c0['_deathStateApplied']=!![],this[_0x87eef5(0x60c)](_0x3a09c0);}},VisuMZ['BattleCore'][_0x251720(0x965)]=Game_Action[_0x251720(0x97e)][_0x251720(0x869)],Game_Action['prototype'][_0x251720(0x869)]=function(){const _0x408393=_0x251720;VisuMZ['BattleCore'][_0x408393(0x965)][_0x408393(0xa57)](this),this[_0x408393(0x5ae)](),this[_0x408393(0x520)]();},Game_Action['prototype'][_0x251720(0x5ae)]=function(){const _0xd8ec35=_0x251720;if(!SceneManager[_0xd8ec35(0x847)]())return;const _0x2a1b23=/<COMMON (?:EVENT|EVENTS):[ ](.*)>/gi,_0x4edb38=this[_0xd8ec35(0x342)]()['note'][_0xd8ec35(0x591)](_0x2a1b23);if(_0x4edb38)for(const _0x42873f of _0x4edb38){if(!_0x42873f)continue;_0x42873f[_0xd8ec35(0x591)](_0x2a1b23);const _0x3297a9=String(RegExp['$1'])[_0xd8ec35(0xa45)](',')[_0xd8ec35(0x259)](_0x11590e=>String(_0x11590e)['trim']()),_0x43b20c=_0x3297a9['map'](_0x46941d=>DataManager[_0xd8ec35(0x696)](_0x46941d));for(const _0x33c1ab of _0x43b20c){const _0xcf66c2=$dataCommonEvents[_0x33c1ab];_0xcf66c2&&$gameTemp[_0xd8ec35(0x7e)](_0x33c1ab);}}},DataManager[_0x251720(0x696)]=function(_0x5e0b65){const _0x161cf7=_0x251720;_0x5e0b65=_0x5e0b65['toUpperCase']()[_0x161cf7(0x30b)](),this[_0x161cf7(0x69e)]=this['_commonEventIDs']||{};if(this[_0x161cf7(0x69e)][_0x5e0b65])return this[_0x161cf7(0x69e)][_0x5e0b65];for(const _0x3fe229 of $dataCommonEvents){if(!_0x3fe229)continue;let _0x3a50b8=_0x3fe229['name'];_0x3a50b8=_0x3a50b8[_0x161cf7(0x105)](/\x1I\[(\d+)\]/gi,''),_0x3a50b8=_0x3a50b8[_0x161cf7(0x105)](/\\I\[(\d+)\]/gi,''),this['_commonEventIDs'][_0x3a50b8[_0x161cf7(0x62a)]()[_0x161cf7(0x30b)]()]=_0x3fe229['id'];}return this['_commonEventIDs'][_0x5e0b65]||0x0;},Game_Action[_0x251720(0x97e)][_0x251720(0x520)]=function(){const _0x146f57=_0x251720;if(!SceneManager['isSceneBattle']())return;const _0x54c1d4=VisuMZ[_0x146f57(0x731)][_0x146f57(0x825)][_0x146f57(0xa38)];_0x54c1d4[_0x146f57(0x66d)]&&$gameSwitches[_0x146f57(0x667)](_0x54c1d4[_0x146f57(0x66d)],![]);if(_0x54c1d4['SwitchMissEvade']){if(_0x146f57(0x7b3)===_0x146f57(0x9e7)){if(!_0x2bcfdf[_0x146f57(0x847)]())return;if(!_0x269f62[_0x146f57(0xaa7)])return;if(!_0x5e08bd[_0x146f57(0x7e1)]())return;_0x2029db[_0x146f57(0xa0c)](_0x336a60,_0x1912d2);const _0x3f36bb=_0x573d49['ActionCount'];_0x2648ab[_0x146f57(0x29b)]&&_0x308af2[_0x146f57(0x29b)]['friendsUnit']()['gainCurrentActionsETB'](_0x3f36bb);}else $gameSwitches['setValue'](_0x54c1d4[_0x146f57(0x823)],![]);}_0x54c1d4['VariableDmg']&&$gameVariables[_0x146f57(0x667)](_0x54c1d4[_0x146f57(0x1a2)],0x0),_0x54c1d4['VariableHeal']&&$gameVariables[_0x146f57(0x667)](_0x54c1d4[_0x146f57(0xab2)],0x0);},Game_Action[_0x251720(0x97e)]['applyResultSwitches']=function(_0x46425d){const _0x3ad18c=_0x251720;if(!SceneManager[_0x3ad18c(0x847)]())return;if(!_0x46425d)return;const _0x512578=_0x46425d[_0x3ad18c(0x772)](),_0x3c9e81=VisuMZ[_0x3ad18c(0x731)][_0x3ad18c(0x825)][_0x3ad18c(0xa38)];_0x3c9e81[_0x3ad18c(0x66d)]&&_0x512578[_0x3ad18c(0x8f5)]&&$gameSwitches[_0x3ad18c(0x667)](_0x3c9e81[_0x3ad18c(0x66d)],!![]);if(_0x3c9e81[_0x3ad18c(0x823)]&&(_0x512578[_0x3ad18c(0x1c1)]||_0x512578[_0x3ad18c(0x5a6)])){if('LIMlH'===_0x3ad18c(0xa5d)){const _0x43a9d3=_0x5dd59d[_0x3ad18c(0x30d)]();if(_0x43a9d3&&_0x43a9d3[_0x3ad18c(0x60a)])_0x43a9d3[_0x3ad18c(0x60a)]()[_0x3ad18c(0x6df)]();_0x33e831[_0x3ad18c(0x731)][_0x3ad18c(0x55e)][_0x3ad18c(0xa57)](this);}else $gameSwitches[_0x3ad18c(0x667)](_0x3c9e81[_0x3ad18c(0x823)],!![]);}if(_0x3c9e81[_0x3ad18c(0x1a2)]){if(_0x3ad18c(0x3e2)!==_0x3ad18c(0x45d)){let _0x270eea=$gameVariables[_0x3ad18c(0x951)](_0x3c9e81[_0x3ad18c(0x1a2)]);_0x512578[_0x3ad18c(0x427)]>0x0&&(_0x270eea+=Math[_0x3ad18c(0x7a)](_0x512578[_0x3ad18c(0x427)])),$gameVariables[_0x3ad18c(0x667)](_0x3c9e81[_0x3ad18c(0x1a2)],_0x270eea);}else _0x3c045e['motionIdle']=_0x8f99b0(_0x3d3f7b['$1'])[_0x3ad18c(0x612)]()[_0x3ad18c(0x30b)]();}if(_0x3c9e81[_0x3ad18c(0xab2)]){if(_0x3ad18c(0x2e3)==='zcKnk'){let _0x82e45=$gameVariables['value'](_0x3c9e81[_0x3ad18c(0xab2)]);_0x512578[_0x3ad18c(0x427)]<0x0&&(_0x3ad18c(0x51e)===_0x3ad18c(0x575)?_0x5b9fe4[_0x3ad18c(0x27a)](0x0,0x0,_0x233823[_0x3ad18c(0x19f)],_0x3f8a58[_0x3ad18c(0xc3)]):_0x82e45+=Math[_0x3ad18c(0x7a)](_0x512578[_0x3ad18c(0x427)])),$gameVariables['setValue'](_0x3c9e81['VariableHeal'],_0x82e45);}else this[_0x3ad18c(0x141)](_0x3ad18c(0x622),[_0x5c9e58],_0x3e6907,_0x1920c7),this[_0x3ad18c(0x141)]('performMoveToTargets',_0x3c02d8,_0x20e79f,_0x3ad18c(0x833),_0x392aed,!![],'Linear',!![]),this[_0x3ad18c(0x141)](_0x3ad18c(0x995),[_0x4c34fe],_0x3ad18c(0x8bb)),this[_0x3ad18c(0x141)]('waitForMovement');}},VisuMZ[_0x251720(0x731)][_0x251720(0x69c)]=Game_BattlerBase['prototype']['initMembers'],Game_BattlerBase[_0x251720(0x97e)][_0x251720(0x147)]=function(){const _0x3bdb2f=_0x251720;VisuMZ[_0x3bdb2f(0x731)]['Game_BattlerBase_initMembers'][_0x3bdb2f(0xa57)](this),this[_0x3bdb2f(0x158)]();},Game_BattlerBase[_0x251720(0x97e)]['initMembersBattleCore']=function(){const _0x2c104a=_0x251720;this[_0x2c104a(0x8b1)]=![];},VisuMZ['BattleCore']['Game_BattlerBase_refresh']=Game_BattlerBase[_0x251720(0x97e)][_0x251720(0x841)],Game_BattlerBase[_0x251720(0x97e)][_0x251720(0x841)]=function(){const _0x258759=_0x251720;this[_0x258759(0x4d7)]={},VisuMZ['BattleCore']['Game_BattlerBase_refresh'][_0x258759(0xa57)](this);},Game_BattlerBase[_0x251720(0x97e)][_0x251720(0x947)]=function(_0x5e00ec){const _0x255c5d=_0x251720;return this[_0x255c5d(0x4d7)]=this['_cache']||{},this['_cache'][_0x5e00ec]!==undefined;},Game_BattlerBase[_0x251720(0x97e)][_0x251720(0x706)]=function(){const _0x49c6ec=_0x251720;if(this[_0x49c6ec(0x4d7)][_0x49c6ec(0x706)]!==undefined)return this[_0x49c6ec(0x4d7)][_0x49c6ec(0x706)];const _0x5b5096=/<DAMAGE CAP:[ ](\d+)>/i,_0x546a6a=this[_0x49c6ec(0xabc)]()[_0x49c6ec(0x259)](_0x45d4ff=>_0x45d4ff&&_0x45d4ff[_0x49c6ec(0x67f)][_0x49c6ec(0x591)](_0x5b5096)?Number(RegExp['$1']):0x0);let _0x87f2e0=_0x546a6a[_0x49c6ec(0x988)]>0x0?Math['max'](..._0x546a6a):0x0;if(_0x87f2e0<=0x0)_0x87f2e0=VisuMZ[_0x49c6ec(0x731)][_0x49c6ec(0x825)]['Damage'][_0x49c6ec(0x5fd)];return this['_cache']['hardDamageCap']=_0x87f2e0,this[_0x49c6ec(0x4d7)][_0x49c6ec(0x706)];},Game_BattlerBase[_0x251720(0x97e)][_0x251720(0x8b0)]=function(){const _0x51ff9f=_0x251720;if(this['_cache'][_0x51ff9f(0x596)]!==undefined)return this[_0x51ff9f(0x4d7)][_0x51ff9f(0x596)];let _0x385f46=VisuMZ[_0x51ff9f(0x731)][_0x51ff9f(0x825)][_0x51ff9f(0x2e1)][_0x51ff9f(0x8ed)];const _0x39d9a1=/<SOFT DAMAGE CAP:[ ]([\+\-]\d+)([%％])>/i,_0x2c14d8=this[_0x51ff9f(0xabc)]()[_0x51ff9f(0x259)](_0x5ed8f3=>_0x5ed8f3&&_0x5ed8f3[_0x51ff9f(0x67f)][_0x51ff9f(0x591)](_0x39d9a1)?Number(RegExp['$1'])/0x64:0x0);return _0x385f46=_0x2c14d8['reduce']((_0x569cc3,_0xf9db6d)=>_0x569cc3+_0xf9db6d,_0x385f46),this[_0x51ff9f(0x4d7)]['softDamageCap']=_0x385f46,this[_0x51ff9f(0x4d7)]['softDamageCap'][_0x51ff9f(0x6d)](0.01,0x1);},VisuMZ[_0x251720(0x731)][_0x251720(0x5b8)]=Game_BattlerBase['prototype']['die'],Game_BattlerBase[_0x251720(0x97e)][_0x251720(0xa9a)]=function(){const _0xc41046=_0x251720;VisuMZ[_0xc41046(0x731)][_0xc41046(0x5b8)][_0xc41046(0xa57)](this),SceneManager['isSceneBattle']()&&this[_0xc41046(0x995)](_0xc41046(0x437));},Game_BattlerBase[_0x251720(0x97e)][_0x251720(0x60a)]=function(){const _0x25a692=_0x251720;if(!SceneManager[_0x25a692(0x847)]())return null;if(!SceneManager['_scene'][_0x25a692(0x742)])return null;return SceneManager[_0x25a692(0x35b)]['_spriteset'][_0x25a692(0x3b0)](this);},Game_BattlerBase['prototype'][_0x251720(0x516)]=function(){const _0x3ebe31=_0x251720;return VisuMZ[_0x3ebe31(0x731)][_0x3ebe31(0x825)][_0x3ebe31(0x98)][_0x3ebe31(0x93c)];},Game_BattlerBase[_0x251720(0x97e)]['svBattlerAnchorY']=function(){const _0x12e373=_0x251720;return VisuMZ[_0x12e373(0x731)][_0x12e373(0x825)][_0x12e373(0x98)][_0x12e373(0x261)];},Game_BattlerBase[_0x251720(0x97e)]['svBattlerShadowVisible']=function(){const _0x5a523b=_0x251720;return this['isActor']&&this['isActor']()?VisuMZ[_0x5a523b(0x731)][_0x5a523b(0x825)][_0x5a523b(0x98)]['Shadow']:VisuMZ[_0x5a523b(0x731)][_0x5a523b(0x825)][_0x5a523b(0x3b1)]['Shadow'];},Game_BattlerBase['prototype']['battlerSmoothImage']=function(){return!![];},Game_BattlerBase[_0x251720(0x97e)][_0x251720(0x9a9)]=function(){return 0x0;},Game_BattlerBase[_0x251720(0x97e)][_0x251720(0x36e)]=function(){return 0x0;},Game_BattlerBase[_0x251720(0x97e)]['createBattleUIOffsetX']=function(_0x4e724d){const _0x33cc66=_0x251720;if(!_0x4e724d)return 0x0;let _0xcc4b54=0x0;const _0x321de1=_0x4e724d[_0x33cc66(0x67f)];if(_0x321de1[_0x33cc66(0x591)](/<BATTLE UI OFFSET X:[ ]([\+\-]\d+)>/i)){if(_0x33cc66(0x9ad)!==_0x33cc66(0x96a))_0xcc4b54+=Number(RegExp['$1']);else return this[_0x33cc66(0x838)](_0x3d9850);}if(_0x321de1['match'](/<BATTLE UI OFFSET:[ ]([\+\-]\d+),[ ]([\+\-]\d+)>/i)){if('fkxUD'!==_0x33cc66(0x561))_0xcc4b54+=Number(RegExp['$1']);else{const _0xcf458=_0x3746b6[_0x33cc66(0x731)][_0x33cc66(0x825)][_0x33cc66(0xa38)],_0x4fc6dc=_0xcf458[_0x33cc66(0x94f)];_0x4fc6dc&&_0xd06ce0['BattleCore'][_0x33cc66(0x369)](_0x4fc6dc)&&(this[_0x33cc66(0xa73)]=!![],_0x1edfeb[_0x33cc66(0x7e)](_0xcf458['BattleStartEvent']),_0x21ee82[_0x33cc66(0x8e3)](),_0x2928a7[_0x33cc66(0x1ab)][_0x33cc66(0xf8)]=!![]),_0xcf458['DefeatEvent']>0x0&&(this[_0x33cc66(0x1fb)]=!![]);}}return _0xcc4b54;},Game_BattlerBase[_0x251720(0x97e)][_0x251720(0x4a3)]=function(_0x4beb1f){const _0x47203e=_0x251720;if(!_0x4beb1f)return 0x0;let _0x2c9a30=0x0;const _0x1fc48a=_0x4beb1f['note'];return _0x1fc48a[_0x47203e(0x591)](/<BATTLE UI OFFSET Y:[ ]([\+\-]\d+)>/i)&&(_0x2c9a30+=Number(RegExp['$1'])),_0x1fc48a['match'](/<BATTLE UI OFFSET:[ ]([\+\-]\d+),[ ]([\+\-]\d+)>/i)&&(_0x2c9a30+=Number(RegExp['$2'])),_0x2c9a30;},VisuMZ[_0x251720(0x731)][_0x251720(0x7f8)]=Game_BattlerBase[_0x251720(0x97e)]['isStateResist'],Game_BattlerBase['prototype']['isStateResist']=function(_0x37759c){const _0xac6808=_0x251720;if(_0x37759c===this[_0xac6808(0x1b1)]()&&this[_0xac6808(0x9e5)]()){if(_0xac6808(0x8a7)==='vCQCR'){let _0x1fb3d1=_0x56ba7f[_0xac6808(0x731)]['Sprite_Battler_damageOffsetX'][_0xac6808(0xa57)](this),_0x221174=_0x525742[_0xac6808(0x731)][_0xac6808(0x825)][_0xac6808(0x2e1)][_0xac6808(0x5da)]||0x0;return _0x53be66['round'](_0x1fb3d1+_0x221174);}else return!![];}return VisuMZ[_0xac6808(0x731)][_0xac6808(0x7f8)][_0xac6808(0xa57)](this,_0x37759c);},Game_BattlerBase[_0x251720(0x97e)][_0x251720(0x9e5)]=function(){return this['_immortal'];},Game_BattlerBase['prototype']['setImmortal']=function(_0x2305f5){const _0x314e4f=_0x251720;if(_0x2305f5)this[_0x314e4f(0x695)]();else{if(_0x314e4f(0x46b)===_0x314e4f(0x46b))this[_0x314e4f(0x2c7)]();else{const _0x3088c2=_0x259d6b['x']+_0x4d5bc4['floor']((_0x54ce44['width']-_0x3fd0d7)/0x2);this[_0x314e4f(0x314)](_0x51f0a4,_0x3088c2,_0x4fd5d2['y'],_0x2b8ad4);}}},Game_BattlerBase[_0x251720(0x97e)][_0x251720(0x695)]=function(){const _0x1a8ba7=_0x251720;if(this['isDead']())return;this[_0x1a8ba7(0x8b1)]=!![],this[_0x1a8ba7(0x4d4)]=![];},Game_BattlerBase['prototype'][_0x251720(0x2c7)]=function(){const _0x40fed6=_0x251720,_0x1627b6=this[_0x40fed6(0x2ce)]();this[_0x40fed6(0x8b1)]=![],_0x1627b6&&this[_0x40fed6(0x4d4)]&&this['die'](),this['_deathStateApplied']=![],this[_0x40fed6(0x841)](),this[_0x40fed6(0x864)]()&&_0x1627b6&&('xQAhz'===_0x40fed6(0x323)?this[_0x40fed6(0x43e)](...arguments):(this['performCollapse'](),this[_0x40fed6(0x711)]()));},VisuMZ['BattleCore']['Game_BattlerBase_canAttack']=Game_BattlerBase[_0x251720(0x97e)][_0x251720(0x1fd)],Game_BattlerBase[_0x251720(0x97e)][_0x251720(0x1fd)]=function(){const _0x533a61=_0x251720;if(!this['canAttackBattleCore']())return![];return VisuMZ[_0x533a61(0x731)][_0x533a61(0x5a9)][_0x533a61(0xa57)](this);},Game_BattlerBase[_0x251720(0x97e)][_0x251720(0xc1)]=function(){const _0x368a7f=_0x251720;for(const _0x21366b of this['traitObjects']()){if(!_0x21366b)continue;if(_0x21366b['note'][_0x368a7f(0x591)](/<(?:ATTACK SEAL|SEAL ATTACK)>/i))return![];}return!![];},VisuMZ[_0x251720(0x731)][_0x251720(0x677)]=Game_BattlerBase[_0x251720(0x97e)][_0x251720(0x66c)],Game_BattlerBase[_0x251720(0x97e)][_0x251720(0x66c)]=function(){const _0x230991=_0x251720;if(!this['canGuardBattleCore']())return![];return VisuMZ[_0x230991(0x731)][_0x230991(0x677)][_0x230991(0xa57)](this);},Game_BattlerBase[_0x251720(0x97e)]['canGuardBattleCore']=function(){const _0x2124e9=_0x251720;for(const _0x44a7e5 of this['traitObjects']()){if(!_0x44a7e5)continue;if(_0x44a7e5[_0x2124e9(0x67f)][_0x2124e9(0x591)](/<(?:GUARD SEAL|SEAL GUARD)>/i))return![];}return!![];},Game_BattlerBase[_0x251720(0x97e)][_0x251720(0x4fd)]=function(){const _0x518ed0=_0x251720;for(const _0x494736 of this[_0x518ed0(0xabc)]()){if(_0x518ed0(0x2bf)!==_0x518ed0(0x2bf))this[_0x518ed0(0x866)]['_reflectionTarget']=_0x1ab5e0,this[_0x518ed0(0x1cb)][_0x518ed0(0x9a7)](_0x5de168),this[_0x518ed0(0x1cb)][_0x518ed0(0x1c0)](_0x58d4e0,this[_0x518ed0(0x866)]),this[_0x518ed0(0x866)][_0x518ed0(0x1d9)](_0x4d929f),this[_0x518ed0(0x1cb)][_0x518ed0(0x9d)](_0x33275b,_0x41b8d4);else{if(!_0x494736)continue;if(_0x494736['note']['match'](/<(?:ITEM SEAL|SEAL ITEM|SEAL ITEMS)>/i))return![];}}return!![];},Game_Battler[_0x251720(0x97e)][_0x251720(0x9e9)]=function(){const _0x37da96=_0x251720;return VisuMZ[_0x37da96(0x731)][_0x37da96(0x825)]['Mechanics'][_0x37da96(0x88a)];},VisuMZ['BattleCore'][_0x251720(0x78c)]=Game_Battler['prototype'][_0x251720(0x1d7)],Game_Battler[_0x251720(0x97e)]['regenerateAll']=function(){const _0x513314=_0x251720;if(SceneManager[_0x513314(0x847)]()&&$gameTroop['turnCount']()<=0x0)return;if(SceneManager['isSceneBattle']()&&BattleManager[_0x513314(0xb2)]()&&this[_0x513314(0x74a)]===Graphics[_0x513314(0x74d)]){if('CXGlM'===_0x513314(0x535))return;else{if(this[_0x513314(0x864)]()&&this[_0x513314(0x86f)]())return![];}}this[_0x513314(0x74a)]=Graphics[_0x513314(0x74d)],this['processBattleCoreJS']('PreRegenerateJS'),VisuMZ['BattleCore'][_0x513314(0x78c)][_0x513314(0xa57)](this),this[_0x513314(0x829)](),this[_0x513314(0xa55)]('PostRegenerateJS');},Game_Battler['prototype'][_0x251720(0x829)]=function(){const _0x4df183=_0x251720;if(SceneManager['isSceneBattle']())for(const _0x1620a2 of this[_0x4df183(0xabc)]()){if(!_0x1620a2)continue;this[_0x4df183(0x1f6)](_0x1620a2);}},Game_Battler[_0x251720(0x97e)]['onRegeneratePlayStateAnimation']=function(_0x5468ca){const _0x392216=_0x251720;if(!Imported[_0x392216(0x7a8)])return;if(!SceneManager[_0x392216(0x847)]())return;if(this[_0x392216(0x864)]())return;if(this[_0x392216(0x945)]())return;if(_0x5468ca[_0x392216(0x67f)][_0x392216(0x591)](/<(?:REGENERATE|REGEN|DEGEN|DOT|SLIP)[ ]ANIMATION:[ ](\d+)>/i)){if(_0x392216(0x624)===_0x392216(0x624)){const _0x5bc707=Number(RegExp['$1']);$gameTemp[_0x392216(0xa3d)]([this],_0x5bc707,![],![]);}else _0x2b2e29[_0x392216(0x731)][_0x392216(0x637)][_0x392216(0xa57)](this),this[_0x392216(0x5bf)]()===_0x392216(0x9bc)&&this[_0x392216(0x4df)]();}},VisuMZ[_0x251720(0x731)][_0x251720(0x97f)]=Game_Battler[_0x251720(0x97e)][_0x251720(0x3b6)],Game_Battler[_0x251720(0x97e)][_0x251720(0x3b6)]=function(){const _0x514b2e=_0x251720;this[_0x514b2e(0xa55)](_0x514b2e(0xa05)),VisuMZ[_0x514b2e(0x731)][_0x514b2e(0x97f)]['call'](this),this['processBattleCoreJS'](_0x514b2e(0x548));},VisuMZ[_0x251720(0x731)][_0x251720(0x885)]=Game_Battler[_0x251720(0x97e)][_0x251720(0x1a9)],Game_Battler[_0x251720(0x97e)][_0x251720(0x1a9)]=function(){const _0x32db2e=_0x251720;this[_0x32db2e(0xa55)](_0x32db2e(0x173)),VisuMZ['BattleCore'][_0x32db2e(0x885)][_0x32db2e(0xa57)](this),this[_0x32db2e(0xa55)](_0x32db2e(0x8d4));},Game_Battler[_0x251720(0x97e)][_0x251720(0xa55)]=function(_0xa1e378){const _0xbe840d=_0x251720;if(this[_0xbe840d(0x1bd)]||this['_tempActor'])return;const _0x2edd73=VisuMZ['BattleCore'][_0xbe840d(0x825)]['Mechanics'];if(_0x2edd73[_0xa1e378])_0x2edd73[_0xa1e378][_0xbe840d(0xa57)](this);for(const _0x47d20c of this[_0xbe840d(0xabc)]()){if(!_0x47d20c)continue;key=VisuMZ[_0xbe840d(0x731)][_0xbe840d(0x338)](_0x47d20c,_0xa1e378),VisuMZ['BattleCore']['JS'][key]&&VisuMZ['BattleCore']['JS'][key]['call'](this,this,this,_0x47d20c,0x0);}},Game_Battler[_0x251720(0x97e)][_0x251720(0x536)]=function(){const _0x904415=_0x251720;return VisuMZ[_0x904415(0x731)][_0x904415(0x825)][_0x904415(0x98)]['ChantStyle']||![];},Game_Battler['prototype']['isChanting']=function(){const _0xcbd1f=_0x251720;if(this['isWaiting']()){if(this[_0xcbd1f(0x536)]()){if(this[_0xcbd1f(0x15d)][_0xcbd1f(0x84)](_0x32816d=>_0x32816d[_0xcbd1f(0x342)]()&&_0x32816d[_0xcbd1f(0x700)]()))return!![];}else{if(this[_0xcbd1f(0x15d)]['some'](_0x31566d=>_0x31566d[_0xcbd1f(0x342)]()&&_0x31566d[_0xcbd1f(0x4cf)]()))return!![];}}if(BattleManager[_0xcbd1f(0xb2)]()&&this[_0xcbd1f(0x7ef)]===_0xcbd1f(0xa11)){if(_0xcbd1f(0x2be)!==_0xcbd1f(0x2be)){if(!_0x360e25['isSceneBattle']())return;const _0x3bc0a0=_0x296e3c['getLastPluginCommandInterpreter']();if(!_0x3bc0a0)return;_0x3bc0a0[_0xcbd1f(0x1a1)]('battleSpriteSkew');}else{if(this[_0xcbd1f(0x536)]())return this[_0xcbd1f(0x4c1)]()&&this[_0xcbd1f(0x4c1)]()[_0xcbd1f(0x342)]()&&this[_0xcbd1f(0x4c1)]()[_0xcbd1f(0x700)]();else{if(_0xcbd1f(0x343)===_0xcbd1f(0x343))return this['currentAction']()&&this[_0xcbd1f(0x4c1)]()[_0xcbd1f(0x342)]()&&this[_0xcbd1f(0x4c1)]()[_0xcbd1f(0x4cf)]();else this['startMotion'](_0xcbd1f(0x2f9));}}}return![];},Game_Battler[_0x251720(0x97e)][_0x251720(0x21e)]=function(){const _0x496873=_0x251720;if(BattleManager[_0x496873(0xb2)]()&&this[_0x496873(0x7ef)]===_0x496873(0xa11)){if(_0x496873(0x999)!==_0x496873(0x986)){if(this['chantStyle']())return this[_0x496873(0x4c1)]()&&this[_0x496873(0x4c1)]()['item']()&&!this[_0x496873(0x4c1)]()[_0x496873(0x700)]();else{if(_0x496873(0x380)!==_0x496873(0x38c))return this[_0x496873(0x4c1)]()&&this[_0x496873(0x4c1)]()[_0x496873(0x342)]()&&!this['currentAction']()['isMagicSkill']();else{const _0xf4c103=this[_0x496873(0x808)](),_0x58813c=_0x55233a[_0x496873(0x731)]['Settings'][_0x496873(0x85f)][_0x496873(0x67b)],_0x428d96=_0xf4c103==='text'?_0x382147[_0x496873(0x5f1)]:_0x496873(0x969)['format'](_0x58813c,_0x4d8c35[_0x496873(0x5f1)]),_0x23b5f6=this[_0x496873(0x223)]();this[_0x496873(0x91a)](_0x428d96,_0x496873(0x5f1),_0x23b5f6);}}}else return _0x26c391[_0x496873(0x731)]['Settings'][_0x496873(0x3b1)][_0x496873(0x9eb)];}return![];},VisuMZ[_0x251720(0x731)]['Game_Battler_clearDamagePopup']=Game_Battler[_0x251720(0x97e)]['clearDamagePopup'],Game_Battler[_0x251720(0x97e)][_0x251720(0x6f6)]=function(){const _0x3aa5b5=_0x251720;VisuMZ[_0x3aa5b5(0x731)][_0x3aa5b5(0x2ca)][_0x3aa5b5(0xa57)](this),this['_damagePopupArray']=[];},Game_Battler[_0x251720(0x97e)][_0x251720(0x891)]=function(){const _0x42f0be=_0x251720;if(!this[_0x42f0be(0x186)])this[_0x42f0be(0x6f6)]();return this['_damagePopupArray'][_0x42f0be(0x988)]>0x0;},Game_Battler['prototype'][_0x251720(0x3f3)]=function(){const _0x51cc96=_0x251720;if(!SceneManager[_0x51cc96(0x847)]())return;if(!this['_damagePopupArray'])this['clearDamagePopup']();this['createSeparateDamagePopups']();const _0x1cac0d=this[_0x51cc96(0x60a)]();if(_0x1cac0d)_0x1cac0d['setupDamagePopup']();},Game_Battler['prototype'][_0x251720(0x4ab)]=function(){const _0x27cbf7=_0x251720,_0x4d0c1c=this['result']();if(_0x4d0c1c[_0x27cbf7(0x1c1)]||_0x4d0c1c[_0x27cbf7(0x5a6)]){const _0x4d21d0=JsonEx[_0x27cbf7(0xa1d)](_0x4d0c1c);_0x4d21d0[_0x27cbf7(0x574)]=![],_0x4d21d0[_0x27cbf7(0x4bc)]=0x0,this[_0x27cbf7(0x186)][_0x27cbf7(0x141)](_0x4d21d0);}if(_0x4d0c1c['hpAffected']){if('LeXxi'!==_0x27cbf7(0x895)){const _0x12508c=JsonEx[_0x27cbf7(0xa1d)](_0x4d0c1c);_0x12508c[_0x27cbf7(0x1c1)]=![],_0x12508c[_0x27cbf7(0x5a6)]=![],_0x12508c[_0x27cbf7(0x4bc)]=0x0,this[_0x27cbf7(0x186)][_0x27cbf7(0x141)](_0x12508c);}else{const _0xba9243=this[_0x27cbf7(0x7a7)](_0x3db9fe,_0x46a3c4);_0xba9243[_0x27cbf7(0x817)][_0x27cbf7(0xa68)](_0x2dd886[_0xe19328],0x0,0x0,_0x25300d,_0x239bfc,_0x27cbf7(0x8cc)),_0xba9243['x']=(_0x51e2d4-(_0x5607ff['length']-0x1)/0x2)*_0x2f84a2,_0xba9243['dy']=-_0x254f20;}}if(_0x4d0c1c[_0x27cbf7(0x4bc)]!==0x0){if(_0x27cbf7(0x8be)!==_0x27cbf7(0x804)){const _0x4c7f27=JsonEx[_0x27cbf7(0xa1d)](_0x4d0c1c);_0x4c7f27['missed']=![],_0x4c7f27[_0x27cbf7(0x5a6)]=![],_0x4c7f27[_0x27cbf7(0x574)]=![],this[_0x27cbf7(0x186)]['push'](_0x4c7f27);}else{if(!_0x142734[_0x27cbf7(0x847)]())return;if(!_0x5722d4['VisuMZ_1_ElementStatusCore'])return;_0x2cefb1[_0x27cbf7(0xa0c)](_0x140607,_0x3eecdf);const _0x3a6c7d=_0x321a22[_0x27cbf7(0x866)],_0x21a96e=_0x59d490[_0x27cbf7(0x3ac)];if(!_0x3a6c7d)return;_0x3a6c7d['_battleCoreAddedElements']=_0x21a96e;}}},Game_Battler['prototype'][_0x251720(0x9f5)]=function(){const _0x1be281=_0x251720;if(!this['_damagePopupArray'])this[_0x1be281(0x6f6)]();return VisuMZ['BattleCore'][_0x1be281(0x825)][_0x1be281(0x2e1)][_0x1be281(0x69a)]?this[_0x1be281(0x186)][_0x1be281(0x7e7)]():this[_0x1be281(0x186)]['pop']();},Game_Battler['prototype'][_0x251720(0x33c)]=function(_0xa68eb6,_0x2cfefa){const _0x417c93=_0x251720;if(!SceneManager['isSceneBattle']())return;if(!this[_0x417c93(0x60a)]())return;if(_0xa68eb6[_0x417c93(0x988)]<=0x0)return;_0x2cfefa=_0x2cfefa||{},_0x2cfefa[_0x417c93(0xdd)]=_0x2cfefa[_0x417c93(0xdd)]||_0x417c93(0xa1a),_0x2cfefa[_0x417c93(0x928)]=_0x2cfefa['flashColor']||[0x0,0x0,0x0,0x0],_0x2cfefa[_0x417c93(0xab9)]=_0x2cfefa[_0x417c93(0xab9)]||0x0,this[_0x417c93(0x60a)]()[_0x417c93(0x33c)](_0xa68eb6,_0x2cfefa);},Game_Battler[_0x251720(0x97e)][_0x251720(0x954)]=function(_0x589427,_0x5a1a14,_0x3eecb0){const _0x52042f=_0x251720;if(!SceneManager[_0x52042f(0x847)]())return;if(!this[_0x52042f(0x60a)]())return;if(_0x5a1a14['length']<=0x0)return;_0x3eecb0=_0x3eecb0||{},_0x3eecb0['textColor']=_0x3eecb0['textColor']||_0x52042f(0xa1a),_0x3eecb0[_0x52042f(0x928)]=_0x3eecb0[_0x52042f(0x928)]||[0x0,0x0,0x0,0x0],_0x3eecb0['flashDuration']=_0x3eecb0[_0x52042f(0xab9)]||0x0,this[_0x52042f(0x60a)]()[_0x52042f(0x954)](_0x589427,_0x5a1a14,_0x3eecb0);},Game_Battler['prototype']['notFocusValid']=function(){const _0x5da48d=_0x251720;if(this[_0x5da48d(0x945)]())return![];if(this[_0x5da48d(0x2ce)]()&&this['isAppeared']())return!![];if(this[_0x5da48d(0x722)]()&&this[_0x5da48d(0x87d)]()){if(this[_0x5da48d(0x864)]()&&this[_0x5da48d(0x86f)]())return![];}else{if(this[_0x5da48d(0x864)]())return![];}return!![];},VisuMZ[_0x251720(0x731)][_0x251720(0xa4)]=Game_Battler[_0x251720(0x97e)][_0x251720(0x32e)],Game_Battler[_0x251720(0x97e)][_0x251720(0x32e)]=function(){const _0x2da2fb=_0x251720;VisuMZ['BattleCore'][_0x2da2fb(0xa4)][_0x2da2fb(0xa57)](this),this[_0x2da2fb(0x985)]();},Game_Battler[_0x251720(0x97e)]['canBattlerMove']=function(){return!![];},Game_Battler[_0x251720(0x97e)][_0x251720(0x3d4)]=function(){return![];},VisuMZ[_0x251720(0x731)]['Game_Battler_onBattleStart']=Game_Battler[_0x251720(0x97e)]['onBattleStart'],Game_Battler[_0x251720(0x97e)][_0x251720(0x832)]=function(_0xc4247e){const _0x35c1ed=_0x251720;VisuMZ[_0x35c1ed(0x731)][_0x35c1ed(0x8d2)][_0x35c1ed(0xa57)](this,_0xc4247e),this[_0x35c1ed(0x6b)](_0xc4247e);},Game_Battler['prototype'][_0x251720(0x6b)]=function(_0x36467d){const _0x4168f4=_0x251720;this[_0x4168f4(0x79c)](![]);},VisuMZ['BattleCore'][_0x251720(0x368)]=Game_Battler[_0x251720(0x97e)][_0x251720(0x7bb)],Game_Battler[_0x251720(0x97e)]['performActionStart']=function(_0x52023b){const _0x424cfc=_0x251720;VisuMZ[_0x424cfc(0x731)]['Game_Battler_performActionStart'][_0x424cfc(0xa57)](this,_0x52023b);if(!_0x52023b['isGuard']()){const _0x11bb05=this[_0x424cfc(0x60a)]();_0x11bb05&&_0x11bb05[_0x424cfc(0x4c0)]();}this[_0x424cfc(0x79c)](![]);},Game_Battler[_0x251720(0x97e)]['performActionEndMembers']=function(){const _0x49e454=_0x251720,_0x503b64=this['_flinched'];this[_0x49e454(0x939)]=![];if(BattleManager[_0x49e454(0x8a4)]()&&this[_0x49e454(0xa69)]()){if(_0x49e454(0x5d7)==='arogk'){const _0xb97a27=this[_0x49e454(0x60a)]();if(_0xb97a27&&_0x503b64)_0xb97a27['stepForward']();return;}else this['commandEscape']();}const _0x2abd53=this[_0x49e454(0x60a)]();if(_0x2abd53)_0x2abd53[_0x49e454(0x6df)]();this['setBattlerFlip'](![]),this['requestMotionRefresh']();},Game_Battler['prototype']['performActionMotions']=function(_0x566c8a){const _0x39d6b3=_0x251720;if(_0x566c8a['isAttack']())this['performAttack']();else{if(_0x566c8a['isGuard']()){if(_0x39d6b3(0x17c)!==_0x39d6b3(0x17c))return this[_0x39d6b3(0x125)]();else this[_0x39d6b3(0x995)]('guard');}else{if(_0x566c8a['isMagical']()){if(_0x39d6b3(0x9df)!==_0x39d6b3(0x78))this[_0x39d6b3(0x995)](_0x39d6b3(0x16d));else{let _0x4ceb13=this[_0x39d6b3(0x5ca)]();return _0x4ad485['clamp'](-_0x4ceb13,_0x4ceb13);}}else{if(_0x566c8a[_0x39d6b3(0x657)]()){if(_0x566c8a[_0x39d6b3(0x342)]()[_0x39d6b3(0x363)][_0x39d6b3(0x74e)]>0x0){if('wByWq'==='OJUpw'){if(this['battler']())this[_0x39d6b3(0x60a)]()['refreshMotion']();}else this['performAttack']();}else this[_0x39d6b3(0x995)](_0x39d6b3(0x6f7));}else _0x566c8a[_0x39d6b3(0x92f)]()&&this['requestMotion'](_0x39d6b3(0x342));}}}},Game_Battler[_0x251720(0x97e)]['getAttackMotion']=function(){const _0x2dd4a7=_0x251720;return $dataSystem[_0x2dd4a7(0x65f)][0x0];},Game_Battler[_0x251720(0x97e)]['getAttackWeaponAnimationId']=function(){const _0x5cff3d=_0x251720,_0x43a715=this[_0x5cff3d(0x8ae)]();return _0x43a715?_0x43a715[_0x5cff3d(0x9e8)]:0x0;},Game_Battler[_0x251720(0x97e)]['performSubstitute']=function(_0x260559){const _0x1f27a3=_0x251720;if(!$gameSystem['isSideView']())return;const _0x3e8695=this[_0x1f27a3(0x60a)](),_0x137cef=_0x260559[_0x1f27a3(0x60a)]();if(!_0x3e8695||!_0x137cef)return;const _0x3933e0=_0x137cef[_0x1f27a3(0x176)],_0x1cc9c4=_0x137cef[_0x1f27a3(0x6cc)];this['moveBattlerToPoint'](_0x3933e0,_0x1cc9c4,0x0,![],'Linear',-0x1),_0x3e8695[_0x1f27a3(0x6da)]();const _0x4bb4b0=VisuMZ[_0x1f27a3(0x731)][_0x1f27a3(0x825)][_0x1f27a3(0x1cc)];let _0xd81e36=(_0x137cef[_0x1f27a3(0x139)]+_0x3e8695[_0x1f27a3(0x139)])/0x2;_0xd81e36*=this[_0x1f27a3(0x4f2)]()?0x1:-0x1;let _0x140629=_0x4bb4b0[_0x1f27a3(0x539)]*(this['isActor']()?0x1:-0x1);_0x260559['moveBattlerDistance'](_0xd81e36,_0x140629,0x0,![],_0x1f27a3(0x59a)),_0x137cef[_0x1f27a3(0x6da)]();},Game_Battler['prototype'][_0x251720(0x995)]=function(_0x20a9dc){const _0x423f1=_0x251720;if(SceneManager[_0x423f1(0x847)]()){const _0x290643=this[_0x423f1(0x60a)]();_0x290643&&(_0x290643['forceMotion'](_0x20a9dc),[_0x423f1(0x389),'thrust',_0x423f1(0x25c)][_0x423f1(0x9b0)](_0x20a9dc)&&this[_0x423f1(0xa60)]());}this['clearFreezeMotion']();},Game_Battler[_0x251720(0x97e)][_0x251720(0xa60)]=function(){},Game_Battler['prototype']['startWeaponAnimation']=function(_0x2c8ac3){const _0x32e39f=_0x251720;if(SceneManager[_0x32e39f(0x847)]()){const _0x50a6ef=this[_0x32e39f(0x60a)]();if(_0x50a6ef)_0x50a6ef[_0x32e39f(0x470)](_0x2c8ac3);}},Game_Battler[_0x251720(0x97e)][_0x251720(0x9f)]=function(){const _0x3af552=_0x251720;if(SceneManager[_0x3af552(0x847)]()){const _0x13e15e=this['getAttackWeaponAnimationId']();this[_0x3af552(0x7fa)](_0x13e15e);}},Game_Battler[_0x251720(0x97e)]['performCastAnimation']=function(_0x573440,_0x37a71b){const _0x9244b=_0x251720;if(!_0x573440)return;if(!_0x573440[_0x9244b(0x342)]())return;if(_0x573440['isAttack']())return;if(_0x573440[_0x9244b(0x45f)]())return;if(_0x573440[_0x9244b(0x92f)]())return;let _0x4608b9=0x0;const _0x46f3d5=VisuMZ[_0x9244b(0x731)]['Settings'][_0x9244b(0x1cc)],_0x23a793=_0x573440[_0x9244b(0x342)]()[_0x9244b(0x67f)];if(_0x23a793[_0x9244b(0x591)](/<CAST ANIMATION: (\d+)>/i))_0x9244b(0x156)==='IHFQU'?(this[_0x9244b(0x432)](),_0x1ab783['BattleCore'][_0x9244b(0x6c9)][_0x9244b(0xa57)](this),this[_0x9244b(0x7ec)]()):_0x4608b9=Number(RegExp['$1']);else{if(_0x23a793['match'](/<NO CAST ANIMATION>/i)){if(_0x9244b(0x18c)==='uKscG')return;else{if(_0x4d9f66[_0x9244b(0x742)][_0x9244b(0x721)]())return!![];this['_waitMode']='';}}else{if(_0x573440[_0x9244b(0x204)]())_0x4608b9=_0x46f3d5[_0x9244b(0x299)];else{if(_0x573440[_0x9244b(0x1f9)]()){if(_0x9244b(0x467)!==_0x9244b(0xa58))_0x4608b9=_0x46f3d5[_0x9244b(0x64d)];else{if(!this[_0x9244b(0x806)])return;if(this[_0x9244b(0x397)]&&this[_0x9244b(0x397)][_0x9244b(0x199)]()){const _0x4b7d3d=this['_shadowSprite']['bitmap'];this['_shadowSprite']['setFrame'](0x0,0x0,_0x4b7d3d['width'],_0x4b7d3d[_0x9244b(0x442)]);}else this[_0x9244b(0x806)][_0x9244b(0x8c4)](0x0,0x0,0x0,0x0);}}else _0x573440[_0x9244b(0x700)]()&&(_0x9244b(0xc0)===_0x9244b(0xc0)?_0x4608b9=_0x46f3d5[_0x9244b(0x374)]:(_0x50cc7e+=_0x2cc931,_0x3007c7+=_0x4edd27));}}}_0x4608b9>0x0&&$gameTemp[_0x9244b(0x95b)]([this],_0x4608b9,!!_0x37a71b);},Game_Battler[_0x251720(0x97e)][_0x251720(0x7d8)]=function(){const _0x2f46b7=_0x251720;SoundManager[_0x2f46b7(0x365)]();let _0x3463f5=VisuMZ[_0x2f46b7(0x731)][_0x2f46b7(0x825)][_0x2f46b7(0x1cc)][_0x2f46b7(0x5c2)];if(_0x3463f5>0x0){if(Imported[_0x2f46b7(0x7a8)])_0x2f46b7(0x3c4)!==_0x2f46b7(0x3c3)?$gameTemp[_0x2f46b7(0xa3d)]([this],_0x3463f5):this[_0x2f46b7(0x63a)]=_0x4e19f4(_0x4f0915['$1']);else{if('ENeKL'===_0x2f46b7(0xe6))$gameTemp[_0x2f46b7(0x95b)]([this],_0x3463f5);else return this[_0x2f46b7(0x72e)](_0x2f46b7(0x796));}}},VisuMZ['BattleCore'][_0x251720(0x8dd)]=Game_Battler[_0x251720(0x97e)]['performDamage'],Game_Battler[_0x251720(0x97e)][_0x251720(0x712)]=function(){const _0xd793c5=_0x251720;VisuMZ[_0xd793c5(0x731)]['Game_Battler_performDamage'][_0xd793c5(0xa57)](this),this['performFlinch']();},VisuMZ[_0x251720(0x731)][_0x251720(0x993)]=Game_Battler['prototype'][_0x251720(0x949)],Game_Battler['prototype'][_0x251720(0x949)]=function(){const _0x404057=_0x251720;VisuMZ['BattleCore'][_0x404057(0x993)][_0x404057(0xa57)](this),this[_0x404057(0x206)]();},VisuMZ[_0x251720(0x731)][_0x251720(0xa10)]=Game_Battler['prototype'][_0x251720(0x2c1)],Game_Battler[_0x251720(0x97e)]['performEvasion']=function(){const _0x3985a0=_0x251720;VisuMZ[_0x3985a0(0x731)][_0x3985a0(0xa10)]['call'](this),this['performFlinch']();},Game_Battler[_0x251720(0x97e)][_0x251720(0x206)]=function(){const _0x1e0bd6=_0x251720;if(!$gameSystem[_0x1e0bd6(0x22c)]())return;if(this['_flinched'])return;this[_0x1e0bd6(0x939)]=!![];const _0x528e21=this['battler']();if(_0x528e21)_0x528e21[_0x1e0bd6(0x9c9)]();},Game_Battler['prototype']['requestMotionRefresh']=function(){const _0xf86e5a=_0x251720;if(this[_0xf86e5a(0x864)]()&&this[_0xf86e5a(0x857)]!==_0xf86e5a(0x437)){this[_0xf86e5a(0x995)](_0xf86e5a(0x437));return;}if(this[_0xf86e5a(0x864)]()&&this['_motionType']===_0xf86e5a(0x437))return;if(!!this[_0xf86e5a(0xa63)])return;if(this['isEnemy']()){if(!this[_0xf86e5a(0x475)]()&&this!==BattleManager[_0xf86e5a(0x29b)]){if(this[_0xf86e5a(0x60a)]())this[_0xf86e5a(0x60a)]()[_0xf86e5a(0x853)]();}this[_0xf86e5a(0x985)]();return;}if(this[_0xf86e5a(0x857)]==='victory')return;if(this[_0xf86e5a(0x857)]==='escape'&&!BattleManager[_0xf86e5a(0xa69)]())return;if(this['_motionType']===_0xf86e5a(0x474)&&!BattleManager[_0xf86e5a(0xa69)]())return;this[_0xf86e5a(0x32e)]();if(this[_0xf86e5a(0x60a)]()&&BattleManager[_0xf86e5a(0xa69)]()){this[_0xf86e5a(0x60a)]()['refreshMotion'](),this['clearFreezeMotion']();return;}},Game_Enemy[_0x251720(0x97e)]['isDuringNonLoopingMotion']=function(){const _0x52d594=_0x251720;if(!this[_0x52d594(0x87d)]())return![];const _0xa29252=this[_0x52d594(0x60a)]();if(!_0xa29252)return![];const _0x7f155e=_0xa29252['_svBattlerSprite'];if(!_0x7f155e)return![];const _0x349c5f=_0x7f155e[_0x52d594(0x723)];return _0x349c5f&&!_0x349c5f[_0x52d594(0x8db)];},Game_Battler['prototype'][_0x251720(0x660)]=function(){const _0x19ad2b=_0x251720;return this[_0x19ad2b(0x2ae)];},Game_Battler[_0x251720(0x97e)][_0x251720(0x79c)]=function(_0x46ad6a){const _0x62550b=_0x251720;if(!$gameSystem[_0x62550b(0x22c)]())return;this['_isBattlerFlipped']=_0x46ad6a;const _0x1d0519=this['battler']();if(_0x1d0519)_0x1d0519[_0x62550b(0x916)]();},Game_Battler[_0x251720(0x97e)]['setBattlerFacePoint']=function(_0xf59547,_0x550b38,_0x21fe36){const _0x29e4dd=_0x251720;if(!$gameSystem['isSideView']())return;const _0x5d27e3=this[_0x29e4dd(0x60a)]();if(!_0x5d27e3)return;if(_0xf59547===_0x5d27e3['_baseX'])return;let _0x21489d=![];if(this['isActor']()){if(_0x29e4dd(0x41f)===_0x29e4dd(0x41f)){if(_0xf59547>_0x5d27e3['_baseX'])_0x21489d=!![];if(_0xf59547<_0x5d27e3[_0x29e4dd(0x176)])_0x21489d=![];}else _0x5c7ff3['BattleCore'][_0x29e4dd(0x5e6)]&&_0x1e47d3[_0x29e4dd(0x731)][_0x29e4dd(0x5e6)][_0x29e4dd(0xa57)](this,_0x308720),_0x511eed[_0x29e4dd(0x731)][_0x29e4dd(0x4d5)](_0x3037cd);}else{if(this[_0x29e4dd(0x722)]()){if(_0xf59547>_0x5d27e3['_baseX'])_0x21489d=![];if(_0xf59547<_0x5d27e3[_0x29e4dd(0x176)])_0x21489d=!![];}};this[_0x29e4dd(0x79c)](_0x21fe36?!_0x21489d:_0x21489d),_0x5d27e3['updateFlip']();},Game_Battler['prototype']['moveBattlerDistance']=function(_0x231f89,_0x25184d,_0x41f119,_0x3bd370,_0x129272){const _0x156397=_0x251720;if(!$gameSystem[_0x156397(0x22c)]())return;const _0x1b6c25=this[_0x156397(0x60a)]();if(!_0x1b6c25)return;if(_0x3bd370)this[_0x156397(0x587)](_0x231f89+_0x1b6c25[_0x156397(0x176)],_0x25184d+_0x1b6c25[_0x156397(0x6cc)],![]);_0x231f89+=_0x1b6c25[_0x156397(0x176)]-_0x1b6c25['_homeX'],_0x25184d+=_0x1b6c25[_0x156397(0x6cc)]-_0x1b6c25['_homeY'],_0x1b6c25['startMove'](_0x231f89,_0x25184d,_0x41f119);if(Imported[_0x156397(0x7a8)])_0x1b6c25[_0x156397(0x28f)](_0x129272||_0x156397(0x59a));},Game_Battler['prototype']['moveBattlerToPoint']=function(_0x11c47c,_0x256ffb,_0x246bf5,_0x33a34f,_0x2ba6dd,_0x273299){const _0x4c19d8=_0x251720;if(!$gameSystem['isSideView']())return;const _0x2e69cb=this['battler']();if(!_0x2e69cb)return;_0x273299=_0x273299||0x0;if(_0x273299>0x0){if(_0x2e69cb['_baseX']>_0x11c47c)_0x11c47c+=_0x2e69cb[_0x4c19d8(0x139)]/0x2+_0x273299;if(_0x2e69cb['_baseX']<_0x11c47c)_0x11c47c-=_0x2e69cb[_0x4c19d8(0x139)]/0x2+_0x273299;}if(_0x33a34f)this[_0x4c19d8(0x587)](_0x11c47c,_0x256ffb,![]);_0x11c47c-=_0x2e69cb['_homeX'],_0x256ffb-=_0x2e69cb[_0x4c19d8(0xa0e)],_0x2e69cb[_0x4c19d8(0x44c)](_0x11c47c,_0x256ffb,_0x246bf5);if(Imported[_0x4c19d8(0x7a8)])_0x2e69cb[_0x4c19d8(0x28f)](_0x2ba6dd||_0x4c19d8(0x59a));},Game_Battler[_0x251720(0x97e)]['floatBattler']=function(_0x4bbf5e,_0x3f9256,_0x6a6877){const _0x3c9f47=_0x251720;if(!$gameSystem[_0x3c9f47(0x22c)]())return;const _0x592442=this[_0x3c9f47(0x60a)]();if(!_0x592442)return;_0x592442['startFloat'](_0x4bbf5e,_0x3f9256,_0x6a6877);},Game_Battler[_0x251720(0x97e)][_0x251720(0x135)]=function(_0x43ea96,_0x2274f8){const _0x54729e=_0x251720;if(!$gameSystem[_0x54729e(0x22c)]())return;const _0x1d50e1=this[_0x54729e(0x60a)]();if(!_0x1d50e1)return;_0x1d50e1['startJump'](_0x43ea96,_0x2274f8);},Game_Battler[_0x251720(0x97e)]['spinBattler']=function(_0x335258,_0x1877e6,_0x1c6539,_0x52d674){const _0x2b1f09=_0x251720;if(!$gameSystem[_0x2b1f09(0x22c)]())return;const _0x5a0983=this['battler']();if(!_0x5a0983)return;_0x5a0983[_0x2b1f09(0x6aa)](_0x335258,_0x1877e6,_0x1c6539,_0x52d674);},Game_Battler['prototype'][_0x251720(0x978)]=function(_0x440f18,_0x486bad,_0x51c718,_0x1f3a82){const _0x560410=_0x251720;if(!$gameSystem['isSideView']())return;const _0x22ebb4=this[_0x560410(0x60a)]();if(!_0x22ebb4)return;this[_0x560410(0x4f2)]()&&(_0x440f18*=-0x1,_0x486bad*=-0x1),_0x22ebb4[_0x560410(0x63c)](_0x440f18,_0x486bad,_0x51c718,_0x1f3a82);},Game_Battler[_0x251720(0x97e)][_0x251720(0x54f)]=function(_0x5c262b,_0x242849,_0x27aa9d,_0x166951){const _0x409d95=_0x251720;if(!$gameSystem[_0x409d95(0x22c)]())return;const _0x5702c2=this[_0x409d95(0x60a)]();if(!_0x5702c2)return;_0x5702c2[_0x409d95(0xaac)](_0x5c262b,_0x242849,_0x27aa9d,_0x166951);},Game_Battler['prototype'][_0x251720(0x1b2)]=function(_0x4d84a4,_0x2af2cc,_0x57bc14){const _0x4b0569=_0x251720;if(!$gameSystem[_0x4b0569(0x22c)]())return;const _0x2be490=this[_0x4b0569(0x60a)]();if(!_0x2be490)return;_0x2be490['startOpacity'](_0x4d84a4,_0x2af2cc,_0x57bc14);},Game_Battler[_0x251720(0x97e)][_0x251720(0x985)]=function(){const _0x543ba5=_0x251720,_0x2de03f=!!this['_freezeMotionData'];this[_0x543ba5(0xa63)]=undefined,_0x2de03f&&(_0x543ba5(0x773)!==_0x543ba5(0x94c)?(this[_0x543ba5(0x711)](),this[_0x543ba5(0x250)]()):this[_0x543ba5(0x2c7)]());},Game_Battler[_0x251720(0x97e)][_0x251720(0x250)]=function(){const _0x44544c=_0x251720;if(!SceneManager[_0x44544c(0x847)]())return;const _0x1ca506=this[_0x44544c(0x60a)]();if(!_0x1ca506)return;let _0x1b4d22=this[_0x44544c(0x4f2)]()?_0x1ca506[_0x44544c(0x488)]:_0x1ca506[_0x44544c(0x5ce)]['_weaponSprite'];_0x1b4d22&&_0x1b4d22[_0x44544c(0x1ea)](0x0);},Game_Battler['prototype'][_0x251720(0x420)]=function(_0x4fb7e2,_0x4b0c5f,_0xc61463){const _0x29d699=_0x251720;if(this[_0x29d699(0x722)]()&&!this[_0x29d699(0x87d)]())return;let _0x4d3ed7=0x0,_0x191367=0x0;_0x4fb7e2[_0x29d699(0x591)](/ATTACK[ ](\d+)/i)&&(_0x191367=Number(RegExp['$1']),_0x191367--);if(this[_0x29d699(0x4f2)]()){const _0x13fcec=this[_0x29d699(0x2e6)]();_0x4d3ed7=_0x13fcec[_0x191367]?_0x13fcec[_0x191367][_0x29d699(0x87c)]:0x0;}else this['isEnemy']()&&(_0x4d3ed7=this['svBattlerData']()[_0x29d699(0x87c)]||0x0);const _0x49f644=$dataSystem[_0x29d699(0x65f)][_0x4d3ed7];if(_0x4fb7e2[_0x29d699(0x591)](/attack/i)){if(_0x29d699(0x6a0)==='EdUjm')return[_0x5507c5];else _0x4fb7e2=[_0x29d699(0x1c8),_0x29d699(0x389),'missile'][_0x49f644[_0x29d699(0x74e)]]||_0x29d699(0x389);}this['_freezeMotionData']={'motionType':_0x4fb7e2,'weaponImageId':_0x4b0c5f?_0x49f644[_0x29d699(0x9e8)]:0x0,'pattern':_0xc61463};},Game_Battler[_0x251720(0x97e)]['isFriendly']=function(_0x249323){const _0xd1e2aa=_0x251720;if(!_0x249323)return![];return _0x249323[_0xd1e2aa(0x366)]()===this[_0xd1e2aa(0x366)]();},Game_Battler[_0x251720(0x97e)][_0x251720(0x748)]=function(_0x4bd2d5){const _0x4265de=_0x251720;if(!_0x4bd2d5)return![];return _0x4bd2d5[_0x4265de(0x7f5)]()===this['friendsUnit']();},VisuMZ['BattleCore'][_0x251720(0x73b)]=Game_Actor[_0x251720(0x97e)][_0x251720(0x1ea)],Game_Actor[_0x251720(0x97e)][_0x251720(0x1ea)]=function(_0x18e937){const _0x53bebc=_0x251720;VisuMZ[_0x53bebc(0x731)][_0x53bebc(0x73b)]['call'](this,_0x18e937),this['initBattlePortrait']();},Game_Actor[_0x251720(0x97e)][_0x251720(0xa3e)]=function(){const _0x3d2ccc=_0x251720;this['_battlePortrait']='',this['actor']()&&this['actor']()[_0x3d2ccc(0x67f)]['match'](/<BATTLE (?:IMAGE|PORTRAIT):[ ](.*)>/i)&&(this['_battlePortrait']=String(RegExp['$1']));},Game_Actor[_0x251720(0x97e)][_0x251720(0x811)]=function(){const _0x587805=_0x251720;if(this[_0x587805(0x92a)]()!==''){if(_0x587805(0x9c2)!==_0x587805(0x96e))return this[_0x587805(0x92a)]();else{if(this['_targetOpacity']===_0x59c585)return;this[_0x587805(0x10c)]=_0x22d5ef,this[_0x587805(0x6c2)]=_0x20c095,this[_0x587805(0x741)]=_0x1a65a1,this[_0x587805(0x30a)]=_0x13ad0b||_0x587805(0x59a);if(_0x17d327<=0x0)this[_0x587805(0x8f9)]=_0x4d39cb;}}else{if(Imported[_0x587805(0x604)]&&this['getMenuImage']()!==''){if('LPwEa'===_0x587805(0x79e)){if(!_0x513691[_0x587805(0x847)]())return;if(!_0xa5be34[_0x587805(0x41e)])return;if(!_0x6ce081[_0x587805(0xa8e)]())return;_0x3a776b[_0x587805(0xa0c)](_0x5cd023,_0x1fdac4);const _0x42e909=_0x406a79[_0x587805(0x29b)]['friendsUnit']();let _0x32b46d=_0x169d1b['FullActions'],_0x5a96f0=_0xe98ffb[_0x587805(0x477)];_0x42e909['gainFullActionsPTB'](_0x32b46d),_0x42e909['gainHalfActionsPTB'](_0x5a96f0);}else return this[_0x587805(0x592)]();}}return'';},Game_Actor[_0x251720(0x97e)]['getBattlePortrait']=function(){const _0x59a18f=_0x251720;if(this[_0x59a18f(0xa06)]===undefined)this[_0x59a18f(0xa3e)]();return this[_0x59a18f(0xa06)];},Game_Actor[_0x251720(0x97e)][_0x251720(0xa82)]=function(_0xe84c49){const _0x140f73=_0x251720;if(this[_0x140f73(0xa06)]===undefined)this[_0x140f73(0xa3e)]();this[_0x140f73(0xa06)]=_0xe84c49;if(SceneManager[_0x140f73(0x847)]()&&$gameParty[_0x140f73(0x5e2)]()[_0x140f73(0x9b0)](this)){if(_0x140f73(0x958)!==_0x140f73(0x6bc)){const _0x2bddd9=SceneManager['_scene']['_statusWindow'];if(_0x2bddd9)_0x2bddd9[_0x140f73(0x875)](this);}else _0xc32459=(_0x4367bf+_0xc056c2)/0x2,_0x52868f=-0x1;}},Game_Actor[_0x251720(0x97e)][_0x251720(0x9b3)]=function(){return!![];},Game_Actor[_0x251720(0x97e)][_0x251720(0x7db)]=function(){const _0x3f7892=_0x251720;if(!this[_0x3f7892(0x356)]()&&BattleManager[_0x3f7892(0x8b7)])return!![];return Game_Battler['prototype'][_0x3f7892(0x7db)][_0x3f7892(0xa57)](this);},VisuMZ['BattleCore'][_0x251720(0x381)]=Game_Actor['prototype']['makeActionList'],Game_Actor[_0x251720(0x97e)][_0x251720(0x9db)]=function(){const _0x4bc41e=_0x251720;if(BattleManager[_0x4bc41e(0x8b7)]&&!ConfigManager[_0x4bc41e(0x842)])return this[_0x4bc41e(0x125)]();else{if(_0x4bc41e(0x4bf)!==_0x4bc41e(0x4bf))this[_0x4bc41e(0xa91)]=0x0;else{return VisuMZ[_0x4bc41e(0x731)]['Game_Actor_makeActionList'][_0x4bc41e(0xa57)](this);;}}},Game_Actor[_0x251720(0x97e)][_0x251720(0x125)]=function(){const _0x3fd8d9=_0x251720,_0x4f59f2=[],_0x16e013=new Game_Action(this);return _0x16e013[_0x3fd8d9(0x1d3)](),_0x4f59f2[_0x3fd8d9(0x141)](_0x16e013),_0x4f59f2;},Game_Actor[_0x251720(0x97e)][_0x251720(0x2b7)]=function(){const _0x4d8fad=_0x251720;return this['currentClass']()['note'][_0x4d8fad(0x591)](/<BATTLE COMMANDS>\s*([\s\S]*)\s*<\/BATTLE COMMANDS>/i)?String(RegExp['$1'])[_0x4d8fad(0xa45)](/[\r\n]+/):VisuMZ[_0x4d8fad(0x731)][_0x4d8fad(0x825)][_0x4d8fad(0x9c7)][_0x4d8fad(0x7ca)];},Game_Actor['prototype'][_0x251720(0x516)]=function(){const _0xd596f=_0x251720;if(this[_0xd596f(0x4d7)]['svAnchorX']!==undefined)return this[_0xd596f(0x4d7)]['svAnchorX'];return this[_0xd596f(0x30d)]()[_0xd596f(0x67f)][_0xd596f(0x591)](/<SIDEVIEW ANCHOR: (.*), (.*)>/i)?(this[_0xd596f(0x4d7)][_0xd596f(0x108)]=eval(RegExp['$1']),this[_0xd596f(0x4d7)]['svAnchorY']=eval(RegExp['$2'])):this[_0xd596f(0x4d7)][_0xd596f(0x108)]=Game_Battler[_0xd596f(0x97e)]['svBattlerAnchorX'][_0xd596f(0xa57)](this),this[_0xd596f(0x4d7)]['svAnchorX'];},Game_Actor[_0x251720(0x97e)][_0x251720(0x5fc)]=function(){const _0x4f03fe=_0x251720;if(this[_0x4f03fe(0x4d7)]['svAnchorY']!==undefined)return this[_0x4f03fe(0x4d7)][_0x4f03fe(0x611)];return this[_0x4f03fe(0x30d)]()[_0x4f03fe(0x67f)]['match'](/<SIDEVIEW ANCHOR: (.*), (.*)>/i)?'efDLS'!==_0x4f03fe(0x3cd)?(this[_0x4f03fe(0x4d7)][_0x4f03fe(0x108)]=eval(RegExp['$1']),this['_cache'][_0x4f03fe(0x611)]=eval(RegExp['$2'])):this['performAttack']():this[_0x4f03fe(0x4d7)][_0x4f03fe(0x611)]=Game_Battler[_0x4f03fe(0x97e)][_0x4f03fe(0x5fc)]['call'](this),this[_0x4f03fe(0x4d7)]['svAnchorY'];},Game_Actor[_0x251720(0x97e)][_0x251720(0x199)]=function(){const _0x243a11=_0x251720;if(this['_cache']['svShadow']!==undefined)return this[_0x243a11(0x4d7)]['svShadow'];if(this[_0x243a11(0x30d)]()[_0x243a11(0x67f)]['match'](/<SIDEVIEW SHOW SHADOW>/i))this[_0x243a11(0x4d7)][_0x243a11(0x416)]=!![];else{if(this['actor']()[_0x243a11(0x67f)][_0x243a11(0x591)](/<SIDEVIEW HIDE SHADOW>/i)){if(_0x243a11(0x478)!==_0x243a11(0x153))this[_0x243a11(0x4d7)][_0x243a11(0x416)]=![];else return _0x27f0c1[_0x243a11(0x731)][_0x243a11(0x83a)]['call'](this,_0x21c0e8);}else this[_0x243a11(0x4d7)][_0x243a11(0x416)]=Game_Battler[_0x243a11(0x97e)][_0x243a11(0x199)][_0x243a11(0xa57)](this);}return this[_0x243a11(0x4d7)][_0x243a11(0x416)];},Game_Actor['prototype'][_0x251720(0x26c)]=function(){const _0x2e53f2=_0x251720;return VisuMZ['BattleCore'][_0x2e53f2(0x825)]['Actor'][_0x2e53f2(0x55c)];},Game_Actor[_0x251720(0x97e)]['performWeaponAnimation']=function(){const _0x5e3932=_0x251720,_0x715d89=this[_0x5e3932(0x2e6)](),_0x1e8a4a=_0x715d89[0x0]?_0x715d89[0x0][_0x5e3932(0x87c)]:0x0,_0x32270d=$dataSystem[_0x5e3932(0x65f)][_0x1e8a4a];_0x32270d&&this[_0x5e3932(0x7fa)](_0x32270d['weaponImageId']);},Game_Actor[_0x251720(0x97e)][_0x251720(0x702)]=function(_0x43b2b8){const _0x457431=_0x251720;Game_Battler['prototype'][_0x457431(0x702)][_0x457431(0xa57)](this,_0x43b2b8),this[_0x457431(0x458)](_0x43b2b8);},Game_Actor[_0x251720(0x97e)][_0x251720(0x8ae)]=function(){const _0x19e873=_0x251720,_0x32edcb=this[_0x19e873(0x2e6)](),_0x44e038=_0x32edcb[0x0]?_0x32edcb[0x0]['wtypeId']:0x0;return $dataSystem[_0x19e873(0x65f)][_0x44e038];},Game_Actor[_0x251720(0x97e)][_0x251720(0x5de)]=function(_0x35f04c){const _0x2947fc=_0x251720;_0x35f04c=_0x35f04c||0x1,_0x35f04c--;const _0x247f93=this[_0x2947fc(0x2e6)]();return _0x247f93[_0x35f04c]?_0x247f93[_0x35f04c][_0x2947fc(0x1fc)]:0x0;},Game_Actor[_0x251720(0x97e)]['getAttackMotionSlot']=function(_0x4b54c0){const _0x539a3a=_0x251720;_0x4b54c0=_0x4b54c0||0x1,_0x4b54c0--;const _0x1cab61=this[_0x539a3a(0x2e6)](),_0x589c53=_0x1cab61[_0x4b54c0]?_0x1cab61[_0x4b54c0][_0x539a3a(0x87c)]:0x0;return $dataSystem['attackMotions'][_0x589c53];},Game_Actor[_0x251720(0x97e)][_0x251720(0x218)]=function(_0x471dfb){const _0x514934=_0x251720;_0x471dfb=_0x471dfb||0x1,_0x471dfb--;const _0x113888=this[_0x514934(0x2e6)](),_0x5b0ac1=_0x113888[_0x471dfb]?_0x113888[_0x471dfb][_0x514934(0x87c)]:0x0,_0x41fcc0=$dataSystem[_0x514934(0x65f)][_0x5b0ac1];if(_0x41fcc0){if(_0x41fcc0[_0x514934(0x74e)]===0x0)this[_0x514934(0x995)]('thrust');else{if(_0x41fcc0[_0x514934(0x74e)]===0x1){if('DMikG'!=='CABRe')this[_0x514934(0x995)]('swing');else return _0x4c2126[_0x514934(0x13f)];}else _0x41fcc0[_0x514934(0x74e)]===0x2&&this[_0x514934(0x995)](_0x514934(0x25c));}this['startWeaponAnimation'](_0x41fcc0[_0x514934(0x9e8)]);}},Game_Battler[_0x251720(0x97e)]['setActiveWeaponSlot']=function(_0x12c5e7){const _0x1ff71c=_0x251720;this[_0x1ff71c(0xa61)]=_0x12c5e7||0x0;},Game_Battler[_0x251720(0x97e)]['nextActiveWeaponSlot']=function(){const _0xc5c472=_0x251720;this[_0xc5c472(0xa61)]=this[_0xc5c472(0xa61)]||0x0,this[_0xc5c472(0xa61)]++;},Game_Battler['prototype']['clearActiveWeaponSlot']=function(){this['_activeWeaponSlot']=undefined;},VisuMZ['BattleCore']['Game_Actor_equips']=Game_Actor['prototype'][_0x251720(0x5b5)],Game_Actor[_0x251720(0x97e)]['equips']=function(){const _0xf85570=_0x251720;let _0x43c13b=VisuMZ[_0xf85570(0x731)]['Game_Actor_equips'][_0xf85570(0xa57)](this);if(this['_tempEquipCheck'])return _0x43c13b;if(this['_activeWeaponSlot']!==undefined){this['_tempEquipCheck']=!![];const _0x1f2bd4=this[_0xf85570(0x6c1)]();for(let _0x2080bc=0x0;_0x2080bc<_0x1f2bd4[_0xf85570(0x988)];_0x2080bc++){_0x1f2bd4[_0x2080bc]===0x1&&this[_0xf85570(0xa61)]!==_0x2080bc&&(_0x43c13b[_0x2080bc]=null);}this[_0xf85570(0x6cf)]=undefined;}return _0x43c13b;},Window_BattleLog[_0x251720(0x97e)][_0x251720(0x6bb)]=function(_0x56faff){const _0x5ce271=_0x251720;return _0x56faff['isActor']()?_0x56faff['weapons']()[_0x5ce271(0x988)]||0x1:0x1;},Window_BattleLog[_0x251720(0x97e)][_0x251720(0x1b5)]=function(_0xcff0b2,_0x4991d6){const _0x3022dc=_0x251720;_0xcff0b2&&_0xcff0b2['isActor']()&&_0xcff0b2[_0x3022dc(0x9d8)](_0x4991d6),this[_0x3022dc(0x648)]();},Window_BattleLog[_0x251720(0x97e)][_0x251720(0x2aa)]=function(_0x3437c8){const _0x395c5d=_0x251720;if(_0x3437c8&&_0x3437c8[_0x395c5d(0x4f2)]()){if(_0x395c5d(0x863)===_0x395c5d(0x70a)){_0xa7c1b9-=_0x258414;const _0x127ef3=_0x42acd3['BattleCore']['Settings'][_0x395c5d(0x2e1)]['DefaultSoftScaler'],_0x51f045=_0x290458[_0x395c5d(0x79a)](0x1-_0x3a42ac/((_0x2ea4ea-_0x330a3d)*_0x127ef3+_0x45a588),0.01);_0x520274*=_0x51f045,_0x7806ca+=_0x1afa06;}else _0x3437c8[_0x395c5d(0x7ac)]();}this[_0x395c5d(0x648)]();},Game_Actor[_0x251720(0x97e)][_0x251720(0x9a9)]=function(){const _0x1f48bc=_0x251720;let _0x26014c='battleUIOffsetX';if(this[_0x1f48bc(0x947)](_0x26014c))return this[_0x1f48bc(0x4d7)][_0x26014c];return this[_0x1f48bc(0x4d7)][_0x26014c]=this[_0x1f48bc(0xd6)](this[_0x1f48bc(0x30d)]()),this['_cache'][_0x26014c];},Game_Actor['prototype'][_0x251720(0x36e)]=function(){const _0x46ac60=_0x251720;let _0x38cc27=_0x46ac60(0x36e);if(this[_0x46ac60(0x947)](_0x38cc27))return this['_cache'][_0x38cc27];return this[_0x46ac60(0x4d7)][_0x38cc27]=this[_0x46ac60(0x4a3)](this[_0x46ac60(0x30d)]()),this[_0x46ac60(0x4d7)][_0x38cc27];},VisuMZ[_0x251720(0x731)][_0x251720(0x101)]=Game_Enemy['prototype'][_0x251720(0x1ea)],Game_Enemy[_0x251720(0x97e)]['setup']=function(_0x41b982,_0x336586,_0x20954d){const _0x324771=_0x251720;_0x41b982=DataManager[_0x324771(0x83b)](_0x41b982),VisuMZ[_0x324771(0x731)]['Game_Enemy_setup'][_0x324771(0xa57)](this,_0x41b982,_0x336586,_0x20954d);Imported[_0x324771(0xb5)]&&this[_0x324771(0x7a9)]();this['clearBattleCoreData'](),this[_0x324771(0x573)]();if(Imported['VisuMZ_1_ElementStatusCore']){if(_0x324771(0x7ba)!==_0x324771(0x7ba)){if(this[_0x324771(0x517)]>0x0){const _0x244585=this[_0x324771(0x517)],_0x12d588=this[_0x324771(0x5df)];_0x12d588['x']=(_0x12d588['x']*(_0x244585-0x1)+this[_0x324771(0x113)])/_0x244585,_0x12d588['opacity']=(_0x12d588['opacity']*(_0x244585-0x1)+0xff)/_0x244585,this[_0x324771(0x517)]--;}}else this[_0x324771(0x461)]();}},Game_Enemy['prototype']['clearBattleCoreData']=function(){const _0x39ec53=_0x251720,_0x106fe5=VisuMZ[_0x39ec53(0x731)][_0x39ec53(0x825)]['Enemy'];this[_0x39ec53(0x63a)]=_0x106fe5['AttackAnimation'],this[_0x39ec53(0x76a)]={};},Game_Enemy[_0x251720(0x97e)][_0x251720(0x573)]=function(){const _0x374659=_0x251720,_0xe4f5e2=VisuMZ[_0x374659(0x731)]['Settings']['Enemy'],_0xcc98d8=this['enemy']()[_0x374659(0x67f)];this[_0x374659(0x76a)]={'name':'','wtypeId':_0xe4f5e2['WtypeId'],'collapse':_0xe4f5e2[_0x374659(0x555)],'motionIdle':_0xe4f5e2[_0x374659(0x8aa)],'width':_0xe4f5e2[_0x374659(0x968)]||0x40,'height':_0xe4f5e2[_0x374659(0xa34)]||0x40,'anchorX':_0xe4f5e2['AnchorX']||0x0,'anchorY':_0xe4f5e2[_0x374659(0x261)]||0x0,'shadow':_0xe4f5e2[_0x374659(0x7f7)]};_0xcc98d8[_0x374659(0x591)](/<ATTACK ANIMATION:[ ](\d+)>/i)&&(this['_attackAnimationId']=Number(RegExp['$1']));const _0x16d613=this[_0x374659(0x76a)];if(_0xcc98d8[_0x374659(0x591)](/<SIDEVIEW BATTLER: (.*)>/i))_0x16d613[_0x374659(0x1f8)]=String(RegExp['$1']);else{if(_0xcc98d8['match'](/<SIDEVIEW BATTLERS>\s*([\s\S]*)\s*<\/SIDEVIEW BATTLERS>/i)){if(_0x374659(0x97b)===_0x374659(0x80b))this[_0x374659(0xa7d)][_0x374659(0x6a9)](_0x31d43b);else{const _0x3d00cb=String(RegExp['$1'])[_0x374659(0xa45)](/[\r\n]+/)[_0x374659(0x39c)]('');_0x16d613['name']=DataManager[_0x374659(0xa9f)](_0x3d00cb);}}}if(_0xcc98d8[_0x374659(0x591)](/<SIDEVIEW ANCHOR: (.*), (.*)>/i)){if(_0x374659(0x6c0)!==_0x374659(0x192))_0x16d613[_0x374659(0x3dd)]=eval(RegExp['$1']),_0x16d613[_0x374659(0x46f)]=eval(RegExp['$2']);else{const _0xb05c90=_0x26ad11[_0x374659(0x13f)]/0x2,_0x5034d6=this[_0x374659(0x73d)](_0x521cbe['BattleCore'][_0x374659(0x825)]['BattleLayout'][_0x374659(0x383)],!![]),_0x1f3dec=_0x1abecd[_0x374659(0x3e4)]((_0x2afee2[_0x374659(0x13f)]-_0xb05c90)/0x2),_0x2e46b2=_0x13abd1[_0x374659(0x635)]-_0x5034d6-this[_0x374659(0x1b3)]()[_0x374659(0x442)];return new _0x3df73d(_0x1f3dec,_0x2e46b2,_0xb05c90,_0x5034d6);}}if(_0xcc98d8[_0x374659(0x591)](/<SIDEVIEW COLLAPSE>/i)){if(_0x374659(0x68d)!==_0x374659(0x861))_0x16d613[_0x374659(0x95f)]=!![];else{if(_0x2d7f0b[_0x374659(0x847)]()){const _0x63f551=this[_0x374659(0x60a)]();if(_0x63f551)_0x63f551[_0x374659(0x470)](_0x484140);}}}else _0xcc98d8[_0x374659(0x591)](/<SIDEVIEW NO COLLAPSE>/i)&&(_0x374659(0x66f)!=='Cohbm'?this[_0x374659(0x8f9)]+=0x10:_0x16d613[_0x374659(0x95f)]=![]);if(_0xcc98d8[_0x374659(0x591)](/<SIDEVIEW SHOW SHADOW>/i))_0x374659(0x634)!=='BNLSI'?(this[_0x374659(0x56d)][_0x374659(0x732)]['x']=0x1/(this[_0x374659(0x732)]['x']||0.001),this['_stateSprite'][_0x374659(0x732)]['y']=0x1/(this[_0x374659(0x732)]['y']||0.001)):_0x16d613[_0x374659(0x977)]=!![];else _0xcc98d8[_0x374659(0x591)](/<SIDEVIEW HIDE SHADOW>/i)&&(_0x374659(0x9a5)===_0x374659(0x776)?_0x3ecfa9[_0x374659(0x731)]['JS'][_0x435bb1]['call'](this,this[_0x374659(0x271)](),this[_0x374659(0x271)](),this[_0x374659(0x342)](),_0x11ae74):_0x16d613[_0x374659(0x977)]=![]);if(_0xcc98d8[_0x374659(0x591)](/<SIDEVIEW IDLE MOTION: (.*)>/i))_0x16d613[_0x374659(0x673)]=String(RegExp['$1'])[_0x374659(0x612)]()[_0x374659(0x30b)]();else{if(_0xcc98d8[_0x374659(0x591)](/<SIDEVIEW IDLE MOTIONS>\s*([\s\S]*)\s*<\/SIDEVIEW IDLE MOTIONS>/i)){if('qxmPF'===_0x374659(0x493))return 0x1;else{const _0xb623b9=String(RegExp['$1'])[_0x374659(0xa45)](/[\r\n]+/)[_0x374659(0x39c)]('');_0x16d613[_0x374659(0x673)]=DataManager[_0x374659(0xa9f)](_0xb623b9);}}}_0xcc98d8[_0x374659(0x591)](/<SIDEVIEW SIZE: (\d+), (\d+)>/i)&&(_0x16d613['width']=Number(RegExp['$1']),_0x16d613[_0x374659(0x442)]=Number(RegExp['$2']));if(_0xcc98d8[_0x374659(0x591)](/<SIDEVIEW WEAPON: (.*)>/i))_0x374659(0x136)===_0x374659(0x987)?_0x416dd2[_0x374659(0x731)][_0x374659(0x324)][_0x374659(0xa57)](this):_0x16d613[_0x374659(0x87c)]=DataManager['getWtypeIdWithName'](RegExp['$1']);else{if(_0xcc98d8['match'](/<SIDEVIEW WEAPONS>\s*([\s\S]*)\s*<\/SIDEVIEW WEAPONS>/i)){if(_0x374659(0x128)!==_0x374659(0x4a9)){const _0x705966=String(RegExp['$1'])[_0x374659(0xa45)](/[\r\n]+/)[_0x374659(0x39c)](''),_0x573f52=DataManager[_0x374659(0xa9f)](_0x705966);_0x16d613['wtypeId']=DataManager['getWtypeIdWithName'](_0x573f52);}else{_0x4c8ea4[_0x374659(0x365)]();let _0x1343e8=_0x4ad26b[_0x374659(0x731)][_0x374659(0x825)][_0x374659(0x1cc)][_0x374659(0x5c2)];_0x1343e8>0x0&&(_0xc0fd96[_0x374659(0x7a8)]?_0x1869d6['requestFauxAnimation']([this],_0x1343e8):_0x1bbe2d[_0x374659(0x95b)]([this],_0x1343e8));}}}if(Imported[_0x374659(0xb5)]){if('qrjlq'===_0x374659(0x89b)){const _0x475309=this[_0x374659(0x110)]();for(const _0x1e786b of _0x475309){const _0x31ce4f=this[_0x374659(0x148)](_0x1e786b)[_0x374659(0x225)]['toUpperCase']()[_0x374659(0x30b)](),_0x179e2d=_0x1e786b[_0x374659(0x62a)]()[_0x374659(0x30b)]();if(_0xcc98d8[_0x374659(0x591)](VisuMZ['ElementStatusCore'][_0x374659(0x61f)][_0x374659(0x614)['format'](_0x179e2d,_0x31ce4f)]))_0x374659(0x27c)!==_0x374659(0x6fc)?_0x16d613[_0x374659(0x1f8)]=String(RegExp['$1']):delete _0x37289f[_0x374659(0x6a5)][_0x374659(0x3da)];else{if(_0xcc98d8['match'](VisuMZ[_0x374659(0x18e)][_0x374659(0x61f)]['SvBattlerMass-%1-%2'[_0x374659(0x8d6)](_0x179e2d,_0x31ce4f)])){if('JFLfo'!=='JFLfo')_0x57cb26[_0x374659(0x97e)][_0x374659(0x143)][_0x374659(0xa57)](this),this[_0x374659(0x742)]&&this['_spriteset'][_0x374659(0xc8)](),_0x257454[_0x374659(0x5e8)]&&_0x412a05[_0x374659(0xa41)]();else{const _0x75e221=String(RegExp['$1'])[_0x374659(0xa45)](/[\r\n]+/)[_0x374659(0x39c)]('');_0x16d613[_0x374659(0x1f8)]=DataManager['processRandomizedData'](_0x75e221);}}}if(_0xcc98d8['match'](VisuMZ[_0x374659(0x18e)][_0x374659(0x61f)][_0x374659(0x5b9)[_0x374659(0x8d6)](_0x179e2d,_0x31ce4f)]))'wdPpL'===_0x374659(0x914)?_0x16d613[_0x374659(0x87c)]=DataManager[_0x374659(0x385)](RegExp['$1']):(_0x4a9a21[_0x374659(0x731)][_0x374659(0xa4)][_0x374659(0xa57)](this),this[_0x374659(0x985)]());else{if(_0xcc98d8[_0x374659(0x591)](VisuMZ[_0x374659(0x18e)][_0x374659(0x61f)][_0x374659(0x61a)['format'](_0x179e2d,_0x31ce4f)])){const _0x24ad18=String(RegExp['$1'])[_0x374659(0xa45)](/[\r\n]+/)['remove'](''),_0x365d12=DataManager[_0x374659(0xa9f)](_0x24ad18);_0x16d613[_0x374659(0x87c)]=DataManager[_0x374659(0x385)](_0x365d12);}}if(_0xcc98d8[_0x374659(0x591)](VisuMZ[_0x374659(0x18e)][_0x374659(0x61f)][_0x374659(0xab4)[_0x374659(0x8d6)](_0x179e2d,_0x31ce4f)]))_0x16d613[_0x374659(0x673)]=String(RegExp['$1'])[_0x374659(0x612)]()['trim']();else{if(_0xcc98d8[_0x374659(0x591)](VisuMZ[_0x374659(0x18e)][_0x374659(0x61f)][_0x374659(0x76)[_0x374659(0x8d6)](_0x179e2d,_0x31ce4f)])){const _0xb13dc4=String(RegExp['$1'])['split'](/[\r\n]+/)['remove']('');_0x16d613[_0x374659(0x673)]=DataManager[_0x374659(0xa9f)](_0xb13dc4);}}}}else _0x3354b5['removeImmortal'](),_0xa52167[_0x374659(0x909)](_0x13f8f0[_0x374659(0x1b1)]());}},Game_Enemy[_0x251720(0x97e)][_0x251720(0x3fe)]=function(){return this['_attackAnimationId']||0x0;},Game_Enemy['prototype'][_0x251720(0x439)]=function(){const _0x2b4b55=_0x251720;return this[_0x2b4b55(0x3fe)]();},Game_Enemy[_0x251720(0x97e)][_0x251720(0x5de)]=function(_0x4c7361){const _0x1fe6a0=_0x251720;return this[_0x1fe6a0(0x3fe)]();},Game_Enemy[_0x251720(0x97e)][_0x251720(0x10f)]=function(){const _0x5b8030=_0x251720;if(this['enemy']()[_0x5b8030(0x67f)][_0x5b8030(0x591)](/<BATTLER SPRITE CANNOT MOVE>/i))return![];return Game_Battler['prototype']['canBattlerMove']['call'](this);},Game_Enemy[_0x251720(0x97e)]['isBattlerGrounded']=function(){const _0x33653c=_0x251720;if(this[_0x33653c(0xa80)]()[_0x33653c(0x67f)][_0x33653c(0x591)](/<BATTLER SPRITE GROUNDED>/i))return!![];return![];},Game_Enemy['prototype']['skills']=function(){const _0xe44cc1=_0x251720,_0x31c357=[];for(const _0x3979d3 of this[_0xe44cc1(0xa80)]()[_0xe44cc1(0xa2f)]){if(_0xe44cc1(0x3ab)!==_0xe44cc1(0x5b0)){const _0x258ae2=$dataSkills[_0x3979d3['skillId']];if(_0x258ae2&&!_0x31c357[_0xe44cc1(0x9b0)](_0x258ae2))_0x31c357[_0xe44cc1(0x141)](_0x258ae2);}else _0x2ce475[_0xe44cc1(0x141)](_0x2fcfde['trueRandomTarget']());}return _0x31c357;},Game_Enemy['prototype'][_0x251720(0x9a9)]=function(){const _0x3152e9=_0x251720;let _0x428c0b='battleUIOffsetX';if(this['checkCacheKey'](_0x428c0b))return this[_0x3152e9(0x4d7)][_0x428c0b];return this['_cache'][_0x428c0b]=this['createBattleUIOffsetX'](this[_0x3152e9(0xa80)]()),this[_0x3152e9(0x4d7)][_0x428c0b];},Game_Enemy[_0x251720(0x97e)][_0x251720(0x36e)]=function(){const _0x1b5e5b=_0x251720;let _0x1d610c=_0x1b5e5b(0x36e);if(this[_0x1b5e5b(0x947)](_0x1d610c))return this['_cache'][_0x1d610c];return this[_0x1b5e5b(0x4d7)][_0x1d610c]=this[_0x1b5e5b(0x4a3)](this['enemy']()),this[_0x1b5e5b(0x4d7)][_0x1d610c];},Game_Enemy[_0x251720(0x97e)]['svBattlerData']=function(){const _0x5d084f=_0x251720;if(this[_0x5d084f(0x76a)]!==undefined)return this[_0x5d084f(0x76a)];return this[_0x5d084f(0x573)](),this[_0x5d084f(0x76a)];},Game_Enemy[_0x251720(0x97e)][_0x251720(0x87d)]=function(){const _0x46119b=_0x251720;return this[_0x46119b(0x690)]()[_0x46119b(0x1f8)]!=='';},Game_Enemy['prototype'][_0x251720(0x502)]=function(){const _0x49a7e9=_0x251720;return this['svBattlerData']()[_0x49a7e9(0x1f8)];},Game_Enemy[_0x251720(0x97e)][_0x251720(0x26c)]=function(){const _0x49d0e2=_0x251720;if(this[_0x49d0e2(0x87d)]())return VisuMZ[_0x49d0e2(0x731)]['Settings'][_0x49d0e2(0x98)][_0x49d0e2(0x55c)];else{if(_0x49d0e2(0x1e4)!==_0x49d0e2(0x25e))return VisuMZ[_0x49d0e2(0x731)][_0x49d0e2(0x825)]['Enemy'][_0x49d0e2(0x55c)];else _0x513681[_0x49d0e2(0x60e)](_0x49d0e2(0x5f7));}},Game_Enemy[_0x251720(0x97e)][_0x251720(0x702)]=function(_0x66be3a){const _0x366baf=_0x251720;Game_Battler['prototype'][_0x366baf(0x702)][_0x366baf(0xa57)](this,_0x66be3a);if(this[_0x366baf(0x87d)]())this[_0x366baf(0x458)](_0x66be3a);},Game_Enemy[_0x251720(0x97e)][_0x251720(0x62e)]=function(){const _0x382fec=_0x251720,_0x272f6f=this[_0x382fec(0x690)]()['wtypeId']||0x0,_0xde5f63=$dataSystem[_0x382fec(0x65f)][_0x272f6f];if(_0xde5f63){if(_0xde5f63['type']===0x0)_0x382fec(0x9a0)==='lYKKK'?this[_0x382fec(0x8e4)](_0x273d71,_0x558180):this[_0x382fec(0x995)](_0x382fec(0x1c8));else{if(_0xde5f63[_0x382fec(0x74e)]===0x1){if(_0x382fec(0x8ee)===_0x382fec(0x75c)){const _0x3986a5=_0x8d8d06[_0x382fec(0x342)]();this[_0x382fec(0xa27)](_0x425987,_0x3986a5),this['push']('applyImmortal',_0x4383fe,_0x4dc15a,!![]),this[_0x382fec(0x141)](_0x382fec(0x7bb),_0x27187,_0x1cbc04),this[_0x382fec(0x141)](_0x382fec(0x766)),this[_0x382fec(0x141)](_0x382fec(0xb1),_0x4553ca,_0x468197),this[_0x382fec(0x141)](_0x382fec(0x797));}else this[_0x382fec(0x995)](_0x382fec(0x389));}else _0xde5f63[_0x382fec(0x74e)]===0x2&&this[_0x382fec(0x995)](_0x382fec(0x25c));}}},Game_Enemy[_0x251720(0x97e)][_0x251720(0xa60)]=function(){const _0x301697=_0x251720,_0x27820f=this[_0x301697(0x690)]()[_0x301697(0x87c)]||0x0,_0x4c84c4=$dataSystem[_0x301697(0x65f)][_0x27820f];if(_0x4c84c4){if(_0x301697(0x836)==='GWlIq')this['startWeaponAnimation'](_0x4c84c4[_0x301697(0x9e8)]);else return _0x270885[_0x301697(0x6cc)]-_0x372278[_0x301697(0x6cc)];}},Game_Enemy[_0x251720(0x97e)][_0x251720(0x8ae)]=function(){const _0x4f90f2=_0x251720,_0x54d295=this['svBattlerData']()['wtypeId']||0x0;return $dataSystem[_0x4f90f2(0x65f)][_0x54d295];},Game_Enemy['prototype']['getAttackMotionSlot']=function(_0x2aee15){const _0x14ff53=_0x251720;return this[_0x14ff53(0x8ae)]();},Game_Enemy['prototype']['performDamage']=function(){const _0x2d72c2=_0x251720;Game_Battler[_0x2d72c2(0x97e)][_0x2d72c2(0x712)][_0x2d72c2(0xa57)](this),this[_0x2d72c2(0x9b3)]()&&this[_0x2d72c2(0x87d)]()&&this[_0x2d72c2(0x995)](_0x2d72c2(0x363)),SoundManager[_0x2d72c2(0x53a)]();},Game_Enemy[_0x251720(0x97e)][_0x251720(0x2c1)]=function(){const _0x5f095c=_0x251720;Game_Battler[_0x5f095c(0x97e)]['performEvasion'][_0x5f095c(0xa57)](this),this['requestMotion'](_0x5f095c(0x597));},Game_Enemy[_0x251720(0x97e)][_0x251720(0x6db)]=function(){const _0x3cd665=_0x251720;Game_Battler[_0x3cd665(0x97e)][_0x3cd665(0x6db)][_0x3cd665(0xa57)](this),this[_0x3cd665(0x995)]('evade');},Game_Enemy[_0x251720(0x97e)][_0x251720(0x508)]=function(){const _0x386986=_0x251720;Game_Battler['prototype'][_0x386986(0x508)]['call'](this),this['performAttack']();},Game_Enemy[_0x251720(0x97e)][_0x251720(0x86f)]=function(){const _0x4c8c04=_0x251720;if(this[_0x4c8c04(0x87d)]()){if('OedXa'!=='OedXa')this[_0x4c8c04(0x4d7)][_0x4c8c04(0x108)]=_0x5edcc9(_0x5c8f13['$1']),this[_0x4c8c04(0x4d7)][_0x4c8c04(0x611)]=_0x3419dd(_0x5e5401['$2']);else{if(this[_0x4c8c04(0x8d7)]()>=0x1)return!![];return this[_0x4c8c04(0x690)]()['collapse'];}}else return!![];},Game_Enemy['prototype']['svBattlerAnchorX']=function(){const _0x446094=_0x251720;return this[_0x446094(0x690)]()['anchorX'];},Game_Enemy[_0x251720(0x97e)][_0x251720(0x5fc)]=function(){const _0x4218fb=_0x251720;return this[_0x4218fb(0x690)]()[_0x4218fb(0x46f)];},Game_Enemy[_0x251720(0x97e)][_0x251720(0x199)]=function(){const _0x115b11=_0x251720;return this[_0x115b11(0x690)]()[_0x115b11(0x977)];},VisuMZ[_0x251720(0x731)]['Game_Enemy_transform']=Game_Enemy[_0x251720(0x97e)][_0x251720(0x457)],Game_Enemy[_0x251720(0x97e)]['transform']=function(_0x9cb09e){const _0xc129b8=_0x251720;VisuMZ['BattleCore'][_0xc129b8(0x257)][_0xc129b8(0xa57)](this,_0x9cb09e),this['clearBattleCoreData'](),this[_0xc129b8(0x573)]();const _0x3f709d=this[_0xc129b8(0x60a)]();if(_0x3f709d)_0x3f709d[_0xc129b8(0x200)](this);},Game_Unit[_0x251720(0x97e)][_0x251720(0xa55)]=function(_0x56c708){const _0x1278a1=_0x251720;for(const _0x4ca731 of this[_0x1278a1(0x991)]()){if(_0x1278a1(0xa3)!==_0x1278a1(0x460)){if(_0x4ca731)_0x4ca731[_0x1278a1(0xa55)](_0x56c708);}else{if(!_0xe3d2de[_0x1278a1(0x847)]())return;if(!_0x32725f[_0x1278a1(0x395)])return;if(!_0x49702c['_subject'])return;_0x4f1a4a[_0x1278a1(0xa0c)](_0x5ccd19,_0x423350);const _0x494df9=_0x3c7ac5[_0x1278a1(0x3a6)];_0x25d8ec[_0x1278a1(0x667)](_0x494df9,_0x332a0e[_0x1278a1(0x29b)]['toUseBoostPoints']());}}},Game_Unit[_0x251720(0x97e)][_0x251720(0x50d)]=function(){const _0x53deed=_0x251720,_0x18b9c4=this[_0x53deed(0x8ef)]();return _0x18b9c4[Math['randomInt'](_0x18b9c4[_0x53deed(0x988)])];},VisuMZ[_0x251720(0x731)][_0x251720(0x942)]=Game_Party[_0x251720(0x97e)]['addActor'],Game_Party['prototype'][_0x251720(0x87f)]=function(_0x58513a){const _0x49c712=_0x251720;VisuMZ[_0x49c712(0x731)][_0x49c712(0x942)][_0x49c712(0xa57)](this,_0x58513a),BattleManager[_0x49c712(0x4cc)]();},VisuMZ[_0x251720(0x731)][_0x251720(0x39e)]=Game_Party['prototype'][_0x251720(0x62d)],Game_Party[_0x251720(0x97e)][_0x251720(0x62d)]=function(_0x2ecaff){const _0x458d68=_0x251720;VisuMZ[_0x458d68(0x731)][_0x458d68(0x39e)][_0x458d68(0xa57)](this,_0x2ecaff),BattleManager[_0x458d68(0x4cc)]();},VisuMZ[_0x251720(0x731)]['Game_Troop_setup']=Game_Troop[_0x251720(0x97e)][_0x251720(0x1ea)],Game_Troop[_0x251720(0x97e)][_0x251720(0x1ea)]=function(_0x3e0941){const _0x273cc0=_0x251720;$gameTemp[_0x273cc0(0x86c)](),$gameTemp['applyForcedGameTroopSettingsBattleCore'](_0x3e0941),VisuMZ['BattleCore'][_0x273cc0(0x9c)][_0x273cc0(0xa57)](this,_0x3e0941);},VisuMZ['BattleCore']['Game_Troop_expTotal']=Game_Troop[_0x251720(0x97e)][_0x251720(0x827)],Game_Troop[_0x251720(0x97e)][_0x251720(0x827)]=function(){const _0x1af762=_0x251720;let _0x5cfc34=VisuMZ[_0x1af762(0x731)]['Game_Troop_expTotal']['call'](this);return this['expRate']&&(_0x5cfc34*=this[_0x1af762(0x4db)]()),Math[_0x1af762(0x4a0)](_0x5cfc34);},Game_Troop[_0x251720(0x97e)][_0x251720(0x4db)]=function(){return 0x1;},VisuMZ[_0x251720(0x731)][_0x251720(0x445)]=Game_Map[_0x251720(0x97e)][_0x251720(0x507)],Game_Map[_0x251720(0x97e)][_0x251720(0x507)]=function(){const _0x2b6373=_0x251720;VisuMZ[_0x2b6373(0x731)][_0x2b6373(0x445)][_0x2b6373(0xa57)](this),this[_0x2b6373(0x1e9)]();},Game_Map['prototype']['setupBattlebackBattleCore']=function(){const _0x54d50f=_0x251720;this['_regionBattleback1']={},this[_0x54d50f(0x187)]={};if(!$dataMap)return;const _0x14dc0c=$dataMap[_0x54d50f(0x67f)];if(!_0x14dc0c)return;const _0x36e59f=_0x14dc0c[_0x54d50f(0x591)](/<REGION (\d+) BATTLEBACK(\d+): (.*)>/gi);if(_0x36e59f)for(const _0x126d9a of _0x36e59f){_0x126d9a[_0x54d50f(0x591)](/<REGION (\d+) BATTLEBACK(\d+): (.*)>/i);const _0x1f2498=Number(RegExp['$1']),_0x2dfba3=Number(RegExp['$2']),_0x5d53b3=_0x2dfba3===0x1?this['_regionBattleback1']:this['_regionBattleback2'],_0x1832f1=String(RegExp['$3']);_0x5d53b3[_0x1f2498]=_0x1832f1;}},VisuMZ[_0x251720(0x731)][_0x251720(0x9e6)]=Game_Map[_0x251720(0x97e)][_0x251720(0x126)],Game_Map[_0x251720(0x97e)][_0x251720(0x126)]=function(){const _0x3005b0=_0x251720;if(!BattleManager[_0x3005b0(0x220)]()){if(_0x3005b0(0x63b)!==_0x3005b0(0x286)){const _0x1f39ae=$gamePlayer[_0x3005b0(0x71f)]($gamePlayer['x'],$gamePlayer['y']);if(this[_0x3005b0(0x1c5)]&&this['_regionBattleback1'][_0x1f39ae])return this['_regionBattleback1'][_0x1f39ae];}else this[_0x3005b0(0x6f5)]=![];}return VisuMZ[_0x3005b0(0x731)][_0x3005b0(0x9e6)][_0x3005b0(0xa57)](this);},VisuMZ['BattleCore']['Game_Map_battleback2Name']=Game_Map[_0x251720(0x97e)][_0x251720(0x908)],Game_Map[_0x251720(0x97e)]['battleback2Name']=function(){const _0x419ccb=_0x251720;if(!BattleManager[_0x419ccb(0x220)]()){if(_0x419ccb(0x36a)===_0x419ccb(0x5ac))this[_0x419ccb(0x461)]();else{const _0x35c186=$gamePlayer['regionId']($gamePlayer['x'],$gamePlayer['y']);if(this[_0x419ccb(0x1c5)]&&this['_regionBattleback2'][_0x35c186])return _0x419ccb(0x6d0)!==_0x419ccb(0x6d0)?_0x4739bc(_0x362dfa['$1'])*0.01:this['_regionBattleback2'][_0x35c186];}}return VisuMZ[_0x419ccb(0x731)][_0x419ccb(0xa93)][_0x419ccb(0xa57)](this);},VisuMZ['BattleCore'][_0x251720(0x13c)]=Game_Map[_0x251720(0x97e)][_0x251720(0x5ab)],Game_Map[_0x251720(0x97e)][_0x251720(0x5ab)]=function(){const _0x1cfd66=_0x251720;let _0x2d5308=JsonEx[_0x1cfd66(0xa1d)](VisuMZ[_0x1cfd66(0x731)][_0x1cfd66(0x13c)][_0x1cfd66(0xa57)](this));return VisuMZ[_0x1cfd66(0x731)]['ShuffleArray'](_0x2d5308);},VisuMZ['BattleCore'][_0x251720(0x390)]=function(_0x1eb91c){const _0x2faca6=_0x251720;var _0x293cb8,_0x348ea5,_0x31561e;for(_0x31561e=_0x1eb91c[_0x2faca6(0x988)]-0x1;_0x31561e>0x0;_0x31561e--){_0x293cb8=Math[_0x2faca6(0x570)](Math['random']()*(_0x31561e+0x1)),_0x348ea5=_0x1eb91c[_0x31561e],_0x1eb91c[_0x31561e]=_0x1eb91c[_0x293cb8],_0x1eb91c[_0x293cb8]=_0x348ea5;}return _0x1eb91c;},VisuMZ[_0x251720(0x731)][_0x251720(0x171)]=Game_Interpreter[_0x251720(0x97e)][_0x251720(0x97)],Game_Interpreter[_0x251720(0x97e)]['command357']=function(_0x49e396){const _0xc9cbd7=_0x251720;return $gameTemp[_0xc9cbd7(0x686)](this),VisuMZ[_0xc9cbd7(0x731)]['Game_Interpreter_PluginCommand']['call'](this,_0x49e396);},VisuMZ[_0x251720(0x731)]['Game_Interpreter_updateWaitMode']=Game_Interpreter['prototype'][_0x251720(0x2ec)],Game_Interpreter[_0x251720(0x97e)][_0x251720(0x2ec)]=function(){const _0x2f59fb=_0x251720;if(SceneManager[_0x2f59fb(0x847)]())switch(this[_0x2f59fb(0x645)]){case _0x2f59fb(0x82e):if(Imported[_0x2f59fb(0x243)]){if(_0x2f59fb(0x795)===_0x2f59fb(0x7df))_0x4a0ec5[_0x2f59fb(0x731)]['Game_Actor_setup'][_0x2f59fb(0xa57)](this,_0x13c511),this['initBattlePortrait']();else{if($gameScreen[_0x2f59fb(0x623)]()[_0x2f59fb(0x738)]>0x0)return!![];this[_0x2f59fb(0x645)]='';}}break;case _0x2f59fb(0x3d8):if(BattleManager[_0x2f59fb(0x742)][_0x2f59fb(0x82d)]())return!![];this[_0x2f59fb(0x645)]='';break;case _0x2f59fb(0x828):if(Imported['VisuMZ_3_ActSeqCamera']){if($gameScreen[_0x2f59fb(0x623)]()['cameraDuration']>0x0)return!![];if($gameScreen[_0x2f59fb(0x623)]()[_0x2f59fb(0x665)]>0x0)return!![];this[_0x2f59fb(0x645)]='';}break;case _0x2f59fb(0x260):if(BattleManager[_0x2f59fb(0x742)][_0x2f59fb(0x7dd)]())return!![];this[_0x2f59fb(0x645)]='';break;case _0x2f59fb(0x202):if(BattleManager[_0x2f59fb(0x742)][_0x2f59fb(0x726)]())return!![];this[_0x2f59fb(0x645)]='';break;case _0x2f59fb(0xbb):if(BattleManager[_0x2f59fb(0x742)][_0x2f59fb(0x378)]())return!![];this[_0x2f59fb(0x645)]='';break;case'battlelog':if(BattleManager[_0x2f59fb(0x1cb)]['isBusy']())return!![];this[_0x2f59fb(0x645)]='';break;case _0x2f59fb(0x3cc):if(BattleManager[_0x2f59fb(0x742)][_0x2f59fb(0x94)]())return!![];this['_waitMode']='';break;case'battleOpacity':if(BattleManager['_spriteset'][_0x2f59fb(0x78e)]())return!![];this[_0x2f59fb(0x645)]='';break;case'battleGrow':if(BattleManager[_0x2f59fb(0x742)][_0x2f59fb(0x9c1)]())return!![];this['_waitMode']='';break;case _0x2f59fb(0x758):if(BattleManager[_0x2f59fb(0x742)][_0x2f59fb(0x4ac)]())return!![];this['_waitMode']='';break;case'battleProjectiles':if(Imported[_0x2f59fb(0x46a)]){if(BattleManager[_0x2f59fb(0x742)]['isAnyProjectilePresent']())return!![];this[_0x2f59fb(0x645)]='';}break;case _0x2f59fb(0xeb):if(Imported['VisuMZ_3_ActSeqCamera']){if($gameScreen[_0x2f59fb(0x623)]()[_0x2f59fb(0x2a9)]>0x0)return!![];this[_0x2f59fb(0x645)]='';}break;case'battleSpin':if(BattleManager[_0x2f59fb(0x742)][_0x2f59fb(0x45e)]())return!![];this[_0x2f59fb(0x645)]='';break;case _0x2f59fb(0x684):if(Imported[_0x2f59fb(0x243)]){if($gameScreen[_0x2f59fb(0x623)]()['zoomDuration']>0x0)return!![];this['_waitMode']='';}break;}return VisuMZ[_0x2f59fb(0x731)][_0x2f59fb(0x7f1)][_0x2f59fb(0xa57)](this);},VisuMZ[_0x251720(0x731)][_0x251720(0x19a)]=Game_Interpreter[_0x251720(0x97e)]['command301'],Game_Interpreter['prototype'][_0x251720(0x8ea)]=function(_0x53e8e7){const _0x5ca3cd=_0x251720;return!$gameParty[_0x5ca3cd(0x56a)]()?this[_0x5ca3cd(0x19b)](_0x53e8e7):VisuMZ[_0x5ca3cd(0x731)][_0x5ca3cd(0x19a)][_0x5ca3cd(0xa57)](this,_0x53e8e7);},Game_Interpreter['prototype'][_0x251720(0x9d4)]=function(_0x54ce43){const _0x16d3ba=_0x251720;return VisuMZ[_0x16d3ba(0x731)][_0x16d3ba(0x19a)][_0x16d3ba(0xa57)](this,_0x54ce43),BattleManager[_0x16d3ba(0x9c8)](_0x156e81=>{const _0x498e64=_0x16d3ba;this['_branch'][this[_0x498e64(0x8ac)]]=_0x156e81;}),!![];},VisuMZ[_0x251720(0x731)]['CheckMapBattleEventValid']=function(_0x51484b){const _0x4bed36=_0x251720,_0x98f648=$dataCommonEvents[_0x51484b];if(!_0x98f648)return![];if(_0x98f648[_0x4bed36(0x855)][_0x4bed36(0x988)]<=0x1)return![];return!![];},Game_Interpreter[_0x251720(0x97e)][_0x251720(0x19b)]=function(_0x5a6414){const _0x3263eb=_0x251720,_0x28a043=VisuMZ['BattleCore']['Settings'][_0x3263eb(0xa38)],_0x7a73a6=_0x28a043[_0x3263eb(0x94f)],_0x3142e6=$dataCommonEvents[_0x7a73a6];if(_0x3142e6&&VisuMZ['BattleCore'][_0x3263eb(0x369)](_0x7a73a6)){const _0x4e5290=this[_0x3263eb(0x1a4)]()?this[_0x3263eb(0x285)]:0x0,_0x47f9e3=_0x3142e6[_0x3263eb(0x855)];this['setupChild'](_0x47f9e3,_0x4e5290),this['_list']=JsonEx[_0x3263eb(0xa1d)](this[_0x3263eb(0x619)]);const _0x348188={'code':0xbc3,'indent':this[_0x3263eb(0x8ac)],'parameters':JsonEx['makeDeepCopy'](_0x5a6414)};return this[_0x3263eb(0x619)][_0x3263eb(0xa81)](this[_0x3263eb(0x868)]+0x1,0x0,_0x348188),!![];}else{if(_0x3263eb(0x7bf)!==_0x3263eb(0x7c0))return VisuMZ[_0x3263eb(0x731)][_0x3263eb(0x19a)]['call'](this,_0x5a6414);else this[_0x3263eb(0x9d9)](0x1);}},VisuMZ[_0x251720(0x731)][_0x251720(0x800)]=BattleManager[_0x251720(0x319)],BattleManager[_0x251720(0x319)]=function(){const _0x4c1344=_0x251720;VisuMZ['BattleCore']['BattleManager_onEncounter'][_0x4c1344(0xa57)](this),this[_0x4c1344(0x512)]();},BattleManager[_0x251720(0x512)]=function(){const _0xebbaf9=_0x251720,_0x54cfd2=VisuMZ['BattleCore'][_0xebbaf9(0x825)][_0xebbaf9(0xa38)],_0x277713=_0x54cfd2[_0xebbaf9(0x94f)];_0x277713&&VisuMZ[_0xebbaf9(0x731)][_0xebbaf9(0x369)](_0x277713)&&(this['_battleCoreBattleStartEvent']=!![],$gameTemp[_0xebbaf9(0x7e)](_0x54cfd2[_0xebbaf9(0x94f)]),$gameMap['updateInterpreter'](),$gameMap[_0xebbaf9(0x1ab)]['_preBattleCommonEvent']=!![]),_0x54cfd2[_0xebbaf9(0x401)]>0x0&&(this[_0xebbaf9(0x1fb)]=!![]);},VisuMZ[_0x251720(0x731)][_0x251720(0x31a)]=Scene_Map['prototype']['updateCallMenu'],Scene_Map[_0x251720(0x97e)][_0x251720(0x2a8)]=function(){const _0x43a7e0=_0x251720;if(BattleManager[_0x43a7e0(0xa73)])return;VisuMZ['BattleCore']['Scene_Map_updateCallMenu'][_0x43a7e0(0xa57)](this);},VisuMZ[_0x251720(0x731)]['Scene_Map_launchBattle']=Scene_Map[_0x251720(0x97e)][_0x251720(0xab6)],Scene_Map[_0x251720(0x97e)][_0x251720(0xab6)]=function(){const _0x4086fe=_0x251720;BattleManager[_0x4086fe(0xa73)]?this['battleCorePreBattleCommonEvent']():VisuMZ[_0x4086fe(0x731)][_0x4086fe(0x35d)][_0x4086fe(0xa57)](this);},Scene_Map[_0x251720(0x97e)][_0x251720(0x9d0)]=function(){const _0x460322=_0x251720;this[_0x460322(0x9b9)]=!![];},VisuMZ[_0x251720(0x731)]['SceneManager_isSceneChanging']=SceneManager[_0x251720(0x4f0)],SceneManager[_0x251720(0x4f0)]=function(){const _0x508b1d=_0x251720;if(BattleManager[_0x508b1d(0xa73)])return![];return VisuMZ[_0x508b1d(0x731)][_0x508b1d(0x709)]['call'](this);},VisuMZ[_0x251720(0x731)][_0x251720(0x6ef)]=Game_Interpreter[_0x251720(0x97e)][_0x251720(0x42f)],Game_Interpreter[_0x251720(0x97e)][_0x251720(0x42f)]=function(){const _0x15a4f3=_0x251720;VisuMZ['BattleCore'][_0x15a4f3(0x6ef)][_0x15a4f3(0xa57)](this),this['_preBattleCommonEvent']&&(this[_0x15a4f3(0xf8)]=undefined,SceneManager[_0x15a4f3(0x35b)][_0x15a4f3(0x84c)]());},Scene_Map[_0x251720(0x97e)][_0x251720(0x84c)]=function(){const _0x541dad=_0x251720;BattleManager[_0x541dad(0xa73)]=undefined,BattleManager[_0x541dad(0x6ad)]=!![],this[_0x541dad(0x2bd)]();},VisuMZ['BattleCore']['Scene_Map_initializeAfter']=Scene_Map[_0x251720(0x97e)]['initialize'],Scene_Map['prototype'][_0x251720(0x43e)]=function(){const _0x34bf5f=_0x251720;VisuMZ['BattleCore']['Scene_Map_initializeAfter'][_0x34bf5f(0xa57)](this),BattleManager[_0x34bf5f(0x6ad)]&&(this['_active']=!![],BattleManager[_0x34bf5f(0x6ad)]=undefined);},VisuMZ[_0x251720(0x731)][_0x251720(0xa78)]=Scene_Map['prototype']['initialize'],Scene_Map[_0x251720(0x97e)]['initialize']=function(){const _0x5e3ba1=_0x251720;VisuMZ[_0x5e3ba1(0x731)][_0x5e3ba1(0xa78)][_0x5e3ba1(0xa57)](this),$gameTemp[_0x5e3ba1(0x86c)]();},VisuMZ[_0x251720(0x731)][_0x251720(0x52f)]=Scene_ItemBase[_0x251720(0x97e)][_0x251720(0x770)],Scene_ItemBase['prototype'][_0x251720(0x770)]=function(){const _0x42221a=_0x251720;VisuMZ[_0x42221a(0x731)][_0x42221a(0x52f)][_0x42221a(0xa57)](this),this[_0x42221a(0x342)]()[_0x42221a(0x67f)][_0x42221a(0x591)](/<CUSTOM ACTION SEQUENCE>/i)&&(_0x42221a(0x4c7)!==_0x42221a(0x224)?$gameTemp[_0x42221a(0xaf)]=[]:_0x37cbcb[_0x42221a(0x667)](_0x4651f6[_0x42221a(0x66d)],![])),DataManager[_0x42221a(0xd2)](this['item']())&&(_0x42221a(0x88)==='bIskO'?(_0x4de0a0=_0x1959c8*this[_0x42221a(0x2e7)]['damageRate'],_0x93ef9+=this['_multipliers'][_0x42221a(0x1d5)]*(_0x4a0d7d>=0x0?0x1:-0x1),_0x4ba62e=this[_0x42221a(0x931)]('PreDamage%1JS',_0x28970d,_0x30cd78,![]),_0x343927=this[_0x42221a(0x4a5)](_0x54a925),_0x2bdc57=_0xb8b10[_0x42221a(0x3e4)](_0x3ccc18),this['_executedValue']=_0x2bf513,this['_totalValue']=this[_0x42221a(0x6d1)]||0x0,this[_0x42221a(0x6d1)]+=_0x7cf9ef,_0x4b075e['BattleCore'][_0x42221a(0x3f7)][_0x42221a(0xa57)](this,_0x238499,_0x59ccc6),this[_0x42221a(0x931)](_0x42221a(0x91),_0x15f41e,_0x445621,!![])):$gameTemp[_0x42221a(0xaf)]=[]);},VisuMZ[_0x251720(0x731)][_0x251720(0x1bb)]=Scene_Options[_0x251720(0x97e)][_0x251720(0x331)],Scene_Options[_0x251720(0x97e)]['maxCommands']=function(){const _0x30f2b1=_0x251720;let _0x14b0ac=VisuMZ[_0x30f2b1(0x731)][_0x30f2b1(0x1bb)]['call'](this);const _0x5a8ae4=VisuMZ['BattleCore'][_0x30f2b1(0x825)];if(_0x5a8ae4[_0x30f2b1(0x513)][_0x30f2b1(0x256)]&&_0x5a8ae4['AutoBattle']['AdjustRect'])_0x14b0ac+=0x2;if(_0x5a8ae4[_0x30f2b1(0x2df)][_0x30f2b1(0x256)]&&_0x5a8ae4[_0x30f2b1(0x2df)]['AdjustRect'])_0x14b0ac+=0x1;return _0x14b0ac;},VisuMZ[_0x251720(0x731)][_0x251720(0x1ad)]=Scene_Battle[_0x251720(0x97e)]['start'],Scene_Battle[_0x251720(0x97e)][_0x251720(0x143)]=function(){const _0x4c0838=_0x251720;if(SceneManager[_0x4c0838(0x9a)]()){if(_0x4c0838(0x935)!==_0x4c0838(0x235))Scene_Message[_0x4c0838(0x97e)]['start'][_0x4c0838(0xa57)](this),this[_0x4c0838(0x742)]&&this[_0x4c0838(0x742)]['update'](),BattleManager['_tpbSceneChangeCacheActor']&&(_0x4c0838(0x2a4)!=='WQqMC'?this[_0x4c0838(0xa1e)](_0x5f3cfe,_0x2de0bc,_0x4388dd):BattleManager[_0x4c0838(0xa41)]());else{if(this[_0x4c0838(0x4d7)][_0x4c0838(0x706)]!==_0x253714)return this[_0x4c0838(0x4d7)][_0x4c0838(0x706)];const _0x1ab547=/<DAMAGE CAP:[ ](\d+)>/i,_0x408d66=this['traitObjects']()[_0x4c0838(0x259)](_0x3f881d=>_0x3f881d&&_0x3f881d[_0x4c0838(0x67f)][_0x4c0838(0x591)](_0x1ab547)?_0x215c2a(_0x11ea2a['$1']):0x0);let _0x2265b5=_0x408d66['length']>0x0?_0x38b2da[_0x4c0838(0x79a)](..._0x408d66):0x0;if(_0x2265b5<=0x0)_0x2265b5=_0x956d1e[_0x4c0838(0x731)]['Settings'][_0x4c0838(0x2e1)]['DefaultHardCap'];return this[_0x4c0838(0x4d7)][_0x4c0838(0x706)]=_0x2265b5,this['_cache'][_0x4c0838(0x706)];}}else _0x4c0838(0x83)!==_0x4c0838(0x8c3)?VisuMZ[_0x4c0838(0x731)][_0x4c0838(0x1ad)][_0x4c0838(0xa57)](this):(this['_logWindow'][_0x4c0838(0x141)](_0x4c0838(0x84b),_0x11e177[_0x4c0838(0x902)][_0x4c0838(0x8d6)](_0x564182[_0x4c0838(0x1f8)]())),this['_logWindow']['push']('wait'));},VisuMZ[_0x251720(0x731)]['Scene_Battle_stop']=Scene_Battle[_0x251720(0x97e)]['stop'],Scene_Battle['prototype'][_0x251720(0x2bd)]=function(){const _0x2abf0e=_0x251720;SceneManager[_0x2abf0e(0xac5)]()?_0x2abf0e(0x54d)!=='LpAWk'?Scene_Message[_0x2abf0e(0x97e)][_0x2abf0e(0x2bd)]['call'](this):this[_0x2abf0e(0x8f9)]=0x0:VisuMZ['BattleCore']['Scene_Battle_stop'][_0x2abf0e(0xa57)](this);},VisuMZ['BattleCore'][_0x251720(0x491)]=Scene_Battle[_0x251720(0x97e)][_0x251720(0x42f)],Scene_Battle[_0x251720(0x97e)][_0x251720(0x42f)]=function(){const _0xb743e3=_0x251720;SceneManager[_0xb743e3(0xac5)]()?Scene_Message[_0xb743e3(0x97e)][_0xb743e3(0x42f)][_0xb743e3(0xa57)](this):VisuMZ[_0xb743e3(0x731)]['Scene_Battle_terminate'][_0xb743e3(0xa57)](this);},Scene_Battle[_0x251720(0x97e)][_0x251720(0x95a)]=function(){const _0x1526f1=_0x251720;if(ConfigManager[_0x1526f1(0x791)]&&ConfigManager[_0x1526f1(0x102)]!==undefined){if(_0x1526f1(0x5eb)!=='dXrzg')return ConfigManager[_0x1526f1(0x102)];else{if(!this[_0x1526f1(0x342)]()['damage']['critical'])return 0x0;let _0x552c26=_0x64573d[_0x1526f1(0x731)]['Settings']['Damage'][_0x1526f1(0x13d)]['call'](this,_0x53408b);return _0x552c26=this[_0x1526f1(0x2e7)]['criticalHitRate']*_0x552c26+this[_0x1526f1(0x2e7)][_0x1526f1(0xa72)],_0x552c26;}}else{if(this[_0x1526f1(0x5bf)]()==='border')return _0x1526f1(0x688)==='OVKyQ'?![]:_0x2f4cbe;else{return Scene_Message[_0x1526f1(0x97e)][_0x1526f1(0x95a)][_0x1526f1(0xa57)](this);;}}},VisuMZ[_0x251720(0x731)]['Scene_Battle_createAllWindows']=Scene_Battle['prototype'][_0x251720(0x448)],Scene_Battle[_0x251720(0x97e)][_0x251720(0x448)]=function(){const _0x13cd8b=_0x251720;this[_0x13cd8b(0x432)](),VisuMZ[_0x13cd8b(0x731)]['Scene_Battle_createAllWindows'][_0x13cd8b(0xa57)](this),this[_0x13cd8b(0x7ec)]();},VisuMZ[_0x251720(0x731)][_0x251720(0x637)]=Scene_Battle['prototype'][_0x251720(0x594)],Scene_Battle[_0x251720(0x97e)][_0x251720(0x594)]=function(){const _0x533a23=_0x251720;VisuMZ['BattleCore'][_0x533a23(0x637)]['call'](this),this[_0x533a23(0x5bf)]()===_0x533a23(0x9bc)&&this[_0x533a23(0x4df)]();},Scene_Battle[_0x251720(0x97e)][_0x251720(0xa7c)]=function(_0x2d4a53){const _0x11d253=_0x251720;if(_0x2d4a53){if('RbJQM'!==_0x11d253(0x20a))this[_0x11d253(0x290)]['x']=(Graphics[_0x11d253(0x139)]-Graphics[_0x11d253(0x13f)])/0x2,this[_0x11d253(0x290)]['y']=(Graphics[_0x11d253(0x442)]-Graphics['boxHeight'])/0x2;else{if(!_0x1cdfcf[_0x11d253(0x847)]())return;if(!_0x52d73e[_0x11d253(0x243)])return;_0x3777df[_0x11d253(0xa0c)](_0x3ce863,_0x66a0d6);const _0x2944f9=_0x297888['getLastPluginCommandInterpreter'](),_0x465549=_0x55e2d4[_0x11d253(0x9b2)];if(!_0x2944f9)return;_0x39160e[_0x11d253(0x4b2)](_0xc1aaaa['SkewX'],_0x19ec53[_0x11d253(0x382)],_0x16403b[_0x11d253(0x19f)],_0x5924ce[_0x11d253(0xc3)]);if(_0x465549)_0x2944f9[_0x11d253(0x1a1)](_0x11d253(0xeb));}}else this[_0x11d253(0x290)]['x']=Graphics[_0x11d253(0x139)]*0xa,this[_0x11d253(0x290)]['y']=Graphics[_0x11d253(0x442)]*0xa;},VisuMZ[_0x251720(0x731)]['Scene_Battle_selectNextCommand']=Scene_Battle[_0x251720(0x97e)][_0x251720(0x1da)],Scene_Battle[_0x251720(0x97e)]['selectNextCommand']=function(){const _0x2d5ef7=_0x251720,_0x571d11=BattleManager['actor']();VisuMZ[_0x2d5ef7(0x731)][_0x2d5ef7(0x996)]['call'](this);if(_0x571d11){if(_0x2d5ef7(0x5f5)!==_0x2d5ef7(0x5f5)){const _0xf23704=_0x339bb6[_0x2d5ef7(0x5e2)]()[_0x4028af],_0x1aa97e=new _0x360577();_0x1aa97e['moveToStartPositionBattleCore'](_0xf23704),_0x1aa97e['setBattler'](_0xf23704),_0x1aa97e['update'](),this[_0x2d5ef7(0x63d)][_0x2d5ef7(0x141)](_0x1aa97e),this[_0x2d5ef7(0xa12)][_0x2d5ef7(0x26f)](_0x1aa97e);}else{if(_0x571d11===BattleManager['actor']())return;if(_0x571d11===BattleManager['_subject'])return;if(_0x571d11[_0x2d5ef7(0x60a)]())_0x571d11[_0x2d5ef7(0x60a)]()['stepBack']();}}},VisuMZ[_0x251720(0x731)][_0x251720(0x55e)]=Scene_Battle[_0x251720(0x97e)][_0x251720(0x495)],Scene_Battle[_0x251720(0x97e)][_0x251720(0x495)]=function(){const _0x707b2e=_0x251720,_0x42d8d8=BattleManager[_0x707b2e(0x30d)]();if(_0x42d8d8&&_0x42d8d8[_0x707b2e(0x60a)])_0x42d8d8[_0x707b2e(0x60a)]()[_0x707b2e(0x6df)]();VisuMZ['BattleCore']['Scene_Battle_selectPreviousCommand'][_0x707b2e(0xa57)](this);},VisuMZ[_0x251720(0x731)][_0x251720(0x6fa)]=Scene_Battle[_0x251720(0x97e)]['logWindowRect'],Scene_Battle[_0x251720(0x97e)]['logWindowRect']=function(){const _0xdf6a39=_0x251720;if(VisuMZ[_0xdf6a39(0x731)][_0xdf6a39(0x825)][_0xdf6a39(0x8cf)][_0xdf6a39(0x3f4)])return VisuMZ[_0xdf6a39(0x731)][_0xdf6a39(0x825)][_0xdf6a39(0x8cf)][_0xdf6a39(0x3f4)]['call'](this);return VisuMZ[_0xdf6a39(0x731)][_0xdf6a39(0x6fa)][_0xdf6a39(0xa57)](this);},VisuMZ[_0x251720(0x731)]['Scene_Battle_createPartyCommandWindow']=Scene_Battle['prototype'][_0x251720(0x3ed)],Scene_Battle['prototype']['createPartyCommandWindow']=function(){const _0x1fb5de=_0x251720;VisuMZ['BattleCore'][_0x1fb5de(0x21c)][_0x1fb5de(0xa57)](this),this[_0x1fb5de(0x25d)]();},Scene_Battle[_0x251720(0x97e)][_0x251720(0x25d)]=function(){const _0x24f953=_0x251720,_0x571127=this[_0x24f953(0x71d)];_0x571127[_0x24f953(0x8f3)](_0x24f953(0x581),this[_0x24f953(0xa89)][_0x24f953(0x270)](this)),_0x571127[_0x24f953(0x8f3)](_0x24f953(0x918),this[_0x24f953(0x9ef)]['bind'](this));const _0x47ce4b=this[_0x24f953(0x5bf)]();switch(_0x47ce4b){case'xp':case _0x24f953(0x234):return this['_partyCommandWindow'][_0x24f953(0x334)](0x1);break;}},Scene_Battle[_0x251720(0x97e)]['commandAutoBattle']=function(){const _0xe0ad99=_0x251720;BattleManager[_0xe0ad99(0x8b7)]=!![],$gameParty[_0xe0ad99(0x644)](),this[_0xe0ad99(0x1da)](),BattleManager['isTpb']()&&(BattleManager[_0xe0ad99(0xaa8)]=![]);},Scene_Battle[_0x251720(0x97e)][_0x251720(0x9ef)]=function(){const _0x5e258e=_0x251720;this['isQueueOptionsMenu']()?(this['_callSceneOptions']=!![],this['_logWindow'][_0x5e258e(0x141)]('addText',VisuMZ['BattleCore'][_0x5e258e(0x825)][_0x5e258e(0x85f)][_0x5e258e(0x49a)])):_0x5e258e(0x802)==='WQgxs'?_0x5a62d0['prototype'][_0x5e258e(0x2bd)]['call'](this):this['callOptions']();},Scene_Battle[_0x251720(0x97e)][_0x251720(0x5d1)]=function(){return BattleManager['isActiveTpb']();},Scene_Battle['prototype'][_0x251720(0x777)]=function(){const _0x2ebc76=_0x251720;this[_0x2ebc76(0x905)]=![],this[_0x2ebc76(0x742)]['update'](),this[_0x2ebc76(0x290)][_0x2ebc76(0x499)]=![];if(BattleManager[_0x2ebc76(0x220)]())($dataSystem['battleback1Name']||$dataSystem[_0x2ebc76(0x908)])&&SceneManager[_0x2ebc76(0x4a1)]();else($gameMap['battleback1Name']()||$gameMap[_0x2ebc76(0x908)]())&&SceneManager[_0x2ebc76(0x4a1)]();SceneManager[_0x2ebc76(0x141)](Scene_Options),BattleManager['isTpb']()&&(_0x2ebc76(0x185)!==_0x2ebc76(0x185)?this[_0x2ebc76(0xf9)](_0x2ebc76(0x8bb)):BattleManager['_tpbSceneChangeCacheActor']=BattleManager[_0x2ebc76(0x30d)]());},VisuMZ[_0x251720(0x731)][_0x251720(0x67e)]=Scene_Battle['prototype'][_0x251720(0x69b)],Scene_Battle[_0x251720(0x97e)][_0x251720(0x69b)]=function(){const _0xe503df=_0x251720;VisuMZ[_0xe503df(0x731)][_0xe503df(0x67e)][_0xe503df(0xa57)](this);if(this[_0xe503df(0x905)]&&!BattleManager[_0xe503df(0x29b)])this[_0xe503df(0x777)]();},Scene_Battle[_0x251720(0x97e)][_0x251720(0x7ec)]=function(){const _0x2c0dc1=_0x251720,_0x827bc7=this[_0x2c0dc1(0x58d)]();this[_0x2c0dc1(0xa2c)]=new Window_AutoBattleCancel(_0x827bc7),this[_0x2c0dc1(0xa2c)]['hide'](),this['addChild'](this[_0x2c0dc1(0xa2c)]);},Scene_Battle[_0x251720(0x97e)][_0x251720(0x58d)]=function(){const _0x59a8e7=_0x251720;return VisuMZ[_0x59a8e7(0x731)][_0x59a8e7(0x825)][_0x59a8e7(0x513)][_0x59a8e7(0x4d6)][_0x59a8e7(0xa57)](this);},Scene_Battle[_0x251720(0x97e)][_0x251720(0x5f6)]=function(){const _0x185cfc=_0x251720;return VisuMZ[_0x185cfc(0x731)][_0x185cfc(0x825)][_0x185cfc(0x85f)][_0x185cfc(0xa35)];},VisuMZ[_0x251720(0x731)][_0x251720(0x324)]=Scene_Battle[_0x251720(0x97e)][_0x251720(0x877)],Scene_Battle['prototype']['startPartyCommandSelection']=function(){const _0x1f2050=_0x251720;if(this[_0x1f2050(0x5f6)]())this[_0x1f2050(0xbe)]();else{if(_0x1f2050(0x4b8)!==_0x1f2050(0x831))VisuMZ['BattleCore'][_0x1f2050(0x324)][_0x1f2050(0xa57)](this);else{_0x28358f-=_0x1e5928[_0x4a1871];if(_0x441405<=0x0)return _0x44fe1d;}}},Scene_Battle[_0x251720(0x97e)]['onDisabledPartyCommandSelection']=function(){const _0xaaf7ee=_0x251720;if(BattleManager[_0xaaf7ee(0x20d)]())_0xaaf7ee(0x9b1)!==_0xaaf7ee(0x9b1)?(_0x3ba929+=_0x5bdc0c,_0x46331a+=_0xf26f7a[_0xaaf7ee(0x4f2)]()?-_0xe2d969:_0x404b67):this[_0xaaf7ee(0x1da)]();else BattleManager[_0xaaf7ee(0xb2)]()&&VisuMZ[_0xaaf7ee(0x731)][_0xaaf7ee(0x324)][_0xaaf7ee(0xa57)](this);},VisuMZ['BattleCore'][_0x251720(0xa95)]=Scene_Battle[_0x251720(0x97e)][_0x251720(0x71a)],Scene_Battle[_0x251720(0x97e)]['commandFight']=function(){const _0x4b65ea=_0x251720;BattleManager[_0x4b65ea(0xb2)]()?(this['tpbCommandFight'](),this[_0x4b65ea(0xaab)]()):VisuMZ[_0x4b65ea(0x731)][_0x4b65ea(0xa95)]['call'](this);},Scene_Battle['prototype']['tpbCommandFight']=function(){const _0x34b281=_0x251720;if(!VisuMZ['BattleCore']['TpbActiveChangeEnabled'])return;if(Imported[_0x34b281(0x4be)]&&BattleManager[_0x34b281(0x524)]())return;const _0x38cc50=$gameParty[_0x34b281(0x8ef)]()[_0x34b281(0x778)](_0x520d61=>_0x520d61[_0x34b281(0x510)]()&&_0x520d61[_0x34b281(0x51b)]());BattleManager[_0x34b281(0x926)]=_0x38cc50[0x0]||null,BattleManager[_0x34b281(0x926)]&&BattleManager[_0x34b281(0x926)][_0x34b281(0x3bf)](_0x34b281(0x1ae));},VisuMZ['BattleCore']['Scene_Battle_createActorCommandWindow']=Scene_Battle['prototype']['createActorCommandWindow'],Scene_Battle['prototype'][_0x251720(0x191)]=function(){const _0x2b4a28=_0x251720;VisuMZ[_0x2b4a28(0x731)][_0x2b4a28(0xa75)][_0x2b4a28(0xa57)](this),this[_0x2b4a28(0x9be)]();},Scene_Battle[_0x251720(0x97e)][_0x251720(0x9be)]=function(){const _0x8e865=_0x251720,_0x25ee68=this[_0x8e865(0x6f1)];_0x25ee68[_0x8e865(0x8f3)](_0x8e865(0x5f1),this[_0x8e865(0x862)][_0x8e865(0x270)](this)),_0x25ee68[_0x8e865(0x8f3)]('autoBattle',this[_0x8e865(0x23a)][_0x8e865(0x270)](this)),_0x25ee68[_0x8e865(0x8f3)](_0x8e865(0x4eb),this[_0x8e865(0x8a0)][_0x8e865(0x270)](this));if(BattleManager[_0x8e865(0xb2)]()){if(this['isPartyCommandWindowDisabled']())delete _0x25ee68['_handlers'][_0x8e865(0x3da)];else{if('iEWRH'===_0x8e865(0x5c0)){if(_0x491d04[_0x8e865(0x176)]>_0x13805e)_0x29bfd0+=_0x1297ee[_0x8e865(0x139)]/0x2+_0x359c00;if(_0x2638fa[_0x8e865(0x176)]<_0x1ff45c)_0xdeeef9-=_0xc8d3bc[_0x8e865(0x139)]/0x2+_0x26287b;}else _0x25ee68['setHandler'](_0x8e865(0x3da),this['actorCommandCancelTPB'][_0x8e865(0x270)](this));}}},Scene_Battle[_0x251720(0x97e)]['actorCommandEscape']=function(){const _0x2abeea=_0x251720;this[_0x2abeea(0x944)]();},Scene_Battle[_0x251720(0x97e)][_0x251720(0x23a)]=function(){const _0x383798=_0x251720;BattleManager[_0x383798(0x30d)]()[_0x383798(0x625)](),BattleManager[_0x383798(0x8ab)](),BattleManager[_0x383798(0x37a)](),this[_0x383798(0x17e)]();},Scene_Battle[_0x251720(0x97e)]['actorCommandSingleSkill']=function(){const _0x5611e2=_0x251720,_0x987d2e=BattleManager[_0x5611e2(0x407)]();_0x987d2e['setSkill'](this[_0x5611e2(0x6f1)]['currentExt']()),this[_0x5611e2(0xfe)]();},Scene_Battle[_0x251720(0x97e)][_0x251720(0x61e)]=function(){const _0x5731ba=_0x251720;if(this['tpbActorSwitchConditionsMet']())this[_0x5731ba(0x48e)]();else{if(_0x5731ba(0x157)===_0x5731ba(0x157))this[_0x5731ba(0x226)]();else{const _0x17e510=_0x4e5bbc[_0x5731ba(0x731)][_0x5731ba(0x825)]['Mechanics'];_0x17e510['BattleEndEvent']&&_0x12fc71[_0x5731ba(0x731)][_0x5731ba(0x369)](_0x17e510[_0x5731ba(0x3c5)])&&_0x356e15['reserveCommonEvent'](_0x17e510[_0x5731ba(0x3c5)]);const _0x2d4701='%1Event'[_0x5731ba(0x8d6)](_0x181e7c);_0x17e510[_0x2d4701]&&_0x1426cb[_0x5731ba(0x731)][_0x5731ba(0x369)](_0x17e510[_0x2d4701])&&_0x22b012[_0x5731ba(0x7e)](_0x17e510[_0x2d4701]);}}},VisuMZ[_0x251720(0x731)][_0x251720(0x699)]=![],Scene_Battle['prototype'][_0x251720(0x74f)]=function(){const _0x3f82d6=_0x251720;if(Imported[_0x3f82d6(0x4be)]&&BattleManager['isCTB']()){if(_0x3f82d6(0x3a2)!==_0x3f82d6(0x5c5))return![];else _0x4e5f77[_0x3f82d6(0x65a)]([_0x56053f]);}else{if(!VisuMZ[_0x3f82d6(0x731)]['TpbActiveChangeEnabled'])return![];const _0x543ef4=$gameParty[_0x3f82d6(0x8ef)]()[_0x3f82d6(0x778)](_0x20e8ea=>_0x20e8ea['isTpbCharged']()&&_0x20e8ea[_0x3f82d6(0x51b)]());return _0x543ef4['length']>0x0&&BattleManager[_0x3f82d6(0x30d)]()!==_0x543ef4[_0x543ef4[_0x3f82d6(0x988)]-0x1];}},Scene_Battle['prototype']['performTpbActiveCheckSwitch']=function(){const _0x408f01=_0x251720,_0x5c44a7=BattleManager['actor'](),_0x1264f2=_0x5c44a7['battler']();if(_0x1264f2)_0x1264f2[_0x408f01(0x6df)]();const _0x1dddcc=$gameParty[_0x408f01(0x8ef)]()[_0x408f01(0x778)](_0x52804e=>_0x52804e[_0x408f01(0x510)]()&&_0x52804e[_0x408f01(0x51b)]()),_0x4905e3=_0x1dddcc[_0x408f01(0x2dd)](_0x5c44a7),_0x3c45d7=_0x1dddcc[_0x4905e3+0x1];BattleManager[_0x408f01(0x926)]=_0x3c45d7||null;if(_0x3c45d7)_0x3c45d7[_0x408f01(0x3bf)](_0x408f01(0x1ae));_0x5c44a7['setActionState'](_0x408f01(0x7f4)),this['changeInputWindow']();},Scene_Battle[_0x251720(0x97e)]['processActorCommandCancelTPB']=function(){const _0x3ec58f=_0x251720;this[_0x3ec58f(0x71d)][_0x3ec58f(0x1ea)](),this[_0x3ec58f(0x6f1)][_0x3ec58f(0x824)]();if(!VisuMZ[_0x3ec58f(0x731)]['TpbActiveChangeEnabled'])return;if(Imported[_0x3ec58f(0x4be)]&&BattleManager[_0x3ec58f(0x524)]())return;if(BattleManager[_0x3ec58f(0x926)]){if(_0x3ec58f(0x753)!=='AKAtt'){BattleManager[_0x3ec58f(0x926)][_0x3ec58f(0x3bf)](_0x3ec58f(0x7f4));const _0x4a67e1=BattleManager['_currentActor'][_0x3ec58f(0x60a)]();if(_0x4a67e1)_0x4a67e1[_0x3ec58f(0x6df)]();}else{const _0x591dab=_0x23a7b3[_0x3ec58f(0x67f)];if(_0x591dab[_0x3ec58f(0x591)](/<SIDEVIEW SHADOW (?:SCALE|SCALE X):[ ](\d+)([%％])>/i))return _0x4b6415(_0x52fad3['$1'])*0.01;else{if(_0x591dab[_0x3ec58f(0x591)](/<SIDEVIEW SHADOW (?:SCALE|SCALE X):[ ](.*)>/i))return _0x1329f(_0xea8c3b['$1'])||0x0;}}}BattleManager['_currentActor']=null;},VisuMZ[_0x251720(0x731)][_0x251720(0x675)]=Scene_Battle[_0x251720(0x97e)][_0x251720(0x132)],Scene_Battle['prototype'][_0x251720(0x132)]=function(){const _0x3156e1=_0x251720;VisuMZ[_0x3156e1(0x731)][_0x3156e1(0x675)][_0x3156e1(0xa57)](this),this['createHelpWindowBattleCore']();},Scene_Battle[_0x251720(0x97e)]['createHelpWindowBattleCore']=function(){const _0x350120=_0x251720;this[_0x350120(0x6f1)][_0x350120(0x3e3)](this[_0x350120(0xa96)]),this[_0x350120(0x71d)][_0x350120(0x3e3)](this['_helpWindow']);},Scene_Battle['prototype'][_0x251720(0x5bf)]=function(){const _0x3a99b9=_0x251720;if($gameTemp[_0x3a99b9(0xa0d)]!==undefined)return $gameTemp['_forcedBattleLayout'];if(this['_battleLayoutStyle']){if(_0x3a99b9(0x4c5)!=='hRiju')return this[_0x3a99b9(0x923)];else{if(!_0x1f1a20[_0x3a99b9(0x847)]())return![];if(!_0x422d84)return![];if(!_0x1e7528[_0x3a99b9(0x342)]())return![];if(_0x52e16f[_0x3a99b9(0x342)]()[_0x3a99b9(0x67f)][_0x3a99b9(0x591)](/<CUSTOM ACTION SEQUENCE>/i))return!![];if(_0x82d7e4[_0x3a99b9(0xd2)](_0x117000[_0x3a99b9(0x342)]()))return!![];return![];}}return this[_0x3a99b9(0x923)]=VisuMZ[_0x3a99b9(0x731)][_0x3a99b9(0x825)]['BattleLayout'][_0x3a99b9(0x692)][_0x3a99b9(0x612)]()[_0x3a99b9(0x30b)](),this[_0x3a99b9(0x923)]===_0x3a99b9(0x42b)&&!Imported[_0x3a99b9(0x9e4)]&&(this[_0x3a99b9(0x923)]=_0x3a99b9(0xa0f)),this[_0x3a99b9(0x923)];},VisuMZ['BattleCore'][_0x251720(0x956)]=Scene_Battle[_0x251720(0x97e)][_0x251720(0x57b)],Scene_Battle[_0x251720(0x97e)][_0x251720(0x57b)]=function(){const _0x396b8b=_0x251720,_0x41fcef=this['battleLayoutStyle']();switch(_0x41fcef){case _0x396b8b(0x855):return this[_0x396b8b(0x73d)](Math['max'](0x1,$gameParty['maxBattleMembers']()),!![]);break;default:return VisuMZ['BattleCore'][_0x396b8b(0x956)][_0x396b8b(0xa57)](this);break;}},VisuMZ[_0x251720(0x731)]['Scene_Battle_helpWindowRect']=Scene_Battle[_0x251720(0x97e)]['helpWindowRect'],Scene_Battle[_0x251720(0x97e)][_0x251720(0x8d0)]=function(){const _0x5d60d1=_0x251720,_0x47cb29=this[_0x5d60d1(0x5bf)]();switch(_0x47cb29){case _0x5d60d1(0x9bc):return this['helpWindowRectBorderStyle']();break;case'default':case _0x5d60d1(0x855):case'xp':case'portrait':default:return VisuMZ[_0x5d60d1(0x731)][_0x5d60d1(0x161)][_0x5d60d1(0xa57)](this);break;}},Scene_Battle[_0x251720(0x97e)][_0x251720(0x567)]=function(){const _0x3c157a=_0x251720,_0x1fbdaf=this[_0x3c157a(0x5bf)]();switch(_0x1fbdaf){case'xp':case _0x3c157a(0x234):return this[_0x3c157a(0x1b3)]();break;case _0x3c157a(0x9bc):return this[_0x3c157a(0x1f1)]();break;case _0x3c157a(0xa0f):case'list':default:return this[_0x3c157a(0x122)]();break;}},VisuMZ['BattleCore'][_0x251720(0x708)]=Scene_Battle[_0x251720(0x97e)][_0x251720(0x232)],Scene_Battle[_0x251720(0x97e)][_0x251720(0x232)]=function(){const _0x218410=_0x251720,_0x58d731=this[_0x218410(0x5bf)]();switch(_0x58d731){case'xp':case _0x218410(0x234):return this[_0x218410(0x16f)]();break;case _0x218410(0x9bc):return this[_0x218410(0x6cb)]();case'default':case'list':default:return this['partyCommandWindowRectDefaultStyle']();break;}},Scene_Battle['prototype'][_0x251720(0x317)]=function(){const _0x6b6fe1=_0x251720,_0x8de50b=VisuMZ['BattleCore'][_0x6b6fe1(0x825)][_0x6b6fe1(0x8ca)],_0x5b5280=_0x8de50b[_0x6b6fe1(0xac0)]||0xc0,_0x2c183b=this['windowAreaHeight'](),_0x1c87be=this['isRightInputMode']()?Graphics[_0x6b6fe1(0x13f)]-_0x5b5280:0x0,_0x2c623a=Graphics[_0x6b6fe1(0x635)]-_0x2c183b;return new Rectangle(_0x1c87be,_0x2c623a,_0x5b5280,_0x2c183b);},Scene_Battle[_0x251720(0x97e)][_0x251720(0x9f4)]=function(){const _0x8327e9=_0x251720;return this[_0x8327e9(0x232)]();},VisuMZ[_0x251720(0x731)][_0x251720(0x638)]=Scene_Battle[_0x251720(0x97e)]['updateStatusWindowPosition'],Scene_Battle[_0x251720(0x97e)][_0x251720(0x95e)]=function(){const _0x66aab2=_0x251720,_0x816d06=this[_0x66aab2(0x5bf)]();switch(_0x816d06){case'xp':case'portrait':case _0x66aab2(0x9bc):break;case _0x66aab2(0xa0f):case _0x66aab2(0x855):default:VisuMZ[_0x66aab2(0x731)][_0x66aab2(0x638)]['call'](this);break;}},VisuMZ[_0x251720(0x731)][_0x251720(0x737)]=Scene_Battle['prototype'][_0x251720(0x459)],Scene_Battle[_0x251720(0x97e)][_0x251720(0x459)]=function(){const _0x5eb332=_0x251720;VisuMZ[_0x5eb332(0x731)][_0x5eb332(0x737)][_0x5eb332(0xa57)](this),this[_0x5eb332(0x76c)]();},VisuMZ[_0x251720(0x731)]['Scene_Battle_startEnemySelection']=Scene_Battle[_0x251720(0x97e)][_0x251720(0xa9d)],Scene_Battle[_0x251720(0x97e)]['startEnemySelection']=function(){const _0x2c3778=_0x251720;VisuMZ['BattleCore'][_0x2c3778(0x3bc)][_0x2c3778(0xa57)](this),this['_enemyWindow'][_0x2c3778(0x558)](),this[_0x2c3778(0x76c)]();},Scene_Battle[_0x251720(0x97e)][_0x251720(0x76c)]=function(){const _0xe04170=_0x251720,_0x30776c=this[_0xe04170(0x5bf)]();['xp',_0xe04170(0x234),_0xe04170(0x9bc)]['includes'](_0x30776c)&&this['_actorCommandWindow'][_0xe04170(0x824)](),(_0x30776c==='border'||this[_0xe04170(0x370)]())&&(this[_0xe04170(0x24f)][_0xe04170(0x824)](),this[_0xe04170(0x215)][_0xe04170(0x824)]());},VisuMZ[_0x251720(0x731)]['Scene_Battle_onActorOk']=Scene_Battle[_0x251720(0x97e)][_0x251720(0x8b9)],Scene_Battle[_0x251720(0x97e)][_0x251720(0x8b9)]=function(){const _0x931270=_0x251720;VisuMZ[_0x931270(0x731)]['Scene_Battle_onActorOk']['call'](this),this[_0x931270(0x689)]();},Scene_Battle[_0x251720(0x97e)][_0x251720(0x798)]=function(){const _0x3a9c86=_0x251720;return[_0x3a9c86(0x6ff),_0x3a9c86(0x474),_0x3a9c86(0x4eb)][_0x3a9c86(0x9b0)](this[_0x3a9c86(0x6f1)][_0x3a9c86(0x8fa)]());},VisuMZ[_0x251720(0x731)]['Scene_Battle_onActorCancel']=Scene_Battle[_0x251720(0x97e)][_0x251720(0x1e0)],Scene_Battle[_0x251720(0x97e)][_0x251720(0x1e0)]=function(){const _0x2a4345=_0x251720;if(this[_0x2a4345(0x798)]()){if(_0x2a4345(0x598)!=='JIGLI')this[_0x2a4345(0xa7b)][_0x2a4345(0xa67)](),this['_actorWindow'][_0x2a4345(0x379)](),this[_0x2a4345(0x6f1)][_0x2a4345(0x77)]();else{const _0x2946e9=_0x224d44['indexOf'](_0x3a6842[_0x2a4345(0x62a)]()['trim']());_0x2946e9>=0x0&&_0x2946e9<=0x7&&_0xf6ab72[_0x2a4345(0x887)](_0x2946e9)&&_0xd4f91f['removeBuff'](_0x2946e9);}}else VisuMZ[_0x2a4345(0x731)][_0x2a4345(0x7fe)]['call'](this);this[_0x2a4345(0x21d)]();},VisuMZ[_0x251720(0x731)]['Scene_Battle_onEnemyOk']=Scene_Battle[_0x251720(0x97e)][_0x251720(0x1ee)],Scene_Battle[_0x251720(0x97e)][_0x251720(0x1ee)]=function(){const _0x3bfbda=_0x251720;VisuMZ['BattleCore']['Scene_Battle_onEnemyOk'][_0x3bfbda(0xa57)](this),this[_0x3bfbda(0x689)]();},VisuMZ['BattleCore'][_0x251720(0x4e8)]=Scene_Battle[_0x251720(0x97e)]['onEnemyCancel'],Scene_Battle[_0x251720(0x97e)][_0x251720(0x7f0)]=function(){const _0x1a42b5=_0x251720;this[_0x1a42b5(0x798)]()?(this[_0x1a42b5(0xa7b)]['show'](),this[_0x1a42b5(0x31c)][_0x1a42b5(0x379)](),this[_0x1a42b5(0x6f1)][_0x1a42b5(0x77)]()):_0x1a42b5(0x281)===_0x1a42b5(0x281)?VisuMZ[_0x1a42b5(0x731)][_0x1a42b5(0x4e8)][_0x1a42b5(0xa57)](this):this['requestMotion'](_0x1a42b5(0x363)),this['cancelTargetSelectionVisibility']();},Scene_Battle[_0x251720(0x97e)][_0x251720(0x689)]=function(){const _0x585859=_0x251720,_0x3d42db=this[_0x585859(0x5bf)]();(_0x3d42db==='border'||this['isSkillItemWindowsMiddle']())&&(this[_0x585859(0x24f)]['open'](),this[_0x585859(0x24f)][_0x585859(0xb4)]&&this[_0x585859(0x24f)][_0x585859(0xa67)](),this['_itemWindow'][_0x585859(0x2b2)](),this[_0x585859(0x215)][_0x585859(0xb4)]&&('IsQXC'==='CjExg'?_0x37d2de[_0x585859(0x731)]['ParseSkillNotetags']['call'](this,_0x515268):this[_0x585859(0x215)][_0x585859(0xa67)]()));},Scene_Battle[_0x251720(0x97e)][_0x251720(0x21d)]=function(){const _0x2192b4=_0x251720,_0x268160=this[_0x2192b4(0x5bf)]();['xp',_0x2192b4(0x234),_0x2192b4(0x9bc)]['includes'](_0x268160)&&(_0x2192b4(0x49c)!==_0x2192b4(0x49c)?_0x31ab7f[_0x2192b4(0x60e)](_0x2192b4(0x283)):this['_actorCommandWindow']['open']()),this[_0x2192b4(0x689)]();},Scene_Battle[_0x251720(0x97e)][_0x251720(0x122)]=function(){const _0x1133a1=_0x251720,_0x37376c=VisuMZ['BattleCore']['Settings'][_0x1133a1(0x8ca)],_0x46dec7=Window_BattleStatus[_0x1133a1(0x97e)][_0x1133a1(0x466)](),_0x4ef16c=Graphics[_0x1133a1(0x13f)]-(_0x37376c[_0x1133a1(0xac0)]||0xc0),_0x346ddf=this[_0x1133a1(0x57b)]()+_0x46dec7,_0x2efddb=this['isRightInputMode']()?0x0:Graphics[_0x1133a1(0x13f)]-_0x4ef16c,_0x184a21=Graphics[_0x1133a1(0x635)]-_0x346ddf+_0x46dec7;return new Rectangle(_0x2efddb,_0x184a21,_0x4ef16c,_0x346ddf);},Scene_Battle['prototype']['statusWindowRectXPStyle']=function(){const _0x478262=_0x251720,_0x1dff14=Window_BattleStatus['prototype'][_0x478262(0x466)](),_0x3f2f88=Graphics[_0x478262(0x13f)],_0x4c83e0=this[_0x478262(0x57b)]()+_0x1dff14,_0x3cb21f=0x0,_0x19d3e9=Graphics['boxHeight']-_0x4c83e0+_0x1dff14;return new Rectangle(_0x3cb21f,_0x19d3e9,_0x3f2f88,_0x4c83e0);},Scene_Battle['prototype'][_0x251720(0x16f)]=function(){const _0x48e9bb=_0x251720,_0x287b0c=Graphics['boxWidth']/0x2,_0x2c6d8c=this['calcWindowHeight'](VisuMZ[_0x48e9bb(0x731)]['Settings']['BattleLayout'][_0x48e9bb(0x383)],!![]),_0x44cef3=Math[_0x48e9bb(0x3e4)]((Graphics['boxWidth']-_0x287b0c)/0x2),_0x3823f9=Graphics[_0x48e9bb(0x635)]-_0x2c6d8c-this[_0x48e9bb(0x1b3)]()['height'];return new Rectangle(_0x44cef3,_0x3823f9,_0x287b0c,_0x2c6d8c);},Scene_Battle['prototype'][_0x251720(0x214)]=function(){const _0x49b63c=_0x251720,_0xc81cec=Graphics[_0x49b63c(0x139)],_0x30f5a0=Math[_0x49b63c(0x3e4)]((Graphics[_0x49b63c(0x13f)]-_0xc81cec)/0x2),_0x2832bc=this[_0x49b63c(0x5c9)](),_0xccebae=(Graphics['height']-Graphics['boxHeight'])/-0x2;return new Rectangle(_0x30f5a0,_0xccebae,_0xc81cec,_0x2832bc);},Scene_Battle[_0x251720(0x97e)][_0x251720(0x1f1)]=function(){const _0x1075f9=_0x251720,_0x40161d=Graphics[_0x1075f9(0x139)],_0x5c08f5=Math[_0x1075f9(0x3e4)]((Graphics['boxWidth']-_0x40161d)/0x2),_0x15269c=this[_0x1075f9(0x73d)](0x4,!![]),_0x29c0a1=Graphics[_0x1075f9(0x635)]-_0x15269c+(Graphics[_0x1075f9(0x442)]-Graphics[_0x1075f9(0x635)])/0x2;return new Rectangle(_0x5c08f5,_0x29c0a1,_0x40161d,_0x15269c);},Scene_Battle['prototype'][_0x251720(0x6cb)]=function(){const _0xf40898=_0x251720,_0x4cf53a=Math[_0xf40898(0x570)](Graphics[_0xf40898(0x139)]/0x3),_0x27b1f2=this['isRightInputMode']()?(Graphics['width']+Graphics[_0xf40898(0x13f)])/0x2-_0x4cf53a:(Graphics[_0xf40898(0x139)]-Graphics[_0xf40898(0x13f)])/-0x2,_0x5b1d86=this[_0xf40898(0x214)](),_0x53230d=_0x5b1d86['y']+_0x5b1d86[_0xf40898(0x442)],_0x14b01c=this['statusWindowRectBorderStyle'](),_0x3f163b=_0x14b01c['y']-_0x53230d;return new Rectangle(_0x27b1f2,_0x53230d,_0x4cf53a,_0x3f163b);},Scene_Battle[_0x251720(0x97e)]['skillItemWindowRectBorderStyle']=function(){const _0x163281=_0x251720,_0x48a810=Math[_0x163281(0x4a0)](Graphics['width']/0x3),_0x275004=Math[_0x163281(0x3e4)]((Graphics[_0x163281(0x13f)]-_0x48a810)/0x2),_0x260322=this[_0x163281(0x6cb)](),_0x25ef95=_0x260322['y'],_0x4f966d=_0x260322[_0x163281(0x442)];return new Rectangle(_0x275004,_0x25ef95,_0x48a810,_0x4f966d);},Scene_Battle['prototype'][_0x251720(0x4df)]=function(){const _0x5b5b23=_0x251720;this[_0x5b5b23(0x82b)]['y']=this['_helpWindow']['y']+this[_0x5b5b23(0xa96)][_0x5b5b23(0x442)],this[_0x5b5b23(0x95a)]()?this[_0x5b5b23(0x5bf)]()===_0x5b5b23(0x9bc)?this[_0x5b5b23(0x82b)]['x']=0x8:this[_0x5b5b23(0x82b)]['x']=-this[_0x5b5b23(0x82b)][_0x5b5b23(0x139)]-0x4:this[_0x5b5b23(0x82b)]['x']=Graphics[_0x5b5b23(0x139)]-(Graphics[_0x5b5b23(0x139)]-Graphics[_0x5b5b23(0x13f)])/0x2-this['_cancelButton'][_0x5b5b23(0x139)]-0x4;},VisuMZ[_0x251720(0x731)][_0x251720(0x8a3)]=Scene_Battle[_0x251720(0x97e)][_0x251720(0x7e9)],Scene_Battle[_0x251720(0x97e)][_0x251720(0x7e9)]=function(){const _0x5c9b99=_0x251720;if(this['battleLayoutStyle']()==='border')return this[_0x5c9b99(0x88f)]();else{if(this[_0x5c9b99(0x370)]()){if(_0x5c9b99(0x91d)!==_0x5c9b99(0x59b))return this['skillItemWindowRectMiddle']();else _0x37e0a7[_0x5c9b99(0x363)][_0x5c9b99(0x8f5)]=!![];}else return VisuMZ['BattleCore'][_0x5c9b99(0x8a3)][_0x5c9b99(0xa57)](this);}},VisuMZ[_0x251720(0x731)]['Scene_Battle_itemWindowRect']=Scene_Battle[_0x251720(0x97e)][_0x251720(0x992)],Scene_Battle[_0x251720(0x97e)]['itemWindowRect']=function(){const _0x9527c0=_0x251720;if(this[_0x9527c0(0x5bf)]()===_0x9527c0(0x9bc)){if(_0x9527c0(0xa4c)!==_0x9527c0(0x8e9))return this[_0x9527c0(0x88f)]();else this[_0x9527c0(0xa06)]='',this[_0x9527c0(0x30d)]()&&this[_0x9527c0(0x30d)]()[_0x9527c0(0x67f)][_0x9527c0(0x591)](/<BATTLE (?:IMAGE|PORTRAIT):[ ](.*)>/i)&&(this[_0x9527c0(0xa06)]=_0xd32484(_0x33f003['$1']));}else{if(this[_0x9527c0(0x370)]()){if(_0x9527c0(0x68c)==='GOQyZ')_0x1cebd6[_0x9527c0(0x6dd)](_0x5cd9c2[_0x9527c0(0xa5)]||'',_0x16a955[_0x9527c0(0x4c8)]||0x0);else return this[_0x9527c0(0x99e)]();}else return VisuMZ[_0x9527c0(0x731)][_0x9527c0(0x6ea)]['call'](this);}},Scene_Battle[_0x251720(0x97e)][_0x251720(0x370)]=function(){const _0x409c9f=_0x251720;return VisuMZ[_0x409c9f(0x731)][_0x409c9f(0x825)][_0x409c9f(0x8ca)][_0x409c9f(0x144)];},Scene_Battle['prototype'][_0x251720(0x99e)]=function(){const _0x27ca7e=_0x251720,_0x2de799=Sprite_Button[_0x27ca7e(0x97e)][_0x27ca7e(0x7ea)]()*0x2+0x4;let _0x17dc02=Graphics[_0x27ca7e(0x13f)]-_0x2de799;if(Imported[_0x27ca7e(0x7a8)]&&SceneManager[_0x27ca7e(0x31f)]()){if(_0x27ca7e(0x277)===_0x27ca7e(0x2ea))return _0x3ede7f[_0x27ca7e(0x366)]()['aliveMembers']()['filter'](_0x21d398=>_0x21d398!==_0x165ad5);else _0x17dc02+=_0x2de799;}const _0x1dc7d5=this[_0x27ca7e(0x78a)](),_0x272c5d=Graphics[_0x27ca7e(0x635)]-_0x1dc7d5-this[_0x27ca7e(0x567)]()[_0x27ca7e(0x442)]+Window_BattleStatus[_0x27ca7e(0x97e)]['extraHeight'](),_0x103519=0x0;return new Rectangle(_0x103519,_0x1dc7d5,_0x17dc02,_0x272c5d);},Scene_Battle[_0x251720(0x97e)]['createEnemyNameContainer']=function(){const _0xce2f08=_0x251720;if(!VisuMZ['BattleCore'][_0xce2f08(0x825)][_0xce2f08(0x3b1)][_0xce2f08(0x254)])return;this[_0xce2f08(0x50e)]=new Sprite(),this[_0xce2f08(0x50e)]['x']=this['_windowLayer']['x'],this[_0xce2f08(0x50e)]['y']=this['_windowLayer']['y'];const _0x3f2686=this['children']['indexOf'](this['_windowLayer']);this[_0xce2f08(0x7e3)](this[_0xce2f08(0x50e)],_0x3f2686);for(let _0x378c78=0x0;_0x378c78<0x8;_0x378c78++){const _0x3273d2=new Window_EnemyName(_0x378c78);this[_0xce2f08(0x50e)]['addChild'](_0x3273d2);}},Sprite_Battler[_0x251720(0x52a)]=VisuMZ[_0x251720(0x731)][_0x251720(0x825)][_0x251720(0x98)][_0x251720(0x387)],VisuMZ['BattleCore'][_0x251720(0x99b)]=Sprite_Battler[_0x251720(0x97e)][_0x251720(0x147)],Sprite_Battler['prototype'][_0x251720(0x147)]=function(){const _0x1bf371=_0x251720;VisuMZ[_0x1bf371(0x731)]['Sprite_Battler_initMembers'][_0x1bf371(0xa57)](this),this[_0x1bf371(0x158)]();if(this[_0x1bf371(0x8c)]===Sprite_Enemy)this[_0x1bf371(0x655)]();this[_0x1bf371(0x2cf)]();},Sprite_Battler[_0x251720(0x97e)]['initMembersBattleCore']=function(){const _0x3a4263=_0x251720;this[_0x3a4263(0x176)]=0x0,this[_0x3a4263(0x6cc)]=0x0,this[_0x3a4263(0x743)]=0x0,this[_0x3a4263(0x244)]=0x0,this[_0x3a4263(0x865)]=0x0,this[_0x3a4263(0x8d3)]=0x0,this[_0x3a4263(0x41b)]=_0x3a4263(0x59a),this[_0x3a4263(0xa91)]=0x0,this['_jumpMaxHeight']=0x0,this['_jumpDuration']=0x0,this[_0x3a4263(0x554)]=0x0,this[_0x3a4263(0x10c)]=0xff,this['_opacityDuration']=0x0,this['_opacityWholeDuration']=0x0,this[_0x3a4263(0x30a)]=_0x3a4263(0x59a),this[_0x3a4263(0x694)]=0x0,this[_0x3a4263(0x1aa)]=0x0,this[_0x3a4263(0x4aa)]=0x0,this[_0x3a4263(0x919)]=0x0,this[_0x3a4263(0x452)]=_0x3a4263(0x59a),this[_0x3a4263(0x167)]=!![],this[_0x3a4263(0x6b6)]=0x0,this['_skewY']=0x0,this[_0x3a4263(0x3c9)]=0x0,this[_0x3a4263(0x3ad)]=0x0,this['_skewDuration']=0x0,this[_0x3a4263(0x590)]=0x0,this[_0x3a4263(0xbc)]=_0x3a4263(0x59a),this['_growX']=0x1,this['_growY']=0x1,this[_0x3a4263(0xa86)]=0x1,this[_0x3a4263(0xcd)]=0x1,this[_0x3a4263(0x522)]=0x0,this[_0x3a4263(0x579)]=0x0,this[_0x3a4263(0x9cf)]=_0x3a4263(0x59a),this['_flipScaleX']=0x1;},Sprite_Battler[_0x251720(0x97e)]['createShadowSprite']=function(){const _0x308104=_0x251720;this[_0x308104(0x806)]=new Sprite(),this[_0x308104(0x806)][_0x308104(0x817)]=ImageManager[_0x308104(0x421)](_0x308104(0x5a7)),this[_0x308104(0x806)][_0x308104(0x817)][_0x308104(0x149)]=VisuMZ[_0x308104(0x731)][_0x308104(0x825)][_0x308104(0x98)][_0x308104(0x55c)],this[_0x308104(0x806)][_0x308104(0x48c)]['x']=0.5,this[_0x308104(0x806)][_0x308104(0x48c)]['y']=0.5,this[_0x308104(0x806)]['y']=-0x2,this['_shadowSprite'][_0x308104(0x499)]=![],this[_0x308104(0x26f)](this['_shadowSprite']);},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x2cf)]=function(){const _0x270a0d=_0x251720;this[_0x270a0d(0x316)]=new Sprite(),this['_distortionSprite']['anchor']['x']=0.5,this['_distortionSprite'][_0x270a0d(0x48c)]['y']=0.5,this[_0x270a0d(0x26f)](this[_0x270a0d(0x316)]);},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x5b7)]=function(){const _0x53253e=_0x251720;if(!this[_0x53253e(0x316)])return;if(this['_shadowSprite']){const _0x2ed094=this[_0x53253e(0x440)](this[_0x53253e(0x316)]);this[_0x53253e(0x7e3)](this[_0x53253e(0x806)],_0x2ed094),this[_0x53253e(0x5bd)]();}this[_0x53253e(0x5ce)]&&('VGJZc'!==_0x53253e(0x9d3)?this[_0x53253e(0x316)][_0x53253e(0x26f)](this[_0x53253e(0x5ce)]):_0x302c50-=_0x40cb5d[_0x53253e(0x1d6)]()/0x2),this[_0x53253e(0x488)]&&this[_0x53253e(0x316)][_0x53253e(0x26f)](this[_0x53253e(0x488)]),this['_mainSprite']&&this[_0x53253e(0x316)]['addChild'](this[_0x53253e(0xa7d)]),this['_dragonbonesSpriteContainer']&&this[_0x53253e(0x316)][_0x53253e(0x26f)](this[_0x53253e(0x44f)]);},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x5bd)]=function(){const _0x295c5a=_0x251720;if(!this[_0x295c5a(0x806)])return;if(this[_0x295c5a(0x397)]&&this[_0x295c5a(0x397)][_0x295c5a(0x199)]()){if('aUwCe'===_0x295c5a(0x10a)){const _0x101f8a=_0x598483[_0x295c5a(0x35b)][_0x295c5a(0xa7b)];if(_0x101f8a)_0x101f8a['refreshActorPortrait'](this);}else{const _0x3db9c9=this['_shadowSprite'][_0x295c5a(0x817)];this[_0x295c5a(0x806)][_0x295c5a(0x8c4)](0x0,0x0,_0x3db9c9['width'],_0x3db9c9[_0x295c5a(0x442)]);}}else this[_0x295c5a(0x806)][_0x295c5a(0x8c4)](0x0,0x0,0x0,0x0);},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x2f3)]=function(){const _0x1988e9=_0x251720;return SceneManager[_0x1988e9(0x847)]()?SceneManager['_scene']['_spriteset']['_damageContainer']:this[_0x1988e9(0x584)];},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x33c)]=function(_0x20ccef,_0x1f241a){const _0x58073f=_0x251720;if(!this[_0x58073f(0x397)][_0x58073f(0x9b3)]())return;const _0x41c781=VisuMZ['BattleCore'][_0x58073f(0x825)]['Damage'],_0xac9c75=new Sprite_Damage();_0xac9c75['_duration']=_0x41c781[_0x58073f(0xabb)],this[_0x58073f(0xa65)](_0xac9c75),_0xac9c75[_0x58073f(0x33c)](_0x20ccef,_0x1f241a),this['addDamageSprite'](_0xac9c75);},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x954)]=function(_0x1a2497,_0x1c86d0,_0x1a22e6){const _0x1d9f67=_0x251720;if(!this[_0x1d9f67(0x397)]['isSpriteVisible']())return;const _0x53f929=VisuMZ[_0x1d9f67(0x731)][_0x1d9f67(0x825)][_0x1d9f67(0x2e1)],_0x411503=new Sprite_Damage();_0x411503[_0x1d9f67(0x38d)]=_0x53f929[_0x1d9f67(0xabb)],this[_0x1d9f67(0xa65)](_0x411503),_0x411503[_0x1d9f67(0x954)](_0x1a2497,_0x1c86d0,_0x1a22e6),this['addDamageSprite'](_0x411503);},Sprite_Battler[_0x251720(0x97e)][_0x251720(0xad)]=function(){const _0x50cae0=_0x251720;if(!this['_battler']['isDamagePopupRequested']())return;while(this[_0x50cae0(0x397)][_0x50cae0(0x891)]()){_0x50cae0(0x69d)!==_0x50cae0(0x69d)?(_0x4cec07[_0x50cae0(0x436)](_0x1953e4,_0x1df5ce,_0x54663e,_0x3fff5b,_0x4d2e23,-0x1),this[_0x50cae0(0x648)]()):this[_0x50cae0(0x397)][_0x50cae0(0x9b3)]()&&this[_0x50cae0(0x476)]();}this['_battler'][_0x50cae0(0x6f6)](),this[_0x50cae0(0x397)][_0x50cae0(0x678)]();},Sprite_Battler['prototype'][_0x251720(0x476)]=function(){const _0x320177=_0x251720,_0x27ee80=VisuMZ[_0x320177(0x731)][_0x320177(0x825)][_0x320177(0x2e1)],_0x47d347=new Sprite_Damage();_0x47d347['_duration']=_0x27ee80[_0x320177(0xabb)],this[_0x320177(0xa65)](_0x47d347),_0x47d347['setup'](this[_0x320177(0x397)]),_0x47d347['setupBattleCore'](this[_0x320177(0x397)]),this[_0x320177(0x1bf)](_0x47d347);},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x1bf)]=function(_0x14b6f6){const _0xb0387c=_0x251720;this[_0xb0387c(0x5a8)][_0xb0387c(0x141)](_0x14b6f6);if(this[_0xb0387c(0x2ba)]()){if('FtBhX'!==_0xb0387c(0x321))SceneManager['_scene'][_0xb0387c(0xa7b)][_0xb0387c(0x1bf)](_0x14b6f6,this[_0xb0387c(0x397)]);else{if(this[_0xb0387c(0x30d)]()['note'][_0xb0387c(0x591)](/<BATTLE (?:IMAGE|PORTRAIT) OFFSET Y:[ ]([\+\-]\d+)>/i))return _0x46f20c(_0x41c12a['$1']);else{if(this['actor']()['note'][_0xb0387c(0x591)](/<BATTLE (?:IMAGE|PORTRAIT) OFFSET:[ ]([\+\-]\d+),[ ]([\+\-]\d+)>/i))return _0x4bea4b(_0x2e590d['$2']);}return 0x0;}}else{if(_0xb0387c(0x679)===_0xb0387c(0x679)){this[_0xb0387c(0x2f3)]()[_0xb0387c(0x26f)](_0x14b6f6);if(SceneManager[_0xb0387c(0x443)]())_0x14b6f6['scale']['x']=-0x1;}else return this[_0xb0387c(0x2db)]()&&!this['isCustomBattleScope']()?this[_0xb0387c(0x346)]():_0x321d57[_0xb0387c(0x731)]['Game_Action_isForOpponent'][_0xb0387c(0xa57)](this);}},Sprite_Battler['prototype']['isShownOnBattlePortrait']=function(){const _0x7d0216=_0x251720;return!$gameSystem[_0x7d0216(0x22c)]()&&this[_0x7d0216(0x397)]&&this[_0x7d0216(0x397)][_0x7d0216(0x4f2)]();},Sprite_Battler[_0x251720(0x97e)]['sortDamageSprites']=function(_0x2fee57){const _0x2452b1=_0x251720;this[_0x2452b1(0x610)](_0x2fee57,!![]);const _0x2f8c65=VisuMZ['BattleCore']['Settings'][_0x2452b1(0x2e1)],_0x42885d=SceneManager[_0x2452b1(0x443)]()?-0x1:0x1;if(_0x2f8c65['NewPopupBottom'])for(const _0x4b49ec of this[_0x2452b1(0x5a8)]){_0x4b49ec['x']+=_0x2f8c65[_0x2452b1(0x150)]*_0x42885d,_0x4b49ec['y']+=_0x2f8c65[_0x2452b1(0x5db)];}else{if(_0x2452b1(0x3de)===_0x2452b1(0x330)){if(!this[_0x2452b1(0x32a)])return;this['_lineHeight']=this[_0x2452b1(0x77b)]||_0x443ae0['prototype'][_0x2452b1(0x1d8)](),this['x']=this['_linkedSprite'][_0x2452b1(0x176)],this['y']=this[_0x2452b1(0x32a)][_0x2452b1(0x6cc)]-this['_lineHeight']*0.5;const _0x372904=_0x4d6ed0['BattleCore']['Settings'][_0x2452b1(0x3b1)];this['x']+=_0x372904['NameOffsetX']||0x0,this['y']+=_0x372904[_0x2452b1(0x672)]||0x0;}else{const _0x4acddb=this['_damages'][this['_damages'][_0x2452b1(0x988)]-0x1];if(_0x4acddb){if('egoho'!=='xHqkd')_0x2fee57['x']=_0x4acddb['x']+_0x2f8c65[_0x2452b1(0x150)]*_0x42885d,_0x2fee57['y']=_0x4acddb['y']+_0x2f8c65[_0x2452b1(0x5db)];else return this[_0x2452b1(0x606)](_0x1c7d72);}}}},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x610)]=function(_0xa3f1c4,_0x1dd3da){const _0x427423=_0x251720,_0x5d3014=SceneManager[_0x427423(0x443)]()?-0x1:0x1;let _0x2cc424=this[_0x427423(0x176)];_0x2cc424+=this['extraPositionX']();let _0xbe234c=this[_0x427423(0x6cc)];const _0x388bf6=this[_0x427423(0x316)]['scale']['y'];_0xbe234c+=this[_0x427423(0x780)]();const _0x2838e1=SceneManager[_0x427423(0x35b)][_0x427423(0xa7b)];if(_0x2838e1&&this[_0x427423(0x584)]===_0x2838e1){_0x2cc424+=_0x2838e1['x']-this[_0x427423(0x5b3)]();const _0x263b5a=_0x2838e1[_0x427423(0x1d8)]()*0x3/0x4;_0xbe234c=_0x2838e1['y']+_0x263b5a,_0xbe234c=Math[_0x427423(0x1c4)](_0xbe234c,_0x2838e1['y']+this['y']-this[_0x427423(0x442)]+_0x263b5a);}_0xa3f1c4['x']=Math['round'](_0x2cc424+this[_0x427423(0x5b3)]()*_0x5d3014),_0xa3f1c4['y']=Math[_0x427423(0x3e4)](_0xbe234c+this[_0x427423(0x14d)]());},VisuMZ[_0x251720(0x731)][_0x251720(0x296)]=Sprite_Battler[_0x251720(0x97e)][_0x251720(0x5b3)],Sprite_Battler['prototype']['damageOffsetX']=function(){const _0x4a7eaf=_0x251720;let _0x3e8de0=VisuMZ[_0x4a7eaf(0x731)][_0x4a7eaf(0x296)]['call'](this),_0x186fe3=VisuMZ[_0x4a7eaf(0x731)]['Settings']['Damage'][_0x4a7eaf(0x5da)]||0x0;return Math[_0x4a7eaf(0x3e4)](_0x3e8de0+_0x186fe3);},VisuMZ[_0x251720(0x731)][_0x251720(0x8eb)]=Sprite_Battler[_0x251720(0x97e)][_0x251720(0x14d)],Sprite_Battler['prototype'][_0x251720(0x14d)]=function(){const _0x711043=_0x251720;let _0x5c1bc7=VisuMZ[_0x711043(0x731)][_0x711043(0x8eb)][_0x711043(0xa57)](this);switch(VisuMZ[_0x711043(0x731)][_0x711043(0x825)][_0x711043(0x2e1)][_0x711043(0x62f)]){case _0x711043(0x2b1):_0x5c1bc7-=this[_0x711043(0x442)]*this[_0x711043(0x732)]['y'];break;case _0x711043(0x8cc):_0x5c1bc7-=this[_0x711043(0x442)]*this[_0x711043(0x732)]['y']*0.5;break;}let _0x469971=VisuMZ['BattleCore']['Settings'][_0x711043(0x2e1)][_0x711043(0x7f2)]||0x0;return Math[_0x711043(0x3e4)](_0x5c1bc7+_0x469971);},Sprite_Actor[_0x251720(0x97e)]['damageOffsetX']=function(){const _0x135cab=_0x251720;return Sprite_Battler[_0x135cab(0x97e)][_0x135cab(0x5b3)]['call'](this);},Sprite_Actor['prototype']['damageOffsetY']=function(){const _0x5cf6ae=_0x251720;return Sprite_Battler['prototype'][_0x5cf6ae(0x14d)][_0x5cf6ae(0xa57)](this);},Sprite_Battler['prototype']['destroyDamageSprite']=function(_0x46dfc7){const _0x218209=_0x251720;this[_0x218209(0x2ba)]()?SceneManager[_0x218209(0x35b)][_0x218209(0xa7b)][_0x218209(0xaa6)](_0x46dfc7):(this[_0x218209(0x2f3)]()[_0x218209(0x9d7)](_0x46dfc7),this[_0x218209(0x5a8)][_0x218209(0x39c)](_0x46dfc7),_0x46dfc7[_0x218209(0x8f)]());},VisuMZ[_0x251720(0x731)][_0x251720(0xc7)]=Sprite_Battler['prototype'][_0x251720(0x56b)],Sprite_Battler[_0x251720(0x97e)]['setHome']=function(_0x18d0db,_0x579884){const _0x3ac91c=_0x251720,_0x4732b0=VisuMZ[_0x3ac91c(0x731)][_0x3ac91c(0x825)];if(this['constructor']===Sprite_Actor)_0x18d0db+=_0x4732b0[_0x3ac91c(0x98)]['OffsetX']||0x0,_0x579884+=_0x4732b0[_0x3ac91c(0x98)][_0x3ac91c(0x3bb)]||0x0;else this[_0x3ac91c(0x8c)]===Sprite_Enemy&&(_0x3ac91c(0x79b)!=='rphFl'?(_0x18d0db+=_0x4732b0['Enemy']['OffsetX']||0x0,_0x579884+=_0x4732b0[_0x3ac91c(0x3b1)][_0x3ac91c(0x3bb)]||0x0):this[_0x3ac91c(0x4d7)][_0x3ac91c(0x416)]=![]);VisuMZ['BattleCore']['Sprite_Battler_setHome']['call'](this,_0x18d0db,_0x579884);},VisuMZ[_0x251720(0x731)][_0x251720(0x719)]=Sprite_Battler[_0x251720(0x97e)]['update'],Sprite_Battler['prototype'][_0x251720(0xc8)]=function(){const _0x3965e2=_0x251720;VisuMZ[_0x3965e2(0x731)]['Sprite_Battler_update'][_0x3965e2(0xa57)](this),!this[_0x3965e2(0x397)]&&this['_hpGaugeSprite']&&(this[_0x3965e2(0x818)][_0x3965e2(0x499)]=![]);},VisuMZ[_0x251720(0x731)][_0x251720(0x33e)]=Sprite_Battler[_0x251720(0x97e)][_0x251720(0x501)],Sprite_Battler[_0x251720(0x97e)][_0x251720(0x501)]=function(){const _0x35b4c5=_0x251720;this[_0x35b4c5(0x70)](),this['updateSkew'](),this[_0x35b4c5(0x154)](),this[_0x35b4c5(0x916)](),this['updateHpGaugePosition'](),VisuMZ[_0x35b4c5(0x731)][_0x35b4c5(0x33e)][_0x35b4c5(0xa57)](this);if(this[_0x35b4c5(0x8c)]===Sprite_Enemy)this['updateShadow']();},VisuMZ[_0x251720(0x731)][_0x251720(0x8c1)]=Sprite_Battler[_0x251720(0x97e)][_0x251720(0x6da)],Sprite_Battler[_0x251720(0x97e)][_0x251720(0x6da)]=function(){const _0x3986e6=_0x251720;VisuMZ[_0x3986e6(0x731)]['Sprite_Battler_updatePosition'][_0x3986e6(0xa57)](this),this[_0x3986e6(0x99a)](),this[_0x3986e6(0x10d)]();},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x99a)]=function(){const _0x23c732=_0x251720;this[_0x23c732(0x176)]=this['x'],this[_0x23c732(0x6cc)]=this['y'],this['updateFloat'](),this[_0x23c732(0xe5)](),this['x']+=this[_0x23c732(0x4ec)](),this['y']+=this[_0x23c732(0x780)](),this['y']+=this[_0x23c732(0x1f5)](),this['x']=Math[_0x23c732(0x570)](this['x']),this['y']=Math[_0x23c732(0x570)](this['y']);},Sprite_Battler[_0x251720(0x97e)]['extraPositionX']=function(){let _0x40aa95=0x0;return _0x40aa95;},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x780)]=function(){const _0x509fb5=_0x251720;let _0x4b7534=0x0;return this[_0x509fb5(0x397)]&&!this[_0x509fb5(0x397)][_0x509fb5(0x3d4)]()&&(_0x4b7534-=this[_0x509fb5(0x743)],_0x4b7534-=this[_0x509fb5(0xa91)]),_0x4b7534;},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x1f5)]=function(){const _0x8f9fa4=_0x251720;let _0x381f90=0x0;if(this[_0x8f9fa4(0x316)]&&this['constructor']!==Sprite_SvEnemy){const _0x339076=this[_0x8f9fa4(0x316)][_0x8f9fa4(0x732)]['y'];_0x381f90-=(_0x339076-0x1)*this[_0x8f9fa4(0x442)];}return _0x381f90;},Sprite_Battler['prototype'][_0x251720(0x916)]=function(){const _0x18d177=_0x251720,_0x121531=this[_0x18d177(0x397)]&&this[_0x18d177(0x397)][_0x18d177(0x660)]();this['_flipScaleX']=(_0x121531?-0x1:0x1)*Math[_0x18d177(0x7a)](this['scale']['x']);},Sprite_Battler['prototype'][_0x251720(0x43a)]=function(_0xc0a35d,_0xdb8660,_0x4be3a2){const _0x277ad7=_0x251720;if(!this[_0x277ad7(0xa42)]())return;if(this[_0x277ad7(0x244)]===_0xc0a35d)return;this['_targetFloatHeight']=_0xc0a35d,this[_0x277ad7(0x865)]=_0xdb8660,this[_0x277ad7(0x8d3)]=_0xdb8660,this['_floatEasing']=_0x4be3a2||_0x277ad7(0x59a);if(_0xdb8660<=0x0)this[_0x277ad7(0x743)]=_0xc0a35d;},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x18a)]=function(){const _0x3f41b7=_0x251720;if(this['_floatDuration']<=0x0)return;const _0x2525c2=this[_0x3f41b7(0x865)],_0x1ec68a=this[_0x3f41b7(0x8d3)],_0x2ced0f=this[_0x3f41b7(0x41b)];if(Imported['VisuMZ_0_CoreEngine']){if(_0x3f41b7(0x653)===_0x3f41b7(0x653))this['_floatHeight']=this[_0x3f41b7(0xa94)](this['_floatHeight'],this[_0x3f41b7(0x244)],_0x2525c2,_0x1ec68a,_0x2ced0f);else return this[_0x3f41b7(0x60d)](_0x2c5086);}else this[_0x3f41b7(0x743)]=(this['_floatHeight']*(_0x2525c2-0x1)+this[_0x3f41b7(0x244)])/_0x2525c2;this[_0x3f41b7(0x865)]--;if(this[_0x3f41b7(0x865)]<=0x0)this[_0x3f41b7(0x48a)]();},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x48a)]=function(){const _0x4d99a6=_0x251720;this[_0x4d99a6(0x743)]=this[_0x4d99a6(0x244)];},Sprite_Battler['prototype'][_0x251720(0x771)]=function(){const _0x4f41cc=_0x251720;return this[_0x4f41cc(0x865)]>0x0;},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x540)]=function(_0x144d15,_0xaeaba0){const _0x50449f=_0x251720;if(!this[_0x50449f(0xa42)]())return;if(_0xaeaba0<=0x0)return;this[_0x50449f(0x617)]=_0x144d15,this['_jumpDuration']=_0xaeaba0,this['_jumpWholeDuration']=_0xaeaba0;},Sprite_Battler[_0x251720(0x97e)][_0x251720(0xe5)]=function(){const _0x56420c=_0x251720;if(this['_jumpDuration']<=0x0)return;const _0x2406a3=this['_jumpWholeDuration']-this[_0x56420c(0x66a)],_0x3fc01e=this['_jumpWholeDuration']/0x2,_0x214105=this['_jumpMaxHeight'],_0x409e22=-_0x214105/Math[_0x56420c(0x85c)](_0x3fc01e,0x2);this['_jumpHeight']=_0x409e22*Math['pow'](_0x2406a3-_0x3fc01e,0x2)+_0x214105,this['_jumpDuration']--;if(this['_jumpDuration']<=0x0)return this[_0x56420c(0x5c7)]();},Sprite_Battler[_0x251720(0x97e)]['onJumpEnd']=function(){const _0x5cadef=_0x251720;this[_0x5cadef(0xa91)]=0x0;},Sprite_Battler['prototype'][_0x251720(0x4e6)]=function(){const _0x5798ca=_0x251720;return this[_0x5798ca(0x66a)]>0x0;},Sprite_Battler[_0x251720(0x97e)]['startOpacity']=function(_0x2a8ead,_0x18d186,_0x4fc9ce){const _0x20f347=_0x251720;if(this['_targetOpacity']===_0x2a8ead)return;this[_0x20f347(0x10c)]=_0x2a8ead,this[_0x20f347(0x6c2)]=_0x18d186,this[_0x20f347(0x741)]=_0x18d186,this[_0x20f347(0x30a)]=_0x4fc9ce||_0x20f347(0x59a);if(_0x18d186<=0x0)this[_0x20f347(0x8f9)]=_0x2a8ead;},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x10d)]=function(){const _0x22b28d=_0x251720;if(this[_0x22b28d(0x8c)][_0x22b28d(0x1f8)]===_0x22b28d(0x972))return;if(this['_opacityDuration']<=0x0)return;const _0x3c490a=this[_0x22b28d(0x6c2)],_0x40a35c=this[_0x22b28d(0x741)],_0x5cc563=this[_0x22b28d(0x30a)];Imported[_0x22b28d(0x7a8)]?_0x22b28d(0x134)!==_0x22b28d(0x881)?this['opacity']=this[_0x22b28d(0xa94)](this[_0x22b28d(0x8f9)],this[_0x22b28d(0x10c)],_0x3c490a,_0x40a35c,_0x5cc563):_0x21ad2b--:this[_0x22b28d(0x8f9)]=(this[_0x22b28d(0x8f9)]*(_0x3c490a-0x1)+this[_0x22b28d(0x10c)])/_0x3c490a;this['_opacityDuration']--;if(this[_0x22b28d(0x6c2)]<=0x0)this[_0x22b28d(0x5c1)]();},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x5c1)]=function(){const _0xf39fc=_0x251720;this[_0xf39fc(0x8f9)]=this[_0xf39fc(0x10c)];},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x3fd)]=function(){const _0x3947b4=_0x251720;return this[_0x3947b4(0x6c2)]>0x0;},Sprite_Battler[_0x251720(0x97e)][_0x251720(0xa0a)]=function(){const _0x1ba330=_0x251720;this[_0x1ba330(0x806)][_0x1ba330(0x499)]=this[_0x1ba330(0x397)]['hasSvBattler'](),this[_0x1ba330(0xe4)]();},Sprite_Battler['prototype'][_0x251720(0xe4)]=function(){const _0x469425=_0x251720;if(!this['_shadowSprite'])return;this[_0x469425(0x806)]['y']=this[_0x469425(0x6cc)]-this['y']-0x2;},Sprite_Battler[_0x251720(0x97e)]['updateShadowScale']=function(){const _0x3c6f56=_0x251720;if(!this[_0x3c6f56(0x397)])return;this[_0x3c6f56(0x188)]=this[_0x3c6f56(0x397)][_0x3c6f56(0x58e)](),this[_0x3c6f56(0x78b)]=this[_0x3c6f56(0x397)][_0x3c6f56(0x2ad)]();},Game_BattlerBase[_0x251720(0x97e)][_0x251720(0x58e)]=function(){const _0x2dd2c1=_0x251720,_0x572562=this[_0x2dd2c1(0x4f2)]()?this[_0x2dd2c1(0x30d)]():this[_0x2dd2c1(0xa80)]();if(_0x572562){if(_0x2dd2c1(0x601)===_0x2dd2c1(0x601)){const _0x31535d=_0x572562[_0x2dd2c1(0x67f)];if(_0x31535d[_0x2dd2c1(0x591)](/<SIDEVIEW SHADOW (?:SCALE|SCALE X):[ ](\d+)([%％])>/i))return Number(RegExp['$1'])*0.01;else{if(_0x31535d[_0x2dd2c1(0x591)](/<SIDEVIEW SHADOW (?:SCALE|SCALE X):[ ](.*)>/i))return Number(RegExp['$1'])||0x0;}}else this[_0x2dd2c1(0x5ce)][_0x2dd2c1(0x56d)][_0x2dd2c1(0x732)]['x']=-0x1/(this[_0x2dd2c1(0x732)]['x']||0.001),this[_0x2dd2c1(0x5ce)][_0x2dd2c1(0x56d)][_0x2dd2c1(0x732)]['y']=0x1/(this[_0x2dd2c1(0x732)]['y']||0.001);}return 0x1;},Game_BattlerBase[_0x251720(0x97e)][_0x251720(0x2ad)]=function(){const _0x1ade0e=_0x251720,_0x3380fa=this[_0x1ade0e(0x4f2)]()?this[_0x1ade0e(0x30d)]():this[_0x1ade0e(0xa80)]();if(_0x3380fa){const _0x3f109b=_0x3380fa[_0x1ade0e(0x67f)];if(_0x3f109b[_0x1ade0e(0x591)](/<SIDEVIEW SHADOW (?:SCALE|SCALE Y):[ ](\d+)([%％])>/i))return Number(RegExp['$1'])*0.01;else{if(_0x3f109b[_0x1ade0e(0x591)](/<SIDEVIEW SHADOW (?:SCALE|SCALE Y):[ ](.*)>/i))return Number(RegExp['$1'])||0x0;}}return 0x1;},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x70)]=function(){const _0x2f2621=_0x251720;if(this['constructor']===Sprite_SvEnemy)return;this[_0x2f2621(0x739)](),this[_0x2f2621(0x14a)]();},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x14a)]=function(){const _0x5c3b2e=_0x251720,_0x336b53=this['_distortionSprite'];_0x336b53&&(_0x336b53[_0x5c3b2e(0x732)]['x']=this[_0x5c3b2e(0x560)](),_0x336b53[_0x5c3b2e(0x732)]['y']=this[_0x5c3b2e(0x9e1)]());},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x560)]=function(){let _0x4e22a9=0x1;return _0x4e22a9*=this['_flipScaleX'],_0x4e22a9*=this['_growX'],_0x4e22a9;},Sprite_Battler[_0x251720(0x97e)]['mainSpriteScaleY']=function(){return 0x1*this['_growY'];},Sprite_Battler['prototype'][_0x251720(0x6f9)]=function(){const _0x2df404=_0x251720;return this[_0x2df404(0x139)]*this[_0x2df404(0x560)]();},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x1d6)]=function(){const _0x4615d5=_0x251720;return this[_0x4615d5(0x442)]*this[_0x4615d5(0x9e1)]();},Sprite_Battler['prototype']['startGrow']=function(_0x159323,_0x555188,_0x2069af,_0x26b877){const _0x505466=_0x251720;if(!this[_0x505466(0xa42)]())return;if(!this['_distortionSprite'])return;if(this[_0x505466(0xa86)]===_0x159323&&this['_targetGrowY']===_0x555188)return;this[_0x505466(0xa86)]=_0x159323,this[_0x505466(0xcd)]=_0x555188,this[_0x505466(0x522)]=_0x2069af,this[_0x505466(0x579)]=_0x2069af,this[_0x505466(0x9cf)]=_0x26b877||'Linear',_0x2069af<=0x0&&(this[_0x505466(0x4ed)]=this[_0x505466(0xa86)],this[_0x505466(0x2c5)]=this[_0x505466(0xcd)]);},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x739)]=function(){const _0x5e1bcb=_0x251720;if(this[_0x5e1bcb(0x522)]<=0x0)return;if(!this[_0x5e1bcb(0x316)])return;const _0xf4ff1=this['_growDuration'],_0x207d29=this['_growWholeDuration'],_0xac1ea2=this[_0x5e1bcb(0x9cf)];if(Imported[_0x5e1bcb(0x7a8)])_0x5e1bcb(0xa6d)!==_0x5e1bcb(0x1f7)?(this[_0x5e1bcb(0x4ed)]=this[_0x5e1bcb(0xa94)](this['_growX'],this[_0x5e1bcb(0xa86)],_0xf4ff1,_0x207d29,_0xac1ea2),this[_0x5e1bcb(0x2c5)]=this[_0x5e1bcb(0xa94)](this['_growY'],this[_0x5e1bcb(0xcd)],_0xf4ff1,_0x207d29,_0xac1ea2)):this[_0x5e1bcb(0x6f4)]=!![];else{if(_0x5e1bcb(0x311)!==_0x5e1bcb(0x762))this[_0x5e1bcb(0x4ed)]=(this[_0x5e1bcb(0x4ed)]*(_0xf4ff1-0x1)+this[_0x5e1bcb(0xa86)])/_0xf4ff1,this[_0x5e1bcb(0x2c5)]=(this['_growY']*(_0xf4ff1-0x1)+this[_0x5e1bcb(0xcd)])/_0xf4ff1;else{const _0x281c14=this[_0x5e1bcb(0x912)](_0x52b838);this[_0x5e1bcb(0xaae)](_0x55399,_0x281c14['x'],_0x281c14['y'],_0x281c14['width'],_0x281c14[_0x5e1bcb(0x442)]);}}this[_0x5e1bcb(0x522)]--;if(this[_0x5e1bcb(0x522)]<=0x0)this[_0x5e1bcb(0x527)]();},Sprite_Battler[_0x251720(0x97e)]['onGrowEnd']=function(){const _0x88cfc4=_0x251720;this[_0x88cfc4(0x4ed)]=this[_0x88cfc4(0xa86)],this[_0x88cfc4(0x2c5)]=this[_0x88cfc4(0xcd)];},Sprite_Battler['prototype'][_0x251720(0xbd)]=function(){const _0x482c90=_0x251720;return this[_0x482c90(0x522)]>0x0;},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x63c)]=function(_0x1b66e1,_0x5d3f6c,_0x431fac,_0x1d8b87){const _0x1cfcf1=_0x251720;if(!this['canMove']())return;if(!this[_0x1cfcf1(0x316)])return;if(this[_0x1cfcf1(0x3c9)]===_0x1b66e1&&this[_0x1cfcf1(0x3ad)]===_0x5d3f6c)return;this[_0x1cfcf1(0x3c9)]=_0x1b66e1,this['_targetSkewY']=_0x5d3f6c,this['_skewDuration']=_0x431fac,this['_skewWholeDuration']=_0x431fac,this[_0x1cfcf1(0xbc)]=_0x1d8b87||_0x1cfcf1(0x59a);if(_0x431fac<=0x0){if(_0x1cfcf1(0x6b2)!=='zXxmc')this[_0x1cfcf1(0x316)][_0x1cfcf1(0x727)]['x']=this[_0x1cfcf1(0x3c9)],this['_distortionSprite'][_0x1cfcf1(0x727)]['y']=this[_0x1cfcf1(0x3ad)];else{if(this[_0x1cfcf1(0x397)]&&this[_0x1cfcf1(0x397)][_0x1cfcf1(0x864)]())return![];if(this[_0x1cfcf1(0x397)]&&!this[_0x1cfcf1(0x397)][_0x1cfcf1(0x10f)]())return![];return _0x40c3ad['isSideView']();}}},Sprite_Battler[_0x251720(0x97e)]['updateSkew']=function(){const _0x414c35=_0x251720;if(this[_0x414c35(0x876)]<=0x0)return;if(!this['_distortionSprite'])return;const _0x48e58e=this[_0x414c35(0x876)],_0x2b65a8=this[_0x414c35(0x590)],_0x28be15=this[_0x414c35(0xbc)],_0x4e78e8=this['_distortionSprite'];if(Imported[_0x414c35(0x7a8)]){if('RBIhk'==='YuwbG'){if(this['_actions'][_0x414c35(0x84)](_0x329fad=>_0x329fad[_0x414c35(0x342)]()&&_0x329fad[_0x414c35(0x700)]()))return!![];}else _0x4e78e8[_0x414c35(0x727)]['x']=this[_0x414c35(0xa94)](_0x4e78e8[_0x414c35(0x727)]['x'],this[_0x414c35(0x3c9)],_0x48e58e,_0x2b65a8,_0x28be15),_0x4e78e8[_0x414c35(0x727)]['y']=this['applyEasing'](_0x4e78e8[_0x414c35(0x727)]['y'],this['_targetSkewY'],_0x48e58e,_0x2b65a8,_0x28be15);}else _0x4e78e8['skew']['x']=(_0x4e78e8[_0x414c35(0x727)]['x']*(_0x48e58e-0x1)+this[_0x414c35(0x3c9)])/_0x48e58e,_0x4e78e8[_0x414c35(0x727)]['y']=(_0x4e78e8['skew']['y']*(_0x48e58e-0x1)+this['_targetSkewY'])/_0x48e58e;this[_0x414c35(0x876)]--;if(this[_0x414c35(0x876)]<=0x0)this[_0x414c35(0x25a)]();},Sprite_Battler[_0x251720(0x97e)]['onSkewEnd']=function(){const _0x5b4351=_0x251720;this[_0x5b4351(0x316)]['skew']['x']=this['_targetSkewX'],this[_0x5b4351(0x316)][_0x5b4351(0x727)]['y']=this['_targetSkewY'];},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x98e)]=function(){return this['_skewDuration']>0x0;},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x6aa)]=function(_0x9c0697,_0x31cc33,_0x1e306b,_0x2606e0){const _0x484ef9=_0x251720;if(!this['canMove']())return;if(!this['_distortionSprite'])return;if(this['_targetAngle']===_0x9c0697)return;this[_0x484ef9(0x1aa)]=_0x9c0697,this[_0x484ef9(0x4aa)]=_0x31cc33,this[_0x484ef9(0x919)]=_0x31cc33,this[_0x484ef9(0x452)]=_0x1e306b||_0x484ef9(0x59a),this[_0x484ef9(0x167)]=_0x2606e0,this[_0x484ef9(0x167)]===undefined&&(this[_0x484ef9(0x167)]=!![]),_0x31cc33<=0x0&&('CTEwa'!==_0x484ef9(0x263)?_0x19ee02=_0x56a3a2>=_0x600590?_0x55ddeb:_0x1eee68:(this[_0x484ef9(0x694)]=_0x9c0697,this[_0x484ef9(0x167)]&&('uPzPd'===_0x484ef9(0x33d)?(this[_0x484ef9(0x1aa)]=0x0,this['_currentAngle']=0x0):(_0x540cf2[_0x484ef9(0x731)][_0x484ef9(0x394)][_0x484ef9(0xa57)](this),this['callNextMethod']()))));},Sprite_Battler[_0x251720(0x97e)]['updateSpin']=function(){const _0xe0ea4c=_0x251720;this[_0xe0ea4c(0x91c)](),this[_0xe0ea4c(0x29a)]();},Sprite_Battler[_0x251720(0x97e)]['updateAngleCalculations']=function(){const _0x2951ec=_0x251720;if(this[_0x2951ec(0x4aa)]<=0x0)return;const _0x3b9f4e=this[_0x2951ec(0x4aa)],_0x2aafba=this[_0x2951ec(0x919)],_0x24f302=this[_0x2951ec(0x452)];Imported[_0x2951ec(0x7a8)]?this[_0x2951ec(0x694)]=this[_0x2951ec(0xa94)](this['_currentAngle'],this[_0x2951ec(0x1aa)],_0x3b9f4e,_0x2aafba,_0x24f302):this[_0x2951ec(0x694)]=(this[_0x2951ec(0x694)]*(_0x3b9f4e-0x1)+this['_targetAngle'])/_0x3b9f4e;this[_0x2951ec(0x4aa)]--;if(this[_0x2951ec(0x4aa)]<=0x0)this[_0x2951ec(0x15a)]();},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x15a)]=function(){const _0x58db62=_0x251720;this[_0x58db62(0x694)]=this[_0x58db62(0x1aa)];if(this[_0x58db62(0x167)]){if(_0x58db62(0x783)!=='rXvsy')this[_0x58db62(0x1aa)]=0x0,this[_0x58db62(0x694)]=0x0;else return!![];}},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x119)]=function(){const _0x4b9302=_0x251720;return this[_0x4b9302(0x4aa)]>0x0;},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x29a)]=function(){const _0x1186b8=_0x251720;if(!this[_0x1186b8(0x316)])return;const _0x20bdf4=this[_0x1186b8(0x694)],_0xcaa3d0=this[_0x1186b8(0x732)]['x'],_0x4b170b=this[_0x1186b8(0x397)][_0x1186b8(0x4f2)]()?-0x1:0x1;this['_distortionSprite'][_0x1186b8(0x50f)]=_0x20bdf4*_0xcaa3d0*_0x4b170b;const _0x55781a=this[_0x1186b8(0x316)]['scale']['y'];this[_0x1186b8(0x316)]['y']=this[_0x1186b8(0x442)]*-0.5*(0x2-_0x55781a),this[_0x1186b8(0x316)]['y']=Math[_0x1186b8(0x4a0)](this[_0x1186b8(0x316)]['y']);const _0x35f900=[this[_0x1186b8(0xa7d)],this[_0x1186b8(0x5ce)],this['_dragonbonesSpriteContainer']];for(const _0xbba39f of _0x35f900){if(_0x1186b8(0xa00)===_0x1186b8(0xa5b)){if(this['_phase']===_0x1186b8(0x3be))this[_0x1186b8(0x3d7)]();else this[_0x1186b8(0x56e)]==='forceAction'?this[_0x1186b8(0x7d5)]():_0x4e1dbd[_0x1186b8(0x731)][_0x1186b8(0xa03)][_0x1186b8(0xa57)](this,_0x46cee4);}else{if(!_0xbba39f)continue;_0xbba39f['y']=this[_0x1186b8(0x442)]*0.5;}}this[_0x1186b8(0x806)]&&(this[_0x1186b8(0x188)]=this[_0x1186b8(0x188)]??0x1,this['_shadowScaleY']=this[_0x1186b8(0x78b)]??0x1,this[_0x1186b8(0x806)][_0x1186b8(0x732)]['x']=this['_distortionSprite'][_0x1186b8(0x732)]['x']*this[_0x1186b8(0x188)],this[_0x1186b8(0x806)][_0x1186b8(0x732)]['y']=this[_0x1186b8(0x316)][_0x1186b8(0x732)]['y']*this[_0x1186b8(0x78b)]);},VisuMZ['BattleCore'][_0x251720(0x56f)]=Sprite_Actor[_0x251720(0x97e)][_0x251720(0xc9)],Sprite_Actor[_0x251720(0x97e)]['createStateSprite']=function(){const _0x5b9f39=_0x251720;VisuMZ[_0x5b9f39(0x731)]['Sprite_Actor_createStateSprite'][_0x5b9f39(0xa57)](this);if(VisuMZ[_0x5b9f39(0x731)]['Settings'][_0x5b9f39(0x2df)][_0x5b9f39(0xa64)]){if(_0x5b9f39(0x99f)!==_0x5b9f39(0x99f)){if(!_0x159328[_0x5b9f39(0x731)][_0x5b9f39(0x825)][_0x5b9f39(0x98)][_0x5b9f39(0x38f)])return;const _0x1a9504=_0x377209[_0x5b9f39(0x29b)];if(_0x1a9504){if(_0x1a9504[_0x5b9f39(0x4f2)]()&&!_0x58de01[_0x5b9f39(0x22c)]())return;const _0xd7bb93=_0x1a9504[_0x5b9f39(0x60a)]();if(_0xd7bb93&&_0x1a9504[_0x5b9f39(0x4f2)]())this[_0x5b9f39(0xa12)][_0x5b9f39(0x26f)](_0xd7bb93);}}else this[_0x5b9f39(0x129)]();}},VisuMZ[_0x251720(0x731)][_0x251720(0xa30)]=Sprite_Enemy[_0x251720(0x97e)][_0x251720(0x760)],Sprite_Enemy[_0x251720(0x97e)][_0x251720(0x760)]=function(){const _0x145cc5=_0x251720;VisuMZ['BattleCore'][_0x145cc5(0x825)][_0x145cc5(0x2df)][_0x145cc5(0x39d)]&&this[_0x145cc5(0x129)](),VisuMZ[_0x145cc5(0x731)][_0x145cc5(0xa30)][_0x145cc5(0xa57)](this);},Sprite_Battler['prototype'][_0x251720(0x129)]=function(){const _0x11b3a9=_0x251720;if(!ConfigManager[_0x11b3a9(0x6b5)])return;if(this[_0x11b3a9(0x8c)]===Sprite_SvEnemy)return;const _0x57a30b=VisuMZ[_0x11b3a9(0x731)][_0x11b3a9(0x825)][_0x11b3a9(0x2df)],_0x37bea0=new Sprite_HpGauge();_0x37bea0[_0x11b3a9(0x48c)]['x']=_0x57a30b[_0x11b3a9(0x93c)],_0x37bea0[_0x11b3a9(0x48c)]['y']=_0x57a30b[_0x11b3a9(0x261)],_0x37bea0[_0x11b3a9(0x732)]['x']=_0x37bea0['scale']['y']=_0x57a30b[_0x11b3a9(0x120)],this[_0x11b3a9(0x818)]=_0x37bea0,this['addChild'](this[_0x11b3a9(0x818)]);},VisuMZ[_0x251720(0x731)][_0x251720(0x8d9)]=Sprite_Battler['prototype']['setBattler'],Sprite_Battler['prototype'][_0x251720(0x200)]=function(_0x2b3355){const _0x190794=_0x251720,_0x4c3a7b=this[_0x190794(0x397)];VisuMZ[_0x190794(0x731)][_0x190794(0x8d9)][_0x190794(0xa57)](this,_0x2b3355),this[_0x190794(0x183)](_0x2b3355);if(_0x4c3a7b!==_0x2b3355)this['updateShadowScale']();},Sprite_Battler['prototype'][_0x251720(0x183)]=function(_0x3f876e){const _0x391f3c=_0x251720;if(!_0x3f876e)return;if(!this[_0x391f3c(0x818)])return;if(_0x3f876e[_0x391f3c(0x4f2)]()){}else{if(_0x3f876e[_0x391f3c(0x722)]()){if(this[_0x391f3c(0x8c)]===Sprite_SvEnemy&&!_0x3f876e[_0x391f3c(0x87d)]())return;}}this[_0x391f3c(0x818)][_0x391f3c(0x1ea)](_0x3f876e,'hp');},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x3c7)]=function(){const _0x2a4d9f=_0x251720;if(!this[_0x2a4d9f(0x397)])return;if(!this[_0x2a4d9f(0x818)])return;const _0x508a91=VisuMZ[_0x2a4d9f(0x731)][_0x2a4d9f(0x825)]['HpGauge'],_0x5b80eb=this[_0x2a4d9f(0x818)];_0x5b80eb[_0x2a4d9f(0x499)]=this[_0x2a4d9f(0x7bd)]();const _0x19aacf=_0x508a91['OffsetX'],_0x4b7450=_0x508a91['OffsetY'];_0x5b80eb['x']=_0x19aacf,_0x5b80eb['x']+=this['_battler'][_0x2a4d9f(0x9a9)](),_0x5b80eb['y']=-this[_0x2a4d9f(0x442)]+_0x4b7450,_0x5b80eb['y']+=this['_battler'][_0x2a4d9f(0x36e)]();},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x7bd)]=function(){const _0x22b1c2=_0x251720;if(!this[_0x22b1c2(0x397)])return![];if(this['_battler'][_0x22b1c2(0x4f2)]())return!![];const _0x3decec=this[_0x22b1c2(0x397)][_0x22b1c2(0xa80)]()[_0x22b1c2(0x67f)];if(_0x3decec[_0x22b1c2(0x591)](/<SHOW HP GAUGE>/i))return!![];if(_0x3decec['match'](/<HIDE HP GAUGE>/i))return![];const _0x51f3a4=VisuMZ[_0x22b1c2(0x731)][_0x22b1c2(0x825)][_0x22b1c2(0x2df)];if(_0x51f3a4['RequiresDefeat']){if(_0x51f3a4[_0x22b1c2(0xd7)]&&BattleManager[_0x22b1c2(0x220)]())return!![];if(this[_0x22b1c2(0x397)]['_visualHpGauge_JustDied'])return![];return this[_0x22b1c2(0x397)][_0x22b1c2(0x278)]();}return!![];},VisuMZ[_0x251720(0x731)][_0x251720(0x870)]=Sprite_Battler['prototype'][_0x251720(0x8c5)],Sprite_Battler[_0x251720(0x97e)][_0x251720(0x8c5)]=function(){const _0x4ea4e1=_0x251720;if(!this[_0x4ea4e1(0x397)])return![];return VisuMZ[_0x4ea4e1(0x731)]['Sprite_Battler_isMoving'][_0x4ea4e1(0xa57)](this);},VisuMZ['BattleCore'][_0x251720(0xa8a)]=Sprite_Battler[_0x251720(0x97e)][_0x251720(0x44c)],Sprite_Battler[_0x251720(0x97e)][_0x251720(0x44c)]=function(_0x1c6f2a,_0x354a7d,_0x1623ac){const _0x4688e2=_0x251720;this[_0x4688e2(0xa42)]()&&(_0x4688e2(0x740)===_0x4688e2(0x48b)?_0x8f11e4='left':VisuMZ['BattleCore'][_0x4688e2(0xa8a)][_0x4688e2(0xa57)](this,_0x1c6f2a,_0x354a7d,_0x1623ac));},Sprite_Battler[_0x251720(0x97e)][_0x251720(0xa42)]=function(){const _0x1ad9bf=_0x251720;if(this[_0x1ad9bf(0x397)]&&this['_battler'][_0x1ad9bf(0x864)]())return![];if(this['_battler']&&!this[_0x1ad9bf(0x397)][_0x1ad9bf(0x10f)]())return![];return $gameSystem[_0x1ad9bf(0x22c)]();},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x4c0)]=function(){},Sprite_Battler[_0x251720(0x97e)]['stepBack']=function(){this['startMove'](0x0,0x0,0xc);},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x130)]=function(){},Sprite_Battler[_0x251720(0x97e)][_0x251720(0x9c9)]=function(){const _0x38e339=_0x251720,_0x2a5207=VisuMZ[_0x38e339(0x731)]['Settings'][_0x38e339(0x98)],_0x892a74=this[_0x38e339(0x397)]&&this[_0x38e339(0x397)][_0x38e339(0x4f2)]()?0x1:-0x1,_0x3ac9cd=this[_0x38e339(0x176)]-this[_0x38e339(0x231)]+_0x892a74*_0x2a5207[_0x38e339(0x530)],_0x430661=this[_0x38e339(0x6cc)]-this[_0x38e339(0xa0e)]+_0x892a74*_0x2a5207[_0x38e339(0xa36)],_0x19e485=_0x2a5207[_0x38e339(0x406)];this['startMove'](_0x3ac9cd,_0x430661,_0x19e485);},VisuMZ[_0x251720(0x731)]['Sprite_Actor_initMembers']=Sprite_Actor['prototype'][_0x251720(0x147)],Sprite_Actor[_0x251720(0x97e)][_0x251720(0x147)]=function(){const _0x3efaac=_0x251720;VisuMZ[_0x3efaac(0x731)][_0x3efaac(0xa7)][_0x3efaac(0xa57)](this),this[_0x3efaac(0x5b7)]();},Sprite_Actor[_0x251720(0x97e)][_0x251720(0x2b3)]=function(){const _0x2d5832=_0x251720;return this[_0x2d5832(0x316)]||this[_0x2d5832(0xa7d)]||this;},VisuMZ[_0x251720(0x731)][_0x251720(0x2b0)]=Sprite_Actor[_0x251720(0x97e)][_0x251720(0x3d3)],Sprite_Actor[_0x251720(0x97e)][_0x251720(0x3d3)]=function(){},Sprite_Actor['prototype']['moveToStartPositionBattleCore']=function(_0x5cc4a4){const _0x326358=_0x251720;if(SceneManager['isPreviousSceneBattleTransitionable']())return;if(!_0x5cc4a4)return;if(!_0x5cc4a4['canMove']())return;VisuMZ['BattleCore'][_0x326358(0x2b0)][_0x326358(0xa57)](this);},VisuMZ['BattleCore'][_0x251720(0x1cd)]=Sprite_Actor[_0x251720(0x97e)]['setActorHome'],Sprite_Actor[_0x251720(0x97e)]['setActorHome']=function(_0x1a0dcc){const _0x3cf450=_0x251720;VisuMZ[_0x3cf450(0x731)]['Settings'][_0x3cf450(0x98)][_0x3cf450(0x73e)]?VisuMZ[_0x3cf450(0x731)]['Settings']['Actor'][_0x3cf450(0x73e)][_0x3cf450(0xa57)](this,_0x1a0dcc):VisuMZ[_0x3cf450(0x731)][_0x3cf450(0x1cd)]['call'](this,_0x1a0dcc);},VisuMZ['BattleCore'][_0x251720(0x9b8)]=Sprite_Actor[_0x251720(0x97e)]['setBattler'],Sprite_Actor[_0x251720(0x97e)][_0x251720(0x200)]=function(_0xa60a84){const _0x3993da=_0x251720;VisuMZ[_0x3993da(0x731)][_0x3993da(0x9b8)]['call'](this,_0xa60a84),this[_0x3993da(0x3d5)](_0xa60a84);},Sprite_Actor['prototype']['setBattlerBattleCore']=function(_0x2f89e7){const _0x3fa924=_0x251720;if(!_0x2f89e7)return;if(!this[_0x3fa924(0xa7d)])return;this[_0x3fa924(0xa7d)][_0x3fa924(0x48c)]['x']=this[_0x3fa924(0x81d)][_0x3fa924(0x516)](),this[_0x3fa924(0xa7d)][_0x3fa924(0x48c)]['y']=this[_0x3fa924(0x81d)][_0x3fa924(0x5fc)](),this[_0x3fa924(0x5bd)]();},VisuMZ[_0x251720(0x731)]['Sprite_Actor_update']=Sprite_Actor[_0x251720(0x97e)][_0x251720(0xc8)],Sprite_Actor[_0x251720(0x97e)][_0x251720(0xc8)]=function(){const _0x16bcfd=_0x251720;VisuMZ[_0x16bcfd(0x731)][_0x16bcfd(0x6d4)]['call'](this);if(this[_0x16bcfd(0x81d)]){if(_0x16bcfd(0x1df)===_0x16bcfd(0x669)){const _0x18a93b=this[_0x16bcfd(0x60a)]();_0x18a93b&&_0x18a93b[_0x16bcfd(0x4c0)]();}else this['updateStateSprite'](),this['updateStyleOpacity']();}},VisuMZ['BattleCore'][_0x251720(0x44b)]=Sprite_Actor['prototype'][_0x251720(0x45c)],Sprite_Actor[_0x251720(0x97e)][_0x251720(0x45c)]=function(){const _0xae5166=_0x251720;VisuMZ['BattleCore']['Sprite_Actor_updateBitmap'][_0xae5166(0xa57)](this),this['_mainSprite']&&this['_mainSprite'][_0xae5166(0x817)]&&this[_0xae5166(0x397)]&&(this[_0xae5166(0xa7d)][_0xae5166(0x817)][_0xae5166(0x149)]!==this[_0xae5166(0x397)][_0xae5166(0x26c)]()&&(this[_0xae5166(0xa7d)][_0xae5166(0x817)][_0xae5166(0x149)]=this[_0xae5166(0x397)]['battlerSmoothImage']()));},VisuMZ[_0x251720(0x731)][_0x251720(0x82f)]=Sprite_Actor[_0x251720(0x97e)][_0x251720(0xa0a)],Sprite_Actor[_0x251720(0x97e)][_0x251720(0xa0a)]=function(){const _0x5ab7f9=_0x251720;VisuMZ['BattleCore'][_0x5ab7f9(0x82f)]['call'](this),this['updateShadowBattleCore']();},Sprite_Actor[_0x251720(0x97e)][_0x251720(0x910)]=function(){const _0x57a824=_0x251720;if(!this['_mainSprite'])return;if(!this[_0x57a824(0x806)])return;this[_0x57a824(0x5bd)](),this[_0x57a824(0xe4)]();},Sprite_Actor[_0x251720(0x97e)][_0x251720(0x6ae)]=function(){const _0x3ad2ca=_0x251720;this[_0x3ad2ca(0x56d)][_0x3ad2ca(0x732)]['x']=0x1/(this[_0x3ad2ca(0x732)]['x']||0.001),this[_0x3ad2ca(0x56d)]['scale']['y']=0x1/(this[_0x3ad2ca(0x732)]['y']||0.001);},Sprite_Actor[_0x251720(0x97e)][_0x251720(0x6c7)]=function(){const _0x1e4e80=_0x251720;if(!$gameSystem[_0x1e4e80(0x22c)]()&&this['constructor']===Sprite_Actor){if(_0x1e4e80(0x888)!==_0x1e4e80(0x888)){const _0x5bf9ce=_0x3b786f[_0x1e4e80(0x731)]['Settings'];if(this[_0x1e4e80(0x8c)]===_0x187df9)_0x5e84f0+=_0x5bf9ce[_0x1e4e80(0x98)]['OffsetX']||0x0,_0x8e6c24+=_0x5bf9ce['Actor'][_0x1e4e80(0x3bb)]||0x0;else this[_0x1e4e80(0x8c)]===_0x2416d0&&(_0x4a1b3a+=_0x5bf9ce[_0x1e4e80(0x3b1)][_0x1e4e80(0x38a)]||0x0,_0x24e70d+=_0x5bf9ce[_0x1e4e80(0x3b1)][_0x1e4e80(0x3bb)]||0x0);_0x216d92['BattleCore'][_0x1e4e80(0xc7)][_0x1e4e80(0xa57)](this,_0x2bc97c,_0x292b0b);}else{const _0x3331b0=Scene_Battle[_0x1e4e80(0x97e)]['battleLayoutStyle']();[_0x1e4e80(0xa0f),_0x1e4e80(0x855),_0x1e4e80(0x234),_0x1e4e80(0x9bc)]['includes'](_0x3331b0)&&(this['opacity']=0x0);}}},Sprite_Actor[_0x251720(0x97e)][_0x251720(0x853)]=function(){const _0x524915=_0x251720,_0x4d8e31=this[_0x524915(0x81d)];if(_0x4d8e31){if(_0x524915(0xe7)==='sXNdR'){const _0x34446a=_0x4d8e31[_0x524915(0x8a9)]();if(_0x4d8e31[_0x524915(0xa69)]()||_0x4d8e31[_0x524915(0x1c3)]())this[_0x524915(0xf9)]('walk');else{if(_0x34446a===0x3)this[_0x524915(0xf9)](_0x524915(0x437));else{if(_0x34446a===0x2)this[_0x524915(0xf9)]('sleep');else{if(this['forceEscapeSprite'])this[_0x524915(0xf9)](_0x524915(0x5f1));else{if(_0x4d8e31[_0x524915(0x21e)]())this['startMotion'](_0x524915(0x990));else{if(_0x4d8e31[_0x524915(0x48d)]())_0x524915(0x98a)===_0x524915(0x898)?_0x582a32[_0x524915(0x667)](_0x4ef595[_0x524915(0x823)],!![]):this[_0x524915(0xf9)]('chant');else{if(_0x4d8e31[_0x524915(0x45f)]()||_0x4d8e31[_0x524915(0x75d)]()){if(_0x524915(0x433)!==_0x524915(0x409))this[_0x524915(0xf9)]('guard');else{if(!this['isDuringNonLoopingMotion']()&&this!==_0x14d6a1[_0x524915(0x29b)]){if(this[_0x524915(0x60a)]())this[_0x524915(0x60a)]()[_0x524915(0x853)]();}this[_0x524915(0x985)]();return;}}else{if(_0x34446a===0x1)this[_0x524915(0xf9)](_0x524915(0x2f9));else{if(_0x4d8e31['isDying']())this['startMotion'](_0x524915(0xdb));else{if(_0x4d8e31[_0x524915(0x819)]())this[_0x524915(0xf9)](_0x524915(0x8bb));else _0x4d8e31[_0x524915(0x4c1)]()?this[_0x524915(0xf9)](_0x524915(0x990)):this['startMotion']('walk');}}}}}}}}}}else{let _0x14556e=0x0;return this['_battler']&&!this[_0x524915(0x397)][_0x524915(0x3d4)]()&&(_0x14556e-=this[_0x524915(0x743)],_0x14556e-=this[_0x524915(0xa91)]),_0x14556e;}}},Sprite_Actor[_0x251720(0x97e)][_0x251720(0x130)]=function(){const _0x44afd9=_0x251720,_0x420b37=0xa,_0x53e3be=0x12c*_0x420b37,_0x35550e=0x1e*_0x420b37;this[_0x44afd9(0x44c)](_0x53e3be,0x0,_0x35550e);},Sprite_Actor['prototype']['onMoveEnd']=function(){const _0x447109=_0x251720;Sprite_Battler[_0x447109(0x97e)][_0x447109(0x2a7)]['call'](this);},Sprite_Actor[_0x251720(0x97e)][_0x251720(0x1db)]=function(){return Sprite_Battler['_motionSpeed'];},Sprite_Weapon[_0x251720(0x97e)]['animationWait']=function(){const _0x52a784=_0x251720;return Sprite_Battler[_0x52a784(0x52a)];},Sprite_Actor[_0x251720(0x97e)][_0x251720(0x80)]=function(){},Sprite_Actor['prototype'][_0x251720(0x8e1)]=function(){},Sprite_Actor[_0x251720(0x97e)]['updateMotionCount']=function(){const _0x18485f=_0x251720;if(this[_0x18485f(0x723)]&&++this[_0x18485f(0x228)]>=this[_0x18485f(0x1db)]()){if(this[_0x18485f(0x723)][_0x18485f(0x8db)])this[_0x18485f(0x258)]=(this[_0x18485f(0x258)]+0x1)%0x4;else{if(this[_0x18485f(0x258)]<0x2)_0x18485f(0x651)!=='GseJZ'?(_0x41211e&&(_0x5c0f4f[_0x18485f(0x4fc)]=_0xad4863[_0x18485f(0x4fc)]||{},_0xc07b54[_0x18485f(0x4fc)][_0x18485f(0x6d5)]=0x0),_0xb5d951[_0x18485f(0x184)](_0x5a9579,_0x88069a,_0x41e1c2,_0x11f6a3)):this[_0x18485f(0x258)]++;else{if(_0x18485f(0xa54)==='GkWjd'){_0x1bcfd4[_0x18485f(0x97e)][_0x18485f(0xc8)][_0x18485f(0xa57)](this),this[_0x18485f(0x28c)](),this[_0x18485f(0x455)]();if(this[_0x18485f(0x5bf)]()===_0x18485f(0x9bc))this[_0x18485f(0x262)]();}else this[_0x18485f(0x853)]();}}this['_motionCount']=0x0;}},Sprite_Actor['prototype'][_0x251720(0x428)]=function(_0x535cb7){const _0x581647=_0x251720;if(_0x535cb7===_0x581647(0xa3f))this[_0x581647(0x453)]=!![];if(this[_0x581647(0x397)]&&this['_battler']['isDead']()){if(_0x581647(0x93a)!==_0x581647(0x93a)){_0x91a1f4['prototype']['activate'][_0x581647(0xa57)](this);const _0x2338b2=this[_0x581647(0x5bf)]();_0x2338b2==='border'&&this[_0x581647(0x663)]();}else{this[_0x581647(0x723)]=Sprite_Actor[_0x581647(0x8b)]['dead'];return;}}const _0x30c7e7=Sprite_Actor[_0x581647(0x8b)][_0x535cb7];this[_0x581647(0x723)]=_0x30c7e7,this[_0x581647(0x228)]=0x0,this[_0x581647(0x258)]=0x0;},Sprite_Actor['prototype']['forceWeaponAnimation']=function(_0x4dbad6){const _0x202920=_0x251720;this[_0x202920(0x51d)](),this[_0x202920(0x488)][_0x202920(0x1ea)](_0x4dbad6),this[_0x202920(0x81d)][_0x202920(0x6b3)]();},Sprite_Actor[_0x251720(0x97e)][_0x251720(0x51d)]=function(){const _0x119fa2=_0x251720;let _0x35a65b=-0x10,_0x4b23e9=this[_0x119fa2(0x442)]*0.5;const _0x4b3ab5=/<SIDEVIEW WEAPON OFFSET:[ ]([\+\-]\d+),[ ]([\+\-]\d+)>/i,_0x24dd90=this[_0x119fa2(0x397)][_0x119fa2(0xabc)]()['map'](_0x4a9a64=>_0x4a9a64&&_0x4a9a64['note'][_0x119fa2(0x591)](_0x4b3ab5)?Number(RegExp['$1']):0x0),_0x38ad97=this[_0x119fa2(0x397)][_0x119fa2(0xabc)]()[_0x119fa2(0x259)](_0x8fb201=>_0x8fb201&&_0x8fb201[_0x119fa2(0x67f)]['match'](_0x4b3ab5)?Number(RegExp['$2']):0x0);_0x35a65b=_0x24dd90[_0x119fa2(0x843)]((_0x3f64f8,_0x16b6e6)=>_0x3f64f8+_0x16b6e6,_0x35a65b),_0x4b23e9=_0x38ad97[_0x119fa2(0x843)]((_0x5e907d,_0x5e2e54)=>_0x5e907d+_0x5e2e54,_0x4b23e9),this[_0x119fa2(0x488)]['x']=_0x35a65b,this['_weaponSprite']['y']=_0x4b23e9,this[_0x119fa2(0x488)][_0x119fa2(0xc8)]();},Sprite_Weapon[_0x251720(0x97e)][_0x251720(0x1ea)]=function(_0x38899c){const _0x5b4c79=_0x251720;this[_0x5b4c79(0x568)]=_0x38899c,this[_0x5b4c79(0xa6e)]=-0x1,this[_0x5b4c79(0x258)]=0x0,this[_0x5b4c79(0x9c0)](),this['updateFrame']();},Sprite_Actor['prototype'][_0x251720(0x962)]=function(){},Sprite_Actor[_0x251720(0x97e)][_0x251720(0x4c0)]=function(){const _0x5b5bd5=_0x251720,_0x3b6014=VisuMZ[_0x5b5bd5(0x731)]['Settings'][_0x5b5bd5(0x1cc)],_0x436f6f=_0x3b6014[_0x5b5bd5(0x104)],_0x205a8f=_0x3b6014['StepDistanceY'],_0x45ac84=_0x3b6014['StepDuration'];this['startMove'](-_0x436f6f,-_0x205a8f,_0x45ac84);},VisuMZ[_0x251720(0x731)][_0x251720(0x297)]=Sprite_Actor[_0x251720(0x97e)][_0x251720(0x615)],Sprite_Actor[_0x251720(0x97e)][_0x251720(0x615)]=function(){const _0x1286ac=_0x251720;this[_0x1286ac(0x55a)](),VisuMZ[_0x1286ac(0x731)][_0x1286ac(0x297)][_0x1286ac(0xa57)](this);},Sprite_Actor[_0x251720(0x97e)][_0x251720(0x55a)]=function(){const _0x51c062=_0x251720;if(this[_0x51c062(0x397)]&&this['_battler']['_freezeMotionData']){const _0xf7a4f6=this[_0x51c062(0x397)][_0x51c062(0xa63)];this['_motion']=Sprite_Actor['MOTIONS'][_0xf7a4f6[_0x51c062(0x7c1)]],this[_0x51c062(0x258)]=_0xf7a4f6[_0x51c062(0x961)];const _0x277878=this[_0x51c062(0x488)];_0x277878['freezeFrame'](_0xf7a4f6[_0x51c062(0x9e8)],_0xf7a4f6[_0x51c062(0x961)]),this['adjustWeaponSpriteOffset']();}},Sprite_Weapon[_0x251720(0x97e)][_0x251720(0x230)]=function(_0x2ba148,_0x43ea5c){const _0x34b689=_0x251720;this[_0x34b689(0x568)]=_0x2ba148,this[_0x34b689(0xa6e)]=-Infinity,this[_0x34b689(0x258)]=_0x43ea5c,this['loadBitmap'](),this[_0x34b689(0x615)]();},Sprite_Enemy[_0x251720(0x97e)][_0x251720(0x147)]=function(){const _0x240325=_0x251720;Sprite_Battler[_0x240325(0x97e)][_0x240325(0x147)][_0x240325(0xa57)](this),this[_0x240325(0x345)]=null,this[_0x240325(0x60f)]=![],this[_0x240325(0x583)]='',this[_0x240325(0x24d)]=0x0,this[_0x240325(0x769)]=null,this[_0x240325(0x641)]=0x0,this[_0x240325(0x418)]=0x0,this['createMainSprite'](),this[_0x240325(0x760)]();},VisuMZ[_0x251720(0x731)][_0x251720(0x35f)]=Sprite_Enemy[_0x251720(0x97e)]['update'],Sprite_Enemy[_0x251720(0x97e)][_0x251720(0xc8)]=function(){const _0x27b301=_0x251720;VisuMZ[_0x27b301(0x731)]['Sprite_Enemy_update'][_0x27b301(0xa57)](this),this[_0x27b301(0x5bd)]();},Sprite_Enemy[_0x251720(0x97e)]['createMainSprite']=function(){const _0x38a569=_0x251720;this[_0x38a569(0xa7d)]=new Sprite(),this[_0x38a569(0xa7d)]['anchor']['x']=0.5,this[_0x38a569(0xa7d)][_0x38a569(0x48c)]['y']=0x1,this[_0x38a569(0x26f)](this[_0x38a569(0xa7d)]),this[_0x38a569(0x5b7)]();},Sprite_Enemy[_0x251720(0x97e)][_0x251720(0x2b3)]=function(){const _0x4b4e64=_0x251720;return this[_0x4b4e64(0x316)]||this[_0x4b4e64(0xa7d)]||this;},Sprite_Enemy[_0x251720(0x97e)][_0x251720(0x9c0)]=function(_0x3d4891){const _0x3b2e1e=_0x251720;this['bitmap']=new Bitmap(0x1,0x1);if(this[_0x3b2e1e(0x87d)]()){if(_0x3b2e1e(0xa3a)===_0x3b2e1e(0xa3a)){const _0x3710d4=this[_0x3b2e1e(0x345)][_0x3b2e1e(0x690)]();this[_0x3b2e1e(0x817)]=new Bitmap(_0x3710d4[_0x3b2e1e(0x139)],_0x3710d4['height']),this[_0x3b2e1e(0xa7d)][_0x3b2e1e(0x817)]=new Bitmap(0x1,0x1);}else this['_animationContainer'][_0x3b2e1e(0x26f)](_0x73ffe6);}else $gameSystem[_0x3b2e1e(0x22c)]()?'JrsLN'===_0x3b2e1e(0x9af)?(this[_0x3b2e1e(0xa7d)][_0x3b2e1e(0x817)]=ImageManager[_0x3b2e1e(0x630)](_0x3d4891),this[_0x3b2e1e(0xa7d)][_0x3b2e1e(0x817)][_0x3b2e1e(0x26d)](this['createEmptyBitmap'][_0x3b2e1e(0x270)](this))):_0x3222f6=_0x510aef:(this[_0x3b2e1e(0xa7d)][_0x3b2e1e(0x817)]=ImageManager[_0x3b2e1e(0x9ac)](_0x3d4891),this['_mainSprite']['bitmap']['addLoadListener'](this[_0x3b2e1e(0x221)][_0x3b2e1e(0x270)](this)));},Sprite_Enemy[_0x251720(0x97e)]['createEmptyBitmap']=function(){const _0x122d0f=_0x251720,_0x3b36b4=this[_0x122d0f(0xa7d)][_0x122d0f(0x817)];if(_0x3b36b4){if(_0x122d0f(0x5c6)===_0x122d0f(0x5c6))this[_0x122d0f(0x817)]=new Bitmap(_0x3b36b4[_0x122d0f(0x139)],_0x3b36b4[_0x122d0f(0x442)]);else return this[_0x122d0f(0x3fe)]();}},VisuMZ[_0x251720(0x731)][_0x251720(0xba)]=Sprite_Enemy[_0x251720(0x97e)][_0x251720(0x6a9)],Sprite_Enemy[_0x251720(0x97e)][_0x251720(0x6a9)]=function(_0xc03e20){const _0x544ef3=_0x251720;this[_0x544ef3(0xa7d)]&&this[_0x544ef3(0xa7d)][_0x544ef3(0x6a9)](_0xc03e20);},VisuMZ['BattleCore'][_0x251720(0x49b)]=Sprite_Enemy[_0x251720(0x97e)][_0x251720(0x2c3)],Sprite_Enemy[_0x251720(0x97e)][_0x251720(0x2c3)]=function(){const _0x39dc34=_0x251720;if(this[_0x39dc34(0x86f)]()){if(_0x39dc34(0x410)!==_0x39dc34(0x5d0))VisuMZ[_0x39dc34(0x731)][_0x39dc34(0x49b)][_0x39dc34(0xa57)](this);else{this['processBattleCoreJS'](_0x39dc34(0x3cf));const _0x1c293c=this[_0x39dc34(0x1cf)];_0x3eb240[_0x39dc34(0x731)][_0x39dc34(0x850)][_0x39dc34(0xa57)](this),this[_0x39dc34(0x1cf)]=_0x1c293c+_0x2ba8b5['BattleCore'][_0x39dc34(0x825)][_0x39dc34(0xa38)][_0x39dc34(0x182)]['call'](this),this[_0x39dc34(0xa66)]('EscapeFail');}}else this[_0x39dc34(0x60f)]=!this[_0x39dc34(0x345)]['isHidden'](),!this[_0x39dc34(0x60f)]&&(this['opacity']=0x0);},VisuMZ[_0x251720(0x731)][_0x251720(0xa56)]=Sprite_Enemy['prototype']['updateCollapse'],Sprite_Enemy[_0x251720(0x97e)][_0x251720(0x9a8)]=function(){const _0x4ab558=_0x251720;if(this['allowCollapse']())VisuMZ[_0x4ab558(0x731)][_0x4ab558(0xa56)][_0x4ab558(0xa57)](this);},Sprite_Enemy['prototype']['updateFrame']=function(){const _0x2189c8=_0x251720;Sprite_Battler[_0x2189c8(0x97e)][_0x2189c8(0x615)][_0x2189c8(0xa57)](this);const _0x289a3d=this[_0x2189c8(0x2b3)]()||this;if(!_0x289a3d)return;!_0x289a3d['bitmap']&&(_0x289a3d['bitmap']=new Bitmap(this['width'],this['height'])),this['_effectType']===_0x2189c8(0x208)?this[_0x2189c8(0xa7d)][_0x2189c8(0x8c4)](0x0,0x0,this[_0x2189c8(0xa7d)][_0x2189c8(0x139)],this[_0x2189c8(0x641)]):_0x2189c8(0xac)!==_0x2189c8(0x9a6)?_0x289a3d['setFrame'](0x0,0x0,_0x289a3d[_0x2189c8(0x817)]['width'],this[_0x2189c8(0x817)]['height']):_0x49b183['snapForBackground']();},VisuMZ['BattleCore'][_0x251720(0x8ad)]=Sprite_Enemy[_0x251720(0x97e)][_0x251720(0xa87)],Sprite_Enemy['prototype'][_0x251720(0xa87)]=function(){const _0x1505db=_0x251720;if(this[_0x1505db(0x86f)]())VisuMZ[_0x1505db(0x731)][_0x1505db(0x8ad)][_0x1505db(0xa57)](this);},Sprite_Enemy[_0x251720(0x97e)][_0x251720(0x8c5)]=function(){const _0x375c74=_0x251720;return Sprite_Battler[_0x375c74(0x97e)][_0x375c74(0x8c5)][_0x375c74(0xa57)](this);},VisuMZ[_0x251720(0x731)]['Sprite_Enemy_updateStateSprite']=Sprite_Enemy[_0x251720(0x97e)][_0x251720(0x6ae)],Sprite_Enemy['prototype'][_0x251720(0x6ae)]=function(){const _0x3e7a02=_0x251720;VisuMZ[_0x3e7a02(0x731)][_0x3e7a02(0x582)]['call'](this),this[_0x3e7a02(0x52d)]();},Sprite_Enemy[_0x251720(0x97e)]['updateStateSpriteBattleCore']=function(){const _0x257ca9=_0x251720,_0x2aa570=VisuMZ[_0x257ca9(0x731)][_0x257ca9(0x825)][_0x257ca9(0x3b1)];if(_0x2aa570['NameAttachStateIcon']&&!_0x2aa570[_0x257ca9(0x254)]){if(_0x257ca9(0x814)!==_0x257ca9(0x341)){this[_0x257ca9(0x83f)]['opacity']=0x0;return;}else{_0x355805['BattleCore']['Game_Action_itemEffectAddNormalState']['call'](this,_0x4e077e,_0x391093);if(!_0x1f9268[_0x257ca9(0x9e5)]())return;if(_0x2ef8b5[_0x257ca9(0x2b6)]!==_0x100cf1[_0x257ca9(0x1b1)]())return;let _0x59d207=_0x143fbf[_0x257ca9(0x884)];!this['isCertainHit']()&&(_0x59d207*=_0x52ca12[_0x257ca9(0x982)](_0x4a3b7c[_0x257ca9(0x2b6)]),_0x59d207*=this['lukEffectRate'](_0x48330a)),_0xf4e3c[_0x257ca9(0x298)]()<_0x59d207&&(_0x5c7a0b[_0x257ca9(0x4d4)]=!![],this['makeSuccess'](_0x2d5255));}}this[_0x257ca9(0x83f)]['x']=0x0,this['_stateIconSprite']['x']+=this[_0x257ca9(0x397)][_0x257ca9(0x9a9)](),this['_stateIconSprite']['y']=-this[_0x257ca9(0x817)][_0x257ca9(0x442)]-this[_0x257ca9(0x83f)][_0x257ca9(0x442)],this[_0x257ca9(0x83f)]['y']+=this[_0x257ca9(0x397)][_0x257ca9(0x36e)](),this[_0x257ca9(0x83f)][_0x257ca9(0x732)]['x']=0x1/(this[_0x257ca9(0x732)]['x']||0.001),this[_0x257ca9(0x83f)][_0x257ca9(0x732)]['y']=0x1/(this['scale']['y']||0.001),this[_0x257ca9(0x87d)]()&&(this['_svBattlerSprite']['_stateSprite'][_0x257ca9(0x732)]['x']=-0x1/(this[_0x257ca9(0x732)]['x']||0.001),this[_0x257ca9(0x5ce)]['_stateSprite'][_0x257ca9(0x732)]['y']=0x1/(this['scale']['y']||0.001));},VisuMZ[_0x251720(0x731)][_0x251720(0x425)]=Sprite_Enemy[_0x251720(0x97e)][_0x251720(0x200)],Sprite_Enemy[_0x251720(0x97e)][_0x251720(0x200)]=function(_0x2ceacb){const _0x2bda75=_0x251720;VisuMZ[_0x2bda75(0x731)][_0x2bda75(0x425)][_0x2bda75(0xa57)](this,_0x2ceacb),this[_0x2bda75(0x364)](_0x2ceacb);},Sprite_Enemy['prototype']['setSvBattlerSprite']=function(_0x47cc1a){const _0x561c88=_0x251720;!this[_0x561c88(0x5ce)]&&(this[_0x561c88(0x5ce)]=new Sprite_SvEnemy(_0x47cc1a),this[_0x561c88(0x5b7)]()),this[_0x561c88(0x5ce)][_0x561c88(0x200)](_0x47cc1a);},Sprite_Enemy['prototype'][_0x251720(0x87d)]=function(){const _0x1c45e9=_0x251720;return this[_0x1c45e9(0x345)]&&this[_0x1c45e9(0x345)][_0x1c45e9(0x87d)]();},Sprite_Enemy[_0x251720(0x97e)][_0x251720(0x86f)]=function(){const _0x2ded9c=_0x251720;if(this['hasSvBattler']()){if(_0x2ded9c(0x544)!==_0x2ded9c(0x544))_0x4893c4[_0x2ded9c(0x9d8)](_0x36961d);else return this[_0x2ded9c(0x345)][_0x2ded9c(0x86f)]();}else return'zKhOy'===_0x2ded9c(0xac2)?!![]:_0x150202['battler']()[_0x2ded9c(0x176)]===_0x279fa7[_0x2ded9c(0x60a)]()[_0x2ded9c(0x176)]?_0xd6c927[_0x2ded9c(0x60a)]()[_0x2ded9c(0x6cc)]-_0x2f944f['battler']()[_0x2ded9c(0x6cc)]:_0x536b46[_0x2ded9c(0x60a)]()['_baseX']-_0x323547[_0x2ded9c(0x60a)]()['_baseX'];},Sprite_Enemy[_0x251720(0x97e)][_0x251720(0x853)]=function(){const _0x3adb35=_0x251720;this[_0x3adb35(0x87d)]()&&this[_0x3adb35(0x5ce)][_0x3adb35(0x853)]();},Sprite_Enemy[_0x251720(0x97e)][_0x251720(0x428)]=function(_0x16e4d1){const _0x27925e=_0x251720;if(this['hasSvBattler']())this[_0x27925e(0x5ce)][_0x27925e(0x428)](_0x16e4d1);},Sprite_Enemy[_0x251720(0x97e)][_0x251720(0x470)]=function(_0x101223){const _0x5bff24=_0x251720;if(this['hasSvBattler']())this[_0x5bff24(0x5ce)][_0x5bff24(0x470)](_0x101223);},Sprite_Enemy[_0x251720(0x97e)][_0x251720(0x4c0)]=function(){const _0x146d90=_0x251720,_0x37992c=VisuMZ['BattleCore'][_0x146d90(0x825)]['ActionSequence'],_0x4c1c78=_0x37992c['StepDistanceX'],_0xeda598=_0x37992c[_0x146d90(0x539)],_0xdc44db=_0x37992c['StepDuration'];this[_0x146d90(0x44c)](_0x4c1c78,_0xeda598,_0xdc44db);};function Sprite_SvEnemy(){this['initialize'](...arguments);}Sprite_SvEnemy[_0x251720(0x97e)]=Object['create'](Sprite_Actor[_0x251720(0x97e)]),Sprite_SvEnemy['prototype']['constructor']=Sprite_SvEnemy,Sprite_SvEnemy['prototype'][_0x251720(0x43e)]=function(_0x22fb68){const _0x1ac620=_0x251720;Sprite_Actor['prototype'][_0x1ac620(0x43e)][_0x1ac620(0xa57)](this,_0x22fb68),this[_0x1ac620(0x732)]['x']=-0x1,this[_0x1ac620(0x56d)][_0x1ac620(0x732)]['x']=-0x1;},Sprite_SvEnemy[_0x251720(0x97e)][_0x251720(0x655)]=function(){},Sprite_SvEnemy[_0x251720(0x97e)][_0x251720(0x3d3)]=function(){},Sprite_SvEnemy[_0x251720(0x97e)][_0x251720(0x6e6)]=function(_0x56c745){},Sprite_SvEnemy[_0x251720(0x97e)]['updateShadow']=function(){},Sprite_SvEnemy[_0x251720(0x97e)]['updateShadowPosition']=function(){},Sprite_SvEnemy[_0x251720(0x97e)][_0x251720(0x6ae)]=function(){const _0x45bb30=_0x251720;this[_0x45bb30(0x56d)][_0x45bb30(0x499)]=![];},Sprite_SvEnemy[_0x251720(0x97e)]['updateBitmap']=function(){const _0x516a4b=_0x251720;Sprite_Battler[_0x516a4b(0x97e)][_0x516a4b(0x45c)][_0x516a4b(0xa57)](this);const _0x14c7ad=this[_0x516a4b(0x81d)][_0x516a4b(0x502)]();if(this[_0x516a4b(0x583)]!==_0x14c7ad){if('zycXl'!==_0x516a4b(0x177))this[_0x516a4b(0x583)]=_0x14c7ad,this[_0x516a4b(0xa7d)]['bitmap']=ImageManager[_0x516a4b(0x95d)](_0x14c7ad);else{const _0x29d858=_0x5ee2f6[_0x516a4b(0x731)][_0x516a4b(0x1ba)][_0x2ca1fe],_0x5cdf68={'code':0x2c,'dataId':_0x29d858,'value1':0x1,'value2':0x0};_0x144689[_0x516a4b(0x3c6)][_0x516a4b(0x141)](_0x5cdf68);}}if(this[_0x516a4b(0xa7d)]&&this[_0x516a4b(0xa7d)][_0x516a4b(0x817)]&&this['_battler']){if(this[_0x516a4b(0xa7d)][_0x516a4b(0x817)][_0x516a4b(0x149)]!==this[_0x516a4b(0x397)][_0x516a4b(0x26c)]()){if(_0x516a4b(0x3ee)!==_0x516a4b(0x3ee))return this[_0x516a4b(0x186)][_0x516a4b(0x7e7)]();else this[_0x516a4b(0xa7d)]['bitmap']['smooth']=this[_0x516a4b(0x397)][_0x516a4b(0x26c)]();}}},Sprite_SvEnemy[_0x251720(0x97e)][_0x251720(0x130)]=function(){},Sprite_SvEnemy[_0x251720(0x97e)]['startMove']=function(_0x1c5e6a,_0x184e86,_0x5e0c5a){const _0x26732b=_0x251720;if(this[_0x26732b(0x584)])this[_0x26732b(0x584)][_0x26732b(0x44c)](_0x1c5e6a,_0x184e86,_0x5e0c5a);},Sprite_SvEnemy[_0x251720(0x97e)][_0x251720(0x853)]=function(){const _0x22ad40=_0x251720,_0x192d47=this['_actor'];if(_0x192d47){const _0x4577fb=_0x192d47[_0x22ad40(0x8a9)]();if(_0x192d47[_0x22ad40(0xa69)]()||_0x192d47[_0x22ad40(0x1c3)]())this['startMotion'](_0x22ad40(0x8bb));else{if(_0x4577fb===0x3)_0x22ad40(0x4b3)===_0x22ad40(0xa19)?(_0x430aa6=_0x5d2a23[_0x22ad40(0x139)]/_0x537e01[_0x22ad40(0x5e2)]()[_0x22ad40(0x988)],_0x96d92d*=_0x4a3d28,_0x3d1718+=_0x420efa[_0x22ad40(0x139)]/_0x39fcae['battleMembers']()[_0x22ad40(0x988)]/0x2):this[_0x22ad40(0xf9)](_0x22ad40(0x437));else{if(_0x4577fb===0x2){if(_0x22ad40(0xf5)!=='AuEoJ'){this[_0x22ad40(0x141)](_0x22ad40(0x7d8),_0x334b2d);if(!_0x153e3f[_0x22ad40(0x731)]['Settings'][_0x22ad40(0x8cf)][_0x22ad40(0x8b5)])return;this[_0x22ad40(0x141)](_0x22ad40(0x84b),_0x2d80e6['magicReflection'][_0x22ad40(0x8d6)](_0x21c153[_0x22ad40(0x1f8)]()));}else this['startMotion'](_0x22ad40(0x750));}else{if(_0x192d47['isChanting']())this[_0x22ad40(0xf9)](_0x22ad40(0x733));else{if(_0x192d47[_0x22ad40(0x45f)]()||_0x192d47['isGuardWaiting']())this[_0x22ad40(0xf9)](_0x22ad40(0x474));else{if(_0x4577fb===0x1)this['startMotion'](_0x22ad40(0x2f9));else{if(_0x192d47[_0x22ad40(0x22a)]())this[_0x22ad40(0xf9)]('dying');else _0x192d47[_0x22ad40(0x819)]()?_0x22ad40(0xae)===_0x22ad40(0x9f8)?_0x47e10e[_0x22ad40(0x62e)]():this['startMotion']('walk'):this['startMotion'](_0x192d47['svBattlerData']()[_0x22ad40(0x673)]||_0x22ad40(0x8bb));}}}}}}}},Sprite_SvEnemy[_0x251720(0x97e)]['inHomePosition']=function(){const _0x4dab51=_0x251720;if(this[_0x4dab51(0x584)]){if(_0x4dab51(0x9c4)!==_0x4dab51(0x9c4))this[_0x4dab51(0x663)]();else return this[_0x4dab51(0x584)][_0x4dab51(0xa17)]===0x0&&this[_0x4dab51(0x584)][_0x4dab51(0x69)]===0x0;}else{if(_0x4dab51(0x7cd)!==_0x4dab51(0x4c2))return!![];else{if(this['_battleLayoutStyle'])return this['_battleLayoutStyle'];return this[_0x4dab51(0x923)]=_0x298e48[_0x4dab51(0x35b)]['battleLayoutStyle'](),this[_0x4dab51(0x923)];}}},Sprite_SvEnemy['prototype'][_0x251720(0x916)]=function(){},VisuMZ[_0x251720(0x731)][_0x251720(0x8de)]=Sprite_Animation[_0x251720(0x97e)][_0x251720(0x6a6)],Sprite_Animation[_0x251720(0x97e)]['targetSpritePosition']=function(_0x512fb9){const _0x3c8171=_0x251720;if(_0x512fb9[_0x3c8171(0x316)]){if(_0x3c8171(0x970)!==_0x3c8171(0x735))return this['targetDistortionSpritePosition'](_0x512fb9);else _0x32e18d[_0x3c8171(0x731)][_0x3c8171(0x35d)]['call'](this);}else{if(_0x3c8171(0x8fb)!=='hgBLE')return VisuMZ[_0x3c8171(0x731)][_0x3c8171(0x8de)][_0x3c8171(0xa57)](this,_0x512fb9);else _0x3a1bb7=_0x1cd0f1[this[_0x3c8171(0x619)][_0x53a964][_0x3c8171(0x329)]];}},Sprite_Animation[_0x251720(0x97e)][_0x251720(0x838)]=function(_0xa8af38){const _0xb27b30=_0x251720;let _0x250c04=_0xa8af38['x'],_0x23998e=_0xa8af38['y'],_0x3ec458=_0xa8af38['height'],_0x4e0ea4=_0xa8af38['_distortionSprite']['scale']['y'];_0xa8af38['x']=_0xa8af38[_0xb27b30(0x176)]+_0xa8af38[_0xb27b30(0x4ec)](),_0xa8af38['y']=_0xa8af38['_baseY']+_0xa8af38[_0xb27b30(0x780)](),_0xa8af38['height']*=_0x4e0ea4;let _0x24bb25=VisuMZ[_0xb27b30(0x731)][_0xb27b30(0x8de)][_0xb27b30(0xa57)](this,_0xa8af38);return _0xa8af38['x']=_0x250c04,_0xa8af38['y']=_0x23998e,_0xa8af38[_0xb27b30(0x442)]=_0x3ec458,_0x24bb25;},Sprite_Damage[_0x251720(0x97e)][_0x251720(0x252)]=function(_0x34134c){const _0x111498=_0x251720,_0x37dfbd=_0x34134c[_0x111498(0x9f5)]()||_0x34134c[_0x111498(0x772)]();if(_0x37dfbd[_0x111498(0x1c1)]||_0x37dfbd[_0x111498(0x5a6)])_0x111498(0x96d)===_0x111498(0x96d)?(this[_0x111498(0x39b)]=0x0,this[_0x111498(0xce)]()):_0x302c40=_0x50c881>=_0x33fe43?_0x4034a8:_0x1fa056;else{if(_0x37dfbd[_0x111498(0x574)])this[_0x111498(0x39b)]=_0x37dfbd['hpDamage']>=0x0?0x0:0x1,this[_0x111498(0xa4a)](_0x37dfbd[_0x111498(0x427)]);else{if(_0x34134c[_0x111498(0x2ce)]()&&_0x37dfbd[_0x111498(0x4bc)]!==0x0){if('qbbob'==='ozqex'){if(!this[_0x111498(0x397)][_0x111498(0x891)]())return;while(this['_battler']['isDamagePopupRequested']()){this[_0x111498(0x397)][_0x111498(0x9b3)]()&&this[_0x111498(0x476)]();}this[_0x111498(0x397)][_0x111498(0x6f6)](),this[_0x111498(0x397)][_0x111498(0x678)]();}else this['_colorType']=_0x37dfbd[_0x111498(0x4bc)]>=0x0?0x2:0x3,this[_0x111498(0xa4a)](_0x37dfbd[_0x111498(0x4bc)]);}}}_0x37dfbd[_0x111498(0x8f5)]&&this[_0x111498(0x946)]();},Sprite_Damage[_0x251720(0x97e)][_0x251720(0x1ea)]=function(_0x2e9eb0){},Sprite_Damage[_0x251720(0x97e)][_0x251720(0xa4a)]=function(_0x4803b2){const _0x526210=_0x251720;let _0x584ae8=this[_0x526210(0x94a)](_0x4803b2);const _0x3a99b8=this[_0x526210(0x7f6)](),_0x1b33a5=Math[_0x526210(0x570)](_0x3a99b8*0.75);for(let _0x14f896=0x0;_0x14f896<_0x584ae8[_0x526210(0x988)];_0x14f896++){if(_0x526210(0x2f4)==='CoUTf'){const _0x721a8f=this['createChildSprite'](_0x1b33a5,_0x3a99b8);_0x721a8f[_0x526210(0x817)][_0x526210(0xa68)](_0x584ae8[_0x14f896],0x0,0x0,_0x1b33a5,_0x3a99b8,_0x526210(0x8cc)),_0x721a8f['x']=(_0x14f896-(_0x584ae8[_0x526210(0x988)]-0x1)/0x2)*_0x1b33a5,_0x721a8f['dy']=-_0x14f896;}else return _0x93553a['BattleCore'][_0x526210(0x825)][_0x526210(0x85f)]['CmdTextAlign'];}},Sprite_Damage[_0x251720(0x97e)]['createString']=function(_0x470ffb){const _0x5c2090=_0x251720;let _0x50ad99=Math['abs'](_0x470ffb)[_0x5c2090(0x16e)]();this[_0x5c2090(0x34f)]()&&(_0x5c2090(0xac8)===_0x5c2090(0xac8)?_0x50ad99=VisuMZ[_0x5c2090(0x4bd)](_0x50ad99):(_0x4c5759[_0x5c2090(0x731)][_0x5c2090(0x52f)][_0x5c2090(0xa57)](this),this[_0x5c2090(0x342)]()[_0x5c2090(0x67f)][_0x5c2090(0x591)](/<CUSTOM ACTION SEQUENCE>/i)&&(_0x26668f['_commonEventQueue']=[]),_0x47b0f0[_0x5c2090(0xd2)](this[_0x5c2090(0x342)]())&&(_0x2338a3['_commonEventQueue']=[])));const _0x330605=VisuMZ[_0x5c2090(0x731)][_0x5c2090(0x825)][_0x5c2090(0x2e1)];let _0x3bf8c4='',_0x37b806='';switch(this[_0x5c2090(0x39b)]){case 0x0:_0x3bf8c4=_0x330605[_0x5c2090(0x930)]||_0x5c2090(0x7e8),_0x37b806=TextManager['hp'];if(_0x470ffb===0x0)_0x3bf8c4='%1';break;case 0x1:_0x3bf8c4=_0x330605['hpHealingFmt']||_0x5c2090(0x8c8),_0x37b806=TextManager['hp'];break;case 0x2:_0x3bf8c4=_0x330605[_0x5c2090(0x193)]||'-%1\x20MP',_0x37b806=TextManager['mp'];break;case 0x3:_0x3bf8c4=_0x330605[_0x5c2090(0x93b)]||'+%1\x20MP',_0x37b806=TextManager['mp'];break;}return _0x3bf8c4[_0x5c2090(0x8d6)](_0x50ad99,_0x37b806)['trim']();},Sprite_Damage['prototype'][_0x251720(0x34f)]=function(){const _0x505680=_0x251720;if(Imported['VisuMZ_0_CoreEngine'])return VisuMZ['CoreEngine'][_0x505680(0x825)][_0x505680(0x43b)][_0x505680(0x9e2)];else{if(_0x505680(0xa18)!==_0x505680(0x72a))return![];else _0x5063d1[_0x505680(0x667)](_0x5919ed[_0x505680(0x66d)],!![]);}},Sprite_Damage[_0x251720(0x97e)][_0x251720(0x946)]=function(){const _0x4037d1=_0x251720,_0xe7c958=VisuMZ[_0x4037d1(0x731)]['Settings'][_0x4037d1(0x2e1)];this[_0x4037d1(0x7fc)]=_0xe7c958[_0x4037d1(0x2f1)][_0x4037d1(0xa79)](0x0),this[_0x4037d1(0x34c)]=_0xe7c958['CriticalDuration'];},Sprite_Damage[_0x251720(0x97e)][_0x251720(0x33c)]=function(_0x3e906f,_0x144522){const _0x41b4cd=_0x251720;this[_0x41b4cd(0x7fc)]=_0x144522[_0x41b4cd(0x928)]||[0x0,0x0,0x0,0x0],this[_0x41b4cd(0x7fc)]=JsonEx[_0x41b4cd(0xa1d)](this[_0x41b4cd(0x7fc)]),this[_0x41b4cd(0x34c)]=_0x144522[_0x41b4cd(0xab9)]||0x0;const _0x18a909=this['fontSize'](),_0x41f2bd=Math[_0x41b4cd(0x570)](_0x18a909*0x1e),_0x59fc39=this[_0x41b4cd(0x7a7)](_0x41f2bd,_0x18a909);_0x59fc39['bitmap'][_0x41b4cd(0xdd)]=ColorManager[_0x41b4cd(0x58b)](_0x144522['textColor']),_0x59fc39[_0x41b4cd(0x817)]['drawText'](_0x3e906f,0x0,0x0,_0x41f2bd,_0x18a909,_0x41b4cd(0x8cc)),_0x59fc39['dy']=0x0;},Sprite_Damage[_0x251720(0x97e)][_0x251720(0x954)]=function(_0x4aa98d,_0x324970,_0x2315ce){const _0x331719=_0x251720,_0x336830=Math['max'](this[_0x331719(0x7f6)](),ImageManager[_0x331719(0x162)]),_0x5e198e=Math[_0x331719(0x570)](_0x336830*0x1e),_0x7bd6c5=this[_0x331719(0x7a7)](_0x5e198e,_0x336830),_0x3429d4=ImageManager[_0x331719(0x391)]/0x2,_0x1ea89c=_0x7bd6c5[_0x331719(0x817)]['measureTextWidth'](_0x324970+'\x20');_0x7bd6c5['bitmap'][_0x331719(0xdd)]=ColorManager['getColor'](_0x2315ce[_0x331719(0xdd)]),_0x7bd6c5[_0x331719(0x817)][_0x331719(0xa68)](_0x324970,_0x3429d4,0x0,_0x5e198e-_0x3429d4,_0x336830,_0x331719(0x8cc));const _0x3bb701=Math['round']((_0x336830-ImageManager[_0x331719(0x162)])/0x2),_0x5b5783=_0x5e198e/0x2-ImageManager[_0x331719(0x391)]-_0x1ea89c/0x2+_0x3429d4/0x2,_0x453413=ImageManager[_0x331719(0x421)](_0x331719(0x2ee)),_0x3dbfad=ImageManager['iconWidth'],_0x1c53b5=ImageManager[_0x331719(0x162)],_0x25afea=_0x4aa98d%0x10*_0x3dbfad,_0xebe9fd=Math[_0x331719(0x570)](_0x4aa98d/0x10)*_0x1c53b5;_0x7bd6c5['bitmap'][_0x331719(0x844)](_0x453413,_0x25afea,_0xebe9fd,_0x3dbfad,_0x1c53b5,_0x5b5783,_0x3bb701),this[_0x331719(0x7fc)]=_0x2315ce[_0x331719(0x928)]||[0x0,0x0,0x0,0x0],this[_0x331719(0x7fc)]=JsonEx[_0x331719(0xa1d)](this[_0x331719(0x7fc)]),this[_0x331719(0x34c)]=_0x2315ce['flashDuration']||0x0,_0x7bd6c5['dy']=0x0;},VisuMZ['BattleCore'][_0x251720(0xa07)]=Sprite_StateIcon[_0x251720(0x97e)]['updateFrame'],Sprite_StateIcon[_0x251720(0x97e)][_0x251720(0x615)]=function(){const _0x5345cc=_0x251720;VisuMZ['BattleCore'][_0x5345cc(0xa07)][_0x5345cc(0xa57)](this),this[_0x5345cc(0x8f9)]=this[_0x5345cc(0x8bf)]>0x0?0xff:0x0;},VisuMZ[_0x251720(0x731)][_0x251720(0x3fa)]=Sprite_Weapon['prototype'][_0x251720(0x9c0)],Sprite_Weapon[_0x251720(0x97e)][_0x251720(0x9c0)]=function(){const _0x30e88d=_0x251720;VisuMZ[_0x30e88d(0x731)]['Sprite_Weapon_loadBitmap'][_0x30e88d(0xa57)](this),this[_0x30e88d(0x817)]&&(this[_0x30e88d(0x817)]['smooth']=VisuMZ[_0x30e88d(0x731)][_0x30e88d(0x825)][_0x30e88d(0x98)][_0x30e88d(0x55c)]);};function _0x477f(){const _0x15bab5=['Window_BattleLog_performAction','HelpOptions','JDFLb','command301','Sprite_Battler_damageOffsetY','MessageWait','DefaultSoftCap','gznsy','aliveMembers','zEREY','stypeId','PostDamageJS','setHandler','cancelButtonText','critical','TLCAC','addOptionsCommand','_weather','opacity','currentSymbol','NLsyg','EscapeSuccessJS','updateBattlerContainer','createTroopNote','setupFont','NextTurn','ActSeq_Animation_CastAnimation','preemptive','endBattle','nextActiveWeaponSlot','_callSceneOptions','resetFontSettings','battleSys','battleback2Name','addState','ActSeq_Motion_ClearFreezeFrame','ConfigManager_makeData','pointX','executeDamage','DRvmA','clear','updateShadowBattleCore','dead\x20actors','faceRect','getConfigValue','wdPpL','makeTargetSprites','updateFlip','addShowHpGaugeCommand','options','_angleWholeDuration','addCommand','FYDgw','updateAngleCalculations','NzQKd','alive\x20enemies\x20not\x20user','displayChangedBuffs','BreakShields','JuTGy','JS\x20%1REGENERATE','_battleLayoutStyle','isOptionsCommandAdded','dgRni','_currentActor','Spriteset_Battle_update','flashColor','Window_BattleLog_performRecovery','getBattlePortrait','isItemCommandEnabled','battleCoreTpbMainPhase','JCJuA','WaitForZoom','isItem','hpDamageFmt','applyBattleCoreJS','alive\x20actors\x20not\x20user','addedDebuffs','isOpen','ZUhkP','base','ParseStateNotetags','Window_PartyCommand_initialize','_flinched','tPfLY','mpHealingFmt','AnchorX','createBattleField','JUVgs','rowSpacing','ActSeq_Horror_TVRemove','waitForNewLine','Game_Party_addActor','unshift','commandEscape','isHidden','setupCriticalEffect','checkCacheKey','XIuEB','performMiss','createString','evalDamageFormula','qbZDX','compatibilityVisible','ActSeq_Movement_BattleStep','BattleStartEvent','isTurnBased','value','lNCgQ','ActSeq_Movement_FaceDirection','setupIconTextPopup','1508427LAAOWT','Scene_Battle_windowAreaHeight','rrHpu','cSeoR','displayRemovedStates','isRightInputMode','requestAnimation','drawItemImagePortraitStyle','loadSvActor','updateStatusWindowPosition','collapse','DistanceAdjust','pattern','updateTargetPosition','enemyNames','Window_BattleLog_performCounter','Game_Action_applyGlobal','ParseSkillNotetags','refreshCursor','Width','\x5cI[%1]%2','cFhFR','ActSeq_Horror_NoiseRemove','isTriggered','QYWDU','VtuDT','isBTB','RWvkq','#%1','Sprite_SvEnemy','actionEffect','MAT','maxTp','VisuMZ_2_BattleSystemBTB','shadow','skewBattler','AutoBattleMsg','drawIcon','QBwfJ','isForRandomBattleCore','MP_Rate','prototype','Game_Battler_startTpbTurn','battleProjectiles','Immortal','stateRate','AutoNotetag','_updateCursorArea','clearFreezeMotion','uNxBp','SDbZn','length','displayItemMessage','nMAcl','hbPGK','JvFlO','DrpbE','isSkewing','setHorrorEffectSettings','wait','members','itemWindowRect','Game_Battler_performMiss','BFBdc','requestMotion','Scene_Battle_selectNextCommand','commandNameWindowDrawText','_methods','sYOmW','updatePositionBattleCore','Sprite_Battler_initMembers','ActSeq_Mechanics_EnemyEscape','tOGbf','skillItemWindowRectMiddle','tEudr','gRweH','JS\x20ESCAPE\x20FAILURE','command339','resize','atbInterrupt','HjBHw','UfMdQ','displayReflection','updateCollapse','battleUIOffsetX','sJhcc','Scwau','loadEnemy','lvjie','resetBreakShield','JrsLN','includes','ZSSXq','WaitForSkew','isSpriteVisible','uHIFG','_skillIDs','TextColor','randomInt','Sprite_Actor_setBattler','_active','callUpdateHelp','ActSeq_Movement_WaitForFloat','border','isCommandEnabled','createActorCommandWindowBattleCore','itemTextAlign','loadBitmap','isAnyoneGrowing','uxUyf','autoSelectPriority','dgBEn','frontviewSpriteY','TDqLJ','ActorCmd','setEventCallback','stepFlinch','clearBattlerMotionTrailData','makeTargetsBattleCore','ChargeRate','hFflH','updateSkew','_growEasing','battleCorePreBattleCommonEvent','BattleManager_processDefeat','applyCritical','hgWYv','command3011','ReflectPlayback','ActSeq_Movement_Scale','removeChild','setActiveWeaponSlot','removeStatesAuto','PrioritySortActors','makeActionList','clone','LUK','MIN_SAFE_INTEGER','CEMDx','ActSeq_Angle_WaitForAngle','mainSpriteScaleY','DigitGroupingDamageSprites','wAdgo','VisuMZ_3_SideviewBattleUI','isImmortal','Game_Map_battleback1Name','PggaR','weaponImageId','allowRandomSpeed','ShowPopup','NameAlwaysVisible','hxuJK','requestPointAnimation','StartName','commandOptions','Exploiter','CYKzc','setBattleZoom','ActSeq_Motion_MotionType','actorCommandWindowRect','getNextDamagePopup','makeSpeed','windowPadding','cHnMK','create','exit','makeCommandList','drawSkillCost','_effectsContainer','ActionCount','ARRAYSTRUCT','iNtzi','BpgNb','ActSeq_Mechanics_CtbSpeed','BattleManager_updatePhase','BattleManager_startTurn','PreStartTurnJS','_battlePortrait','Sprite_StateIcon_updateFrame','FoyuU','wgLMt','updateShadow','enemyId','ConvertParams','_forcedBattleLayout','_homeY','default','Game_Battler_performEvasion','casting','_battlerContainer','float','DualWield','WeaponTypeID','hfMoM','_offsetX','nfuTV','WZCIs','#ffffff','ActSeq_DB_DragonbonesTimeScale','ActSeq_Mechanics_AddBuffDebuff','makeDeepCopy','autoMeleeMultiTargetActionSet','CriticalHitRate','STR','TpGaugeOffsetX','207148wqDCvQ','weaponTypes','EDSXU','BackColor','actorId','displayAction','dYNdO','TqZBP','isHiddenSkill','preparePartyRefresh','_autoBattleWindow','removeBuffsAuto','invokeMagicReflection','actions','Sprite_Enemy_createStateIconSprite','parse','waitForEffect','isFlipped','Height','DisablePartyCmd','FlinchDistanceY','checkTpbInputClose','Mechanics','ARRAYJSON','wxkDo','pKPlC','Eycfn','requestFauxAnimation','initBattlePortrait','victory','isAlwaysVisible','revertTpbCachedActor','canMove','KSZVG','skills','split','NZItf','Window_Options_statusText','vCDhR','HelpSkillType','createDigits','reverse','DDJNP','_battleCoreNoElement','ESCAPE','pages','isForFriend','measureTextWidth','ActSeq_Movement_WaitForSkew','ActionEnd','fnJWO','processBattleCoreJS','Sprite_Enemy_updateCollapse','call','pBRKG','wcwPT','517593OWhyhv','srUrk','createCommandNameWindow','xGByj','setText','usePremadeActionSequence','performWeaponAnimation','_activeWeaponSlot','uAQSu','_freezeMotionData','ShowActorGauge','sortDamageSprites','processPostBattleCommonEvents','show','drawText','isInputting','itemHeight','WMpoT','jump','ccmvn','_animationCount','Debuffs','Window_BattleLog_displayEvasion','RxmZY','criticalHitFlat','_battleCoreBattleStartEvent','FollowTurn','Scene_Battle_createActorCommandWindow','CgTic','_stypeIDs','Scene_Map_initialize','slice','SnjBb','_statusWindow','setVisibleUI','_mainSprite','isSkipPartyCommandWindow','Window_BattleLog_performActionEnd','enemy','splice','setBattlePortrait','drawItemImageXPStyle','drawSingleSkillCost','BindCommonEventKeysForObj','_targetGrowX','updateBossCollapse','FlashDuration','commandAutoBattle','Sprite_Battler_startMove','Window_ActorCommand_initialize','ARRAYSTR','removeBuff','isPTB','RsjNg','iyMnb','_jumpHeight','PRE-','Game_Map_battleback2Name','applyEasing','Scene_Battle_commandFight','_helpWindow','BTeYL','PPYIy','lCcRk','die','SbQob','QhGdt','startEnemySelection','moveToStartPositionBattleCore','processRandomizedData','innerHeight','alterChange','isBusy','ShowAddedDebuff','lOVZC','Destination','removeDamageSprite','VisuMZ_2_BattleSystemETB','_inputting','CopyCombatLog','vepQJ','startActorCommandSelection','startGrow','ActSeq_Movement_WaitForScale','drawActorFace','showAnimation','itemEffectAddNormalState','updateEventMain','VariableHeal','isCustomBattleScope','SvMotionIdleSolo-%1-%2','changeBattlebacks','launchBattle','gaugeX','fRnDz','flashDuration','isAnimationShownOnBattlePortrait','PopupDuration','traitObjects','TeXmG','DamageFlat','guardSkillId','CommandWidth','isCancelled','zKhOy','GztPs','TP_Rate','isNextSceneBattleTransitionable','1078965rmEdlq','Strength','aSJSt','AutoBattleBgType','isTickBased','JIZZq','ActSeq_Set_TargetActionSet','itemCri','_offsetY','counterAttack','onBattleStartBattleCore','ESIaX','clamp','_animation','WaitCount1','updateScale','addBattleCoreAutoBattleStartupCommand','mPEqk','updateStateIconSprite','PZSHz','updateBattlebackBitmap1','SvMotionIdleMass-%1-%2','activate','oiTXz','pgZSi','abs','glitch','ParseItemNotetags','_updateFilterArea','reserveCommonEvent','movement','setupMotion','Window_BattleLog_displayCritical','isForFriendBattleCore','BKHps','some','icon','concat','AutoBattleOK','RgFLb','ActSeq_Mechanics_TextPopup','isIncludedInEnemyWindow','MOTIONS','constructor','isAutoBattleCommandEnabled','Game_Temp_requestAnimation','destroy','revealNewWeaknesses','PostDamage%1JS','moveBattlerDistance','_battleField','isAnyoneMoving','Rate','kumVX','command357','Actor','isATB','isPreviousSceneBattleTransitionable','mUyoj','Game_Troop_setup','displayActionResults','addSingleSkillCommands','startAttackWeaponAnimation','noise','removedStateObjects','BattleManager_isTpbMainPhase','kPvBM','Game_Battler_clearMotion','Text','pop','Sprite_Actor_initMembers','ZMZTW','addedStateObjects','updatePhase','zTyFC','qaivS','setupDamagePopup','KyecN','_commonEventQueue','ActSeq_Zoom_Reset','performCastAnimation','isTpb','HHTHs','active','VisuMZ_1_ElementStatusCore','ShowSubstitute','_emptyBitmap','ALL\x20SKILLS','Game_Action_needsSelection','Sprite_Enemy_setHue','battleJump','_skewEasing','isGrowing','onDisabledPartyCommandSelection','applyForcedGameTroopSettingsBattleCore','HXxoe','canAttackBattleCore','VisuMZ_1_SkillsStatesCore','EasingType','YtjRZ','alive\x20battlers','Turns','Sprite_Battler_setHome','update','createStateSprite','JCNor','_animationSprites','MDF','_targetGrowY','createMiss','Window_BattleLog_performEvasion','performCollapse','process_VisuMZ_BattleCore_BaseTroops','checkAutoCustomActionSequenceNotetagEffect','processRefresh','DamageType%1','top','createBattleUIOffsetX','BTestBypass','KFEaj','MAXHP','Targets2','dying','JS\x20%1END\x20TURN','textColor','bxnEk','iconIndex','setupMotionBlurImpactFilter','text','CommandAddAutoBattle','DamageStyleList','updateShadowPosition','updateJump','ENeKL','sXNdR','process_VisuMZ_BattleCore_CommonEventKeys','power','iGnGZ','battleSkew','faceWidth','ActSeq_Set_WholeActionSet','cTMre','loadPicture','Window_ActorCommand_setup','452296KFzFeG','XmwPY','drawItemImageListStyle','tvvgZ','AuEoJ','isBorderStylePortraitShown','addEscapeCommand','_preBattleCommonEvent','startMotion','NUM','addedBuffs','slZPi','_actionBattlers','onSelectAction','JS\x20BATTLE\x20VICTORY','process_VisuMZ_BattleCore_DamageStyles','Game_Enemy_setup','uiInputPosition','logActionList','StepDistanceX','replace','BattleManager_selectNextCommand','TKNXq','svAnchorX','canAddSkillCommand','ZVymn','placeTimeGauge','_targetOpacity','updateOpacity','%1Damage%2JS','canBattlerMove','getTraitSetKeys','addGeneralOptions','Window_BattleLog_performActionStart','_borderPortraitTargetX','dimColor2','addAnimationSpriteToContainer','isMVAnimation','itemEffectAddAttackState','ActSeq_Element_ForceElements','isSpinning','version','_createClientArea','NameAttachStateIcon','drawLineText','_battleCoreForcedElements','currentValue','Scale','isAttack','statusWindowRectDefaultStyle','PortraitScaleBorderStyle','TargetLocation','makeActionListAutoAttack','battleback1Name','CnFGz','BhFyk','createHpGaugeSprite','createAnimationSprite','addBattleCoreAutoBattleStyleCommand','HP_Rate','ActSeq_Camera_FocusPoint','NameAlwaysHidden','processBorderActor','retreat','gKoxT','createHelpWindow','szigN','gPLQJ','jumpBattler','PHrfI','AS\x20TARGET','utNDx','width','animation','ARyqp','Game_Map_encounterList','CriticalHitRateJS','alterType','boxWidth','HpGaugeOffsetX','push','getSkillTypes','start','SkillItemMiddleLayout','makeData','HelpFight','initMembers','traitSet','smooth','finalizeScale','Wave','MrnjJ','damageOffsetY','parameters','JS\x20ESCAPE\x20SUCCESS','PopupShiftX','_customDamageFormula','COMBATLOG','ZDvmJ','updateSpin','ShowFailure','gQMIC','Ldsio','initMembersBattleCore','addCustomCommands','onAngleEnd','bMjeI','Parse_Notetags_Targets','_actions','displayMpDamage','BoostPoints','LnsBu','Scene_Battle_helpWindowRect','iconHeight','StateIconOffsetX','_enemies','WsniJ','DamageDisplay','_angleRevertOnFinish','ActSeq_Mechanics_FtbAction','ActSeq_Camera_Reset','uIUAk','placeGauge','ActSeq_Element_AddElements','spell','toString','partyCommandWindowRectXPStyle','ConvertCount','Game_Interpreter_PluginCommand','maxItems','PreEndTurnJS','charged','addGuardCommand','_baseX','PEzVU','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','Targets','Item-%1-%2','ActSeq_Movement_Opacity','WwdDp','initBattleCore','changeInputWindow','DistanceY','adjustPosition_ScaleDown','ActSeq_Camera_FocusTarget','CalcEscapeRaiseJS','setupHpGaugeSprite','alterActionCostPTB','tRspE','_damagePopupArray','_regionBattleback2','_shadowScaleX','Window_BattleLog_displayFailure','updateFloat','Game_BattlerBase_addNewState','uKscG','gainCurrentActionsETB','ElementStatusCore','WaitForOpacity','lukEffectRate','createActorCommandWindow','uHRlt','mpDamageFmt','getItemDamageAmountLabelOriginal','current\x20target','lzkZr','turn','eAsEh','svBattlerShadowVisible','Game_Interpreter_command301','command301_PreBattleEvent','PostApplyAsUserJS','HkOOv','_updateCursorFilterArea','Duration','EnableSoftCap','setWaitMode','VariableDmg','ActSeq_Impact_MotionBlurTarget','isOnCurrentMap','AGI','ActSeq_Skew_Reset','message4','Override','onTurnEnd','_targetAngle','_interpreter','isFightCommandEnabled','Scene_Battle_start','inputting','Window_BattleStatus_initialize','_endBattle','deathStateId','changeBattlerOpacity','statusWindowRectXPStyle','isForOpponent','setActiveWeaponSet','FNVzI','debuffAdd','zMCPD','move','_commonEventKey','Scene_Options_maxCommands','ActSeq_Mechanics_HpMpTp','_tempBattler','TpGaugeOffsetY','addDamageSprite','displayReflectionPlayBack','missed','_enemyID','isActing','min','_regionBattleback1','Window_BattleLog_performReflection','ActSeq_Animation_WaitForAnimation','thrust','drawItemBackground','SideviewSelect','_logWindow','ActionSequence','Sprite_Actor_setActorHome','createEffectActionSet','_escapeRatio','parseForcedGameTroopSettingsBattleCore','_targetIndex','displayCounter','setAttack','fittingHeight','damageFlat','mainSpriteHeight','regenerateAll','lineHeight','apply','selectNextCommand','motionSpeed','lWzlx','isAtbCastingState','Lmjwt','ZsOAN','onActorCancel','displayType','DUTGu','updateActors','QyZkf','iconText','checkShowHideSkillNotetags','StatusWindowAttachmentFrontOffsetX','contents','setupBattlebackBattleCore','setup','Filename','alive\x20friends','CommandVisible','onEnemyOk','CriticalHitMultiplier','ActSeq_BattleLog_WaitForNewLine','statusWindowRectBorderStyle','forceEscapeSprite','gradientFillRect','canAlterActionCostPTB','extraPositionScaledY','onRegeneratePlayStateAnimation','CJWxD','name','isPhysical','jIOsU','_canLose','animationId','canAttack','PreEndBattleJS','cTubs','setBattler','VisuMZ_2_HorrorEffects','battleFloat','text\x20target','isCertainHit','_back1Sprite','performFlinch','Rymfe','bossCollapse','StateIconOffsetY','AwtoX','Game_Action_clear','Actions','isDTB','ArRedFlat','DyeMR','setupActionSet','nJnKf','setSTBExploited','_lastAction','helpWindowRectBorderStyle','_itemWindow','ShowWeapon','isAppeared','performAttackSlot','HpGaugeOffsetY','alive\x20battlers\x20not\x20target','AsTarget','Scene_Battle_createPartyCommandWindow','cancelTargetSelectionVisibility','isCharging','mhp','isBattleTest','createEmptyBitmap','playEnemyAttack','isEscapeCommandEnabled','yadDO','Name','processActorCommandCancelTPB','efvUZ','_motionCount','isFastForward','isDying','getDamageStyle','isSideView','bWcUB','BattleManager_endBattle','ATK','freezeFrame','_homeX','partyCommandWindowRect','ActSeq_Mechanics_Multipliers','portrait','GuxZv','commandSymbol','nAuXA','popBaseLine','ASrct','actorCommandAutoBattle','DigitGrouping','TpbGaugeOffsetY','ActSeq_BattleLog_PushBaseLine','getBattlePortraitOffsetY','wRRtE','stbGainInstant','updateCommandNameWindow','ActSeq_Mechanics_Immortal','VisuMZ_3_ActSeqCamera','_targetFloatHeight','tone','autoSelectLastSelected','ActSeq_BattleLog_Clear','LTJHl','gZPQW','Victory','registerCommand','ActSeq_BattleLog_Refresh','_battlerHue','UUlGZ','_skillWindow','clearFreezeMotionForWeapons','ActSeq_BattleLog_PopBaseLine','setupBattleCore','description','NameLegacy','magicReflection','AddOption','Game_Enemy_transform','_pattern','map','onSkewEnd','gainTp','missile','createPartyCommandWindowBattleCore','hOkev','Window_BattleLog_displayTpDamage','battleEffect','AnchorY','updateBorderStyle','CTEwa','rLGkW','battleSpin','createEnemyNames','GqGnd','OdEkp','zdMNa','amLtT','becomeSTBExploited','battlerSmoothImage','addLoadListener','Game_Action_apply','addChild','bind','subject','commandStyleCheck','PreDamageJS','DLlfm','getAttackWeaponAnimationId','ActSeq_Mechanics_PtbFullHalfAction','OxDcL','hasBeenDefeatedBefore','PreStartBattleJS','setBattleCameraOffset','centerFrontViewSprite','VJRfC','ForceExploited','getLastPluginCommandInterpreter','Sprite_Battleback_adjustPosition','pNVMA','iIvIC','return\x200','PreStartActionJS','showPortraits','_eventId','cAnrt','isOptionsCommandEnabled','optDisplayTp','Direction','updateHelp','NQNww','updateRefresh','lSRqj','onAllActionsEnd','setMoveEasingType','_windowLayer','RPAHW','rpiPf','WHVpM','ODJJC','clearHorrorEffects','Sprite_Battler_damageOffsetX','Sprite_Actor_updateFrame','random','CastCertain','applyAngleChange','_subject','performActionEnd','clearRect','drawItemImage','gainBravePoints','shouldPopupDamage','ShowPortraitsBorderStyle','addChildToBack','_surprise','WQqMC','arRedRate','IMTll','onMoveEnd','updateCallMenu','skewDuration','clearActiveWeaponSet','addSkillCommands','createInnerPortrait','battlerShadowScaleY','_isBattlerFlipped','Radius','Sprite_Actor_moveToStartPosition','head','open','mainSprite','ShowHide','VisuMZ_2_PartySystem','dataId','battleCommands','DefaultSoftScaler','DfTtT','isShownOnBattlePortrait','EUruA','JumpToLabel','stop','pweDG','JOrBG','join','performEvasion','isNextScene','initVisibility','applyHardDamageCap','_growY','actor%1-portrait','removeImmortal','resizeWindowXPStyle','InDSr','Game_Battler_clearDamagePopup','ActSeq_Mechanics_SwapWeapon','dragonbonesData','performActionEndMembers','isAlive','createDistortionSprite','SlotID','battleEnd','RmqQy','ActSeq_Mechanics_OtbOrder','ikepA','BattleManager_endAction','EnableDamageCap','isOkEnabled','log','maxBattleMembers','ZVGgj','isBattleCoreTargetScope','Skill-%1-%2','indexOf','getNextSubjectFromPool','HpGauge','param','Damage','ActSeq_Skew_WaitForSkew','zcKnk','textWidth','frameVisible','weapons','_multipliers','Scene_Boot_onDatabaseLoaded','DefaultDamageStyle','zMYlI','speed','updateWaitMode','alive\x20actors','IconSet','dTRCz','ActSeq_BattleLog_UI','CriticalColor','loadBattleback1','damageContainer','CoUTf','setBattlerMotionTrailData','linkSprite','loadBattleback2','HelpEscape','abnormal','yihse','animationShouldMirror','sliceMax','jKVEA','AYdgF','IRSwN','setupChild','CounterPlayback','padding','displayEvasion','Scene_Battle_startActorCommandSelection','PostApply%1JS','zzkJE','VisuMZ_4_CombatLog','HBzoD','WaitForEffect','_opacityEasing','trim','paXDL','actor','canEscape','not\x20focus','Game_Action_makeTargets','eVcWG','_target','MNfEM','drawTextEx','fkWCd','_distortionSprite','partyCommandWindowRectDefaultStyle','randomTargets','onEncounter','Scene_Map_updateCallMenu','criticalDmgFlat','_enemyWindow','CastAnimation','BattleManager_startInput','isSideButtonLayout','KsHLe','SDAwB','%1StartTurnJS','EUaew','Scene_Battle_startPartyCommandSelection','nameY','createBorderStylePortraitSprite','alive\x20friends\x20not\x20target','right','ext','_linkedSprite','contentsOpacity','ArWuT','VisuMZ_3_ActSeqImpact','clearMotion','ShowFacesListStyle','cWpvr','maxCommands','addFightCommand','StyleName','setBackgroundType','CmdStyle','battlerSprites','ActSeq_Impact_MotionBlurScreen','createKeyJS','JS\x20BATTLE\x20DEFEAT','BattleManager_onEscapeSuccess','IconStypeNorm','setupTextPopup','uPzPd','Sprite_Battler_updateMain','setImmortal','fGDWG','reccr','item','MgeaV','animationBaseDelay','_enemy','isForOpponentBattleCore','ActSeq_Impact_ShockwaveEachTargets','autoBattleStart','alive\x20friends\x20not\x20user','FocusX','popupDamage','_flashDuration','performMoveToPoint','ActSeq_Animation_ShowAnimation','useDigitGrouping','oLriw','autoMeleeSingleTargetActionSet','wholeActionSet','Setting','cancelActorInput','OverallFormulaJS','isConfused','origin','JS\x20%1START\x20BATTLE','ActSeq_Weapon_NextActiveWeapon','_enemyId','_scene','attackStates','Scene_Map_launchBattle','onDatabaseLoaded','Sprite_Enemy_update','%1Event','_cursorArea','repositionEnemiesByResolution','damage','setSvBattlerSprite','playReflection','friendsUnit','filters','Game_Battler_performActionStart','CheckMapBattleEventValid','bNRJq','updateBorderSprite','Game_Action_isForRandom','mainFontSize','battleUIOffsetY','process_VisuMZ_BattleCore_TraitObject_Notetags','isSkillItemWindowsMiddle','EECKB','EscapeSuccess','CgVsT','CastMagical','ActSeq_Animation_AttackAnimation2','innerWidth','repeats','isAnyoneJumping','hide','selectNextActor','createAnimationContainer','forceSelect','ScaleY','BaseTroopIDs','canUse','qpFeP','Game_Actor_makeActionList','SkewY','XPActorCommandLines','STYPES','getWtypeIdWithName','MotionType','MotionSpeed','Opacity','swing','OffsetX','_wtypeIDs','WiBLT','_duration','DEF','PrioritySortActive','ShuffleArray','iconWidth','commandName','sortEnemies','Window_BattleLog_pushBaseLine','VisuMZ_3_BoostAction','createUIContainer','_battler','ActSeq_Mechanics_PtbAlterCost','Window_BattleLog_performSubstitute','FlashColor','_colorType','remove','ShowEnemyGauge','Game_Party_removeActor','ScaleUp','gWwQb','_speed','ZMkBC','DtTZA','action','wpdBJ','VariableID','ActSeq_Motion_PerformAction','endAnimation','delay','requestRefresh','ZbtnC','Elements','_targetSkewY','ActSeq_Mechanics_CtbOrder','AutoMeleeSolo','findTargetSprite','Enemy','_createDamageContainer','validTargets','tRcFQ','Window_BattleLog_update','startTpbTurn','RueVT','xBjTW','_cacheTextWidth','LJOBl','OffsetY','Scene_Battle_startEnemySelection','_createCursorArea','custom','setActionState','okButtonText','damageRate','removeHorrorEffect','PYOwK','SYNiv','BattleEndEvent','effects','updateHpGaugePosition','displayCurrentState','_targetSkewX','_animationContainer','attackStatesRate','battleMove','xovHr','_frontAttachmentSprite','EscapeFailureJS','changeCtbCastTime','STRUCT','jLlTz','moveToStartPosition','isBattlerGrounded','setBattlerBattleCore','XIlhP','updateCustomActionSequence','battleAnimation','updateAttachedSprites','cancel','ActSeq_BattleLog_DisplayAction','WaitForCamera','anchorX','onNKT','States','buffRemove','ShowCurrentState','pSUYx','setHelpWindow','round','onEscapeFailure','addItemCommand','process_VisuMZ_BattleCore_CreateRegExp','Reveal','CmdIconFight','Dwvlr','TimeScale','CsuGv','createPartyCommandWindow','ktiKG','_enemySprites','addSkillTypeCommand','gwztH','isDebuffAffected','startDamagePopup','BattleLogRectJS','ActSeq_Horror_Clear','WaitCount','Game_Action_executeDamage','Index','Skills','Sprite_Weapon_loadBitmap','\x0a\x20\x20\x20\x20\x20\x20\x20\x20//\x20Declare\x20Arguments\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20arguments[0];\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20a\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20b\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20let\x20targets\x20=\x20arguments[1];\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20//\x20Process\x20Code\x0a\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20//\x20Return\x20Value\x0a\x20\x20\x20\x20\x20\x20\x20\x20return\x20targets\x20||\x20[];\x0a\x20\x20\x20\x20','VisuMZ_2_WeaponSwapSystem','isChangingOpacity','attackAnimationId1','absCQ','WaitForSpin','DefeatEvent','tpbCommandFight','cledj','ActSeq_Mechanics_StbExtraAction','HggCR','FlinchDuration','inputtingAction','_backAttachmentSprite','IlUQp','CalcEscapeRatioJS','GivvN','process_VisuMZ_BattleCore_Failsafes','occasion','Mute','sttIW','osNKe','getDefeatedEnemies','TpbGaugeOffsetX','Formula','20UrhfvE','ActSeq_Mechanics_AddState','svShadow','isBattleRefreshRequested','_shake','startAction','maxLines','_floatEasing','CreateActionSequenceTargets','_dimmerSprite','VisuMZ_2_BattleSystemPTB','OMvbl','freezeMotion','loadSystem','makeTargets','gainCurrentActionsFTB','ITEM','Sprite_Enemy_setBattler','process_VisuMZ_BattleCore_jsFunctions','hpDamage','forceMotion','updatePadding','SkillsStatesCore','sideview_ui','addDebuff','endAction','fcitl','terminate','ActSeq_Target_CurrentIndex','ActSeq_Animation_PlayAtCoordinate','createEnemyNameContainer','uqSzT','needsSelection','Window_BattleLog_popupDamage','moveBattlerToPoint','dead','AutoMeleeAoE','attackAnimationId2','startFloat','QoL','ShowCritical','iWqMp','initialize','nCHBm','getChildIndex','PerformAction','height','isBattleFlipped','getInputButtonString','Game_Map_setupBattleback','PreEndActionJS','VisuMZ_2_BattleSystemOTB','createAllWindows','startTurn','DBrAx','Sprite_Actor_updateBitmap','startMove','createJS','_lastPluginCommandInterpreter','_dragonbonesSpriteContainer','ZVbkA','AmtFA','_angleEasing','_checkOn','BARE\x20HANDS','updateEffectContainers','iCdov','transform','performActionMotions','startActorSelection','windowskin','_targets','updateBitmap','SsWuX','isAnyoneSpinning','isGuard','vIluW','recoverAll','ActSeq_Mechanics_BreakShieldChange','NKIcf','AddHpGaugeOption','autoBattleAtStart','extraHeight','pqIjr','children','PLAnR','VisuMZ_3_ActSeqProjectiles','MHNvh','prepareCustomActionSequence','maxCols','isBreakStunned','anchorY','forceWeaponAnimation','mGjik','WGcIg','getHalfActionsPTB','guard','isDuringNonLoopingMotion','createDamageSprite','HalfActions','FLACu','displayCritical','txbob','gainHp','Buffs','yyNcy','ActSeq_Motion_RefreshMotion','VisuMZ_2_BattleSystemSTB','textSizeEx','emerge','attackSkillId','isForAll','ActSeq_Horror_NoiseCreate','PreApplyAsTargetJS','updateAttachmentSprites','130854UvNsAM','_weaponSprite','isMeleeSingleTargetAction','onFloatEnd','AlFZc','anchor','isChanting','performTpbActiveCheckSwitch','drain','isDeathStateAffected','Scene_Battle_terminate','%1StartBattleJS','kBhxz','ScaleX','selectPreviousCommand','ActSeq_Mechanics_AnalyzeWeakness','performMoveToTargets','cCkzv','visible','ActiveTpbOptionsMessage','Sprite_Enemy_initVisibility','jMyrT','Game_Action_itemHit','checkShowHideSwitchNotetags','_waitCount','ceil','snapForBackground','ShowRemovedState','createBattleUIOffsetY','PixGE','applyDamageCaps','_uiContainer','Window_Options_addGeneralOptions','isPlaytest','ZobAn','_angleDuration','createSeparateDamagePopups','isAnyoneSkewing','removeState','loCbD','Window_BattleEnemy_initialize','UcNoa','TlrrM','setBattleSkew','VPVjJ','ShowMissEvasion','Window_SkillList_maxCols','startBattle','bPTHN','tPBCw','ActSeq_Impact_ShockwaveCenterTargets','cOpfs','clearElementChanges','mpDamage','GroupDigits','VisuMZ_2_BattleSystemCTB','TvfrB','stepForward','currentAction','erymO','makeDamageValue','ActSeq_ChangeAngle','WBYtJ','DhcRa','vZOwG','CombatLogIcon','hwOBP','string','removedBuffs','refreshStatusWindow','Window_BattleLog_displayCurrentState','CommandAddOptions','isMagicSkill','toUseBoostPoints','numTargets','displaySubstitute','qxRJg','_deathStateApplied','Parse_Notetags_TraitObjects','AutoBattleRect','_cache','clearBattleRefreshRequest','createContents','qcXkl','expRate','StatusWindowAttachmentBack','auto','vDWqr','repositionCancelButtonBorderStyle','ActSeq_Impact_ShockwavePoint','isAffectedByBreakShield','alive\x20opponents','MhEWt','FullActions','PostStartActionJS','isJumping','VisuMZ_3_WeaknessDisplay','Scene_Battle_onEnemyCancel','ForceDeath','status','singleSkill','extraPositionX','_growX','gaugeLineHeight','applyData','isSceneChanging','ActionEndUpdate','isActor','ECDwG','startInput','ParseActorNotetags','PreDamageAsTargetJS','FaceAway','hue','Window_BattleLog_clear','ArPenFlat','displayBuffs','_ptbActionCost','canUseItemCommand','PostApplyAsTargetJS','ActSeq_Mechanics_PtbConvert','XOpAw','updateMain','svBattlerName','setFullActionsPTB','Window_BattleEnemy_show','updateLink','ActSeq_Movement_FacePoint','setupBattleback','performCounter','CurrentTurn','ActionSkillMsg2','ActSeq_Horror_GlitchRemove','BcVIE','trueRandomTarget','_enemyNameContainer','angle','isTpbCharged','isPartyTpbInputtable','onEncounterBattleCore','AutoBattle','process_VisuMZ_BattleCore_Action_Notetags','ActSeq_Movement_WaitForJump','svBattlerAnchorX','_borderPortraitDuration','tATaY','EGaxo','StatusWindowSelectableBackHide','canInput','setHalfActionsPTB','adjustWeaponSpriteOffset','NUjkA','FzMOY','resetResultSwitches','eBela','_growDuration','iterateBattler','isCTB','ActSeq_Mechanics_DamagePopup','RgQKs','onGrowEnd','jchUr','AsUser','_motionSpeed','CZZJo','ActSeq_Movement_WaitForSpin','updateStateSpriteBattleCore','createTargetsJS','Scene_ItemBase_applyItem','FlinchDistanceX','addAutoBattleCommand','applyVariance','nKvVj','Game_Action_isForOpponent','CXGlM','chantStyle','htOEm','SKXDS','StepDistanceY','playEnemyDamage','BattleDefeatJS','jNvaa','process_VisuMZ_BattleCore_PreBattleCommonEvent','process_VisuMZ_BattleCore_PluginParams','updateAction','startJump','ActSeq_Impact_MotionTrailRemove','GuardFormulaJS','removeAnimationFromContainer','MxVhN','yRHMP','spinBattler','makeActionOrders','PostStartTurnJS','1:1','SkipPartyCmd','needsSelectionBattleCore','isTeamBased','qUAUZ','UXtma','growBattler','IconStypeMagic','ActSeq_DB_DragonbonesMotionAni','allBattleMembers','battleOpacity','_jumpWholeDuration','AllowCollapse','surprise','Window_BattleLog_performDamage','autoSelect','getStypeIdWithName','applyFreezeMotionFrames','deadMembers','SmoothImage','isDisplayEmergedEnemies','Scene_Battle_selectPreviousCommand','battleDisplayText','mainSpriteScaleX','HovUc','CmdTextAutoBattle','nZoRn','ApplyImmortal','CfLwP','TivBA','statusWindowRect','_weaponImageId','processForcedAction','inBattle','setHome','_forcing','_stateSprite','_phase','Sprite_Actor_createStateSprite','floor','_commandNameWindow','changeWeather','setupBattleCoreData','hpAffected','xPpSg','CreateCommonEventKeys','ActSeq_Projectile_Icon','FUNC','_growWholeDuration','btCIR','windowAreaHeight','<CUSTOM\x20ACTION\x20SEQUENCE>','ActSeq_Projectile_Animation','ActSeq_Impact_MotionTrailCreate','vxMnT','MpGaugeOffsetY','autoBattle','Sprite_Enemy_updateStateSprite','_battlerName','parent','ForceExploiter','mzxyp','setBattlerFacePoint','StyleON','CmdTextAlign','EmergeText','getColor','Game_Action_itemEffectAddAttackState','autoBattleWindowRect','battlerShadowScaleX','QoVJc','_skewWholeDuration','match','getMenuImage','GLVej','createCancelButton','ShowTpDmg','softDamageCap','evade','RLtHK','MNZUi','Linear','QGkka','Game_Interpreter_command283','ParseClassNotetags','floatBattler','displayMiss','ActSeq_Camera_WaitForCamera','AnimationID','slices','applyTargetFilters','YjOAN','iBZQF','evaded','Shadow2','_damages','Game_BattlerBase_canAttack','CheckSkillCommandShowSwitches','encounterList','qnkVO','HCTRQ','applyGlobalCommonEventNotetags','BattleManager_makeActionOrders','Kbtne','CriticalHitFlat','formula','damageOffsetX','waitCount','equips','sHloQ','attachSpritesToDistortionSprite','Game_BattlerBase_die','SvWeaponSolo-%1-%2','placeActorName','CDIxf','opacityStart','updateShadowVisibility','HelpAutoBattle','battleLayoutStyle','QtrXo','onOpacityEnd','ReflectAnimation','processVictory','_cursorSprite','MXfkt','qgsfk','onJumpEnd','applyImmortal','helpAreaHeight','getHardDamageCap','Pre','createLowerLayer','EJmTh','_svBattlerSprite','THqTv','hPlmM','isQueueOptionsMenu','Window_BattleStatus_drawItemImage','ActSeq_BattleLog_WaitForBattleLog','_lastEnemy','State-%1-%2','OffsetAdjust','arogk','MANUAL','DResH','PopupOffsetX','PopupShiftY','ARRAYFUNC','ActionSkillMsg1','attackAnimationIdSlot','_borderPortraitSprite','registerDefeatedEnemy','ShowPortraits','battleMembers','filterArea','QyuUb','rzyBg','ParseArmorNotetags','DamageStyles','_tpbSceneChangeCacheActor','RzhqH','ActSeq_Set_SetupAction','RwwGP','statusTextAutoBattleStyle','Window_ItemList_maxCols','currentExt','Angle','fgagi','escape','Spriteset_Battle_updateActors','pEzat','NUTVj','vceil','isPartyCommandWindowDisabled','PostEndActionJS','NameOffsetX','switchToWeaponType','checkTpbInputOpen','WaitForAnimation','svBattlerAnchorY','DefaultHardCap','VisuMZ_2_BattleSystemFTB','IzzXD','_tempActor','NTJNN','ArRedRate','dyQve','VisuMZ_1_MainMenuCore','ActSeq_Movement_Spin','evalDamageFormulaBattleCore','JS\x20%1START\x20TURN','addAutoBattleCommands','ConfigManager_applyData','battler','ActSeq_Mechanics_RemoveState','makeSuccess','customDamageFormula','actionBattleCoreJS','_appeared','alignBattleCoreDamageSprite','svAnchorY','toLowerCase','IeYqp','SvBattlerSolo-%1-%2','updateFrame','ActSeq_Movement_MoveToTarget','_jumpMaxHeight','Targets1','_list','SvWeaponMass-%1-%2','qLyXp','physical','ActSeq_Element_Clear','actorCommandCancelTPB','RegExp','_padding','VvHhT','performJump','battleCameraData','UTwcT','makeAutoBattleActions','_text','statusText','oJAHr','drawBackgroundRect','toUpperCase','CalcActionSpeedJS','bitmapHeight','removeActor','performAttack','PopupPosition','loadSvEnemy','gXypq','NameAlwaysSelectOnly','StartTurnShow','BNLSI','boxHeight','ActionItemMsg','Scene_Battle_createCancelButton','Scene_Battle_updateStatusWindowPosition','DYxTI','_attackAnimationId','OIRsP','startSkew','_actorSprites','createWeather','ATTACK','prepareBorderActor','_effectDuration','HZAtK','Window_BattleLog_popBaseLine','makeActions','_waitMode','WaitForProjectile','isActionSelectionValid','callNextMethod','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','WafvS','QKXPW','Exploited','CastPhysical','BravePoints','_forcedBattlers','battleCommandIcon','GseJZ','commandNameWindowDrawBackground','QRsFB','Amp','createShadowSprite','animationNextDelay','isSkill','SKILLS','DefaultStyle','command119','adjustPosition_ScaleUp','_createEffectsContainer','gainFullActionsPTB','battleStatusWindowAnimationContainer','attackMotions','isBattlerFlipped','hitRate','ActSeq_Animation_AttackAnimation','showHelpWindow','putActiveBattlerOnTop','cameraOffsetDuration','40tQAgQX','setValue','CmdIconItem','eClAz','_jumpDuration','NJXMS','canGuard','SwitchCritical','ActSeq_Horror_TVCreate','Cohbm','drawGauge','ActSeq_Horror_GlitchCreate','NameOffsetY','motionIdle','worldTransform','Scene_Battle_createHelpWindow','hasSkill','Game_BattlerBase_canGuard','clearResult','DMEUU','qOWMZ','CmdIconEscape','hdCyB','itemLineRect','Scene_Battle_updateBattleProcess','note','visibilityState','ActSeq_Target_RandTarget','redraw','CJhJG','battleZoom','HitRate','setLastPluginCommandInterpreter','_armorPenetration','OVKyQ','okTargetSelectionVisibility','_enemyIDs','_item','uoFZS','LIdEI','nCKRj','nogpT','svBattlerData','JgsUy','Style','setCustomDamageFormula','_currentAngle','addImmortal','getCommonEventIdWithName','Defeat','displayFailure','TpbActiveChangeEnabled','NewPopupBottom','updateBattleProcess','Game_BattlerBase_initMembers','gsQOu','_commonEventIDs','createCommandVisibleJS','hkRuC','scope','ubdAG','Battleback','mnabQ','_handlers','targetSpritePosition','isBypassDamageCap','createBattleFieldBattleCore','setHue','startSpin','%1Apply%2JS','ActSeq_Mechanics_StbRemoveExcessActions','_battleCoreBattleResumeAfter','updateStateSprite','wGRHq','GKfTn','checkShowHideBattleNotetags','fhjnC','clearWeaponAnimation','ActionAnimation','visualHpGauge','_skewX','SkewX','JPvAG','599536rMcmdK','StatusWindowAttachmentBackOffsetY','getDualWieldTimes','JMyHX','ActionEffect','compareBattlerSprites','spriteId','aACoF','equipSlots','_opacityDuration','Variable','LTfXO','JHlSn','HbgDL','updateStyleOpacity','UJXvG','Scene_Battle_createAllWindows','isOTB','partyCommandWindowRectBorderStyle','_baseY','turnCount','Mirror','_tempEquipCheck','vcceC','_totalValue','unjCw','JOcyC','Sprite_Actor_update','priority','setupShockwaveImpactFilter','autoBattleStyle','ScaleDown','drawItem','updatePosition','performMagicEvasion','clearBattleCoreData','addTextToCombatLog','HitFlat','stepBack','nYzRX','nqUVR','placeStateIcon','ShowMpDmg','Game_Action_itemEffectAddNormalState','pushBaseLine','setActorHome','WaitForMovement','SkillItemBorderCols','unchanged','Scene_Battle_itemWindowRect','bENHv','TextAlign','ActSeq_BattleLog_AddText','ResetOffset','Game_Interpreter_terminate','applyResultSwitches','_actorCommandWindow','updateCancel','drawItemStatusXPStyle','_requestRefresh','_tpbNeedsPartyCommand','clearDamagePopup','skill','BattleVictoryJS','mainSpriteWidth','Scene_Battle_logWindowRect','Spriteset_Battle_createBattleField','wcFtO','HP_Flat','CmdIconAutoBattle','attack','isMagical','DistanceX','performAction','VisuMZ_2_DragonbonesUnion','xYCei','KvrYw','hardDamageCap','TPB','Scene_Battle_partyCommandWindowRect','SceneManager_isSceneChanging','khDyA','miiqY','needsActorInputCancel','dOkwn','PortraitScale','uPKRx','EFFECT_COMMON_EVENT','requestMotionRefresh','performDamage','sort','targetActionSet','Spriteset_Battle_createLowerLayer','PreDamage%1JS','isAutoBattleCommandAdded','invokeAction','Sprite_Battler_update','commandFight','JSON','drawItemStyleIconText','_partyCommandWindow','_damageContainer','regionId','UNTITLED','isAnyProjectilePresent','isEnemy','_motion','isTpbMainPhase','ActSeq_Movement_FaceTarget','isAnyoneFloating','skew','backColor','MGxyo','kONwo','isAtbChargingState','qqJDC','ActSeq_Motion_WaitMotionFrame','isBattleSys','BattleManager_processVictory','oxbzN','BattleCore','scale','chant','nwawx','ZWOdt','StatusWindowSkinFilename','Scene_Battle_startActorSelection','angleDuration','updateGrow','isFrameVisible','Game_Actor_setup','applyArmorModifiers','calcWindowHeight','HomePosJS','UnmCi','UuJgE','_opacityWholeDuration','_spriteset','_floatHeight','fFads','setBattleAngle','DTtYE','_back2Sprite','isOpponent','AS\x20USER','_lastRegenFrameCount','duration','gainHalfActionsPTB','frameCount','type','tpbActorSwitchConditionsMet','sleep','VwYTL','gainMp','hTANA','isSTB','Post','BattleManager_startBattle','Window_BattleLog_performCollapse','battleSpriteSkew','process_VisuMZ_BattleCore_Notetags','Window_BattleLog_refresh','jQYtB','BfodZ','isGuardWaiting','createBattleFieldContainer','GYzXA','createStateIconSprite','cEVUM','YGRxD','PostEndBattleJS','MotionFrameWait','gcFrk','waitForMovement','createActionSequenceProjectile','VVHXi','_effectType','_svBattlerData','getBattlePortraitOffsetX','makeTargetSelectionMoreVisible','ParseAllNotetags','createAttachedSprites','addPartyCommand','applyItem','isFloating','result','jNREC','fillRect','updateBattlebackBitmap2','KPBfL','callOptions','filter','dead\x20friends','QMEcb','_lineHeight','index','user','LZAoQ','battlelog','extraPositionY','_executedValue','requestDragonbonesAnimation','LUoyp','hitFlat','lBFJm','ActSeq_Mechanics_Collapse','zdBVf','addSingleSkillCommand','drawEnemyName','helpAreaBottom','_shadowScaleY','Game_Battler_regenerateAll','FaceDirection','isAnyoneChangingOpacity','mCmIs','NDVka','uiMenuStyle','playCancel','isMeleeMultiTargetAction','DKWRu','bAgBn','DTB','waitForAnimation','isNonSubmenuCancel','BattleManager_initMembers','max','aoMiB','setBattlerFlip','MP_Flat','dwWxH','%1EndActionJS','tHGHF','MVdRz','displayTpDamage','performSTBExploiter','PostApplyJS','refreshBattlerMotions','resizeWindowBorderStyle','createChildSprite','VisuMZ_0_CoreEngine','initElementStatusCore','isPreviousScene','qkFsh','clearActiveWeaponSlot','JXxmf','StatusWindowSkinHide','lineRect','addAttackCommand','magicSkills','YgnAB','krrXg','turnOrderChangeOTB','ActSeq_Camera_Offset','TP_Flat','itemRect','%1StartActionJS','alive\x20opponents\x20not\x20target','MYCKe','performActionStart','Azvjc','isVisualHpGaugeDisplayed','itemHit','ORUXL','fqUhl','motionType','ActSeq_Mechanics_DeathBreak','ConvertActionSequenceTarget','Window_BattleLog_displayMpDamage','Class-%1-%2','Parse_Notetags_Action','ActSeq_Mechanics_StbExploit','CoreEngine','KrzMq','BattleCmdList','adjustFlippedBattlefield','PostStartBattleJS','bcnas','getNextSubject','ynwjB','CmdIconOptions','ForceRandom','changeCtbChargeTime','RequiresDefeat','ActSeq_Angle_Reset','updateForceAction','ZsxAo','IyIrY','performReflection','Window_BattleLog_displayMiss','getSkillIdWithName','isAutoBattle','adjustPosition_1for1','isEffecting','isForRandom','lFqoE','makeBattleCommand','isETB','nBBkX','addChildAt','RpcuP','dTXlF','uwEiF','shift','-%1','skillWindowRect','blockWidth','NameFontSize','createAutoBattleWindow','\x0a\x20\x20\x20\x20\x20\x20\x20\x20//\x20Declare\x20Arguments\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20arguments[0];\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20skill\x20=\x20arguments[1];\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20a\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20b\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20let\x20visible\x20=\x20true;\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20//\x20Process\x20Code\x0a\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20//\x20Return\x20Value\x0a\x20\x20\x20\x20\x20\x20\x20\x20return\x20visible;\x0a\x20\x20\x20\x20','updateWeather','_tpbState','onEnemyCancel','Game_Interpreter_updateWaitMode','PopupOffsetY','cameraClamp','undecided','opponentsUnit','fontSize','Shadow','Game_BattlerBase_isStateResist','uvrzt','startWeaponAnimation','dztwQ','_flashColor','skillTypes','Scene_Battle_onActorCancel','StartTurnMsg','BattleManager_onEncounter','drawItemStatusListStyle','oCpma','ParseWeaponNotetags','emMzP','SHGNm','_shadowSprite','setBattleCameraPoint','commandStyle','zVkHq','changeAtbChargeTime','hnBnn','ActSeq_Mechanics_BoostPointsStoreData','StatusWindowAttachmentFrontOffsetY','processDefeat','dead\x20enemies','ActSeq_Mechanics_ActionEffect','getBattlePortraitFilename','6sMUVym','finishActionSet','tCDiu','battleCommandName','WaitForAngle','bitmap','_hpGaugeSprite','isUndecided','alive\x20enemies\x20not\x20target','drawItemStyleIcon','adjustPosition','_actor','ShowAddedBuff','PreApplyAsUserJS','_battleCoreAddedElements','Window_BattleLog_performMiss','ArPenRate','SwitchMissEvade','close','Settings','applySoftDamageCap','expTotal','battleCamera','regenerateAllBattleCore','SkillItemStandardCols','_cancelButton','ShowRemovedBuff','isAnimationPlaying','battleAngle','Sprite_Actor_updateShadow','isForOne','xWkEB','onBattleStart','front\x20base','forceAction','JGbnq','GWlIq','message1','targetDistortionSpritePosition','qsxpl','Game_Action_evalDamageFormula','swapEnemyIDs','showEnemyAttackAnimation','_lines','eSYeL','_stateIconSprite','waitForOpacity','refresh','autoBattleUseSkills','reduce','blt','ParseEnemyNotetags','AQZKM','isSceneBattle','adDHa','POST-','aphLf','addText','battleCoreResumeLaunchBattle','repeatTargets','alterBreakShield','command283','BattleManager_onEscapeFailure','adjustPosition_ScaleToFit','Bedge','refreshMotion','WaitCount2','list','pTUOr','_motionType','all\x20targets','createDamageContainer','NzETU','BindCommonEventKeysForGroup','pow','frhIs','FocusY','PartyCmd','%1RegenerateJS','uOkxt','actorCommandEscape','mljXj','isDead','_floatDuration','_action','APEPU','_index','applyGlobal','_updateClientArea','ShowCounter','clearForcedGameTroopSettingsBattleCore','Intensity','tazoV','allowCollapse','Sprite_Battler_isMoving','ActSeq_Weapon_ClearActiveWeapon','PreDamageAsUserJS','Armor-%1-%2','DJMyF','refreshActorPortrait','_skewDuration','startPartyCommandSelection','dimColor1','yvBkP','removeAnimation','setupZoomBlurImpactFilter','wtypeId','hasSvBattler','alterPriority','addActor','buffAdd','BVcPf','alive\x20battlers\x20not\x20user','Game_System_initialize','value1','Game_Battler_onTurnEnd','getEnemyIdWithName','isBuffAffected','MjyPg','ActSeq_Zoom_WaitForZoom','AllowRandomSpeed','ResetFocus','updateVisibility','KzzUH','processEscape','skillItemWindowRectBorderStyle','DZugu','isDamagePopupRequested','useItem','updateBattlebackBitmap','VisuMZ_4_BreakShields','ojFuj','commandNameWindowCenter','BattleManager_startAction','wGSra','Actor-%1-%2','createAttachmentSprites','qrjlq','kDbqe','sliceMin','Game_BattlerBase_eraseState','selectNextCommandTpb','actorCommandSingleSkill','onEscapeSuccess','setHelpWindowItem','Scene_Battle_skillWindowRect','isActiveTpb','targetObjects','RVONR','ptSxq','_baseLineStack','stateMotionIndex','MotionIdle','finishActorInput','_indent','Sprite_Enemy_updateBossCollapse','getAttackMotion','performSubstitute','softDamageCapRate','_immortal','fight','HFvre','left','ShowReflect','gainStoredBoostPoints','_autoBattle','criticalDmgRate','onActorOk','bitmapWidth','walk','jiEhG','battleGrow','PUAWc','_iconIndex','loadWindowskin','Sprite_Battler_updatePosition','updateShadowScale','SwOTe','setFrame','isMoving','PreApplyJS','Weapon-%1-%2','+%1','eraseState','BattleLayout','_allTargets','center','prev\x20target','_visualHpGauge_JustDied','BattleLog','helpWindowRect','focus','Game_Battler_onBattleStart','_floatWholeDuration','PostEndTurnJS','COMBAT\x20LOG','format','collapseType','_defeatedEnemies','Sprite_Battler_setBattler','JS\x20%1END\x20BATTLE','loop','MpGaugeOffsetX','Game_Battler_performDamage','Sprite_Animation_targetSpritePosition','alterCost','oQCgf','setupWeaponAnimation','actionSplicePoint','updateInterpreter','showNormalAnimation','Game_Battler_makeSpeed','xGKxE'];_0x477f=function(){return _0x15bab5;};return _0x477f();}function Sprite_HpGauge(){const _0x3d7f29=_0x251720;this[_0x3d7f29(0x43e)](...arguments);}Sprite_HpGauge[_0x251720(0x97e)]=Object[_0x251720(0x9f9)](Sprite_Gauge[_0x251720(0x97e)]),Sprite_HpGauge[_0x251720(0x97e)][_0x251720(0x8c)]=Sprite_HpGauge,Sprite_HpGauge[_0x251720(0x97e)][_0x251720(0x43e)]=function(){const _0x2da6e4=_0x251720;Sprite_Gauge[_0x2da6e4(0x97e)][_0x2da6e4(0x43e)][_0x2da6e4(0xa57)](this);},Sprite_HpGauge['prototype'][_0x251720(0xab7)]=function(){return 0x0;},Sprite_HpGauge[_0x251720(0x97e)][_0x251720(0x682)]=function(){const _0x390d5c=_0x251720;this[_0x390d5c(0x817)][_0x390d5c(0x90f)]();const _0x5aabbe=this[_0x390d5c(0x11f)]();!isNaN(_0x5aabbe)&&this[_0x390d5c(0x670)]();};function Sprite_EnemyName(){const _0x207385=_0x251720;this[_0x207385(0x43e)](...arguments);}Sprite_EnemyName[_0x251720(0x97e)]=Object[_0x251720(0x9f9)](Sprite_Name[_0x251720(0x97e)]),Sprite_EnemyName['prototype'][_0x251720(0x8c)]=Sprite_EnemyName,Sprite_EnemyName[_0x251720(0x97e)][_0x251720(0x43e)]=function(){const _0x32e045=_0x251720;Sprite_Name['prototype'][_0x32e045(0x43e)][_0x32e045(0xa57)](this),this[_0x32e045(0x76e)]();},Sprite_EnemyName['prototype'][_0x251720(0x147)]=function(){const _0x59014b=_0x251720;Sprite_Name[_0x59014b(0x97e)]['initMembers'][_0x59014b(0xa57)](this),this[_0x59014b(0x8f9)]=0x0,this[_0x59014b(0x32a)]=null,this['anchor']['x']=0.5,this[_0x59014b(0x48c)]['y']=0x0;},Sprite_EnemyName['prototype']['createAttachedSprites']=function(){const _0x37b5cf=_0x251720;if(VisuMZ[_0x37b5cf(0x731)][_0x37b5cf(0x825)][_0x37b5cf(0x3b1)][_0x37b5cf(0x11c)]){if(_0x37b5cf(0x306)!==_0x37b5cf(0xaaa))this['_stateIconSprite']=new Sprite_StateIcon(),this[_0x37b5cf(0x26f)](this[_0x37b5cf(0x83f)]);else{const _0xdea4be=_0x449650[_0x37b5cf(0x35b)][_0x37b5cf(0x6cb)]();this[_0x37b5cf(0x1b9)](_0xdea4be['x'],_0xdea4be['y'],_0xdea4be[_0x37b5cf(0x139)],_0xdea4be[_0x37b5cf(0x442)]),this[_0x37b5cf(0x4d9)](),this[_0x37b5cf(0x334)](0x0);}}},Sprite_EnemyName[_0x251720(0x97e)][_0x251720(0x8ba)]=function(){const _0x4b0fc5=_0x251720;return Graphics[_0x4b0fc5(0x13f)];},Sprite_EnemyName[_0x251720(0x97e)][_0x251720(0x62c)]=function(){const _0x3c7ae4=_0x251720;return this[_0x3c7ae4(0x77b)]=this[_0x3c7ae4(0x77b)]||Window_Base[_0x3c7ae4(0x97e)][_0x3c7ae4(0x1d8)]()||0x24,this['_lineHeight']*0x4;},Sprite_EnemyName[_0x251720(0x97e)][_0x251720(0x7f6)]=function(){const _0x25d05d=_0x251720;return VisuMZ[_0x25d05d(0x731)]['Settings']['Enemy'][_0x25d05d(0x7eb)]||$gameSystem[_0x25d05d(0x36d)]();},Sprite_EnemyName['prototype'][_0x251720(0x2f6)]=function(_0x2f4358){this['_linkedSprite']=_0x2f4358;},Sprite_EnemyName[_0x251720(0x97e)]['update']=function(){const _0x1a362c=_0x251720;Sprite_Name[_0x1a362c(0x97e)][_0x1a362c(0xc8)]['call'](this),this['updateLink'](),this[_0x1a362c(0x6da)](),this[_0x1a362c(0x3d9)](),this['updateOpacity']();},Sprite_EnemyName[_0x251720(0x97e)][_0x251720(0x682)]=function(){const _0x3be958=_0x251720;this['_cacheTextWidth']=undefined;const _0x10a4b6=this['name'](),_0x2df19b=this[_0x3be958(0x8ba)](),_0xc2b195=Window_Base['prototype'][_0x3be958(0x1d8)]();this[_0x3be958(0x8ff)](),this[_0x3be958(0x817)]['clear'](),this['bitmap']['drawText'](_0x10a4b6,0x0,0x0,_0x2df19b,_0xc2b195,'center');},Sprite_EnemyName[_0x251720(0x97e)][_0x251720(0x505)]=function(){const _0xdf31f8=_0x251720;if(!this[_0xdf31f8(0x32a)])return;this[_0xdf31f8(0x397)]!==this[_0xdf31f8(0x32a)][_0xdf31f8(0x397)]&&this[_0xdf31f8(0x1ea)](this[_0xdf31f8(0x32a)][_0xdf31f8(0x397)]);},Sprite_EnemyName[_0x251720(0x97e)][_0x251720(0x6da)]=function(){const _0x27df82=_0x251720;if(!this[_0x27df82(0x32a)])return;this[_0x27df82(0x77b)]=this[_0x27df82(0x77b)]||Window_Base[_0x27df82(0x97e)]['lineHeight'](),this['x']=this['_linkedSprite']['_baseX'],this['y']=this['_linkedSprite'][_0x27df82(0x6cc)]-this['_lineHeight']*0.5;const _0x389261=VisuMZ['BattleCore'][_0x27df82(0x825)]['Enemy'];this['x']+=_0x389261['NameOffsetX']||0x0,this['y']+=_0x389261['NameOffsetY']||0x0;},Sprite_EnemyName['prototype'][_0x251720(0x3d9)]=function(){const _0x37f667=_0x251720;this[_0x37f667(0x73)]();},Sprite_EnemyName['prototype'][_0x251720(0x73)]=function(){const _0x2db3c0=_0x251720;if(!this['_stateIconSprite'])return;this[_0x2db3c0(0x397)]!==this[_0x2db3c0(0x83f)][_0x2db3c0(0x397)]&&('TeXmG'!==_0x2db3c0(0xabd)?_0x3fc656[_0x2db3c0(0x731)][_0x2db3c0(0x4e8)]['call'](this):this[_0x2db3c0(0x83f)][_0x2db3c0(0x1ea)](this[_0x2db3c0(0x397)]));const _0x2460e0=this[_0x2db3c0(0x2e4)]();this[_0x2db3c0(0x77b)]=this[_0x2db3c0(0x77b)]||Window_Base[_0x2db3c0(0x97e)][_0x2db3c0(0x1d8)](),this['_stateIconSprite']['x']=Math[_0x2db3c0(0x3e4)]((_0x2460e0+ImageManager['iconWidth'])/0x2)+0x8,this[_0x2db3c0(0x83f)]['y']=this[_0x2db3c0(0x77b)]/0x2;const _0x2d0363=VisuMZ[_0x2db3c0(0x731)]['Settings']['Enemy'];this[_0x2db3c0(0x83f)]['x']+=_0x2d0363['AttachStateOffsetX']||0x0,this[_0x2db3c0(0x83f)]['y']+=_0x2d0363['AttachStateOffsetY']||0x0;},Sprite_EnemyName[_0x251720(0x97e)]['updateOpacity']=function(){const _0x2e12d5=_0x251720,_0x414817=this[_0x2e12d5(0x680)]();if(_0x414817&&this[_0x2e12d5(0x8f9)]<0xff){if('FQQXm'!==_0x2e12d5(0x127))this['opacity']+=0x10;else{if(!_0x24be5d[_0x2e12d5(0x847)]())return;_0x38744d[_0x2e12d5(0xa0c)](_0x332379,_0x1d04e0),_0x160471['_scene'][_0x2e12d5(0xa7c)](_0x157d95[_0x2e12d5(0x2b4)]);}}else!_0x414817&&this[_0x2e12d5(0x8f9)]>0x0&&(this['opacity']-=0x10);},Sprite_EnemyName['prototype']['visibilityState']=function(){const _0x529a9b=_0x251720;if(this['isAlwaysHidden']()){if('VUWhK'!==_0x529a9b(0x528))return![];else _0x36d85b[_0x529a9b(0x731)]['Game_BattlerBase_eraseState'][_0x529a9b(0xa57)](this,_0x55969a),this[_0x529a9b(0x722)]()&&_0x9b0abb===this[_0x529a9b(0x1b1)]()&&this[_0x529a9b(0x2ce)]()&&(this['_visualHpGauge_JustDied']=![]),!this[_0x529a9b(0x600)]&&!this[_0x529a9b(0x1bd)]&&_0x2b74a1[_0x529a9b(0x847)]()&&this[_0x529a9b(0x711)]();}else{if(!this[_0x529a9b(0x397)])return![];else{if(this['_battler'][_0x529a9b(0x864)]())return![];else{if(!this['_battler']['isAppeared']()){if(_0x529a9b(0x7cf)==='ynwjB')return![];else _0xe7d07d['BattleCore']['Sprite_Actor_setActorHome'][_0x529a9b(0xa57)](this,_0x22a073);}else{if(this[_0x529a9b(0x94d)]()){if(_0x529a9b(0x874)===_0x529a9b(0x7f9)){if(!_0x4f1d3c[_0x529a9b(0x847)]())return;if(!_0x1781f7['VisuMZ_3_ActSeqCamera'])return;_0x5a8ffb[_0x529a9b(0xa0c)](_0x1aecfb,_0x4b968a);const _0x41a86e=_0x588e46[_0x529a9b(0x27e)](),_0x197fe7=_0x33b3e2[_0x529a9b(0x88b)],_0x3f5b24=_0x4880c9[_0x529a9b(0x6ee)],_0x4e845b=_0x48bc31[_0x529a9b(0x3dc)];if(_0x197fe7){const _0x59928f=_0x2d8c7a['round'](_0x50924e['width']/0x2),_0x9eec4f=_0x772328[_0x529a9b(0x3e4)](_0xd85793['height']/0x2);_0x16487d[_0x529a9b(0x807)](_0x59928f,_0x9eec4f,_0x584938[_0x529a9b(0x19f)],_0x287d31[_0x529a9b(0xc3)]);}_0x3f5b24&&_0x2a827f[_0x529a9b(0x27a)](0x0,0x0,_0x1f52ca[_0x529a9b(0x19f)],_0x4e1f0c[_0x529a9b(0xc3)]);if(_0x4e845b)_0x41a86e[_0x529a9b(0x1a1)](_0x529a9b(0x828));}else return!![];}else{if(this[_0x529a9b(0xa40)]())return!![];else{if(this[_0x529a9b(0x8a)]())return!![];else{if(this['opacity']>0x0){if('NQNww'!==_0x529a9b(0x28b))_0x2ff98b[_0x529a9b(0x731)][_0x529a9b(0x576)](),_0x2e0fe8['BattleCore'][_0x529a9b(0x85b)](_0x55f9e4),_0x115906['BattleCore']['BindCommonEventKeysForGroup'](_0x5ef4cc);else return![];}}}}}}}}},Sprite_EnemyName[_0x251720(0x97e)]['isAlwaysHidden']=function(){const _0x4604b3=_0x251720;return VisuMZ[_0x4604b3(0x731)]['Settings']['Enemy'][_0x4604b3(0x12e)];},Sprite_EnemyName[_0x251720(0x97e)][_0x251720(0x94d)]=function(){return![];},Sprite_EnemyName[_0x251720(0x97e)]['isAlwaysVisible']=function(){const _0x9a3c5a=_0x251720;return VisuMZ[_0x9a3c5a(0x731)]['Settings'][_0x9a3c5a(0x3b1)][_0x9a3c5a(0x9eb)];},Sprite_EnemyName[_0x251720(0x97e)]['isIncludedInEnemyWindow']=function(){const _0x10c93e=_0x251720;if(VisuMZ[_0x10c93e(0x731)]['Settings']['Enemy'][_0x10c93e(0x632)])return'rPtDM'===_0x10c93e(0x138)?this[_0x10c93e(0x8b1)]:this[_0x10c93e(0x397)]['isSelected']();else{if(_0x10c93e(0x8f0)!=='pmRqk')return SceneManager[_0x10c93e(0x35b)]['_enemyWindow']&&SceneManager['_scene'][_0x10c93e(0x31c)][_0x10c93e(0xb4)]&&SceneManager[_0x10c93e(0x35b)][_0x10c93e(0x31c)][_0x10c93e(0x164)][_0x10c93e(0x9b0)](this[_0x10c93e(0x397)]);else!_0x1bad07['isDeathStateAffected']()&&(_0x58496f['forceAction'](_0x583df8[0x2],_0x764faf[0x3]),_0x2a678c[_0x10c93e(0x834)](_0x3590b7));}},Sprite_EnemyName['prototype'][_0x251720(0x2e4)]=function(){const _0x30dde8=_0x251720;if(!this[_0x30dde8(0x397)])return 0x0;if(this[_0x30dde8(0x3b9)])return this[_0x30dde8(0x3b9)];const _0x588da6=this[_0x30dde8(0x1f8)]();return this['setupFont'](),this[_0x30dde8(0x3b9)]=this[_0x30dde8(0x817)][_0x30dde8(0xa51)](_0x588da6)||0x1,this[_0x30dde8(0x3b9)];},VisuMZ[_0x251720(0x731)][_0x251720(0x27f)]=Sprite_Battleback[_0x251720(0x97e)]['adjustPosition'],Sprite_Battleback[_0x251720(0x97e)]['adjustPosition']=function(){const _0x365cc4=_0x251720,_0x1c3e0a=VisuMZ[_0x365cc4(0x731)][_0x365cc4(0x825)][_0x365cc4(0x6a3)];if(!_0x1c3e0a)return VisuMZ[_0x365cc4(0x731)]['Sprite_Battleback_adjustPosition']['call'](this);const _0x58c9b9=String(_0x1c3e0a[_0x365cc4(0x659)])||'MZ';switch(_0x58c9b9){case'MZ':VisuMZ[_0x365cc4(0x731)]['Sprite_Battleback_adjustPosition'][_0x365cc4(0xa57)](this);break;case _0x365cc4(0x549):this['adjustPosition_1for1']();break;case'ScaleToFit':this[_0x365cc4(0x851)]();break;case _0x365cc4(0x6d8):this[_0x365cc4(0x180)]();break;case _0x365cc4(0x39f):this[_0x365cc4(0x65b)]();break;}},Sprite_Battleback['prototype'][_0x251720(0x7dc)]=function(){const _0x267dad=_0x251720;this[_0x267dad(0x139)]=Graphics[_0x267dad(0x139)],this[_0x267dad(0x442)]=Graphics[_0x267dad(0x442)];const _0x3abfc6=0x1;this[_0x267dad(0x732)]['x']=_0x3abfc6,this[_0x267dad(0x732)]['y']=_0x3abfc6,this['x']=0x0,this['y']=0x0;},Sprite_Battleback['prototype'][_0x251720(0x851)]=function(){const _0x56578b=_0x251720;this[_0x56578b(0x139)]=Graphics[_0x56578b(0x139)],this[_0x56578b(0x442)]=Graphics[_0x56578b(0x442)];const _0x8c52c8=this['width']/this[_0x56578b(0x817)][_0x56578b(0x139)],_0x36c79f=this[_0x56578b(0x442)]/this['bitmap'][_0x56578b(0x442)],_0x57c6d4=Math[_0x56578b(0x79a)](_0x8c52c8,_0x36c79f);this[_0x56578b(0x732)]['x']=_0x57c6d4,this[_0x56578b(0x732)]['y']=_0x57c6d4,this['x']=(Graphics[_0x56578b(0x139)]-this['width'])/0x2,this['y']=Graphics['height']-this[_0x56578b(0x442)];},Sprite_Battleback[_0x251720(0x97e)][_0x251720(0x180)]=function(){const _0x18f01b=_0x251720;this[_0x18f01b(0x139)]=Graphics[_0x18f01b(0x139)],this['height']=Graphics[_0x18f01b(0x442)];const _0x100b72=Math[_0x18f01b(0x1c4)](0x1,this['width']/this['bitmap']['width']),_0x278e9a=Math[_0x18f01b(0x1c4)](0x1,this[_0x18f01b(0x442)]/this['bitmap']['height']),_0x313104=Math[_0x18f01b(0x79a)](_0x100b72,_0x278e9a);this[_0x18f01b(0x732)]['x']=_0x313104,this['scale']['y']=_0x313104,this['x']=(Graphics[_0x18f01b(0x139)]-this[_0x18f01b(0x139)])/0x2,this['y']=Graphics[_0x18f01b(0x442)]-this[_0x18f01b(0x442)];},Sprite_Battleback[_0x251720(0x97e)][_0x251720(0x65b)]=function(){const _0xd3f6c3=_0x251720;this[_0xd3f6c3(0x139)]=Graphics[_0xd3f6c3(0x139)],this[_0xd3f6c3(0x442)]=Graphics[_0xd3f6c3(0x442)];const _0x1fb71e=Math[_0xd3f6c3(0x79a)](0x1,this[_0xd3f6c3(0x139)]/this[_0xd3f6c3(0x817)]['width']),_0x52b9fe=Math[_0xd3f6c3(0x79a)](0x1,this[_0xd3f6c3(0x442)]/this[_0xd3f6c3(0x817)]['height']),_0x132eb2=Math[_0xd3f6c3(0x79a)](_0x1fb71e,_0x52b9fe);this[_0xd3f6c3(0x732)]['x']=_0x132eb2,this[_0xd3f6c3(0x732)]['y']=_0x132eb2,this['x']=(Graphics['width']-this[_0xd3f6c3(0x139)])/0x2,this['y']=Graphics[_0xd3f6c3(0x442)]-this[_0xd3f6c3(0x442)];},Spriteset_Battle['prototype'][_0x251720(0xa33)]=function(){const _0x6cea8c=_0x251720;if(!$gameSystem[_0x6cea8c(0x22c)]())return![];return![];},Spriteset_Battle[_0x251720(0x97e)][_0x251720(0x344)]=function(){return 0x0;},Spriteset_Battle[_0x251720(0x97e)][_0x251720(0x656)]=function(){return 0x0;},VisuMZ['BattleCore'][_0x251720(0x715)]=Spriteset_Battle[_0x251720(0x97e)]['createLowerLayer'],Spriteset_Battle[_0x251720(0x97e)][_0x251720(0x5cc)]=function(){const _0x4e4c65=_0x251720;VisuMZ[_0x4e4c65(0x731)][_0x4e4c65(0x715)][_0x4e4c65(0xa57)](this),this[_0x4e4c65(0x63e)](),this[_0x4e4c65(0x396)](),this['createEnemyNames']();},VisuMZ[_0x251720(0x731)][_0x251720(0x927)]=Spriteset_Battle[_0x251720(0x97e)][_0x251720(0xc8)],Spriteset_Battle[_0x251720(0x97e)][_0x251720(0xc8)]=function(){const _0x4b3341=_0x251720;VisuMZ[_0x4b3341(0x731)][_0x4b3341(0x927)][_0x4b3341(0xa57)](this),this[_0x4b3341(0x7ee)]();},Spriteset_Battle[_0x251720(0x97e)]['createWeather']=function(){const _0x3090bd=_0x251720;this[_0x3090bd(0x8f8)]=new Weather(),this[_0x3090bd(0x93)]['addChild'](this[_0x3090bd(0x8f8)]);},Spriteset_Battle[_0x251720(0x97e)][_0x251720(0x7ee)]=function(){const _0x47fadd=_0x251720;this[_0x47fadd(0x8f8)][_0x47fadd(0x74e)]=$gameScreen['weatherType'](),this[_0x47fadd(0x8f8)][_0x47fadd(0xe9)]=$gameScreen['weatherPower']();},Game_Interpreter[_0x251720(0x97e)]['command236']=function(_0x26b86d){const _0x2862a2=_0x251720;$gameScreen[_0x2862a2(0x572)](_0x26b86d[0x0],_0x26b86d[0x1],_0x26b86d[0x2]);if(_0x26b86d[0x3])this['wait'](_0x26b86d[0x2]);return!![];},VisuMZ[_0x251720(0x731)][_0x251720(0x59c)]=Game_Interpreter[_0x251720(0x97e)][_0x251720(0x84f)],Game_Interpreter[_0x251720(0x97e)][_0x251720(0x84f)]=function(_0x39d82a){const _0xe08964=_0x251720;if(SceneManager['isSceneBattle']()){if(_0xe08964(0x64b)!==_0xe08964(0x64b))_0x4d502f['BattleCore']['Scene_Battle_stop'][_0xe08964(0xa57)](this);else return SceneManager[_0xe08964(0x35b)]['_spriteset'][_0xe08964(0xab5)](_0x39d82a[0x0],_0x39d82a[0x1]),!![];}else{if(_0xe08964(0x537)===_0xe08964(0x537))return VisuMZ[_0xe08964(0x731)][_0xe08964(0x59c)][_0xe08964(0xa57)](this,_0x39d82a);else this[_0xe08964(0x645)]='';}},Spriteset_Battle[_0x251720(0x97e)][_0x251720(0x893)]=function(_0x592af0,_0xdc7d60){const _0x557ae8=_0x251720;_0x592af0[_0x557ae8(0x817)]=_0xdc7d60;},Spriteset_Battle[_0x251720(0x97e)][_0x251720(0xab5)]=function(_0x50c4a2,_0x36e289){const _0x5c1474=_0x251720;_0x50c4a2=_0x50c4a2||'',_0x36e289=_0x36e289||'';_0x50c4a2===''&&_0x36e289===''&&(_0x50c4a2=this[_0x5c1474(0x205)]['battleback1Name'](),_0x36e289=this[_0x5c1474(0x747)][_0x5c1474(0x908)]());const _0x447fdd=ImageManager[_0x5c1474(0x2f2)](_0x50c4a2),_0x2566d9=ImageManager[_0x5c1474(0x2f7)](_0x36e289);_0x447fdd[_0x5c1474(0x26d)](this['updateBattlebackBitmap1'][_0x5c1474(0x270)](this,this[_0x5c1474(0x205)],this[_0x5c1474(0x747)],_0x447fdd,_0x2566d9));},Spriteset_Battle[_0x251720(0x97e)]['updateBattlebackBitmap1']=function(_0x22f463,_0xc4c034,_0x3c8e1b,_0x3b85d8){const _0x28eb21=_0x251720;_0x3b85d8[_0x28eb21(0x26d)](this[_0x28eb21(0x775)][_0x28eb21(0x270)](this,_0x22f463,_0xc4c034,_0x3c8e1b,_0x3b85d8));},Spriteset_Battle[_0x251720(0x97e)][_0x251720(0x775)]=function(_0x25cbb9,_0x422a24,_0x51b016,_0xa47a98){const _0x5e6933=_0x251720;_0x25cbb9[_0x5e6933(0x817)]=_0x51b016,_0x422a24[_0x5e6933(0x817)]=_0xa47a98,_0x25cbb9[_0x5e6933(0x81c)](),_0x422a24[_0x5e6933(0x81c)]();},VisuMZ['BattleCore'][_0x251720(0x6fb)]=Spriteset_Battle['prototype']['createBattleField'],Spriteset_Battle[_0x251720(0x97e)][_0x251720(0x93d)]=function(){const _0x27919f=_0x251720;VisuMZ[_0x27919f(0x731)][_0x27919f(0x6fb)][_0x27919f(0xa57)](this),this[_0x27919f(0x6a8)]();},Spriteset_Battle[_0x251720(0x97e)][_0x251720(0x6a8)]=function(){const _0x34cbfe=_0x251720;this[_0x34cbfe(0x75e)](),this[_0x34cbfe(0x37b)](),this[_0x34cbfe(0x859)](),this[_0x34cbfe(0x7cb)]();},Spriteset_Battle[_0x251720(0x97e)][_0x251720(0x75e)]=function(){const _0x5e5fe3=_0x251720;this['_battlerContainer']=new Sprite(),this[_0x5e5fe3(0x93)]['addChild'](this['_battlerContainer']);},Spriteset_Battle[_0x251720(0x97e)][_0x251720(0x37b)]=function(){const _0x17064d=_0x251720;this['_animationContainer']=new Sprite(),this[_0x17064d(0x93)][_0x17064d(0x26f)](this[_0x17064d(0x3ca)]);},Spriteset_Battle[_0x251720(0x97e)][_0x251720(0x859)]=function(){const _0x3d6693=_0x251720;this[_0x3d6693(0x71e)]=new Sprite(),this[_0x3d6693(0x71e)]['x']=this['_battleField']['x'],this[_0x3d6693(0x71e)]['y']=this[_0x3d6693(0x93)]['y'],this[_0x3d6693(0x26f)](this[_0x3d6693(0x71e)]);},Spriteset_Battle['prototype']['adjustFlippedBattlefield']=function(){const _0x56d25f=_0x251720;if(!this[_0x56d25f(0xa33)]())return;this['_battlerContainer'][_0x56d25f(0x732)]['x']=-0x1,this[_0x56d25f(0xa12)]['x']=this['_battleField'][_0x56d25f(0x139)],this['_animationContainer'][_0x56d25f(0x732)]['x']=-0x1,this['_animationContainer']['x']=this[_0x56d25f(0x93)][_0x56d25f(0x139)],this[_0x56d25f(0x71e)]['scale']['x']=-0x1,this['_damageContainer']['x']=this[_0x56d25f(0x93)]['x']+this[_0x56d25f(0x93)]['width'];},Spriteset_Battle[_0x251720(0x97e)]['createEnemies']=function(){const _0x414b9d=_0x251720;Imported[_0x414b9d(0x7a8)]&&this['coreEngineRepositionEnemies']()&&(_0x414b9d(0x471)===_0x414b9d(0x9ab)?this[_0x414b9d(0x1a1)](_0x414b9d(0x8f9)):this[_0x414b9d(0x362)]());const _0x1af177=$gameTroop[_0x414b9d(0x991)](),_0x2cbff2=[];for(const _0x430e8a of _0x1af177){'MNfEM'===_0x414b9d(0x313)?_0x2cbff2[_0x414b9d(0x141)](new Sprite_Enemy(_0x430e8a)):(_0x580ec6[_0x414b9d(0x97e)][_0x414b9d(0x43e)][_0x414b9d(0xa57)](this,_0x1e3c67),this['setBackgroundType'](this['bgType']()),this[_0x414b9d(0x841)]());}_0x2cbff2[_0x414b9d(0x713)](this['compareEnemySprite'][_0x414b9d(0x270)](this));for(const _0xec7bf8 of _0x2cbff2){this['_battlerContainer'][_0x414b9d(0x26f)](_0xec7bf8);}this[_0x414b9d(0x3ef)]=_0x2cbff2;},Spriteset_Battle[_0x251720(0x97e)]['createActors']=function(){const _0x769ea6=_0x251720;this[_0x769ea6(0x63d)]=[];for(let _0x119b32=0x0;_0x119b32<$gameParty['maxBattleMembers']();_0x119b32++){if(_0x769ea6(0x498)!==_0x769ea6(0x498))return _0x9640aa[_0x769ea6(0x731)][_0x769ea6(0x825)][_0x769ea6(0x8ca)]['SkillItemBorderCols'];else{const _0x55bf4e=$gameParty['battleMembers']()[_0x119b32],_0x1daa10=new Sprite_Actor();_0x1daa10[_0x769ea6(0xa9e)](_0x55bf4e),_0x1daa10['setBattler'](_0x55bf4e),_0x1daa10[_0x769ea6(0xc8)](),this['_actorSprites'][_0x769ea6(0x141)](_0x1daa10),this['_battlerContainer']['addChild'](_0x1daa10);}}},Spriteset_Battle['prototype'][_0x251720(0x12a)]=function(_0x1e1795,_0x106835,_0x206c1a,_0x20b1f8){const _0x5e9a84=_0x251720,_0xf588b1=this[_0x5e9a84(0x116)](_0x106835),_0x5572df=new(_0xf588b1?Sprite_AnimationMV:Sprite_Animation)(),_0x4193e4=this[_0x5e9a84(0x915)](_0x1e1795);if(this[_0x5e9a84(0x2fb)](_0x1e1795[0x0])){if('PjvOU'===_0x5e9a84(0x57f)){if(!_0x441356[_0x5e9a84(0x731)]['Settings'][_0x5e9a84(0x8cf)][_0x5e9a84(0x6e3)])return;_0x431257['BattleCore'][_0x5e9a84(0x7c4)][_0x5e9a84(0xa57)](this,_0x321390);}else _0x206c1a=!_0x206c1a;}_0x5572df[_0x5e9a84(0x8a5)]=_0x1e1795,_0x5572df[_0x5e9a84(0x1ea)](_0x4193e4,_0x106835,_0x206c1a,_0x20b1f8),this[_0x5e9a84(0x115)](_0x5572df);},Spriteset_Battle[_0x251720(0x97e)][_0x251720(0x115)]=function(_0x7e7c51){const _0x3cd717=_0x251720;this['isAnimationShownOnBattlePortrait'](_0x7e7c51)?this['battleStatusWindowAnimationContainer']()[_0x3cd717(0x26f)](_0x7e7c51):this[_0x3cd717(0x3ca)][_0x3cd717(0x26f)](_0x7e7c51),this[_0x3cd717(0xcb)]['push'](_0x7e7c51);},Spriteset_Battle[_0x251720(0x97e)][_0x251720(0xaba)]=function(_0x105504){const _0x49cfa8=_0x251720;if(!_0x105504)return![];if(!_0x105504[_0x49cfa8(0x6e)])return![];if(_0x105504[_0x49cfa8(0x6e)][_0x49cfa8(0x1e1)]!==0x0)return![];if(!_0x105504['targetObjects'][0x0])return![];if(!_0x105504['targetObjects'][0x0][_0x49cfa8(0x4f2)]())return![];if($gameSystem[_0x49cfa8(0x22c)]())return![];if(!this['battleStatusWindowAnimationContainer']())return![];return Window_BattleStatus[_0x49cfa8(0x97e)]['battleLayoutStyle']()==='portrait';},Spriteset_Battle[_0x251720(0x97e)]['battleStatusWindowAnimationContainer']=function(){const _0x371bdd=_0x251720;if(!SceneManager[_0x371bdd(0x35b)])return;if(!SceneManager[_0x371bdd(0x35b)][_0x371bdd(0xa7b)])return;if(!SceneManager[_0x371bdd(0x35b)][_0x371bdd(0xa7b)][_0x371bdd(0x9fd)])return;return SceneManager[_0x371bdd(0x35b)][_0x371bdd(0xa7b)][_0x371bdd(0x9fd)];},Spriteset_Battle['prototype'][_0x251720(0x87a)]=function(_0x403d7e){const _0x1472eb=_0x251720;this[_0x1472eb(0x543)](_0x403d7e);for(const _0x254482 of _0x403d7e['targetObjects']){_0x254482[_0x1472eb(0x3a8)]&&(_0x1472eb(0x280)===_0x1472eb(0x280)?_0x254482['endAnimation']():(_0x525893[_0x1472eb(0x4fc)]=_0x5a53b6[_0x1472eb(0x4fc)]||{},_0x1740fe[_0x1472eb(0x4fc)]['priority']=0x0));}_0x403d7e[_0x1472eb(0x8f)]();},Spriteset_Battle[_0x251720(0x97e)][_0x251720(0x543)]=function(_0x54fa90){const _0xbdc9df=_0x251720;this['_animationSprites'][_0xbdc9df(0x39c)](_0x54fa90),this[_0xbdc9df(0xaba)](_0x54fa90)?this[_0xbdc9df(0x65e)]()[_0xbdc9df(0x9d7)](_0x54fa90):_0xbdc9df(0x518)!=='EEbiK'?this[_0xbdc9df(0x3ca)][_0xbdc9df(0x9d7)](_0x54fa90):(_0x52caaf[_0xbdc9df(0x731)][_0xbdc9df(0x8e7)][_0xbdc9df(0xa57)](this,_0x54e1d4,_0x2818bb),this['callNextMethod']());},VisuMZ[_0x251720(0x731)][_0x251720(0x5f2)]=Spriteset_Battle['prototype']['updateActors'],Spriteset_Battle['prototype'][_0x251720(0x1e3)]=function(){const _0x34b378=_0x251720;VisuMZ[_0x34b378(0x731)][_0x34b378(0x5f2)]['call'](this),this[_0x34b378(0x8fd)]();},Spriteset_Battle[_0x251720(0x97e)][_0x251720(0x8fd)]=function(){const _0x1296a4=_0x251720;this['_battlerContainer'][_0x1296a4(0x468)][_0x1296a4(0x713)](this[_0x1296a4(0x6be)][_0x1296a4(0x270)](this)),this[_0x1296a4(0x664)]();},Spriteset_Battle[_0x251720(0x97e)][_0x251720(0x6be)]=function(_0x4b0159,_0x4226e6){const _0x48fbd2=_0x251720;if(VisuMZ['BattleCore'][_0x48fbd2(0x825)][_0x48fbd2(0x98)]['PrioritySortActors']){if(_0x4b0159['_battler']&&_0x4226e6[_0x48fbd2(0x397)]){if(_0x4b0159[_0x48fbd2(0x397)][_0x48fbd2(0x4f2)]()&&_0x4226e6[_0x48fbd2(0x397)][_0x48fbd2(0x722)]()){if(_0x48fbd2(0x239)===_0x48fbd2(0x839))_0x130ef1+=_0x553d28[_0x48fbd2(0x7a)](_0x39c203['hpDamage']);else return 0x1;}else{if(_0x4226e6[_0x48fbd2(0x397)][_0x48fbd2(0x4f2)]()&&_0x4b0159[_0x48fbd2(0x397)][_0x48fbd2(0x722)]())return-0x1;}}}if(_0x4b0159[_0x48fbd2(0x6cc)]!==_0x4226e6[_0x48fbd2(0x6cc)])return _0x4b0159['_baseY']-_0x4226e6[_0x48fbd2(0x6cc)];else{if(_0x48fbd2(0x5e5)!==_0x48fbd2(0x5e5)){const _0x1f6d51={'code':0xe6,'indent':0x0,'parameters':[0x1]},_0x56c698=_0x58e89e['list'][_0x48fbd2(0xa6)]();_0x30dcb6['list']['unshift'](_0x1f6d51),_0x2345ad[_0x48fbd2(0x855)]['unshift'](_0x56c698);}else return _0x4226e6[_0x48fbd2(0x6bf)]-_0x4b0159[_0x48fbd2(0x6bf)];}},Spriteset_Battle[_0x251720(0x97e)][_0x251720(0x664)]=function(){const _0x1a04b3=_0x251720;if(!VisuMZ['BattleCore'][_0x1a04b3(0x825)]['Actor']['PrioritySortActive'])return;const _0x55b859=BattleManager['_subject'];if(_0x55b859){if(_0x55b859[_0x1a04b3(0x4f2)]()&&!$gameSystem[_0x1a04b3(0x22c)]())return;const _0x5f0dc6=_0x55b859[_0x1a04b3(0x60a)]();if(_0x5f0dc6&&_0x55b859['isActor']())this[_0x1a04b3(0xa12)][_0x1a04b3(0x26f)](_0x5f0dc6);}},Spriteset_Battle[_0x251720(0x97e)][_0x251720(0x88e)]=function(){const _0xcbaf84=_0x251720;for(const _0x3456a2 of $gameParty['aliveMembers']()){if(_0xcbaf84(0x3ea)!==_0xcbaf84(0xd8)){if(!_0x3456a2)continue;if(!_0x3456a2[_0xcbaf84(0x60a)]())continue;_0x3456a2[_0xcbaf84(0x60a)]()[_0xcbaf84(0x1f2)]=!![],_0x3456a2[_0xcbaf84(0x60a)]()[_0xcbaf84(0x130)]();}else _0x31c192[_0xcbaf84(0x772)]()[_0xcbaf84(0x61c)]?this[_0xcbaf84(0x141)](_0xcbaf84(0x2c1),_0x50cb2c):this[_0xcbaf84(0x141)](_0xcbaf84(0x6db),_0x2424e1);}},Spriteset_Battle[_0x251720(0x97e)]['createUIContainer']=function(){const _0x59b6c6=_0x251720;this['_uiContainer']=new Sprite(),this['_battleField'][_0x59b6c6(0x26f)](this[_0x59b6c6(0x4a6)]);},Spriteset_Battle[_0x251720(0x97e)][_0x251720(0x266)]=function(){const _0x48db20=_0x251720;if(VisuMZ['BattleCore'][_0x48db20(0x825)][_0x48db20(0x3b1)][_0x48db20(0x254)])return;this[_0x48db20(0x50e)]=new Sprite(),this[_0x48db20(0x4a6)]['addChild'](this['_enemyNameContainer']);for(const _0xc4e08e of this['_enemySprites']){const _0x4ab320=new Sprite_EnemyName();this['_enemyNameContainer'][_0x48db20(0x26f)](_0x4ab320),_0x4ab320[_0x48db20(0x2f6)](_0xc4e08e);}},Spriteset_Battle[_0x251720(0x97e)][_0x251720(0xaa2)]=function(){return![];},Spriteset_Battle[_0x251720(0x97e)][_0x251720(0x726)]=function(){return this['battlerSprites']()['some'](_0x306e94=>_0x306e94['isFloating']());},Spriteset_Battle['prototype'][_0x251720(0x378)]=function(){const _0x6bd2d3=_0x251720;return this[_0x6bd2d3(0x336)]()[_0x6bd2d3(0x84)](_0x5271b5=>_0x5271b5[_0x6bd2d3(0x4e6)]());},Spriteset_Battle[_0x251720(0x97e)]['isAnyoneGrowing']=function(){const _0x38ee28=_0x251720;return this[_0x38ee28(0x336)]()[_0x38ee28(0x84)](_0x549a9a=>_0x549a9a[_0x38ee28(0xbd)]());},Spriteset_Battle[_0x251720(0x97e)][_0x251720(0x4ac)]=function(){const _0x115836=_0x251720;return this[_0x115836(0x336)]()[_0x115836(0x84)](_0x27e42e=>_0x27e42e[_0x115836(0x98e)]());},Spriteset_Battle[_0x251720(0x97e)][_0x251720(0x45e)]=function(){const _0x368b10=_0x251720;return this[_0x368b10(0x336)]()[_0x368b10(0x84)](_0x24496e=>_0x24496e[_0x368b10(0x119)]());},Spriteset_Battle['prototype'][_0x251720(0x78e)]=function(){const _0x2d6085=_0x251720;return this[_0x2d6085(0x336)]()['some'](_0x8af3d2=>_0x8af3d2[_0x2d6085(0x3fd)]());},VisuMZ['BattleCore'][_0x251720(0x5ed)]=Window_ItemList['prototype'][_0x251720(0x46d)],Window_ItemList[_0x251720(0x97e)][_0x251720(0x46d)]=function(){const _0x42fe4b=_0x251720;if(SceneManager[_0x42fe4b(0x847)]()){if(_0x42fe4b(0x451)===_0x42fe4b(0x451)){if(SceneManager['_scene'][_0x42fe4b(0x5bf)]()==='border'){if(_0x42fe4b(0x787)!==_0x42fe4b(0x249))return VisuMZ[_0x42fe4b(0x731)][_0x42fe4b(0x825)]['BattleLayout'][_0x42fe4b(0x6e8)];else{if(!_0x3a8c34[_0x42fe4b(0x847)]())return;_0x5d7593[_0x42fe4b(0xa0c)](_0x2f9897,_0x5cdbec);const _0x5e5701=_0x57b90a['_action'];if(!_0x5e5701)return;let _0x34b4b9=_0x2977bb[_0x42fe4b(0x413)];_0x5e5701[_0x42fe4b(0x693)](_0x34b4b9);}}else{if(_0x42fe4b(0x67a)===_0x42fe4b(0x67a))return VisuMZ[_0x42fe4b(0x731)][_0x42fe4b(0x825)][_0x42fe4b(0x8ca)][_0x42fe4b(0x82a)];else _0x11e56d=this['_baseLineStack'][this[_0x42fe4b(0x8a8)]['length']-0x1];}}else _0x731b6d[_0x42fe4b(0x731)][_0x42fe4b(0xa8b)][_0x42fe4b(0xa57)](this,_0x7d22ee),this[_0x42fe4b(0xa5c)](_0x3bbfac);}else return VisuMZ['BattleCore'][_0x42fe4b(0x5ed)][_0x42fe4b(0xa57)](this);},VisuMZ[_0x251720(0x731)][_0x251720(0x4b5)]=Window_SkillList[_0x251720(0x97e)][_0x251720(0x46d)],Window_SkillList[_0x251720(0x97e)][_0x251720(0x46d)]=function(){const _0x2371d0=_0x251720;if(SceneManager[_0x2371d0(0x847)]()){if('nCKRj'===_0x2371d0(0x68e))return SceneManager[_0x2371d0(0x35b)]['battleLayoutStyle']()===_0x2371d0(0x9bc)?VisuMZ[_0x2371d0(0x731)]['Settings']['BattleLayout'][_0x2371d0(0x6e8)]:VisuMZ[_0x2371d0(0x731)][_0x2371d0(0x825)][_0x2371d0(0x8ca)]['SkillItemStandardCols'];else this['_pattern']++;}else return _0x2371d0(0x7e6)==='arrrh'?_0x168a97[_0x2371d0(0x7f5)]()[_0x2371d0(0x8ef)]()[_0x2371d0(0x778)](_0x4cdcb1=>_0x4cdcb1!==_0x224dcf):VisuMZ[_0x2371d0(0x731)][_0x2371d0(0x4b5)][_0x2371d0(0xa57)](this);},VisuMZ['BattleCore'][_0x251720(0x4a7)]=Window_Options[_0x251720(0x97e)][_0x251720(0x111)],Window_Options[_0x251720(0x97e)][_0x251720(0x111)]=function(){const _0xfe82d2=_0x251720;VisuMZ[_0xfe82d2(0x731)][_0xfe82d2(0x4a7)][_0xfe82d2(0xa57)](this),this[_0xfe82d2(0x608)](),this[_0xfe82d2(0x917)]();},Window_Options[_0x251720(0x97e)][_0x251720(0x608)]=function(){const _0x1e6025=_0x251720;VisuMZ[_0x1e6025(0x731)][_0x1e6025(0x825)]['AutoBattle'][_0x1e6025(0x256)]&&(this['addBattleCoreAutoBattleStartupCommand'](),this[_0x1e6025(0x12b)]());},Window_Options[_0x251720(0x97e)][_0x251720(0x917)]=function(){const _0x192ad2=_0x251720;if(!VisuMZ[_0x192ad2(0x731)][_0x192ad2(0x825)][_0x192ad2(0x2df)][_0x192ad2(0x464)])return;const _0x45dda6=TextManager[_0x192ad2(0x6b5)],_0x21aa97='visualHpGauge';this[_0x192ad2(0x91a)](_0x45dda6,_0x21aa97);},Window_Options[_0x251720(0x97e)][_0x251720(0x71)]=function(){const _0xc3d11c=_0x251720,_0x341591=TextManager[_0xc3d11c(0x348)],_0x307d50='autoBattleAtStart';this['addCommand'](_0x341591,_0x307d50);},Window_Options[_0x251720(0x97e)][_0x251720(0x12b)]=function(){const _0x37ad8d=_0x251720,_0x306e20=TextManager[_0x37ad8d(0x6d7)],_0x42e0da='autoBattleUseSkills';this[_0x37ad8d(0x91a)](_0x306e20,_0x42e0da);},VisuMZ[_0x251720(0x731)][_0x251720(0xa47)]=Window_Options[_0x251720(0x97e)][_0x251720(0x627)],Window_Options['prototype'][_0x251720(0x627)]=function(_0x1135bb){const _0x539c01=_0x251720,_0x29e0cb=this['commandSymbol'](_0x1135bb);return _0x29e0cb===_0x539c01(0x842)?this[_0x539c01(0x5ec)]():VisuMZ['BattleCore'][_0x539c01(0xa47)]['call'](this,_0x1135bb);},Window_Options[_0x251720(0x97e)]['statusTextAutoBattleStyle']=function(){const _0x511839=_0x251720,_0x80bbed=VisuMZ[_0x511839(0x731)][_0x511839(0x825)]['AutoBattle'],_0x4e4e4a=this[_0x511839(0x913)](_0x511839(0x842));return _0x4e4e4a?_0x80bbed[_0x511839(0x588)]:_0x80bbed['StyleOFF'];},Window_ShopStatus[_0x251720(0x97e)]['getItemDamageAmountLabelBattleCore']=function(){const _0x5cc495=_0x251720,_0x56d2be=DataManager[_0x5cc495(0x22b)](this['_item']),_0x4a45ee=VisuMZ[_0x5cc495(0x5e7)][_0x56d2be];if(!_0x4a45ee)return this[_0x5cc495(0x194)]();const _0x43fe8c=_0x5cc495(0xd4)[_0x5cc495(0x8d6)](this[_0x5cc495(0x68b)][_0x5cc495(0x363)][_0x5cc495(0x74e)]),_0x4264bd=[null,TextManager['hp'],TextManager['mp'],TextManager['hp'],TextManager['mp'],TextManager['hp'],TextManager['mp']][this['_item'][_0x5cc495(0x363)][_0x5cc495(0x74e)]];return _0x4a45ee[_0x43fe8c]['format'](_0x4264bd);},Window_ShopStatus[_0x251720(0x97e)]['getItemDamageAmountTextBattleCore']=function(){const _0x68ac01=_0x251720,_0x555556=DataManager['getDamageStyle'](this[_0x68ac01(0x68b)]),_0x2d9cbb=VisuMZ[_0x68ac01(0x5e7)][_0x555556];if(!_0x2d9cbb)return this['getItemDamageAmountTextOriginal']();return _0x2d9cbb[_0x68ac01(0x166)][_0x68ac01(0xa57)](this);},VisuMZ[_0x251720(0x731)]['Window_PartyCommand_initialize']=Window_PartyCommand[_0x251720(0x97e)]['initialize'],Window_PartyCommand[_0x251720(0x97e)][_0x251720(0x43e)]=function(_0x3764ad){const _0x5d72f9=_0x251720;VisuMZ['BattleCore'][_0x5d72f9(0x938)][_0x5d72f9(0xa57)](this,_0x3764ad),this[_0x5d72f9(0xa5c)](_0x3764ad);},Window_PartyCommand[_0x251720(0x97e)]['createCommandNameWindow']=function(_0x552d07){const _0x41a05a=_0x251720,_0x370cc1=new Rectangle(0x0,0x0,_0x552d07['width'],_0x552d07[_0x41a05a(0x442)]);this['_commandNameWindow']=new Window_Base(_0x370cc1),this['_commandNameWindow'][_0x41a05a(0x8f9)]=0x0,this['addChild'](this[_0x41a05a(0x571)]),this[_0x41a05a(0x241)]();},Window_PartyCommand[_0x251720(0x97e)][_0x251720(0x9ba)]=function(){const _0x537dae=_0x251720;Window_Command[_0x537dae(0x97e)][_0x537dae(0x9ba)]['call'](this);if(this['_commandNameWindow'])this['updateCommandNameWindow']();},Window_PartyCommand[_0x251720(0x97e)]['updateCommandNameWindow']=function(){const _0xaac387=_0x251720,_0x5dc40b=this[_0xaac387(0x571)];_0x5dc40b[_0xaac387(0x1e8)]['clear']();const _0x1bb582=this[_0xaac387(0x272)](this[_0xaac387(0x77c)]());if(_0x1bb582==='icon'&&this[_0xaac387(0x172)]()>0x0){const _0x381fcd=this[_0xaac387(0x67d)](this[_0xaac387(0x77c)]());let _0x15f7a5=this[_0xaac387(0x392)](this[_0xaac387(0x77c)]());_0x15f7a5=_0x15f7a5['replace'](/\\I\[(\d+)\]/gi,''),_0x5dc40b[_0xaac387(0x906)](),this[_0xaac387(0x652)](_0x15f7a5,_0x381fcd),this[_0xaac387(0x997)](_0x15f7a5,_0x381fcd),this[_0xaac387(0x896)](_0x15f7a5,_0x381fcd);}},Window_PartyCommand['prototype'][_0x251720(0x652)]=function(_0x533b28,_0x4bd50f){},Window_PartyCommand[_0x251720(0x97e)]['commandNameWindowDrawText']=function(_0x3ec23f,_0x1bb0cc){const _0x8c55df=_0x251720,_0xde9b44=this['_commandNameWindow'];_0xde9b44[_0x8c55df(0xa68)](_0x3ec23f,0x0,_0x1bb0cc['y'],_0xde9b44[_0x8c55df(0x376)],_0x8c55df(0x8cc));},Window_PartyCommand[_0x251720(0x97e)][_0x251720(0x896)]=function(_0x35642b,_0x2e3c32){const _0x40e693=_0x251720,_0x18124b=this[_0x40e693(0x571)],_0x533a0b=$gameSystem[_0x40e693(0x9f7)](),_0x265dc8=_0x2e3c32['x']+Math['floor'](_0x2e3c32[_0x40e693(0x139)]/0x2)+_0x533a0b;_0x18124b['x']=_0x18124b[_0x40e693(0x139)]/-0x2+_0x265dc8,_0x18124b['y']=Math[_0x40e693(0x570)](_0x2e3c32[_0x40e693(0x442)]/0x2);},Window_PartyCommand[_0x251720(0x97e)][_0x251720(0x9fb)]=function(){const _0x444b27=_0x251720;this[_0x444b27(0x332)](),this[_0x444b27(0x531)](),this[_0x444b27(0x159)](),this['addOptionsCommand'](),this[_0x444b27(0xf7)]();},Window_PartyCommand[_0x251720(0x97e)][_0x251720(0x332)]=function(){const _0x494148=_0x251720,_0x52a3d7=this['commandStyle'](),_0x3013b1=VisuMZ['BattleCore'][_0x494148(0x825)][_0x494148(0x85f)][_0x494148(0x3e9)],_0x1bdbc6=_0x52a3d7===_0x494148(0xe1)?TextManager[_0x494148(0x8b2)]:_0x494148(0x969)[_0x494148(0x8d6)](_0x3013b1,TextManager[_0x494148(0x8b2)]),_0xd88941=this[_0x494148(0x1ac)]();this[_0x494148(0x91a)](_0x1bdbc6,'fight',_0xd88941);},Window_PartyCommand[_0x251720(0x97e)][_0x251720(0x1ac)]=function(){return!![];},Window_PartyCommand['prototype'][_0x251720(0x531)]=function(){const _0x5e1a03=_0x251720;if(!this[_0x5e1a03(0x717)]())return;const _0x4a136f=this['commandStyle'](),_0x54f754=VisuMZ[_0x5e1a03(0x731)][_0x5e1a03(0x825)][_0x5e1a03(0x85f)][_0x5e1a03(0x6fe)],_0x20ef4f=_0x4a136f===_0x5e1a03(0xe1)?TextManager[_0x5e1a03(0x581)]:_0x5e1a03(0x969)[_0x5e1a03(0x8d6)](_0x54f754,TextManager[_0x5e1a03(0x581)]),_0x24b9ca=this['isAutoBattleCommandEnabled']();this[_0x5e1a03(0x91a)](_0x20ef4f,_0x5e1a03(0x581),_0x24b9ca);},Window_PartyCommand['prototype'][_0x251720(0x717)]=function(){const _0x5828a9=_0x251720;return VisuMZ[_0x5828a9(0x731)][_0x5828a9(0x825)][_0x5828a9(0x85f)][_0x5828a9(0xe2)];},Window_PartyCommand[_0x251720(0x97e)]['isAutoBattleCommandEnabled']=function(){return!![];},Window_PartyCommand[_0x251720(0x97e)][_0x251720(0x159)]=function(){},Window_PartyCommand['prototype']['addOptionsCommand']=function(){const _0x274b4e=_0x251720;if(!this['isOptionsCommandAdded']())return;const _0x1fb881=this[_0x274b4e(0x808)](),_0x492a3e=VisuMZ[_0x274b4e(0x731)]['Settings'][_0x274b4e(0x85f)][_0x274b4e(0x7d0)],_0x149caf=_0x1fb881===_0x274b4e(0xe1)?TextManager[_0x274b4e(0x918)]:'\x5cI[%1]%2'[_0x274b4e(0x8d6)](_0x492a3e,TextManager[_0x274b4e(0x918)]),_0x403697=this[_0x274b4e(0x287)]();this[_0x274b4e(0x91a)](_0x149caf,_0x274b4e(0x918),_0x403697);},Window_PartyCommand['prototype'][_0x251720(0x924)]=function(){const _0x1e8503=_0x251720;return VisuMZ[_0x1e8503(0x731)][_0x1e8503(0x825)][_0x1e8503(0x85f)][_0x1e8503(0x4ce)];},Window_PartyCommand[_0x251720(0x97e)][_0x251720(0x287)]=function(){return!![];},Window_PartyCommand['prototype'][_0x251720(0xf7)]=function(){const _0x2f3f16=_0x251720,_0x45a58d=this['commandStyle'](),_0x4f9285=VisuMZ[_0x2f3f16(0x731)][_0x2f3f16(0x825)][_0x2f3f16(0x85f)][_0x2f3f16(0x67b)],_0x54d8d9=_0x45a58d===_0x2f3f16(0xe1)?TextManager[_0x2f3f16(0x5f1)]:_0x2f3f16(0x969)[_0x2f3f16(0x8d6)](_0x4f9285,TextManager[_0x2f3f16(0x5f1)]),_0x37d2cf=this[_0x2f3f16(0x223)]();this[_0x2f3f16(0x91a)](_0x54d8d9,'escape',_0x37d2cf);},Window_PartyCommand[_0x251720(0x97e)][_0x251720(0x223)]=function(){const _0x44e09e=_0x251720;return BattleManager[_0x44e09e(0x30e)]();},Window_PartyCommand[_0x251720(0x97e)][_0x251720(0x9bf)]=function(){const _0x4dc546=_0x251720;return VisuMZ[_0x4dc546(0x731)][_0x4dc546(0x825)][_0x4dc546(0x85f)]['CmdTextAlign'];},Window_PartyCommand[_0x251720(0x97e)][_0x251720(0x6d9)]=function(_0x19c279){const _0x21b004=_0x251720,_0x444218=this[_0x21b004(0x272)](_0x19c279);if(_0x444218===_0x21b004(0x1e5))this[_0x21b004(0x71c)](_0x19c279);else{if(_0x444218===_0x21b004(0x85)){if(_0x21b004(0xab)!=='NBsfu')this['drawItemStyleIcon'](_0x19c279);else{const _0x55fc13=_0x569b09[_0x21b004(0x731)][_0x21b004(0x825)][_0x21b004(0x8ca)];if(_0x55fc13['StatusWindowSelectableBackHide'])return;_0x2f2bda[_0x21b004(0x97e)][_0x21b004(0x1c9)][_0x21b004(0xa57)](this,_0x15d01b);}}else Window_Command[_0x21b004(0x97e)][_0x21b004(0x6d9)]['call'](this,_0x19c279);}},Window_PartyCommand[_0x251720(0x97e)][_0x251720(0x808)]=function(){const _0x213e15=_0x251720;return VisuMZ[_0x213e15(0x731)]['Settings']['PartyCmd'][_0x213e15(0x335)];},Window_PartyCommand[_0x251720(0x97e)][_0x251720(0x272)]=function(_0x512d85){const _0x7f62cd=_0x251720;if(_0x512d85<0x0)return _0x7f62cd(0xe1);const _0x28dd5d=this[_0x7f62cd(0x808)]();if(_0x28dd5d!==_0x7f62cd(0x4dd))return _0x28dd5d;else{if(this[_0x7f62cd(0x172)]()>0x0){if(_0x7f62cd(0x948)===_0x7f62cd(0x1b8)){if(_0x166447['value'](_0x142343))return![];}else{const _0x5c4735=this[_0x7f62cd(0x392)](_0x512d85);if(_0x5c4735[_0x7f62cd(0x591)](/\\I\[(\d+)\]/i)){const _0x590839=this[_0x7f62cd(0x67d)](_0x512d85),_0x506860=this[_0x7f62cd(0x480)](_0x5c4735)[_0x7f62cd(0x139)];return _0x506860<=_0x590839[_0x7f62cd(0x139)]?_0x7f62cd(0x1e5):_0x7f62cd(0x85);}}}}return _0x7f62cd(0xe1);},Window_PartyCommand[_0x251720(0x97e)]['drawItemStyleIconText']=function(_0x5a8c58){const _0x4dead4=_0x251720,_0x1e69ee=this['itemLineRect'](_0x5a8c58),_0x3fc2dc=this['commandName'](_0x5a8c58),_0xc2e96e=this[_0x4dead4(0x480)](_0x3fc2dc)[_0x4dead4(0x139)];this['changePaintOpacity'](this['isCommandEnabled'](_0x5a8c58));const _0x2d5d16=this[_0x4dead4(0x9bf)]();if(_0x2d5d16===_0x4dead4(0x328)){if('jLlTz'===_0x4dead4(0x3d2))this['drawTextEx'](_0x3fc2dc,_0x1e69ee['x']+_0x1e69ee['width']-_0xc2e96e,_0x1e69ee['y'],_0xc2e96e);else{if(!_0x244b1f[_0x4dead4(0x22c)]())return;const _0xb00732=this['battler']();if(!_0xb00732)return;_0xb00732[_0x4dead4(0xaac)](_0x2b251a,_0x1a40ad,_0xb4b8bd,_0x2e3884);}}else{if(_0x2d5d16==='center'){const _0xe106f7=_0x1e69ee['x']+Math[_0x4dead4(0x570)]((_0x1e69ee['width']-_0xc2e96e)/0x2);this[_0x4dead4(0x314)](_0x3fc2dc,_0xe106f7,_0x1e69ee['y'],_0xc2e96e);}else this[_0x4dead4(0x314)](_0x3fc2dc,_0x1e69ee['x'],_0x1e69ee['y'],_0xc2e96e);}},Window_PartyCommand[_0x251720(0x97e)][_0x251720(0x81b)]=function(_0x516712){const _0x1c5d76=_0x251720;this[_0x1c5d76(0x392)](_0x516712)[_0x1c5d76(0x591)](/\\I\[(\d+)\]/i);const _0x46ae24=Number(RegExp['$1'])||0x0,_0x3f09a0=this[_0x1c5d76(0x67d)](_0x516712),_0xb7d779=_0x3f09a0['x']+Math[_0x1c5d76(0x570)]((_0x3f09a0[_0x1c5d76(0x139)]-ImageManager['iconWidth'])/0x2),_0x3f8e4a=_0x3f09a0['y']+(_0x3f09a0[_0x1c5d76(0x442)]-ImageManager[_0x1c5d76(0x162)])/0x2;this[_0x1c5d76(0x97a)](_0x46ae24,_0xb7d779,_0x3f8e4a);},Window_PartyCommand['prototype'][_0x251720(0x379)]=function(){},Window_PartyCommand[_0x251720(0x97e)][_0x251720(0x77)]=function(){const _0x258a4b=_0x251720;Window_Command[_0x258a4b(0x97e)][_0x258a4b(0x77)][_0x258a4b(0xa57)](this);const _0x491e62=this[_0x258a4b(0x5bf)]();_0x491e62===_0x258a4b(0x9bc)&&this[_0x258a4b(0x663)]();},Window_PartyCommand[_0x251720(0x97e)]['battleLayoutStyle']=function(){const _0x5606ea=_0x251720;if(this[_0x5606ea(0x923)])return this[_0x5606ea(0x923)];return this['_battleLayoutStyle']=SceneManager['_scene'][_0x5606ea(0x5bf)](),this[_0x5606ea(0x923)];},Window_PartyCommand[_0x251720(0x97e)]['updateHelp']=function(){const _0x4abd04=_0x251720,_0x4e7a9f=VisuMZ['BattleCore'][_0x4abd04(0x825)][_0x4abd04(0x85f)],_0x54fb64=this[_0x4abd04(0x8fa)]();switch(_0x54fb64){case _0x4abd04(0x8b2):this[_0x4abd04(0xa96)][_0x4abd04(0xa5e)](_0x4e7a9f[_0x4abd04(0x146)]);break;case _0x4abd04(0x581):this[_0x4abd04(0xa96)]['setText'](_0x4e7a9f[_0x4abd04(0x5be)]);break;case _0x4abd04(0x918):this[_0x4abd04(0xa96)][_0x4abd04(0xa5e)](_0x4e7a9f[_0x4abd04(0x8e8)]);break;case _0x4abd04(0x5f1):this[_0x4abd04(0xa96)][_0x4abd04(0xa5e)](_0x4e7a9f['HelpEscape']);break;default:this[_0x4abd04(0xa96)]['setText']('');break;}},VisuMZ[_0x251720(0x731)]['Window_ActorCommand_initialize']=Window_ActorCommand[_0x251720(0x97e)][_0x251720(0x43e)],Window_ActorCommand[_0x251720(0x97e)][_0x251720(0x43e)]=function(_0x531c66){const _0x55064e=_0x251720;VisuMZ[_0x55064e(0x731)][_0x55064e(0xa8b)]['call'](this,_0x531c66),this[_0x55064e(0xa5c)](_0x531c66);},Window_ActorCommand[_0x251720(0x97e)][_0x251720(0xa5c)]=function(_0x4b1b58){const _0x13c27e=_0x251720,_0xaf0903=new Rectangle(0x0,0x0,_0x4b1b58['width'],_0x4b1b58[_0x13c27e(0x442)]);this['_commandNameWindow']=new Window_Base(_0xaf0903),this[_0x13c27e(0x571)][_0x13c27e(0x8f9)]=0x0,this[_0x13c27e(0x26f)](this[_0x13c27e(0x571)]),this[_0x13c27e(0x241)]();},Window_ActorCommand[_0x251720(0x97e)][_0x251720(0x9ba)]=function(){const _0x164fbd=_0x251720;Window_Command['prototype'][_0x164fbd(0x9ba)][_0x164fbd(0xa57)](this);if(this[_0x164fbd(0x571)])this['updateCommandNameWindow']();},Window_ActorCommand[_0x251720(0x97e)][_0x251720(0x241)]=function(){const _0x5cca3d=_0x251720,_0x205699=this[_0x5cca3d(0x571)];_0x205699['contents'][_0x5cca3d(0x90f)]();const _0x29b077=this['commandStyleCheck'](this[_0x5cca3d(0x77c)]());if(_0x29b077===_0x5cca3d(0x85)&&this['maxItems']()>0x0){const _0x161cdf=this[_0x5cca3d(0x67d)](this['index']());let _0x467177=this[_0x5cca3d(0x392)](this[_0x5cca3d(0x77c)]());_0x467177=_0x467177['replace'](/\\I\[(\d+)\]/gi,''),_0x205699[_0x5cca3d(0x906)](),this[_0x5cca3d(0x652)](_0x467177,_0x161cdf),this['commandNameWindowDrawText'](_0x467177,_0x161cdf),this[_0x5cca3d(0x896)](_0x467177,_0x161cdf);}},Window_ActorCommand['prototype'][_0x251720(0x652)]=function(_0x536060,_0x1b7ed3){},Window_ActorCommand[_0x251720(0x97e)]['commandNameWindowDrawText']=function(_0x31cd37,_0x37af8b){const _0x8edaf7=_0x251720,_0x4e5df6=this[_0x8edaf7(0x571)];_0x4e5df6[_0x8edaf7(0xa68)](_0x31cd37,0x0,_0x37af8b['y'],_0x4e5df6['innerWidth'],_0x8edaf7(0x8cc));},Window_ActorCommand[_0x251720(0x97e)][_0x251720(0x896)]=function(_0xa36a8d,_0x58fa6a){const _0xc89391=_0x251720,_0x1ea4c0=this['_commandNameWindow'],_0x5f2318=$gameSystem[_0xc89391(0x9f7)](),_0x27c4c7=_0x58fa6a['x']+Math[_0xc89391(0x570)](_0x58fa6a[_0xc89391(0x139)]/0x2)+_0x5f2318;_0x1ea4c0['x']=_0x1ea4c0[_0xc89391(0x139)]/-0x2+_0x27c4c7,_0x1ea4c0['y']=Math[_0xc89391(0x570)](_0x58fa6a['height']/0x2);},Window_ActorCommand[_0x251720(0x97e)][_0x251720(0x9fb)]=function(){const _0x24862a=_0x251720;if(!this[_0x24862a(0x81d)])return;const _0x5bcaa8=this[_0x24862a(0x81d)][_0x24862a(0x2b7)]();for(const _0x47b148 of _0x5bcaa8){this[_0x24862a(0x7e0)](_0x47b148['toUpperCase']()[_0x24862a(0x30b)]());}},Window_ActorCommand[_0x251720(0x97e)][_0x251720(0x7e0)]=function(_0xc75040){const _0x5bb8cc=_0x251720;_0xc75040===_0x5bb8cc(0x63f)&&('iofpT'!==_0x5bb8cc(0x268)?this['addAttackCommand']():this['_escapeRatio']=_0x5168cb[_0x5bb8cc(0x731)][_0x5bb8cc(0x825)][_0x5bb8cc(0xa38)][_0x5bb8cc(0x40a)][_0x5bb8cc(0xa57)](this));[_0x5bb8cc(0x384),_0x5bb8cc(0x658)][_0x5bb8cc(0x9b0)](_0xc75040)&&this[_0x5bb8cc(0x2ab)]();_0xc75040==='GUARD'&&this[_0x5bb8cc(0x175)]();if(_0xc75040===_0x5bb8cc(0x424)){if('nwawx'!==_0x5bb8cc(0x734)){if(!_0x16cd7b[_0x5bb8cc(0x847)]())return;if(!_0x4bfe8f[_0x5bb8cc(0x46a)])return;_0x371a02[_0x5bb8cc(0xa0c)](_0x3a28ed,_0x5065bc);const _0x33694b=_0x2f1a15[_0x5bb8cc(0x27e)](),_0x409863=_0x4efd4d[_0x5bb8cc(0x646)];if(!_0x33694b)return;const _0x1e10d3=_0xde5568['_spriteset'];if(!_0x1e10d3)return;_0x1e10d3[_0x5bb8cc(0x767)](_0x290c6d);if(_0x409863)_0x33694b[_0x5bb8cc(0x1a1)](_0x5bb8cc(0x980));}else this[_0x5bb8cc(0x3e6)]();}if(_0xc75040===_0x5bb8cc(0xa4e)){if('sDIcH'!==_0x5bb8cc(0x70f))this[_0x5bb8cc(0xf7)]();else return _0x4c9caf[_0x5bb8cc(0x7c8)][_0x5bb8cc(0x825)][_0x5bb8cc(0x43b)][_0x5bb8cc(0x9e2)];}_0xc75040==='AUTO\x20BATTLE'&&this[_0x5bb8cc(0x531)]();if(_0xc75040[_0x5bb8cc(0x591)](/STYPE: (\d+)/i)){if('nogpT'!==_0x5bb8cc(0x68f))this[_0x5bb8cc(0x49f)]=_0x31945f;else{const _0x2136f0=Number(RegExp['$1']);this['addSkillTypeCommand'](_0x2136f0);}}else{if(_0xc75040[_0x5bb8cc(0x591)](/STYPE: (.*)/i)){if(_0x5bb8cc(0x890)!=='dQvmP'){const _0x28ae4b=DataManager[_0x5bb8cc(0x559)](RegExp['$1']);this[_0x5bb8cc(0x3f0)](_0x28ae4b);}else{if(!_0x383960[_0x5bb8cc(0x4a8)]())return;_0x3199ef['log'](this[_0x5bb8cc(0x998)]['map'](_0x5f0dfc=>_0x5f0dfc[_0x5bb8cc(0x1f8)])[_0x5bb8cc(0x2c0)]('\x0a'));}}}_0xc75040===_0x5bb8cc(0xb8)&&this[_0x5bb8cc(0x9e)]();if(_0xc75040[_0x5bb8cc(0x591)](/SKILL: (\d+)/i)){const _0x5443f3=Number(RegExp['$1']);this[_0x5bb8cc(0x788)]($dataSkills[_0x5443f3]);}else{if(_0xc75040[_0x5bb8cc(0x591)](/SKILL: (.*)/i)){const _0x1e1ff2=DataManager[_0x5bb8cc(0x7da)](RegExp['$1']);this['addSingleSkillCommand']($dataSkills[_0x1e1ff2]);}}_0xc75040==='PARTY'&&Imported[_0x5bb8cc(0x2b5)]&&this[_0x5bb8cc(0x76f)]();[_0x5bb8cc(0x152),_0x5bb8cc(0x8d5)][_0x5bb8cc(0x9b0)](_0xc75040)&&Imported[_0x5bb8cc(0x307)]&&(_0x5bb8cc(0xde)!==_0x5bb8cc(0x7ad)?this['addCombatLogCommand']():_0x29ae00[_0x5bb8cc(0x7e)](_0x41a759['BattleEndEvent']));if(_0xc75040==='WEAPON\x20SWAP'&&Imported[_0x5bb8cc(0x3fc)]){if(_0x5bb8cc(0x44a)!==_0x5bb8cc(0x879))this['addWeaponSwapCommand'](!![]);else return _0x2144cc[_0x5bb8cc(0x731)][_0x5bb8cc(0x825)][_0x5bb8cc(0x98)]['ChantStyle']||![];}},Window_ActorCommand[_0x251720(0x97e)][_0x251720(0x7b0)]=function(){const _0x2725d3=_0x251720,_0x4be72b=$dataSkills[this[_0x2725d3(0x81d)][_0x2725d3(0x482)]()];if(!_0x4be72b)return;if(!this[_0x2725d3(0x109)](_0x4be72b))return;const _0x5a6db6=this[_0x2725d3(0x808)](),_0x5b43eb=DataManager[_0x2725d3(0x815)](_0x4be72b),_0x2157cc=DataManager[_0x2725d3(0x650)](_0x4be72b),_0x1d8f31=_0x5a6db6==='text'?_0x5b43eb:_0x2725d3(0x969)[_0x2725d3(0x8d6)](_0x2157cc,_0x5b43eb);this['addCommand'](_0x1d8f31,_0x2725d3(0x6ff),this['_actor'][_0x2725d3(0x1fd)]());},Window_ActorCommand[_0x251720(0x97e)][_0x251720(0x175)]=function(){const _0x353524=_0x251720,_0x25f352=$dataSkills[this[_0x353524(0x81d)][_0x353524(0xabf)]()];if(!_0x25f352)return;if(!this[_0x353524(0x109)](_0x25f352))return;const _0x5066d9=this['commandStyle'](),_0x3254c9=DataManager[_0x353524(0x815)](_0x25f352),_0x43461f=DataManager['battleCommandIcon'](_0x25f352),_0x46ab91=_0x5066d9==='text'?_0x3254c9:'\x5cI[%1]%2'[_0x353524(0x8d6)](_0x43461f,_0x3254c9);this['addCommand'](_0x46ab91,_0x353524(0x474),this[_0x353524(0x81d)][_0x353524(0x66c)]());},Window_ActorCommand[_0x251720(0x97e)]['addItemCommand']=function(){const _0x590ecf=_0x251720,_0x33176c=this[_0x590ecf(0x808)](),_0x40ed9d=VisuMZ['BattleCore'][_0x590ecf(0x825)][_0x590ecf(0x9c7)][_0x590ecf(0x668)],_0x36877c=_0x33176c===_0x590ecf(0xe1)?TextManager[_0x590ecf(0x342)]:_0x590ecf(0x969)[_0x590ecf(0x8d6)](_0x40ed9d,TextManager[_0x590ecf(0x342)]),_0x50fc62=this[_0x590ecf(0x92b)]();this[_0x590ecf(0x91a)](_0x36877c,'item',_0x50fc62);},Window_ActorCommand['prototype']['isItemCommandEnabled']=function(){const _0x392a74=_0x251720;return this[_0x392a74(0x81d)]&&this['_actor'][_0x392a74(0x4fd)]();},Window_ActorCommand[_0x251720(0x97e)][_0x251720(0x2ab)]=function(){const _0x37e3eb=_0x251720,_0x337040=this['_actor'][_0x37e3eb(0x7fd)]();for(const _0x1a6a13 of _0x337040){this[_0x37e3eb(0x3f0)](_0x1a6a13);}},Window_ActorCommand['prototype'][_0x251720(0x3f0)]=function(_0x258db1){const _0x1d3302=_0x251720;let _0x8409c4=$dataSystem[_0x1d3302(0x7fd)][_0x258db1];if(!_0x8409c4)return;let _0xd076a1=_0x8409c4;const _0x3efce0=this[_0x1d3302(0x808)]();if(_0x3efce0===_0x1d3302(0xe1))_0xd076a1=_0xd076a1[_0x1d3302(0x105)](/\x1I\[(\d+)\]/gi,''),_0xd076a1=_0xd076a1[_0x1d3302(0x105)](/\\I\[(\d+)\]/gi,'');else{if(!_0x8409c4[_0x1d3302(0x591)](/\\I\[(\d+)\]/i)){if('UJXvG'===_0x1d3302(0x6c8)){const _0x54fd01=Imported[_0x1d3302(0xc2)]?VisuMZ[_0x1d3302(0x42a)][_0x1d3302(0x825)][_0x1d3302(0x3f9)]:VisuMZ[_0x1d3302(0x731)][_0x1d3302(0x825)]['ActorCmd'],_0x42ab3e=$dataSystem['magicSkills'][_0x1d3302(0x9b0)](_0x258db1),_0xaeb68a=_0x42ab3e?_0x54fd01['IconStypeMagic']:_0x54fd01['IconStypeNorm'];_0xd076a1=_0x1d3302(0x969)[_0x1d3302(0x8d6)](_0xaeb68a,_0x8409c4);}else{const _0x5acc96=this[_0x1d3302(0x397)];_0x1fb9ff[_0x1d3302(0x731)][_0x1d3302(0x8d9)]['call'](this,_0x300dcf),this['setupHpGaugeSprite'](_0x48008b);if(_0x5acc96!==_0xeddaf)this[_0x1d3302(0x8c2)]();}}}this[_0x1d3302(0x91a)](_0xd076a1,'skill',!![],_0x258db1);},Window_ActorCommand[_0x251720(0x97e)][_0x251720(0x9e)]=function(){const _0x4ad9d1=_0x251720,_0x1260c9=this[_0x4ad9d1(0x81d)]['skillTypes'](),_0x284abd=this[_0x4ad9d1(0x81d)][_0x4ad9d1(0xa44)]();for(const _0x293814 of _0x284abd){if(_0x4ad9d1(0xc4)===_0x4ad9d1(0xc4)){if(!_0x293814)continue;if(Imported[_0x4ad9d1(0xc2)]){if(_0x4ad9d1(0x7d6)!==_0x4ad9d1(0x7d6))return _0x4d9ee0;else{if(this['noSimilarSTypes'](_0x293814))continue;if(this[_0x4ad9d1(0xa2a)](_0x293814))continue;}}else{if(!_0x1260c9[_0x4ad9d1(0x9b0)](_0x293814[_0x4ad9d1(0x8f1)]))continue;}this[_0x4ad9d1(0x788)](_0x293814);}else{const _0x15045c=_0x22c403[_0x4ad9d1(0x97e)][_0x4ad9d1(0x466)](),_0x41c982=_0x2786f2['boxWidth'],_0x2c35df=this[_0x4ad9d1(0x57b)]()+_0x15045c,_0x6985ca=0x0,_0x45e2dd=_0x3b17e6[_0x4ad9d1(0x635)]-_0x2c35df+_0x15045c;return new _0x17b175(_0x6985ca,_0x45e2dd,_0x41c982,_0x2c35df);}}},Window_ActorCommand[_0x251720(0x97e)]['noSimilarSTypes']=function(_0x375398){const _0x24747f=_0x251720,_0x2a0dc2=this[_0x24747f(0x81d)][_0x24747f(0x7fd)](),_0xf91662=_0x2a0dc2[_0x24747f(0x778)](_0x545fac=>DataManager[_0x24747f(0x142)](_0x375398)[_0x24747f(0x9b0)](_0x545fac));return _0xf91662[_0x24747f(0x988)]<=0x0;},Window_ActorCommand['prototype'][_0x251720(0xa2a)]=function(_0x2e10cf){const _0x56c4d3=_0x251720;if(!Window_SkillList[_0x56c4d3(0x97e)][_0x56c4d3(0x6b1)][_0x56c4d3(0xa57)](this,_0x2e10cf))return!![];if(!Window_SkillList['prototype'][_0x56c4d3(0x49e)]['call'](this,_0x2e10cf))return!![];if(!Window_SkillList[_0x56c4d3(0x97e)][_0x56c4d3(0x1e6)][_0x56c4d3(0xa57)](this,_0x2e10cf))return!![];return![];},Window_ActorCommand[_0x251720(0x97e)][_0x251720(0x788)]=function(_0x43daae){const _0x4653b7=_0x251720;if(!_0x43daae)return;if(!this[_0x4653b7(0x109)](_0x43daae))return;const _0x2e946a=this[_0x4653b7(0x808)](),_0x467fe2=DataManager[_0x4653b7(0x815)](_0x43daae),_0x24245e=DataManager[_0x4653b7(0x650)](_0x43daae),_0xcfb201=_0x2e946a===_0x4653b7(0xe1)?_0x467fe2:_0x4653b7(0x969)[_0x4653b7(0x8d6)](_0x24245e,_0x467fe2),_0x48a130=this[_0x4653b7(0x81d)][_0x4653b7(0x37f)](_0x43daae);this[_0x4653b7(0x91a)](_0xcfb201,'singleSkill',_0x48a130,_0x43daae['id']);},Window_ActorCommand['prototype'][_0x251720(0x109)]=function(_0x5a2e56){const _0x4e0119=_0x251720,_0x17f91f=_0x5a2e56[_0x4e0119(0x67f)];if(_0x17f91f[_0x4e0119(0x591)](/<COMMAND REQUIRE LEARN>/i)){if(_0x4e0119(0x4c9)!=='EMmlH'){if(!this[_0x4e0119(0x81d)]['isLearnedSkill'](_0x5a2e56['id']))return![];}else _0x2635bf[_0x4e0119(0x97e)][_0x4e0119(0x147)][_0x4e0119(0xa57)](this),this[_0x4e0119(0x8f9)]=0x0,this['_linkedSprite']=null,this['anchor']['x']=0.5,this[_0x4e0119(0x48c)]['y']=0x0;}if(_0x17f91f[_0x4e0119(0x591)](/<COMMAND REQUIRE ACCESS>/i)){if(!this['_actor'][_0x4e0119(0x676)](_0x5a2e56['id']))return![];}const _0x69779=VisuMZ[_0x4e0119(0x731)][_0x4e0119(0x338)](_0x5a2e56,_0x4e0119(0x1ed));if(VisuMZ[_0x4e0119(0x731)]['JS'][_0x69779]){if(!VisuMZ[_0x4e0119(0x731)]['JS'][_0x69779][_0x4e0119(0xa57)](this,this[_0x4e0119(0x81d)],_0x5a2e56))return![];}return VisuMZ[_0x4e0119(0x731)][_0x4e0119(0x5aa)](_0x5a2e56);},VisuMZ[_0x251720(0x731)]['CheckSkillCommandShowSwitches']=function(_0x216e8f){const _0x576620=_0x251720,_0x15d8a3=_0x216e8f[_0x576620(0x67f)];if(_0x15d8a3[_0x576620(0x591)](/<COMMAND SHOW[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x340967=JSON['parse']('['+RegExp['$1']['match'](/\d+/g)+']');for(const _0x2dcdf4 of _0x340967){if(!$gameSwitches[_0x576620(0x951)](_0x2dcdf4))return![];}return!![];}if(_0x15d8a3[_0x576620(0x591)](/<COMMAND SHOW ALL[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){if('UxxZk'==='qcEQT')(_0x46f67b[_0x576620(0x126)]||_0x122495[_0x576620(0x908)])&&_0x1fd6ee[_0x576620(0x4a1)]();else{const _0x45f8d0=JSON[_0x576620(0xa31)]('['+RegExp['$1'][_0x576620(0x591)](/\d+/g)+']');for(const _0x44007a of _0x45f8d0){if(!$gameSwitches['value'](_0x44007a))return![];}return!![];}}if(_0x15d8a3['match'](/<COMMAND SHOW ANY[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x1a34bb=JSON[_0x576620(0xa31)]('['+RegExp['$1'][_0x576620(0x591)](/\d+/g)+']');for(const _0x1aa3b6 of _0x1a34bb){if($gameSwitches[_0x576620(0x951)](_0x1aa3b6))return!![];}return![];}if(_0x15d8a3[_0x576620(0x591)](/<COMMAND HIDE[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x3491ad=JSON['parse']('['+RegExp['$1'][_0x576620(0x591)](/\d+/g)+']');for(const _0x23ac83 of _0x3491ad){if(!$gameSwitches[_0x576620(0x951)](_0x23ac83))return!![];}return![];}if(_0x15d8a3[_0x576620(0x591)](/<COMMAND HIDE ALL[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x373ff8=JSON[_0x576620(0xa31)]('['+RegExp['$1'][_0x576620(0x591)](/\d+/g)+']');for(const _0x6a88f5 of _0x373ff8){if(!$gameSwitches[_0x576620(0x951)](_0x6a88f5))return!![];}return![];}if(_0x15d8a3[_0x576620(0x591)](/<COMMAND HIDE ANY[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0xca30a7=JSON[_0x576620(0xa31)]('['+RegExp['$1'][_0x576620(0x591)](/\d+/g)+']');for(const _0x504a29 of _0xca30a7){if(_0x576620(0x5bb)!==_0x576620(0x5bb))return this['hasSvBattler']()?this[_0x576620(0x345)][_0x576620(0x86f)]():!![];else{if($gameSwitches[_0x576620(0x951)](_0x504a29))return![];}}return!![];}return!![];},Window_ActorCommand[_0x251720(0x97e)]['addEscapeCommand']=function(){const _0x3fe99e=_0x251720,_0x2c29e7=this['commandStyle'](),_0xfc47a8=VisuMZ['BattleCore'][_0x3fe99e(0x825)]['PartyCmd']['CmdIconEscape'],_0xeba12b=_0x2c29e7===_0x3fe99e(0xe1)?TextManager[_0x3fe99e(0x5f1)]:_0x3fe99e(0x969)[_0x3fe99e(0x8d6)](_0xfc47a8,TextManager['escape']),_0x992d33=this[_0x3fe99e(0x223)]();this[_0x3fe99e(0x91a)](_0xeba12b,'escape',_0x992d33);},Window_ActorCommand[_0x251720(0x97e)][_0x251720(0x223)]=function(){const _0x514195=_0x251720;return BattleManager[_0x514195(0x30e)]();},Window_ActorCommand['prototype']['addAutoBattleCommand']=function(){const _0x251461=_0x251720,_0x5acb96=this[_0x251461(0x808)](),_0x4c36f3=VisuMZ[_0x251461(0x731)]['Settings'][_0x251461(0x85f)][_0x251461(0x6fe)],_0x5be6f8=_0x5acb96==='text'?TextManager[_0x251461(0x581)]:_0x251461(0x969)['format'](_0x4c36f3,TextManager[_0x251461(0x581)]),_0x548052=this[_0x251461(0x8d)]();this[_0x251461(0x91a)](_0x5be6f8,_0x251461(0x581),_0x548052);},Window_ActorCommand[_0x251720(0x97e)]['isAutoBattleCommandEnabled']=function(){return!![];},Window_ActorCommand[_0x251720(0x97e)]['itemTextAlign']=function(){const _0x49ea1a=_0x251720;return VisuMZ['BattleCore'][_0x49ea1a(0x825)][_0x49ea1a(0x9c7)][_0x49ea1a(0x589)];},Window_ActorCommand[_0x251720(0x97e)]['drawItem']=function(_0x47ae38){const _0x282c0f=_0x251720,_0x56fc0c=this[_0x282c0f(0x272)](_0x47ae38);if(_0x56fc0c==='iconText')this[_0x282c0f(0x71c)](_0x47ae38);else _0x56fc0c==='icon'?_0x282c0f(0x99d)===_0x282c0f(0x925)?_0x2ede58[_0x282c0f(0x95b)]([this],_0x1152f5,!!_0x33b3b2):this[_0x282c0f(0x81b)](_0x47ae38):Window_Command[_0x282c0f(0x97e)][_0x282c0f(0x6d9)]['call'](this,_0x47ae38);this[_0x282c0f(0xa84)](_0x47ae38);},Window_ActorCommand[_0x251720(0x97e)][_0x251720(0x808)]=function(){const _0xeab643=_0x251720;return VisuMZ[_0xeab643(0x731)][_0xeab643(0x825)][_0xeab643(0x9c7)][_0xeab643(0x335)];},Window_ActorCommand[_0x251720(0x97e)][_0x251720(0x272)]=function(_0x25c77c){const _0x1d69dc=_0x251720;if(_0x25c77c<0x0)return _0x1d69dc(0xe1);const _0x2e1ad0=this[_0x1d69dc(0x808)]();if(_0x2e1ad0!==_0x1d69dc(0x4dd))return _0x2e1ad0;else{if(this[_0x1d69dc(0x172)]()>0x0){const _0x5ec22f=this[_0x1d69dc(0x392)](_0x25c77c);if(_0x5ec22f[_0x1d69dc(0x591)](/\\I\[(\d+)\]/i)){const _0x2430e4=this['itemLineRect'](_0x25c77c),_0x2b6eba=this['textSizeEx'](_0x5ec22f)[_0x1d69dc(0x139)];if(_0x2b6eba<=_0x2430e4[_0x1d69dc(0x139)])return'iconText';else{if(_0x1d69dc(0x957)!==_0x1d69dc(0x957)){let _0x4a0a5a=_0x5625f7[_0x1d69dc(0x951)](_0xf92e3c[_0x1d69dc(0xab2)]);_0x46a85d[_0x1d69dc(0x427)]<0x0&&(_0x4a0a5a+=_0x3d75d9[_0x1d69dc(0x7a)](_0x325783['hpDamage'])),_0x117131[_0x1d69dc(0x667)](_0x21d8bf['VariableHeal'],_0x4a0a5a);}else return _0x1d69dc(0x85);}}}}return _0x1d69dc(0xe1);},Window_ActorCommand[_0x251720(0x97e)][_0x251720(0x71c)]=function(_0x1ea815){const _0x595e22=_0x251720,_0x4a2962=this[_0x595e22(0x67d)](_0x1ea815),_0x2e624a=this['commandName'](_0x1ea815),_0x57f304=this[_0x595e22(0x480)](_0x2e624a)[_0x595e22(0x139)];this['changePaintOpacity'](this[_0x595e22(0x9bd)](_0x1ea815));const _0x1ed313=this[_0x595e22(0x9bf)]();if(_0x1ed313===_0x595e22(0x328))this['drawTextEx'](_0x2e624a,_0x4a2962['x']+_0x4a2962['width']-_0x57f304,_0x4a2962['y'],_0x57f304);else{if(_0x1ed313===_0x595e22(0x8cc)){if(_0x595e22(0x98d)===_0x595e22(0x98d)){const _0x14a4ca=_0x4a2962['x']+Math[_0x595e22(0x570)]((_0x4a2962[_0x595e22(0x139)]-_0x57f304)/0x2);this[_0x595e22(0x314)](_0x2e624a,_0x14a4ca,_0x4a2962['y'],_0x57f304);}else _0x2c588d+=(_0x12c57e[_0x595e22(0x722)]()?0x1:-0x1)*_0xcff8ac[_0x595e22(0x6f9)]()/0x2;}else{if(_0x595e22(0x320)!==_0x595e22(0x320)){const _0xd737f1=_0x8cb774(_0xeea0c7['$1']);return[_0x12c107[_0x595e22(0x30d)](_0xd737f1)];}else this['drawTextEx'](_0x2e624a,_0x4a2962['x'],_0x4a2962['y'],_0x57f304);}}},Window_ActorCommand[_0x251720(0x97e)]['drawItemStyleIcon']=function(_0x8fc54a){const _0x33a0d0=_0x251720;this[_0x33a0d0(0x392)](_0x8fc54a)['match'](/\\I\[(\d+)\]/i);const _0x10c110=Number(RegExp['$1'])||0x0,_0x457657=this['itemLineRect'](_0x8fc54a),_0x18be22=_0x457657['x']+Math[_0x33a0d0(0x570)]((_0x457657[_0x33a0d0(0x139)]-ImageManager[_0x33a0d0(0x391)])/0x2),_0x49f3ae=_0x457657['y']+(_0x457657[_0x33a0d0(0x442)]-ImageManager[_0x33a0d0(0x162)])/0x2;this['drawIcon'](_0x10c110,_0x18be22,_0x49f3ae);},Window_ActorCommand['prototype'][_0x251720(0xa84)]=function(_0x56a064){const _0x109170=_0x251720;if(!(VisuMZ[_0x109170(0x731)][_0x109170(0x825)][_0x109170(0x9c7)]['ShowCosts']??!![]))return;const _0x1d8a7c=this[_0x109170(0x236)](_0x56a064);if(!['attack',_0x109170(0x474),'singleSkill']['includes'](_0x1d8a7c))return;const _0x433a25=this[_0x109170(0x67d)](_0x56a064);let _0x286efe=null;if(_0x1d8a7c===_0x109170(0x6ff)){if(_0x109170(0x64a)===_0x109170(0x2d4)){const _0x5e7b95=this[_0x109170(0x690)]()[_0x109170(0x87c)]||0x0,_0x4636f1=_0x3ce81e[_0x109170(0x65f)][_0x5e7b95];_0x4636f1&&this['startWeaponAnimation'](_0x4636f1['weaponImageId']);}else _0x286efe=$dataSkills[this['_actor'][_0x109170(0x482)]()];}else{if(_0x1d8a7c==='guard'){if(_0x109170(0x794)==='DKWRu')_0x286efe=$dataSkills[this[_0x109170(0x81d)]['guardSkillId']()];else{const _0x23b957=_0x2e0ea9[_0x109170(0x8d6)](_0x4d53af[_0x109170(0x1f8)](),_0x34ab6e['param'](_0x53a214));this[_0x109170(0x141)](_0x109170(0x238)),this[_0x109170(0x141)](_0x109170(0x6e5)),this[_0x109170(0x141)](_0x109170(0x84b),_0x23b957),this['push']('wait');}}else{if(_0x109170(0xa9b)!==_0x109170(0x456))_0x286efe=$dataSkills[this[_0x109170(0x619)][_0x56a064][_0x109170(0x329)]];else{if(!_0xa25978[_0x109170(0x97e)][_0x109170(0x6b1)]['call'](this,_0x361af5))return!![];if(!_0x10d337['prototype']['checkShowHideSwitchNotetags']['call'](this,_0x1f50d7))return!![];if(!_0x1b93a5[_0x109170(0x97e)][_0x109170(0x1e6)][_0x109170(0xa57)](this,_0x5c8c50))return!![];return![];}}}this[_0x109170(0x9fc)](this[_0x109170(0x81d)],_0x286efe,_0x433a25['x'],_0x433a25['y'],_0x433a25[_0x109170(0x139)]);},Window_ActorCommand[_0x251720(0x97e)][_0x251720(0x9fc)]=function(_0x2bd7f1,_0x3417b7,_0xad317a,_0x56351a,_0x2d6294){const _0x1e17c6=_0x251720;if(!_0x3417b7)return;Imported[_0x1e17c6(0xc2)]?Window_Command[_0x1e17c6(0x97e)][_0x1e17c6(0x9fc)]['call'](this,_0x2bd7f1,_0x3417b7,_0xad317a,_0x56351a,_0x2d6294):Window_SkillList[_0x1e17c6(0x97e)][_0x1e17c6(0x9fc)]['call'](this,_0x3417b7,_0xad317a,_0x56351a,_0x2d6294);},Window_ActorCommand[_0x251720(0x97e)]['hide']=function(){},Window_ActorCommand[_0x251720(0x97e)][_0x251720(0x77)]=function(){const _0x41a396=_0x251720;Window_Command[_0x41a396(0x97e)][_0x41a396(0x77)]['call'](this);const _0x38c30e=this['battleLayoutStyle']();_0x38c30e===_0x41a396(0x9bc)&&this[_0x41a396(0x663)]();},Window_ActorCommand['prototype'][_0x251720(0x5bf)]=function(){const _0x16c3eb=_0x251720;if(this[_0x16c3eb(0x923)])return this[_0x16c3eb(0x923)];return this[_0x16c3eb(0x923)]=SceneManager['_scene'][_0x16c3eb(0x5bf)](),this['_battleLayoutStyle'];},VisuMZ['BattleCore'][_0x251720(0xf0)]=Window_ActorCommand[_0x251720(0x97e)][_0x251720(0x1ea)],Window_ActorCommand[_0x251720(0x97e)][_0x251720(0x1ea)]=function(_0x387f48){const _0x4a15a6=_0x251720,_0x111fed=this['battleLayoutStyle']();if(_0x387f48&&['xp','portrait'][_0x4a15a6(0x9b0)](_0x111fed))this[_0x4a15a6(0x2c8)](_0x387f48);else _0x387f48&&[_0x4a15a6(0x9bc)][_0x4a15a6(0x9b0)](_0x111fed)&&(this[_0x4a15a6(0x7a6)](_0x387f48),this[_0x4a15a6(0x663)]());VisuMZ[_0x4a15a6(0x731)][_0x4a15a6(0xf0)][_0x4a15a6(0xa57)](this,_0x387f48),_0x387f48&&$gameTroop[_0x4a15a6(0x8ef)]()[_0x4a15a6(0x988)]>0x0&&_0x387f48[_0x4a15a6(0x60a)]()&&_0x387f48[_0x4a15a6(0x60a)]()['stepForward']();},Window_ActorCommand['prototype'][_0x251720(0x2c8)]=function(_0x1afe3d){const _0x3353ce=_0x251720,_0x5ce903=Math['round'](Graphics[_0x3353ce(0x13f)]/0x3),_0x11d018=Math[_0x3353ce(0x3e4)](Graphics[_0x3353ce(0x13f)]/$gameParty[_0x3353ce(0x5e2)]()[_0x3353ce(0x988)]),_0x51b28a=Math[_0x3353ce(0x1c4)](_0x5ce903,_0x11d018),_0x469b33=this[_0x3353ce(0x1d4)](VisuMZ[_0x3353ce(0x731)][_0x3353ce(0x825)][_0x3353ce(0x8ca)][_0x3353ce(0x383)]),_0xbbaf13=_0x11d018*_0x1afe3d[_0x3353ce(0x77c)]()+(_0x11d018-_0x51b28a)/0x2,_0x3b525e=SceneManager[_0x3353ce(0x35b)][_0x3353ce(0xa7b)]['y']-_0x469b33;this[_0x3353ce(0x1b9)](_0xbbaf13,_0x3b525e,_0x51b28a,_0x469b33),this[_0x3353ce(0x4d9)](),this[_0x3353ce(0x334)](0x1);},Window_ActorCommand['prototype'][_0x251720(0x7a6)]=function(_0x39c16c){const _0xb3e523=_0x251720,_0x9c829e=SceneManager[_0xb3e523(0x35b)][_0xb3e523(0x6cb)]();this['move'](_0x9c829e['x'],_0x9c829e['y'],_0x9c829e[_0xb3e523(0x139)],_0x9c829e[_0xb3e523(0x442)]),this['createContents'](),this['setBackgroundType'](0x0);},Window_ActorCommand[_0x251720(0x97e)]['refreshDimmerBitmap']=function(){const _0x19909a=_0x251720;if(this[_0x19909a(0x41d)]){if(_0x19909a(0x3f1)===_0x19909a(0x98b))this[_0x19909a(0x9d9)](0x1);else{const _0x17477f=this['_dimmerSprite'][_0x19909a(0x817)],_0x5c893d=this[_0x19909a(0x139)]-0x8,_0x47d9e5=this[_0x19909a(0x442)],_0x2d83da=this[_0x19909a(0x302)],_0x2ebe21=ColorManager[_0x19909a(0x878)](),_0x26edcb=ColorManager[_0x19909a(0x114)]();this['_dimmerSprite']['x']=0x4,_0x17477f[_0x19909a(0x9a3)](_0x5c893d,_0x47d9e5),_0x17477f[_0x19909a(0x1f3)](0x0,0x0,_0x5c893d,_0x2d83da,_0x26edcb,_0x2ebe21,!![]),_0x17477f[_0x19909a(0x774)](0x0,_0x2d83da,_0x5c893d,_0x47d9e5-_0x2d83da*0x2,_0x2ebe21),_0x17477f[_0x19909a(0x1f3)](0x0,_0x47d9e5-_0x2d83da,_0x5c893d,_0x2d83da,_0x2ebe21,_0x26edcb,!![]),this['_dimmerSprite'][_0x19909a(0x8c4)](0x0,0x0,_0x5c893d,_0x47d9e5);}}},Window_ActorCommand[_0x251720(0x97e)][_0x251720(0x28a)]=function(){const _0xfe9cf6=_0x251720;if(!this[_0xfe9cf6(0x81d)])return;const _0x252e7b=VisuMZ[_0xfe9cf6(0x731)][_0xfe9cf6(0x825)][_0xfe9cf6(0x9c7)],_0xf20b0=this['currentSymbol']();switch(_0xf20b0){case'attack':this[_0xfe9cf6(0x8a2)]($dataSkills[this[_0xfe9cf6(0x81d)][_0xfe9cf6(0x482)]()]);break;case _0xfe9cf6(0x474):this[_0xfe9cf6(0x8a2)]($dataSkills[this[_0xfe9cf6(0x81d)]['guardSkillId']()]);break;case _0xfe9cf6(0x6f7):const _0x1303c9=_0x252e7b[_0xfe9cf6(0xa49)],_0x24ff76=_0x1303c9['format']($dataSystem['skillTypes'][this[_0xfe9cf6(0x5ee)]()]);this[_0xfe9cf6(0xa96)][_0xfe9cf6(0xa5e)](_0x24ff76);break;case _0xfe9cf6(0x4eb):this[_0xfe9cf6(0x8a2)]($dataSkills[this[_0xfe9cf6(0x5ee)]()]);break;case _0xfe9cf6(0x342):this[_0xfe9cf6(0xa96)][_0xfe9cf6(0xa5e)](_0x252e7b['HelpItem']);break;case'escape':this[_0xfe9cf6(0xa96)][_0xfe9cf6(0xa5e)](_0x252e7b[_0xfe9cf6(0x2f8)]);break;case _0xfe9cf6(0x581):this['_helpWindow'][_0xfe9cf6(0xa5e)](_0x252e7b[